/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.io.File;
import java.nio.file.Path;
import java.util.List;
import java.util.function.UnaryOperator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.assertj.core.api.Assertions;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.Recipe;
import org.openrewrite.Result;
import org.openrewrite.SourceFile;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaRecipeTest;
import org.openrewrite.java.TypeValidator;
import org.openrewrite.java.UpdateSourcePositions;
import org.openrewrite.java.tree.J;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Range;

@Disabled
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\bg\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0014\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\n*\u00020\fH\u0002\u00a8\u0006\r"}, d2={"Lorg/openrewrite/java/UpdateSourcePositionsTest;", "Lorg/openrewrite/java/JavaRecipeTest;", "lamdaParameter", "", "jp", "Lorg/openrewrite/java/JavaParser;", "lineColumnTest", "updateSourcePositions", "updateSourcePositions2", "printWithLines", "", "kotlin.jvm.PlatformType", "Lorg/openrewrite/SourceFile;", "rewrite-java-tck"})
public interface UpdateSourcePositionsTest
extends JavaRecipeTest {
    @Test
    public void lamdaParameter(@NotNull JavaParser var1);

    @Test
    public void updateSourcePositions(@NotNull JavaParser var1);

    @Test
    public void updateSourcePositions2(@NotNull JavaParser var1);

    @Test
    public void lineColumnTest(@NotNull JavaParser var1);

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        private static String printWithLines(UpdateSourcePositionsTest $this, SourceFile $receiver) {
            return $receiver.printAll(new PrintOutputCapture((Object)0, new PrintOutputCapture.MarkerPrinter(){

                @NotNull
                public String beforePrefix(@NotNull Marker marker, @NotNull Cursor cursor, @NotNull UnaryOperator<String> commentWrapper) {
                    Intrinsics.checkNotNullParameter((Object)marker, (String)"marker");
                    Intrinsics.checkNotNullParameter((Object)cursor, (String)"cursor");
                    Intrinsics.checkNotNullParameter(commentWrapper, (String)"commentWrapper");
                    return marker instanceof Range ? "[(" + ((Range)marker).getStart().getLine() + ", " + ((Range)marker).getStart().getColumn() + "), (" + ((Range)marker).getEnd().getLine() + ", " + ((Range)marker).getEnd().getColumn() + ")]" : "";
                }
            }));
        }

        @Test
        public static void lamdaParameter(@NotNull UpdateSourcePositionsTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"package org.test;\n              \nimport java.util.function.Consumer;\n                \npublic class Application {\n\n    public Consumer<String> demo() {\n        return (args) -> {\n            log.info(\"\");\n        };\n    }\n\n}"};
            List cu = jp.parse(stringArray);
            SourceFile sourceFile = ((Result)new UpdateSourcePositions().run(cu).getResults().get(0)).getAfter();
            Intrinsics.checkNotNull((Object)sourceFile);
            SourceFile after = sourceFile;
            Assertions.assertThat((String)DefaultImpls.printWithLines($this, after)).isEqualTo("[(1, 0), (13, 2)][(1, 0), (1, 16)]package [(1, 8), (1, 16)][(1, 8), (1, 11)]org.[(1, 12), (1, 16)]test;\n              \n[(3, 1), (3, 35)]import [(3, 8), (3, 35)][(3, 8), (3, 26)][(3, 8), (3, 17)][(3, 8), (3, 12)]java.[(3, 13), (3, 17)]util.[(3, 18), (3, 26)]function.[(3, 27), (3, 35)]Consumer;\n                \n[(5, 1), (13, 2)][(5, 1), (5, 7)]public class [(5, 14), (5, 25)]Application [(5, 26), (13, 2)]{\n\n    [(7, 5), (11, 6)][(7, 5), (7, 11)]public [(7, 12), (7, 28)][(7, 12), (7, 20)]Consumer<[(7, 21), (7, 27)]String> [(7, 29), (7, 33)]demo([(7, 34), (7, 34)]) [(7, 36), (11, 6)]{\n        [(8, 9), (10, 10)]return [(8, 16), (10, 10)]([(8, 17), (8, 21)][(8, 17), (8, 21)][(8, 17), (8, 21)]args) -> [(8, 26), (10, 10)]{\n            [(9, 13), (9, 25)][(9, 13), (9, 16)]log.[(9, 17), (9, 21)]info([(9, 22), (9, 24)]\"\");\n        };\n    }\n\n}");
        }

        @Test
        public static void updateSourcePositions(@NotNull UpdateSourcePositionsTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"class Test {\n    int n;\n    \n    void test() {\n    }\n}"};
            List cu = jp.parse(stringArray);
            SourceFile sourceFile = ((Result)new UpdateSourcePositions().run(cu).getResults().get(0)).getAfter();
            Intrinsics.checkNotNull((Object)sourceFile);
            SourceFile after = sourceFile;
            Assertions.assertThat((String)DefaultImpls.printWithLines($this, after)).isEqualTo("[0,54][0,54]class [6,4]Test [11,43]{\n    [17,5][17,3]int [21,1][21,1]n;\n    \n    [33,19][33,4]void [38,4]test([43,0]) [45,7]{\n    }\n}");
            Assertions.assertThat((String)DefaultImpls.printWithLines($this, after)).isEqualTo("[(1, 0), (6, 2)][(1, 0), (6, 2)]class [(1, 6), (1, 10)]Test [(1, 11), (6, 2)]{\n    [(2, 5), (2, 10)][(2, 5), (2, 8)]int [(2, 9), (2, 10)][(2, 9), (2, 10)]n;\n    \n    [(4, 5), (5, 6)][(4, 5), (4, 9)]void [(4, 10), (4, 14)]test([(4, 15), (4, 15)]) [(4, 17), (5, 6)]{\n    }\n}");
        }

        @Test
        public static void updateSourcePositions2(@NotNull UpdateSourcePositionsTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String source = "package org.test;\n\nimport org.springframework.context.annotation.Bean;\nimport org.springframework.context.annotation.Scope;\n\n@Scope(value=)\npublic class TestScopeCompletion {\n\n    @Bean\n    @Scope(\"onMethod\")\n    public Object myBean() {\n        return null;\n    }\n}";
            String[] stringArray = new String[]{source};
            List cu = jp.parse(stringArray);
            SourceFile sourceFile = ((Result)new UpdateSourcePositions().run(cu).getResults().get(0)).getAfter();
            Intrinsics.checkNotNull((Object)sourceFile);
            SourceFile after = sourceFile;
            Assertions.assertThat((String)after.printAll()).isEqualTo(source);
            Assertions.assertThat((String)DefaultImpls.printWithLines($this, after)).isEqualTo("[0,266][0,16]package [8,8][8,3]org.[12,4]test;\n\n[19,50]import [26,43][26,38][26,27][26,19][26,3]org.[30,15]springframework.[46,7]context.[54,10]annotation.[65,4]Bean;\n[71,51]import [78,44][78,38][78,27][78,19][78,3]org.[82,15]springframework.[98,7]context.[106,10]annotation.[117,5]Scope;\n\n[125,141][125,14]@[126,5]Scope([132,6][132,5]value=)\n[140,6]public class [153,19]TestScopeCompletion [173,93]{\n\n    [180,84][180,5]@[181,4]Bean\n    [190,18]@[191,5]Scope([197,10]\"onMethod\")\n    [213,6]public [220,6]Object [227,6]myBean([234,0]) [236,28]{\n        [246,11]return [253,4]null;\n    }\n}");
            Assertions.assertThat((String)DefaultImpls.printWithLines($this, after)).isEqualTo("[(1, 0), (14, 2)][(1, 0), (1, 16)]package [(1, 8), (1, 16)][(1, 8), (1, 11)]org.[(1, 12), (1, 16)]test;\n\n[(3, 1), (3, 51)]import [(3, 8), (3, 51)][(3, 8), (3, 46)][(3, 8), (3, 35)][(3, 8), (3, 27)][(3, 8), (3, 11)]org.[(3, 12), (3, 27)]springframework.[(3, 28), (3, 35)]context.[(3, 36), (3, 46)]annotation.[(3, 47), (3, 51)]Bean;\n[(4, 1), (4, 52)]import [(4, 8), (4, 52)][(4, 8), (4, 46)][(4, 8), (4, 35)][(4, 8), (4, 27)][(4, 8), (4, 11)]org.[(4, 12), (4, 27)]springframework.[(4, 28), (4, 35)]context.[(4, 36), (4, 46)]annotation.[(4, 47), (4, 52)]Scope;\n\n[(6, 1), (14, 2)][(6, 1), (6, 15)]@[(6, 2), (6, 7)]Scope([(6, 8), (6, 14)][(6, 8), (6, 13)]value=)\n[(7, 1), (7, 7)]public class [(7, 14), (7, 33)]TestScopeCompletion [(7, 34), (14, 2)]{\n\n    [(9, 5), (13, 6)][(9, 5), (9, 10)]@[(9, 6), (9, 10)]Bean\n    [(10, 5), (10, 23)]@[(10, 6), (10, 11)]Scope([(10, 12), (10, 22)]\"onMethod\")\n    [(11, 5), (11, 11)]public [(11, 12), (11, 18)]Object [(11, 19), (11, 25)]myBean([(11, 26), (11, 26)]) [(11, 28), (13, 6)]{\n        [(12, 9), (12, 20)]return [(12, 16), (12, 20)]null;\n    }\n}");
        }

        @Test
        public static void lineColumnTest(@NotNull UpdateSourcePositionsTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String source = "package com.example;\n\nimport org.springframework.boot.SpringApplication;\nimport org.springframework.boot.autoconfigure.SpringBootApplication;\n\n@SpringBootApplication\npublic class EmptyBoot15WebAppApplication {\n\n    public static void main(String[] args) {\n        SpringApplication.run(EmptyBoot15WebAppApplication.class, args);\n    }\n}";
            String[] stringArray = new String[]{source};
            List cu = jp.parse(stringArray);
            SourceFile sourceFile = ((Result)new UpdateSourcePositions().run(cu).getResults().get(0)).getAfter();
            Intrinsics.checkNotNull((Object)sourceFile);
            SourceFile after = sourceFile;
            Assertions.assertThat((String)after.printAll()).isEqualTo(source);
            Assertions.assertThat((String)DefaultImpls.printWithLines($this, after)).isEqualTo("[(1, 0), (12, 2)][(1, 0), (1, 19)]package [(1, 8), (1, 19)][(1, 8), (1, 11)]com.[(1, 12), (1, 19)]example;\n\n[(3, 1), (3, 50)]import [(3, 8), (3, 50)][(3, 8), (3, 32)][(3, 8), (3, 27)][(3, 8), (3, 11)]org.[(3, 12), (3, 27)]springframework.[(3, 28), (3, 32)]boot.[(3, 33), (3, 50)]SpringApplication;\n[(4, 1), (4, 68)]import [(4, 8), (4, 68)][(4, 8), (4, 46)][(4, 8), (4, 32)][(4, 8), (4, 27)][(4, 8), (4, 11)]org.[(4, 12), (4, 27)]springframework.[(4, 28), (4, 32)]boot.[(4, 33), (4, 46)]autoconfigure.[(4, 47), (4, 68)]SpringBootApplication;\n\n[(6, 1), (12, 2)][(6, 1), (6, 23)]@[(6, 2), (6, 23)]SpringBootApplication\n[(7, 1), (7, 7)]public class [(7, 14), (7, 42)]EmptyBoot15WebAppApplication [(7, 43), (12, 2)]{\n\n    [(9, 5), (11, 6)][(9, 5), (9, 11)]public [(9, 12), (9, 18)]static [(9, 19), (9, 23)]void [(9, 24), (9, 28)]main([(9, 29), (9, 42)][(9, 29), (9, 35)]String[] [(9, 38), (9, 42)][(9, 38), (9, 42)]args) [(9, 44), (11, 6)]{\n        [(10, 9), (10, 72)][(10, 9), (10, 26)]SpringApplication.[(10, 27), (10, 30)]run([(10, 31), (10, 65)][(10, 31), (10, 59)]EmptyBoot15WebAppApplication.[(10, 60), (10, 65)]class, [(10, 67), (10, 71)]args);\n    }\n}");
        }

        @NotNull
        public static JavaParser getParser(@NotNull UpdateSourcePositionsTest $this) {
            return JavaRecipeTest.DefaultImpls.getParser($this);
        }

        @NotNull
        public static ExecutionContext getExecutionContext(@NotNull UpdateSourcePositionsTest $this) {
            return JavaRecipeTest.DefaultImpls.getExecutionContext($this);
        }

        @BeforeEach
        public static void beforeRecipe(@NotNull UpdateSourcePositionsTest $this) {
            JavaRecipeTest.DefaultImpls.beforeRecipe($this);
        }

        @AfterEach
        public static void afterRecipe(@NotNull UpdateSourcePositionsTest $this) {
            JavaRecipeTest.DefaultImpls.afterRecipe($this);
        }

        public static void assertChanged(@NotNull UpdateSourcePositionsTest $this, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super TypeValidator.ValidationOptions.Companion.Builder, Unit> typeValidation, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(typeValidation, (String)"typeValidation");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged($this, parser, recipe2, executionContext, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, typeValidation, afterConditions);
        }

        public static void assertChanged(@NotNull UpdateSourcePositionsTest $this, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull File before, @Nullable Path relativeTo, @Language(value="java") @NotNull File[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super TypeValidator.ValidationOptions.Companion.Builder, Unit> typeValidation, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(typeValidation, (String)"typeValidation");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged($this, parser, recipe2, executionContext, before, relativeTo, dependsOn, after, cycles, expectedCyclesThatMakeChanges, typeValidation, afterConditions);
        }

        public static void assertUnchanged(@NotNull UpdateSourcePositionsTest $this, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged($this, parser, recipe2, executionContext, before, dependsOn);
        }

        public static void assertUnchanged(@NotNull UpdateSourcePositionsTest $this, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull File before, @Nullable Path relativeTo, @Language(value="java") @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged($this, parser, recipe2, executionContext, before, relativeTo, dependsOn);
        }

        @Nullable
        public static Recipe getRecipe(@NotNull UpdateSourcePositionsTest $this) {
            return JavaRecipeTest.DefaultImpls.getRecipe($this);
        }

        public static void assertChangedBase(@NotNull UpdateSourcePositionsTest $this, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull File before, @Nullable Path relativeTo, @NotNull File[] dependsOn, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase($this, parser, recipe2, executionContext, before, relativeTo, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertChangedBase(@NotNull UpdateSourcePositionsTest $this, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull String before, @NotNull String[] dependsOn, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase($this, parser, recipe2, executionContext, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertUnchangedBase(@NotNull UpdateSourcePositionsTest $this, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull File before, @Nullable Path relativeTo, @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchangedBase($this, parser, recipe2, executionContext, before, relativeTo, dependsOn);
        }

        public static void assertUnchangedBase(@NotNull UpdateSourcePositionsTest $this, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull String before, @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchangedBase($this, parser, recipe2, executionContext, before, dependsOn);
        }

        @NotNull
        public static Recipe fromRuntimeClasspath(@NotNull UpdateSourcePositionsTest $this, @NotNull String recipe2) {
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            return JavaRecipeTest.DefaultImpls.fromRuntimeClasspath($this, recipe2);
        }

        @NotNull
        public static Recipe toRecipe(@NotNull UpdateSourcePositionsTest $this, @NotNull Function0<? extends TreeVisitor<?, ExecutionContext>> supplier) {
            Intrinsics.checkNotNullParameter(supplier, (String)"supplier");
            return JavaRecipeTest.DefaultImpls.toRecipe($this, supplier);
        }
    }
}

