/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.openrewrite.Parser;
import org.openrewrite.Recipe;
import org.openrewrite.java.Assertions;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.ReplaceConstant;
import org.openrewrite.test.RecipeSpec;
import org.openrewrite.test.RewriteTest;
import org.openrewrite.test.SourceSpecs;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0003H\u0017J\b\u0010\u0007\u001a\u00020\u0003H\u0017J\b\u0010\b\u001a\u00020\u0003H\u0017\u00a8\u0006\t"}, d2={"Lorg/openrewrite/java/ReplaceConstantTest;", "Lorg/openrewrite/test/RewriteTest;", "defaults", "", "spec", "Lorg/openrewrite/test/RecipeSpec;", "doesNotChangeOriginalVariableDeclaration", "replaceConstant", "replaceStaticallyImportedConstant", "rewrite-java-tck"})
public interface ReplaceConstantTest
extends RewriteTest {
    public void defaults(@NotNull RecipeSpec var1);

    @Test
    public void replaceConstant();

    @Test
    public void replaceStaticallyImportedConstant();

    @Test
    public void doesNotChangeOriginalVariableDeclaration();

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        public static void defaults(@NotNull ReplaceConstantTest $this, @NotNull RecipeSpec spec) {
            Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
            spec.recipe((Recipe)new ReplaceConstant("com.google.common.base.Charsets", "UTF_8", "\"UTF_8\""));
        }

        @Test
        public static void replaceConstant(@NotNull ReplaceConstantTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import com.google.common.base.Charsets;\n            class Test {\n                Object o = Charsets.UTF_8;\n            }\n            ", (String)"\n            class Test {\n                Object o = \"UTF_8\";\n            }\n            ")};
            $this.rewriteRun(DefaultImpls::replaceConstant$lambda$0, sourceSpecsArray);
        }

        @Test
        public static void replaceStaticallyImportedConstant(@NotNull ReplaceConstantTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import static com.google.common.base.Charsets.UTF_8;\n            class Test {\n                Object o = UTF_8;\n            }\n            ", (String)"\n            class Test {\n                Object o = \"UTF_8\";\n            }\n            ")};
            $this.rewriteRun(DefaultImpls::replaceStaticallyImportedConstant$lambda$1, sourceSpecsArray);
        }

        @Test
        public static void doesNotChangeOriginalVariableDeclaration(@NotNull ReplaceConstantTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            package com.constant;\n            public class B {\n                public static final String VAR = \"default\";\n                void method() {\n                    String VAR = \"\";\n                }\n            }\n        "), Assertions.java((String)"\n            package com.abc;\n            import com.constant.B;\n            class A {\n                String v = B.VAR;\n                private String method() {\n                    return B.VAR;\n                }\n            }\n            ", (String)"\n            package com.abc;\n            class A {\n                String v = \"newValue\";\n                private String method() {\n                    return \"newValue\";\n                }\n            }\n            ")};
            $this.rewriteRun(DefaultImpls::doesNotChangeOriginalVariableDeclaration$lambda$2, sourceSpecsArray);
        }

        private static void replaceConstant$lambda$0(RecipeSpec spec) {
            Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
            String[] stringArray = new String[]{"guava"};
            spec.parser((Parser.Builder)JavaParser.fromJavaVersion().classpath(stringArray));
        }

        private static void replaceStaticallyImportedConstant$lambda$1(RecipeSpec spec) {
            Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
            String[] stringArray = new String[]{"guava"};
            spec.parser((Parser.Builder)JavaParser.fromJavaVersion().classpath(stringArray));
        }

        private static void doesNotChangeOriginalVariableDeclaration$lambda$2(RecipeSpec spec) {
            Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
            spec.recipe((Recipe)new ReplaceConstant("com.constant.B", "VAR", "\"newValue\""));
        }
    }
}

