/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.assertj.core.api.Assertions;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.AssertionsKt;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTypeMappingTest;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\bf\u0018\u0000 \n2\u00020\u0001:\u0001\nJ\b\u0010\u0002\u001a\u00020\u0003H\u0017J\b\u0010\u0004\u001a\u00020\u0003H\u0017J\b\u0010\u0005\u001a\u00020\u0003H\u0017J\b\u0010\u0006\u001a\u00020\u0003H\u0017J\b\u0010\u0007\u001a\u00020\u0003H\u0017J\b\u0010\b\u001a\u00020\u0003H\u0017J\b\u0010\t\u001a\u00020\u0003H\u0017\u00a8\u0006\u000b"}, d2={"Lorg/openrewrite/java/JavaParserTypeMappingTest;", "Lorg/openrewrite/java/JavaTypeMappingTest;", "annotationParameterDefaults", "", "beforeRecipe", "methodInvocationOnUnknownType", "methodInvocationWithUnknownTypeSymbol", "multiMapWithSameLambdaParamNames", "parameterizedTypesAreDeeplyBasedOnBounds", "variousMethodScopeIdentifierTypes", "Companion", "rewrite-java-tck"})
public interface JavaParserTypeMappingTest
extends JavaTypeMappingTest {
    @NotNull
    public static final Companion Companion = org.openrewrite.java.JavaParserTypeMappingTest$Companion.$$INSTANCE;

    @BeforeEach
    public void beforeRecipe();

    @Test
    public void annotationParameterDefaults();

    @Test
    public void parameterizedTypesAreDeeplyBasedOnBounds();

    @Test
    public void methodInvocationWithUnknownTypeSymbol();

    @Test
    public void methodInvocationOnUnknownType();

    @Test
    public void variousMethodScopeIdentifierTypes();

    @Test
    public void multiMapWithSameLambdaParamNames();

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/openrewrite/java/JavaParserTypeMappingTest$Companion;", "", "()V", "parser", "Lorg/openrewrite/java/JavaParser;", "getParser", "()Lorg/openrewrite/java/JavaParser;", "rewrite-java-tck"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        @NotNull
        private static final JavaParser parser;

        private Companion() {
        }

        @NotNull
        public final JavaParser getParser() {
            return parser;
        }

        static {
            $$INSTANCE = new Companion();
            JavaParser javaParser = JavaParser.fromJavaVersion().logCompilationWarningsAndErrors(true).build();
            Intrinsics.checkNotNullExpressionValue((Object)javaParser, (String)"fromJavaVersion()\n      \u2026rue)\n            .build()");
            parser = javaParser;
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        @BeforeEach
        public static void beforeRecipe(@NotNull JavaParserTypeMappingTest $this) {
            Companion.getParser().reset();
        }

        /*
         * WARNING - void declaration
         */
        @Test
        public static void annotationParameterDefaults(@NotNull JavaParserTypeMappingTest $this) {
            void $this$mapTo$iv$iv;
            String source = "\n            @Deprecated\n            class Test {\n            }\n        ";
            String[] stringArray = new String[]{source};
            J.CompilationUnit cu = (J.CompilationUnit)Companion.getParser().parse(stringArray).get(0);
            JavaType.Class clazz = TypeUtils.asClass((JavaType)((J.Annotation)((J.ClassDeclaration)cu.getClasses().get(0)).getAllAnnotations().get(0)).getType());
            Intrinsics.checkNotNull((Object)clazz);
            JavaType.Class t = clazz;
            List list = t.getMethods();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"t.methods");
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                JavaType.Method method = (JavaType.Method)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getDefaultValue());
            }
            Assertions.assertThat((List)((List)destination$iv$iv)).allMatch(DefaultImpls::annotationParameterDefaults$lambda$1);
        }

        @Test
        public static void parameterizedTypesAreDeeplyBasedOnBounds(@NotNull JavaParserTypeMappingTest $this) {
            String[] stringArray = new String[]{"abstract class TypeA<T extends Number> extends java.util.ArrayList<T> {}", "class TypeB extends TypeA<Integer> {\n    // Attempt to force the JavaTypeCache to cache the wrong parameterized super type.\n    java.util.List<String> list = new java.util.ArrayList<>();\n}", "class TypeC<T extends String> extends java.util.ArrayList<T> {\n    // Attempt to force the JavaTypeCache to cache the wrong parameterized super type.\n    java.util.List<Object> list = new java.util.ArrayList<>();\n}"};
            String[] sources = stringArray;
            List cus = Companion.getParser().parse((ExecutionContext)new InMemoryExecutionContext(DefaultImpls::parameterizedTypesAreDeeplyBasedOnBounds$lambda$2), Arrays.copyOf(sources, sources.length));
            JavaType.FullyQualified fullyQualified = ((J.ClassDeclaration)((J.CompilationUnit)cus.get(0)).getClasses().get(0)).getType();
            Intrinsics.checkNotNull((Object)fullyQualified, (String)"null cannot be cast to non-null type org.openrewrite.java.tree.JavaType.Parameterized");
            JavaType.Parameterized typeA = (JavaType.Parameterized)fullyQualified;
            Object e = typeA.getTypeParameters().get(0);
            Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type org.openrewrite.java.tree.JavaType.GenericTypeVariable");
            Assertions.assertThat((String)((JavaType.GenericTypeVariable)e).toString()).isEqualTo("Generic{T extends java.lang.Number}");
            JavaType.FullyQualified fullyQualified2 = typeA.getSupertype();
            Intrinsics.checkNotNull((Object)fullyQualified2, (String)"null cannot be cast to non-null type org.openrewrite.java.tree.JavaType.Parameterized");
            JavaType.Parameterized typeASuperType = (JavaType.Parameterized)fullyQualified2;
            Assertions.assertThat((String)typeASuperType.toString()).isEqualTo("java.util.ArrayList<Generic{T extends java.lang.Number}>");
            JavaType.FullyQualified fullyQualified3 = typeASuperType.getType();
            Intrinsics.checkNotNull((Object)fullyQualified3, (String)"null cannot be cast to non-null type org.openrewrite.java.tree.JavaType.Class");
            Assertions.assertThat((String)((JavaType.Class)fullyQualified3).getTypeParameters().get(0).toString()).isEqualTo("Generic{E}");
            JavaType.FullyQualified fullyQualified4 = ((J.ClassDeclaration)((J.CompilationUnit)cus.get(1)).getClasses().get(0)).getType();
            Intrinsics.checkNotNull((Object)fullyQualified4, (String)"null cannot be cast to non-null type org.openrewrite.java.tree.JavaType.Class");
            JavaType.Class typeB = (JavaType.Class)fullyQualified4;
            JavaType.FullyQualified fullyQualified5 = typeB.getSupertype();
            Intrinsics.checkNotNull((Object)fullyQualified5);
            Assertions.assertThat((String)fullyQualified5.toString()).isEqualTo("TypeA<java.lang.Integer>");
            JavaType.FullyQualified fullyQualified6 = typeB.getSupertype();
            Intrinsics.checkNotNull((Object)fullyQualified6, (String)"null cannot be cast to non-null type org.openrewrite.java.tree.JavaType.Parameterized");
            JavaType.Parameterized typeBSuperType = (JavaType.Parameterized)fullyQualified6;
            JavaType.FullyQualified fullyQualified7 = typeBSuperType.getType();
            Intrinsics.checkNotNull((Object)fullyQualified7, (String)"null cannot be cast to non-null type org.openrewrite.java.tree.JavaType.Class");
            Assertions.assertThat((String)((JavaType.Class)fullyQualified7).getTypeParameters().get(0).toString()).isEqualTo("Generic{T extends java.lang.Number}");
            JavaType.FullyQualified fullyQualified8 = ((J.ClassDeclaration)((J.CompilationUnit)cus.get(2)).getClasses().get(0)).getType();
            Intrinsics.checkNotNull((Object)fullyQualified8, (String)"null cannot be cast to non-null type org.openrewrite.java.tree.JavaType.Parameterized");
            JavaType.Parameterized typeC = (JavaType.Parameterized)fullyQualified8;
            Object e2 = typeC.getTypeParameters().get(0);
            Intrinsics.checkNotNull(e2, (String)"null cannot be cast to non-null type org.openrewrite.java.tree.JavaType.GenericTypeVariable");
            Assertions.assertThat((String)((JavaType.GenericTypeVariable)e2).toString()).isEqualTo("Generic{T extends java.lang.String}");
            JavaType.FullyQualified fullyQualified9 = typeC.getSupertype();
            Intrinsics.checkNotNull((Object)fullyQualified9, (String)"null cannot be cast to non-null type org.openrewrite.java.tree.JavaType.Parameterized");
            JavaType.Parameterized typeCSuperType = (JavaType.Parameterized)fullyQualified9;
            Assertions.assertThat((String)typeCSuperType.toString()).isEqualTo("java.util.ArrayList<Generic{T extends java.lang.String}>");
            JavaType.FullyQualified fullyQualified10 = typeCSuperType.getType();
            Intrinsics.checkNotNull((Object)fullyQualified10, (String)"null cannot be cast to non-null type org.openrewrite.java.tree.JavaType.Class");
            Assertions.assertThat((String)((JavaType.Class)fullyQualified10).getTypeParameters().get(0).toString()).isEqualTo("Generic{E}");
        }

        @Test
        public static void methodInvocationWithUnknownTypeSymbol(@NotNull JavaParserTypeMappingTest $this) {
            String source = "import java.util.ArrayList;\nimport java.util.List;\nimport java.util.stream.Collectors;\n\nclass Test {\n    class Parent {\n    }\n    class Child extends Parent {\n    }\n\n    List<Parent> method(List<Parent> values) {\n        return values.stream()\n                .map(o -> {\n                    if (o instanceof Child) {\n                        return new UnknownType(((Child) o).toString());\n                    }\n                    return o;\n                })\n                .collect(Collectors.toList());\n    }\n}";
            String[] stringArray = new String[]{source};
            List cu = Companion.getParser().parse((ExecutionContext)new InMemoryExecutionContext(DefaultImpls::methodInvocationWithUnknownTypeSymbol$lambda$3), stringArray);
            Assertions.assertThat((List)cu).isNotNull();
        }

        @Test
        public static void methodInvocationOnUnknownType(@NotNull JavaParserTypeMappingTest $this) {
            String source = "import java.util.ArrayList;\n// do not import List to create an UnknownType\n\nclass Test {\n    class Base {\n        private int foo;\n        public boolean setFoo(int foo) {\n            this.foo = foo;\n        }\n        public int getFoo() {\n            return foo;\n        }\n    }\n    List<Base> createUnknownType(List<Integer> values) {\n        List<Base> bases = new ArrayList<>();\n        values.forEach((v) -> {\n            Base b = new Base();\n            b.setFoo(v);\n            bases.add(b);\n        });\n        return bases;\n    }\n}";
            String[] stringArray = new String[]{source};
            List cu = Companion.getParser().parse((ExecutionContext)new InMemoryExecutionContext(DefaultImpls::methodInvocationOnUnknownType$lambda$4), stringArray);
            Assertions.assertThat((List)cu).isNotNull();
        }

        @Test
        public static void variousMethodScopeIdentifierTypes(@NotNull JavaParserTypeMappingTest $this) {
            String source = "import java.util.List;\nimport java.util.stream.Collectors;\n\n@SuppressWarnings(\"ALL\")\nclass MakeEasyToFind {\n    void method(List<MultiMap> multiMaps) {\n        List<Integer> ints;\n        ints.forEach(it -> {\n            if (it != null) {\n            }\n        });\n\n        multiMaps.forEach(it -> {\n            if (it != null) {\n            }\n        });\n\n        while (true) {\n            if (multiMaps.isEmpty()) {\n                Long it;\n                break;\n            }\n        }\n    }\n\n    static class MultiMap {\n        List<Inner> inners;\n        public List<Inner> getInners() {\n            return inners;\n        }\n\n        static class Inner {\n            List<Number> numbers;\n            public List<Number> getNumbers() {\n                return numbers;\n            }\n        }\n    }\n}";
            String[] stringArray = new String[]{source};
            Object e = Companion.getParser().parse((ExecutionContext)new InMemoryExecutionContext(DefaultImpls::variousMethodScopeIdentifierTypes$lambda$5), stringArray).get(0);
            Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type org.openrewrite.java.tree.J.CompilationUnit");
            Object e2 = ((J.CompilationUnit)e).getClasses().get(0);
            Intrinsics.checkNotNull(e2, (String)"null cannot be cast to non-null type org.openrewrite.java.tree.J.ClassDeclaration");
            Object e3 = ((J.ClassDeclaration)e2).getBody().getStatements().get(0);
            Intrinsics.checkNotNull(e3, (String)"null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            J.Block block2 = ((J.MethodDeclaration)e3).getBody();
            Intrinsics.checkNotNull((Object)block2);
            J.Block methodBody = block2;
            Object object = methodBody.getStatements().get(1);
            Intrinsics.checkNotNull(object, (String)"null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodInvocation");
            Object object2 = ((J.MethodInvocation)object).getArguments().get(0);
            Intrinsics.checkNotNull(object2, (String)"null cannot be cast to non-null type org.openrewrite.java.tree.J.Lambda");
            Object object3 = ((J.Lambda)object2).getBody();
            Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type org.openrewrite.java.tree.J.Block");
            Object object4 = ((J.Block)object3).getStatements().get(0);
            Intrinsics.checkNotNull(object4, (String)"null cannot be cast to non-null type org.openrewrite.java.tree.J.If");
            Object object5 = ((J.If)object4).getIfCondition();
            Intrinsics.checkNotNull((Object)object5, (String)"null cannot be cast to non-null type org.openrewrite.java.tree.J.ControlParentheses<@[FlexibleNullability] org.openrewrite.java.tree.Expression?>");
            stringArray = object5.getTree();
            Intrinsics.checkNotNull((Object)stringArray, (String)"null cannot be cast to non-null type org.openrewrite.java.tree.J.Binary");
            Expression expression = ((J.Binary)stringArray).getLeft();
            Intrinsics.checkNotNull((Object)expression, (String)"null cannot be cast to non-null type org.openrewrite.java.tree.J.Identifier");
            JavaType.Variable variable = ((J.Identifier)expression).getFieldType();
            Intrinsics.checkNotNull((Object)variable, (String)"null cannot be cast to non-null type org.openrewrite.java.tree.JavaType.Variable");
            JavaType intsItType = variable.getType();
            Assertions.assertThat((String)intsItType.toString()).isEqualTo("java.lang.Integer");
            Object e4 = methodBody.getStatements().get(2);
            Intrinsics.checkNotNull(e4, (String)"null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodInvocation");
            object = ((J.MethodInvocation)e4).getArguments().get(0);
            Intrinsics.checkNotNull(object, (String)"null cannot be cast to non-null type org.openrewrite.java.tree.J.Lambda");
            object2 = ((J.Lambda)object).getBody();
            Intrinsics.checkNotNull(object2, (String)"null cannot be cast to non-null type org.openrewrite.java.tree.J.Block");
            object3 = ((J.Block)object2).getStatements().get(0);
            Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type org.openrewrite.java.tree.J.If");
            object4 = ((J.If)object3).getIfCondition();
            Intrinsics.checkNotNull(object4, (String)"null cannot be cast to non-null type org.openrewrite.java.tree.J.ControlParentheses<@[FlexibleNullability] org.openrewrite.java.tree.Expression?>");
            object5 = object4.getTree();
            Intrinsics.checkNotNull((Object)object5, (String)"null cannot be cast to non-null type org.openrewrite.java.tree.J.Binary");
            stringArray = ((J.Binary)object5).getLeft();
            Intrinsics.checkNotNull((Object)stringArray, (String)"null cannot be cast to non-null type org.openrewrite.java.tree.J.Identifier");
            expression = ((J.Identifier)stringArray).getFieldType();
            Intrinsics.checkNotNull((Object)expression, (String)"null cannot be cast to non-null type org.openrewrite.java.tree.JavaType.Variable");
            JavaType multiMapItType = expression.getType();
            Assertions.assertThat((String)multiMapItType.toString()).isEqualTo("MakeEasyToFind$MultiMap");
            e4 = methodBody.getStatements().get(3);
            Intrinsics.checkNotNull(e4, (String)"null cannot be cast to non-null type org.openrewrite.java.tree.J.WhileLoop");
            object = ((J.WhileLoop)e4).getBody();
            Intrinsics.checkNotNull(object, (String)"null cannot be cast to non-null type org.openrewrite.java.tree.J.Block");
            object2 = ((J.Block)object).getStatements().get(0);
            Intrinsics.checkNotNull(object2, (String)"null cannot be cast to non-null type org.openrewrite.java.tree.J.If");
            object3 = ((J.If)object2).getThenPart();
            Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type org.openrewrite.java.tree.J.Block");
            object4 = ((J.Block)object3).getStatements().get(0);
            Intrinsics.checkNotNull(object4, (String)"null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDeclarations");
            object5 = ((J.VariableDeclarations)object4).getVariables().get(0);
            Intrinsics.checkNotNull((Object)object5, (String)"null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDeclarations.NamedVariable");
            stringArray = ((J.VariableDeclarations.NamedVariable)object5).getName();
            Intrinsics.checkNotNull((Object)stringArray, (String)"null cannot be cast to non-null type org.openrewrite.java.tree.J.Identifier");
            JavaType javaType = stringArray.getType();
            Intrinsics.checkNotNull((Object)javaType);
            JavaType whileLoopItType = javaType;
            Assertions.assertThat((String)whileLoopItType.toString()).isEqualTo("java.lang.Long");
        }

        @Test
        public static void multiMapWithSameLambdaParamNames(@NotNull JavaParserTypeMappingTest $this) {
            String source = "import java.util.List;\nimport java.util.stream.Collectors;\n\n@SuppressWarnings(\"ALL\")\nclass MakeEasyToFind {\n    void method(List<MultiMap> multiMaps) {\n        Object obj = multiMaps.stream()\n            .map(it -> it.getInners())\n            .map(it -> it.stream().map(i -> i.getNumbers()))\n            .collect(Collectors.toList());\n    }\n\n    static class MultiMap {\n        List<Inner> inners;\n        public List<Inner> getInners() {\n            return inners;\n        }\n\n        static class Inner {\n            List<Number> numbers;\n            public List<Number> getNumbers() {\n                return numbers;\n            }\n        }\n    }\n}";
            String[] stringArray = new String[]{source};
            Object e = Companion.getParser().parse((ExecutionContext)new InMemoryExecutionContext(DefaultImpls::multiMapWithSameLambdaParamNames$lambda$6), stringArray).get(0);
            Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type org.openrewrite.java.tree.J.CompilationUnit");
            Object e2 = ((J.CompilationUnit)e).getClasses().get(0);
            Intrinsics.checkNotNull(e2, (String)"null cannot be cast to non-null type org.openrewrite.java.tree.J.ClassDeclaration");
            Object e3 = ((J.ClassDeclaration)e2).getBody().getStatements().get(0);
            Intrinsics.checkNotNull(e3, (String)"null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            J.Block block2 = ((J.MethodDeclaration)e3).getBody();
            Intrinsics.checkNotNull((Object)block2);
            J.Block methodBody = block2;
            Object e4 = methodBody.getStatements().get(0);
            Intrinsics.checkNotNull(e4, (String)"null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDeclarations");
            stringArray = ((J.VariableDeclarations)e4).getVariables().get(0);
            Intrinsics.checkNotNull((Object)stringArray, (String)"null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDeclarations.NamedVariable");
            Expression expression = ((J.VariableDeclarations.NamedVariable)stringArray).getInitializer();
            Intrinsics.checkNotNull((Object)expression, (String)"null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodInvocation");
            Expression expression2 = ((J.MethodInvocation)expression).getSelect();
            Intrinsics.checkNotNull((Object)expression2, (String)"null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodInvocation");
            J.MethodInvocation multiLambda = (J.MethodInvocation)expression2;
            Object object = multiLambda.getSelect();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodInvocation");
            Object e5 = ((J.MethodInvocation)object).getArguments().get(0);
            Intrinsics.checkNotNull(e5, (String)"null cannot be cast to non-null type org.openrewrite.java.tree.J.Lambda");
            Object e6 = ((J.Lambda)e5).getParameters().getParameters().get(0);
            Intrinsics.checkNotNull(e6, (String)"null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDeclarations");
            Object e7 = ((J.VariableDeclarations)e6).getVariables().get(0);
            Intrinsics.checkNotNull(e7, (String)"null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDeclarations.NamedVariable");
            expression = ((J.VariableDeclarations.NamedVariable)e7).getName();
            Intrinsics.checkNotNull((Object)expression, (String)"null cannot be cast to non-null type org.openrewrite.java.tree.J.Identifier");
            JavaType javaType = expression.getType();
            Intrinsics.checkNotNull((Object)javaType);
            JavaType firstMultiMapLambdaParamItType = javaType;
            Assertions.assertThat((String)firstMultiMapLambdaParamItType.toString()).isEqualTo("MakeEasyToFind$MultiMap");
            object = multiLambda.getArguments().get(0);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.openrewrite.java.tree.J.Lambda");
            Object e8 = ((J.Lambda)object).getParameters().getParameters().get(0);
            Intrinsics.checkNotNull(e8, (String)"null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDeclarations");
            e4 = ((J.VariableDeclarations)e8).getVariables().get(0);
            Intrinsics.checkNotNull(e4, (String)"null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDeclarations.NamedVariable");
            stringArray = ((J.VariableDeclarations.NamedVariable)e4).getName();
            Intrinsics.checkNotNull((Object)stringArray, (String)"null cannot be cast to non-null type org.openrewrite.java.tree.J.Identifier");
            JavaType javaType2 = stringArray.getType();
            Intrinsics.checkNotNull((Object)javaType2);
            JavaType secondMultiMapLambdaParamItType = javaType2;
            Assertions.assertThat((String)secondMultiMapLambdaParamItType.toString()).isEqualTo("java.util.List<MakeEasyToFind$MultiMap$Inner>");
        }

        private static boolean annotationParameterDefaults$lambda$1(Object it) {
            return it != null;
        }

        private static void parameterizedTypesAreDeeplyBasedOnBounds$lambda$2(Throwable t) {
            AssertionsKt.fail((Throwable)t);
            throw new KotlinNothingValueException();
        }

        private static void methodInvocationWithUnknownTypeSymbol$lambda$3(Throwable t) {
            AssertionsKt.fail((Throwable)t);
            throw new KotlinNothingValueException();
        }

        private static void methodInvocationOnUnknownType$lambda$4(Throwable t) {
            AssertionsKt.fail((Throwable)t);
            throw new KotlinNothingValueException();
        }

        private static void variousMethodScopeIdentifierTypes$lambda$5(Throwable t) {
            AssertionsKt.fail((Throwable)t);
            throw new KotlinNothingValueException();
        }

        private static void multiMapWithSameLambdaParamNames$lambda$6(Throwable t) {
            AssertionsKt.fail((Throwable)t);
            throw new KotlinNothingValueException();
        }
    }
}

