/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.List;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.openrewrite.java.Assertions;
import org.openrewrite.java.tree.J;
import org.openrewrite.test.RewriteTest;
import org.openrewrite.test.SourceSpec;
import org.openrewrite.test.SourceSpecs;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H\u0017J\b\u0010\u0004\u001a\u00020\u0003H\u0017J\b\u0010\u0005\u001a\u00020\u0003H\u0017\u00a8\u0006\u0006"}, d2={"Lorg/openrewrite/java/JavaParserTest;", "Lorg/openrewrite/test/RewriteTest;", "annotationCommentWithNoSpaceParsesCorrectly", "", "annotationCommentWithSpaceParsesCorrectly", "incompleteAssignment", "rewrite-java-tck"})
public interface JavaParserTest
extends RewriteTest {
    @Test
    public void incompleteAssignment();

    @Test
    public void annotationCommentWithNoSpaceParsesCorrectly();

    @Test
    public void annotationCommentWithSpaceParsesCorrectly();

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        @Test
        public static void incompleteAssignment(@NotNull JavaParserTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n               @Deprecated(since=)\n               public class A {}\n            ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void annotationCommentWithNoSpaceParsesCorrectly(@NotNull JavaParserTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n                @SuppressWarnings(\"serial\")// fred\n                @Deprecated\n                public class PersistenceManagerImpl {\n                }\n            ", DefaultImpls::annotationCommentWithNoSpaceParsesCorrectly$lambda$1)};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void annotationCommentWithSpaceParsesCorrectly(@NotNull JavaParserTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n                @SuppressWarnings(\"serial\") // fred\n                @Deprecated\n                public class PersistenceManagerImpl {\n                }\n            ", DefaultImpls::annotationCommentWithSpaceParsesCorrectly$lambda$3)};
            $this.rewriteRun(sourceSpecsArray);
        }

        private static void annotationCommentWithNoSpaceParsesCorrectly$lambda$1$lambda$0(J.CompilationUnit cu) {
            org.assertj.core.api.Assertions.assertThat((List)((J.ClassDeclaration)cu.getClasses().get(0)).getLeadingAnnotations()).hasSize(2);
        }

        private static void annotationCommentWithNoSpaceParsesCorrectly$lambda$1(SourceSpec spec) {
            spec.afterRecipe(DefaultImpls::annotationCommentWithNoSpaceParsesCorrectly$lambda$1$lambda$0);
        }

        private static void annotationCommentWithSpaceParsesCorrectly$lambda$3$lambda$2(J.CompilationUnit cu) {
            org.assertj.core.api.Assertions.assertThat((List)((J.ClassDeclaration)cu.getClasses().get(0)).getLeadingAnnotations()).hasSize(2);
        }

        private static void annotationCommentWithSpaceParsesCorrectly$lambda$3(SourceSpec spec) {
            spec.afterRecipe(DefaultImpls::annotationCommentWithSpaceParsesCorrectly$lambda$3$lambda$2);
        }
    }
}

