/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.io.File;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.Assertions;
import org.openrewrite.java.ChangeMethodAccessLevel;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaRecipeTest;
import org.openrewrite.java.TypeValidator;
import org.openrewrite.java.tree.J;
import org.openrewrite.test.RecipeSpec;
import org.openrewrite.test.RewriteTest;
import org.openrewrite.test.SourceSpecs;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\bf\u0018\u00002\u00020\u00012\u00020\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0017J\b\u0010\u0005\u001a\u00020\u0004H\u0017J\b\u0010\u0006\u001a\u00020\u0004H\u0017J\b\u0010\u0007\u001a\u00020\u0004H\u0017J\b\u0010\b\u001a\u00020\u0004H\u0017J\b\u0010\t\u001a\u00020\u0004H\u0017J\b\u0010\n\u001a\u00020\u0004H\u0017J\b\u0010\u000b\u001a\u00020\u0004H\u0017J\b\u0010\f\u001a\u00020\u0004H\u0017\u00a8\u0006\r"}, d2={"Lorg/openrewrite/java/ChangeMethodAccessLevelTest;", "Lorg/openrewrite/test/RewriteTest;", "Lorg/openrewrite/java/JavaRecipeTest;", "doNotChangeExistingAccessLevel", "", "matchOverrides", "methodPatternExactMatch", "packagePrivateToProtected", "packagePrivateToProtectedWithConstructor", "packagePrivateToProtectedWithOtherModifier", "publicToPackagePrivate", "publicToPackagePrivateWildcard", "publicToPrivate", "rewrite-java-tck"})
public interface ChangeMethodAccessLevelTest
extends RewriteTest,
JavaRecipeTest {
    @Test
    public void publicToPrivate();

    @Test
    public void packagePrivateToProtected();

    @Test
    public void publicToPackagePrivate();

    @Test
    public void publicToPackagePrivateWildcard();

    @Test
    public void doNotChangeExistingAccessLevel();

    @Test
    public void packagePrivateToProtectedWithOtherModifier();

    @Test
    public void packagePrivateToProtectedWithConstructor();

    @Test
    public void methodPatternExactMatch();

    @Test
    public void matchOverrides();

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        @Test
        public static void publicToPrivate(@NotNull ChangeMethodAccessLevelTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            package com.abc;\n\n            class A {\n                @SuppressWarnings(\"ALL\") // comment\n                public void aMethod(String s) {\n                }\n\n                // comment\n                @SuppressWarnings(\"ALL\")\n                public void aMethod() {\n                }\n\n                // comment\n                public void aMethod(Integer i) {\n                }\n\n                public void aMethod(Double i) {\n                }\n            }\n        ", (String)"\n            package com.abc;\n\n            class A {\n                @SuppressWarnings(\"ALL\") // comment\n                private void aMethod(String s) {\n                }\n\n                // comment\n                @SuppressWarnings(\"ALL\")\n                private void aMethod() {\n                }\n\n                // comment\n                private void aMethod(Integer i) {\n                }\n\n                private void aMethod(Double i) {\n                }\n            }\n        ")};
            $this.rewriteRun(DefaultImpls::publicToPrivate$lambda$0, sourceSpecsArray);
        }

        @Test
        public static void packagePrivateToProtected(@NotNull ChangeMethodAccessLevelTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            package com.abc;\n\n            class A {\n                @SuppressWarnings(\"ALL\") // comment\n                static void aMethod(String s) {\n                }\n\n                // comment\n                @SuppressWarnings(\"ALL\")\n                void aMethod() {\n                }\n\n                // comment\n                void aMethod(Integer i) {\n                }\n\n                void aMethod(Double i) {\n                }\n            }\n        ", (String)"\n            package com.abc;\n\n            class A {\n                @SuppressWarnings(\"ALL\") // comment\n                protected static void aMethod(String s) {\n                }\n\n                // comment\n                @SuppressWarnings(\"ALL\")\n                protected void aMethod() {\n                }\n\n                // comment\n                protected void aMethod(Integer i) {\n                }\n\n                protected void aMethod(Double i) {\n                }\n            }\n        ")};
            $this.rewriteRun(DefaultImpls::packagePrivateToProtected$lambda$1, sourceSpecsArray);
        }

        @Test
        public static void publicToPackagePrivate(@NotNull ChangeMethodAccessLevelTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            package com.abc;\n\n            class A {\n                @SuppressWarnings(\"ALL\") // comment\n                public void aMethod(String s) {\n                }\n\n                // comment\n                @SuppressWarnings(\"ALL\")\n                public void aMethod() {\n                }\n\n                // comment\n                public void aMethod(Integer i) {\n                }\n\n                public void aMethod(Double i) {\n                }\n            }\n        ", (String)"\n            package com.abc;\n\n            class A {\n                // comment\n                @SuppressWarnings(\"ALL\")\n                void aMethod(String s) {\n                }\n\n                // comment\n                @SuppressWarnings(\"ALL\")\n                void aMethod() {\n                }\n\n                // comment\n                void aMethod(Integer i) {\n                }\n\n                void aMethod(Double i) {\n                }\n            }\n        ")};
            $this.rewriteRun(DefaultImpls::publicToPackagePrivate$lambda$2, sourceSpecsArray);
        }

        @Test
        public static void publicToPackagePrivateWildcard(@NotNull ChangeMethodAccessLevelTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            package com.abc;\n\n            class A {\n                // comment\n                public A(Integer i) {\n                }\n\n                @Deprecated // comment\n                public A(Float f) {\n                }\n\n                @Deprecated // comment\n                public void aMethod(String s) {\n                }\n\n                // comment\n                public void aMethod(Integer i) {\n                }\n            }\n        ", (String)"\n            package com.abc;\n\n            class A {\n                // comment\n                A(Integer i) {\n                }\n\n                // comment\n                @Deprecated\n                A(Float f) {\n                }\n\n                // comment\n                @Deprecated\n                void aMethod(String s) {\n                }\n\n                // comment\n                void aMethod(Integer i) {\n                }\n            }\n        ")};
            $this.rewriteRun(DefaultImpls::publicToPackagePrivateWildcard$lambda$3, sourceSpecsArray);
        }

        @Test
        public static void doNotChangeExistingAccessLevel(@NotNull ChangeMethodAccessLevelTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            package com.abc;\n\n            class A {\n                // comment\n                public void aMethod(String s) {\n                }\n            }\n        ")};
            $this.rewriteRun(DefaultImpls::doNotChangeExistingAccessLevel$lambda$4, sourceSpecsArray);
        }

        @Test
        public static void packagePrivateToProtectedWithOtherModifier(@NotNull ChangeMethodAccessLevelTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            package com.abc;\n\n            class A {\n                // comment\n                @Deprecated\n                static void aMethod(Double d) {\n                }\n            }\n        ", (String)"\n            package com.abc;\n\n            class A {\n                // comment\n                @Deprecated\n                protected static void aMethod(Double d) {\n                }\n            }\n        ")};
            $this.rewriteRun(DefaultImpls::packagePrivateToProtectedWithOtherModifier$lambda$5, sourceSpecsArray);
        }

        @Test
        public static void packagePrivateToProtectedWithConstructor(@NotNull ChangeMethodAccessLevelTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            package com.abc;\n\n            class A {\n                A(Integer i) {\n                }\n\n                // comment\n                A() {\n                }\n            }\n        ", (String)"\n            package com.abc;\n\n            class A {\n                protected A(Integer i) {\n                }\n\n                // comment\n                protected A() {\n                }\n            }\n        ")};
            $this.rewriteRun(DefaultImpls::packagePrivateToProtectedWithConstructor$lambda$6, sourceSpecsArray);
        }

        @Test
        public static void methodPatternExactMatch(@NotNull ChangeMethodAccessLevelTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            package com.abc;\n\n            class A {\n                public String aMethod() {\n                    return \"example_A\";\n                }\n            }\n\n            class B extends A {\n                @Override\n                public String aMethod() {\n                    return \"example_B\";\n                }\n            }\n        ", (String)"\n            package com.abc;\n\n            class A {\n                protected String aMethod() {\n                    return \"example_A\";\n                }\n            }\n\n            class B extends A {\n                @Override\n                public String aMethod() {\n                    return \"example_B\";\n                }\n            }\n        ")};
            $this.rewriteRun(DefaultImpls::methodPatternExactMatch$lambda$7, sourceSpecsArray);
        }

        @Test
        public static void matchOverrides(@NotNull ChangeMethodAccessLevelTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            package com.abc;\n\n            class A {\n                public String aMethod() {\n                    return \"example_A\";\n                }\n            }\n\n            class B extends A {\n                @Override\n                public String aMethod() {\n                    return \"example_B\";\n                }\n            }\n        ", (String)"\n            package com.abc;\n\n            class A {\n                protected String aMethod() {\n                    return \"example_A\";\n                }\n            }\n\n            class B extends A {\n                @Override\n                protected String aMethod() {\n                    return \"example_B\";\n                }\n            }\n        ")};
            $this.rewriteRun(DefaultImpls::matchOverrides$lambda$8, sourceSpecsArray);
        }

        @NotNull
        public static JavaParser getParser(@NotNull ChangeMethodAccessLevelTest $this) {
            return JavaRecipeTest.DefaultImpls.getParser($this);
        }

        @NotNull
        public static ExecutionContext getExecutionContext(@NotNull ChangeMethodAccessLevelTest $this) {
            return JavaRecipeTest.DefaultImpls.getExecutionContext($this);
        }

        @BeforeEach
        public static void beforeRecipe(@NotNull ChangeMethodAccessLevelTest $this) {
            JavaRecipeTest.DefaultImpls.beforeRecipe($this);
        }

        @AfterEach
        public static void afterRecipe(@NotNull ChangeMethodAccessLevelTest $this) {
            JavaRecipeTest.DefaultImpls.afterRecipe($this);
        }

        public static void assertChanged(@NotNull ChangeMethodAccessLevelTest $this, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super TypeValidator.ValidationOptions.Companion.Builder, Unit> typeValidation, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(typeValidation, (String)"typeValidation");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged($this, parser, recipe2, executionContext, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, typeValidation, afterConditions);
        }

        public static void assertChanged(@NotNull ChangeMethodAccessLevelTest $this, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull File before, @Nullable Path relativeTo, @Language(value="java") @NotNull File[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super TypeValidator.ValidationOptions.Companion.Builder, Unit> typeValidation, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(typeValidation, (String)"typeValidation");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged($this, parser, recipe2, executionContext, before, relativeTo, dependsOn, after, cycles, expectedCyclesThatMakeChanges, typeValidation, afterConditions);
        }

        public static void assertUnchanged(@NotNull ChangeMethodAccessLevelTest $this, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged($this, parser, recipe2, executionContext, before, dependsOn);
        }

        public static void assertUnchanged(@NotNull ChangeMethodAccessLevelTest $this, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull File before, @Nullable Path relativeTo, @Language(value="java") @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged($this, parser, recipe2, executionContext, before, relativeTo, dependsOn);
        }

        @Nullable
        public static Recipe getRecipe(@NotNull ChangeMethodAccessLevelTest $this) {
            return JavaRecipeTest.DefaultImpls.getRecipe($this);
        }

        public static void assertChangedBase(@NotNull ChangeMethodAccessLevelTest $this, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull File before, @Nullable Path relativeTo, @NotNull File[] dependsOn, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase($this, parser, recipe2, executionContext, before, relativeTo, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertChangedBase(@NotNull ChangeMethodAccessLevelTest $this, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull String before, @NotNull String[] dependsOn, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase($this, parser, recipe2, executionContext, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertUnchangedBase(@NotNull ChangeMethodAccessLevelTest $this, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull File before, @Nullable Path relativeTo, @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchangedBase($this, parser, recipe2, executionContext, before, relativeTo, dependsOn);
        }

        public static void assertUnchangedBase(@NotNull ChangeMethodAccessLevelTest $this, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull String before, @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchangedBase($this, parser, recipe2, executionContext, before, dependsOn);
        }

        @NotNull
        public static Recipe fromRuntimeClasspath(@NotNull ChangeMethodAccessLevelTest $this, @NotNull String recipe2) {
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            return JavaRecipeTest.DefaultImpls.fromRuntimeClasspath($this, recipe2);
        }

        @NotNull
        public static Recipe toRecipe(@NotNull ChangeMethodAccessLevelTest $this, @NotNull Function0<? extends TreeVisitor<?, ExecutionContext>> supplier) {
            Intrinsics.checkNotNullParameter(supplier, (String)"supplier");
            return JavaRecipeTest.DefaultImpls.toRecipe($this, supplier);
        }

        private static void publicToPrivate$lambda$0(RecipeSpec spec) {
            spec.recipe((Recipe)new ChangeMethodAccessLevel("com.abc.A aMethod(..)", "private", null));
        }

        private static void packagePrivateToProtected$lambda$1(RecipeSpec spec) {
            spec.recipe((Recipe)new ChangeMethodAccessLevel("com.abc.A aMethod(..)", "protected", null));
        }

        private static void publicToPackagePrivate$lambda$2(RecipeSpec spec) {
            spec.recipe((Recipe)new ChangeMethodAccessLevel("com.abc.A aMethod(..)", "package", null));
        }

        private static void publicToPackagePrivateWildcard$lambda$3(RecipeSpec spec) {
            spec.recipe((Recipe)new ChangeMethodAccessLevel("com.abc.A *(..)", "package", null));
        }

        private static void doNotChangeExistingAccessLevel$lambda$4(RecipeSpec spec) {
            spec.recipe((Recipe)new ChangeMethodAccessLevel("com.abc.A aMethod(String)", "public", null));
        }

        private static void packagePrivateToProtectedWithOtherModifier$lambda$5(RecipeSpec spec) {
            spec.recipe((Recipe)new ChangeMethodAccessLevel("com.abc.A aMethod(..)", "protected", null));
        }

        private static void packagePrivateToProtectedWithConstructor$lambda$6(RecipeSpec spec) {
            spec.recipe((Recipe)new ChangeMethodAccessLevel("com.abc.A <constructor>(..)", "protected", null));
        }

        private static void methodPatternExactMatch$lambda$7(RecipeSpec spec) {
            spec.recipe((Recipe)new ChangeMethodAccessLevel("com.abc.A aMethod(..)", "protected", null));
        }

        private static void matchOverrides$lambda$8(RecipeSpec spec) {
            spec.recipe((Recipe)new ChangeMethodAccessLevel("com.abc.A aMethod(..)", "protected", Boolean.valueOf(true)));
        }
    }
}

