/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.io.File;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.ChangeFieldName;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaRecipeTest;
import org.openrewrite.java.TypeValidator;
import org.openrewrite.java.tree.J;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\bf\u0018\u00002\u00020\u0001J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0016J\u0010\u0010\u0002\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0017J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0017J\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0017J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0017J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0017\u00a8\u0006\u000f"}, d2={"Lorg/openrewrite/java/ChangeFieldNameTest;", "Lorg/openrewrite/java/JavaRecipeTest;", "changeFieldName", "Lorg/openrewrite/Recipe;", "enclosingClassFqn", "", "from", "to", "", "jp", "Lorg/openrewrite/java/JavaParser;", "changeFieldNameReferences", "changeFieldNameReferencesInOtherClass", "changeFieldNameReferencesInOtherClassUsingStaticImport", "dontChangeNestedFieldsWithSameName", "rewrite-java-tck"})
public interface ChangeFieldNameTest
extends JavaRecipeTest {
    @NotNull
    public Recipe changeFieldName(@NotNull String var1, @NotNull String var2, @NotNull String var3);

    @Test
    public void changeFieldName(@NotNull JavaParser var1);

    @Test
    public void changeFieldNameReferences(@NotNull JavaParser var1);

    @Test
    public void changeFieldNameReferencesInOtherClass(@NotNull JavaParser var1);

    @Test
    public void changeFieldNameReferencesInOtherClassUsingStaticImport(@NotNull JavaParser var1);

    @Test
    public void dontChangeNestedFieldsWithSameName(@NotNull JavaParser var1);

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        @NotNull
        public static Recipe changeFieldName(@NotNull ChangeFieldNameTest $this, @NotNull String enclosingClassFqn, @NotNull String from, @NotNull String to) {
            Intrinsics.checkNotNullParameter((Object)enclosingClassFqn, (String)"enclosingClassFqn");
            Intrinsics.checkNotNullParameter((Object)from, (String)"from");
            Intrinsics.checkNotNullParameter((Object)to, (String)"to");
            return $this.toRecipe(new Function0<TreeVisitor<?, ExecutionContext>>(enclosingClassFqn, from, to){
                final /* synthetic */ String $enclosingClassFqn;
                final /* synthetic */ String $from;
                final /* synthetic */ String $to;
                {
                    this.$enclosingClassFqn = $enclosingClassFqn;
                    this.$from = $from;
                    this.$to = $to;
                    super(0);
                }

                @NotNull
                public final TreeVisitor<?, ExecutionContext> invoke() {
                    return (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(this.$enclosingClassFqn, this.$from, this.$to){
                        final /* synthetic */ String $enclosingClassFqn;
                        final /* synthetic */ String $from;
                        final /* synthetic */ String $to;
                        {
                            this.$enclosingClassFqn = $enclosingClassFqn;
                            this.$from = $from;
                            this.$to = $to;
                        }

                        @NotNull
                        public J.CompilationUnit visitCompilationUnit(@NotNull J.CompilationUnit cu, @NotNull ExecutionContext p) {
                            Intrinsics.checkNotNullParameter((Object)cu, (String)"cu");
                            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                            this.doAfterVisit((TreeVisitor)new ChangeFieldName(this.$enclosingClassFqn, this.$from, this.$to));
                            J.CompilationUnit compilationUnit = super.visitCompilationUnit(cu, (Object)p);
                            Intrinsics.checkNotNullExpressionValue((Object)compilationUnit, (String)"super.visitCompilationUnit(cu, p)");
                            return compilationUnit;
                        }
                    };
                }
            });
        }

        @Test
        public static void changeFieldName(@NotNull ChangeFieldNameTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default($this, jp, $this.changeFieldName("Test", "collection", "list"), null, "\n            import java.util.List;\n            class Test {\n               List collection = null;\n            }\n        ", null, "\n            import java.util.List;\n            class Test {\n               List list = null;\n            }\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void changeFieldNameReferences(@NotNull ChangeFieldNameTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default($this, jp, $this.changeFieldName("Test", "n", "n1"), null, "\n            class Test {\n               int n;\n               \n               {\n                   n = 1;\n                   n /= 2;\n                   if(n + 1 == 2) {}\n                   n++;\n               }\n               \n               public int foo(int n) {\n                   return n + this.n;\n               }\n            }\n        ", null, "\n            class Test {\n               int n1;\n               \n               {\n                   n1 = 1;\n                   n1 /= 2;\n                   if(n1 + 1 == 2) {}\n                   n1++;\n               }\n               \n               public int foo(int n) {\n                   return n + this.n1;\n               }\n            }\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void changeFieldNameReferencesInOtherClass(@NotNull ChangeFieldNameTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Recipe recipe2 = $this.changeFieldName("Test", "n", "n1");
            String[] stringArray = new String[]{"\n                class Test {\n                   int n;\n                }\n            "};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default($this, jp, recipe2, null, "\n            class Caller {\n                Test t = new Test();\n                {\n                    t.n = 1;\n                }\n            }\n        ", stringArray2, "\n            class Caller {\n                Test t = new Test();\n                {\n                    t.n1 = 1;\n                }\n            }\n        ", 0, 0, null, null, 964, null);
        }

        @Test
        public static void changeFieldNameReferencesInOtherClassUsingStaticImport(@NotNull ChangeFieldNameTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Recipe recipe2 = new Recipe[]{"\n                package com.example;\n\n                public class Test {\n                    public static final int IMPORT_ME_STATICALLY = 0;\n                }\n            "};
            Recipe recipe3 = recipe2;
            recipe2 = $this.changeFieldName("com.example.Test", "IMPORT_ME_STATICALLY", "IMPORT_ME_STATICALLY_1");
            JavaRecipeTest.DefaultImpls.assertChanged$default($this, jp, recipe2, null, "\n            package org.openrewrite.test;\n\n            import static com.example.Test.IMPORT_ME_STATICALLY;\n\n            public class Caller {\n                int e = IMPORT_ME_STATICALLY;\n            }\n        ", (String[])recipe3, "\n            package org.openrewrite.test;\n\n            import static com.example.Test.IMPORT_ME_STATICALLY_1;\n\n            public class Caller {\n                int e = IMPORT_ME_STATICALLY_1;\n            }\n        ", 0, 0, null, null, 964, null);
        }

        @Test
        public static void dontChangeNestedFieldsWithSameName(@NotNull ChangeFieldNameTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Recipe recipe2 = new Recipe[]{"class A { Object collection; }"};
            Recipe recipe3 = recipe2;
            recipe2 = $this.changeFieldName("Test", "collection", "list");
            JavaRecipeTest.DefaultImpls.assertChanged$default($this, jp, recipe2, null, "\n            import java.util.List;\n            class Test {\n                List collection = null;\n                class Nested {\n                    Object collection = Test.this.collection;\n                    Object collection2 = A.this.collection;\n                }\n            }\n        ", (String[])recipe3, "\n            import java.util.List;\n            class Test {\n                List list = null;\n                class Nested {\n                    Object collection = Test.this.list;\n                    Object collection2 = A.this.collection;\n                }\n            }\n        ", 0, 0, null, null, 964, null);
        }

        @NotNull
        public static JavaParser getParser(@NotNull ChangeFieldNameTest $this) {
            return JavaRecipeTest.DefaultImpls.getParser($this);
        }

        @NotNull
        public static ExecutionContext getExecutionContext(@NotNull ChangeFieldNameTest $this) {
            return JavaRecipeTest.DefaultImpls.getExecutionContext($this);
        }

        @BeforeEach
        public static void beforeRecipe(@NotNull ChangeFieldNameTest $this) {
            JavaRecipeTest.DefaultImpls.beforeRecipe($this);
        }

        @AfterEach
        public static void afterRecipe(@NotNull ChangeFieldNameTest $this) {
            JavaRecipeTest.DefaultImpls.afterRecipe($this);
        }

        public static void assertChanged(@NotNull ChangeFieldNameTest $this, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super TypeValidator.ValidationOptions.Companion.Builder, Unit> typeValidation, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(typeValidation, (String)"typeValidation");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged($this, parser, recipe2, executionContext, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, typeValidation, afterConditions);
        }

        public static void assertChanged(@NotNull ChangeFieldNameTest $this, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull File before, @Nullable Path relativeTo, @Language(value="java") @NotNull File[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super TypeValidator.ValidationOptions.Companion.Builder, Unit> typeValidation, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(typeValidation, (String)"typeValidation");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged($this, parser, recipe2, executionContext, before, relativeTo, dependsOn, after, cycles, expectedCyclesThatMakeChanges, typeValidation, afterConditions);
        }

        public static void assertUnchanged(@NotNull ChangeFieldNameTest $this, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged($this, parser, recipe2, executionContext, before, dependsOn);
        }

        public static void assertUnchanged(@NotNull ChangeFieldNameTest $this, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull File before, @Nullable Path relativeTo, @Language(value="java") @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged($this, parser, recipe2, executionContext, before, relativeTo, dependsOn);
        }

        @Nullable
        public static Recipe getRecipe(@NotNull ChangeFieldNameTest $this) {
            return JavaRecipeTest.DefaultImpls.getRecipe($this);
        }

        public static void assertChangedBase(@NotNull ChangeFieldNameTest $this, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull File before, @Nullable Path relativeTo, @NotNull File[] dependsOn, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase($this, parser, recipe2, executionContext, before, relativeTo, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertChangedBase(@NotNull ChangeFieldNameTest $this, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull String before, @NotNull String[] dependsOn, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase($this, parser, recipe2, executionContext, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertUnchangedBase(@NotNull ChangeFieldNameTest $this, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull File before, @Nullable Path relativeTo, @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchangedBase($this, parser, recipe2, executionContext, before, relativeTo, dependsOn);
        }

        public static void assertUnchangedBase(@NotNull ChangeFieldNameTest $this, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull String before, @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchangedBase($this, parser, recipe2, executionContext, before, dependsOn);
        }

        @NotNull
        public static Recipe fromRuntimeClasspath(@NotNull ChangeFieldNameTest $this, @NotNull String recipe2) {
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            return JavaRecipeTest.DefaultImpls.fromRuntimeClasspath($this, recipe2);
        }

        @NotNull
        public static Recipe toRecipe(@NotNull ChangeFieldNameTest $this, @NotNull Function0<? extends TreeVisitor<?, ExecutionContext>> supplier) {
            Intrinsics.checkNotNullParameter(supplier, (String)"supplier");
            return JavaRecipeTest.DefaultImpls.toRecipe($this, supplier);
        }
    }
}

