/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.openrewrite.java.Assertions;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.test.RewriteTest;
import org.openrewrite.test.SourceSpec;
import org.openrewrite.test.SourceSpecs;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0013\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H\u0017J\b\u0010\u0004\u001a\u00020\u0003H\u0017J\b\u0010\u0005\u001a\u00020\u0003H\u0017J\b\u0010\u0006\u001a\u00020\u0003H\u0017J\b\u0010\u0007\u001a\u00020\u0003H\u0017J\b\u0010\b\u001a\u00020\u0003H\u0017J\b\u0010\t\u001a\u00020\u0003H\u0017J\b\u0010\n\u001a\u00020\u0003H\u0017J\b\u0010\u000b\u001a\u00020\u0003H\u0017J\b\u0010\f\u001a\u00020\u0003H\u0017J\b\u0010\r\u001a\u00020\u0003H\u0017J\b\u0010\u000e\u001a\u00020\u0003H\u0017J\b\u0010\u000f\u001a\u00020\u0003H\u0017J\b\u0010\u0010\u001a\u00020\u0003H\u0017J\b\u0010\u0011\u001a\u00020\u0003H\u0017J\b\u0010\u0012\u001a\u00020\u0003H\u0017J\b\u0010\u0013\u001a\u00020\u0003H\u0017J\b\u0010\u0014\u001a\u00020\u0003H\u0017J\b\u0010\u0015\u001a\u00020\u0003H\u0017\u00a8\u0006\u0016"}, d2={"Lorg/openrewrite/java/tree/TypeUtilsTest;", "Lorg/openrewrite/test/RewriteTest;", "differentMethodTypeIsOfType", "", "differentParameterizedTypesIsOfType", "differentVarianceOfGenericTypeOfType", "isArrayTypeOfClassType", "isFullyQualifiedOfType", "isFullyQualifiedTypeOfClassType", "isGenericTypeOfType", "isJavaTypeArrayAssignableTo", "isMethodTypeIsOfType", "isOverrideBasicInheritance", "isOverrideBasicInterface", "isOverrideConsidersTypeParameterPositions", "isOverrideParameterizedInterface", "isOverrideParameterizedMethod", "isParameterizedTypeOfClassType", "isParameterizedTypeOfType", "isParameterizedTypeWithShallowClassesOfType", "isPrimitiveTypeOfClassType", "isVariableTypeOfClassType", "rewrite-java-tck"})
public interface TypeUtilsTest
extends RewriteTest {
    @Test
    public void isOverrideBasicInterface();

    @Test
    public void isOverrideBasicInheritance();

    @Test
    public void isOverrideParameterizedInterface();

    @Test
    public void isOverrideParameterizedMethod();

    @Test
    public void isOverrideConsidersTypeParameterPositions();

    @Test
    public void isFullyQualifiedOfType();

    @Test
    public void isParameterizedTypeOfType();

    @Test
    public void isParameterizedTypeWithShallowClassesOfType();

    @Test
    public void isMethodTypeIsOfType();

    @Test
    public void differentMethodTypeIsOfType();

    @Test
    public void differentParameterizedTypesIsOfType();

    @Test
    public void isGenericTypeOfType();

    @Test
    public void differentVarianceOfGenericTypeOfType();

    @Test
    public void isJavaTypeArrayAssignableTo();

    @Test
    public void isFullyQualifiedTypeOfClassType();

    @Test
    public void isParameterizedTypeOfClassType();

    @Test
    public void isVariableTypeOfClassType();

    @Test
    public void isArrayTypeOfClassType();

    @Test
    public void isPrimitiveTypeOfClassType();

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @Test
        public static void isOverrideBasicInterface(@NotNull TypeUtilsTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            interface Interface {\n                void foo();\n            }\n        "), Assertions.java((String)"\n            class Clazz implements Interface {\n                @Override void foo() { }\n            }\n        ", DefaultImpls::isOverrideBasicInterface$lambda-1)};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void isOverrideBasicInheritance(@NotNull TypeUtilsTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Superclass {\n                void foo();\n            }\n        "), Assertions.java((String)"\n            class Clazz extends Superclass {\n                @Override void foo() { }\n            }\n        ", DefaultImpls::isOverrideBasicInheritance$lambda-3)};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void isOverrideParameterizedInterface(@NotNull TypeUtilsTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.util.Comparator;\n            \n            class TestComparator implements Comparator<String> {\n                @Override public int compare(String o1, String o2) { \n                    return 0; \n                }\n            }\n        ", DefaultImpls::isOverrideParameterizedInterface$lambda-5)};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void isOverrideParameterizedMethod(@NotNull TypeUtilsTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            interface Interface {\n                <T> void foo(T t);\n            }\n        "), Assertions.java((String)"\n            class Clazz implements Interface {\n                @Override <T> void foo(T t) { }\n            }\n        ", DefaultImpls::isOverrideParameterizedMethod$lambda-7)};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void isOverrideConsidersTypeParameterPositions(@NotNull TypeUtilsTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            interface Interface <T, Y> {\n                 void foo(Y y, T t);\n            }\n        "), Assertions.java((String)"\n            class Clazz implements Interface<Integer, String> {\n                \n                void foo(Integer t, String y) { }\n                \n                @Override\n                void foo(String y, Integer t) { }\n            }\n        ", DefaultImpls::isOverrideConsidersTypeParameterPositions$lambda-9)};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void isFullyQualifiedOfType(@NotNull TypeUtilsTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                Integer integer1;\n                Integer integer2;\n            }\n        ", DefaultImpls::isFullyQualifiedOfType$lambda-11)};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void isParameterizedTypeOfType(@NotNull TypeUtilsTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                java.util.List<Integer> integer1;\n                java.util.List<Integer> integer2;\n            }\n        ", DefaultImpls::isParameterizedTypeOfType$lambda-13)};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void isParameterizedTypeWithShallowClassesOfType(@NotNull TypeUtilsTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                java.util.List<Integer> integer1;\n            }\n        ", DefaultImpls::isParameterizedTypeWithShallowClassesOfType$lambda-15)};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void isMethodTypeIsOfType(@NotNull TypeUtilsTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                void stringArg(String arg) {\n                    objectArg(arg);\n                }\n                void integerArg(Integer arg) {\n                    objectArg(arg);\n                }\n                void objectArg(Object arg) {}\n            }\n        ", DefaultImpls::isMethodTypeIsOfType$lambda-17)};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void differentMethodTypeIsOfType(@NotNull TypeUtilsTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                void stringArg(String arg) {\n                    foo(arg);\n                }\n                void integerArg(Integer arg) {\n                    foo(arg);\n                }\n                void foo(Integer arg) {}\n                void foo(Object arg) {}\n            }\n        ", DefaultImpls::differentMethodTypeIsOfType$lambda-19)};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void differentParameterizedTypesIsOfType(@NotNull TypeUtilsTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                java.util.List<Integer> integers;\n                java.util.List<String> strings;\n            }\n        ", DefaultImpls::differentParameterizedTypesIsOfType$lambda-21)};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void isGenericTypeOfType(@NotNull TypeUtilsTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                java.util.List<? super Number> type1;\n                java.util.List<? super Number> type2;\n            }\n        ", DefaultImpls::isGenericTypeOfType$lambda-23)};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void differentVarianceOfGenericTypeOfType(@NotNull TypeUtilsTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                java.util.List<? super Number> type1;\n                java.util.List<? extends Number> type2;\n            }\n        ", DefaultImpls::differentVarianceOfGenericTypeOfType$lambda-25)};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void isJavaTypeArrayAssignableTo(@NotNull TypeUtilsTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"class Test {}"), Assertions.java((String)"\n            class ExtendTest extends Test {\n                Test[] extendTestArray = new ExtendTest[0];\n            }\n        ", DefaultImpls::isJavaTypeArrayAssignableTo$lambda-27)};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void isFullyQualifiedTypeOfClassType(@NotNull TypeUtilsTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                Integer integer;\n            }\n        ", DefaultImpls::isFullyQualifiedTypeOfClassType$lambda-29)};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void isParameterizedTypeOfClassType(@NotNull TypeUtilsTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                java.util.List<Integer> list;\n            }\n        ", DefaultImpls::isParameterizedTypeOfClassType$lambda-31)};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void isVariableTypeOfClassType(@NotNull TypeUtilsTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                java.util.List<Integer> list;\n            }\n        ", DefaultImpls::isVariableTypeOfClassType$lambda-33)};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void isArrayTypeOfClassType(@NotNull TypeUtilsTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                Integer[] integer;\n            }\n        ", DefaultImpls::isArrayTypeOfClassType$lambda-35)};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void isPrimitiveTypeOfClassType(@NotNull TypeUtilsTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                int i;\n            }\n        ", DefaultImpls::isPrimitiveTypeOfClassType$lambda-37)};
            this_.rewriteRun(sourceSpecsArray);
        }

        private static void isOverrideBasicInterface$lambda-1$lambda-0(J.CompilationUnit cu) {
            Object e = ((J.ClassDeclaration)cu.getClasses().get(0)).getBody().getStatements().get(0);
            if (e == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            JavaType.Method fooMethodType = ((J.MethodDeclaration)e).getMethodType();
            org.assertj.core.api.Assertions.assertThat((Optional)TypeUtils.findOverriddenMethod((JavaType.Method)fooMethodType)).isPresent();
        }

        private static void isOverrideBasicInterface$lambda-1(SourceSpec s) {
            s.beforeRecipe(DefaultImpls::isOverrideBasicInterface$lambda-1$lambda-0);
        }

        private static void isOverrideBasicInheritance$lambda-3$lambda-2(J.CompilationUnit cu) {
            Object e = ((J.ClassDeclaration)cu.getClasses().get(0)).getBody().getStatements().get(0);
            if (e == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            JavaType.Method fooMethodType = ((J.MethodDeclaration)e).getMethodType();
            org.assertj.core.api.Assertions.assertThat((Optional)TypeUtils.findOverriddenMethod((JavaType.Method)fooMethodType)).isPresent();
        }

        private static void isOverrideBasicInheritance$lambda-3(SourceSpec s) {
            s.beforeRecipe(DefaultImpls::isOverrideBasicInheritance$lambda-3$lambda-2);
        }

        private static void isOverrideParameterizedInterface$lambda-5$lambda-4(J.CompilationUnit cu) {
            Object e = ((J.ClassDeclaration)cu.getClasses().get(0)).getBody().getStatements().get(0);
            if (e == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            JavaType.Method fooMethodType = ((J.MethodDeclaration)e).getMethodType();
            org.assertj.core.api.Assertions.assertThat((Optional)TypeUtils.findOverriddenMethod((JavaType.Method)fooMethodType)).isPresent();
        }

        private static void isOverrideParameterizedInterface$lambda-5(SourceSpec s) {
            s.beforeRecipe(DefaultImpls::isOverrideParameterizedInterface$lambda-5$lambda-4);
        }

        private static void isOverrideParameterizedMethod$lambda-7$lambda-6(J.CompilationUnit cu) {
            Object e = ((J.ClassDeclaration)cu.getClasses().get(0)).getBody().getStatements().get(0);
            if (e == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            JavaType.Method fooMethodType = ((J.MethodDeclaration)e).getMethodType();
            org.assertj.core.api.Assertions.assertThat((Optional)TypeUtils.findOverriddenMethod((JavaType.Method)fooMethodType)).isPresent();
        }

        private static void isOverrideParameterizedMethod$lambda-7(SourceSpec s) {
            s.beforeRecipe(DefaultImpls::isOverrideParameterizedMethod$lambda-7$lambda-6);
        }

        /*
         * WARNING - void declaration
         */
        private static void isOverrideConsidersTypeParameterPositions$lambda-9$lambda-8(J.CompilationUnit cu) {
            void $this$filterIsInstanceTo$iv$iv;
            List list = ((J.ClassDeclaration)cu.getClasses().get(0)).getBody().getStatements();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"cu.classes[0].body.statements");
            Iterable $this$filterIsInstance$iv = list;
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof J.MethodDeclaration)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List methods = (List)destination$iv$iv;
            org.assertj.core.api.Assertions.assertThat((Optional)TypeUtils.findOverriddenMethod((JavaType.Method)((J.MethodDeclaration)methods.get(0)).getMethodType())).isEmpty();
            org.assertj.core.api.Assertions.assertThat((Optional)TypeUtils.findOverriddenMethod((JavaType.Method)((J.MethodDeclaration)methods.get(1)).getMethodType())).isPresent();
        }

        private static void isOverrideConsidersTypeParameterPositions$lambda-9(SourceSpec s) {
            s.beforeRecipe(DefaultImpls::isOverrideConsidersTypeParameterPositions$lambda-9$lambda-8);
        }

        private static void isFullyQualifiedOfType$lambda-11$lambda-10(J.CompilationUnit cu) {
            Object e = ((J.ClassDeclaration)cu.getClasses().get(0)).getBody().getStatements().get(0);
            if (e == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDeclarations");
            }
            J.VariableDeclarations.NamedVariable variable1 = (J.VariableDeclarations.NamedVariable)((J.VariableDeclarations)e).getVariables().get(0);
            Object e2 = ((J.ClassDeclaration)cu.getClasses().get(0)).getBody().getStatements().get(1);
            if (e2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDeclarations");
            }
            J.VariableDeclarations.NamedVariable variable2 = (J.VariableDeclarations.NamedVariable)((J.VariableDeclarations)e2).getVariables().get(0);
            JavaType.Variable variable = variable1.getVariableType();
            org.assertj.core.api.Assertions.assertThat((Object)(variable != null ? variable.getType() : null)).isInstanceOf(JavaType.Class.class);
            JavaType.Variable variable3 = variable2.getVariableType();
            org.assertj.core.api.Assertions.assertThat((Object)(variable3 != null ? variable3.getType() : null)).isInstanceOf(JavaType.Class.class);
            JavaType.Variable variable4 = variable1.getVariableType();
            JavaType.Variable variable5 = variable2.getVariableType();
            org.assertj.core.api.Assertions.assertThat((boolean)TypeUtils.isOfType((JavaType)(variable4 != null ? variable4.getType() : null), (JavaType)(variable5 != null ? variable5.getType() : null))).isTrue();
        }

        private static void isFullyQualifiedOfType$lambda-11(SourceSpec s) {
            s.beforeRecipe(DefaultImpls::isFullyQualifiedOfType$lambda-11$lambda-10);
        }

        private static void isParameterizedTypeOfType$lambda-13$lambda-12(J.CompilationUnit cu) {
            Object e = ((J.ClassDeclaration)cu.getClasses().get(0)).getBody().getStatements().get(0);
            if (e == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDeclarations");
            }
            J.VariableDeclarations.NamedVariable variable1 = (J.VariableDeclarations.NamedVariable)((J.VariableDeclarations)e).getVariables().get(0);
            Object e2 = ((J.ClassDeclaration)cu.getClasses().get(0)).getBody().getStatements().get(1);
            if (e2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDeclarations");
            }
            J.VariableDeclarations.NamedVariable variable2 = (J.VariableDeclarations.NamedVariable)((J.VariableDeclarations)e2).getVariables().get(0);
            JavaType.Variable variable = variable1.getVariableType();
            org.assertj.core.api.Assertions.assertThat((Object)(variable != null ? variable.getType() : null)).isInstanceOf(JavaType.Parameterized.class);
            JavaType.Variable variable3 = variable2.getVariableType();
            org.assertj.core.api.Assertions.assertThat((Object)(variable3 != null ? variable3.getType() : null)).isInstanceOf(JavaType.Parameterized.class);
            JavaType.Variable variable4 = variable1.getVariableType();
            JavaType.Variable variable5 = variable2.getVariableType();
            org.assertj.core.api.Assertions.assertThat((boolean)TypeUtils.isOfType((JavaType)(variable4 != null ? variable4.getType() : null), (JavaType)(variable5 != null ? variable5.getType() : null))).isTrue();
        }

        private static void isParameterizedTypeOfType$lambda-13(SourceSpec s) {
            s.beforeRecipe(DefaultImpls::isParameterizedTypeOfType$lambda-13$lambda-12);
        }

        private static void isParameterizedTypeWithShallowClassesOfType$lambda-15$lambda-14(J.CompilationUnit cu) {
            Object e = ((J.ClassDeclaration)cu.getClasses().get(0)).getBody().getStatements().get(0);
            if (e == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDeclarations");
            }
            J.VariableDeclarations.NamedVariable variable1 = (J.VariableDeclarations.NamedVariable)((J.VariableDeclarations)e).getVariables().get(0);
            JavaType.Variable variable = variable1.getVariableType();
            org.assertj.core.api.Assertions.assertThat((Object)(variable != null ? variable.getType() : null)).isInstanceOf(JavaType.Parameterized.class);
            JavaType.Parameterized shallowParameterizedType = new JavaType.Parameterized(null, (JavaType.FullyQualified)JavaType.ShallowClass.build((String)"java.util.List"), CollectionsKt.listOf((Object)JavaType.ShallowClass.build((String)"java.lang.Integer")));
            JavaType.Variable variable2 = variable1.getVariableType();
            org.assertj.core.api.Assertions.assertThat((boolean)TypeUtils.isOfType((JavaType)(variable2 != null ? variable2.getType() : null), (JavaType)((JavaType)shallowParameterizedType))).isTrue();
        }

        private static void isParameterizedTypeWithShallowClassesOfType$lambda-15(SourceSpec s) {
            s.beforeRecipe(DefaultImpls::isParameterizedTypeWithShallowClassesOfType$lambda-15$lambda-14);
        }

        private static void isMethodTypeIsOfType$lambda-17$lambda-16(J.CompilationUnit cu) {
            Object e = ((J.ClassDeclaration)cu.getClasses().get(0)).getBody().getStatements().get(0);
            if (e == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block2 = ((J.MethodDeclaration)e).getBody();
            Intrinsics.checkNotNull((Object)block2);
            Object e2 = block2.getStatements().get(0);
            if (e2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodInvocation");
            }
            J.MethodInvocation methodInvocation1 = (J.MethodInvocation)e2;
            Object e3 = ((J.ClassDeclaration)cu.getClasses().get(0)).getBody().getStatements().get(1);
            if (e3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block3 = ((J.MethodDeclaration)e3).getBody();
            Intrinsics.checkNotNull((Object)block3);
            Object e4 = block3.getStatements().get(0);
            if (e4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodInvocation");
            }
            J.MethodInvocation methodInvocation2 = (J.MethodInvocation)e4;
            org.assertj.core.api.Assertions.assertThat((Object)methodInvocation1.getMethodType()).isInstanceOf(JavaType.Method.class);
            org.assertj.core.api.Assertions.assertThat((Object)methodInvocation2.getMethodType()).isInstanceOf(JavaType.Method.class);
            org.assertj.core.api.Assertions.assertThat((boolean)TypeUtils.isOfType((JavaType)((JavaType)methodInvocation1.getMethodType()), (JavaType)((JavaType)methodInvocation2.getMethodType()))).isTrue();
        }

        private static void isMethodTypeIsOfType$lambda-17(SourceSpec s) {
            s.beforeRecipe(DefaultImpls::isMethodTypeIsOfType$lambda-17$lambda-16);
        }

        private static void differentMethodTypeIsOfType$lambda-19$lambda-18(J.CompilationUnit cu) {
            Object e = ((J.ClassDeclaration)cu.getClasses().get(0)).getBody().getStatements().get(0);
            if (e == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block2 = ((J.MethodDeclaration)e).getBody();
            Intrinsics.checkNotNull((Object)block2);
            Object e2 = block2.getStatements().get(0);
            if (e2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodInvocation");
            }
            J.MethodInvocation methodInvocation1 = (J.MethodInvocation)e2;
            Object e3 = ((J.ClassDeclaration)cu.getClasses().get(0)).getBody().getStatements().get(1);
            if (e3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block3 = ((J.MethodDeclaration)e3).getBody();
            Intrinsics.checkNotNull((Object)block3);
            Object e4 = block3.getStatements().get(0);
            if (e4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodInvocation");
            }
            J.MethodInvocation methodInvocation2 = (J.MethodInvocation)e4;
            org.assertj.core.api.Assertions.assertThat((Object)methodInvocation1.getMethodType()).isInstanceOf(JavaType.Method.class);
            org.assertj.core.api.Assertions.assertThat((Object)methodInvocation2.getMethodType()).isInstanceOf(JavaType.Method.class);
            org.assertj.core.api.Assertions.assertThat((boolean)TypeUtils.isOfType((JavaType)((JavaType)methodInvocation1.getMethodType()), (JavaType)((JavaType)methodInvocation2.getMethodType()))).isFalse();
        }

        private static void differentMethodTypeIsOfType$lambda-19(SourceSpec s) {
            s.beforeRecipe(DefaultImpls::differentMethodTypeIsOfType$lambda-19$lambda-18);
        }

        private static void differentParameterizedTypesIsOfType$lambda-21$lambda-20(J.CompilationUnit cu) {
            Object e = ((J.ClassDeclaration)cu.getClasses().get(0)).getBody().getStatements().get(0);
            if (e == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDeclarations");
            }
            J.VariableDeclarations.NamedVariable variable1 = (J.VariableDeclarations.NamedVariable)((J.VariableDeclarations)e).getVariables().get(0);
            Object e2 = ((J.ClassDeclaration)cu.getClasses().get(0)).getBody().getStatements().get(1);
            if (e2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDeclarations");
            }
            J.VariableDeclarations.NamedVariable variable2 = (J.VariableDeclarations.NamedVariable)((J.VariableDeclarations)e2).getVariables().get(0);
            JavaType.Variable variable = variable1.getVariableType();
            org.assertj.core.api.Assertions.assertThat((Object)(variable != null ? variable.getType() : null)).isInstanceOf(JavaType.Parameterized.class);
            JavaType.Variable variable3 = variable2.getVariableType();
            org.assertj.core.api.Assertions.assertThat((Object)(variable3 != null ? variable3.getType() : null)).isInstanceOf(JavaType.Parameterized.class);
            JavaType.Variable variable4 = variable1.getVariableType();
            JavaType.Variable variable5 = variable2.getVariableType();
            org.assertj.core.api.Assertions.assertThat((boolean)TypeUtils.isOfType((JavaType)(variable4 != null ? variable4.getType() : null), (JavaType)(variable5 != null ? variable5.getType() : null))).isFalse();
        }

        private static void differentParameterizedTypesIsOfType$lambda-21(SourceSpec s) {
            s.beforeRecipe(DefaultImpls::differentParameterizedTypesIsOfType$lambda-21$lambda-20);
        }

        private static void isGenericTypeOfType$lambda-23$lambda-22(J.CompilationUnit cu) {
            Object e = ((J.ClassDeclaration)cu.getClasses().get(0)).getBody().getStatements().get(0);
            if (e == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDeclarations");
            }
            J.VariableDeclarations.NamedVariable namedVariable = (J.VariableDeclarations.NamedVariable)((J.VariableDeclarations)e).getVariables().get(0);
            JavaType javaType = namedVariable != null ? namedVariable.getType() : null;
            if (javaType == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.JavaType.Parameterized");
            }
            JavaType variable1 = (JavaType)((JavaType.Parameterized)javaType).getTypeParameters().get(0);
            Object e2 = ((J.ClassDeclaration)cu.getClasses().get(0)).getBody().getStatements().get(1);
            if (e2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDeclarations");
            }
            J.VariableDeclarations.NamedVariable namedVariable2 = (J.VariableDeclarations.NamedVariable)((J.VariableDeclarations)e2).getVariables().get(0);
            JavaType javaType2 = namedVariable2 != null ? namedVariable2.getType() : null;
            if (javaType2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.JavaType.Parameterized");
            }
            JavaType variable2 = (JavaType)((JavaType.Parameterized)javaType2).getTypeParameters().get(0);
            org.assertj.core.api.Assertions.assertThat((Object)variable1).isInstanceOf(JavaType.GenericTypeVariable.class);
            org.assertj.core.api.Assertions.assertThat((Object)variable2).isInstanceOf(JavaType.GenericTypeVariable.class);
            org.assertj.core.api.Assertions.assertThat((boolean)TypeUtils.isOfType((JavaType)variable1, (JavaType)variable2)).isTrue();
        }

        private static void isGenericTypeOfType$lambda-23(SourceSpec s) {
            s.beforeRecipe(DefaultImpls::isGenericTypeOfType$lambda-23$lambda-22);
        }

        private static void differentVarianceOfGenericTypeOfType$lambda-25$lambda-24(J.CompilationUnit cu) {
            Object e = ((J.ClassDeclaration)cu.getClasses().get(0)).getBody().getStatements().get(0);
            if (e == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDeclarations");
            }
            J.VariableDeclarations.NamedVariable namedVariable = (J.VariableDeclarations.NamedVariable)((J.VariableDeclarations)e).getVariables().get(0);
            JavaType javaType = namedVariable != null ? namedVariable.getType() : null;
            if (javaType == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.JavaType.Parameterized");
            }
            JavaType variable1 = (JavaType)((JavaType.Parameterized)javaType).getTypeParameters().get(0);
            Object e2 = ((J.ClassDeclaration)cu.getClasses().get(0)).getBody().getStatements().get(1);
            if (e2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDeclarations");
            }
            J.VariableDeclarations.NamedVariable namedVariable2 = (J.VariableDeclarations.NamedVariable)((J.VariableDeclarations)e2).getVariables().get(0);
            JavaType javaType2 = namedVariable2 != null ? namedVariable2.getType() : null;
            if (javaType2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.JavaType.Parameterized");
            }
            JavaType variable2 = (JavaType)((JavaType.Parameterized)javaType2).getTypeParameters().get(0);
            org.assertj.core.api.Assertions.assertThat((Object)variable1).isInstanceOf(JavaType.GenericTypeVariable.class);
            org.assertj.core.api.Assertions.assertThat((Object)variable2).isInstanceOf(JavaType.GenericTypeVariable.class);
            org.assertj.core.api.Assertions.assertThat((boolean)TypeUtils.isOfType((JavaType)variable1, (JavaType)variable2)).isFalse();
        }

        private static void differentVarianceOfGenericTypeOfType$lambda-25(SourceSpec s) {
            s.beforeRecipe(DefaultImpls::differentVarianceOfGenericTypeOfType$lambda-25$lambda-24);
        }

        private static void isJavaTypeArrayAssignableTo$lambda-27$lambda-26(J.CompilationUnit cu) {
            Object e = ((J.ClassDeclaration)cu.getClasses().get(0)).getBody().getStatements().get(0);
            if (e == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDeclarations");
            }
            J.VariableDeclarations.NamedVariable variable = (J.VariableDeclarations.NamedVariable)((J.VariableDeclarations)e).getVariables().get(0);
            JavaType.Variable variable2 = variable.getVariableType();
            Expression expression = variable.getInitializer();
            if (expression == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.NewArray");
            }
            org.assertj.core.api.Assertions.assertThat((boolean)TypeUtils.isAssignableTo((JavaType)(variable2 != null ? variable2.getType() : null), (JavaType)((J.NewArray)expression).getType())).isTrue();
        }

        private static void isJavaTypeArrayAssignableTo$lambda-27(SourceSpec s) {
            s.beforeRecipe(DefaultImpls::isJavaTypeArrayAssignableTo$lambda-27$lambda-26);
        }

        private static void isFullyQualifiedTypeOfClassType$lambda-29$lambda-28(J.CompilationUnit cu) {
            Object e = ((J.ClassDeclaration)cu.getClasses().get(0)).getBody().getStatements().get(0);
            if (e == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDeclarations");
            }
            J.VariableDeclarations.NamedVariable variable = (J.VariableDeclarations.NamedVariable)((J.VariableDeclarations)e).getVariables().get(0);
            JavaType.Variable variable2 = variable.getVariableType();
            org.assertj.core.api.Assertions.assertThat((Object)(variable2 != null ? variable2.getType() : null)).isInstanceOf(JavaType.Class.class);
            JavaType.Variable variable3 = variable.getVariableType();
            org.assertj.core.api.Assertions.assertThat((boolean)TypeUtils.isOfClassType((JavaType)(variable3 != null ? variable3.getType() : null), (String)"java.lang.Integer")).isTrue();
        }

        private static void isFullyQualifiedTypeOfClassType$lambda-29(SourceSpec s) {
            s.beforeRecipe(DefaultImpls::isFullyQualifiedTypeOfClassType$lambda-29$lambda-28);
        }

        private static void isParameterizedTypeOfClassType$lambda-31$lambda-30(J.CompilationUnit cu) {
            Object e = ((J.ClassDeclaration)cu.getClasses().get(0)).getBody().getStatements().get(0);
            if (e == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDeclarations");
            }
            J.VariableDeclarations.NamedVariable variable = (J.VariableDeclarations.NamedVariable)((J.VariableDeclarations)e).getVariables().get(0);
            JavaType.Variable variable2 = variable.getVariableType();
            org.assertj.core.api.Assertions.assertThat((Object)(variable2 != null ? variable2.getType() : null)).isInstanceOf(JavaType.Parameterized.class);
            JavaType.Variable variable3 = variable.getVariableType();
            org.assertj.core.api.Assertions.assertThat((boolean)TypeUtils.isOfClassType((JavaType)(variable3 != null ? variable3.getType() : null), (String)"java.util.List")).isTrue();
        }

        private static void isParameterizedTypeOfClassType$lambda-31(SourceSpec s) {
            s.beforeRecipe(DefaultImpls::isParameterizedTypeOfClassType$lambda-31$lambda-30);
        }

        private static void isVariableTypeOfClassType$lambda-33$lambda-32(J.CompilationUnit cu) {
            Object e = ((J.ClassDeclaration)cu.getClasses().get(0)).getBody().getStatements().get(0);
            if (e == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDeclarations");
            }
            J.VariableDeclarations.NamedVariable variable = (J.VariableDeclarations.NamedVariable)((J.VariableDeclarations)e).getVariables().get(0);
            org.assertj.core.api.Assertions.assertThat((Object)variable.getVariableType()).isInstanceOf(JavaType.Variable.class);
            org.assertj.core.api.Assertions.assertThat((boolean)TypeUtils.isOfClassType((JavaType)((JavaType)variable.getVariableType()), (String)"java.util.List")).isTrue();
        }

        private static void isVariableTypeOfClassType$lambda-33(SourceSpec s) {
            s.beforeRecipe(DefaultImpls::isVariableTypeOfClassType$lambda-33$lambda-32);
        }

        private static void isArrayTypeOfClassType$lambda-35$lambda-34(J.CompilationUnit cu) {
            Object e = ((J.ClassDeclaration)cu.getClasses().get(0)).getBody().getStatements().get(0);
            if (e == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDeclarations");
            }
            J.VariableDeclarations.NamedVariable variable = (J.VariableDeclarations.NamedVariable)((J.VariableDeclarations)e).getVariables().get(0);
            JavaType.Variable variable2 = variable.getVariableType();
            org.assertj.core.api.Assertions.assertThat((Object)(variable2 != null ? variable2.getType() : null)).isInstanceOf(JavaType.Array.class);
            JavaType.Variable variable3 = variable.getVariableType();
            org.assertj.core.api.Assertions.assertThat((boolean)TypeUtils.isOfClassType((JavaType)(variable3 != null ? variable3.getType() : null), (String)"java.lang.Integer")).isTrue();
        }

        private static void isArrayTypeOfClassType$lambda-35(SourceSpec s) {
            s.beforeRecipe(DefaultImpls::isArrayTypeOfClassType$lambda-35$lambda-34);
        }

        private static void isPrimitiveTypeOfClassType$lambda-37$lambda-36(J.CompilationUnit cu) {
            Object e = ((J.ClassDeclaration)cu.getClasses().get(0)).getBody().getStatements().get(0);
            if (e == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDeclarations");
            }
            J.VariableDeclarations.NamedVariable variable = (J.VariableDeclarations.NamedVariable)((J.VariableDeclarations)e).getVariables().get(0);
            JavaType.Variable variable2 = variable.getVariableType();
            org.assertj.core.api.Assertions.assertThat((Object)(variable2 != null ? variable2.getType() : null)).isInstanceOf(JavaType.Primitive.class);
            JavaType.Variable variable3 = variable.getVariableType();
            org.assertj.core.api.Assertions.assertThat((boolean)TypeUtils.isOfClassType((JavaType)(variable3 != null ? variable3.getType() : null), (String)"int")).isTrue();
        }

        private static void isPrimitiveTypeOfClassType$lambda-37(SourceSpec s) {
            s.beforeRecipe(DefaultImpls::isPrimitiveTypeOfClassType$lambda-37$lambda-36);
        }
    }
}

