/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.openrewrite.java.Assertions;
import org.openrewrite.test.RewriteTest;
import org.openrewrite.test.SourceSpecs;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H\u0017J\b\u0010\u0004\u001a\u00020\u0003H\u0017J\b\u0010\u0005\u001a\u00020\u0003H\u0017J\b\u0010\u0006\u001a\u00020\u0003H\u0017\u00a8\u0006\u0007"}, d2={"Lorg/openrewrite/java/tree/SwitchTest;", "Lorg/openrewrite/test/RewriteTest;", "defaultCase", "", "multipleCases", "noCases", "singleCase", "rewrite-java-tck"})
public interface SwitchTest
extends RewriteTest {
    @Test
    public void singleCase();

    @Test
    public void defaultCase();

    @Test
    public void noCases();

    @Test
    public void multipleCases();

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @Test
        public static void singleCase(@NotNull SwitchTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n               class Test {\n                  void test() {\n                      int n;\n                      switch(n) {\n                         case 0: break;\n                      }\n                  }\n               }\n            ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void defaultCase(@NotNull SwitchTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n               class Test {\n                  void test() {\n                      int n;\n                      switch(n) {\n                          default: System.out.println(\"default!\");\n                      }\n                  }\n               }\n            ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void noCases(@NotNull SwitchTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n               class Test {\n                  void test() {\n                      int n;\n                      switch(n) {}\n                  }\n               }\n            ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void multipleCases(@NotNull SwitchTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n               class Test {\n                  void test() {\n                      int n;\n                      switch(n) {\n                          case 0: {\n                             break;\n                          }\n                          case 1: {\n                             break;\n                          }\n                      }\n                  }\n               }\n            ")};
            this_.rewriteRun(sourceSpecsArray);
        }
    }
}

