/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.RecipeRun;
import org.openrewrite.Result;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.Assertions;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaTemplateTest;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.TestKt;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.template.SourceTemplate;
import org.openrewrite.test.RecipeSpec;
import org.openrewrite.test.RewriteTest;
import org.openrewrite.test.SourceSpecs;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b7\n\u0002\u0018\u0002\n\u0002\b\u0010\bf\u0018\u00002\u00020\u0001J\b\u0010\b\u001a\u00020\tH\u0017J\b\u0010\n\u001a\u00020\tH\u0017J\b\u0010\u000b\u001a\u00020\tH\u0017J\b\u0010\f\u001a\u00020\tH\u0017J\b\u0010\r\u001a\u00020\tH\u0017J\b\u0010\u000e\u001a\u00020\tH\u0017J\b\u0010\u000f\u001a\u00020\tH\u0017J\b\u0010\u0010\u001a\u00020\tH\u0017J\b\u0010\u0011\u001a\u00020\tH\u0017J\b\u0010\u0012\u001a\u00020\tH\u0017J\b\u0010\u0013\u001a\u00020\tH\u0017J\b\u0010\u0014\u001a\u00020\tH\u0017J\b\u0010\u0015\u001a\u00020\tH\u0017J\b\u0010\u0016\u001a\u00020\tH\u0017J\b\u0010\u0017\u001a\u00020\tH\u0017J\b\u0010\u0018\u001a\u00020\tH\u0017J\b\u0010\u0019\u001a\u00020\tH\u0017J\b\u0010\u001a\u001a\u00020\tH\u0017J\b\u0010\u001b\u001a\u00020\tH\u0017J\b\u0010\u001c\u001a\u00020\tH\u0017J\b\u0010\u001d\u001a\u00020\tH\u0017J\b\u0010\u001e\u001a\u00020\tH\u0017J\b\u0010\u001f\u001a\u00020\tH\u0017J\b\u0010 \u001a\u00020\tH\u0017J\b\u0010!\u001a\u00020\tH\u0017J\b\u0010\"\u001a\u00020\tH\u0017J\b\u0010#\u001a\u00020\tH\u0017J\b\u0010$\u001a\u00020\tH\u0017J\b\u0010%\u001a\u00020\tH\u0017J\b\u0010&\u001a\u00020\tH\u0017J\b\u0010'\u001a\u00020\tH\u0017J\b\u0010(\u001a\u00020\tH\u0017J\b\u0010)\u001a\u00020\tH\u0017J\b\u0010*\u001a\u00020\tH\u0017J\b\u0010+\u001a\u00020\tH\u0017J\b\u0010,\u001a\u00020\tH\u0017J\b\u0010-\u001a\u00020\tH\u0017J\b\u0010.\u001a\u00020\tH\u0017J\b\u0010/\u001a\u00020\tH\u0017J\b\u00100\u001a\u00020\tH\u0017J\b\u00101\u001a\u00020\tH\u0017J\b\u00102\u001a\u00020\tH\u0017J\b\u00103\u001a\u00020\tH\u0017J\b\u00104\u001a\u00020\tH\u0017J\b\u00105\u001a\u00020\tH\u0017J\b\u00106\u001a\u00020\tH\u0017J\b\u00107\u001a\u00020\tH\u0017J\b\u00108\u001a\u00020\tH\u0017J\b\u00109\u001a\u00020\tH\u0017J\b\u0010:\u001a\u00020\tH\u0017J\b\u0010;\u001a\u00020\tH\u0017J\b\u0010<\u001a\u00020\tH\u0017J\b\u0010=\u001a\u00020\tH\u0017J\b\u0010>\u001a\u00020\tH\u0017J\u0010\u0010?\u001a\u00020\t2\u0006\u0010@\u001a\u00020AH\u0017J\b\u0010B\u001a\u00020\tH\u0017J\b\u0010C\u001a\u00020\tH\u0017J\b\u0010D\u001a\u00020\tH\u0017J\b\u0010E\u001a\u00020\tH\u0017J\b\u0010F\u001a\u00020\tH\u0017J\b\u0010G\u001a\u00020\tH\u0017J\b\u0010H\u001a\u00020\tH\u0017J\b\u0010I\u001a\u00020\tH\u0017J\b\u0010J\u001a\u00020\tH\u0017J\b\u0010K\u001a\u00020\tH\u0017J\b\u0010L\u001a\u00020\tH\u0017J\b\u0010M\u001a\u00020\tH\u0017J\b\u0010N\u001a\u00020\tH\u0017J\b\u0010O\u001a\u00020\tH\u0017J\b\u0010P\u001a\u00020\tH\u0017R\u0014\u0010\u0002\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0006\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0005\u00a8\u0006Q"}, d2={"Lorg/openrewrite/java/JavaTemplateTest;", "Lorg/openrewrite/test/RewriteTest;", "replaceAnnotationRecipe", "Lorg/openrewrite/Recipe;", "getReplaceAnnotationRecipe", "()Lorg/openrewrite/Recipe;", "replaceToStringWithLiteralRecipe", "getReplaceToStringWithLiteralRecipe", "addClassAnnotations", "", "addMethodAnnotations", "addVariableAnnotationsToVariableAlreadyAnnotated", "addVariableAnnotationsToVariableNotAnnotated", "afterStatementInBlock", "arrayInitializer", "assignmentNotPartOfVariableDeclaration", "assignmentWithinIfPredicate", "beforeStatementInBlock", "chainedMethodInvocationsAsNewClassArgument", "chainedMethodInvocationsAsNewClassArgument2", "dontDropTheAssert", "enumClassWithAnonymousInnerClassConstructor", "enumWithinEnum", "firstStatementInClassBlock", "firstStatementInMethodBlock", "innerEnumWithStaticMethod", "javaTemplateControlsSemiColons", "lambdaIsNewClass", "lambdaIsVariableInitializer", "lastStatementInClassBlock", "lastStatementInMethodBlock", "methodArgumentStopCommentsOnlyTerminateEnumInitializers", "methodDeclarationWithComment", "methodInvocationReplacementHasContextAboutLocalVariables", "multiDimentionalArrayInitializer", "replaceAndInterpolateMethodParameters", "replaceAnnotation", "replaceArguments", "replaceBody", "replaceClassAnnotation", "replaceClassAnnotations", "replaceClassExtends", "replaceClassImplements", "replaceClassTypeParameters", "replaceExpressionWithAnotherExpression", "replaceFieldAccessWithMethodInvocation", "replaceForEachControlIterator", "replaceForEachControlVariable", "replaceIdentifierWithMethodInvocation", "replaceLambdaParameters", "replaceLambdaWithMethodReference", "replaceMethod", "replaceMethodAnnotations", "replaceMethodDeclarationAnnotation", "replaceMethodDeclarationVariableDeclarationAnnotation", "replaceMethodInvocationWithArray", "replaceMethodInvocationWithMethodReference", "replaceMethodNameAndArgumentsSimultaneously", "replaceMethodParameters", "replaceMethodParametersVariadicArray", "replaceMethodTypeParameters", "replaceMissingBody", "replaceNamedVariableInitializerMethodInvocation", "replacePackage", "jp", "Lorg/openrewrite/java/JavaParser;", "replaceSingleExpressionInLambdaBody", "replaceSingleExpressionInLambdaBodyWithExpression", "replaceSingleStatement", "replaceStatementInBlock", "replaceStatementInLambdaBodyMultiStatementBlock", "replaceStatementInLambdaBodySingleStatementBlock", "replaceStatementInLambdaBodyWithVariableDeclaredInBlock", "replaceStatementRequiringNewImport", "replaceThrows", "replaceVariableAnnotations", "replaceVariableDeclarationAnnotation", "replacingMethodInvocationWithinEnum", "replacingMethodInvocationWithinInnerEnum", "templateStatementIsWithinTryWithResourcesBlock", "templatingWhileLoopCondition", "rewrite-java-tck"})
public interface JavaTemplateTest
extends RewriteTest {
    @NotNull
    public Recipe getReplaceToStringWithLiteralRecipe();

    @Test
    public void methodArgumentStopCommentsOnlyTerminateEnumInitializers();

    @Test
    public void enumWithinEnum();

    @Test
    public void templateStatementIsWithinTryWithResourcesBlock();

    @Test
    public void replaceIdentifierWithMethodInvocation();

    @Test
    public void replaceExpressionWithAnotherExpression();

    @Test
    public void replaceFieldAccessWithMethodInvocation();

    @Test
    public void methodInvocationReplacementHasContextAboutLocalVariables();

    @Test
    public void innerEnumWithStaticMethod();

    @Test
    public void replacePackage(@NotNull JavaParser var1);

    @Test
    public void replaceMethod();

    @Test
    public void replaceLambdaWithMethodReference();

    @Test
    public void replaceStatementInLambdaBodySingleStatementBlock();

    @Test
    public void replaceStatementInLambdaBodyWithVariableDeclaredInBlock();

    @Test
    public void replaceStatementInLambdaBodyMultiStatementBlock();

    @Test
    public void replaceSingleExpressionInLambdaBody();

    @Test
    public void replaceSingleExpressionInLambdaBodyWithExpression();

    @Test
    public void replaceMethodNameAndArgumentsSimultaneously();

    @Test
    public void replaceMethodInvocationWithArray();

    @Test
    public void replaceMethodInvocationWithMethodReference();

    @Test
    public void replaceMethodParameters();

    @Test
    public void replaceMethodParametersVariadicArray();

    @Test
    public void replaceAndInterpolateMethodParameters();

    @Test
    public void replaceLambdaParameters();

    @Test
    public void replaceSingleStatement();

    @Test
    public void replaceStatementInBlock();

    @Test
    public void beforeStatementInBlock();

    @Test
    public void afterStatementInBlock();

    @Test
    public void firstStatementInClassBlock();

    @Test
    public void firstStatementInMethodBlock();

    @Test
    public void lastStatementInClassBlock();

    @Test
    public void lastStatementInMethodBlock();

    @Test
    public void replaceStatementRequiringNewImport();

    @Test
    public void replaceArguments();

    @NotNull
    public Recipe getReplaceAnnotationRecipe();

    @Test
    public void replaceClassAnnotation();

    @Test
    public void replaceMethodDeclarationAnnotation();

    @Test
    public void replaceVariableDeclarationAnnotation();

    @Test
    public void replaceMethodDeclarationVariableDeclarationAnnotation();

    @Test
    public void replaceMethodAnnotations();

    @Test
    public void replaceClassAnnotations();

    @Test
    public void replaceVariableAnnotations();

    @Test
    public void addVariableAnnotationsToVariableAlreadyAnnotated();

    @Test
    public void addVariableAnnotationsToVariableNotAnnotated();

    @Test
    public void addMethodAnnotations();

    @Test
    public void addClassAnnotations();

    @Test
    public void replaceAnnotation();

    @Test
    public void replaceClassImplements();

    @Test
    public void replaceClassExtends();

    @Test
    public void replaceThrows();

    @Disabled
    @Test
    public void replaceMethodTypeParameters();

    @Test
    public void replaceClassTypeParameters();

    @Test
    public void replaceBody();

    @Test
    public void replaceMissingBody();

    @Test
    public void replaceNamedVariableInitializerMethodInvocation();

    @Test
    public void lambdaIsVariableInitializer();

    @Test
    public void methodDeclarationWithComment();

    @Test
    public void assignmentNotPartOfVariableDeclaration();

    @Test
    public void assignmentWithinIfPredicate();

    @Test
    public void lambdaIsNewClass();

    @Test
    public void replaceForEachControlVariable();

    @Test
    public void replaceForEachControlIterator();

    @Test
    public void chainedMethodInvocationsAsNewClassArgument();

    @Test
    public void chainedMethodInvocationsAsNewClassArgument2();

    @Test
    public void templatingWhileLoopCondition();

    @Test
    public void javaTemplateControlsSemiColons();

    @Test
    public void enumClassWithAnonymousInnerClassConstructor();

    @Test
    public void replacingMethodInvocationWithinEnum();

    @Test
    public void replacingMethodInvocationWithinInnerEnum();

    @Test
    public void arrayInitializer();

    @Test
    public void multiDimentionalArrayInitializer();

    @Test
    public void dontDropTheAssert();

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @NotNull
        public static Recipe getReplaceToStringWithLiteralRecipe(@NotNull JavaTemplateTest this_) {
            Recipe recipe2 = RewriteTest.toRecipe(DefaultImpls::_get_replaceToStringWithLiteralRecipe_$lambda-0);
            Intrinsics.checkNotNullExpressionValue((Object)recipe2, (String)"toRecipe{object : JavaVi\u2026\n            }\n        }}");
            return recipe2;
        }

        @Test
        public static void methodArgumentStopCommentsOnlyTerminateEnumInitializers(@NotNull JavaTemplateTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.io.File;\n            import java.io.IOException;\n            import java.util.List;\n            \n            class Test {\n                File getFile(File testDir, List<String> compileClassPath ) throws IOException {\n                    assertEquals(new File(testDir, \"ejbs/target/classes\").getCanonicalFile(),\n                        new File(compileClassPath.get(1).toString()).getCanonicalFile());\n                }\n                void assertEquals(File f1, File f2) {}\n            }\n        ", (String)"\n            import java.io.File;\n            import java.io.IOException;\n            import java.util.List;\n            \n            class Test {\n                File getFile(File testDir, List<String> compileClassPath ) throws IOException {\n                    assertEquals(new File(testDir, \"ejbs/target/classes\").getCanonicalFile(),\n                        new File(compileClassPath.get(1)).getCanonicalFile());\n                }\n                void assertEquals(File f1, File f2) {}\n            }\n        ")};
            this_.rewriteRun(arg_0 -> DefaultImpls.methodArgumentStopCommentsOnlyTerminateEnumInitializers$lambda-1(this_, arg_0), sourceSpecsArray);
        }

        @Test
        public static void enumWithinEnum(@NotNull JavaTemplateTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            public enum Test {\n                INSTANCE;\n                public enum MatchMode { DEFAULT }\n                public String doSomething() {\n                    return \"STARTING\".toString();\n                }\n            }\n        ", (String)"\n            public enum Test {\n                INSTANCE;\n                public enum MatchMode { DEFAULT }\n                public String doSomething() {\n                    return \"STARTING\";\n                }\n            }\n        ")};
            this_.rewriteRun(arg_0 -> DefaultImpls.enumWithinEnum$lambda-2(this_, arg_0), sourceSpecsArray);
        }

        @Test
        public static void templateStatementIsWithinTryWithResourcesBlock(@NotNull JavaTemplateTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.io.*;\n            import java.nio.charset.StandardCharsets;\n            \n            class Test {\n                ByteArrayInputStream createBis(byte[] bytes) {\n                    return new ByteArrayInputStream(bytes);\n                }\n                \n                void doSomething() {\n                    String sout = \"\";\n                    try (BufferedReader br = new BufferedReader(new FileReader(null))) {\n                        new ByteArrayInputStream(\"bytes\".getBytes(StandardCharsets.UTF_8));\n                    } catch (IOException e) {\n                        e.printStackTrace();\n                    }\n                }\n            }\n        ", (String)"\n            import java.io.*;\n            import java.nio.charset.StandardCharsets;\n            \n            class Test {\n                ByteArrayInputStream createBis(byte[] bytes) {\n                    return new ByteArrayInputStream(bytes);\n                }\n                \n                void doSomething() {\n                    String sout = \"\";\n                    try (BufferedReader br = new BufferedReader(new FileReader(null))) {\n                        createBis(\"bytes\".getBytes(StandardCharsets.UTF_8));\n                    } catch (IOException e) {\n                        e.printStackTrace();\n                    }\n                }\n            }\n        ")};
            this_.rewriteRun(DefaultImpls::templateStatementIsWithinTryWithResourcesBlock$lambda-4, sourceSpecsArray);
        }

        @Test
        public static void replaceIdentifierWithMethodInvocation(@NotNull JavaTemplateTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.io.File;\n            class Test {\n                void test(File f) {\n                    System.out.println(f);\n                }\n            }\n        ", (String)"\n            import java.io.File;\n            class Test {\n                void test(File f) {\n                    System.out.println(f.getCanonicalFile().toPath());\n                }\n            }\n        ")};
            this_.rewriteRun(DefaultImpls::replaceIdentifierWithMethodInvocation$lambda-6, sourceSpecsArray);
        }

        @Test
        public static void replaceExpressionWithAnotherExpression(@NotNull JavaTemplateTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                void test(int i) {\n                    int n = +i;\n                }\n            }\n        ", (String)"\n            class Test {\n                void test(int i) {\n                    int n = i++;\n                }\n            }\n        ")};
            this_.rewriteRun(DefaultImpls::replaceExpressionWithAnotherExpression$lambda-8, sourceSpecsArray);
        }

        @Test
        public static void replaceFieldAccessWithMethodInvocation(@NotNull JavaTemplateTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.io.File;\n            class Test {\n                File f;\n                void test() {\n                    System.out.println(this.f);\n                }\n            }\n        ", (String)"\n            import java.io.File;\n            class Test {\n                File f;\n                void test() {\n                    System.out.println(this.f.getCanonicalFile().toPath());\n                }\n            }\n        ")};
            this_.rewriteRun(DefaultImpls::replaceFieldAccessWithMethodInvocation$lambda-10, sourceSpecsArray);
        }

        @Test
        public static void methodInvocationReplacementHasContextAboutLocalVariables(@NotNull JavaTemplateTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.util.List;\n            class Test {\n                List<String> words;\n                void test() {\n                    words.clear();\n                }\n            }\n        ", (String)"\n            import java.util.List;\n            class Test {\n                List<String> words;\n                void test() {\n                    words.add(\"jon\");\n                }\n            }\n        ")};
            this_.rewriteRun(DefaultImpls::methodInvocationReplacementHasContextAboutLocalVariables$lambda-12, sourceSpecsArray);
        }

        @Test
        public static void innerEnumWithStaticMethod(@NotNull JavaTemplateTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class A {\n                public enum Type {\n                    One;\n            \n                    public Type(String t) {\n                    }\n            \n                    String t;\n            \n                    public static Type fromType(String type) {\n                        return null;\n                    }\n                }\n            \n                public A(Type type) {}\n                public A() {}\n            \n                public void method(Type type) {\n                    new A(type);\n                }\n            }\n        ", (String)"\n            class A {\n                public enum Type {\n                    One;\n            \n                    public Type(String t) {\n                    }\n            \n                    String t;\n            \n                    public static Type fromType(String type) {\n                        return null;\n                    }\n                }\n            \n                public A(Type type) {}\n                public A() {}\n            \n                public void method(Type type) {\n                    new A();\n                }\n            }\n        ")};
            this_.rewriteRun(DefaultImpls::innerEnumWithStaticMethod$lambda-14, sourceSpecsArray);
        }

        @Test
        public static void replacePackage(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            package a;\n            class Test {\n            }\n        ", (String)"\n            package b;\n            class Test {\n            }\n        ")};
            this_.rewriteRun(DefaultImpls::replacePackage$lambda-16, sourceSpecsArray);
        }

        @Test
        public static void replaceMethod(@NotNull JavaTemplateTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                void test() {\n                }\n            }\n        ", (String)"\n            class Test {\n            \n                int test2(int n) {\n                    return n;\n                }\n            }\n        ")};
            this_.rewriteRun(DefaultImpls::replaceMethod$lambda-19, sourceSpecsArray);
        }

        @Test
        public static void replaceLambdaWithMethodReference(@NotNull JavaTemplateTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.util.function.Function;\n\n            class Test {\n                Function<Object, String> toString = it -> it.toString();\n            }\n        ", (String)"\n            import java.util.function.Function;\n\n            class Test {\n                Function<Object, String> toString = Object::toString;\n            }\n        ")};
            this_.rewriteRun(DefaultImpls::replaceLambdaWithMethodReference$lambda-21, sourceSpecsArray);
        }

        @Test
        public static void replaceStatementInLambdaBodySingleStatementBlock(@NotNull JavaTemplateTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.util.stream.Stream;\n\n            class Test {\n                int n;\n\n                void method(Stream<Object> obj) {\n                    obj.filter(o -> {\n                        return n == 0;\n                    });\n                }\n            }\n        ", (String)"\n            import java.util.stream.Stream;\n\n            class Test {\n                int n;\n\n                void method(Stream<Object> obj) {\n                    obj.filter(o -> {\n                        return n == 1;\n                    });\n                }\n            }\n        ")};
            this_.rewriteRun(DefaultImpls::replaceStatementInLambdaBodySingleStatementBlock$lambda-23, sourceSpecsArray);
        }

        @Test
        public static void replaceStatementInLambdaBodyWithVariableDeclaredInBlock(@NotNull JavaTemplateTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.util.stream.Stream;\n\n            class Test {\n                static void method(Stream<Object> obj) {\n                    obj.filter(o -> {\n                        int n = 0;\n                        return n == 0;\n                    });\n                }\n            }\n        ", (String)"\n            import java.util.stream.Stream;\n\n            class Test {\n                static void method(Stream<Object> obj) {\n                    obj.filter(o -> {\n                        int n = 0;\n                        return n == 1;\n                    });\n                }\n            }\n        ")};
            this_.rewriteRun(DefaultImpls::replaceStatementInLambdaBodyWithVariableDeclaredInBlock$lambda-25, sourceSpecsArray);
        }

        @Test
        public static void replaceStatementInLambdaBodyMultiStatementBlock(@NotNull JavaTemplateTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.util.stream.Stream;\n\n            class Test {\n                static void method(Stream<String> obj) {\n                    obj.map(o -> {\n                        String str = o;\n                        str = o.toLowerCase();\n                        return str;\n                    });\n                }\n            }\n        ", (String)"\n            import java.util.stream.Stream;\n\n            class Test {\n                static void method(Stream<String> obj) {\n                    obj.map(o -> {\n                        String str = o;\n                        str = o.toUpperCase();\n                        return str;\n                    });\n                }\n            }\n        ")};
            this_.rewriteRun(DefaultImpls::replaceStatementInLambdaBodyMultiStatementBlock$lambda-27, sourceSpecsArray);
        }

        @Test
        public static void replaceSingleExpressionInLambdaBody(@NotNull JavaTemplateTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.util.stream.Stream;\n\n            class Test {\n                static void method(Stream<String> obj) {\n                    obj.filter(o -> o.toLowerCase().length() > 0);\n                }\n            }\n        ", (String)"\n            import java.util.stream.Stream;\n\n            class Test {\n                static void method(Stream<String> obj) {\n                    obj.filter(o -> o.toUpperCase().length() > 0);\n                }\n            }\n        ")};
            this_.rewriteRun(DefaultImpls::replaceSingleExpressionInLambdaBody$lambda-29, sourceSpecsArray);
        }

        @Test
        public static void replaceSingleExpressionInLambdaBodyWithExpression(@NotNull JavaTemplateTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.util.stream.Stream;\n\n            class Test {\n                enum Abc {A,B,C}\n                static void method(Stream<Abc> obj) {\n                    Object a = obj.filter(o -> o.equals(Abc.A));\n                }\n            }\n        ", (String)"\n            import java.util.stream.Stream;\n\n            class Test {\n                enum Abc {A,B,C}\n                static void method(Stream<Abc> obj) {\n                    Object a = obj.filter(o -> o == Abc.A);\n                }\n            }\n        ")};
            this_.rewriteRun(DefaultImpls::replaceSingleExpressionInLambdaBodyWithExpression$lambda-31, sourceSpecsArray);
        }

        @Test
        public static void replaceMethodNameAndArgumentsSimultaneously(@NotNull JavaTemplateTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n                package org.openrewrite;\n                public class A {\n                    public A acceptInteger(Integer i) { return this; }\n                    public A acceptString(String s) { return this; }\n                    public A someOtherMethod() { return this; }\n                }\n            "), Assertions.java((String)"\n            package org.openrewrite;\n            \n            public class Foo {\n                {\n                    Integer i = 1;\n                    new A().someOtherMethod()\n                            .acceptInteger(i)\n                            .someOtherMethod();\n                }\n            }\n        ", (String)"\n            package org.openrewrite;\n            \n            public class Foo {\n                {\n                    Integer i = 1;\n                    new A().someOtherMethod()\n                            .acceptString(i.toString())\n                            .someOtherMethod();\n                }\n            }\n        ")};
            this_.rewriteRun(DefaultImpls::replaceMethodNameAndArgumentsSimultaneously$lambda-33, sourceSpecsArray);
        }

        @Test
        public static void replaceMethodInvocationWithArray(@NotNull JavaTemplateTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            package org.openrewrite;\n            public class Test {\n                public void method(int[] val) {}\n                public void method(int[] val1, String val2) {}\n            }\n        "), Assertions.java((String)"\n            import org.openrewrite.Test;\n            class A {\n                public void method() {\n                    Test test = new Test();\n                    int[] arr = new int[]{};\n                    test.method(arr, null);\n                }\n            }\n        ", (String)"\n            import org.openrewrite.Test;\n            class A {\n                public void method() {\n                    Test test = new Test();\n                    int[] arr = new int[]{};\n                    test.method(arr);\n                }\n            }\n        ")};
            this_.rewriteRun(DefaultImpls::replaceMethodInvocationWithArray$lambda-35, sourceSpecsArray);
        }

        @Test
        public static void replaceMethodInvocationWithMethodReference(@NotNull JavaTemplateTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.util.function.Function;\n\n            class Test {\n                Function<Object, String> toString = getToString();\n                \n                static Function<Object, String> getToString() {\n                    return Object::toString;\n                } \n            }\n        ", (String)"\n            import java.util.function.Function;\n\n            class Test {\n                Function<Object, String> toString = Object::toString;\n                \n                static Function<Object, String> getToString() {\n                    return Object::toString;\n                } \n            }\n        ")};
            this_.rewriteRun(DefaultImpls::replaceMethodInvocationWithMethodReference$lambda-37, sourceSpecsArray);
        }

        @Test
        public static void replaceMethodParameters(@NotNull JavaTemplateTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                void test() {\n                    new Runnable() {\n                        void inner() {\n                        }\n                        @Override \n                        public void run() {}\n                    };\n                }\n            }\n        ", (String)"\n            class Test {\n                void test(int m, java.util.List<String> n) {\n                    new Runnable() {\n                        void inner(int m, java.util.List<String> n) {\n                        }\n                        @Override \n                        public void run() {}\n                    };\n                }\n            }\n        ")};
            this_.rewriteRun(DefaultImpls::replaceMethodParameters$lambda-41, sourceSpecsArray);
        }

        @Test
        public static void replaceMethodParametersVariadicArray(@NotNull JavaTemplateTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                void test() {\n                    new Runnable() {\n                        void inner() {\n                        }\n                    };\n                }\n            }\n        ", (String)"\n            class Test {\n                void test(Object[]... values) {\n                    new Runnable() {\n                        void inner(Object[]... values) {\n                        }\n                    };\n                }\n            }\n        ")};
            this_.rewriteRun(DefaultImpls::replaceMethodParametersVariadicArray$lambda-45, sourceSpecsArray);
        }

        @Test
        public static void replaceAndInterpolateMethodParameters(@NotNull JavaTemplateTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                void test(String s) {\n                }\n            }\n        ", (String)"\n            class Test {\n                void test(int n, String s) {\n                }\n            }\n        ")};
            this_.rewriteRun(DefaultImpls::replaceAndInterpolateMethodParameters$lambda-49, sourceSpecsArray);
        }

        @Test
        public static void replaceLambdaParameters(@NotNull JavaTemplateTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                void test() {\n                    Object o = () -> 1;\n                }\n            }\n        ", (String)"\n            class Test {\n                void test() {\n                    Object o = (int m, int n) -> 1;\n                }\n            }\n        ")};
            this_.rewriteRun(DefaultImpls::replaceLambdaParameters$lambda-51, sourceSpecsArray);
        }

        @Test
        public static void replaceSingleStatement(@NotNull JavaTemplateTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                int n;\n                void test() {\n                    assert n == 0;\n                }\n            }\n        ", (String)"\n            class Test {\n                int n;\n                void test() {\n                    if (n != 1) {\n                        n++;\n                    }\n                }\n            }\n        ")};
            this_.rewriteRun(DefaultImpls::replaceSingleStatement$lambda-53, sourceSpecsArray);
        }

        @Test
        public static void replaceStatementInBlock(@NotNull JavaTemplateTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                int n;\n                void test() {\n                    n = 1;\n                    n++;\n                }\n            }\n        ", (String)"\n            class Test {\n                int n;\n                void test() {\n                    n = 1;\n                    n = 2;\n                    n = 3;\n                }\n            }\n        ")};
            this_.rewriteRun(DefaultImpls::replaceStatementInBlock$lambda-55, sourceSpecsArray);
        }

        @Test
        public static void beforeStatementInBlock(@NotNull JavaTemplateTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                int n;\n                void test() {\n                    n = 1;\n                }\n            }\n        ", (String)"\n            class Test {\n                int n;\n                void test() {\n                    assert n == 0;\n                    n = 1;\n                }\n            }\n        ")};
            this_.rewriteRun(DefaultImpls::beforeStatementInBlock$lambda-57, sourceSpecsArray);
        }

        @Test
        public static void afterStatementInBlock(@NotNull JavaTemplateTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                int n;\n                void test() {\n                    assert n == 0;\n                }\n            }\n        ", (String)"\n            class Test {\n                int n;\n                void test() {\n                    assert n == 0;\n                    n = 1;\n                }\n            }\n        ")};
            this_.rewriteRun(DefaultImpls::afterStatementInBlock$lambda-59, sourceSpecsArray);
        }

        @Test
        public static void firstStatementInClassBlock(@NotNull JavaTemplateTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                // comment\n                int n;\n            }\n        ", (String)"\n            class Test {\n                int m;\n                // comment\n                int n;\n            }\n        ")};
            this_.rewriteRun(DefaultImpls::firstStatementInClassBlock$lambda-61, sourceSpecsArray);
        }

        @Test
        public static void firstStatementInMethodBlock(@NotNull JavaTemplateTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                int n;\n                void test() {\n                    // comment\n                    int n = 1;\n                }\n            }\n        ", (String)"\n            class Test {\n                int n;\n                void test() {\n                    int m = 0;\n                    // comment\n                    int n = 1;\n                }\n            }\n        ")};
            this_.rewriteRun(DefaultImpls::firstStatementInMethodBlock$lambda-63, sourceSpecsArray);
        }

        @Test
        public static void lastStatementInClassBlock(@NotNull JavaTemplateTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n            }\n        ", (String)"\n            class Test {\n                int n;\n            }\n        ")};
            this_.rewriteRun(DefaultImpls::lastStatementInClassBlock$lambda-65, sourceSpecsArray);
        }

        @Test
        public static void lastStatementInMethodBlock(@NotNull JavaTemplateTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                int n;\n                void test() {\n                    assert n == 0;\n                }\n            }\n        ", (String)"\n            class Test {\n                int n;\n                void test() {\n                    assert n == 0;\n                    n = 1;\n                }\n            }\n        ")};
            this_.rewriteRun(DefaultImpls::lastStatementInMethodBlock$lambda-67, sourceSpecsArray);
        }

        @Test
        public static void replaceStatementRequiringNewImport(@NotNull JavaTemplateTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                int n;\n                void test() {\n                    assert n == 0;\n                }\n            }\n        ", (String)"\n            import java.util.List;\n            \n            class Test {\n                int n;\n                void test() {\n                    List<String> s = null;\n                }\n            }\n        ")};
            this_.rewriteRun(DefaultImpls::replaceStatementRequiringNewImport$lambda-69, sourceSpecsArray);
        }

        @Test
        public static void replaceArguments(@NotNull JavaTemplateTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            abstract class Test {\n                abstract void test();\n                abstract void test(int m, int n, String foo);\n                void fred(int m, int n, String foo) {\n                    test();\n                }\n            }\n        ", (String)"\n            abstract class Test {\n                abstract void test();\n                abstract void test(int m, int n, String foo);\n                void fred(int m, int n, String foo) {\n                    test(m, Integer.valueOf(n), \"foo\");\n                }\n            }\n        ")};
            this_.rewriteRun(DefaultImpls::replaceArguments$lambda-73, sourceSpecsArray);
        }

        @NotNull
        public static Recipe getReplaceAnnotationRecipe(@NotNull JavaTemplateTest this_) {
            Recipe recipe2 = RewriteTest.toRecipe(DefaultImpls::_get_replaceAnnotationRecipe_$lambda-74);
            Intrinsics.checkNotNullExpressionValue((Object)recipe2, (String)"toRecipe{object : JavaIs\u2026\n            }\n        }}");
            return recipe2;
        }

        @Test
        public static void replaceClassAnnotation(@NotNull JavaTemplateTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"@SuppressWarnings(\"ALL\") class Test {}", (String)"@Deprecated class Test {}")};
            this_.rewriteRun(arg_0 -> DefaultImpls.replaceClassAnnotation$lambda-75(this_, arg_0), sourceSpecsArray);
        }

        @Test
        public static void replaceMethodDeclarationAnnotation(@NotNull JavaTemplateTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n                class A {\n                    @SuppressWarnings(\"ALL\")\n                    void someTest() {}\n                }\n            ", (String)"\n                class A {\n                    @Deprecated\n                    void someTest() {}\n                }\n            ")};
            this_.rewriteRun(arg_0 -> DefaultImpls.replaceMethodDeclarationAnnotation$lambda-76(this_, arg_0), sourceSpecsArray);
        }

        @Test
        public static void replaceVariableDeclarationAnnotation(@NotNull JavaTemplateTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n                class A {\n                    @interface A1{}\n                    @interface A2{}\n                    \n                    @A1\n                    Object someObject;\n                }\n            ", (String)"\n                class A {\n                    @interface A1{}\n                    @interface A2{}\n                    \n                    @A2\n                    Object someObject;\n                }\n            ")};
            this_.rewriteRun(arg_0 -> DefaultImpls.replaceVariableDeclarationAnnotation$lambda-77(this_, arg_0), sourceSpecsArray);
        }

        @Test
        public static void replaceMethodDeclarationVariableDeclarationAnnotation(@NotNull JavaTemplateTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n                class A {\n                    @interface A1{}\n                    @interface A2{}\n                    \n                    void someMethod(@A1 String a){}\n                }\n            ", (String)"\n                class A {\n                    @interface A1{}\n                    @interface A2{}\n                    \n                    void someMethod(@A2 String a){}\n                }\n            ")};
            this_.rewriteRun(arg_0 -> DefaultImpls.replaceMethodDeclarationVariableDeclarationAnnotation$lambda-78(this_, arg_0), sourceSpecsArray);
        }

        @Test
        public static void replaceMethodAnnotations(@NotNull JavaTemplateTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                static final String WARNINGS = \"ALL\";\n            \n                public @SuppressWarnings(WARNINGS) Test() {\n                }\n            \n                public void test1() {\n                }\n            \n                public @SuppressWarnings(WARNINGS) void test2() {\n                }\n            }\n        ", (String)"\n            class Test {\n                static final String WARNINGS = \"ALL\";\n            \n                @SuppressWarnings(\"other\")\n                public Test() {\n                }\n            \n                @SuppressWarnings(\"other\")\n                public void test1() {\n                }\n            \n                @SuppressWarnings(\"other\")\n                public void test2() {\n                }\n            }\n        ")};
            this_.rewriteRun(DefaultImpls::replaceMethodAnnotations$lambda-80, sourceSpecsArray);
        }

        @Test
        public static void replaceClassAnnotations(@NotNull JavaTemplateTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                static final String WARNINGS = \"ALL\";\n                \n                class Inner1 {\n                }\n            }\n        ", (String)"\n            class Test {\n                static final String WARNINGS = \"ALL\";\n            \n                @SuppressWarnings(\"other\")\n                class Inner1 {\n                }\n            }\n        ")};
            this_.rewriteRun(DefaultImpls::replaceClassAnnotations$lambda-82, sourceSpecsArray);
        }

        @Test
        public static void replaceVariableAnnotations(@NotNull JavaTemplateTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                void test() {\n                    // the m\n                    int m;\n                    final @SuppressWarnings(\"ALL\") int n;\n                }\n            }\n        ", (String)"\n            class Test {\n                void test() {\n                    // the m\n                    @SuppressWarnings(\"other\")\n                    int m;\n                    @SuppressWarnings(\"other\")\n                    final int n;\n                }\n            }\n        ")};
            this_.rewriteRun(DefaultImpls::replaceVariableAnnotations$lambda-84, sourceSpecsArray);
        }

        @Test
        public static void addVariableAnnotationsToVariableAlreadyAnnotated(@NotNull JavaTemplateTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                @SuppressWarnings(\"ALL\") private final int m, a;\n                void test() {\n                    @SuppressWarnings(\"ALL\") /* hello */\n                    Boolean z;\n                    // comment n\n                    @SuppressWarnings(\"ALL\")\n                    int n;\n                    @SuppressWarnings(\"ALL\") final Boolean b;\n                    @SuppressWarnings(\"ALL\")\n                    // comment x, y\n                    private Boolean x, y;\n                }\n            }\n        ", (String)"\n            class Test {\n                @SuppressWarnings(\"ALL\")\n                @Deprecated\n                private final int m, a;\n                void test() {\n                    @SuppressWarnings(\"ALL\")\n                    @Deprecated /* hello */\n                    Boolean z;\n                    // comment n\n                    @SuppressWarnings(\"ALL\")\n                    @Deprecated\n                    int n;\n                    @SuppressWarnings(\"ALL\")\n                    @Deprecated\n                    final Boolean b;\n                    @SuppressWarnings(\"ALL\")\n                    @Deprecated\n                    // comment x, y\n                    private Boolean x, y;\n                }\n            }\n        ")};
            this_.rewriteRun(DefaultImpls::addVariableAnnotationsToVariableAlreadyAnnotated$lambda-86, sourceSpecsArray);
        }

        @Test
        public static void addVariableAnnotationsToVariableNotAnnotated(@NotNull JavaTemplateTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                void test() {\n                    final int m;\n                    int n;\n                }\n            }\n        ", (String)"\n            class Test {\n                void test() {\n                    @SuppressWarnings(\"ALL\")\n                    final int m;\n                    @SuppressWarnings(\"ALL\")\n                    int n;\n                }\n            }\n        ")};
            this_.rewriteRun(DefaultImpls::addVariableAnnotationsToVariableNotAnnotated$lambda-88, sourceSpecsArray);
        }

        @Test
        public static void addMethodAnnotations(@NotNull JavaTemplateTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                public void test0() {\n                }\n\n                static final String WARNINGS = \"ALL\";\n\n                void test1() {\n                }\n            }\n        ", (String)"\n            class Test {\n                @SuppressWarnings(\"other\")\n                public void test0() {\n                }\n\n                static final String WARNINGS = \"ALL\";\n\n                @SuppressWarnings(\"other\")\n                void test1() {\n                }\n            }\n        ")};
            this_.rewriteRun(DefaultImpls::addMethodAnnotations$lambda-90, sourceSpecsArray);
        }

        @Test
        public static void addClassAnnotations(@NotNull JavaTemplateTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                class Inner1 {\n                }\n            }\n        ", (String)"\n            class Test {\n                @SuppressWarnings(\"other\")\n                class Inner1 {\n                }\n            }\n        ")};
            this_.rewriteRun(DefaultImpls::addClassAnnotations$lambda-92, sourceSpecsArray);
        }

        @Test
        public static void replaceAnnotation(@NotNull JavaTemplateTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            @SuppressWarnings(\"ALL\")\n            class Test {\n            }\n        ", (String)"\n            @Deprecated\n            class Test {\n            }\n        ")};
            this_.rewriteRun(DefaultImpls::replaceAnnotation$lambda-94, sourceSpecsArray);
        }

        @Test
        public static void replaceClassImplements(@NotNull JavaTemplateTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n            }\n        ", (String)"\n            import java.io.Closeable;\n            import java.io.Serializable;\n            \n            class Test implements Serializable, Closeable {\n            }\n        ")};
            this_.rewriteRun(DefaultImpls::replaceClassImplements$lambda-96, sourceSpecsArray);
        }

        @Test
        public static void replaceClassExtends(@NotNull JavaTemplateTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n            }\n        ", (String)"\n            import java.util.List;\n            \n            class Test extends List<String> {\n            }\n        ")};
            this_.rewriteRun(DefaultImpls::replaceClassExtends$lambda-98, sourceSpecsArray);
        }

        @Test
        public static void replaceThrows(@NotNull JavaTemplateTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                void test() {}\n            }\n        ", (String)"\n            class Test {\n                void test() throws Exception {}\n            }\n        ")};
            this_.rewriteRun(DefaultImpls::replaceThrows$lambda-102, sourceSpecsArray);
        }

        @Disabled
        @Test
        public static void replaceMethodTypeParameters(@NotNull JavaTemplateTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.util.List;\n            \n            class Test {\n            \n                void test() {\n                }\n            }\n        ", (String)"\n            import java.util.List;\n            \n            class Test {\n            \n                <T, U> void test(List<T> t, U u) {\n                }\n            }\n        ")};
            this_.rewriteRun(DefaultImpls::replaceMethodTypeParameters$lambda-107, sourceSpecsArray);
        }

        @Test
        public static void replaceClassTypeParameters(@NotNull JavaTemplateTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n            }\n        ", (String)"\n            class Test<T, U> {\n            }\n        ")};
            this_.rewriteRun(DefaultImpls::replaceClassTypeParameters$lambda-109, sourceSpecsArray);
        }

        @Test
        public static void replaceBody(@NotNull JavaTemplateTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                int n;\n                void test() {\n                    n++;\n                }\n            }\n        ", (String)"\n            class Test {\n                int n;\n                void test() {\n                    n = 1;\n                }\n            }\n        ")};
            this_.rewriteRun(DefaultImpls::replaceBody$lambda-111, sourceSpecsArray);
        }

        @Test
        public static void replaceMissingBody(@NotNull JavaTemplateTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            abstract class Test {\n                abstract void test();\n            }\n        ", (String)"\n            abstract class Test {\n                void test(){\n                }\n            }\n        ")};
            this_.rewriteRun(DefaultImpls::replaceMissingBody$lambda-113, sourceSpecsArray);
        }

        @Test
        public static void replaceNamedVariableInitializerMethodInvocation(@NotNull JavaTemplateTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.util.Arrays;\n            import java.util.List;\n            import java.util.function.Function;\n            class Test {\n                void t() {\n                    List<String> nums = Arrays.asList(\"1\", \"2\", \"3\");\n                    nums.forEach(s -> Integer.valueOf(s));\n                }\n                void inLambda(int i) {\n                    Function<String, Integer> toString = it -> {\n                        try {\n                            return Integer.valueOf(it);\n                        }catch (NumberFormatException ex) {\n                            ex.printStackTrace();\n                        }\n                        return 0;\n                    };\n                }\n                String inClassDeclaration(int i) {\n                    return new Object() {\n                        void foo() {\n                            Integer.valueOf(i);\n                        }\n                    }.toString();\n                }\n            }\n        ", (String)"\n            import java.util.Arrays;\n            import java.util.List;\n            import java.util.function.Function;\n            class Test {\n                void t() {\n                    List<String> nums = Arrays.asList(\"1\", \"2\", \"3\");\n                    nums.forEach(s -> new Integer(s));\n                }\n                void inLambda(int i) {\n                    Function<String, Integer> toString = it -> {\n                        try {\n                            return new Integer(it);\n                        }catch (NumberFormatException ex) {\n                            ex.printStackTrace();\n                        }\n                        return 0;\n                    };\n                }\n                String inClassDeclaration(int i) {\n                    return new Object() {\n                        void foo() {\n                            new Integer(i);\n                        }\n                    }.toString();\n                }\n            }\n        ")};
            this_.rewriteRun(DefaultImpls::replaceNamedVariableInitializerMethodInvocation$lambda-115, sourceSpecsArray);
        }

        @Test
        public static void lambdaIsVariableInitializer(@NotNull JavaTemplateTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.util.function.Function;\n            class Test {\n                Function<String, Integer> asInteger = it -> Integer.valueOf(it);\n            }\n        ", (String)"\n            import java.util.function.Function;\n            class Test {\n                Function<String, Integer> asInteger = it -> new Integer(it);\n            }\n        ")};
            this_.rewriteRun(DefaultImpls::lambdaIsVariableInitializer$lambda-117, sourceSpecsArray);
        }

        @Test
        public static void methodDeclarationWithComment(@NotNull JavaTemplateTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class A {\n            \n            }\n        ", (String)"\n            class A {\n                /**\n                 * comment\n                 */\n                void foo() {\n                }\n\n            }\n        ")};
            this_.rewriteRun(DefaultImpls::methodDeclarationWithComment$lambda-119, sourceSpecsArray);
        }

        @Test
        public static void assignmentNotPartOfVariableDeclaration(@NotNull JavaTemplateTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class A {\n                void foo() {\n                    int i;\n                    i = Integer.valueOf(1);\n                }\n            }\n        ", (String)"\n            class A {\n                void foo() {\n                    int i;\n                    i = 1;\n                }\n            }\n        ")};
            this_.rewriteRun(DefaultImpls::assignmentNotPartOfVariableDeclaration$lambda-121, sourceSpecsArray);
        }

        @Test
        public static void assignmentWithinIfPredicate(@NotNull JavaTemplateTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class A {\n                void foo() {\n                    double value = 0;\n                    if ((value = 1) == 0) {}\n                }\n            }\n        ", (String)"\n            class A {\n                void foo() {\n                    double value = 0;\n                    if ((value = 0) == 0) {}\n                }\n            }\n        ")};
            this_.rewriteRun(DefaultImpls::assignmentWithinIfPredicate$lambda-123, sourceSpecsArray);
        }

        @Test
        public static void lambdaIsNewClass(@NotNull JavaTemplateTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class T {\n                public T (int a, Runnable r, String s) { }\n                static void method() {\n                    new T(1, () -> {\n                        int i;\n                        i = Integer.valueOf(1);\n                    }, \"hello\" );\n                }\n            }\n            ", (String)"\n            class T {\n                public T (int a, Runnable r, String s) { }\n                static void method() {\n                    new T(1, () -> {\n                        int i;\n                        i = 1;\n                    }, \"hello\" );\n                }\n            }\n            ")};
            this_.rewriteRun(DefaultImpls::lambdaIsNewClass$lambda-125, sourceSpecsArray);
        }

        @Test
        public static void replaceForEachControlVariable(@NotNull JavaTemplateTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.util.ArrayList;\n            class T {\n                void m() {\n                    for (String s : new ArrayList<String>()) {}\n                }\n            }\n            ", (String)"\n            import java.util.ArrayList;\n            class T {\n                void m() {\n                    for (Object s : new ArrayList<String>()) {}\n                }\n            }\n            ")};
            this_.rewriteRun(DefaultImpls::replaceForEachControlVariable$lambda-127, sourceSpecsArray);
        }

        @Test
        public static void replaceForEachControlIterator(@NotNull JavaTemplateTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.util.ArrayList;\n            import java.util.Collections;\n            class T {\n                void m() {\n                    for (String s : new ArrayList<String>()) {}\n                }\n            }\n            ", (String)"\n            import java.util.ArrayList;\n            import java.util.Collections;\n            class T {\n                void m() {\n                    for (String s : Collections.emptyList()) {}\n                }\n            }\n            ")};
            this_.rewriteRun(DefaultImpls::replaceForEachControlIterator$lambda-129, sourceSpecsArray);
        }

        @Test
        public static void chainedMethodInvocationsAsNewClassArgument(@NotNull JavaTemplateTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.util.ArrayList;\n            import java.util.Collections;\n            public class T {\n                void m(String arg) {\n                    U u = new U(arg.toString().toCharArray());\n                }\n                class U {\n                    U(char[] chars){}\n                }\n            }\n            ", (String)"\n            import java.util.ArrayList;\n            import java.util.Collections;\n            public class T {\n                void m(String arg) {\n                    U u = new U(arg.toCharArray());\n                }\n                class U {\n                    U(char[] chars){}\n                }\n            }\n            ")};
            this_.rewriteRun(arg_0 -> DefaultImpls.chainedMethodInvocationsAsNewClassArgument$lambda-130(this_, arg_0), sourceSpecsArray);
        }

        @Test
        public static void chainedMethodInvocationsAsNewClassArgument2(@NotNull JavaTemplateTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class T {\n                void m(String jsonPayload) {\n                    HttpEntity entity = new HttpEntity(jsonPayload.toString(), 0);\n                }\n                class HttpEntity {\n                    HttpEntity(String s, int i){}\n                }\n            }\n            ", (String)"\n            class T {\n                void m(String jsonPayload) {\n                    HttpEntity entity = new HttpEntity(jsonPayload, 0);\n                }\n                class HttpEntity {\n                    HttpEntity(String s, int i){}\n                }\n            }\n            ")};
            this_.rewriteRun(arg_0 -> DefaultImpls.chainedMethodInvocationsAsNewClassArgument2$lambda-131(this_, arg_0), sourceSpecsArray);
        }

        @Test
        public static void templatingWhileLoopCondition(@NotNull JavaTemplateTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.util.List;\n            class T {\n                void m(List<?> l) {\n                    while (l.size() != 0) {}\n                }\n            }\n        ", (String)"\n            import java.util.List;\n            class T {\n                void m(List<?> l) {\n                    while (!l.isEmpty()) {}\n                }\n            }\n        ")};
            this_.rewriteRun(DefaultImpls::templatingWhileLoopCondition$lambda-133, sourceSpecsArray);
        }

        @Test
        public static void javaTemplateControlsSemiColons(@NotNull JavaTemplateTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.math.BigDecimal;\n            import java.math.RoundingMode;\n            \n            class A {\n                void m() {\n                    StringBuilder sb = new StringBuilder();\n                    sb.append((new BigDecimal(0).setScale(1, BigDecimal.ROUND_HALF_UP).doubleValue())).append(\"|\");\n                }\n            }\n        ", (String)"\n            import java.math.BigDecimal;\n            import java.math.RoundingMode;\n            \n            class A {\n                void m() {\n                    StringBuilder sb = new StringBuilder();\n                    sb.append((new BigDecimal(0).setScale(1, RoundingMode.HALF_UP).doubleValue())).append(\"|\");\n                }\n            }\n        ")};
            this_.rewriteRun(DefaultImpls::javaTemplateControlsSemiColons$lambda-135, sourceSpecsArray);
        }

        @Test
        public static void enumClassWithAnonymousInnerClassConstructor(@NotNull JavaTemplateTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            enum MyEnum {\n                THING_ONE(new MyEnumThing() {\n                    @Override \n                    public String getName() {\n                        return \"Thing One\".toString();\n                    }\n                });\n                private final MyEnumThing enumThing;\n                MyEnum(MyEnumThing myEnumThing) {\n                    this.enumThing = myEnumThing;\n                }\n                interface MyEnumThing {\n                    String getName();\n                }\n            }\n            ", (String)"\n            enum MyEnum {\n                THING_ONE(new MyEnumThing() {\n                    @Override \n                    public String getName() {\n                        return \"Thing One\";\n                    }\n                });\n                private final MyEnumThing enumThing;\n                MyEnum(MyEnumThing myEnumThing) {\n                    this.enumThing = myEnumThing;\n                }\n                interface MyEnumThing {\n                    String getName();\n                }\n            }\n            ")};
            this_.rewriteRun(arg_0 -> DefaultImpls.enumClassWithAnonymousInnerClassConstructor$lambda-136(this_, arg_0), sourceSpecsArray);
        }

        @Test
        public static void replacingMethodInvocationWithinEnum(@NotNull JavaTemplateTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            public enum Options {\n            \n                JAR(\"instance.jar.file\"),\n                JVM_ARGUMENTS(\"instance.vm.args\");\n            \n                private String name;\n            \n                Options(String name) {\n                    this.name = name;\n                }\n            \n                public String asString() {\n                    return System.getProperty(name);\n                }\n                \n                public Integer asInteger(int defaultValue) {\n                    String string  = asString();\n                    return new Integer(string.toString());\n                }\n            \n            }\n        ", (String)"\n            public enum Options {\n            \n                JAR(\"instance.jar.file\"),\n                JVM_ARGUMENTS(\"instance.vm.args\");\n            \n                private String name;\n            \n                Options(String name) {\n                    this.name = name;\n                }\n            \n                public String asString() {\n                    return System.getProperty(name);\n                }\n                \n                public Integer asInteger(int defaultValue) {\n                    String string  = asString();\n                    return new Integer(string);\n                }\n            \n            }\n        ")};
            this_.rewriteRun(arg_0 -> DefaultImpls.replacingMethodInvocationWithinEnum$lambda-137(this_, arg_0), sourceSpecsArray);
        }

        @Test
        public static void replacingMethodInvocationWithinInnerEnum(@NotNull JavaTemplateTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            public class Test {\n                void doSomething(Options options) {\n                    switch (options) {\n                        case JAR:\n                        case JVM_ARGUMENTS:\n                            System.out.println(\"\");\n                    }\n                }\n                enum Options {\n                    JAR(0, \"instance.jar.file\".toString()),\n                    JVM_ARGUMENTS(1, \"instance.vm.args\");\n                \n                    private final String name;\n                    private final int id;\n                \n                    Options(int id,String name) {\n                        this.id = id;\n                        this.name = name;\n                    }\n                \n                    public String asString() {\n                        return System.getProperty(name);\n                    }\n                    \n                    public Integer asInteger(int defaultValue) {\n                        String string  = asString();\n                        return new Integer(string);\n                    }\n                }\n            }\n        ", (String)"\n            public class Test {\n                void doSomething(Options options) {\n                    switch (options) {\n                        case JAR:\n                        case JVM_ARGUMENTS:\n                            System.out.println(\"\");\n                    }\n                }\n                enum Options {\n                    JAR(0, \"instance.jar.file\"),\n                    JVM_ARGUMENTS(1, \"instance.vm.args\");\n                \n                    private final String name;\n                    private final int id;\n                \n                    Options(int id,String name) {\n                        this.id = id;\n                        this.name = name;\n                    }\n                \n                    public String asString() {\n                        return System.getProperty(name);\n                    }\n                    \n                    public Integer asInteger(int defaultValue) {\n                        String string  = asString();\n                        return new Integer(string);\n                    }\n                }\n            }\n        ")};
            this_.rewriteRun(arg_0 -> DefaultImpls.replacingMethodInvocationWithinInnerEnum$lambda-138(this_, arg_0), sourceSpecsArray);
        }

        @Test
        public static void arrayInitializer(@NotNull JavaTemplateTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            package abc;\n            \n            public class ArrayHelper {\n                public static Object[] of(Object... objects){ return null;}\n            }\n        "), Assertions.java((String)"\n            import abc.ArrayHelper;\n            import java.util.Arrays;\n            \n            class A {\n                Object[] o = new Object[] {\n                    ArrayHelper.of(1, 2, 3)\n                };\n            }\n        ", (String)"\n            import abc.ArrayHelper;\n            import java.util.Arrays;\n            \n            class A {\n                Object[] o = new Object[] {\n                        Arrays.asList(1, 2, 3)\n                };\n            }\n        ")};
            this_.rewriteRun(DefaultImpls::arrayInitializer$lambda-140, sourceSpecsArray);
        }

        @Test
        public static void multiDimentionalArrayInitializer(@NotNull JavaTemplateTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class A {\n                Integer[][] num2 = new Integer[][]{ {new Integer(1), new Integer(2)}, {new Integer(1), new Integer(2)} };\n            }\n        ", (String)"\n            class A {\n                Integer[][] num2 = new Integer[][]{ {Integer.valueOf(1), Integer.valueOf(2)}, {Integer.valueOf(1), Integer.valueOf(2)} };\n            }\n        ")};
            this_.rewriteRun(DefaultImpls::multiDimentionalArrayInitializer$lambda-142, sourceSpecsArray);
        }

        @Test
        public static void dontDropTheAssert(@NotNull JavaTemplateTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.util.Collection;\n            \n            class Test {\n                void doSomething(Collection<Object> c) {\n                    assert c.size() > 0;\n                }\n            }\n        ", (String)"\n            import java.util.Collection;\n            \n            class Test {\n                void doSomething(Collection<Object> c) {\n                    assert !c.isEmpty();\n                }\n            }\n        ")};
            this_.rewriteRun(DefaultImpls::dontDropTheAssert$lambda-144, sourceSpecsArray);
        }

        private static TreeVisitor _get_replaceToStringWithLiteralRecipe_$lambda-0() {
            return (TreeVisitor)new JavaVisitor<ExecutionContext>(){
                @NotNull
                private MethodMatcher TO_STRING;
                private final JavaTemplate t;
                {
                    this.TO_STRING = new MethodMatcher("java.lang.String toString()");
                    this.t = JavaTemplate.builder(() -> replaceToStringWithLiteralRecipe.1.1.t$lambda-0(this), (String)"#{any(java.lang.String)}").build();
                }

                @NotNull
                public J visitMethodInvocation(@NotNull J.MethodInvocation method, @NotNull ExecutionContext ctx) {
                    Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                    Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                    J j = super.visitMethodInvocation(method, (Object)ctx);
                    if (j == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J");
                    }
                    J mi = j;
                    if (mi instanceof J.MethodInvocation && this.TO_STRING.matches((J.MethodInvocation)mi)) {
                        Object[] objectArray = new Object[]{((J.MethodInvocation)mi).getSelect()};
                        J j2 = mi.withTemplate((SourceTemplate)this.t, ((J.MethodInvocation)mi).getCoordinates().replace(), objectArray);
                        Intrinsics.checkNotNullExpressionValue((Object)j2, (String)"mi.withTemplate(t, mi.co\u2026tes.replace(), mi.select)");
                        return j2;
                    }
                    return mi;
                }

                private static final Cursor t$lambda-0(replaceToStringWithLiteralRecipe.1.1 this$0) {
                    Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                    return this$0.getCursor();
                }
            };
        }

        private static void methodArgumentStopCommentsOnlyTerminateEnumInitializers$lambda-1(JavaTemplateTest this$0, RecipeSpec spec) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            spec.recipe(this$0.getReplaceToStringWithLiteralRecipe());
        }

        private static void enumWithinEnum$lambda-2(JavaTemplateTest this$0, RecipeSpec spec) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            spec.recipe(this$0.getReplaceToStringWithLiteralRecipe());
        }

        private static TreeVisitor templateStatementIsWithinTryWithResourcesBlock$lambda-4$lambda-3() {
            return (TreeVisitor)new JavaVisitor<ExecutionContext>(){

                @NotNull
                public J visitNewClass(@NotNull J.NewClass newClass, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)newClass, (String)"newClass");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    J nc = super.visitNewClass(newClass, (Object)p);
                    J.MethodDeclaration md = (J.MethodDeclaration)this.getCursor().firstEnclosing(J.MethodDeclaration.class);
                    if (md != null && md.getSimpleName().equals("createBis")) {
                        J j = nc;
                        Intrinsics.checkNotNullExpressionValue((Object)j, (String)"nc");
                        return j;
                    }
                    if (newClass.getType() != null) {
                        JavaType javaType = newClass.getType();
                        if (javaType == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.JavaType.Class");
                        }
                        if (((JavaType.Class)javaType).getFullyQualifiedName().equals("java.io.ByteArrayInputStream")) {
                            List list = newClass.getArguments();
                            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"newClass.arguments");
                            if (!((Collection)list).isEmpty()) {
                                Object[] objectArray = new Object[]{newClass.getArguments().get(0)};
                                nc = nc.withTemplate((SourceTemplate)JavaTemplate.builder(() -> templateStatementIsWithinTryWithResourcesBlock.1.1.1.visitNewClass$lambda-0(this), (String)"createBis(#{anyArray()})").build(), newClass.getCoordinates().replace(), objectArray);
                            }
                        }
                    }
                    J j = nc;
                    Intrinsics.checkNotNullExpressionValue((Object)j, (String)"nc");
                    return j;
                }

                private static final Cursor visitNewClass$lambda-0(templateStatementIsWithinTryWithResourcesBlock.1.1.1 this$0) {
                    Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                    return this$0.getCursor();
                }
            };
        }

        private static void templateStatementIsWithinTryWithResourcesBlock$lambda-4(RecipeSpec spec) {
            spec.recipe(RewriteTest.toRecipe(DefaultImpls::templateStatementIsWithinTryWithResourcesBlock$lambda-4$lambda-3));
        }

        private static TreeVisitor replaceIdentifierWithMethodInvocation$lambda-6$lambda-5() {
            return (TreeVisitor)new JavaVisitor<ExecutionContext>(){

                @NotNull
                public J visitMethodDeclaration(@NotNull J.MethodDeclaration method, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    Tree tree = this.visit((Tree)method.getBody(), p);
                    if (tree == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Block");
                    }
                    J.MethodDeclaration methodDeclaration2 = method.withBody((J.Block)tree);
                    Intrinsics.checkNotNullExpressionValue((Object)methodDeclaration2, (String)"method.withBody(visit(method.body, p) as J.Block)");
                    return (J)methodDeclaration2;
                }

                @NotNull
                public J visitIdentifier(@NotNull J.Identifier identifier, @NotNull ExecutionContext p) {
                    J j;
                    Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    if (Intrinsics.areEqual((Object)identifier.getSimpleName(), (Object)"f")) {
                        Object[] objectArray = new Object[]{identifier};
                        J j2 = identifier.withTemplate((SourceTemplate)JavaTemplate.builder(() -> replaceIdentifierWithMethodInvocation.1.1.1.visitIdentifier$lambda-0(this), (String)"#{any(java.io.File)}.getCanonicalFile().toPath()").build(), identifier.getCoordinates().replace(), objectArray);
                        j = j2;
                        Intrinsics.checkNotNullExpressionValue((Object)j2, (String)"{\n                      \u2026  )\n                    }");
                    } else {
                        j = (J)identifier;
                    }
                    return j;
                }

                private static final Cursor visitIdentifier$lambda-0(replaceIdentifierWithMethodInvocation.1.1.1 this$0) {
                    Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                    return this$0.getCursor();
                }
            };
        }

        private static void replaceIdentifierWithMethodInvocation$lambda-6(RecipeSpec spec) {
            spec.recipe(RewriteTest.toRecipe(DefaultImpls::replaceIdentifierWithMethodInvocation$lambda-6$lambda-5)).expectedCyclesThatMakeChanges(1).cycles(1);
        }

        private static TreeVisitor replaceExpressionWithAnotherExpression$lambda-8$lambda-7() {
            return (TreeVisitor)new JavaVisitor<ExecutionContext>(){

                @NotNull
                public J visitUnary(@NotNull J.Unary unary, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)unary, (String)"unary");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    Object[] objectArray = new Object[]{unary.getExpression()};
                    J j = unary.withTemplate((SourceTemplate)JavaTemplate.builder(() -> replaceExpressionWithAnotherExpression.1.1.1.visitUnary$lambda-0(this), (String)"#{any()}++").build(), unary.getCoordinates().replace(), objectArray);
                    Intrinsics.checkNotNullExpressionValue((Object)j, (String)"unary.withTemplate(\n    \u2026ion\n                    )");
                    return j;
                }

                private static final Cursor visitUnary$lambda-0(replaceExpressionWithAnotherExpression.1.1.1 this$0) {
                    Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                    return this$0.getCursor();
                }
            };
        }

        private static void replaceExpressionWithAnotherExpression$lambda-8(RecipeSpec spec) {
            spec.recipe(RewriteTest.toRecipe(DefaultImpls::replaceExpressionWithAnotherExpression$lambda-8$lambda-7)).expectedCyclesThatMakeChanges(1).cycles(1);
        }

        private static TreeVisitor replaceFieldAccessWithMethodInvocation$lambda-10$lambda-9() {
            return (TreeVisitor)new JavaVisitor<ExecutionContext>(){

                @NotNull
                public J visitMethodDeclaration(@NotNull J.MethodDeclaration method, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    Tree tree = this.visit((Tree)method.getBody(), p);
                    if (tree == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Block");
                    }
                    J.MethodDeclaration methodDeclaration2 = method.withBody((J.Block)tree);
                    Intrinsics.checkNotNullExpressionValue((Object)methodDeclaration2, (String)"method.withBody(visit(method.body, p) as J.Block)");
                    return (J)methodDeclaration2;
                }

                @NotNull
                public J visitFieldAccess(@NotNull J.FieldAccess fa, @NotNull ExecutionContext p) {
                    J j;
                    Intrinsics.checkNotNullParameter((Object)fa, (String)"fa");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    if (Intrinsics.areEqual((Object)fa.getSimpleName(), (Object)"f")) {
                        Object[] objectArray = new Object[]{fa};
                        J j2 = fa.withTemplate((SourceTemplate)JavaTemplate.builder(() -> replaceFieldAccessWithMethodInvocation.1.1.1.visitFieldAccess$lambda-0(this), (String)"#{any(java.io.File)}.getCanonicalFile().toPath()").build(), fa.getCoordinates().replace(), objectArray);
                        j = j2;
                        Intrinsics.checkNotNullExpressionValue((Object)j2, (String)"{\n                      \u2026  )\n                    }");
                    } else {
                        j = (J)fa;
                    }
                    return j;
                }

                private static final Cursor visitFieldAccess$lambda-0(replaceFieldAccessWithMethodInvocation.1.1.1 this$0) {
                    Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                    return this$0.getCursor();
                }
            };
        }

        private static void replaceFieldAccessWithMethodInvocation$lambda-10(RecipeSpec spec) {
            spec.recipe(RewriteTest.toRecipe(DefaultImpls::replaceFieldAccessWithMethodInvocation$lambda-10$lambda-9)).expectedCyclesThatMakeChanges(1).cycles(1);
        }

        private static TreeVisitor methodInvocationReplacementHasContextAboutLocalVariables$lambda-12$lambda-11() {
            return (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

                @NotNull
                public J.MethodInvocation visitMethodInvocation(@NotNull J.MethodInvocation method, @NotNull ExecutionContext ctx) {
                    J.MethodInvocation methodInvocation2;
                    Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                    Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                    if (Intrinsics.areEqual((Object)method.getSimpleName(), (Object)"clear")) {
                        J j = method.withTemplate((SourceTemplate)JavaTemplate.builder(() -> methodInvocationReplacementHasContextAboutLocalVariables.1.1.1.visitMethodInvocation$lambda-0(this), (String)"words.add(\"jon\");").build(), method.getCoordinates().replace(), new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)j, (String)"{\n                      \u2026  )\n                    }");
                        methodInvocation2 = (J.MethodInvocation)j;
                    } else {
                        methodInvocation2 = method;
                    }
                    return methodInvocation2;
                }

                private static final Cursor visitMethodInvocation$lambda-0(methodInvocationReplacementHasContextAboutLocalVariables.1.1.1 this$0) {
                    Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                    return this$0.getCursor();
                }
            };
        }

        private static void methodInvocationReplacementHasContextAboutLocalVariables$lambda-12(RecipeSpec spec) {
            spec.recipe(RewriteTest.toRecipe(DefaultImpls::methodInvocationReplacementHasContextAboutLocalVariables$lambda-12$lambda-11));
        }

        private static TreeVisitor innerEnumWithStaticMethod$lambda-14$lambda-13() {
            return (TreeVisitor)new JavaVisitor<ExecutionContext>(){
                private final JavaTemplate t;
                {
                    this.t = JavaTemplate.builder(() -> innerEnumWithStaticMethod.1.1.1.t$lambda-0(this), (String)"new A()").build();
                }

                public final JavaTemplate getT() {
                    return this.t;
                }

                @NotNull
                public J visitNewClass(@NotNull J.NewClass newClass, @NotNull ExecutionContext p) {
                    J j;
                    Intrinsics.checkNotNullParameter((Object)newClass, (String)"newClass");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    if ((Expression)newClass.getArguments().get(0) instanceof J.Empty) {
                        j = (J)newClass;
                    } else {
                        J j2 = newClass.withTemplate((SourceTemplate)this.t, newClass.getCoordinates().replace(), new Object[0]);
                        j = j2;
                        Intrinsics.checkNotNullExpressionValue((Object)j2, (String)"newClass.withTemplate(t,\u2026ss.coordinates.replace())");
                    }
                    return j;
                }

                private static final Cursor t$lambda-0(innerEnumWithStaticMethod.1.1.1 this$0) {
                    Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                    return this$0.getCursor().getParentOrThrow();
                }
            };
        }

        private static void innerEnumWithStaticMethod$lambda-14(RecipeSpec spec) {
            spec.recipe(RewriteTest.toRecipe(DefaultImpls::innerEnumWithStaticMethod$lambda-14$lambda-13));
        }

        private static TreeVisitor replacePackage$lambda-16$lambda-15() {
            return (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){
                private final JavaTemplate t;
                {
                    this.t = JavaTemplate.builder(() -> replacePackage.1.1.1.t$lambda-0(this), (String)"b").build();
                }

                public final JavaTemplate getT() {
                    return this.t;
                }

                @NotNull
                public J.Package visitPackage(@NotNull J.Package pkg, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)pkg, (String)"pkg");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    if (Intrinsics.areEqual((Object)pkg.getExpression().printTrimmed(this.getCursor()), (Object)"a")) {
                        J j = pkg.withTemplate((SourceTemplate)this.t, pkg.getCoordinates().replace(), new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)j, (String)"pkg.withTemplate(t, pkg.coordinates.replace())");
                        return (J.Package)j;
                    }
                    J.Package package_ = super.visitPackage(pkg, (Object)p);
                    Intrinsics.checkNotNullExpressionValue((Object)package_, (String)"super.visitPackage(pkg, p)");
                    return package_;
                }

                @NotNull
                public J.ClassDeclaration visitClassDeclaration(@NotNull J.ClassDeclaration classDecl, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)classDecl, (String)"classDecl");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    J.ClassDeclaration cd = super.visitClassDeclaration(classDecl, (Object)p);
                    JavaType.FullyQualified fullyQualified = classDecl.getType();
                    Intrinsics.checkNotNull((Object)fullyQualified);
                    if (Intrinsics.areEqual((Object)fullyQualified.getPackageName(), (Object)"a")) {
                        JavaType.FullyQualified fullyQualified2 = cd.getType();
                        Intrinsics.checkNotNull((Object)fullyQualified2);
                        cd = cd.withType((JavaType)fullyQualified2.withFullyQualifiedName("b." + cd.getSimpleName()));
                    }
                    J.ClassDeclaration classDeclaration = cd;
                    Intrinsics.checkNotNullExpressionValue((Object)classDeclaration, (String)"cd");
                    return classDeclaration;
                }

                private static final Cursor t$lambda-0(replacePackage.1.1.1 this$0) {
                    Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                    return this$0.getCursor().getParentOrThrow();
                }
            };
        }

        private static void replacePackage$lambda-16(RecipeSpec spec) {
            spec.recipe(RewriteTest.toRecipe(DefaultImpls::replacePackage$lambda-16$lambda-15));
        }

        private static TreeVisitor replaceMethod$lambda-19$lambda-17() {
            return (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){
                private final JavaTemplate t;
                {
                    this.t = JavaTemplate.builder(() -> replaceMethod.1.1.1.t$lambda-0(this), (String)"int test2(int n) { return n; }").build();
                }

                public final JavaTemplate getT() {
                    return this.t;
                }

                @NotNull
                public J.MethodDeclaration visitMethodDeclaration(@NotNull J.MethodDeclaration method, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    if (Intrinsics.areEqual((Object)method.getSimpleName(), (Object)"test")) {
                        J j = method.withTemplate((SourceTemplate)this.t, method.getCoordinates().replace(), new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)j, (String)"method.withTemplate(t, m\u2026od.coordinates.replace())");
                        return (J.MethodDeclaration)j;
                    }
                    J.MethodDeclaration methodDeclaration2 = super.visitMethodDeclaration(method, (Object)p);
                    Intrinsics.checkNotNullExpressionValue((Object)methodDeclaration2, (String)"super.visitMethodDeclaration(method, p)");
                    return methodDeclaration2;
                }

                private static final Cursor t$lambda-0(replaceMethod.1.1.1 this$0) {
                    Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                    return this$0.getCursor().getParentOrThrow();
                }
            };
        }

        private static void replaceMethod$lambda-19$lambda-18(RecipeRun it) {
            SourceFile sourceFile = ((Result)it.getResults().get(0)).getAfter();
            if (sourceFile == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.CompilationUnit");
            }
            J.CompilationUnit cu = (J.CompilationUnit)sourceFile;
            List list = cu.getClasses();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"cu.classes");
            List list2 = ((J.ClassDeclaration)CollectionsKt.first((List)list)).getBody().getStatements();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"cu.classes.first().body.statements");
            Object object = CollectionsKt.first((List)list2);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            JavaType.Method method = ((J.MethodDeclaration)object).getMethodType();
            Intrinsics.checkNotNull((Object)method);
            JavaType.Method methodType = method;
            org.assertj.core.api.Assertions.assertThat((Object)methodType.getReturnType()).isEqualTo((Object)JavaType.Primitive.Int);
            Object[] objectArray = new JavaType[]{(JavaType)JavaType.Primitive.Int};
            org.assertj.core.api.Assertions.assertThat((List)methodType.getParameterTypes()).containsExactly(objectArray);
        }

        private static void replaceMethod$lambda-19(RecipeSpec spec) {
            spec.recipe(RewriteTest.toRecipe(DefaultImpls::replaceMethod$lambda-19$lambda-17)).afterRecipe(DefaultImpls::replaceMethod$lambda-19$lambda-18);
        }

        private static TreeVisitor replaceLambdaWithMethodReference$lambda-21$lambda-20() {
            return (TreeVisitor)new JavaVisitor<ExecutionContext>(){
                private final JavaTemplate t;
                {
                    this.t = JavaTemplate.builder(() -> replaceLambdaWithMethodReference.1.1.1.t$lambda-0(this), (String)"Object::toString").build();
                }

                public final JavaTemplate getT() {
                    return this.t;
                }

                @NotNull
                public J visitLambda(@NotNull J.Lambda lambda2, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)lambda2, (String)"lambda");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    J j = lambda2.withTemplate((SourceTemplate)this.t, lambda2.getCoordinates().replace(), new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)j, (String)"lambda.withTemplate(t, l\u2026da.coordinates.replace())");
                    return j;
                }

                private static final Cursor t$lambda-0(replaceLambdaWithMethodReference.1.1.1 this$0) {
                    Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                    return this$0.getCursor().getParentOrThrow();
                }
            };
        }

        private static void replaceLambdaWithMethodReference$lambda-21(RecipeSpec spec) {
            spec.recipe(RewriteTest.toRecipe(DefaultImpls::replaceLambdaWithMethodReference$lambda-21$lambda-20));
        }

        private static TreeVisitor replaceStatementInLambdaBodySingleStatementBlock$lambda-23$lambda-22() {
            return (TreeVisitor)new JavaVisitor<ExecutionContext>(){
                private final JavaTemplate t;
                {
                    this.t = JavaTemplate.builder(() -> replaceStatementInLambdaBodySingleStatementBlock.1.1.1.t$lambda-0(this), (String)"return n == 1;").build();
                }

                public final JavaTemplate getT() {
                    return this.t;
                }

                @NotNull
                public J visitReturn(@NotNull J.Return retrn, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)retrn, (String)"retrn");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    if (retrn.getExpression() instanceof J.Binary) {
                        Expression expression = retrn.getExpression();
                        if (expression == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Binary");
                        }
                        J.Binary binary2 = (J.Binary)expression;
                        if (binary2.getRight() instanceof J.Literal) {
                            Expression expression2 = binary2.getRight();
                            if (expression2 == null) {
                                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Literal");
                            }
                            if (Intrinsics.areEqual((Object)0, (Object)((J.Literal)expression2).getValue())) {
                                J j = retrn.withTemplate((SourceTemplate)this.t, retrn.getCoordinates().replace(), new Object[0]);
                                Intrinsics.checkNotNullExpressionValue((Object)j, (String)"retrn.withTemplate(t, retrn.coordinates.replace())");
                                return j;
                            }
                        }
                    }
                    return (J)retrn;
                }

                private static final Cursor t$lambda-0(replaceStatementInLambdaBodySingleStatementBlock.1.1.1 this$0) {
                    Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                    return this$0.getCursor().getParentOrThrow();
                }
            };
        }

        private static void replaceStatementInLambdaBodySingleStatementBlock$lambda-23(RecipeSpec spec) {
            spec.recipe(RewriteTest.toRecipe(DefaultImpls::replaceStatementInLambdaBodySingleStatementBlock$lambda-23$lambda-22));
        }

        private static TreeVisitor replaceStatementInLambdaBodyWithVariableDeclaredInBlock$lambda-25$lambda-24() {
            return (TreeVisitor)new JavaVisitor<ExecutionContext>(){
                private final JavaTemplate t;
                {
                    this.t = JavaTemplate.builder(() -> replaceStatementInLambdaBodyWithVariableDeclaredInBlock.1.1.1.t$lambda-0(this), (String)"return n == 1;").build();
                }

                public final JavaTemplate getT() {
                    return this.t;
                }

                @NotNull
                public J visitReturn(@NotNull J.Return retrn, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)retrn, (String)"retrn");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    if (retrn.getExpression() instanceof J.Binary) {
                        Expression expression = retrn.getExpression();
                        if (expression == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Binary");
                        }
                        J.Binary binary2 = (J.Binary)expression;
                        if (binary2.getRight() instanceof J.Literal) {
                            Expression expression2 = binary2.getRight();
                            if (expression2 == null) {
                                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Literal");
                            }
                            if (Intrinsics.areEqual((Object)0, (Object)((J.Literal)expression2).getValue())) {
                                J j = retrn.withTemplate((SourceTemplate)this.t, retrn.getCoordinates().replace(), new Object[0]);
                                Intrinsics.checkNotNullExpressionValue((Object)j, (String)"retrn.withTemplate(t, retrn.coordinates.replace())");
                                return j;
                            }
                        }
                    }
                    return (J)retrn;
                }

                private static final Cursor t$lambda-0(replaceStatementInLambdaBodyWithVariableDeclaredInBlock.1.1.1 this$0) {
                    Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                    return this$0.getCursor().getParentOrThrow();
                }
            };
        }

        private static void replaceStatementInLambdaBodyWithVariableDeclaredInBlock$lambda-25(RecipeSpec spec) {
            spec.recipe(RewriteTest.toRecipe(DefaultImpls::replaceStatementInLambdaBodyWithVariableDeclaredInBlock$lambda-25$lambda-24));
        }

        private static TreeVisitor replaceStatementInLambdaBodyMultiStatementBlock$lambda-27$lambda-26() {
            return (TreeVisitor)new JavaVisitor<ExecutionContext>(){
                private final JavaTemplate t;
                {
                    this.t = JavaTemplate.builder(() -> replaceStatementInLambdaBodyMultiStatementBlock.1.1.1.t$lambda-0(this), (String)"#{any(java.lang.String)}.toUpperCase()").build();
                }

                public final JavaTemplate getT() {
                    return this.t;
                }

                @NotNull
                public J visitMethodInvocation(@NotNull J.MethodInvocation method, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    if (method.getSimpleName().equals("toLowerCase")) {
                        Object[] objectArray = new Object[]{method.getSelect()};
                        J j = method.withTemplate((SourceTemplate)this.t, method.getCoordinates().replace(), objectArray);
                        Intrinsics.checkNotNullExpressionValue((Object)j, (String)"method.withTemplate(t, m\u2026replace(), method.select)");
                        return j;
                    }
                    J j = super.visitMethodInvocation(method, (Object)p);
                    Intrinsics.checkNotNullExpressionValue((Object)j, (String)"super.visitMethodInvocation(method, p)");
                    return j;
                }

                private static final Cursor t$lambda-0(replaceStatementInLambdaBodyMultiStatementBlock.1.1.1 this$0) {
                    Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                    return this$0.getCursor().getParentOrThrow();
                }
            };
        }

        private static void replaceStatementInLambdaBodyMultiStatementBlock$lambda-27(RecipeSpec spec) {
            spec.recipe(RewriteTest.toRecipe(DefaultImpls::replaceStatementInLambdaBodyMultiStatementBlock$lambda-27$lambda-26));
        }

        private static TreeVisitor replaceSingleExpressionInLambdaBody$lambda-29$lambda-28() {
            return (TreeVisitor)new JavaVisitor<ExecutionContext>(){
                private final JavaTemplate t;
                {
                    this.t = JavaTemplate.builder(() -> replaceSingleExpressionInLambdaBody.1.1.1.t$lambda-0(this), (String)"#{any(java.lang.String)}.toUpperCase()").build();
                }

                public final JavaTemplate getT() {
                    return this.t;
                }

                @NotNull
                public J visitMethodInvocation(@NotNull J.MethodInvocation method, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    if (method.getSimpleName().equals("toLowerCase")) {
                        Object[] objectArray = new Object[]{method.getSelect()};
                        J j = method.withTemplate((SourceTemplate)this.t, method.getCoordinates().replace(), objectArray);
                        Intrinsics.checkNotNullExpressionValue((Object)j, (String)"method.withTemplate(t, m\u2026replace(), method.select)");
                        return j;
                    }
                    J j = super.visitMethodInvocation(method, (Object)p);
                    Intrinsics.checkNotNullExpressionValue((Object)j, (String)"super.visitMethodInvocation(method, p)");
                    return j;
                }

                private static final Cursor t$lambda-0(replaceSingleExpressionInLambdaBody.1.1.1 this$0) {
                    Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                    return this$0.getCursor().getParentOrThrow();
                }
            };
        }

        private static void replaceSingleExpressionInLambdaBody$lambda-29(RecipeSpec spec) {
            spec.recipe(RewriteTest.toRecipe(DefaultImpls::replaceSingleExpressionInLambdaBody$lambda-29$lambda-28));
        }

        private static TreeVisitor replaceSingleExpressionInLambdaBodyWithExpression$lambda-31$lambda-30() {
            return (TreeVisitor)new JavaVisitor<ExecutionContext>(){
                @NotNull
                private final MethodMatcher ENUM_EQUALS;
                private final JavaTemplate t;
                {
                    this.ENUM_EQUALS = new MethodMatcher("java.lang.Enum equals(java.lang.Object)");
                    this.t = JavaTemplate.builder(() -> replaceSingleExpressionInLambdaBodyWithExpression.1.1.1.t$lambda-0(this), (String)"#{any()} == #{any()}").build();
                }

                @NotNull
                public final MethodMatcher getENUM_EQUALS() {
                    return this.ENUM_EQUALS;
                }

                public final JavaTemplate getT() {
                    return this.t;
                }

                @NotNull
                public J visitMethodInvocation(@NotNull J.MethodInvocation method, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    if (this.ENUM_EQUALS.matches(method)) {
                        Object[] objectArray = new Object[]{method.getSelect(), method.getArguments().get(0)};
                        J j = method.withTemplate((SourceTemplate)this.t, method.getCoordinates().replace(), objectArray);
                        Intrinsics.checkNotNullExpressionValue((Object)j, (String)"method.withTemplate(t, m\u2026ect, method.arguments[0])");
                        return j;
                    }
                    J j = super.visitMethodInvocation(method, (Object)p);
                    Intrinsics.checkNotNullExpressionValue((Object)j, (String)"super.visitMethodInvocation(method, p)");
                    return j;
                }

                private static final Cursor t$lambda-0(replaceSingleExpressionInLambdaBodyWithExpression.1.1.1 this$0) {
                    Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                    return this$0.getCursor().getParentOrThrow();
                }
            };
        }

        private static void replaceSingleExpressionInLambdaBodyWithExpression$lambda-31(RecipeSpec spec) {
            spec.recipe(RewriteTest.toRecipe(DefaultImpls::replaceSingleExpressionInLambdaBodyWithExpression$lambda-31$lambda-30));
        }

        private static TreeVisitor replaceMethodNameAndArgumentsSimultaneously$lambda-33$lambda-32() {
            return (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){
                private final JavaTemplate t;
                {
                    this.t = JavaTemplate.builder(() -> replaceMethodNameAndArgumentsSimultaneously.1.1.1.t$lambda-0(this), (String)"acceptString(#{any()}.toString())").javaParser(replaceMethodNameAndArgumentsSimultaneously.1.1.1::t$lambda-1).build();
                }

                public final JavaTemplate getT() {
                    return this.t;
                }

                @NotNull
                public J.MethodInvocation visitMethodInvocation(@NotNull J.MethodInvocation method, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    J.MethodInvocation methodInvocation2 = super.visitMethodInvocation(method, (Object)p);
                    Intrinsics.checkNotNullExpressionValue((Object)methodInvocation2, (String)"super.visitMethodInvocation(method, p)");
                    J.MethodInvocation m = methodInvocation2;
                    if (m.getSimpleName().equals("acceptInteger")) {
                        Object[] objectArray = new Object[]{m.getArguments().get(0)};
                        J j = m.withTemplate((SourceTemplate)this.t, m.getCoordinates().replaceMethod(), objectArray);
                        Intrinsics.checkNotNullExpressionValue((Object)j, (String)"m.withTemplate(t, m.coor\u2026Method(), m.arguments[0])");
                        m = (J.MethodInvocation)j;
                    }
                    return m;
                }

                private static final Cursor t$lambda-0(replaceMethodNameAndArgumentsSimultaneously.1.1.1 this$0) {
                    Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                    return this$0.getCursor().getParentOrThrow();
                }

                private static final JavaParser t$lambda-1() {
                    String[] stringArray = new String[]{"\n                            package org.openrewrite;\n                            public class A {\n                                public A acceptInteger(Integer i) { return this; }\n                                public A acceptString(String s) { return this; }\n                                public A someOtherMethod() { return this; }\n                            }\n                        "};
                    return JavaParser.fromJavaVersion().dependsOn(stringArray).build();
                }
            };
        }

        private static void replaceMethodNameAndArgumentsSimultaneously$lambda-33(RecipeSpec spec) {
            spec.recipe(RewriteTest.toRecipe(DefaultImpls::replaceMethodNameAndArgumentsSimultaneously$lambda-33$lambda-32));
        }

        private static TreeVisitor replaceMethodInvocationWithArray$lambda-35$lambda-34() {
            return (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){
                private final JavaTemplate t;
                {
                    this.t = JavaTemplate.builder(() -> replaceMethodInvocationWithArray.1.1.1.t$lambda-0(this), (String)"#{anyArray(int)}").build();
                }

                public final JavaTemplate getT() {
                    return this.t;
                }

                @NotNull
                public J.MethodInvocation visitMethodInvocation(@NotNull J.MethodInvocation method, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    J.MethodInvocation methodInvocation2 = super.visitMethodInvocation(method, (Object)p);
                    Intrinsics.checkNotNullExpressionValue((Object)methodInvocation2, (String)"super.visitMethodInvocation(method, p)");
                    J.MethodInvocation m = methodInvocation2;
                    if (m.getSimpleName().equals("method") && m.getArguments().size() == 2) {
                        Object[] objectArray = new Object[]{m.getArguments().get(0)};
                        J j = m.withTemplate((SourceTemplate)this.t, m.getCoordinates().replaceArguments(), objectArray);
                        Intrinsics.checkNotNullExpressionValue((Object)j, (String)"m.withTemplate(t, m.coor\u2026uments(), m.arguments[0])");
                        m = (J.MethodInvocation)j;
                    }
                    return m;
                }

                private static final Cursor t$lambda-0(replaceMethodInvocationWithArray.1.1.1 this$0) {
                    Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                    return this$0.getCursor().getParentOrThrow();
                }
            };
        }

        private static void replaceMethodInvocationWithArray$lambda-35(RecipeSpec spec) {
            spec.recipe(RewriteTest.toRecipe(DefaultImpls::replaceMethodInvocationWithArray$lambda-35$lambda-34));
        }

        private static TreeVisitor replaceMethodInvocationWithMethodReference$lambda-37$lambda-36() {
            return (TreeVisitor)new JavaVisitor<ExecutionContext>(){
                private final JavaTemplate t;
                {
                    this.t = JavaTemplate.builder(() -> replaceMethodInvocationWithMethodReference.1.1.1.t$lambda-0(this), (String)"Object::toString").build();
                }

                public final JavaTemplate getT() {
                    return this.t;
                }

                @NotNull
                public J visitMethodInvocation(@NotNull J.MethodInvocation method, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    J j = method.withTemplate((SourceTemplate)this.t, method.getCoordinates().replace(), new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)j, (String)"method.withTemplate(t, m\u2026od.coordinates.replace())");
                    return j;
                }

                private static final Cursor t$lambda-0(replaceMethodInvocationWithMethodReference.1.1.1 this$0) {
                    Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                    return this$0.getCursor().getParentOrThrow();
                }
            };
        }

        private static void replaceMethodInvocationWithMethodReference$lambda-37(RecipeSpec spec) {
            spec.recipe(RewriteTest.toRecipe(DefaultImpls::replaceMethodInvocationWithMethodReference$lambda-37$lambda-36));
        }

        private static TreeVisitor replaceMethodParameters$lambda-41$lambda-38() {
            return (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){
                private final JavaTemplate t;
                {
                    this.t = JavaTemplate.builder(() -> replaceMethodParameters.1.1.1.t$lambda-0(this), (String)"int m, java.util.List<String> n").build();
                }

                public final JavaTemplate getT() {
                    return this.t;
                }

                @NotNull
                public J.MethodDeclaration visitMethodDeclaration(@NotNull J.MethodDeclaration method, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    if (Intrinsics.areEqual((Object)method.getSimpleName(), (Object)"test") && method.getParameters().size() == 1) {
                        J j = method.withTemplate((SourceTemplate)this.t, method.getCoordinates().replaceParameters(), new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)j, (String)"method.withTemplate(t, m\u2026ates.replaceParameters())");
                        J.MethodDeclaration m = (J.MethodDeclaration)j;
                        J.Block block2 = method.getBody();
                        Intrinsics.checkNotNull((Object)block2);
                        E e = block2.getStatements().get(0);
                        if (e == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.NewClass");
                        }
                        J.NewClass newRunnable = (J.NewClass)e;
                        J.Block block3 = newRunnable.getBody();
                        Intrinsics.checkNotNull((Object)block3);
                        E e2 = block3.getStatements().get(0);
                        if (e2 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
                        }
                        J.MethodDeclaration innerMethod = (J.MethodDeclaration)e2;
                        J j2 = m.withTemplate((SourceTemplate)this.t, innerMethod.getCoordinates().replaceParameters(), new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)j2, (String)"m.withTemplate(t, innerM\u2026ates.replaceParameters())");
                        return (J.MethodDeclaration)j2;
                    }
                    J.MethodDeclaration methodDeclaration2 = super.visitMethodDeclaration(method, (Object)p);
                    Intrinsics.checkNotNullExpressionValue((Object)methodDeclaration2, (String)"super.visitMethodDeclaration(method, p)");
                    return methodDeclaration2;
                }

                private static final Cursor t$lambda-0(replaceMethodParameters.1.1.1 this$0) {
                    Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                    return this$0.getCursor().getParentOrThrow();
                }
            };
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static boolean replaceMethodParameters$lambda-41$lambda-40$lambda-39(JavaType it) {
            if (!(it instanceof JavaType.Parameterized)) return false;
            if (!Intrinsics.areEqual((Object)((JavaType.Parameterized)it).getType().getFullyQualifiedName(), (Object)"java.util.List")) return false;
            if (((JavaType.Parameterized)it).getTypeParameters().size() != 1) return false;
            List list = ((JavaType.Parameterized)it).getTypeParameters();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"it.typeParameters");
            JavaType.FullyQualified fullyQualified = TestKt.asFullyQualified((JavaType)CollectionsKt.first((List)list));
            Intrinsics.checkNotNull((Object)fullyQualified);
            if (!Intrinsics.areEqual((Object)fullyQualified.getFullyQualifiedName(), (Object)"java.lang.String")) return false;
            return true;
        }

        private static void replaceMethodParameters$lambda-41$lambda-40(RecipeRun it) {
            SourceFile sourceFile = ((Result)it.getResults().get(0)).getAfter();
            if (sourceFile == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.CompilationUnit");
            }
            J.CompilationUnit cu = (J.CompilationUnit)sourceFile;
            List list = cu.getClasses();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"cu.classes");
            List list2 = ((J.ClassDeclaration)CollectionsKt.first((List)list)).getBody().getStatements();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"cu.classes.first().body.statements");
            Object object = CollectionsKt.first((List)list2);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            JavaType.Method method = ((J.MethodDeclaration)object).getMethodType();
            Intrinsics.checkNotNull((Object)method);
            JavaType.Method type = method;
            Object[] objectArray = new String[]{"m", "n"};
            ((ListAssert)org.assertj.core.api.Assertions.assertThat((List)type.getParameterNames()).as("Changing the method's parameters should have also updated its type's parameter names", new Object[0])).containsExactly(objectArray);
            ((ObjectAssert)org.assertj.core.api.Assertions.assertThat(type.getParameterTypes().get(0)).as("Changing the method's parameters should have resulted in the first parameter's type being 'int'", new Object[0])).isEqualTo((Object)JavaType.Primitive.Int);
            org.assertj.core.api.Assertions.assertThat(type.getParameterTypes().get(1)).matches(DefaultImpls::replaceMethodParameters$lambda-41$lambda-40$lambda-39, "Changing the method's parameters should have resulted in the second parameter's type being 'List<String>'");
        }

        private static void replaceMethodParameters$lambda-41(RecipeSpec spec) {
            spec.recipe(RewriteTest.toRecipe(DefaultImpls::replaceMethodParameters$lambda-41$lambda-38)).afterRecipe(DefaultImpls::replaceMethodParameters$lambda-41$lambda-40);
        }

        private static TreeVisitor replaceMethodParametersVariadicArray$lambda-45$lambda-42() {
            return (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){
                private final JavaTemplate t;
                {
                    this.t = JavaTemplate.builder(() -> replaceMethodParametersVariadicArray.1.1.1.t$lambda-0(this), (String)"Object[]... values").build();
                }

                public final JavaTemplate getT() {
                    return this.t;
                }

                @NotNull
                public J.MethodDeclaration visitMethodDeclaration(@NotNull J.MethodDeclaration method, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    if (Intrinsics.areEqual((Object)method.getSimpleName(), (Object)"test")) {
                        List list = method.getParameters();
                        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"method.parameters");
                        if (CollectionsKt.firstOrNull((List)list) instanceof J.Empty) {
                            J j = method.withTemplate((SourceTemplate)this.t, method.getCoordinates().replaceParameters(), new Object[0]);
                            Intrinsics.checkNotNullExpressionValue((Object)j, (String)"method.withTemplate(t, m\u2026ates.replaceParameters())");
                            J.MethodDeclaration m = (J.MethodDeclaration)j;
                            J.Block block2 = method.getBody();
                            Intrinsics.checkNotNull((Object)block2);
                            E e = block2.getStatements().get(0);
                            if (e == null) {
                                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.NewClass");
                            }
                            J.NewClass newRunnable = (J.NewClass)e;
                            J.Block block3 = newRunnable.getBody();
                            Intrinsics.checkNotNull((Object)block3);
                            E e2 = block3.getStatements().get(0);
                            if (e2 == null) {
                                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
                            }
                            J.MethodDeclaration innerMethod = (J.MethodDeclaration)e2;
                            J j2 = m.withTemplate((SourceTemplate)this.t, innerMethod.getCoordinates().replaceParameters(), new Object[0]);
                            Intrinsics.checkNotNullExpressionValue((Object)j2, (String)"m.withTemplate(t, innerM\u2026ates.replaceParameters())");
                            return (J.MethodDeclaration)j2;
                        }
                    }
                    J.MethodDeclaration methodDeclaration2 = super.visitMethodDeclaration(method, (Object)p);
                    Intrinsics.checkNotNullExpressionValue((Object)methodDeclaration2, (String)"super.visitMethodDeclaration(method, p)");
                    return methodDeclaration2;
                }

                private static final Cursor t$lambda-0(replaceMethodParametersVariadicArray.1.1.1 this$0) {
                    Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                    return this$0.getCursor().getParentOrThrow();
                }
            };
        }

        private static boolean replaceMethodParametersVariadicArray$lambda-45$lambda-44$lambda-43(JavaType it) {
            JavaType.Array array2 = TestKt.asArray(it);
            Intrinsics.checkNotNull((Object)array2);
            JavaType.FullyQualified fullyQualified = TestKt.asFullyQualified(array2.getElemType());
            return Intrinsics.areEqual((Object)(fullyQualified != null ? fullyQualified.getFullyQualifiedName() : null), (Object)"java.lang.Object");
        }

        private static void replaceMethodParametersVariadicArray$lambda-45$lambda-44(RecipeRun it) {
            SourceFile sourceFile = ((Result)it.getResults().get(0)).getAfter();
            if (sourceFile == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.CompilationUnit");
            }
            J.CompilationUnit cu = (J.CompilationUnit)sourceFile;
            List list = cu.getClasses();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"cu.classes");
            List list2 = ((J.ClassDeclaration)CollectionsKt.first((List)list)).getBody().getStatements();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"cu.classes.first().body.statements");
            Object object = CollectionsKt.first((List)list2);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            JavaType.Method method = ((J.MethodDeclaration)object).getMethodType();
            Intrinsics.checkNotNull((Object)method);
            JavaType.Method type = method;
            Object[] objectArray = new String[]{"values"};
            ((ListAssert)org.assertj.core.api.Assertions.assertThat((List)type.getParameterNames()).as("Changing the method's parameters should have also updated its type's parameter names", new Object[0])).containsExactly(objectArray);
            JavaType param = (JavaType)type.getParameterTypes().get(0);
            JavaType.Array array2 = TestKt.asArray(param);
            Intrinsics.checkNotNull((Object)array2);
            ((ObjectAssert)org.assertj.core.api.Assertions.assertThat((Object)array2.getElemType()).as("Changing the method's parameters should have resulted in the first parameter's type being 'Object[]'", new Object[0])).matches(DefaultImpls::replaceMethodParametersVariadicArray$lambda-45$lambda-44$lambda-43);
        }

        private static void replaceMethodParametersVariadicArray$lambda-45(RecipeSpec spec) {
            spec.recipe(RewriteTest.toRecipe(DefaultImpls::replaceMethodParametersVariadicArray$lambda-45$lambda-42)).afterRecipe(DefaultImpls::replaceMethodParametersVariadicArray$lambda-45$lambda-44);
        }

        private static TreeVisitor replaceAndInterpolateMethodParameters$lambda-49$lambda-46() {
            return (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){
                private final JavaTemplate t;
                {
                    this.t = JavaTemplate.builder(() -> replaceAndInterpolateMethodParameters.1.1.1.t$lambda-0(this), (String)"int n, #{}").build();
                }

                public final JavaTemplate getT() {
                    return this.t;
                }

                @NotNull
                public J.MethodDeclaration visitMethodDeclaration(@NotNull J.MethodDeclaration method, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    if (Intrinsics.areEqual((Object)method.getSimpleName(), (Object)"test") && method.getParameters().size() == 1) {
                        Object[] objectArray = new Object[]{method.getParameters().get(0)};
                        J j = method.withTemplate((SourceTemplate)this.t, method.getCoordinates().replaceParameters(), objectArray);
                        Intrinsics.checkNotNullExpressionValue((Object)j, (String)"method.withTemplate(\n   \u2026                        )");
                        return (J.MethodDeclaration)j;
                    }
                    return method;
                }

                private static final Cursor t$lambda-0(replaceAndInterpolateMethodParameters.1.1.1 this$0) {
                    Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                    return this$0.getCursor().getParentOrThrow();
                }
            };
        }

        private static boolean replaceAndInterpolateMethodParameters$lambda-49$lambda-48$lambda-47(JavaType it) {
            JavaType.FullyQualified fullyQualified = TestKt.asFullyQualified(it);
            Intrinsics.checkNotNull((Object)fullyQualified);
            return Intrinsics.areEqual((Object)fullyQualified.getFullyQualifiedName(), (Object)"java.lang.String");
        }

        private static void replaceAndInterpolateMethodParameters$lambda-49$lambda-48(RecipeRun it) {
            SourceFile sourceFile = ((Result)it.getResults().get(0)).getAfter();
            if (sourceFile == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.CompilationUnit");
            }
            J.CompilationUnit cu = (J.CompilationUnit)sourceFile;
            List list = cu.getClasses();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"cu.classes");
            List list2 = ((J.ClassDeclaration)CollectionsKt.first((List)list)).getBody().getStatements();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"cu.classes.first().body.statements");
            Object object = CollectionsKt.first((List)list2);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            JavaType.Method method = ((J.MethodDeclaration)object).getMethodType();
            Intrinsics.checkNotNull((Object)method);
            JavaType.Method type = method;
            Object[] objectArray = new String[]{"n", "s"};
            ((ListAssert)org.assertj.core.api.Assertions.assertThat((List)type.getParameterNames()).as("Changing the method's parameters should have also updated its type's parameter names", new Object[0])).containsExactly(objectArray);
            ((ObjectAssert)org.assertj.core.api.Assertions.assertThat(type.getParameterTypes().get(0)).as("Changing the method's parameters should have resulted in the first parameter's type being 'int'", new Object[0])).isEqualTo((Object)JavaType.Primitive.Int);
            ((ObjectAssert)org.assertj.core.api.Assertions.assertThat(type.getParameterTypes().get(1)).as("Changing the method's parameters should have resulted in the second parameter's type being 'List<String>'", new Object[0])).matches(DefaultImpls::replaceAndInterpolateMethodParameters$lambda-49$lambda-48$lambda-47);
        }

        private static void replaceAndInterpolateMethodParameters$lambda-49(RecipeSpec spec) {
            spec.recipe(RewriteTest.toRecipe(DefaultImpls::replaceAndInterpolateMethodParameters$lambda-49$lambda-46)).afterRecipe(DefaultImpls::replaceAndInterpolateMethodParameters$lambda-49$lambda-48);
        }

        private static TreeVisitor replaceLambdaParameters$lambda-51$lambda-50() {
            return (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){
                private final JavaTemplate t;
                {
                    this.t = JavaTemplate.builder(() -> replaceLambdaParameters.1.1.1.t$lambda-0(this), (String)"int m, int n").build();
                }

                public final JavaTemplate getT() {
                    return this.t;
                }

                @NotNull
                public J.Lambda visitLambda(@NotNull J.Lambda lambda2, @NotNull ExecutionContext p) {
                    J.Lambda lambda3;
                    Intrinsics.checkNotNullParameter((Object)lambda2, (String)"lambda");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    if (lambda2.getParameters().getParameters().size() == 1) {
                        J j = lambda2.withTemplate((SourceTemplate)this.t, lambda2.getParameters().getCoordinates().replace(), new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)j, (String)"{\n                      \u2026())\n                    }");
                        lambda3 = (J.Lambda)j;
                    } else {
                        J.Lambda lambda4 = super.visitLambda(lambda2, (Object)p);
                        lambda3 = lambda4;
                        Intrinsics.checkNotNullExpressionValue((Object)lambda4, (String)"{\n                      \u2026 p)\n                    }");
                    }
                    return lambda3;
                }

                private static final Cursor t$lambda-0(replaceLambdaParameters.1.1.1 this$0) {
                    Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                    return this$0.getCursor().getParentOrThrow();
                }
            };
        }

        private static void replaceLambdaParameters$lambda-51(RecipeSpec spec) {
            spec.recipe(RewriteTest.toRecipe(DefaultImpls::replaceLambdaParameters$lambda-51$lambda-50));
        }

        private static TreeVisitor replaceSingleStatement$lambda-53$lambda-52() {
            return (TreeVisitor)new JavaVisitor<ExecutionContext>(){
                private final JavaTemplate t;
                {
                    this.t = JavaTemplate.builder(() -> replaceSingleStatement.1.1.1.t$lambda-0(this), (String)"if(n != 1) {\n  n++;\n}").build();
                }

                public final JavaTemplate getT() {
                    return this.t;
                }

                @NotNull
                public J visitAssert(@NotNull J.Assert _assert, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)_assert, (String)"_assert");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    J j = _assert.withTemplate((SourceTemplate)this.t, _assert.getCoordinates().replace(), new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)j, (String)"_assert.withTemplate(t, \u2026rt.coordinates.replace())");
                    return j;
                }

                private static final Cursor t$lambda-0(replaceSingleStatement.1.1.1 this$0) {
                    Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                    return this$0.getCursor().getParentOrThrow();
                }
            };
        }

        private static void replaceSingleStatement$lambda-53(RecipeSpec spec) {
            spec.recipe(RewriteTest.toRecipe(DefaultImpls::replaceSingleStatement$lambda-53$lambda-52));
        }

        private static TreeVisitor replaceStatementInBlock$lambda-55$lambda-54() {
            return (TreeVisitor)new JavaVisitor<ExecutionContext>(){
                private final JavaTemplate t;
                {
                    this.t = JavaTemplate.builder(() -> replaceStatementInBlock.1.1.1.t$lambda-0(this), (String)"n = 2;\nn = 3;").build();
                }

                public final JavaTemplate getT() {
                    return this.t;
                }

                @NotNull
                public J visitMethodDeclaration(@NotNull J.MethodDeclaration method, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    J.Block block2 = method.getBody();
                    Intrinsics.checkNotNull((Object)block2);
                    Statement statement = (Statement)block2.getStatements().get(1);
                    if (statement instanceof J.Unary) {
                        J j = method.withTemplate((SourceTemplate)this.t, ((J.Unary)statement).getCoordinates().replace(), new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)j, (String)"method.withTemplate(t, s\u2026nt.coordinates.replace())");
                        return j;
                    }
                    return (J)method;
                }

                private static final Cursor t$lambda-0(replaceStatementInBlock.1.1.1 this$0) {
                    Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                    return this$0.getCursor().getParentOrThrow();
                }
            };
        }

        private static void replaceStatementInBlock$lambda-55(RecipeSpec spec) {
            spec.recipe(RewriteTest.toRecipe(DefaultImpls::replaceStatementInBlock$lambda-55$lambda-54));
        }

        private static TreeVisitor beforeStatementInBlock$lambda-57$lambda-56() {
            return (TreeVisitor)new JavaVisitor<ExecutionContext>(){
                private final JavaTemplate t;
                {
                    this.t = JavaTemplate.builder(() -> beforeStatementInBlock.1.1.1.t$lambda-0(this), (String)"assert n == 0;").build();
                }

                public final JavaTemplate getT() {
                    return this.t;
                }

                @NotNull
                public J visitMethodDeclaration(@NotNull J.MethodDeclaration method, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    J.Block block2 = method.getBody();
                    Intrinsics.checkNotNull((Object)block2);
                    Statement statement = (Statement)block2.getStatements().get(0);
                    if (statement instanceof J.Assignment) {
                        J j = method.withTemplate((SourceTemplate)this.t, ((J.Assignment)statement).getCoordinates().before(), new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)j, (String)"method.withTemplate(t, s\u2026ent.coordinates.before())");
                        return j;
                    }
                    return (J)method;
                }

                private static final Cursor t$lambda-0(beforeStatementInBlock.1.1.1 this$0) {
                    Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                    return this$0.getCursor().getParentOrThrow();
                }
            };
        }

        private static void beforeStatementInBlock$lambda-57(RecipeSpec spec) {
            spec.recipe(RewriteTest.toRecipe(DefaultImpls::beforeStatementInBlock$lambda-57$lambda-56));
        }

        private static TreeVisitor afterStatementInBlock$lambda-59$lambda-58() {
            return (TreeVisitor)new JavaVisitor<ExecutionContext>(){
                private final JavaTemplate t;
                {
                    this.t = JavaTemplate.builder(() -> afterStatementInBlock.1.1.1.t$lambda-0(this), (String)"n = 1;").build();
                }

                public final JavaTemplate getT() {
                    return this.t;
                }

                @NotNull
                public J visitMethodDeclaration(@NotNull J.MethodDeclaration method, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    J.Block block2 = method.getBody();
                    Intrinsics.checkNotNull((Object)block2);
                    if (block2.getStatements().size() == 1) {
                        SourceTemplate sourceTemplate = (SourceTemplate)this.t;
                        J.Block block3 = method.getBody();
                        Intrinsics.checkNotNull((Object)block3);
                        J j = method.withTemplate(sourceTemplate, ((Statement)block3.getStatements().get(0)).getCoordinates().after(), new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)j, (String)"method.withTemplate(t, m\u2026s[0].coordinates.after())");
                        return j;
                    }
                    return (J)method;
                }

                private static final Cursor t$lambda-0(afterStatementInBlock.1.1.1 this$0) {
                    Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                    return this$0.getCursor().getParentOrThrow();
                }
            };
        }

        private static void afterStatementInBlock$lambda-59(RecipeSpec spec) {
            spec.recipe(RewriteTest.toRecipe(DefaultImpls::afterStatementInBlock$lambda-59$lambda-58));
        }

        private static TreeVisitor firstStatementInClassBlock$lambda-61$lambda-60() {
            return (TreeVisitor)new JavaVisitor<ExecutionContext>(){
                private final JavaTemplate t;
                {
                    this.t = JavaTemplate.builder(() -> firstStatementInClassBlock.1.1.1.t$lambda-0(this), (String)"int m;").build();
                }

                public final JavaTemplate getT() {
                    return this.t;
                }

                @NotNull
                public J visitClassDeclaration(@NotNull J.ClassDeclaration classDecl, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)classDecl, (String)"classDecl");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    if (classDecl.getBody().getStatements().size() == 1) {
                        J j = classDecl.withTemplate((SourceTemplate)this.t, classDecl.getBody().getCoordinates().firstStatement(), new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)j, (String)"classDecl.withTemplate(t\u2026dinates.firstStatement())");
                        return j;
                    }
                    return (J)classDecl;
                }

                private static final Cursor t$lambda-0(firstStatementInClassBlock.1.1.1 this$0) {
                    Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                    return this$0.getCursor().getParentOrThrow();
                }
            };
        }

        private static void firstStatementInClassBlock$lambda-61(RecipeSpec spec) {
            spec.recipe(RewriteTest.toRecipe(DefaultImpls::firstStatementInClassBlock$lambda-61$lambda-60));
        }

        private static TreeVisitor firstStatementInMethodBlock$lambda-63$lambda-62() {
            return (TreeVisitor)new JavaVisitor<ExecutionContext>(){
                private final JavaTemplate t;
                {
                    this.t = JavaTemplate.builder(() -> firstStatementInMethodBlock.1.1.1.t$lambda-0(this), (String)"int m = 0;").build();
                }

                public final JavaTemplate getT() {
                    return this.t;
                }

                @NotNull
                public J visitMethodDeclaration(@NotNull J.MethodDeclaration method, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    J.Block block2 = method.getBody();
                    Intrinsics.checkNotNull((Object)block2);
                    if (block2.getStatements().size() == 1) {
                        SourceTemplate sourceTemplate = (SourceTemplate)this.t;
                        J.Block block3 = method.getBody();
                        Intrinsics.checkNotNull((Object)block3);
                        J j = method.withTemplate(sourceTemplate, block3.getCoordinates().firstStatement(), new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)j, (String)"method.withTemplate(t, m\u2026dinates.firstStatement())");
                        return j;
                    }
                    return (J)method;
                }

                private static final Cursor t$lambda-0(firstStatementInMethodBlock.1.1.1 this$0) {
                    Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                    return this$0.getCursor().getParentOrThrow();
                }
            };
        }

        private static void firstStatementInMethodBlock$lambda-63(RecipeSpec spec) {
            spec.recipe(RewriteTest.toRecipe(DefaultImpls::firstStatementInMethodBlock$lambda-63$lambda-62));
        }

        private static TreeVisitor lastStatementInClassBlock$lambda-65$lambda-64() {
            return (TreeVisitor)new JavaVisitor<ExecutionContext>(){
                private final JavaTemplate t;
                {
                    this.t = JavaTemplate.builder(() -> lastStatementInClassBlock.1.1.1.t$lambda-0(this), (String)"int n;").build();
                }

                public final JavaTemplate getT() {
                    return this.t;
                }

                @NotNull
                public J visitClassDeclaration(@NotNull J.ClassDeclaration classDecl, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)classDecl, (String)"classDecl");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    if (classDecl.getBody().getStatements().isEmpty()) {
                        J j = classDecl.withTemplate((SourceTemplate)this.t, classDecl.getBody().getCoordinates().lastStatement(), new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)j, (String)"classDecl.withTemplate(t\u2026rdinates.lastStatement())");
                        return j;
                    }
                    return (J)classDecl;
                }

                private static final Cursor t$lambda-0(lastStatementInClassBlock.1.1.1 this$0) {
                    Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                    return this$0.getCursor().getParentOrThrow();
                }
            };
        }

        private static void lastStatementInClassBlock$lambda-65(RecipeSpec spec) {
            spec.recipe(RewriteTest.toRecipe(DefaultImpls::lastStatementInClassBlock$lambda-65$lambda-64));
        }

        private static TreeVisitor lastStatementInMethodBlock$lambda-67$lambda-66() {
            return (TreeVisitor)new JavaVisitor<ExecutionContext>(){
                private final JavaTemplate t;
                {
                    this.t = JavaTemplate.builder(() -> lastStatementInMethodBlock.1.1.1.t$lambda-0(this), (String)"n = 1;").build();
                }

                public final JavaTemplate getT() {
                    return this.t;
                }

                @NotNull
                public J visitMethodDeclaration(@NotNull J.MethodDeclaration method, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    J.Block block2 = method.getBody();
                    Intrinsics.checkNotNull((Object)block2);
                    if (block2.getStatements().size() == 1) {
                        SourceTemplate sourceTemplate = (SourceTemplate)this.t;
                        J.Block block3 = method.getBody();
                        Intrinsics.checkNotNull((Object)block3);
                        J j = method.withTemplate(sourceTemplate, block3.getCoordinates().lastStatement(), new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)j, (String)"method.withTemplate(t, m\u2026rdinates.lastStatement())");
                        return j;
                    }
                    return (J)method;
                }

                private static final Cursor t$lambda-0(lastStatementInMethodBlock.1.1.1 this$0) {
                    Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                    return this$0.getCursor().getParentOrThrow();
                }
            };
        }

        private static void lastStatementInMethodBlock$lambda-67(RecipeSpec spec) {
            spec.recipe(RewriteTest.toRecipe(DefaultImpls::lastStatementInMethodBlock$lambda-67$lambda-66));
        }

        private static TreeVisitor replaceStatementRequiringNewImport$lambda-69$lambda-68() {
            return (TreeVisitor)new JavaVisitor<ExecutionContext>(){
                private final JavaTemplate t;
                {
                    String[] stringArray = new String[]{"java.util.List"};
                    this.t = JavaTemplate.builder(() -> replaceStatementRequiringNewImport.1.1.1.t$lambda-0(this), (String)"List<String> s = null;").imports(stringArray).build();
                }

                public final JavaTemplate getT() {
                    return this.t;
                }

                @NotNull
                public J visitAssert(@NotNull J.Assert _assert, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)_assert, (String)"_assert");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    this.maybeAddImport("java.util.List");
                    J j = _assert.withTemplate((SourceTemplate)this.t, _assert.getCoordinates().replace(), new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)j, (String)"_assert.withTemplate(t, \u2026rt.coordinates.replace())");
                    return j;
                }

                private static final Cursor t$lambda-0(replaceStatementRequiringNewImport.1.1.1 this$0) {
                    Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                    return this$0.getCursor().getParentOrThrow();
                }
            };
        }

        private static void replaceStatementRequiringNewImport$lambda-69(RecipeSpec spec) {
            spec.recipe(RewriteTest.toRecipe(DefaultImpls::replaceStatementRequiringNewImport$lambda-69$lambda-68));
        }

        private static TreeVisitor replaceArguments$lambda-73$lambda-70() {
            return (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){
                private final JavaTemplate t;
                {
                    this.t = JavaTemplate.builder(() -> replaceArguments.1.1.1.t$lambda-0(this), (String)"m, Integer.valueOf(n), \"foo\"").build();
                }

                public final JavaTemplate getT() {
                    return this.t;
                }

                @NotNull
                public J.MethodInvocation visitMethodInvocation(@NotNull J.MethodInvocation method, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    if (method.getArguments().size() == 1) {
                        J j = method.withTemplate((SourceTemplate)this.t, method.getCoordinates().replaceArguments(), new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)j, (String)"method.withTemplate(t, m\u2026nates.replaceArguments())");
                        return (J.MethodInvocation)j;
                    }
                    return method;
                }

                private static final Cursor t$lambda-0(replaceArguments.1.1.1 this$0) {
                    Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                    return this$0.getCursor().getParentOrThrow();
                }
            };
        }

        private static boolean replaceArguments$lambda-73$lambda-72$lambda-71(JavaType it) {
            JavaType.FullyQualified fullyQualified = TestKt.asFullyQualified(it);
            Intrinsics.checkNotNull((Object)fullyQualified);
            return fullyQualified.getFullyQualifiedName().equals("java.lang.String");
        }

        private static void replaceArguments$lambda-73$lambda-72(RecipeRun it) {
            SourceFile sourceFile = ((Result)it.getResults().get(0)).getAfter();
            if (sourceFile == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.CompilationUnit");
            }
            J.CompilationUnit cu = (J.CompilationUnit)sourceFile;
            Object e = ((J.ClassDeclaration)cu.getClasses().get(0)).getBody().getStatements().get(2);
            if (e == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block2 = ((J.MethodDeclaration)e).getBody();
            Intrinsics.checkNotNull((Object)block2);
            Object e2 = block2.getStatements().get(0);
            if (e2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodInvocation");
            }
            J.MethodInvocation m = (J.MethodInvocation)e2;
            JavaType.Method method = m.getMethodType();
            Intrinsics.checkNotNull((Object)method);
            JavaType.Method type = method;
            org.assertj.core.api.Assertions.assertThat(type.getParameterTypes().get(0)).isEqualTo((Object)JavaType.Primitive.Int);
            org.assertj.core.api.Assertions.assertThat(type.getParameterTypes().get(1)).isEqualTo((Object)JavaType.Primitive.Int);
            org.assertj.core.api.Assertions.assertThat(type.getParameterTypes().get(2)).matches(DefaultImpls::replaceArguments$lambda-73$lambda-72$lambda-71);
        }

        private static void replaceArguments$lambda-73(RecipeSpec spec) {
            spec.recipe(RewriteTest.toRecipe(DefaultImpls::replaceArguments$lambda-73$lambda-70)).afterRecipe(DefaultImpls::replaceArguments$lambda-73$lambda-72);
        }

        private static TreeVisitor _get_replaceAnnotationRecipe_$lambda-74() {
            return (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){
                private final JavaTemplate t;
                {
                    this.t = JavaTemplate.builder(() -> replaceAnnotationRecipe.1.1.t$lambda-0(this), (String)"@Deprecated").build();
                }

                public final JavaTemplate getT() {
                    return this.t;
                }

                @NotNull
                public J.Annotation visitAnnotation(@NotNull J.Annotation annotation2, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)annotation2, (String)"annotation");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    if (Intrinsics.areEqual((Object)annotation2.getSimpleName(), (Object)"SuppressWarnings")) {
                        J j = annotation2.withTemplate((SourceTemplate)this.t, annotation2.getCoordinates().replace(), new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)j, (String)"annotation.withTemplate(\u2026on.coordinates.replace())");
                        return (J.Annotation)j;
                    }
                    if (Intrinsics.areEqual((Object)annotation2.getSimpleName(), (Object)"A1")) {
                        J j = annotation2.withTemplate((SourceTemplate)JavaTemplate.builder(() -> replaceAnnotationRecipe.1.1.visitAnnotation$lambda-1(this), (String)"@A2").build(), annotation2.getCoordinates().replace(), new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)j, (String)"annotation.withTemplate(\u2026on.coordinates.replace())");
                        return (J.Annotation)j;
                    }
                    J.Annotation annotation3 = super.visitAnnotation(annotation2, (Object)p);
                    Intrinsics.checkNotNullExpressionValue((Object)annotation3, (String)"super.visitAnnotation(annotation, p)");
                    return annotation3;
                }

                private static final Cursor t$lambda-0(replaceAnnotationRecipe.1.1 this$0) {
                    Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                    return this$0.getCursor().getParentOrThrow();
                }

                private static final Cursor visitAnnotation$lambda-1(replaceAnnotationRecipe.1.1 this$0) {
                    Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                    return this$0.getCursor().getParentOrThrow();
                }
            };
        }

        private static void replaceClassAnnotation$lambda-75(JavaTemplateTest this$0, RecipeSpec spec) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            spec.recipe(this$0.getReplaceAnnotationRecipe());
        }

        private static void replaceMethodDeclarationAnnotation$lambda-76(JavaTemplateTest this$0, RecipeSpec spec) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            spec.recipe(this$0.getReplaceAnnotationRecipe());
        }

        private static void replaceVariableDeclarationAnnotation$lambda-77(JavaTemplateTest this$0, RecipeSpec spec) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            spec.recipe(this$0.getReplaceAnnotationRecipe());
        }

        private static void replaceMethodDeclarationVariableDeclarationAnnotation$lambda-78(JavaTemplateTest this$0, RecipeSpec spec) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            spec.recipe(this$0.getReplaceAnnotationRecipe());
        }

        private static TreeVisitor replaceMethodAnnotations$lambda-80$lambda-79() {
            return (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){
                private final JavaTemplate t;
                {
                    this.t = JavaTemplate.builder(() -> replaceMethodAnnotations.1.1.1.t$lambda-0(this), (String)"@SuppressWarnings(\"other\")").build();
                }

                public final JavaTemplate getT() {
                    return this.t;
                }

                @NotNull
                public J.MethodDeclaration visitMethodDeclaration(@NotNull J.MethodDeclaration method, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    if (method.getLeadingAnnotations().size() == 0) {
                        J j = method.withTemplate((SourceTemplate)this.t, method.getCoordinates().replaceAnnotations(), new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)j, (String)"method.withTemplate(t, m\u2026tes.replaceAnnotations())");
                        return (J.MethodDeclaration)j;
                    }
                    J.MethodDeclaration methodDeclaration2 = super.visitMethodDeclaration(method, (Object)p);
                    Intrinsics.checkNotNullExpressionValue((Object)methodDeclaration2, (String)"super.visitMethodDeclaration(method, p)");
                    return methodDeclaration2;
                }

                private static final Cursor t$lambda-0(replaceMethodAnnotations.1.1.1 this$0) {
                    Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                    return this$0.getCursor().getParentOrThrow();
                }
            };
        }

        private static void replaceMethodAnnotations$lambda-80(RecipeSpec spec) {
            spec.recipe(RewriteTest.toRecipe(DefaultImpls::replaceMethodAnnotations$lambda-80$lambda-79));
        }

        private static TreeVisitor replaceClassAnnotations$lambda-82$lambda-81() {
            return (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){
                private final JavaTemplate t;
                {
                    this.t = JavaTemplate.builder(() -> replaceClassAnnotations.1.1.1.t$lambda-0(this), (String)"@SuppressWarnings(\"other\")").build();
                }

                public final JavaTemplate getT() {
                    return this.t;
                }

                @NotNull
                public J.ClassDeclaration visitClassDeclaration(@NotNull J.ClassDeclaration classDecl, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)classDecl, (String)"classDecl");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    if (classDecl.getLeadingAnnotations().size() == 0 && !Intrinsics.areEqual((Object)classDecl.getSimpleName(), (Object)"Test")) {
                        J j = classDecl.withTemplate((SourceTemplate)this.t, classDecl.getCoordinates().replaceAnnotations(), new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)j, (String)"classDecl.withTemplate(t\u2026tes.replaceAnnotations())");
                        return (J.ClassDeclaration)j;
                    }
                    J.ClassDeclaration classDeclaration = super.visitClassDeclaration(classDecl, (Object)p);
                    Intrinsics.checkNotNullExpressionValue((Object)classDeclaration, (String)"super.visitClassDeclaration(classDecl, p)");
                    return classDeclaration;
                }

                private static final Cursor t$lambda-0(replaceClassAnnotations.1.1.1 this$0) {
                    Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                    return this$0.getCursor().getParentOrThrow();
                }
            };
        }

        private static void replaceClassAnnotations$lambda-82(RecipeSpec spec) {
            spec.recipe(RewriteTest.toRecipe(DefaultImpls::replaceClassAnnotations$lambda-82$lambda-81));
        }

        private static TreeVisitor replaceVariableAnnotations$lambda-84$lambda-83() {
            return (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){
                private final JavaTemplate t;
                {
                    this.t = JavaTemplate.builder(() -> replaceVariableAnnotations.1.1.1.t$lambda-0(this), (String)"@SuppressWarnings(\"other\")").build();
                }

                public final JavaTemplate getT() {
                    return this.t;
                }

                @NotNull
                public J.VariableDeclarations visitVariableDeclarations(@NotNull J.VariableDeclarations multiVariable, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)multiVariable, (String)"multiVariable");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    if (multiVariable.getLeadingAnnotations().size() == 0) {
                        J j = multiVariable.withTemplate((SourceTemplate)this.t, multiVariable.getCoordinates().replaceAnnotations(), new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)j, (String)"multiVariable.withTempla\u2026tes.replaceAnnotations())");
                        return (J.VariableDeclarations)j;
                    }
                    J.VariableDeclarations variableDeclarations = super.visitVariableDeclarations(multiVariable, (Object)p);
                    Intrinsics.checkNotNullExpressionValue((Object)variableDeclarations, (String)"super.visitVariableDeclarations(multiVariable, p)");
                    return variableDeclarations;
                }

                private static final Cursor t$lambda-0(replaceVariableAnnotations.1.1.1 this$0) {
                    Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                    return this$0.getCursor().getParentOrThrow();
                }
            };
        }

        private static void replaceVariableAnnotations$lambda-84(RecipeSpec spec) {
            spec.recipe(RewriteTest.toRecipe(DefaultImpls::replaceVariableAnnotations$lambda-84$lambda-83));
        }

        private static TreeVisitor addVariableAnnotationsToVariableAlreadyAnnotated$lambda-86$lambda-85() {
            return (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){
                private final JavaTemplate t;
                {
                    this.t = JavaTemplate.builder(() -> addVariableAnnotationsToVariableAlreadyAnnotated.1.1.1.t$lambda-0(this), (String)"@Deprecated").build();
                }

                public final JavaTemplate getT() {
                    return this.t;
                }

                @NotNull
                public J.VariableDeclarations visitVariableDeclarations(@NotNull J.VariableDeclarations multiVariable, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)multiVariable, (String)"multiVariable");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    if (multiVariable.getLeadingAnnotations().size() == 1) {
                        J j = multiVariable.withTemplate((SourceTemplate)this.t, multiVariable.getCoordinates().addAnnotation(Comparator.comparing(addVariableAnnotationsToVariableAlreadyAnnotated.1.1.1::visitVariableDeclarations$lambda-1)), new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)j, (String)"multiVariable.withTempla\u2026otation(comparing { 0 }))");
                        return (J.VariableDeclarations)j;
                    }
                    J.VariableDeclarations variableDeclarations = super.visitVariableDeclarations(multiVariable, (Object)p);
                    Intrinsics.checkNotNullExpressionValue((Object)variableDeclarations, (String)"super.visitVariableDeclarations(multiVariable, p)");
                    return variableDeclarations;
                }

                private static final Cursor t$lambda-0(addVariableAnnotationsToVariableAlreadyAnnotated.1.1.1 this$0) {
                    Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                    return this$0.getCursor().getParentOrThrow();
                }

                private static final Integer visitVariableDeclarations$lambda-1(J.Annotation it) {
                    return 0;
                }
            };
        }

        private static void addVariableAnnotationsToVariableAlreadyAnnotated$lambda-86(RecipeSpec spec) {
            spec.recipe(RewriteTest.toRecipe(DefaultImpls::addVariableAnnotationsToVariableAlreadyAnnotated$lambda-86$lambda-85));
        }

        private static TreeVisitor addVariableAnnotationsToVariableNotAnnotated$lambda-88$lambda-87() {
            return (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){
                private final JavaTemplate t;
                {
                    this.t = JavaTemplate.builder(() -> addVariableAnnotationsToVariableNotAnnotated.1.1.1.t$lambda-0(this), (String)"@SuppressWarnings(\"ALL\")").build();
                }

                public final JavaTemplate getT() {
                    return this.t;
                }

                @NotNull
                public J.VariableDeclarations visitVariableDeclarations(@NotNull J.VariableDeclarations multiVariable, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)multiVariable, (String)"multiVariable");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    if (multiVariable.getLeadingAnnotations().size() == 0) {
                        J j = multiVariable.withTemplate((SourceTemplate)this.t, multiVariable.getCoordinates().addAnnotation(Comparator.comparing(addVariableAnnotationsToVariableNotAnnotated.1.1.1::visitVariableDeclarations$lambda-1)), new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)j, (String)"multiVariable.withTempla\u2026                        )");
                        return (J.VariableDeclarations)j;
                    }
                    J.VariableDeclarations variableDeclarations = super.visitVariableDeclarations(multiVariable, (Object)p);
                    Intrinsics.checkNotNullExpressionValue((Object)variableDeclarations, (String)"super.visitVariableDeclarations(multiVariable, p)");
                    return variableDeclarations;
                }

                private static final Cursor t$lambda-0(addVariableAnnotationsToVariableNotAnnotated.1.1.1 this$0) {
                    Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                    return this$0.getCursor().getParentOrThrow();
                }

                private static final String visitVariableDeclarations$lambda-1(J.Annotation it) {
                    return it.getSimpleName();
                }
            };
        }

        private static void addVariableAnnotationsToVariableNotAnnotated$lambda-88(RecipeSpec spec) {
            spec.recipe(RewriteTest.toRecipe(DefaultImpls::addVariableAnnotationsToVariableNotAnnotated$lambda-88$lambda-87));
        }

        private static TreeVisitor addMethodAnnotations$lambda-90$lambda-89() {
            return (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){
                private final JavaTemplate t;
                {
                    this.t = JavaTemplate.builder(() -> addMethodAnnotations.1.1.1.t$lambda-0(this), (String)"@SuppressWarnings(\"other\")").build();
                }

                public final JavaTemplate getT() {
                    return this.t;
                }

                @NotNull
                public J.MethodDeclaration visitMethodDeclaration(@NotNull J.MethodDeclaration method, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    if (method.getLeadingAnnotations().size() == 0) {
                        J j = method.withTemplate((SourceTemplate)this.t, method.getCoordinates().addAnnotation(Comparator.comparing(addMethodAnnotations.1.1.1::visitMethodDeclaration$lambda-1)), new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)j, (String)"method.withTemplate(t, m\u2026aring { it.simpleName }))");
                        return (J.MethodDeclaration)j;
                    }
                    J.MethodDeclaration methodDeclaration2 = super.visitMethodDeclaration(method, (Object)p);
                    Intrinsics.checkNotNullExpressionValue((Object)methodDeclaration2, (String)"super.visitMethodDeclaration(method, p)");
                    return methodDeclaration2;
                }

                private static final Cursor t$lambda-0(addMethodAnnotations.1.1.1 this$0) {
                    Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                    return this$0.getCursor().getParentOrThrow();
                }

                private static final String visitMethodDeclaration$lambda-1(J.Annotation it) {
                    return it.getSimpleName();
                }
            };
        }

        private static void addMethodAnnotations$lambda-90(RecipeSpec spec) {
            spec.recipe(RewriteTest.toRecipe(DefaultImpls::addMethodAnnotations$lambda-90$lambda-89));
        }

        private static TreeVisitor addClassAnnotations$lambda-92$lambda-91() {
            return (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){
                private final JavaTemplate t;
                {
                    this.t = JavaTemplate.builder(() -> addClassAnnotations.1.1.1.t$lambda-0(this), (String)"@SuppressWarnings(\"other\")").build();
                }

                public final JavaTemplate getT() {
                    return this.t;
                }

                @NotNull
                public J.ClassDeclaration visitClassDeclaration(@NotNull J.ClassDeclaration classDecl, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)classDecl, (String)"classDecl");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    if (classDecl.getLeadingAnnotations().size() == 0 && !Intrinsics.areEqual((Object)classDecl.getSimpleName(), (Object)"Test")) {
                        J j = classDecl.withTemplate((SourceTemplate)this.t, classDecl.getCoordinates().addAnnotation(Comparator.comparing(addClassAnnotations.1.1.1::visitClassDeclaration$lambda-1)), new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)j, (String)"classDecl.withTemplate(\n\u2026                        )");
                        return (J.ClassDeclaration)j;
                    }
                    J.ClassDeclaration classDeclaration = super.visitClassDeclaration(classDecl, (Object)p);
                    Intrinsics.checkNotNullExpressionValue((Object)classDeclaration, (String)"super.visitClassDeclaration(classDecl, p)");
                    return classDeclaration;
                }

                private static final Cursor t$lambda-0(addClassAnnotations.1.1.1 this$0) {
                    Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                    return this$0.getCursor().getParentOrThrow();
                }

                private static final String visitClassDeclaration$lambda-1(J.Annotation it) {
                    return it.getSimpleName();
                }
            };
        }

        private static void addClassAnnotations$lambda-92(RecipeSpec spec) {
            spec.recipe(RewriteTest.toRecipe(DefaultImpls::addClassAnnotations$lambda-92$lambda-91));
        }

        private static TreeVisitor replaceAnnotation$lambda-94$lambda-93() {
            return (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){
                private final JavaTemplate t;
                {
                    this.t = JavaTemplate.builder(() -> replaceAnnotation.1.1.1.t$lambda-0(this), (String)"@Deprecated").build();
                }

                public final JavaTemplate getT() {
                    return this.t;
                }

                @NotNull
                public J.Annotation visitAnnotation(@NotNull J.Annotation annotation2, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)annotation2, (String)"annotation");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    if (Intrinsics.areEqual((Object)annotation2.getSimpleName(), (Object)"SuppressWarnings")) {
                        J j = annotation2.withTemplate((SourceTemplate)this.t, annotation2.getCoordinates().replace(), new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)j, (String)"annotation.withTemplate(\u2026on.coordinates.replace())");
                        return (J.Annotation)j;
                    }
                    return annotation2;
                }

                private static final Cursor t$lambda-0(replaceAnnotation.1.1.1 this$0) {
                    Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                    return this$0.getCursor().getParentOrThrow();
                }
            };
        }

        private static void replaceAnnotation$lambda-94(RecipeSpec spec) {
            spec.recipe(RewriteTest.toRecipe(DefaultImpls::replaceAnnotation$lambda-94$lambda-93));
        }

        private static TreeVisitor replaceClassImplements$lambda-96$lambda-95() {
            return (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){
                private final JavaTemplate t;
                {
                    String[] stringArray = new String[]{"java.io.*"};
                    this.t = JavaTemplate.builder(() -> replaceClassImplements.1.1.1.t$lambda-0(this), (String)"Serializable, Closeable").imports(stringArray).build();
                }

                public final JavaTemplate getT() {
                    return this.t;
                }

                @NotNull
                public J.ClassDeclaration visitClassDeclaration(@NotNull J.ClassDeclaration classDecl, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)classDecl, (String)"classDecl");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    if (classDecl.getImplements() == null) {
                        this.maybeAddImport("java.io.Closeable");
                        this.maybeAddImport("java.io.Serializable");
                        J j = classDecl.withTemplate((SourceTemplate)this.t, classDecl.getCoordinates().replaceImplementsClause(), new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)j, (String)"classDecl.withTemplate(t\u2026eplaceImplementsClause())");
                        return (J.ClassDeclaration)j;
                    }
                    J.ClassDeclaration classDeclaration = super.visitClassDeclaration(classDecl, (Object)p);
                    Intrinsics.checkNotNullExpressionValue((Object)classDeclaration, (String)"super.visitClassDeclaration(classDecl, p)");
                    return classDeclaration;
                }

                private static final Cursor t$lambda-0(replaceClassImplements.1.1.1 this$0) {
                    Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                    return this$0.getCursor().getParentOrThrow();
                }
            };
        }

        private static void replaceClassImplements$lambda-96(RecipeSpec spec) {
            spec.recipe(RewriteTest.toRecipe(DefaultImpls::replaceClassImplements$lambda-96$lambda-95));
        }

        private static TreeVisitor replaceClassExtends$lambda-98$lambda-97() {
            return (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){
                private final JavaTemplate t;
                {
                    String[] stringArray = new String[]{"java.util.*"};
                    this.t = JavaTemplate.builder(() -> replaceClassExtends.1.1.1.t$lambda-0(this), (String)"List<String>").imports(stringArray).build();
                }

                public final JavaTemplate getT() {
                    return this.t;
                }

                @NotNull
                public J.ClassDeclaration visitClassDeclaration(@NotNull J.ClassDeclaration classDecl, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)classDecl, (String)"classDecl");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    if (classDecl.getExtends() == null) {
                        this.maybeAddImport("java.util.List");
                        J j = classDecl.withTemplate((SourceTemplate)this.t, classDecl.getCoordinates().replaceExtendsClause(), new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)j, (String)"classDecl.withTemplate(t\u2026s.replaceExtendsClause())");
                        return (J.ClassDeclaration)j;
                    }
                    J.ClassDeclaration classDeclaration = super.visitClassDeclaration(classDecl, (Object)p);
                    Intrinsics.checkNotNullExpressionValue((Object)classDeclaration, (String)"super.visitClassDeclaration(classDecl, p)");
                    return classDeclaration;
                }

                private static final Cursor t$lambda-0(replaceClassExtends.1.1.1 this$0) {
                    Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                    return this$0.getCursor().getParentOrThrow();
                }
            };
        }

        private static void replaceClassExtends$lambda-98(RecipeSpec spec) {
            spec.recipe(RewriteTest.toRecipe(DefaultImpls::replaceClassExtends$lambda-98$lambda-97));
        }

        private static TreeVisitor replaceThrows$lambda-102$lambda-99() {
            return (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){
                private final JavaTemplate t;
                {
                    this.t = JavaTemplate.builder(() -> replaceThrows.1.1.1.t$lambda-0(this), (String)"Exception").build();
                }

                public final JavaTemplate getT() {
                    return this.t;
                }

                @NotNull
                public J.MethodDeclaration visitMethodDeclaration(@NotNull J.MethodDeclaration method, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    if (method.getThrows() == null) {
                        J j = method.withTemplate((SourceTemplate)this.t, method.getCoordinates().replaceThrows(), new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)j, (String)"method.withTemplate(t, m\u2026rdinates.replaceThrows())");
                        return (J.MethodDeclaration)j;
                    }
                    J.MethodDeclaration methodDeclaration2 = super.visitMethodDeclaration(method, (Object)p);
                    Intrinsics.checkNotNullExpressionValue((Object)methodDeclaration2, (String)"super.visitMethodDeclaration(method, p)");
                    return methodDeclaration2;
                }

                private static final Cursor t$lambda-0(replaceThrows.1.1.1 this$0) {
                    Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                    return this$0.getCursor().getParentOrThrow();
                }
            };
        }

        /*
         * WARNING - void declaration
         */
        private static void replaceThrows$lambda-102$lambda-101(RecipeRun it) {
            void $this$mapTo$iv$iv;
            SourceFile sourceFile = ((Result)it.getResults().get(0)).getAfter();
            if (sourceFile == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.CompilationUnit");
            }
            J.CompilationUnit cu = (J.CompilationUnit)sourceFile;
            List list = cu.getClasses();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"cu.classes");
            List list2 = ((J.ClassDeclaration)CollectionsKt.first((List)list)).getBody().getStatements();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"cu.classes.first().body.statements");
            Object object = CollectionsKt.first((List)list2);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.MethodDeclaration testMethodDecl = (J.MethodDeclaration)object;
            JavaType.Method method = testMethodDecl.getMethodType();
            Intrinsics.checkNotNull((Object)method);
            List list3 = method.getThrownExceptions();
            Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"testMethodDecl.methodType!!.thrownExceptions");
            Iterable $this$map$iv = list3;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                JavaType.FullyQualified fullyQualified = (JavaType.FullyQualified)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it2.getFullyQualifiedName());
            }
            Object[] objectArray = new String[]{"java.lang.Exception"};
            org.assertj.core.api.Assertions.assertThat((List)((List)destination$iv$iv)).containsExactly(objectArray);
        }

        private static void replaceThrows$lambda-102(RecipeSpec spec) {
            spec.recipe(RewriteTest.toRecipe(DefaultImpls::replaceThrows$lambda-102$lambda-99)).afterRecipe(DefaultImpls::replaceThrows$lambda-102$lambda-101);
        }

        private static TreeVisitor replaceMethodTypeParameters$lambda-107$lambda-103() {
            return (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){
                private final JavaTemplate typeParamsTemplate;
                private final JavaTemplate methodArgsTemplate;
                {
                    this.typeParamsTemplate = JavaTemplate.builder(() -> replaceMethodTypeParameters.1.1.1.typeParamsTemplate$lambda-0(this), (String)"T, U").build();
                    String[] stringArray = new String[]{"java.util.List"};
                    this.methodArgsTemplate = JavaTemplate.builder(() -> replaceMethodTypeParameters.1.1.1.methodArgsTemplate$lambda-1(this), (String)"List<T> t, U u").imports(stringArray).build();
                }

                public final JavaTemplate getTypeParamsTemplate() {
                    return this.typeParamsTemplate;
                }

                public final JavaTemplate getMethodArgsTemplate() {
                    return this.methodArgsTemplate;
                }

                @NotNull
                public J.MethodDeclaration visitMethodDeclaration(@NotNull J.MethodDeclaration method, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    if (method.getTypeParameters() == null) {
                        J j = ((J.MethodDeclaration)method.withTemplate((SourceTemplate)this.typeParamsTemplate, method.getCoordinates().replaceTypeParameters(), new Object[0])).withTemplate((SourceTemplate)this.methodArgsTemplate, method.getCoordinates().replaceParameters(), new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)j, (String)"method.withTemplate<J.Me\u2026ates.replaceParameters())");
                        return (J.MethodDeclaration)j;
                    }
                    J.MethodDeclaration methodDeclaration2 = super.visitMethodDeclaration(method, (Object)p);
                    Intrinsics.checkNotNullExpressionValue((Object)methodDeclaration2, (String)"super.visitMethodDeclaration(method, p)");
                    return methodDeclaration2;
                }

                private static final Cursor typeParamsTemplate$lambda-0(replaceMethodTypeParameters.1.1.1 this$0) {
                    Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                    return this$0.getCursor().getParentOrThrow();
                }

                private static final Cursor methodArgsTemplate$lambda-1(replaceMethodTypeParameters.1.1.1 this$0) {
                    Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                    return this$0.getCursor().getParentOrThrow();
                }
            };
        }

        private static boolean replaceMethodTypeParameters$lambda-107$lambda-106$lambda-104(JavaType tType) {
            return tType instanceof JavaType.FullyQualified && Intrinsics.areEqual((Object)((JavaType.FullyQualified)tType).getFullyQualifiedName(), (Object)"java.util.List");
        }

        private static boolean replaceMethodTypeParameters$lambda-107$lambda-106$lambda-105(JavaType uType) {
            return uType instanceof JavaType.GenericTypeVariable && Intrinsics.areEqual((Object)((JavaType.GenericTypeVariable)uType).getName(), (Object)"U") && ((JavaType.GenericTypeVariable)uType).getBounds().isEmpty();
        }

        private static void replaceMethodTypeParameters$lambda-107$lambda-106(RecipeRun it) {
            SourceFile sourceFile = ((Result)it.getResults().get(0)).getAfter();
            if (sourceFile == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.CompilationUnit");
            }
            J.CompilationUnit cu = (J.CompilationUnit)sourceFile;
            List list = cu.getClasses();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"cu.classes");
            List list2 = ((J.ClassDeclaration)CollectionsKt.first((List)list)).getBody().getStatements();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"cu.classes.first().body.statements");
            Object object = CollectionsKt.first((List)list2);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            JavaType.Method method = ((J.MethodDeclaration)object).getMethodType();
            Intrinsics.checkNotNull((Object)method);
            JavaType.Method type = method;
            org.assertj.core.api.Assertions.assertThat((Object)type).isNotNull();
            List paramTypes = type.getParameterTypes();
            ((ObjectAssert)org.assertj.core.api.Assertions.assertThat(paramTypes.get(0)).as("The method declaration's type's genericSignature first argument should have have type 'java.util.List'", new Object[0])).matches(DefaultImpls::replaceMethodTypeParameters$lambda-107$lambda-106$lambda-104);
            ((ObjectAssert)org.assertj.core.api.Assertions.assertThat(paramTypes.get(1)).as("The method declaration's type's genericSignature second argument should have type 'U' with bound 'java.lang.Object'", new Object[0])).matches(DefaultImpls::replaceMethodTypeParameters$lambda-107$lambda-106$lambda-105);
        }

        private static void replaceMethodTypeParameters$lambda-107(RecipeSpec spec) {
            spec.recipe(RewriteTest.toRecipe(DefaultImpls::replaceMethodTypeParameters$lambda-107$lambda-103)).afterRecipe(DefaultImpls::replaceMethodTypeParameters$lambda-107$lambda-106);
        }

        private static TreeVisitor replaceClassTypeParameters$lambda-109$lambda-108() {
            return (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){
                private final JavaTemplate t;
                {
                    this.t = JavaTemplate.builder(() -> replaceClassTypeParameters.1.1.1.t$lambda-0(this), (String)"T, U").build();
                }

                public final JavaTemplate getT() {
                    return this.t;
                }

                @NotNull
                public J.ClassDeclaration visitClassDeclaration(@NotNull J.ClassDeclaration classDecl, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)classDecl, (String)"classDecl");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    if (classDecl.getTypeParameters() == null) {
                        J j = classDecl.withTemplate((SourceTemplate)this.t, classDecl.getCoordinates().replaceTypeParameters(), new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)j, (String)"classDecl.withTemplate(t\u2026.replaceTypeParameters())");
                        return (J.ClassDeclaration)j;
                    }
                    J.ClassDeclaration classDeclaration = super.visitClassDeclaration(classDecl, (Object)p);
                    Intrinsics.checkNotNullExpressionValue((Object)classDeclaration, (String)"super.visitClassDeclaration(classDecl, p)");
                    return classDeclaration;
                }

                private static final Cursor t$lambda-0(replaceClassTypeParameters.1.1.1 this$0) {
                    Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                    return this$0.getCursor().getParentOrThrow();
                }
            };
        }

        private static void replaceClassTypeParameters$lambda-109(RecipeSpec spec) {
            spec.recipe(RewriteTest.toRecipe(DefaultImpls::replaceClassTypeParameters$lambda-109$lambda-108));
        }

        private static TreeVisitor replaceBody$lambda-111$lambda-110() {
            return (TreeVisitor)new JavaVisitor<ExecutionContext>(){
                private final JavaTemplate t;
                {
                    this.t = JavaTemplate.builder(() -> replaceBody.1.1.1.t$lambda-0(this), (String)"n = 1;").build();
                }

                public final JavaTemplate getT() {
                    return this.t;
                }

                @NotNull
                public J visitMethodDeclaration(@NotNull J.MethodDeclaration method, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    J.Block block2 = method.getBody();
                    Intrinsics.checkNotNull((Object)block2);
                    Statement statement = (Statement)block2.getStatements().get(0);
                    if (statement instanceof J.Unary) {
                        J j = method.withTemplate((SourceTemplate)this.t, method.getCoordinates().replaceBody(), new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)j, (String)"method.withTemplate(t, m\u2026oordinates.replaceBody())");
                        return j;
                    }
                    return (J)method;
                }

                private static final Cursor t$lambda-0(replaceBody.1.1.1 this$0) {
                    Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                    return this$0.getCursor().getParentOrThrow();
                }
            };
        }

        private static void replaceBody$lambda-111(RecipeSpec spec) {
            spec.recipe(RewriteTest.toRecipe(DefaultImpls::replaceBody$lambda-111$lambda-110));
        }

        private static TreeVisitor replaceMissingBody$lambda-113$lambda-112() {
            return (TreeVisitor)new JavaVisitor<ExecutionContext>(){
                private final JavaTemplate t;
                {
                    this.t = JavaTemplate.builder(() -> replaceMissingBody.1.1.1.t$lambda-0(this), (String)"").build();
                }

                public final JavaTemplate getT() {
                    return this.t;
                }

                @NotNull
                public J visitMethodDeclaration(@NotNull J.MethodDeclaration method, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    J.MethodDeclaration m = method;
                    if (!m.isAbstract()) {
                        return (J)m;
                    }
                    TypeTree typeTree = m.getReturnTypeExpression();
                    Intrinsics.checkNotNull((Object)typeTree);
                    J.MethodDeclaration methodDeclaration2 = m.withReturnTypeExpression((TypeTree)typeTree.withPrefix(Space.EMPTY));
                    Intrinsics.checkNotNullExpressionValue((Object)methodDeclaration2, (String)"m.withReturnTypeExpressi\u2026.withPrefix(Space.EMPTY))");
                    m = methodDeclaration2;
                    J.MethodDeclaration methodDeclaration3 = m.withModifiers(CollectionsKt.emptyList());
                    Intrinsics.checkNotNullExpressionValue((Object)methodDeclaration3, (String)"m.withModifiers(emptyList())");
                    m = methodDeclaration3;
                    J j = m.withTemplate((SourceTemplate)this.t, m.getCoordinates().replaceBody(), new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)j, (String)"m.withTemplate(t, m.coordinates.replaceBody())");
                    m = (J.MethodDeclaration)j;
                    return (J)m;
                }

                private static final Cursor t$lambda-0(replaceMissingBody.1.1.1 this$0) {
                    Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                    return this$0.getCursor().getParentOrThrow();
                }
            };
        }

        private static void replaceMissingBody$lambda-113(RecipeSpec spec) {
            spec.recipe(RewriteTest.toRecipe(DefaultImpls::replaceMissingBody$lambda-113$lambda-112));
        }

        private static TreeVisitor replaceNamedVariableInitializerMethodInvocation$lambda-115$lambda-114() {
            return (TreeVisitor)new JavaVisitor<ExecutionContext>(){
                @NotNull
                private final MethodMatcher matcher;
                private final JavaTemplate t;
                {
                    this.matcher = new MethodMatcher("Integer valueOf(..)");
                    this.t = JavaTemplate.builder(() -> replaceNamedVariableInitializerMethodInvocation.1.1.1.t$lambda-0(this), (String)"new Integer(#{any()})").build();
                }

                @NotNull
                public final MethodMatcher getMatcher() {
                    return this.matcher;
                }

                public final JavaTemplate getT() {
                    return this.t;
                }

                @NotNull
                public J visitMethodInvocation(@NotNull J.MethodInvocation method, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    if (this.matcher.matches(method)) {
                        Object[] objectArray = new Object[]{method.getArguments().get(0)};
                        J j = method.withTemplate((SourceTemplate)this.t, method.getCoordinates().replace(), objectArray);
                        Intrinsics.checkNotNullExpressionValue((Object)j, (String)"method.withTemplate(t, m\u2026e(), method.arguments[0])");
                        return j;
                    }
                    J j = super.visitMethodInvocation(method, (Object)p);
                    Intrinsics.checkNotNullExpressionValue((Object)j, (String)"super.visitMethodInvocation(method, p)");
                    return j;
                }

                private static final Cursor t$lambda-0(replaceNamedVariableInitializerMethodInvocation.1.1.1 this$0) {
                    Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                    return this$0.getCursor().getParentOrThrow();
                }
            };
        }

        private static void replaceNamedVariableInitializerMethodInvocation$lambda-115(RecipeSpec spec) {
            spec.recipe(RewriteTest.toRecipe(DefaultImpls::replaceNamedVariableInitializerMethodInvocation$lambda-115$lambda-114));
        }

        private static TreeVisitor lambdaIsVariableInitializer$lambda-117$lambda-116() {
            return (TreeVisitor)new JavaVisitor<ExecutionContext>(){
                @NotNull
                private final MethodMatcher matcher;
                private final JavaTemplate t;
                {
                    this.matcher = new MethodMatcher("Integer valueOf(..)");
                    this.t = JavaTemplate.builder(() -> lambdaIsVariableInitializer.1.1.1.t$lambda-0(this), (String)"new Integer(#{any()})").build();
                }

                @NotNull
                public final MethodMatcher getMatcher() {
                    return this.matcher;
                }

                public final JavaTemplate getT() {
                    return this.t;
                }

                @NotNull
                public J visitMethodInvocation(@NotNull J.MethodInvocation method, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    if (this.matcher.matches(method)) {
                        Object[] objectArray = new Object[]{method.getArguments().get(0)};
                        J j = method.withTemplate((SourceTemplate)this.t, method.getCoordinates().replace(), objectArray);
                        Intrinsics.checkNotNullExpressionValue((Object)j, (String)"method.withTemplate(t, m\u2026e(), method.arguments[0])");
                        return j;
                    }
                    J j = super.visitMethodInvocation(method, (Object)p);
                    Intrinsics.checkNotNullExpressionValue((Object)j, (String)"super.visitMethodInvocation(method, p)");
                    return j;
                }

                private static final Cursor t$lambda-0(lambdaIsVariableInitializer.1.1.1 this$0) {
                    Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                    return this$0.getCursor().getParentOrThrow();
                }
            };
        }

        private static void lambdaIsVariableInitializer$lambda-117(RecipeSpec spec) {
            spec.recipe(RewriteTest.toRecipe(DefaultImpls::lambdaIsVariableInitializer$lambda-117$lambda-116));
        }

        private static TreeVisitor methodDeclarationWithComment$lambda-119$lambda-118() {
            return (TreeVisitor)new JavaVisitor<ExecutionContext>(){

                @NotNull
                public J visitClassDeclaration(@NotNull J.ClassDeclaration classDeclaration, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)classDeclaration, (String)"classDeclaration");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    J.ClassDeclaration cd = classDeclaration;
                    if (cd.getBody().getStatements().isEmpty()) {
                        J.ClassDeclaration classDeclaration2 = cd.withBody((J.Block)cd.getBody().withTemplate((SourceTemplate)JavaTemplate.builder(() -> methodDeclarationWithComment.1.1.1.visitClassDeclaration$lambda-0(this), (String)"\n                                /**\n                                 * comment\n                                 */\n                                void foo() {\n                                }\n                            ").build(), cd.getBody().getCoordinates().firstStatement(), new Object[0]));
                        Intrinsics.checkNotNullExpressionValue((Object)classDeclaration2, (String)"cd.withBody(\n           \u2026                        )");
                        cd = classDeclaration2;
                    }
                    return (J)cd;
                }

                private static final Cursor visitClassDeclaration$lambda-0(methodDeclarationWithComment.1.1.1 this$0) {
                    Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                    return this$0.getCursor().getParentOrThrow();
                }
            };
        }

        private static void methodDeclarationWithComment$lambda-119(RecipeSpec spec) {
            spec.recipe(RewriteTest.toRecipe(DefaultImpls::methodDeclarationWithComment$lambda-119$lambda-118));
        }

        private static TreeVisitor assignmentNotPartOfVariableDeclaration$lambda-121$lambda-120() {
            return (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

                @NotNull
                public J.Assignment visitAssignment(@NotNull J.Assignment assignment2, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)assignment2, (String)"assignment");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    J.Assignment a = assignment2;
                    if (a.getAssignment() instanceof J.MethodInvocation) {
                        Expression expression = a.getAssignment();
                        if (expression == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodInvocation");
                        }
                        J.MethodInvocation mi = (J.MethodInvocation)expression;
                        J.Assignment assignment3 = a.withAssignment((Expression)mi.withTemplate((SourceTemplate)JavaTemplate.builder(() -> (this).getCursor(), (String)"1").build(), mi.getCoordinates().replace(), new Object[0]));
                        Intrinsics.checkNotNullExpressionValue((Object)assignment3, (String)"a.withAssignment(mi.with\u2026                       ))");
                        a = assignment3;
                    }
                    return a;
                }
            };
        }

        private static void assignmentNotPartOfVariableDeclaration$lambda-121(RecipeSpec spec) {
            spec.recipe(RewriteTest.toRecipe(DefaultImpls::assignmentNotPartOfVariableDeclaration$lambda-121$lambda-120));
        }

        private static TreeVisitor assignmentWithinIfPredicate$lambda-123$lambda-122() {
            return (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

                @NotNull
                public J.Assignment visitAssignment(@NotNull J.Assignment assignment2, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)assignment2, (String)"assignment");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    if (assignment2.getAssignment() instanceof J.Literal) {
                        Expression expression = assignment2.getAssignment();
                        if (expression == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Literal");
                        }
                        if (Intrinsics.areEqual((Object)"1", (Object)((J.Literal)expression).getValueSource())) {
                            J j = assignment2.withTemplate((SourceTemplate)JavaTemplate.builder(() -> (this).getCursor(), (String)"value = 0").build(), assignment2.getCoordinates().replace(), new Object[0]);
                            Intrinsics.checkNotNullExpressionValue((Object)j, (String)"assignment.withTemplate(\u2026                        )");
                            return (J.Assignment)j;
                        }
                    }
                    return assignment2;
                }
            };
        }

        private static void assignmentWithinIfPredicate$lambda-123(RecipeSpec spec) {
            spec.recipe(RewriteTest.toRecipe(DefaultImpls::assignmentWithinIfPredicate$lambda-123$lambda-122));
        }

        private static TreeVisitor lambdaIsNewClass$lambda-125$lambda-124() {
            return (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

                @NotNull
                public J.Assignment visitAssignment(@NotNull J.Assignment assignment2, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)assignment2, (String)"assignment");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    J.Assignment a = assignment2;
                    if (a.getAssignment() instanceof J.MethodInvocation) {
                        Expression expression = a.getAssignment();
                        if (expression == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodInvocation");
                        }
                        J.MethodInvocation mi = (J.MethodInvocation)expression;
                        J.Assignment assignment3 = a.withAssignment((Expression)mi.withTemplate((SourceTemplate)JavaTemplate.builder(() -> (this).getCursor(), (String)"1").build(), mi.getCoordinates().replace(), new Object[0]));
                        Intrinsics.checkNotNullExpressionValue((Object)assignment3, (String)"a.withAssignment(mi.with\u2026                       ))");
                        a = assignment3;
                    }
                    return a;
                }
            };
        }

        private static void lambdaIsNewClass$lambda-125(RecipeSpec spec) {
            spec.recipe(RewriteTest.toRecipe(DefaultImpls::lambdaIsNewClass$lambda-125$lambda-124));
        }

        private static TreeVisitor replaceForEachControlVariable$lambda-127$lambda-126() {
            return (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

                @NotNull
                public J.VariableDeclarations visitVariableDeclarations(@NotNull J.VariableDeclarations multiVariable, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)multiVariable, (String)"multiVariable");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    J.VariableDeclarations mv = super.visitVariableDeclarations(multiVariable, (Object)p);
                    if (((J.VariableDeclarations.NamedVariable)mv.getVariables().get(0)).getInitializer() == null) {
                        TypeTree typeTree = mv.getTypeExpression();
                        Intrinsics.checkNotNull((Object)typeTree);
                        if (TypeUtils.isOfType((JavaType)typeTree.getType(), (JavaType)((JavaType)JavaType.Primitive.String))) {
                            Object[] objectArray = new Object[]{((J.VariableDeclarations.NamedVariable)multiVariable.getVariables().get(0)).getSimpleName()};
                            mv = (J.VariableDeclarations)multiVariable.withTemplate((SourceTemplate)JavaTemplate.builder(() -> (this).getCursor(), (String)"Object #{}").build(), multiVariable.getCoordinates().replace(), objectArray);
                        }
                    }
                    J.VariableDeclarations variableDeclarations = mv;
                    Intrinsics.checkNotNullExpressionValue((Object)variableDeclarations, (String)"mv");
                    return variableDeclarations;
                }
            };
        }

        private static void replaceForEachControlVariable$lambda-127(RecipeSpec spec) {
            spec.recipe(RewriteTest.toRecipe(DefaultImpls::replaceForEachControlVariable$lambda-127$lambda-126));
        }

        private static TreeVisitor replaceForEachControlIterator$lambda-129$lambda-128() {
            return (TreeVisitor)new JavaVisitor<ExecutionContext>(){

                @NotNull
                public J visitNewClass(@NotNull J.NewClass newClass, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)newClass, (String)"newClass");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    J nc = super.visitNewClass(newClass, (Object)p);
                    if (TypeUtils.isOfClassType((JavaType)newClass.getType(), (String)"java.util.ArrayList")) {
                        String[] stringArray = new String[]{"java.util.Collections"};
                        nc = nc.withTemplate((SourceTemplate)JavaTemplate.builder(() -> (this).getCursor(), (String)"Collections.emptyList()").imports(stringArray).build(), newClass.getCoordinates().replace(), new Object[0]);
                    }
                    J j = nc;
                    Intrinsics.checkNotNullExpressionValue((Object)j, (String)"nc");
                    return j;
                }
            };
        }

        private static void replaceForEachControlIterator$lambda-129(RecipeSpec spec) {
            spec.recipe(RewriteTest.toRecipe(DefaultImpls::replaceForEachControlIterator$lambda-129$lambda-128));
        }

        private static void chainedMethodInvocationsAsNewClassArgument$lambda-130(JavaTemplateTest this$0, RecipeSpec spec) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            spec.recipe(this$0.getReplaceToStringWithLiteralRecipe());
        }

        private static void chainedMethodInvocationsAsNewClassArgument2$lambda-131(JavaTemplateTest this$0, RecipeSpec spec) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            spec.recipe(this$0.getReplaceToStringWithLiteralRecipe());
        }

        private static TreeVisitor templatingWhileLoopCondition$lambda-133$lambda-132() {
            return (TreeVisitor)new JavaVisitor<ExecutionContext>(){

                @NotNull
                public J visitBinary(@NotNull J.Binary binary2, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)binary2, (String)"binary");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    if (binary2.getLeft() instanceof J.MethodInvocation) {
                        Expression expression = binary2.getLeft();
                        if (expression == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodInvocation");
                        }
                        J.MethodInvocation mi = (J.MethodInvocation)expression;
                        Object[] objectArray = new Object[]{mi.getSelect()};
                        J j = binary2.withTemplate((SourceTemplate)JavaTemplate.builder(() -> (this).getCursor(), (String)"!#{any(java.util.List)}.isEmpty()").build(), mi.getCoordinates().replace(), objectArray);
                        Intrinsics.checkNotNullExpressionValue((Object)j, (String)"binary.withTemplate(\n   \u2026                        )");
                        return j;
                    }
                    if (binary2.getLeft() instanceof J.Unary) {
                        Expression expression = binary2.getLeft();
                        Intrinsics.checkNotNullExpressionValue((Object)expression, (String)"binary.left");
                        return (J)expression;
                    }
                    return (J)binary2;
                }
            };
        }

        private static void templatingWhileLoopCondition$lambda-133(RecipeSpec spec) {
            spec.recipe(RewriteTest.toRecipe(DefaultImpls::templatingWhileLoopCondition$lambda-133$lambda-132));
            spec.expectedCyclesThatMakeChanges(2);
        }

        private static TreeVisitor javaTemplateControlsSemiColons$lambda-135$lambda-134() {
            return (TreeVisitor)new JavaVisitor<ExecutionContext>(){
                @NotNull
                private MethodMatcher BIG_DECIMAL_SET_SCALE;
                private JavaTemplate twoArgScale;
                {
                    this.BIG_DECIMAL_SET_SCALE = new MethodMatcher("java.math.BigDecimal setScale(int, int)");
                    String[] stringArray = new String[]{"java.math.RoundingMode"};
                    this.twoArgScale = JavaTemplate.builder(() -> javaTemplateControlsSemiColons.1.1.1.twoArgScale$lambda-0(this), (String)"#{any(int)}, #{}").imports(stringArray).build();
                }

                @NotNull
                public final MethodMatcher getBIG_DECIMAL_SET_SCALE() {
                    return this.BIG_DECIMAL_SET_SCALE;
                }

                public final void setBIG_DECIMAL_SET_SCALE(@NotNull MethodMatcher methodMatcher) {
                    Intrinsics.checkNotNullParameter((Object)methodMatcher, (String)"<set-?>");
                    this.BIG_DECIMAL_SET_SCALE = methodMatcher;
                }

                public final JavaTemplate getTwoArgScale() {
                    return this.twoArgScale;
                }

                public final void setTwoArgScale(JavaTemplate javaTemplate) {
                    this.twoArgScale = javaTemplate;
                }

                @NotNull
                public J visitMethodInvocation(@NotNull J.MethodInvocation method, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    J j = super.visitMethodInvocation(method, (Object)p);
                    if (j == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodInvocation");
                    }
                    J.MethodInvocation mi = (J.MethodInvocation)j;
                    if (this.BIG_DECIMAL_SET_SCALE.matches(mi)) {
                        Object[] objectArray = new Object[]{mi.getArguments().get(0), "RoundingMode.HALF_UP"};
                        J j2 = mi.withTemplate((SourceTemplate)this.twoArgScale, mi.getCoordinates().replaceArguments(), objectArray);
                        Intrinsics.checkNotNullExpressionValue((Object)j2, (String)"mi.withTemplate(\n       \u2026                        )");
                        mi = (J.MethodInvocation)j2;
                    }
                    return (J)mi;
                }

                private static final Cursor twoArgScale$lambda-0(javaTemplateControlsSemiColons.1.1.1 this$0) {
                    Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                    return this$0.getCursor().getParentOrThrow();
                }
            };
        }

        private static void javaTemplateControlsSemiColons$lambda-135(RecipeSpec spec) {
            spec.recipe(RewriteTest.toRecipe(DefaultImpls::javaTemplateControlsSemiColons$lambda-135$lambda-134));
        }

        private static void enumClassWithAnonymousInnerClassConstructor$lambda-136(JavaTemplateTest this$0, RecipeSpec spec) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            spec.recipe(this$0.getReplaceToStringWithLiteralRecipe());
        }

        private static void replacingMethodInvocationWithinEnum$lambda-137(JavaTemplateTest this$0, RecipeSpec spec) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            spec.recipe(this$0.getReplaceToStringWithLiteralRecipe());
        }

        private static void replacingMethodInvocationWithinInnerEnum$lambda-138(JavaTemplateTest this$0, RecipeSpec spec) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            spec.recipe(this$0.getReplaceToStringWithLiteralRecipe());
        }

        private static TreeVisitor arrayInitializer$lambda-140$lambda-139() {
            return (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){
                @NotNull
                private final MethodMatcher mm;
                {
                    this.mm = new MethodMatcher("abc.ArrayHelper of(..)");
                }

                @NotNull
                public final MethodMatcher getMm() {
                    return this.mm;
                }

                @NotNull
                public J.MethodInvocation visitMethodInvocation(@NotNull J.MethodInvocation method, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    J.MethodInvocation mi = super.visitMethodInvocation(method, (Object)p);
                    if (this.mm.matches(mi)) {
                        Object[] objectArray = new String[]{"java.util.Arrays"};
                        SourceTemplate sourceTemplate = (SourceTemplate)JavaTemplate.builder(() -> (this).getCursor(), (String)"Arrays.asList(#{any(java.lang.Integer)}, #{any(java.lang.Integer)}, #{any(java.lang.Integer)})").imports((String[])objectArray).build();
                        objectArray = new Object[]{mi.getArguments().get(0), mi.getArguments().get(1), mi.getArguments().get(2)};
                        mi = (J.MethodInvocation)mi.withTemplate(sourceTemplate, mi.getCoordinates().replace(), objectArray);
                    }
                    J.MethodInvocation methodInvocation2 = mi;
                    Intrinsics.checkNotNullExpressionValue((Object)methodInvocation2, (String)"mi");
                    return methodInvocation2;
                }
            };
        }

        private static void arrayInitializer$lambda-140(RecipeSpec spec) {
            spec.recipe(RewriteTest.toRecipe(DefaultImpls::arrayInitializer$lambda-140$lambda-139));
        }

        private static TreeVisitor multiDimentionalArrayInitializer$lambda-142$lambda-141() {
            return (TreeVisitor)new JavaVisitor<ExecutionContext>(){
                @NotNull
                private final MethodMatcher mm;
                {
                    this.mm = new MethodMatcher("java.util.stream.IntStream sum()");
                }

                @NotNull
                public final MethodMatcher getMm() {
                    return this.mm;
                }

                @NotNull
                public J visitNewClass(@NotNull J.NewClass newClass, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)newClass, (String)"newClass");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    J j = super.visitNewClass(newClass, (Object)p);
                    if (j == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.NewClass");
                    }
                    J.NewClass nc = (J.NewClass)j;
                    Object[] objectArray = new Object[]{nc.getArguments().get(0)};
                    J j2 = nc.withTemplate((SourceTemplate)JavaTemplate.builder(() -> (this).getCursor(), (String)"Integer.valueOf(#{any(java.lang.Integer)})").build(), nc.getCoordinates().replace(), objectArray);
                    if (j2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J");
                    }
                    return j2;
                }
            };
        }

        private static void multiDimentionalArrayInitializer$lambda-142(RecipeSpec spec) {
            spec.recipe(RewriteTest.toRecipe(DefaultImpls::multiDimentionalArrayInitializer$lambda-142$lambda-141));
        }

        private static TreeVisitor dontDropTheAssert$lambda-144$lambda-143() {
            return (TreeVisitor)new JavaVisitor<ExecutionContext>(){

                @NotNull
                public J visitBinary(@NotNull J.Binary binary2, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)binary2, (String)"binary");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    Expression expression = binary2.getLeft();
                    if (expression == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodInvocation");
                    }
                    J.MethodInvocation sizeCall = (J.MethodInvocation)expression;
                    Object[] objectArray = new Object[]{sizeCall.getSelect()};
                    J j = sizeCall.withTemplate((SourceTemplate)JavaTemplate.builder(() -> dontDropTheAssert.1.1.1.visitBinary$lambda-0(this), (String)"!#{any(java.util.Collection)}.isEmpty()").build(), sizeCall.getCoordinates().replace(), objectArray).withPrefix(binary2.getPrefix());
                    Intrinsics.checkNotNullExpressionValue((Object)j, (String)"sizeCall.withTemplate<J?\u2026withPrefix(binary.prefix)");
                    return j;
                }

                private static final Cursor visitBinary$lambda-0(dontDropTheAssert.1.1.1 this$0) {
                    Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                    return this$0.getCursor();
                }
            };
        }

        private static void dontDropTheAssert$lambda-144(RecipeSpec spec) {
            spec.recipe(RewriteTest.toRecipe(DefaultImpls::dontDropTheAssert$lambda-144$lambda-143));
        }
    }
}

