/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.AddImport;
import org.openrewrite.java.AddImportTest;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaRecipeTest;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.TypeValidator;
import org.openrewrite.java.style.ImportLayoutStyle;
import org.openrewrite.java.tree.J;
import org.openrewrite.style.NamedStyles;
import org.openrewrite.template.SourceTemplate;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0018\bf\u0018\u00002\u00020\u0001:\u0001:J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017JA\u0010\u000b\u001a\u00020\f22\u0010\r\u001a\u001a\u0012\u0016\b\u0001\u0012\u0012\u0012\u000e\u0012\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00020\u00110\u00100\u000f0\u000e\"\u0012\u0012\u000e\u0012\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00020\u00110\u00100\u000fH\u0016\u00a2\u0006\u0002\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u001f\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010 \u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010!\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0018\u0010\"\u001a\u00020\u00032\u000e\u0010\u0004\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030#H\u0017J\u0010\u0010$\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010%\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010&\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010'\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010(\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0018\u0010)\u001a\u00020\u00032\u000e\u0010\u0004\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030#H\u0017J\u0010\u0010*\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010+\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010,\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010-\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\b\u0010.\u001a\u00020\u0003H\u0017J\b\u0010/\u001a\u00020\u0003H\u0017J\b\u00100\u001a\u00020\u0003H\u0017J\b\u00101\u001a\u00020\u0003H\u0017J\b\u00102\u001a\u00020\u0003H\u0017J\u0010\u00103\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u00104\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u00105\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u00106\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u00107\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\b\u00108\u001a\u00020\u0003H\u0017J\u0010\u00109\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017\u00a8\u0006;"}, d2={"Lorg/openrewrite/java/AddImportTest;", "Lorg/openrewrite/java/JavaRecipeTest;", "addFirstImport", "", "jp", "Lorg/openrewrite/java/JavaParser;", "addImportAndFoldIntoWildcard", "addImportBeforeImportWithSameInsertIndex", "addImportIfReferenced", "addImportInsertsNewMiddleBlock", "addImportWhenDuplicatesExist", "addImports", "Lorg/openrewrite/Recipe;", "adds", "", "Lkotlin/Function0;", "Lorg/openrewrite/TreeVisitor;", "Lorg/openrewrite/ExecutionContext;", "([Lkotlin/jvm/functions/Function0;)Lorg/openrewrite/Recipe;", "addMultipleImports", "addNamedImport", "addNamedImportIfStarStaticImportExists", "addNamedStaticImport", "addNamedStaticImportWhenReferenced", "addStaticImportForReferencedField", "addStaticImportForUnreferencedField", "addStaticWildcardImportWhenReferenced", "doNotAddImportIfAlreadyExists", "doNotAddImportIfCoveredByStarImport", "doNotAddImportIfNotReferenced", "doNotAddNamedStaticImportIfNotReferenced", "doNotAddWildcardImportIfNotReferenced", "doNotFoldNormalImportWithNamespaceConflict", "dontAddImportForPrimitive", "dontAddImportForStaticImportsIndirectlyReferenced", "Lorg/openrewrite/java/JavaParser$Builder;", "dontAddImportToStaticFieldWithNamespaceConflict", "dontAddImportWhenClassHasNoPackage", "dontAddStaticWildcardImportIfNotReferenced", "dontDuplicateImports", "dontDuplicateImports2", "dontDuplicateImports3", "dontImportFromSamePackage", "dontImportJavaLang", "dontImportJavaLangWhenUsingDefaultPackage", "dontImportYourself", "foldPackageWithEmptyImports", "foldPackageWithExistingImports", "foldStaticSubPackageWithEmptyImports", "foldStaticSubPackageWithExistingImports", "foldSubPackageWithExistingImports", "importIsAddedToCorrectBlock", "importOrderingIssue", "importsAddedInAlphabeticalOrder", "lastImportWhenFirstClassDeclarationHasJavadoc", "namedImportAddedAfterPackageDeclaration", "noImportLayout", "unorderedImportsWithNewBlock", "FixEmptyListMethodType", "rewrite-java-tck"})
public interface AddImportTest
extends JavaRecipeTest {
    @NotNull
    public Recipe addImports(Function0<? extends TreeVisitor<?, ExecutionContext>> ... var1);

    @Test
    public void addImportBeforeImportWithSameInsertIndex(@NotNull JavaParser var1);

    @Test
    public void importIsAddedToCorrectBlock(@NotNull JavaParser var1);

    @Test
    public void dontDuplicateImports(@NotNull JavaParser var1);

    @Test
    public void dontDuplicateImports2(@NotNull JavaParser var1);

    @Test
    public void dontDuplicateImports3(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    public void dontImportYourself(@NotNull JavaParser var1);

    @Test
    public void dontImportJavaLang(@NotNull JavaParser var1);

    @Test
    public void dontImportJavaLangWhenUsingDefaultPackage(@NotNull JavaParser var1);

    @Test
    public void dontImportFromSamePackage(@NotNull JavaParser var1);

    @Test
    public void importOrderingIssue(@NotNull JavaParser var1);

    @Test
    public void addMultipleImports(@NotNull JavaParser var1);

    @Test
    public void addNamedImport(@NotNull JavaParser var1);

    @Test
    public void doNotAddImportIfNotReferenced(@NotNull JavaParser var1);

    @Test
    public void addImportInsertsNewMiddleBlock(@NotNull JavaParser var1);

    @Test
    public void addFirstImport(@NotNull JavaParser var1);

    @Test
    public void addImportIfReferenced(@NotNull JavaParser var1);

    @Test
    public void doNotAddWildcardImportIfNotReferenced(@NotNull JavaParser var1);

    @Test
    public void lastImportWhenFirstClassDeclarationHasJavadoc(@NotNull JavaParser var1);

    @Test
    public void namedImportAddedAfterPackageDeclaration(@NotNull JavaParser var1);

    @Test
    public void importsAddedInAlphabeticalOrder(@NotNull JavaParser var1);

    @Test
    public void doNotAddImportIfAlreadyExists(@NotNull JavaParser var1);

    @Test
    public void doNotAddImportIfCoveredByStarImport(@NotNull JavaParser var1);

    @Test
    public void dontAddImportWhenClassHasNoPackage(@NotNull JavaParser var1);

    @Test
    public void dontAddImportForPrimitive(@NotNull JavaParser var1);

    @Test
    public void addNamedImportIfStarStaticImportExists(@NotNull JavaParser var1);

    @Test
    public void addNamedStaticImport(@NotNull JavaParser var1);

    @Test
    public void addStaticImportForUnreferencedField(@NotNull JavaParser var1);

    @Test
    public void addStaticImportForReferencedField(@NotNull JavaParser var1);

    @Test
    public void dontAddImportToStaticFieldWithNamespaceConflict(@NotNull JavaParser var1);

    @Test
    public void dontAddStaticWildcardImportIfNotReferenced(@NotNull JavaParser var1);

    @Test
    public void addNamedStaticImportWhenReferenced(@NotNull JavaParser var1);

    @Test
    public void doNotAddNamedStaticImportIfNotReferenced(@NotNull JavaParser var1);

    @Test
    public void addStaticWildcardImportWhenReferenced(@NotNull JavaParser var1);

    @Test
    public void dontAddImportForStaticImportsIndirectlyReferenced(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    public void addImportAndFoldIntoWildcard(@NotNull JavaParser var1);

    @Test
    public void addImportWhenDuplicatesExist(@NotNull JavaParser var1);

    @Test
    public void unorderedImportsWithNewBlock(@NotNull JavaParser var1);

    @Test
    public void doNotFoldNormalImportWithNamespaceConflict(@NotNull JavaParser var1);

    @Test
    public void foldPackageWithEmptyImports();

    @Test
    public void foldPackageWithExistingImports();

    @Test
    public void foldSubPackageWithExistingImports();

    @Test
    public void foldStaticSubPackageWithEmptyImports();

    @Test
    public void noImportLayout();

    @Test
    public void foldStaticSubPackageWithExistingImports();

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\b\u0010\u0005\u001a\u00020\u0004H\u0016J\u0012\u0010\u0006\u001a\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00020\b0\u0007H\u0014\u00a8\u0006\t"}, d2={"Lorg/openrewrite/java/AddImportTest$FixEmptyListMethodType;", "Lorg/openrewrite/Recipe;", "()V", "getDescription", "", "getDisplayName", "getVisitor", "Lorg/openrewrite/TreeVisitor;", "Lorg/openrewrite/ExecutionContext;", "rewrite-java-tck"})
    private static final class FixEmptyListMethodType
    extends Recipe {
        @NotNull
        public String getDisplayName() {
            return "Fix Empty List";
        }

        @NotNull
        public String getDescription() {
            return "AddImportTest testing recipe.";
        }

        @NotNull
        protected TreeVisitor<?, ExecutionContext> getVisitor() {
            return (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

                @NotNull
                public J.MethodInvocation visitMethodInvocation(@NotNull J.MethodInvocation method, @NotNull ExecutionContext ctx) {
                    Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                    Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                    J.MethodInvocation methodInvocation2 = super.visitMethodInvocation(method, (Object)ctx);
                    Intrinsics.checkNotNullExpressionValue((Object)methodInvocation2, (String)"super.visitMethodInvocation(method, ctx)");
                    J.MethodInvocation original = methodInvocation2;
                    if (Intrinsics.areEqual((Object)original.getName().getSimpleName(), (Object)"emptyList")) {
                        J.MethodInvocation methodInvocation3 = original.withSelect(null);
                        Intrinsics.checkNotNullExpressionValue((Object)methodInvocation3, (String)"original.withSelect(null)");
                        return methodInvocation3;
                    }
                    return original;
                }
            };
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        /*
         * WARNING - void declaration
         */
        @NotNull
        public static Recipe addImports(@NotNull AddImportTest this_, Function0<? extends TreeVisitor<?, ExecutionContext>> ... adds) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(adds, (String)"adds");
            Function0<? extends TreeVisitor<?, ExecutionContext>>[] $this$map$iv = adds;
            boolean $i$f$map = false;
            Function0<? extends TreeVisitor<?, ExecutionContext>>[] function0Array = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo2 = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void add;
                void item$iv$iv;
                void var10_12 = item$iv$iv = $this$mapTo$iv$iv[i];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(this_.toRecipe((Function0)add));
            }
            Iterable $this$reduce$iv = (List)destination$iv$iv;
            boolean $i$f$reduce = false;
            Iterator iterator$iv = $this$reduce$iv.iterator();
            if (!iterator$iv.hasNext()) {
                throw new UnsupportedOperationException("Empty collection can't be reduced.");
            }
            Object accumulator$iv = iterator$iv.next();
            if (iterator$iv.hasNext()) {
                void r2;
                Recipe $i$f$mapTo2 = (Recipe)iterator$iv.next();
                Recipe r1 = (Recipe)accumulator$iv;
                boolean bl = false;
                Recipe recipe2 = r1.doNext((Recipe)r2);
                Intrinsics.checkNotNullExpressionValue((Object)recipe2, (String)"r1.doNext(r2)");
                return recipe2;
            }
            return (Recipe)accumulator$iv;
        }

        @Test
        public static void addImportBeforeImportWithSameInsertIndex(@NotNull AddImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Function0[] function0Array = new Function0[]{addImportBeforeImportWithSameInsertIndex.1.INSTANCE};
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.addImports(function0Array), null, "\n            import static org.junit.jupiter.api.Assertions.assertTrue;\n\n            import org.junit.Test;\n\n            public class MyTest {\n            }\n        ", null, "\n            import static org.junit.jupiter.api.Assertions.assertFalse;\n            import static org.junit.jupiter.api.Assertions.assertTrue;\n\n            import org.junit.Test;\n\n            public class MyTest {\n            }\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void importIsAddedToCorrectBlock(@NotNull AddImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Function0[] function0Array = new Function0[]{importIsAddedToCorrectBlock.1.INSTANCE};
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.addImports(function0Array), null, "\n            import java.util.List;\n\n            import org.junit.jupiter.api.extension.ExtendWith;\n            import org.mockito.Mock;\n\n            public class MyTest {\n            }\n        ", null, "\n            import java.util.List;\n\n            import org.junit.jupiter.api.extension.ExtendWith;\n            import org.mockito.Mock;\n            import org.mockito.junit.jupiter.MockitoExtension;\n\n            public class MyTest {\n            }\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void dontDuplicateImports(@NotNull AddImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Function0[] function0Array = new Function0[]{dontDuplicateImports.1.INSTANCE, dontDuplicateImports.2.INSTANCE};
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.addImports(function0Array), null, "class A {}", null, "\n            import org.springframework.http.HttpStatus;\n            import org.springframework.http.HttpStatus.Series;\n            \n            class A {}\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void dontDuplicateImports2(@NotNull AddImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Function0[] function0Array = new Function0[]{dontDuplicateImports2.1.INSTANCE};
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.addImports(function0Array), null, "\n            import org.junit.jupiter.api.AfterEach;\n            import org.junit.jupiter.api.Assertions;\n            import org.junit.jupiter.api.BeforeAll;\n            import org.junit.jupiter.api.BeforeEach;\n            import org.slf4j.Logger;\n            import org.slf4j.LoggerFactory;\n\n            class A {}\n        ", null, "\n            import org.junit.jupiter.api.*;\n            import org.slf4j.Logger;\n            import org.slf4j.LoggerFactory;\n            \n            class A {}\n        ", 1, 1, null, null, 788, null);
        }

        @Test
        public static void dontDuplicateImports3(@NotNull AddImportTest this_, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            JavaRecipeTest javaRecipeTest = this_;
            String[] stringArray = new String[]{"junit-jupiter-api"};
            JavaParser javaParser = jp.classpath(stringArray).build();
            Intrinsics.checkNotNullExpressionValue((Object)javaParser, (String)"jp.classpath(\"junit-jupiter-api\").build()");
            Function0[] function0Array = new Function0[]{dontDuplicateImports3.1.INSTANCE};
            JavaRecipeTest.DefaultImpls.assertChanged$default(javaRecipeTest, javaParser, this_.addImports(function0Array), null, "\n            import static org.junit.jupiter.api.Assertions.assertFalse;\n            import static org.junit.jupiter.api.Assertions.assertTrue;\n            \n            import java.util.List;\n\n            class A {}\n        ", null, "\n            import static org.junit.jupiter.api.Assertions.*;\n            \n            import java.util.List;\n            \n            class A {}\n        ", 1, 1, null, null, 788, null);
        }

        @Test
        public static void dontImportYourself(@NotNull AddImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Function0[] function0Array = new Function0[]{dontImportYourself.1.INSTANCE};
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, jp, this_.addImports(function0Array), null, "\n            package com.myorg;\n            \n            class A {\n            }\n        ", null, 20, null);
        }

        @Test
        public static void dontImportJavaLang(@NotNull AddImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Function0[] function0Array = new Function0[]{dontImportJavaLang.1.INSTANCE};
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, jp, this_.addImports(function0Array), null, "\n            package com.myorg;\n\n            class A {\n            }\n        ", null, 20, null);
        }

        @Test
        public static void dontImportJavaLangWhenUsingDefaultPackage(@NotNull AddImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Function0[] function0Array = new Function0[]{dontImportJavaLangWhenUsingDefaultPackage.1.INSTANCE};
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, jp, this_.addImports(function0Array), null, "\n            class A {\n            }\n        ", null, 20, null);
        }

        @Test
        public static void dontImportFromSamePackage(@NotNull AddImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Object[] objectArray = new Function0[]{dontImportFromSamePackage.1.INSTANCE};
            Recipe recipe2 = this_.addImports((Function0<? extends TreeVisitor<?, ExecutionContext>>[])objectArray);
            String[] stringArray = new String[]{"\n            package com.myorg;\n            \n            class B {\n            }\n        "};
            objectArray = stringArray;
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, jp, recipe2, null, "\n            package com.myorg;\n            \n            class A {\n            }\n        ", (String[])objectArray, 4, null);
        }

        @Test
        public static void importOrderingIssue(@NotNull AddImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Function0[] function0Array = new Function0[]{importOrderingIssue.1.INSTANCE};
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.addImports(function0Array), null, "\n            import javax.ws.rs.core.Response.ResponseBuilder;\n            import java.util.Locale;\n\n            class A {}\n        ", null, "\n            import org.springframework.http.HttpHeaders;\n\n            import javax.ws.rs.core.Response.ResponseBuilder;\n            import java.util.Locale;\n\n            class A {}\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void addMultipleImports(@NotNull AddImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Function0[] function0Array = new Function0[]{addMultipleImports.1.INSTANCE, addMultipleImports.2.INSTANCE};
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.addImports(function0Array), null, "\n            class A {}\n        ", null, "\n            import java.util.List;\n            import java.util.Set;\n\n            class A {}\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void addNamedImport(@NotNull AddImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Function0[] function0Array = new Function0[]{addNamedImport.1.INSTANCE};
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.addImports(function0Array), null, "class A {}", null, "\n            import java.util.List;\n            \n            class A {}\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void doNotAddImportIfNotReferenced(@NotNull AddImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Function0[] function0Array = new Function0[]{doNotAddImportIfNotReferenced.1.INSTANCE};
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, jp, this_.addImports(function0Array), null, "\n            package a;\n            \n            class A {}\n        ", null, 20, null);
        }

        @Test
        public static void addImportInsertsNewMiddleBlock(@NotNull AddImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Function0[] function0Array = new Function0[]{addImportInsertsNewMiddleBlock.1.INSTANCE};
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.addImports(function0Array), null, "\n            package a;\n            \n            import com.sun.naming.*;\n            \n            import static java.util.Collections.*;\n            \n            class A {}\n        ", null, "\n            package a;\n            \n            import com.sun.naming.*;\n            \n            import java.util.List;\n            \n            import static java.util.Collections.*;\n            \n            class A {}\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void addFirstImport(@NotNull AddImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Function0[] function0Array = new Function0[]{addFirstImport.1.INSTANCE};
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.addImports(function0Array), null, "\n            package a;\n            \n            class A {}\n        ", null, "\n            package a;\n            \n            import java.util.List;\n            \n            class A {}\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void addImportIfReferenced(@NotNull AddImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.toRecipe(addImportIfReferenced.1.INSTANCE), null, "\n            package a;\n\n            class A {\n            }\n        ", null, "\n            package a;\n            \n            import java.math.BigDecimal;\n            import java.math.RoundingMode;\n            \n            class A {\n                BigDecimal d = BigDecimal.valueOf(1).setScale(1, RoundingMode.HALF_EVEN);\n            }\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void doNotAddWildcardImportIfNotReferenced(@NotNull AddImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Function0[] function0Array = new Function0[]{doNotAddWildcardImportIfNotReferenced.1.INSTANCE};
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, jp, this_.addImports(function0Array), null, "\n            package a;\n            \n            class A {}\n        ", null, 20, null);
        }

        @Test
        public static void lastImportWhenFirstClassDeclarationHasJavadoc(@NotNull AddImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Function0[] function0Array = new Function0[]{lastImportWhenFirstClassDeclarationHasJavadoc.1.INSTANCE};
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.addImports(function0Array), null, "\n            import java.util.List;\n            \n            /**\n             * My type\n             */\n            class A {}\n        ", null, "\n            import java.util.List;\n            \n            import static java.util.Collections.*;\n            \n            /**\n             * My type\n             */\n            class A {}\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void namedImportAddedAfterPackageDeclaration(@NotNull AddImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Function0[] function0Array = new Function0[]{namedImportAddedAfterPackageDeclaration.1.INSTANCE};
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.addImports(function0Array), null, "\n            package a;\n            class A {}\n        ", null, "\n            package a;\n            \n            import java.util.List;\n            \n            class A {}\n        ", 0, 0, null, null, 980, null);
        }

        /*
         * WARNING - void declaration
         */
        @Test
        public static void importsAddedInAlphabeticalOrder(@NotNull AddImportTest this_, @NotNull JavaParser jp) {
            String string;
            void $this$mapIndexedTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Object[] objectArray = new String[]{"c", "c.c", "c.c.c"};
            List otherPackages = CollectionsKt.listOf((Object[])objectArray);
            Object[] $this$mapIndexed$iv = (Object[])otherPackages;
            boolean $i$f$mapIndexed = false;
            Object[] objectArray2 = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void i;
                void pkg;
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                string = (String)item$iv$iv;
                int n2 = n;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add("package " + (String)pkg + ";\npublic class C" + (int)i + " {}");
            }
            List otherImports = (List)destination$iv$iv;
            $this$mapIndexed$iv = new Pair[]{TuplesKt.to((Object)"b", (Object)0), TuplesKt.to((Object)"c.b", (Object)1), TuplesKt.to((Object)"c.c.b", (Object)2)};
            Iterable $this$forEach$iv = CollectionsKt.listOf((Object[])$this$mapIndexed$iv);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                void $this$mapIndexedTo$iv$iv2;
                Pair it = (Pair)element$iv;
                boolean bl = false;
                String pkg = (String)it.component1();
                int order = ((Number)it.component2()).intValue();
                Iterable $this$mapIndexed$iv2 = otherPackages;
                boolean $i$f$mapIndexed2 = false;
                Iterable i = $this$mapIndexed$iv2;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv2, (int)10));
                boolean $i$f$mapIndexedTo2 = false;
                int index$iv$iv2 = 0;
                for (Object item$iv$iv : $this$mapIndexedTo$iv$iv2) {
                    void i2;
                    void otherPkg;
                    int n;
                    if ((n = index$iv$iv2++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    String string2 = (String)item$iv$iv;
                    int n3 = n;
                    Collection collection = destination$iv$iv2;
                    boolean bl2 = false;
                    collection.add((String)otherPkg + ".C" + (int)i2);
                }
                List expectedImports = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv2));
                expectedImports.add(order, pkg + ".B");
                string = new SpreadBuilder(2);
                Collection $this$toTypedArray$iv = otherImports;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                String[] stringArray = thisCollection$iv.toArray(new String[0]);
                if (stringArray == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                }
                string.addSpread((Object)stringArray);
                string.add((Object)("\n                            package " + pkg + ";\n                            public class B {}\n                        "));
                String[] stringArray2 = (String[])string.toArray((Object[])new String[string.size()]);
                Object object = new Function0[]{new Function0<TreeVisitor<?, ExecutionContext>>(pkg){
                    final /* synthetic */ String $pkg;
                    {
                        this.$pkg = $pkg;
                        super(0);
                    }

                    @NotNull
                    public final TreeVisitor<?, ExecutionContext> invoke() {
                        return (TreeVisitor)new AddImport(this.$pkg + ".B", null, false);
                    }
                }};
                string = this_.addImports((Function0<? extends TreeVisitor<?, ExecutionContext>>)object);
                object = "package a;\n\n" + CollectionsKt.joinToString$default((Iterable)expectedImports, (CharSequence)"\n", null, null, (int)0, null, (Function1)importsAddedInAlphabeticalOrder.1.2.INSTANCE, (int)30, null) + "\n\nclass A {}";
                JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, (Recipe)string, null, "\n                    package a;\n        \n                    import c.C0;\n                    import c.c.C1;\n                    import c.c.c.C2;\n        \n                    class A {}\n                ", stringArray2, (String)object, 0, 0, null, null, 964, null);
                jp.reset();
            }
        }

        @Test
        public static void doNotAddImportIfAlreadyExists(@NotNull AddImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Function0[] function0Array = new Function0[]{doNotAddImportIfAlreadyExists.1.INSTANCE};
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, jp, this_.addImports(function0Array), null, "\n            package a;\n            \n            import java.util.List;\n            class A {}\n        ", null, 20, null);
        }

        @Test
        public static void doNotAddImportIfCoveredByStarImport(@NotNull AddImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Function0[] function0Array = new Function0[]{doNotAddImportIfCoveredByStarImport.1.INSTANCE};
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, jp, this_.addImports(function0Array), null, "\n            package a;\n            \n            import java.util.*;\n            class A {}\n        ", null, 20, null);
        }

        @Test
        public static void dontAddImportWhenClassHasNoPackage(@NotNull AddImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Function0[] function0Array = new Function0[]{dontAddImportWhenClassHasNoPackage.1.INSTANCE};
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, jp, this_.addImports(function0Array), null, "class A {}", null, 20, null);
        }

        @Test
        public static void dontAddImportForPrimitive(@NotNull AddImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Function0[] function0Array = new Function0[]{dontAddImportForPrimitive.1.INSTANCE};
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, jp, this_.addImports(function0Array), null, "class A {}", null, 20, null);
        }

        @Test
        public static void addNamedImportIfStarStaticImportExists(@NotNull AddImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Function0[] function0Array = new Function0[]{addNamedImportIfStarStaticImportExists.1.INSTANCE};
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.addImports(function0Array), null, "\n            package a;\n            \n            import static java.util.List.*;\n            class A {}\n        ", null, "\n            package a;\n            \n            import java.util.List;\n            \n            import static java.util.List.*;\n            \n            class A {}\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void addNamedStaticImport(@NotNull AddImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Function0[] function0Array = new Function0[]{addNamedStaticImport.1.INSTANCE};
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.addImports(function0Array), null, "\n            import java.util.*;\n            class A {}\n        ", null, "\n            import java.util.*;\n            \n            import static java.util.Collections.emptyList;\n            \n            class A {}\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void addStaticImportForUnreferencedField(@NotNull AddImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Object[] objectArray = new Function0[]{addStaticImportForUnreferencedField.1.INSTANCE};
            Recipe recipe2 = this_.addImports((Function0<? extends TreeVisitor<?, ExecutionContext>>[])objectArray);
            String[] stringArray = new String[]{"\n                package mycompany;\n                \n                public class Type {\n                    public static String FIELD;\n                }\n            "};
            objectArray = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, recipe2, null, "class A {}", (String[])objectArray, "\n            import static mycompany.Type.FIELD;\n            \n            class A {}\n        ", 0, 0, null, null, 964, null);
        }

        @Test
        public static void addStaticImportForReferencedField(@NotNull AddImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, new Recipe(){

                @NotNull
                public String getDisplayName() {
                    return "test";
                }

                @NotNull
                public String getDescription() {
                    return "Test recipe.";
                }

                @NotNull
                protected addStaticImportForReferencedField.getVisitor.1 getVisitor() {
                    return new JavaIsoVisitor<ExecutionContext>(){

                        @NotNull
                        public J.ClassDeclaration visitClassDeclaration(@NotNull J.ClassDeclaration classDecl, @NotNull ExecutionContext ctx) {
                            Intrinsics.checkNotNullParameter((Object)classDecl, (String)"classDecl");
                            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                            J.ClassDeclaration cd = classDecl;
                            List list = cd.getBody().getStatements();
                            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"cd.body.statements");
                            if (!((Collection)list).isEmpty()) {
                                return cd;
                            }
                            String[] stringArray = new String[]{"java.time.temporal.ChronoUnit"};
                            JavaTemplate.Builder builder = JavaTemplate.builder(() -> (this).getCursor(), (String)"ChronoUnit unit = MILLIS;").imports(stringArray);
                            stringArray = new String[]{"java.time.temporal.ChronoUnit.MILLIS"};
                            J j = cd.withTemplate((SourceTemplate)builder.staticImports(stringArray).build(), cd.getBody().getCoordinates().lastStatement(), new Object[0]);
                            Intrinsics.checkNotNullExpressionValue((Object)j, (String)"cd.withTemplate(\n       \u2026t()\n                    )");
                            cd = (J.ClassDeclaration)j;
                            this.maybeAddImport("java.time.temporal.ChronoUnit");
                            this.maybeAddImport("java.time.temporal.ChronoUnit", "MILLIS");
                            return cd;
                        }
                    };
                }
            }, null, "\n            public class A {\n            \n            }\n        ", null, "\n            import java.time.temporal.ChronoUnit;\n            \n            import static java.time.temporal.ChronoUnit.MILLIS;\n            \n            public class A {\n                ChronoUnit unit = MILLIS;\n            \n            }\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void dontAddImportToStaticFieldWithNamespaceConflict(@NotNull AddImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Function0[] function0Array = new Function0[]{dontAddImportToStaticFieldWithNamespaceConflict.1.INSTANCE};
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, null, this_.addImports(function0Array), null, "\n            package a;\n            \n            import java.time.temporal.ChronoUnit;\n            \n            class A {\n                static final int MILLIS = 1;\n                ChronoUnit unit = ChronoUnit.MILLIS;\n            }\n        ", null, 21, null);
        }

        @Test
        public static void dontAddStaticWildcardImportIfNotReferenced(@NotNull AddImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Function0[] function0Array = new Function0[]{dontAddStaticWildcardImportIfNotReferenced.1.INSTANCE};
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, jp, this_.addImports(function0Array), null, "\n            package a;\n            \n            class A {}\n        ", null, 20, null);
        }

        @Test
        public static void addNamedStaticImportWhenReferenced(@NotNull AddImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest javaRecipeTest = this_;
            Function0[] function0Array = new Function0[]{addNamedStaticImportWhenReferenced.2.INSTANCE};
            Recipe recipe2 = new Recipe(){

                @NotNull
                public String getDisplayName() {
                    return "test";
                }

                @NotNull
                public String getDescription() {
                    return "Test recipe.";
                }

                @NotNull
                protected TreeVisitor<?, ExecutionContext> getVisitor() {
                    return (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

                        public J.MethodInvocation visitMethodInvocation(@NotNull J.MethodInvocation m, @NotNull ExecutionContext ctx) {
                            Intrinsics.checkNotNullParameter((Object)m, (String)"m");
                            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                            return m.withSelect(null);
                        }
                    };
                }
            }.doNext(this_.addImports(function0Array));
            Intrinsics.checkNotNullExpressionValue((Object)recipe2, (String)"object : Recipe() {\n    \u2026List\", true) })\n        )");
            JavaRecipeTest.DefaultImpls.assertChanged$default(javaRecipeTest, jp, recipe2, null, "\n            package a;\n            \n            import java.util.List;\n            \n            class A {\n                public A() {\n                    List<String> list = java.util.Collections.emptyList();\n                }\n            }\n        ", null, "\n            package a;\n            \n            import java.util.List;\n            \n            import static java.util.Collections.emptyList;\n            \n            class A {\n                public A() {\n                    List<String> list = emptyList();\n                }\n            }\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void doNotAddNamedStaticImportIfNotReferenced(@NotNull AddImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Function0[] function0Array = new Function0[]{doNotAddNamedStaticImportIfNotReferenced.1.INSTANCE};
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, jp, this_.addImports(function0Array), null, "\n            package a;\n            \n            class A {}\n        ", null, 20, null);
        }

        @Test
        public static void addStaticWildcardImportWhenReferenced(@NotNull AddImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest javaRecipeTest = this_;
            Function0[] function0Array = new Function0[]{addStaticWildcardImportWhenReferenced.1.INSTANCE};
            Recipe recipe2 = new FixEmptyListMethodType().doNext(this_.addImports(function0Array));
            Intrinsics.checkNotNullExpressionValue((Object)recipe2, (String)"FixEmptyListMethodType()\u2026}\n            )\n        )");
            JavaRecipeTest.DefaultImpls.assertChanged$default(javaRecipeTest, jp, recipe2, null, "\n            package a;\n            \n            import java.util.List;\n            \n            class A {\n                public A() {\n                    List<String> list = java.util.Collections.emptyList();\n                }\n            }\n        ", null, "\n            package a;\n            \n            import java.util.List;\n            \n            import static java.util.Collections.*;\n            \n            class A {\n                public A() {\n                    List<String> list = emptyList();\n                }\n            }\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void dontAddImportForStaticImportsIndirectlyReferenced(@NotNull AddImportTest this_, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            String[] stringArray = new String[]{"jackson-databind"};
            JavaParser javaParser = jp.classpath(stringArray).build();
            stringArray = this_.toRecipe(dontAddImportForStaticImportsIndirectlyReferenced.1.INSTANCE);
            String[] stringArray2 = new String[]{"\n                import com.fasterxml.jackson.databind.ObjectMapper;\n                class Helper {\n                    static ObjectMapper OBJECT_MAPPER;\n                }\n            "};
            String[] stringArray3 = stringArray2;
            JavaRecipeTest javaRecipeTest = this_;
            Intrinsics.checkNotNullExpressionValue((Object)javaParser, (String)"build()");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(javaRecipeTest, javaParser, (Recipe)stringArray, null, "\n            class Test {\n                void test() {\n                    Helper.OBJECT_MAPPER.writer();\n                }\n            }\n        ", stringArray3, 4, null);
        }

        @Test
        public static void addImportAndFoldIntoWildcard(@NotNull AddImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Recipe recipe2 = new Recipe[]{"\n                package foo;\n                public class B {\n                }\n                public class C {\n                }\n            "};
            Recipe recipe3 = recipe2;
            Function0[] function0Array = new Function0[]{addImportAndFoldIntoWildcard.1.INSTANCE};
            recipe2 = this_.addImports(function0Array);
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, recipe2, null, "\n            import foo.B;\n            import foo.C;\n            \n            import java.util.Collections;\n            import java.util.List;\n            import java.util.HashSet;\n            import java.util.HashMap;\n            import java.util.Map;\n            import java.util.Set;\n            \n            class A {\n                B b = new B();\n                C c = new C();\n                Map<String, String> map = new HashMap<>();\n                Set<String> set = new HashSet<>();\n                List<String> test = Collections.singletonList(\"test\");\n                List<String> test2 = new ArrayList<>();\n            }\n        ", (String[])recipe3, "\n            import foo.B;\n            import foo.C;\n            \n            import java.util.*;\n\n            class A {\n                B b = new B();\n                C c = new C();\n                Map<String, String> map = new HashMap<>();\n                Set<String> set = new HashSet<>();\n                List<String> test = Collections.singletonList(\"test\");\n                List<String> test2 = new ArrayList<>();\n            }\n        ", 0, 0, null, null, 964, null);
        }

        @Test
        public static void addImportWhenDuplicatesExist(@NotNull AddImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Function0[] function0Array = new Function0[]{addImportWhenDuplicatesExist.1.INSTANCE};
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.addImports(function0Array), null, "\n            import javax.ws.rs.Path;\n            import javax.ws.rs.Path;\n            \n            class A {}\n        ", null, "\n            import org.springframework.http.MediaType;\n            \n            import javax.ws.rs.Path;\n            import javax.ws.rs.Path;\n            \n            class A {}\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void unorderedImportsWithNewBlock(@NotNull AddImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Function0[] function0Array = new Function0[]{unorderedImportsWithNewBlock.1.INSTANCE};
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.addImports(function0Array), null, "\n            import org.foo.B;\n            import org.foo.A;\n            \n            class A {}\n        ", null, "\n            import org.foo.B;\n            import org.foo.A;\n            \n            import java.time.Duration;\n            \n            class A {}\n        ", 0, 0, null, null, 980, null);
        }

        /*
         * WARNING - void declaration
         */
        @Test
        public static void doNotFoldNormalImportWithNamespaceConflict(@NotNull AddImportTest this_, @NotNull JavaParser jp) {
            void $this$doNotFoldNormalImportWithNamespaceConflict_u24lambda_u2d5;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            ExecutionContext executionContext = new ExecutionContext[]{doNotFoldNormalImportWithNamespaceConflict.1.INSTANCE};
            Recipe recipe2 = this_.addImports((Function0<? extends TreeVisitor<?, ExecutionContext>>)executionContext);
            ExecutionContext executionContext2 = executionContext = this_.getExecutionContext();
            Recipe recipe3 = recipe2;
            JavaParser javaParser = jp;
            JavaRecipeTest javaRecipeTest = this_;
            boolean bl = false;
            $this$doNotFoldNormalImportWithNamespaceConflict_u24lambda_u2d5.putMessage("org.openrewrite.java.skipSourceSetTypeGeneration", (Object)false);
            Unit unit = Unit.INSTANCE;
            JavaRecipeTest.DefaultImpls.assertChanged$default(javaRecipeTest, javaParser, recipe3, executionContext, "\n            import java.awt.*; // contains a List class\n            import java.util.Collection;\n            import java.util.Collections;\n            import java.util.Map;\n            import java.util.Set;\n            \n            @SuppressWarnings(\"ALL\")\n            class Test {\n                List list;\n            }\n        ", null, "\n            import java.awt.*; // contains a List class\n            import java.util.Collection;\n            import java.util.Collections;\n            import java.util.List;\n            import java.util.Map;\n            import java.util.Set;\n            \n            @SuppressWarnings(\"ALL\")\n            class Test {\n                List list;\n            }\n        ", 0, 0, null, null, 976, null);
        }

        @Test
        public static void foldPackageWithEmptyImports(@NotNull AddImportTest this_) {
            JavaRecipeTest javaRecipeTest = this_;
            JavaParser javaParser = JavaParser.fromJavaVersion().styles((Iterable)CollectionsKt.listOf((Object)new NamedStyles(Tree.randomId(), "test", "test", "test", SetsKt.emptySet(), (Collection)CollectionsKt.listOf((Object)ImportLayoutStyle.builder().packageToFold("java.util.*").importAllOthers().importStaticAllOthers().build())))).build();
            Intrinsics.checkNotNullExpressionValue((Object)javaParser, (String)"fromJavaVersion().styles\u2026      )\n        ).build()");
            Function0[] function0Array = new Function0[]{foldPackageWithEmptyImports.1.INSTANCE};
            JavaRecipeTest.DefaultImpls.assertChanged$default(javaRecipeTest, javaParser, this_.addImports(function0Array), null, "\n        ", null, "\n            import java.util.*;\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void foldPackageWithExistingImports(@NotNull AddImportTest this_) {
            JavaRecipeTest javaRecipeTest = this_;
            JavaParser javaParser = JavaParser.fromJavaVersion().styles((Iterable)CollectionsKt.listOf((Object)new NamedStyles(Tree.randomId(), "test", "test", "test", SetsKt.emptySet(), (Collection)CollectionsKt.listOf((Object)ImportLayoutStyle.builder().packageToFold("java.util.*", Boolean.valueOf(false)).importAllOthers().importStaticAllOthers().build())))).build();
            Intrinsics.checkNotNullExpressionValue((Object)javaParser, (String)"fromJavaVersion().styles\u2026      )\n        ).build()");
            Function0[] function0Array = new Function0[]{foldPackageWithExistingImports.1.INSTANCE};
            JavaRecipeTest.DefaultImpls.assertChanged$default(javaRecipeTest, javaParser, this_.addImports(function0Array), null, "\n            import java.util.List;\n        ", null, "\n            import java.util.*;\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void foldSubPackageWithExistingImports(@NotNull AddImportTest this_) {
            JavaRecipeTest javaRecipeTest = this_;
            JavaParser javaParser = JavaParser.fromJavaVersion().styles((Iterable)CollectionsKt.listOf((Object)new NamedStyles(Tree.randomId(), "test", "test", "test", SetsKt.emptySet(), (Collection)CollectionsKt.listOf((Object)ImportLayoutStyle.builder().packageToFold("java.util.*", Boolean.valueOf(true)).importAllOthers().importStaticAllOthers().build())))).build();
            Intrinsics.checkNotNullExpressionValue((Object)javaParser, (String)"fromJavaVersion().styles\u2026      )\n        ).build()");
            Function0[] function0Array = new Function0[]{foldSubPackageWithExistingImports.1.INSTANCE};
            JavaRecipeTest.DefaultImpls.assertChanged$default(javaRecipeTest, javaParser, this_.addImports(function0Array), null, "\n            import java.util.List;\n        ", null, "\n            import java.util.List;\n            import java.util.concurrent.*;\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void foldStaticSubPackageWithEmptyImports(@NotNull AddImportTest this_) {
            JavaRecipeTest javaRecipeTest = this_;
            JavaParser javaParser = JavaParser.fromJavaVersion().styles((Iterable)CollectionsKt.listOf((Object)new NamedStyles(Tree.randomId(), "test", "test", "test", SetsKt.emptySet(), (Collection)CollectionsKt.listOf((Object)ImportLayoutStyle.builder().staticPackageToFold("java.util.*", Boolean.valueOf(true)).importAllOthers().importStaticAllOthers().build())))).build();
            Intrinsics.checkNotNullExpressionValue((Object)javaParser, (String)"fromJavaVersion().styles\u2026      )\n        ).build()");
            Function0[] function0Array = new Function0[]{foldStaticSubPackageWithEmptyImports.1.INSTANCE};
            JavaRecipeTest.DefaultImpls.assertChanged$default(javaRecipeTest, javaParser, this_.addImports(function0Array), null, "\n        ", null, "\n            import static java.util.Collections.*;\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void noImportLayout(@NotNull AddImportTest this_) {
            JavaRecipeTest javaRecipeTest = this_;
            JavaParser javaParser = JavaParser.fromJavaVersion().styles((Iterable)CollectionsKt.listOf((Object)new NamedStyles(Tree.randomId(), "test", "test", "test", SetsKt.emptySet(), (Collection)CollectionsKt.listOf((Object)new ImportLayoutStyle(999, 999, CollectionsKt.emptyList(), CollectionsKt.emptyList()))))).build();
            Intrinsics.checkNotNullExpressionValue((Object)javaParser, (String)"fromJavaVersion().styles\u2026      )\n        ).build()");
            Function0[] function0Array = new Function0[]{noImportLayout.1.INSTANCE};
            JavaRecipeTest.DefaultImpls.assertChanged$default(javaRecipeTest, javaParser, this_.addImports(function0Array), null, "\n        ", null, "\n            import java.util.List;\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void foldStaticSubPackageWithExistingImports(@NotNull AddImportTest this_) {
            JavaRecipeTest javaRecipeTest = this_;
            JavaParser javaParser = JavaParser.fromJavaVersion().styles((Iterable)CollectionsKt.listOf((Object)new NamedStyles(Tree.randomId(), "test", "test", "test", SetsKt.emptySet(), (Collection)CollectionsKt.listOf((Object)ImportLayoutStyle.builder().staticPackageToFold("java.util.*", Boolean.valueOf(true)).importAllOthers().importStaticAllOthers().build())))).build();
            Intrinsics.checkNotNullExpressionValue((Object)javaParser, (String)"fromJavaVersion().styles\u2026      )\n        ).build()");
            Function0[] function0Array = new Function0[]{foldStaticSubPackageWithExistingImports.1.INSTANCE};
            JavaRecipeTest.DefaultImpls.assertChanged$default(javaRecipeTest, javaParser, this_.addImports(function0Array), null, "\n            import java.util.List;\n        ", null, "\n            import java.util.List;\n            \n            import static java.util.Collections.*;\n        ", 0, 0, null, null, 980, null);
        }

        @NotNull
        public static JavaParser getParser(@NotNull AddImportTest this_) {
            return JavaRecipeTest.DefaultImpls.getParser(this_);
        }

        @NotNull
        public static ExecutionContext getExecutionContext(@NotNull AddImportTest this_) {
            return JavaRecipeTest.DefaultImpls.getExecutionContext(this_);
        }

        @BeforeEach
        public static void beforeRecipe(@NotNull AddImportTest this_) {
            JavaRecipeTest.DefaultImpls.beforeRecipe(this_);
        }

        @AfterEach
        public static void afterRecipe(@NotNull AddImportTest this_) {
            JavaRecipeTest.DefaultImpls.afterRecipe(this_);
        }

        public static void assertChanged(@NotNull AddImportTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super TypeValidator.ValidationOptions.Companion.Builder, Unit> typeValidation, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(typeValidation, (String)"typeValidation");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged(this_, parser, recipe2, executionContext, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, typeValidation, afterConditions);
        }

        public static void assertChanged(@NotNull AddImportTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull File before, @Nullable Path relativeTo, @Language(value="java") @NotNull File[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super TypeValidator.ValidationOptions.Companion.Builder, Unit> typeValidation, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(typeValidation, (String)"typeValidation");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged(this_, parser, recipe2, executionContext, before, relativeTo, dependsOn, after, cycles, expectedCyclesThatMakeChanges, typeValidation, afterConditions);
        }

        public static void assertUnchanged(@NotNull AddImportTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, parser, recipe2, executionContext, before, dependsOn);
        }

        public static void assertUnchanged(@NotNull AddImportTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull File before, @Nullable Path relativeTo, @Language(value="java") @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, parser, recipe2, executionContext, before, relativeTo, dependsOn);
        }

        @Nullable
        public static Recipe getRecipe(@NotNull AddImportTest this_) {
            return JavaRecipeTest.DefaultImpls.getRecipe(this_);
        }

        public static void assertChangedBase(@NotNull AddImportTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull File before, @Nullable Path relativeTo, @NotNull File[] dependsOn, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase(this_, parser, recipe2, executionContext, before, relativeTo, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertChangedBase(@NotNull AddImportTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull String before, @NotNull String[] dependsOn, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase(this_, parser, recipe2, executionContext, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertUnchangedBase(@NotNull AddImportTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull File before, @Nullable Path relativeTo, @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchangedBase(this_, parser, recipe2, executionContext, before, relativeTo, dependsOn);
        }

        public static void assertUnchangedBase(@NotNull AddImportTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull String before, @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchangedBase(this_, parser, recipe2, executionContext, before, dependsOn);
        }

        @NotNull
        public static Recipe fromRuntimeClasspath(@NotNull AddImportTest this_, @NotNull String recipe2) {
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            return JavaRecipeTest.DefaultImpls.fromRuntimeClasspath(this_, recipe2);
        }

        @NotNull
        public static Recipe toRecipe(@NotNull AddImportTest this_, @NotNull Function0<? extends TreeVisitor<?, ExecutionContext>> supplier) {
            Intrinsics.checkNotNullParameter(supplier, (String)"supplier");
            return JavaRecipeTest.DefaultImpls.toRecipe(this_, supplier);
        }
    }
}

