/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.tree.JavaTreeTest;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017\u00a8\u0006\n"}, d2={"Lorg/openrewrite/java/tree/LambdaTest;", "Lorg/openrewrite/java/tree/JavaTreeTest;", "lambda", "", "jp", "Lorg/openrewrite/java/JavaParser;", "multipleParameters", "optionalSingleParameterParentheses", "rightSideBlock", "untypedLambdaParameter", "rewrite-java-tck"})
public interface LambdaTest
extends JavaTreeTest {
    @Test
    public void lambda(@NotNull JavaParser var1);

    @Test
    public void untypedLambdaParameter(@NotNull JavaParser var1);

    @Test
    public void optionalSingleParameterParentheses(@NotNull JavaParser var1);

    @Test
    public void rightSideBlock(@NotNull JavaParser var1);

    @Test
    public void multipleParameters(@NotNull JavaParser var1);

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @Test
        public static void lambda(@NotNull LambdaTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"java.util.function.Function"};
            this_.assertParsePrintAndProcess(jp, JavaTreeTest.NestingLevel.Block, "\n            Function<String, String> func = (String s) -> \"\";\n        ", stringArray);
        }

        @Test
        public static void untypedLambdaParameter(@NotNull LambdaTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"java.util.*"};
            this_.assertParsePrintAndProcess(jp, JavaTreeTest.NestingLevel.Block, "\n            List<String> list = new ArrayList<>();\n            list.stream().filter(s -> s.isEmpty());\n        ", stringArray);
        }

        @Test
        public static void optionalSingleParameterParentheses(@NotNull LambdaTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"java.util.*"};
            this_.assertParsePrintAndProcess(jp, JavaTreeTest.NestingLevel.Block, "\n            List<String> list = new ArrayList<>();\n            list.stream().filter((s) -> s.isEmpty());\n        ", stringArray);
        }

        @Test
        public static void rightSideBlock(@NotNull LambdaTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            this_.assertParsePrintAndProcess(jp, JavaTreeTest.NestingLevel.CompilationUnit, "\n            public class A {\n                Action a = ( ) -> { };\n            }\n\n            interface Action {\n                void call();\n            }\n        ", new String[0]);
        }

        @Test
        public static void multipleParameters(@NotNull LambdaTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"java.util.function.BiConsumer"};
            this_.assertParsePrintAndProcess(jp, JavaTreeTest.NestingLevel.Block, "\n            BiConsumer<String, String> a = (s1, s2) -> { };\n        ", stringArray);
        }
    }
}

