/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.format;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.assertj.core.api.Assertions;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.openrewrite.Result;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.format.EmptyNewlineAtEndOfFile;
import org.openrewrite.style.GeneralFormatStyle;
import org.openrewrite.style.NamedStyles;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u000e\u0010\u0004\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0005H\u0017J\u0018\u0010\u0006\u001a\u00020\u00032\u000e\u0010\u0004\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0005H\u0017J\u0018\u0010\u0007\u001a\u00020\u00032\u000e\u0010\u0004\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0005H\u0017J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\u00032\u000e\u0010\u0004\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0005H\u0017J\u0018\u0010\u000e\u001a\u00020\u00032\u000e\u0010\u0004\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0005H\u0017J\u0018\u0010\u000f\u001a\u00020\u00032\u000e\u0010\u0004\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0005H\u0017\u00a8\u0006\u0010"}, d2={"Lorg/openrewrite/java/format/EmptyNewlineAtEndOfFileTest;", "", "autodetectCRLF", "", "jp", "Lorg/openrewrite/java/JavaParser$Builder;", "autodetectLF", "comments", "generalFormat", "", "Lorg/openrewrite/style/NamedStyles;", "useCRLF", "", "multipleLinesToOne", "noComments", "usesCRLF", "rewrite-java-tck"})
public interface EmptyNewlineAtEndOfFileTest {
    @NotNull
    public List<NamedStyles> generalFormat(boolean var1);

    @Test
    public void usesCRLF(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    public void autodetectCRLF(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    public void autodetectLF(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    public void noComments(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    public void comments(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    public void multipleLinesToOne(@NotNull JavaParser.Builder<?, ?> var1);

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @NotNull
        public static List<NamedStyles> generalFormat(@NotNull EmptyNewlineAtEndOfFileTest this_, boolean useCRLF) {
            return CollectionsKt.listOf((Object)new NamedStyles(Tree.randomId(), "test", "test", "test", SetsKt.emptySet(), (Collection)CollectionsKt.listOf((Object)new GeneralFormatStyle(useCRLF))));
        }

        @Test
        public static void usesCRLF(@NotNull EmptyNewlineAtEndOfFileTest this_, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            String[] stringArray = new String[]{"class Test {}"};
            SourceFile sourceFile = ((Result)new EmptyNewlineAtEndOfFile().run(jp.styles((Iterable)this_.generalFormat(true)).build().parse(stringArray)).getResults().get(0)).getAfter();
            Intrinsics.checkNotNull((Object)sourceFile);
            Assertions.assertThat((String)sourceFile.printAll()).isEqualTo("class Test {}\r\n");
        }

        @Test
        public static void autodetectCRLF(@NotNull EmptyNewlineAtEndOfFileTest this_, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            String[] stringArray = new String[]{"class Test {\r\n}"};
            SourceFile sourceFile = ((Result)new EmptyNewlineAtEndOfFile().run(jp.build().parse(stringArray)).getResults().get(0)).getAfter();
            Intrinsics.checkNotNull((Object)sourceFile);
            Assertions.assertThat((String)sourceFile.printAll()).isEqualTo("class Test {\r\n}\r\n");
        }

        @Test
        public static void autodetectLF(@NotNull EmptyNewlineAtEndOfFileTest this_, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            String[] stringArray = new String[]{"class Test {\n}"};
            SourceFile sourceFile = ((Result)new EmptyNewlineAtEndOfFile().run(jp.build().parse(stringArray)).getResults().get(0)).getAfter();
            Intrinsics.checkNotNull((Object)sourceFile);
            Assertions.assertThat((String)sourceFile.printAll()).isEqualTo("class Test {\n}\n");
        }

        @Test
        public static void noComments(@NotNull EmptyNewlineAtEndOfFileTest this_, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            String[] stringArray = new String[]{"class Test {}"};
            SourceFile sourceFile = ((Result)new EmptyNewlineAtEndOfFile().run(jp.styles((Iterable)this_.generalFormat(false)).build().parse(stringArray)).getResults().get(0)).getAfter();
            Intrinsics.checkNotNull((Object)sourceFile);
            Assertions.assertThat((String)sourceFile.printAll()).isEqualTo("class Test {}\n");
        }

        @Test
        public static void comments(@NotNull EmptyNewlineAtEndOfFileTest this_, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            String[] stringArray = new String[]{"class Test {}\n/*comment*/"};
            SourceFile sourceFile = ((Result)new EmptyNewlineAtEndOfFile().run(jp.styles((Iterable)this_.generalFormat(false)).build().parse(stringArray)).getResults().get(0)).getAfter();
            Intrinsics.checkNotNull((Object)sourceFile);
            Assertions.assertThat((String)sourceFile.printAll()).isEqualTo("class Test {}\n/*comment*/\n");
        }

        @Test
        public static void multipleLinesToOne(@NotNull EmptyNewlineAtEndOfFileTest this_, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            String[] stringArray = new String[]{"class Test {}\n\n"};
            SourceFile sourceFile = ((Result)new EmptyNewlineAtEndOfFile().run(jp.styles((Iterable)this_.generalFormat(false)).build().parse(stringArray)).getResults().get(0)).getAfter();
            Intrinsics.checkNotNull((Object)sourceFile);
            Assertions.assertThat((String)sourceFile.printAll()).isEqualTo("class Test {}\n");
        }
    }
}

