/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.io.File;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaRecipeTest;
import org.openrewrite.java.TypeValidator;
import org.openrewrite.java.cleanup.NoValueOfOnStringType;
import org.openrewrite.java.tree.J;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\t\bf\u0018\u00002\u00020\u0001J\b\u0010\u0006\u001a\u00020\u0007H\u0017J\b\u0010\b\u001a\u00020\u0007H\u0017J\b\u0010\t\u001a\u00020\u0007H\u0017J\b\u0010\n\u001a\u00020\u0007H\u0017J\b\u0010\u000b\u001a\u00020\u0007H\u0017J\b\u0010\f\u001a\u00020\u0007H\u0017J\b\u0010\r\u001a\u00020\u0007H\u0017J\b\u0010\u000e\u001a\u00020\u0007H\u0017J\b\u0010\u000f\u001a\u00020\u0007H\u0017R\u0016\u0010\u0002\u001a\u0004\u0018\u00010\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0010"}, d2={"Lorg/openrewrite/java/cleanup/NoValueOfOnStringTypeTest;", "Lorg/openrewrite/java/JavaRecipeTest;", "recipe", "Lorg/openrewrite/Recipe;", "getRecipe", "()Lorg/openrewrite/Recipe;", "concatenationResultingInNonString", "", "doNotChangeOnObject", "valueOfIsMethodInvocationPartOfBinary", "valueOfOnIntWithinBinaryComparison", "valueOfOnLiterals", "valueOfOnMethodInvocation", "valueOfOnNonStringPrimitiveWithinBinaryConcatenation", "valueOfOnNonStringPrimitiveWithinBinaryNotAString", "valueOfOnStandaloneNonStringPrimitive", "rewrite-java-tck"})
public interface NoValueOfOnStringTypeTest
extends JavaRecipeTest {
    @Nullable
    public Recipe getRecipe();

    @Test
    public void doNotChangeOnObject();

    @Test
    public void valueOfOnLiterals();

    @Test
    public void valueOfOnNonStringPrimitiveWithinBinaryConcatenation();

    @Test
    public void valueOfOnNonStringPrimitiveWithinBinaryNotAString();

    @Test
    public void valueOfIsMethodInvocationPartOfBinary();

    @Test
    public void valueOfOnStandaloneNonStringPrimitive();

    @Test
    public void concatenationResultingInNonString();

    @Test
    public void valueOfOnIntWithinBinaryComparison();

    @Test
    public void valueOfOnMethodInvocation();

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @Nullable
        public static Recipe getRecipe(@NotNull NoValueOfOnStringTypeTest this_) {
            return (Recipe)new NoValueOfOnStringType();
        }

        @Test
        public static void doNotChangeOnObject(@NotNull NoValueOfOnStringTypeTest this_) {
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, null, null, null, "\n            class Test {\n                static String method(Object obj) {\n                    return String.valueOf(obj);\n                }\n            }\n        ", null, 23, null);
        }

        @Test
        public static void valueOfOnLiterals(@NotNull NoValueOfOnStringTypeTest this_) {
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, null, "\n            class Test {\n                static void method(char[] data) {\n                    String str = String.valueOf(\"changeMe\");\n                    str = String.valueOf(0);\n                    str = \"changeMe\" + String.valueOf(0);\n                    str = String.valueOf(data);\n                    str = \"changeMe\" + String.valueOf(data);\n                    str = String.valueOf(data, 0, 0);\n                    str = \"doNotChangeMe\" + String.valueOf(data, 0, 0);\n                }\n            }\n        ", null, "\n            class Test {\n                static void method(char[] data) {\n                    String str = \"changeMe\";\n                    str = String.valueOf(0);\n                    str = \"changeMe\" + 0;\n                    str = String.valueOf(data);\n                    str = \"changeMe\" + String.valueOf(data);\n                    str = String.valueOf(data, 0, 0);\n                    str = \"doNotChangeMe\" + String.valueOf(data, 0, 0);\n                }\n            }\n        ", 0, 0, null, null, 983, null);
        }

        @Test
        public static void valueOfOnNonStringPrimitiveWithinBinaryConcatenation(@NotNull NoValueOfOnStringTypeTest this_) {
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, null, "\n            class Test {\n                static void count(int i) {\n                    System.out.println(\"Count: \" + String.valueOf(i));\n                }\n            }\n        ", null, "\n            class Test {\n                static void count(int i) {\n                    System.out.println(\"Count: \" + i);\n                }\n            }\n        ", 0, 0, null, null, 983, null);
        }

        @Test
        public static void valueOfOnNonStringPrimitiveWithinBinaryNotAString(@NotNull NoValueOfOnStringTypeTest this_) {
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, null, null, null, "\n            class Test {\n                static void count(int i) {\n                    String fred = String.valueOf(i) + i;\n                }\n            }\n        ", null, 23, null);
        }

        @Test
        public static void valueOfIsMethodInvocationPartOfBinary(@NotNull NoValueOfOnStringTypeTest this_) {
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, null, null, null, "\n            class Test {\n                static String method(Long id) {\n                    return \"example\" + Test.method(String.valueOf(id));\n                }\n\n                static String method(String str) {\n                    return str;\n                }\n            }\n        ", null, 23, null);
        }

        @Test
        public static void valueOfOnStandaloneNonStringPrimitive(@NotNull NoValueOfOnStringTypeTest this_) {
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, null, "\n            class Test {\n                static void method(int i) {\n                    String str = String.valueOf(i) + \"example\";\n                }\n            }\n        ", null, "\n            class Test {\n                static void method(int i) {\n                    String str = i + \"example\";\n                }\n            }\n        ", 0, 0, null, null, 983, null);
        }

        @Test
        public static void concatenationResultingInNonString(@NotNull NoValueOfOnStringTypeTest this_) {
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, null, null, null, "\n            class Test {\n                static void method(int i) {\n                    String str = i + String.valueOf(i);\n                }\n            }\n        ", null, 23, null);
        }

        @Test
        public static void valueOfOnIntWithinBinaryComparison(@NotNull NoValueOfOnStringTypeTest this_) {
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, null, null, null, "\n            class Test {\n                static void method(String str, int i) {\n                    if (str.indexOf(String.valueOf(i)) >= 0) {\n                        // do nothing\n                    }\n                }\n            }\n        ", null, 23, null);
        }

        @Test
        public static void valueOfOnMethodInvocation(@NotNull NoValueOfOnStringTypeTest this_) {
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, null, "\n            class Test {\n                static void method1() {\n                    String a = String.valueOf(method2());\n                }\n\n                static String method2() {\n                    return \"\";\n                }\n            }\n        ", null, "\n            class Test {\n                static void method1() {\n                    String a = method2();\n                }\n\n                static String method2() {\n                    return \"\";\n                }\n            }\n        ", 0, 0, null, null, 983, null);
        }

        @NotNull
        public static JavaParser getParser(@NotNull NoValueOfOnStringTypeTest this_) {
            return JavaRecipeTest.DefaultImpls.getParser(this_);
        }

        @NotNull
        public static ExecutionContext getExecutionContext(@NotNull NoValueOfOnStringTypeTest this_) {
            return JavaRecipeTest.DefaultImpls.getExecutionContext(this_);
        }

        @BeforeEach
        public static void beforeRecipe(@NotNull NoValueOfOnStringTypeTest this_) {
            JavaRecipeTest.DefaultImpls.beforeRecipe(this_);
        }

        @AfterEach
        public static void afterRecipe(@NotNull NoValueOfOnStringTypeTest this_) {
            JavaRecipeTest.DefaultImpls.afterRecipe(this_);
        }

        public static void assertChanged(@NotNull NoValueOfOnStringTypeTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super TypeValidator.ValidationOptions.Companion.Builder, Unit> typeValidation, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(typeValidation, (String)"typeValidation");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged(this_, parser, recipe2, executionContext, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, typeValidation, afterConditions);
        }

        public static void assertChanged(@NotNull NoValueOfOnStringTypeTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull File before, @Nullable Path relativeTo, @Language(value="java") @NotNull File[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super TypeValidator.ValidationOptions.Companion.Builder, Unit> typeValidation, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(typeValidation, (String)"typeValidation");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged(this_, parser, recipe2, executionContext, before, relativeTo, dependsOn, after, cycles, expectedCyclesThatMakeChanges, typeValidation, afterConditions);
        }

        public static void assertUnchanged(@NotNull NoValueOfOnStringTypeTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, parser, recipe2, executionContext, before, dependsOn);
        }

        public static void assertUnchanged(@NotNull NoValueOfOnStringTypeTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull File before, @Nullable Path relativeTo, @Language(value="java") @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, parser, recipe2, executionContext, before, relativeTo, dependsOn);
        }

        public static void assertChangedBase(@NotNull NoValueOfOnStringTypeTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull File before, @Nullable Path relativeTo, @NotNull File[] dependsOn, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase(this_, parser, recipe2, executionContext, before, relativeTo, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertChangedBase(@NotNull NoValueOfOnStringTypeTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull String before, @NotNull String[] dependsOn, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase(this_, parser, recipe2, executionContext, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertUnchangedBase(@NotNull NoValueOfOnStringTypeTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull File before, @Nullable Path relativeTo, @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchangedBase(this_, parser, recipe2, executionContext, before, relativeTo, dependsOn);
        }

        public static void assertUnchangedBase(@NotNull NoValueOfOnStringTypeTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull String before, @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchangedBase(this_, parser, recipe2, executionContext, before, dependsOn);
        }

        @NotNull
        public static Recipe fromRuntimeClasspath(@NotNull NoValueOfOnStringTypeTest this_, @NotNull String recipe2) {
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            return JavaRecipeTest.DefaultImpls.fromRuntimeClasspath(this_, recipe2);
        }

        @NotNull
        public static Recipe toRecipe(@NotNull NoValueOfOnStringTypeTest this_, @NotNull Function0<? extends TreeVisitor<?, ExecutionContext>> supplier) {
            Intrinsics.checkNotNullParameter(supplier, (String)"supplier");
            return JavaRecipeTest.DefaultImpls.toRecipe(this_, supplier);
        }
    }
}

