/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.io.File;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.Assertions;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaRecipeTest;
import org.openrewrite.java.TypeValidator;
import org.openrewrite.java.cleanup.MethodNameCasing;
import org.openrewrite.java.tree.J;
import org.openrewrite.test.RecipeSpec;
import org.openrewrite.test.RewriteTest;
import org.openrewrite.test.SourceSpecs;
import org.openrewrite.test.TypeValidation;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\n\bf\u0018\u00002\u00020\u00012\u00020\u0002J\b\u0010\r\u001a\u00020\u000eH\u0017J\b\u0010\u000f\u001a\u00020\u000eH\u0017J\b\u0010\u0010\u001a\u00020\u000eH\u0017J\b\u0010\u0011\u001a\u00020\u000eH\u0017J\b\u0010\u0012\u001a\u00020\u000eH\u0017J\b\u0010\u0013\u001a\u00020\u000eH\u0017J\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u000eH\u0017J\b\u0010\u0018\u001a\u00020\u000eH\u0017J\b\u0010\u0019\u001a\u00020\u000eH\u0017J\b\u0010\u001a\u001a\u00020\u000eH\u0017J\b\u0010\u001b\u001a\u00020\u000eH\u0017J\b\u0010\u001c\u001a\u00020\u000eH\u0017J\b\u0010\u001d\u001a\u00020\u000eH\u0017J\b\u0010\u001e\u001a\u00020\u000eH\u0017J\b\u0010\u001f\u001a\u00020\u000eH\u0017R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0006\u00a8\u0006 "}, d2={"Lorg/openrewrite/java/cleanup/MethodNameCasingTest;", "Lorg/openrewrite/java/JavaRecipeTest;", "Lorg/openrewrite/test/RewriteTest;", "parser", "Lorg/openrewrite/java/JavaParser;", "getParser", "()Lorg/openrewrite/java/JavaParser;", "recipe", "Lorg/openrewrite/Recipe;", "getRecipe", "()Lorg/openrewrite/Recipe;", "testParser", "getTestParser", "applyChangeToTest", "", "change name of method with array argument", "changeCamelCaseMethodWithFirstLetterUpperCase", "changeMethodDeclaration", "changeMethodInvocations", "changeMethodNameWhenOverride", "defaults", "spec", "Lorg/openrewrite/test/RecipeSpec;", "doNotApplyToTest", "does not rename method invocations when the method declarations class type is null", "dontChangeCorrectlyCasedMethods", "keep camel case when removing leading underscore", "keep camel case when removing leading underscore 2", "nameExistsInInnerClass", "newNameExists", "rename snake_case to camelCase", "unknownParameterTypes", "rewrite-java-tck"})
public interface MethodNameCasingTest
extends JavaRecipeTest,
RewriteTest {
    @Nullable
    public Recipe getRecipe();

    @Override
    @NotNull
    public JavaParser getParser();

    @NotNull
    public JavaParser getTestParser();

    public void defaults(@NotNull RecipeSpec var1);

    @Test
    public void doNotApplyToTest();

    @Test
    public void applyChangeToTest();

    @Test
    public void changeMethodDeclaration();

    @Test
    public void changeCamelCaseMethodWithFirstLetterUpperCase();

    @Test
    public void changeMethodInvocations();

    @Test
    public void dontChangeCorrectlyCasedMethods();

    @Test
    public void changeMethodNameWhenOverride();

    @Test
    public void newNameExists();

    @Test
    public void nameExistsInInnerClass();

    @Test
    public void rename snake_case to camelCase();

    @Test
    public void does not rename method invocations when the method declarations class type is null();

    @Test
    public void keep camel case when removing leading underscore();

    @Test
    public void keep camel case when removing leading underscore 2();

    @Test
    public void change name of method with array argument();

    @Test
    public void unknownParameterTypes();

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @Nullable
        public static Recipe getRecipe(@NotNull MethodNameCasingTest this_) {
            return (Recipe)new MethodNameCasing(Boolean.valueOf(false));
        }

        @NotNull
        public static JavaParser getParser(@NotNull MethodNameCasingTest this_) {
            JavaParser jp = JavaParser.fromJavaVersion().build();
            jp.setSourceSet("main");
            Intrinsics.checkNotNullExpressionValue((Object)jp, (String)"jp");
            return jp;
        }

        @NotNull
        public static JavaParser getTestParser(@NotNull MethodNameCasingTest this_) {
            JavaParser jp = JavaParser.fromJavaVersion().build();
            jp.setSourceSet("test");
            Intrinsics.checkNotNullExpressionValue((Object)jp, (String)"jp");
            return jp;
        }

        public static void defaults(@NotNull MethodNameCasingTest this_, @NotNull RecipeSpec spec) {
            Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
            spec.recipe((Recipe)new MethodNameCasing(Boolean.valueOf(true)));
        }

        @Test
        public static void doNotApplyToTest(@NotNull MethodNameCasingTest this_) {
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, this_.getTestParser(), null, null, "\n            class Test {\n                void MyMethod_with_\u00fcber() {\n                }\n            }\n        ", null, 22, null);
        }

        @Test
        public static void applyChangeToTest(@NotNull MethodNameCasingTest this_) {
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, this_.getTestParser(), (Recipe)new MethodNameCasing(Boolean.valueOf(true)), null, "\n            class Test {\n                void MyMethod_with_\u00fcber() {\n                }\n            }\n        ", null, "\n            class Test {\n                void myMethodWithBer() {\n                }\n            }\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void changeMethodDeclaration(@NotNull MethodNameCasingTest this_) {
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, null, "\n            class Test {\n                void MyMethod_with_\u00fcber() {\n                }\n            }\n        ", null, "\n            class Test {\n                void myMethodWithBer() {\n                }\n            }\n        ", 0, 0, null, null, 983, null);
        }

        @Test
        public static void changeCamelCaseMethodWithFirstLetterUpperCase(@NotNull MethodNameCasingTest this_) {
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, null, "\n            class Test {\n                void MyMethod() {\n                }\n            }\n        ", null, "\n            class Test {\n                void myMethod() {\n                }\n            }\n        ", 0, 0, null, null, 983, null);
        }

        @Test
        public static void changeMethodInvocations(@NotNull MethodNameCasingTest this_) {
            String[] stringArray = new String[]{"\n            class Test {\n                void MyMethod_with_\u00fcber() {\n                }\n            }\n        "};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, null, "\n            class A {\n                void test() {\n                    new Test().MyMethod_with_\u00fcber();\n                }\n            }\n        ", stringArray2, "\n            class A {\n                void test() {\n                    new Test().myMethodWithBer();\n                }\n            }\n        ", 0, 0, null, null, 967, null);
        }

        @Test
        public static void dontChangeCorrectlyCasedMethods(@NotNull MethodNameCasingTest this_) {
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, null, null, null, "\n            class Test {\n                void dontChange() {\n                }\n            }\n        ", null, 23, null);
        }

        @Test
        public static void changeMethodNameWhenOverride(@NotNull MethodNameCasingTest this_) {
            String[] stringArray = new String[]{"\n            class ParentClass {\n                void _method() {\n                }\n            }\n        "};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, null, "\n            class Test extends ParentClass {\n                @Override\n                void _method() {\n                }\n            }\n        ", stringArray2, "\n            class Test extends ParentClass {\n                @Override\n                void method() {\n                }\n            }\n        ", 0, 0, null, null, 967, null);
        }

        @Test
        public static void newNameExists(@NotNull MethodNameCasingTest this_) {
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, null, null, null, "\n            class Test {\n                void _method() {\n                }\n                void method() {\n                }\n            }\n        ", null, 23, null);
        }

        @Test
        public static void nameExistsInInnerClass(@NotNull MethodNameCasingTest this_) {
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, null, "\n            class T {\n                public void _method(){}\n                \n                private static class M {\n                    public void _method(){}\n                }\n            }\n        ", null, "\n            class T {\n                public void method(){}\n                \n                private static class M {\n                    public void method(){}\n                }\n            }\n        ", 0, 0, null, null, 983, null);
        }

        @Test
        public static void rename snake_case to camelCase(@NotNull MethodNameCasingTest this_) {
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, null, "\n            class T {\n                private static int SOME_METHOD() {\n                  return 1;\n                }\n                private static int some_method_2() {\n                  return 1;\n                }\n                private static int some_\u00fcber_method() {\n                  return 1;\n                }\n                public static void anotherMethod() {\n                  int i = SOME_METHOD();\n                  i = some_method_2();\n                  i = some_\u00fcber_method();\n                }\n            }\n        ", null, "\n            class T {\n                private static int someMethod() {\n                  return 1;\n                }\n                private static int someMethod2() {\n                  return 1;\n                }\n                private static int someBerMethod() {\n                  return 1;\n                }\n                public static void anotherMethod() {\n                  int i = someMethod();\n                  i = someMethod2();\n                  i = someBerMethod();\n                }\n            }\n        ", 0, 0, null, null, 983, null);
        }

        @Test
        public static void does not rename method invocations when the method declarations class type is null(@NotNull MethodNameCasingTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            package abc;\n            class T {\n                public static int MyMethod() {return null;}\n                public static void anotherMethod() {\n                    int i = MyMethod();\n                }\n            }\n            ", (String)"\n            package abc;\n            class T {\n                public static int MyMethod() {return null;}\n                public static void anotherMethod() {\n                    int i = MyMethod();\n                }\n            }\n            ")};
            this_.rewriteRun(DefaultImpls::does_not_rename_method_invocations_when_the_method_declarations_class_type_is_null$lambda-1, sourceSpecsArray);
        }

        @Test
        public static void keep camel case when removing leading underscore(@NotNull MethodNameCasingTest this_) {
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, null, "\n            class Test {\n                private void _theMethod() {\n                \n                }\n            }\n        ", null, "\n            class Test {\n                private void theMethod() {\n                \n                }\n            }\n        ", 0, 0, null, null, 983, null);
        }

        @Test
        public static void keep camel case when removing leading underscore 2(@NotNull MethodNameCasingTest this_) {
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, null, "\n            import java.util.*;\n            \n            class Test {\n                private List<String> _getNames() {\n                    List<String> result = new ArrayList<>();\n                    result.add(\"Alice\");\n                    result.add(\"Bob\");\n                    result.add(\"Carol\");\n                    return result;\n                }\n                \n                public void run() {\n                    for (String n: _getNames()) {\n                        System.out.println(n);\n                    }\n                }\n            }\n        ", null, "\n            import java.util.*;\n            \n            class Test {\n                private List<String> getNames() {\n                    List<String> result = new ArrayList<>();\n                    result.add(\"Alice\");\n                    result.add(\"Bob\");\n                    result.add(\"Carol\");\n                    return result;\n                }\n                \n                public void run() {\n                    for (String n: getNames()) {\n                        System.out.println(n);\n                    }\n                }\n            }\n        ", 0, 0, null, null, 983, null);
        }

        @Test
        public static void change name of method with array argument(@NotNull MethodNameCasingTest this_) {
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, null, "\n            import java.util.*;\n            \n            class Test {\n                private List<String> _getNames(String[] names) {\n                    List<String> result = new ArrayList<>(Arrays.asList(names));\n                    return result;\n                }\n            }\n        ", null, "\n            import java.util.*;\n            \n            class Test {\n                private List<String> getNames(String[] names) {\n                    List<String> result = new ArrayList<>(Arrays.asList(names));\n                    return result;\n                }\n            }\n        ", 0, 0, null, null, 983, null);
        }

        @Test
        public static void unknownParameterTypes(@NotNull MethodNameCasingTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                private void _foo(Unknown u) {\n                }\n            }\n        ", (String)"\n            class Test {\n                private void foo(Unknown u) {\n                }\n            }\n        ")};
            this_.rewriteRun(DefaultImpls::unknownParameterTypes$lambda-2, sourceSpecsArray);
        }

        @NotNull
        public static ExecutionContext getExecutionContext(@NotNull MethodNameCasingTest this_) {
            return JavaRecipeTest.DefaultImpls.getExecutionContext(this_);
        }

        @BeforeEach
        public static void beforeRecipe(@NotNull MethodNameCasingTest this_) {
            JavaRecipeTest.DefaultImpls.beforeRecipe(this_);
        }

        @AfterEach
        public static void afterRecipe(@NotNull MethodNameCasingTest this_) {
            JavaRecipeTest.DefaultImpls.afterRecipe(this_);
        }

        public static void assertChanged(@NotNull MethodNameCasingTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super TypeValidator.ValidationOptions.Companion.Builder, Unit> typeValidation, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(typeValidation, (String)"typeValidation");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged(this_, parser, recipe2, executionContext, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, typeValidation, afterConditions);
        }

        public static void assertChanged(@NotNull MethodNameCasingTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull File before, @Nullable Path relativeTo, @Language(value="java") @NotNull File[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super TypeValidator.ValidationOptions.Companion.Builder, Unit> typeValidation, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(typeValidation, (String)"typeValidation");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged(this_, parser, recipe2, executionContext, before, relativeTo, dependsOn, after, cycles, expectedCyclesThatMakeChanges, typeValidation, afterConditions);
        }

        public static void assertUnchanged(@NotNull MethodNameCasingTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, parser, recipe2, executionContext, before, dependsOn);
        }

        public static void assertUnchanged(@NotNull MethodNameCasingTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull File before, @Nullable Path relativeTo, @Language(value="java") @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, parser, recipe2, executionContext, before, relativeTo, dependsOn);
        }

        public static void assertChangedBase(@NotNull MethodNameCasingTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull File before, @Nullable Path relativeTo, @NotNull File[] dependsOn, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase(this_, parser, recipe2, executionContext, before, relativeTo, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertChangedBase(@NotNull MethodNameCasingTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull String before, @NotNull String[] dependsOn, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase(this_, parser, recipe2, executionContext, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertUnchangedBase(@NotNull MethodNameCasingTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull File before, @Nullable Path relativeTo, @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchangedBase(this_, parser, recipe2, executionContext, before, relativeTo, dependsOn);
        }

        public static void assertUnchangedBase(@NotNull MethodNameCasingTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull String before, @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchangedBase(this_, parser, recipe2, executionContext, before, dependsOn);
        }

        @NotNull
        public static Recipe fromRuntimeClasspath(@NotNull MethodNameCasingTest this_, @NotNull String recipe2) {
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            return JavaRecipeTest.DefaultImpls.fromRuntimeClasspath(this_, recipe2);
        }

        @NotNull
        public static Recipe toRecipe(@NotNull MethodNameCasingTest this_, @NotNull Function0<? extends TreeVisitor<?, ExecutionContext>> supplier) {
            Intrinsics.checkNotNullParameter(supplier, (String)"supplier");
            return JavaRecipeTest.DefaultImpls.toRecipe(this_, supplier);
        }

        private static TreeVisitor does_not_rename_method_invocations_when_the_method_declarations_class_type_is_null$lambda-1$lambda-0() {
            return (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

                @NotNull
                public J.ClassDeclaration visitClassDeclaration(@NotNull J.ClassDeclaration classDecl2, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)classDecl2, (String)"classDecl");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    J.ClassDeclaration classDeclaration = super.visitClassDeclaration(classDecl2, (Object)p).withType(null);
                    Intrinsics.checkNotNullExpressionValue((Object)classDeclaration, (String)"super.visitClassDeclarat\u2026ssDecl, p).withType(null)");
                    return classDeclaration;
                }
            };
        }

        private static void does_not_rename_method_invocations_when_the_method_declarations_class_type_is_null$lambda-1(RecipeSpec spec) {
            spec.typeValidationOptions(TypeValidation.none()).recipe(RewriteTest.toRecipe(DefaultImpls::does_not_rename_method_invocations_when_the_method_declarations_class_type_is_null$lambda-1$lambda-0).doNext((Recipe)new MethodNameCasing(Boolean.valueOf(true))));
        }

        private static void unknownParameterTypes$lambda-2(RecipeSpec spec) {
            spec.typeValidationOptions(TypeValidation.none());
        }
    }
}

