/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.io.File;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.DeleteStatement;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaRecipeTest;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.TestRecipe;
import org.openrewrite.java.TypeValidator;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Statement;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017\u00a8\u0006\b"}, d2={"Lorg/openrewrite/java/DeleteStatementTest;", "Lorg/openrewrite/java/JavaRecipeTest;", "deleteField", "", "jp", "Lorg/openrewrite/java/JavaParser;", "deleteSecondAndFourthStatement", "deleteSecondStatement", "rewrite-java-tck"})
public interface DeleteStatementTest
extends JavaRecipeTest {
    @Test
    public void deleteField(@NotNull JavaParser var1);

    @Test
    public void deleteSecondStatement(@NotNull JavaParser var1);

    @Test
    public void deleteSecondAndFourthStatement(@NotNull JavaParser var1);

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @Test
        public static void deleteField(@NotNull DeleteStatementTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, new TestRecipe(){

                @NotNull
                protected TreeVisitor<?, ExecutionContext> getVisitor() {
                    return (TreeVisitor)new JavaVisitor<ExecutionContext>(){

                        @NotNull
                        public J visitVariableDeclarations(@NotNull J.VariableDeclarations multiVariable2, @NotNull ExecutionContext p) {
                            Intrinsics.checkNotNullParameter((Object)multiVariable2, (String)"multiVariable");
                            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                            this.doAfterVisit((TreeVisitor)new DeleteStatement((Statement)multiVariable2));
                            J j = super.visitVariableDeclarations(multiVariable2, (Object)p);
                            Intrinsics.checkNotNullExpressionValue((Object)j, (String)"super.visitVariableDeclarations(multiVariable, p)");
                            return j;
                        }
                    };
                }
            }, null, "\n            import java.util.List;\n            public class A {\n               List collection = null;\n            }\n        ", null, "\n            public class A {\n            }\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void deleteSecondStatement(@NotNull DeleteStatementTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, new TestRecipe(){

                @NotNull
                protected TreeVisitor<?, ExecutionContext> getVisitor() {
                    return (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

                        /*
                         * WARNING - void declaration
                         */
                        @NotNull
                        public J.Block visitBlock(@NotNull J.Block block2, @NotNull ExecutionContext p) {
                            Intrinsics.checkNotNullParameter((Object)block2, (String)"block");
                            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                            J.Block b = super.visitBlock(block2, (Object)p);
                            if (b.getStatements().size() != 4) {
                                Intrinsics.checkNotNullExpressionValue((Object)b, (String)"b");
                                return b;
                            }
                            List list = b.getStatements();
                            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"b.statements");
                            Iterable $this$forEachIndexed$iv = list;
                            boolean $i$f$forEachIndexed = false;
                            int index$iv = 0;
                            for (T item$iv : $this$forEachIndexed$iv) {
                                void s;
                                int n;
                                if ((n = index$iv++) < 0) {
                                    CollectionsKt.throwIndexOverflow();
                                }
                                Statement statement = (Statement)item$iv;
                                int i = n;
                                boolean bl = false;
                                if (i != 1) continue;
                                this.doAfterVisit((TreeVisitor)new DeleteStatement((Statement)s));
                            }
                            Intrinsics.checkNotNullExpressionValue((Object)b, (String)"b");
                            return b;
                        }
                    };
                }
            }, null, "\n            public class A {\n               {\n                  String s = \"\";\n                  s.toString();\n                  s = \"hello\";\n                  s.toString();\n               }\n            }\n        ", null, "\n            public class A {\n               {\n                  String s = \"\";\n                  s = \"hello\";\n                  s.toString();\n               }\n            }\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void deleteSecondAndFourthStatement(@NotNull DeleteStatementTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, new TestRecipe(){

                @NotNull
                protected TreeVisitor<?, ExecutionContext> getVisitor() {
                    return (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

                        /*
                         * WARNING - void declaration
                         */
                        @NotNull
                        public J.Block visitBlock(@NotNull J.Block block2, @NotNull ExecutionContext p) {
                            Intrinsics.checkNotNullParameter((Object)block2, (String)"block");
                            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                            J.Block b = super.visitBlock(block2, (Object)p);
                            if (b.getStatements().size() != 4) {
                                Intrinsics.checkNotNullExpressionValue((Object)b, (String)"b");
                                return b;
                            }
                            List list = b.getStatements();
                            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"b.statements");
                            Iterable $this$forEachIndexed$iv = list;
                            boolean $i$f$forEachIndexed = false;
                            int index$iv = 0;
                            for (T item$iv : $this$forEachIndexed$iv) {
                                int n;
                                if ((n = index$iv++) < 0) {
                                    CollectionsKt.throwIndexOverflow();
                                }
                                Statement statement = (Statement)item$iv;
                                int i = n;
                                boolean bl = false;
                                switch (i) {
                                    case 1: 
                                    case 3: {
                                        void s;
                                        this.doAfterVisit((TreeVisitor)new DeleteStatement((Statement)s));
                                    }
                                }
                            }
                            Intrinsics.checkNotNullExpressionValue((Object)b, (String)"b");
                            return b;
                        }
                    };
                }
            }, null, "\n            public class A {\n               {\n                  String s = \"\";\n                  s.toString();\n                  s = \"hello\";\n                  s.toString();\n               }\n            }\n        ", null, "\n            public class A {\n               {\n                  String s = \"\";\n                  s = \"hello\";\n               }\n            }\n        ", 0, 0, null, null, 980, null);
        }

        @NotNull
        public static JavaParser getParser(@NotNull DeleteStatementTest this_) {
            return JavaRecipeTest.DefaultImpls.getParser(this_);
        }

        @NotNull
        public static ExecutionContext getExecutionContext(@NotNull DeleteStatementTest this_) {
            return JavaRecipeTest.DefaultImpls.getExecutionContext(this_);
        }

        @BeforeEach
        public static void beforeRecipe(@NotNull DeleteStatementTest this_) {
            JavaRecipeTest.DefaultImpls.beforeRecipe(this_);
        }

        @AfterEach
        public static void afterRecipe(@NotNull DeleteStatementTest this_) {
            JavaRecipeTest.DefaultImpls.afterRecipe(this_);
        }

        public static void assertChanged(@NotNull DeleteStatementTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super TypeValidator.ValidationOptions.Companion.Builder, Unit> typeValidation, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(typeValidation, (String)"typeValidation");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged(this_, parser, recipe2, executionContext, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, typeValidation, afterConditions);
        }

        public static void assertChanged(@NotNull DeleteStatementTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull File before, @Nullable Path relativeTo, @Language(value="java") @NotNull File[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super TypeValidator.ValidationOptions.Companion.Builder, Unit> typeValidation, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(typeValidation, (String)"typeValidation");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged(this_, parser, recipe2, executionContext, before, relativeTo, dependsOn, after, cycles, expectedCyclesThatMakeChanges, typeValidation, afterConditions);
        }

        public static void assertUnchanged(@NotNull DeleteStatementTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, parser, recipe2, executionContext, before, dependsOn);
        }

        public static void assertUnchanged(@NotNull DeleteStatementTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull File before, @Nullable Path relativeTo, @Language(value="java") @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, parser, recipe2, executionContext, before, relativeTo, dependsOn);
        }

        @Nullable
        public static Recipe getRecipe(@NotNull DeleteStatementTest this_) {
            return JavaRecipeTest.DefaultImpls.getRecipe(this_);
        }

        public static void assertChangedBase(@NotNull DeleteStatementTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull File before, @Nullable Path relativeTo, @NotNull File[] dependsOn, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase(this_, parser, recipe2, executionContext, before, relativeTo, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertChangedBase(@NotNull DeleteStatementTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull String before, @NotNull String[] dependsOn, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase(this_, parser, recipe2, executionContext, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertUnchangedBase(@NotNull DeleteStatementTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull File before, @Nullable Path relativeTo, @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchangedBase(this_, parser, recipe2, executionContext, before, relativeTo, dependsOn);
        }

        public static void assertUnchangedBase(@NotNull DeleteStatementTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull String before, @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchangedBase(this_, parser, recipe2, executionContext, before, dependsOn);
        }

        @NotNull
        public static Recipe fromRuntimeClasspath(@NotNull DeleteStatementTest this_, @NotNull String recipe2) {
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            return JavaRecipeTest.DefaultImpls.fromRuntimeClasspath(this_, recipe2);
        }

        @NotNull
        public static Recipe toRecipe(@NotNull DeleteStatementTest this_, @NotNull Function0<? extends TreeVisitor<?, ExecutionContext>> supplier) {
            Intrinsics.checkNotNullParameter(supplier, (String)"supplier");
            return JavaRecipeTest.DefaultImpls.toRecipe(this_, supplier);
        }
    }
}

