/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.openrewrite.Parser;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.java.Assertions;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.RemoveUnusedImports;
import org.openrewrite.java.style.ImportLayoutStyle;
import org.openrewrite.style.NamedStyles;
import org.openrewrite.test.RecipeSpec;
import org.openrewrite.test.RewriteTest;
import org.openrewrite.test.SourceSpecs;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b'\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0003H\u0017J\b\u0010\u0007\u001a\u00020\u0003H\u0017J\b\u0010\b\u001a\u00020\u0003H\u0017J\b\u0010\t\u001a\u00020\u0003H\u0017J\b\u0010\n\u001a\u00020\u0003H\u0017J\b\u0010\u000b\u001a\u00020\u0003H\u0017J\b\u0010\f\u001a\u00020\u0003H\u0017J\b\u0010\r\u001a\u00020\u0003H\u0017J\b\u0010\u000e\u001a\u00020\u0003H\u0017J\b\u0010\u000f\u001a\u00020\u0003H\u0017J\b\u0010\u0010\u001a\u00020\u0003H\u0017J\b\u0010\u0011\u001a\u00020\u0003H\u0017J\b\u0010\u0012\u001a\u00020\u0003H\u0017J\b\u0010\u0013\u001a\u00020\u0003H\u0017J\b\u0010\u0014\u001a\u00020\u0003H\u0017J\b\u0010\u0015\u001a\u00020\u0003H\u0017J\b\u0010\u0016\u001a\u00020\u0003H\u0017J\b\u0010\u0017\u001a\u00020\u0003H\u0017J\b\u0010\u0018\u001a\u00020\u0003H\u0017J\b\u0010\u0019\u001a\u00020\u0003H\u0017J\b\u0010\u001a\u001a\u00020\u0003H\u0017J\b\u0010\u001b\u001a\u00020\u0003H\u0017J\b\u0010\u001c\u001a\u00020\u0003H\u0017J\b\u0010\u001d\u001a\u00020\u0003H\u0017J\b\u0010\u001e\u001a\u00020\u0003H\u0017J\b\u0010\u001f\u001a\u00020\u0003H\u0017J\b\u0010 \u001a\u00020\u0003H\u0017J\b\u0010!\u001a\u00020\u0003H\u0017J\b\u0010\"\u001a\u00020\u0003H\u0017J\b\u0010#\u001a\u00020\u0003H\u0017J\b\u0010$\u001a\u00020\u0003H\u0017J\b\u0010%\u001a\u00020\u0003H\u0017J\b\u0010&\u001a\u00020\u0003H\u0017J\b\u0010'\u001a\u00020\u0003H\u0017J\b\u0010(\u001a\u00020\u0003H\u0017J\b\u0010)\u001a\u00020\u0003H\u0017J\b\u0010*\u001a\u00020\u0003H\u0017J\b\u0010+\u001a\u00020\u0003H\u0017\u00a8\u0006,"}, d2={"Lorg/openrewrite/java/RemoveUnusedImportsTest;", "Lorg/openrewrite/test/RewriteTest;", "defaults", "", "spec", "Lorg/openrewrite/test/RecipeSpec;", "doNotRemoveInnerClassImport", "doNotRemoveInnerClassInSamePackage", "doNotUnfoldPackage", "doNotUnfoldStaticValidWildCard", "doNotUnfoldSubpackage", "doesNotAffectClassBodyFormatting", "doesNotRemoveStaticReferenceToNewClass", "dontRemoveStaticReferenceToPrimitiveField", "ensuresWhitespaceAfterPackageDeclarationNoImportsRemain", "keepInnerClassImports", "leaveImportForStaticImportEnumInAnnotation", "leaveImportIfAnnotationOnEnum", "leaveImportIfRemovedTypeIsStillReferredTo", "leaveNamedStaticImportIfReferenceStillExists", "leaveNamedStaticImportOnFieldIfReferenceStillExists", "leaveStarImportInPlaceIfMoreThanStarCount", "leaveStarStaticImportIfReferenceStillExists", "removeDirectImportWithWildcardImport", "removeImportUsedAsLambdaParameter", "removeImportUsedAsMethodParameter", "removeImportsForSamePackage", "removeMultipleDirectImports", "removeMultipleImportsWhileUnfoldingWildcard", "removeMultipleWildcardImports", "removeNamedImport", "removePackageInfoImports", "removePackageInfoStarImports", "removeStarImportIfNoTypesReferredTo", "removeStarStaticImport", "removeStaticImportIfNotReferenced", "removeWildcardImportWithDirectImport", "replaceStarImportWithNamedImportIfOnlyOneReferencedTypeRemains", "resultSetType", "unfoldIfLessThanStarCount", "unfoldStaticUses", "unfoldSubpackage", "usedInJavadoc", "usedInJavadocWithThrows", "rewrite-java-tck"})
public interface RemoveUnusedImportsTest
extends RewriteTest {
    public void defaults(@NotNull RecipeSpec var1);

    @Test
    public void doNotRemoveInnerClassImport();

    @Test
    public void doNotRemoveInnerClassInSamePackage();

    @Test
    public void usedInJavadocWithThrows();

    @Test
    public void usedInJavadoc();

    @Test
    public void removeNamedImport();

    @Test
    public void leaveImportIfRemovedTypeIsStillReferredTo();

    @Test
    public void leaveImportIfAnnotationOnEnum();

    @Test
    public void leaveImportForStaticImportEnumInAnnotation();

    @Test
    public void removeStarImportIfNoTypesReferredTo();

    @Test
    public void replaceStarImportWithNamedImportIfOnlyOneReferencedTypeRemains();

    @Test
    public void unfoldIfLessThanStarCount();

    @Test
    public void leaveStarImportInPlaceIfMoreThanStarCount();

    @Test
    public void removeStarStaticImport();

    @Test
    public void leaveStarStaticImportIfReferenceStillExists();

    @Test
    public void removeStaticImportIfNotReferenced();

    @Test
    public void leaveNamedStaticImportIfReferenceStillExists();

    @Test
    public void leaveNamedStaticImportOnFieldIfReferenceStillExists();

    @Test
    public void removePackageInfoImports();

    @Test
    public void removePackageInfoStarImports();

    @Test
    public void dontRemoveStaticReferenceToPrimitiveField();

    @Test
    public void resultSetType();

    @Test
    public void ensuresWhitespaceAfterPackageDeclarationNoImportsRemain();

    @Test
    public void doesNotAffectClassBodyFormatting();

    @Test
    public void doesNotRemoveStaticReferenceToNewClass();

    @Test
    public void doNotUnfoldStaticValidWildCard();

    @Test
    public void unfoldStaticUses();

    @Test
    public void doNotUnfoldPackage();

    @Test
    public void unfoldSubpackage();

    @Test
    public void doNotUnfoldSubpackage();

    @Test
    public void removeImportsForSamePackage();

    @Test
    public void removeImportUsedAsLambdaParameter();

    @Test
    public void removeImportUsedAsMethodParameter();

    @Test
    public void removeMultipleDirectImports();

    @Test
    public void removeMultipleWildcardImports();

    @Test
    public void removeWildcardImportWithDirectImport();

    @Test
    public void removeDirectImportWithWildcardImport();

    @Test
    public void removeMultipleImportsWhileUnfoldingWildcard();

    @Test
    public void keepInnerClassImports();

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        public static void defaults(@NotNull RemoveUnusedImportsTest this_, @NotNull RecipeSpec spec) {
            Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
            spec.recipe((Recipe)new RemoveUnusedImports());
        }

        @Test
        public static void doNotRemoveInnerClassImport(@NotNull RemoveUnusedImportsTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.util.Map.Entry;\n\n            public abstract class MyMapEntry<K, V> implements Entry<K, V> {\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void doNotRemoveInnerClassInSamePackage(@NotNull RemoveUnusedImportsTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            package java.util;\n\n            import java.util.Map.Entry;\n\n            public abstract class MyMapEntry<K, V> implements Entry<K, V> {\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void usedInJavadocWithThrows(@NotNull RemoveUnusedImportsTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.time.DateTimeException;\n            \n            class A {\n                /** \n                 * @throws DateTimeException when ...\n                 */\n                void foo() {}\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void usedInJavadoc(@NotNull RemoveUnusedImportsTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.util.List;\n            import java.util.Collection;\n            \n            /** {@link List} */\n            class A {\n                /** {@link Collection} */\n                void foo() {}\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void removeNamedImport(@NotNull RemoveUnusedImportsTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.util.List;\n            class A {}\n        ", (String)"class A {}")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void leaveImportIfRemovedTypeIsStillReferredTo(@NotNull RemoveUnusedImportsTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.util.List;\n            class A {\n               List<Integer> list;\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void leaveImportIfAnnotationOnEnum(@NotNull RemoveUnusedImportsTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            package com.google.gson.annotations;\n            \n            import java.lang.annotation.Documented;\n            import java.lang.annotation.ElementType;\n            import java.lang.annotation.Retention;\n            import java.lang.annotation.RetentionPolicy;\n            import java.lang.annotation.Target;\n\n            @Documented\n            @Retention(RetentionPolicy.RUNTIME)\n            @Target({ElementType.FIELD, ElementType.METHOD})\n            public @interface SerializedName {\n                String value();\n            }\n        "), Assertions.java((String)"\n            import com.google.gson.annotations.SerializedName;\n            \n            public enum PKIState {\n                @SerializedName(\"active\") ACTIVE,\n                @SerializedName(\"dismissed\") DISMISSED\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void leaveImportForStaticImportEnumInAnnotation(@NotNull RemoveUnusedImportsTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            package org.openrewrite.test;\n            \n            public @interface YesOrNo {\n                Status status();\n                enum Status {\n                    YES, NO\n                }\n            }\n        "), Assertions.java((String)"\n            package org.openrewrite.test;\n            \n            import static org.openrewrite.test.YesOrNo.Status.YES;\n            \n            @YesOrNo(status = YES)\n            public class Foo {}\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void removeStarImportIfNoTypesReferredTo(@NotNull RemoveUnusedImportsTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.util.*;\n            class A {}\n        ", (String)"class A {}")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void replaceStarImportWithNamedImportIfOnlyOneReferencedTypeRemains(@NotNull RemoveUnusedImportsTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.util.*;\n            \n            class A {\n                Collection<Integer> c;\n            }\n        ", (String)"\n            import java.util.Collection;\n            \n            class A {\n                Collection<Integer> c;\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void unfoldIfLessThanStarCount(@NotNull RemoveUnusedImportsTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.util.*;\n            class A {\n               Collection<Integer> c;\n               Set<Integer> s = new HashSet<>();\n            }\n        ", (String)"\n            import java.util.Collection;\n            import java.util.HashSet;\n            import java.util.Set;\n            class A {\n               Collection<Integer> c;\n               Set<Integer> s = new HashSet<>();\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void leaveStarImportInPlaceIfMoreThanStarCount(@NotNull RemoveUnusedImportsTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.util.*;\n            class A {\n               Collection<Integer> c;\n               Set<Integer> s = new HashSet<>();\n               List<String> l = Arrays.asList(\"a\",\"b\",\"c\");\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void removeStarStaticImport(@NotNull RemoveUnusedImportsTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import static java.util.Collections.*;\n            class A {}\n        ", (String)"class A {}")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void leaveStarStaticImportIfReferenceStillExists(@NotNull RemoveUnusedImportsTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import static java.util.Collections.*;\n            class A {\n               Object o = emptyList();\n            }\n        ", (String)"\n            import static java.util.Collections.emptyList;\n            class A {\n               Object o = emptyList();\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void removeStaticImportIfNotReferenced(@NotNull RemoveUnusedImportsTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.time.DayOfWeek;\n            \n            import static java.time.DayOfWeek.MONDAY;\n            import static java.time.DayOfWeek.TUESDAY;\n            \n            class WorkWeek {\n                DayOfWeek shortWeekStarts(){\n                    return TUESDAY;\n                }\n            }\n        ", (String)"\n            import java.time.DayOfWeek;\n            \n            import static java.time.DayOfWeek.TUESDAY;\n            \n            class WorkWeek {\n                DayOfWeek shortWeekStarts(){\n                    return TUESDAY;\n                }\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void leaveNamedStaticImportIfReferenceStillExists(@NotNull RemoveUnusedImportsTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import static java.util.Collections.emptyList;\n            import static java.util.Collections.emptySet;\n            \n            class A {\n               Object o = emptyList();\n            }\n        ", (String)"\n            import static java.util.Collections.emptyList;\n            \n            class A {\n               Object o = emptyList();\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void leaveNamedStaticImportOnFieldIfReferenceStillExists(@NotNull RemoveUnusedImportsTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n                package foo;\n                public class B {\n                    public static final String STRING = \"string\";\n                    public static final String STRING2 = \"string2\";\n                }\n        "), Assertions.java((String)"\n                package foo;\n                public class C {\n                    public static final String ANOTHER = \"string\";\n                }\n        "), Assertions.java((String)"\n            import static foo.B.STRING;\n            import static foo.B.STRING2;\n            import static foo.C.*;\n            \n            public class A {\n                String a = STRING;\n            }\n        ", (String)"\n            import static foo.B.STRING;\n            \n            public class A {\n                String a = STRING;\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void removePackageInfoImports(@NotNull RemoveUnusedImportsTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n                package foo;\n                public @interface FooAnnotation {}\n                public @interface Foo {}\n                public @interface Bar {}\n            "), Assertions.java((String)"\n            @Foo\n            @Bar\n            package foo.bar.baz;\n            \n            import foo.Bar;\n            import foo.Foo;\n            import foo.FooAnnotation;\n        ", (String)"\n            @Foo\n            @Bar\n            package foo.bar.baz;\n            \n            import foo.Bar;\n            import foo.Foo;\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void removePackageInfoStarImports(@NotNull RemoveUnusedImportsTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n                package foo;\n                public @interface FooAnnotation {}\n                public @interface Foo {}\n                public @interface Bar {}\n            "), Assertions.java((String)"\n            @Foo\n            @Bar\n            package foo.bar.baz;\n            \n            import foo.*;\n        ", (String)"\n            @Foo\n            @Bar\n            package foo.bar.baz;\n            \n            import foo.Bar;\n            import foo.Foo;\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void dontRemoveStaticReferenceToPrimitiveField(@NotNull RemoveUnusedImportsTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import static java.sql.ResultSet.TYPE_FORWARD_ONLY;\n            public class A {\n                int t = TYPE_FORWARD_ONLY;\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void resultSetType(@NotNull RemoveUnusedImportsTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.sql.ResultSet;\n            public class A {\n                int t = ResultSet.TYPE_FORWARD_ONLY;\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void ensuresWhitespaceAfterPackageDeclarationNoImportsRemain(@NotNull RemoveUnusedImportsTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            package com.example.foo;\n            import java.util.List;\n            public class A {\n            }\n        ", (String)"\n            package com.example.foo;\n            \n            public class A {\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void doesNotAffectClassBodyFormatting(@NotNull RemoveUnusedImportsTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            package com.example.foo;\n            \n            import java.util.List;\n            import java.util.ArrayList;\n            \n            public class A {\n            // Intentionally misaligned to ensure formatting is not overzealous\n            ArrayList<String> foo = new ArrayList<>();\n            }\n        ", (String)"\n            package com.example.foo;\n            \n            import java.util.ArrayList;\n            \n            public class A {\n            // Intentionally misaligned to ensure formatting is not overzealous\n            ArrayList<String> foo = new ArrayList<>();\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void doesNotRemoveStaticReferenceToNewClass(@NotNull RemoveUnusedImportsTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            package org.openrewrite;\n            public class Bar {\n                public static final class Buz {\n                    public Buz() {}\n                }\n            }\n        "), Assertions.java((String)"\n            package foo.test;\n\n            import static org.openrewrite.Bar.Buz;\n\n            public class Test {\n                private void method() {\n                    new Buz();\n                }\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void doNotUnfoldStaticValidWildCard(@NotNull RemoveUnusedImportsTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            package org.openrewrite;\n            public class Foo {\n                public static final int FOO_CONSTANT = 10;\n                public static final class Bar {\n                    private Bar() {}\n                    public static void helper() {}\n                }\n                public static void fooMethod() {}\n            }\n        "), Assertions.java((String)"\n            package foo.test;\n            \n            import static org.openrewrite.Foo.*;\n            \n            public class Test {\n                int val = FOO_CONSTANT;\n                private void method() {\n                    fooMethod();\n                    Bar.helper();\n                }\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void unfoldStaticUses(@NotNull RemoveUnusedImportsTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            package org.openrewrite;\n            public class Foo {\n                public static final int FOO_CONSTANT = 10;\n                public static final class Bar {\n                    private Bar(){}\n                    public static void helper() {}\n                }\n                public static void fooMethod() {}\n            }\n        "), Assertions.java((String)"\n            package foo.test;\n            \n            import static org.openrewrite.Foo.*;\n            \n            public class Test {\n                int val = FOO_CONSTANT;\n                private void method() {\n                    Bar.helper();\n                }\n            }\n        ", (String)"\n            package foo.test;\n            \n            import static org.openrewrite.Foo.FOO_CONSTANT;\n            import static org.openrewrite.Foo.Bar;\n            \n            public class Test {\n                int val = FOO_CONSTANT;\n                private void method() {\n                    Bar.helper();\n                }\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void doNotUnfoldPackage(@NotNull RemoveUnusedImportsTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.util.*;\n            \n            import static java.util.Collections.*;\n\n            class Test {\n                List<String> l = emptyList();\n            }\n        ")};
            this_.rewriteRun(DefaultImpls::doNotUnfoldPackage$lambda-0, sourceSpecsArray);
        }

        @Test
        public static void unfoldSubpackage(@NotNull RemoveUnusedImportsTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.util.concurrent.*;\n            \n            import static java.util.Collections.*;\n\n            class Test {\n                Object o = emptyMap();\n                ConcurrentHashMap<String, String> m;\n            }\n        ", (String)"\n            import java.util.concurrent.ConcurrentHashMap;\n            \n            import static java.util.Collections.emptyMap;\n            \n            class Test {\n                Object o = emptyMap();\n                ConcurrentHashMap<String, String> m;\n            }\n        ")};
            this_.rewriteRun(DefaultImpls::unfoldSubpackage$lambda-1, sourceSpecsArray);
        }

        @Test
        public static void doNotUnfoldSubpackage(@NotNull RemoveUnusedImportsTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.util.concurrent.*;\n            \n            import static java.util.Collections.*;\n            \n            class Test {\n                ConcurrentHashMap<String, String> m = emptyMap();\n            }\n        ")};
            this_.rewriteRun(DefaultImpls::doNotUnfoldSubpackage$lambda-2, sourceSpecsArray);
        }

        @Test
        public static void removeImportsForSamePackage(@NotNull RemoveUnusedImportsTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            package com.google.gson.annotations;\n            \n            import java.lang.annotation.Documented;\n            import java.lang.annotation.ElementType;\n            import java.lang.annotation.Retention;\n            import java.lang.annotation.RetentionPolicy;\n            import java.lang.annotation.Target;\n\n            @Documented\n            @Retention(RetentionPolicy.RUNTIME)\n            @Target({ElementType.FIELD, ElementType.METHOD})\n            public @interface SerializedName {\n                String value();\n            }\n        "), Assertions.java((String)"\n            package com.google.gson.annotations;\n\n            import com.google.gson.annotations.SerializedName;\n            \n            public enum PKIState {\n                @SerializedName(\"active\") ACTIVE,\n                @SerializedName(\"dismissed\") DISMISSED\n            }\n        ", (String)"\n            package com.google.gson.annotations;\n            \n            public enum PKIState {\n                @SerializedName(\"active\") ACTIVE,\n                @SerializedName(\"dismissed\") DISMISSED\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void removeImportUsedAsLambdaParameter(@NotNull RemoveUnusedImportsTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.util.HashMap;\n            import java.util.function.Function;\n\n            public class Test {\n                public static void foo(){\n                    final HashMap<Integer,String> map = new HashMap<>();\n                    map.computeIfAbsent(3, integer -> String.valueOf(integer + 1));\n                }\n            }\n        ", (String)"\n            import java.util.HashMap;\n\n            public class Test {\n                public static void foo(){\n                    final HashMap<Integer,String> map = new HashMap<>();\n                    map.computeIfAbsent(3, integer -> String.valueOf(integer + 1));\n                }\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void removeImportUsedAsMethodParameter(@NotNull RemoveUnusedImportsTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.util.HashMap;\n            import java.util.ArrayList;\n            import java.util.Set;\n\n            public class Test {\n                public static void foo(){\n                    new ArrayList<>(new HashMap<Integer, String>().keySet());\n                }\n            }\n        ", (String)"\n            import java.util.HashMap;\n            import java.util.ArrayList;\n\n            public class Test {\n                public static void foo(){\n                    new ArrayList<>(new HashMap<Integer, String>().keySet());\n                }\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void removeMultipleDirectImports(@NotNull RemoveUnusedImportsTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.util.Collection;\n            import java.util.Collection;\n\n            import static java.util.Collections.emptyList;\n            import static java.util.Collections.emptyList;\n\n            class A {\n               Collection<Integer> c = emptyList();\n            }\n        ", (String)"\n            import java.util.Collection;\n\n            import static java.util.Collections.emptyList;\n\n            class A {\n               Collection<Integer> c = emptyList();\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void removeMultipleWildcardImports(@NotNull RemoveUnusedImportsTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.util.*;\n            import java.util.*;\n\n            import static java.util.Collections.emptyList;\n\n            class A {\n               Collection<Integer> c = emptyList();\n               Set<Integer> s = new HashSet<>();\n               List<String> l = Arrays.asList(\"a\",\"b\",\"c\");\n            }\n        ", (String)"\n            import java.util.*;\n\n            import static java.util.Collections.emptyList;\n\n            class A {\n               Collection<Integer> c = emptyList();\n               Set<Integer> s = new HashSet<>();\n               List<String> l = Arrays.asList(\"a\",\"b\",\"c\");\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void removeWildcardImportWithDirectImport(@NotNull RemoveUnusedImportsTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.util.*;\n            import java.util.Collection;\n\n            import static java.util.Collections.*;\n            import static java.util.Collections.emptyList;\n\n            class A {\n               Collection<Integer> c = emptyList();\n            }\n        ", (String)"\n            import java.util.Collection;\n\n            import static java.util.Collections.emptyList;\n\n            class A {\n               Collection<Integer> c = emptyList();\n            }\n        ")};
            this_.rewriteRun(DefaultImpls::removeWildcardImportWithDirectImport$lambda-3, sourceSpecsArray);
        }

        @Test
        public static void removeDirectImportWithWildcardImport(@NotNull RemoveUnusedImportsTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.util.Set;\n            import java.util.*;\n\n            import static java.util.Collections.emptyList;\n            import static java.util.Collections.*;\n\n            class A {\n               Collection<Integer> c = emptyList();\n               Set<Integer> s = emptySet();\n               List<String> l = Arrays.asList(\"c\",\"b\",\"a\");\n               Iterator<Short> i = emptyIterator();\n            }\n        ", (String)"\n            import java.util.*;\n\n            import static java.util.Collections.*;\n\n            class A {\n               Collection<Integer> c = emptyList();\n               Set<Integer> s = emptySet();\n               List<String> l = Arrays.asList(\"c\",\"b\",\"a\");\n               Iterator<Short> i = emptyIterator();\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void removeMultipleImportsWhileUnfoldingWildcard(@NotNull RemoveUnusedImportsTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.util.Set;\n            import java.util.*;\n\n            import static java.util.Collections.emptyList;\n            import static java.util.Collections.*;\n\n            class A {\n               Collection<Integer> c = emptyList();\n               Set<Integer> s = emptySet();\n            }\n        ", (String)"\n            import java.util.Set;\n            import java.util.Collection;\n\n            import static java.util.Collections.emptyList;\n            import static java.util.Collections.emptySet;\n\n            class A {\n               Collection<Integer> c = emptyList();\n               Set<Integer> s = emptySet();\n            }\n        ")};
            this_.rewriteRun(DefaultImpls::removeMultipleImportsWhileUnfoldingWildcard$lambda-4, sourceSpecsArray);
        }

        @Test
        public static void keepInnerClassImports(@NotNull RemoveUnusedImportsTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.util.*;\n            import java.util.Map.Entry;\n\n            import static java.util.Collections.*;\n\n            class A {\n               Collection<Integer> c = emptyList();\n               Set<Integer> s = emptySet();\n               List<String> l = Arrays.asList(\"c\",\"b\",\"a\");\n               Iterator<Short> i = emptyIterator();\n               Entry<String, Integer> entry;\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        private static void doNotUnfoldPackage$lambda-0(RecipeSpec spec) {
            spec.parser((Parser.Builder)JavaParser.fromJavaVersion().styles((Iterable)CollectionsKt.listOf((Object)new NamedStyles(Tree.randomId(), "test", "test", "test", SetsKt.emptySet(), (Collection)CollectionsKt.listOf((Object)ImportLayoutStyle.builder().packageToFold("java.util.*").staticPackageToFold("java.util.Collections.*").importAllOthers().importStaticAllOthers().build())))));
        }

        private static void unfoldSubpackage$lambda-1(RecipeSpec spec) {
            spec.parser((Parser.Builder)JavaParser.fromJavaVersion().styles((Iterable)CollectionsKt.listOf((Object)new NamedStyles(Tree.randomId(), "test", "test", "test", SetsKt.emptySet(), (Collection)CollectionsKt.listOf((Object)ImportLayoutStyle.builder().packageToFold("java.util.*", Boolean.valueOf(false)).staticPackageToFold("java.util.*", Boolean.valueOf(false)).importAllOthers().importStaticAllOthers().build())))));
        }

        private static void doNotUnfoldSubpackage$lambda-2(RecipeSpec spec) {
            spec.parser((Parser.Builder)JavaParser.fromJavaVersion().styles((Iterable)CollectionsKt.listOf((Object)new NamedStyles(Tree.randomId(), "test", "test", "test", SetsKt.emptySet(), (Collection)CollectionsKt.listOf((Object)ImportLayoutStyle.builder().packageToFold("java.util.*", Boolean.valueOf(true)).staticPackageToFold("java.util.*", Boolean.valueOf(true)).importAllOthers().importStaticAllOthers().build())))));
        }

        private static void removeWildcardImportWithDirectImport$lambda-3(RecipeSpec spec) {
            spec.expectedCyclesThatMakeChanges(2);
        }

        private static void removeMultipleImportsWhileUnfoldingWildcard$lambda-4(RecipeSpec spec) {
            spec.expectedCyclesThatMakeChanges(2);
        }
    }
}

