/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.io.File;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaRecipeTest;
import org.openrewrite.java.RemoveAnnotation;
import org.openrewrite.java.TypeValidator;
import org.openrewrite.java.tree.J;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H\u0017J\b\u0010\u0004\u001a\u00020\u0003H\u0017J\b\u0010\u0005\u001a\u00020\u0003H\u0017J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\bH\u0017J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\bH\u0017J\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\bH\u0017\u00a8\u0006\u000b"}, d2={"Lorg/openrewrite/java/RemoveAnnotationTest;", "Lorg/openrewrite/java/JavaRecipeTest;", "multipleAnnotationsOnClass", "", "multipleAnnotationsOnMethod", "multipleAnnotationsOnVariable", "preserveWhitespaceOnModifiers", "jp", "Lorg/openrewrite/java/JavaParser;", "removeAnnotation", "removeLastAnnotationFromClassDeclaration", "rewrite-java-tck"})
public interface RemoveAnnotationTest
extends JavaRecipeTest {
    @Test
    public void removeLastAnnotationFromClassDeclaration(@NotNull JavaParser var1);

    @Test
    public void removeAnnotation(@NotNull JavaParser var1);

    @Test
    public void preserveWhitespaceOnModifiers(@NotNull JavaParser var1);

    @Test
    public void multipleAnnotationsOnClass();

    @Test
    public void multipleAnnotationsOnMethod();

    @Test
    public void multipleAnnotationsOnVariable();

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @Test
        public static void removeLastAnnotationFromClassDeclaration(@NotNull RemoveAnnotationTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, (Recipe)new RemoveAnnotation("@java.lang.Deprecated"), null, "\n            @Deprecated\n            interface Test {}\n        ", null, "\n            interface Test {}\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void removeAnnotation(@NotNull RemoveAnnotationTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, (Recipe)new RemoveAnnotation("@java.lang.Deprecated"), null, "\n            import java.util.List;\n\n            @Deprecated\n            public class Test {\n                @Deprecated\n                void test() {\n                    @Deprecated int n;\n                }\n            }\n        ", null, "\n            import java.util.List;\n\n            public class Test {\n                void test() {\n                    int n;\n                }\n            }\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void preserveWhitespaceOnModifiers(@NotNull RemoveAnnotationTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, (Recipe)new RemoveAnnotation("@java.lang.Deprecated"), null, "\n            import java.util.List;\n\n            @Deprecated\n            public class Test {\n                @Deprecated\n                private final Integer value = 0;\n            }\n        ", null, "\n            import java.util.List;\n\n            public class Test {\n                private final Integer value = 0;\n            }\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void multipleAnnotationsOnClass(@NotNull RemoveAnnotationTest this_) {
            RemoveAnnotation removeAnnotation2 = new RemoveAnnotation[]{"\n            package org.b;\n            \n            import java.lang.annotation.Target;\n            import static java.lang.annotation.ElementType.*;\n            \n            @Target({TYPE, FIELD, METHOD, PARAMETER, CONSTRUCTOR, LOCAL_VARIABLE})\n            public @interface ThirdAnnotation {\n            }\n        "};
            RemoveAnnotation removeAnnotation3 = removeAnnotation2;
            removeAnnotation2 = new RemoveAnnotation("@java.lang.Deprecated");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, (Recipe)removeAnnotation2, null, "\n            import org.b.ThirdAnnotation;\n\n            @Deprecated @SuppressWarnings(\"\") @ThirdAnnotation\n            public class PosOneWithModifier {\n            }\n            \n            @SuppressWarnings(\"\") @Deprecated @ThirdAnnotation\n            public class PosTwoWithModifier {\n            }\n\n            @SuppressWarnings(\"\") @ThirdAnnotation @Deprecated\n            public class PosThreeWithModifier {\n            }\n            \n            @Deprecated @SuppressWarnings(\"\") @ThirdAnnotation\n            class PosOneNoModifier {\n            }\n            \n            @SuppressWarnings(\"\") @Deprecated @ThirdAnnotation\n            class PosTwoNoModifier {\n            }\n            \n            @SuppressWarnings(\"\") @ThirdAnnotation @Deprecated\n            class PosThreeNoModifier {\n            }\n        ", (String[])removeAnnotation3, "\n            import org.b.ThirdAnnotation;\n\n            @SuppressWarnings(\"\") @ThirdAnnotation\n            public class PosOneWithModifier {\n            }\n            \n            @SuppressWarnings(\"\") @ThirdAnnotation\n            public class PosTwoWithModifier {\n            }\n            \n            @SuppressWarnings(\"\") @ThirdAnnotation\n            public class PosThreeWithModifier {\n            }\n            \n            @SuppressWarnings(\"\") @ThirdAnnotation\n            class PosOneNoModifier {\n            }\n            \n            @SuppressWarnings(\"\") @ThirdAnnotation\n            class PosTwoNoModifier {\n            }\n            \n            @SuppressWarnings(\"\") @ThirdAnnotation\n            class PosThreeNoModifier {\n            }\n        ", 0, 0, null, null, 965, null);
        }

        @Test
        public static void multipleAnnotationsOnMethod(@NotNull RemoveAnnotationTest this_) {
            RemoveAnnotation removeAnnotation2 = new RemoveAnnotation[]{"\n            package org.b;\n            \n            import java.lang.annotation.Target;\n            import static java.lang.annotation.ElementType.*;\n            \n            @Target({TYPE, FIELD, METHOD, PARAMETER, CONSTRUCTOR, LOCAL_VARIABLE})\n            public @interface ThirdAnnotation {\n            }\n        "};
            RemoveAnnotation removeAnnotation3 = removeAnnotation2;
            removeAnnotation2 = new RemoveAnnotation("@java.lang.Deprecated");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, (Recipe)removeAnnotation2, null, "\n            import org.b.ThirdAnnotation;\n            \n            public class RemoveAnnotation {\n            \n                private Integer intValue;\n                private Double doubleValue;\n                private Long longValue;\n                \n                // Pos 1 with modifier.\n                @Deprecated\n                @SuppressWarnings(\"\")\n                @ThirdAnnotation\n                public RemoveAnnotation(Integer intValue) {\n                    this.intValue = intValue;\n                }\n                \n                // Pos 2 with modifier.\n                @SuppressWarnings(\"\")\n                @Deprecated\n                @ThirdAnnotation\n                public RemoveAnnotation(Double doubleValue) {\n                    this.doubleValue = doubleValue;\n                }\n                \n                // Pos 3 with modifier.\n                @SuppressWarnings(\"\")\n                @ThirdAnnotation\n                @Deprecated\n                public RemoveAnnotation(Long longValue) {\n                    this.longValue = longValue;\n                }\n                \n                // Pos 1 no modifier.\n                @Deprecated\n                @SuppressWarnings(\"\")\n                @ThirdAnnotation\n                RemoveAnnotation(Integer intValue, Double doubleValue) {\n                    this.intValue = intValue;\n                    this.doubleValue = doubleValue;\n                }\n                \n                // Pos 2 no modifier.\n                @SuppressWarnings(\"\")\n                @Deprecated\n                @ThirdAnnotation\n                RemoveAnnotation(Double doubleValue, Long longValue) {\n                    this.doubleValue = doubleValue;\n                    this.longValue = longValue;\n                }\n                \n                // Pos 3 no modifier.\n                @SuppressWarnings(\"\")\n                @ThirdAnnotation\n                @Deprecated\n                RemoveAnnotation(Integer intValue, Double doubleValue, Long longValue) {\n                    this.intValue = intValue;\n                    this.doubleValue = doubleValue;\n                    this.longValue = longValue;\n                }\n                \n                @Deprecated\n                @SuppressWarnings(\"\")\n                @ThirdAnnotation\n                public void pos1WithModifier() {\n                }\n                \n                @SuppressWarnings(\"\")\n                @Deprecated\n                @ThirdAnnotation\n                public void pos2WithModifier() {\n                }\n                \n                @SuppressWarnings(\"\")\n                @ThirdAnnotation\n                @Deprecated\n                public void pos3WithModifier() {\n                }\n                \n                @Deprecated\n                @SuppressWarnings(\"\")\n                @ThirdAnnotation\n                void pos1NoModifier() {\n                }\n                \n                @SuppressWarnings(\"\")\n                @Deprecated\n                @ThirdAnnotation\n                void pos2NoModifier() {\n                }\n                \n                @SuppressWarnings(\"\")\n                @ThirdAnnotation\n                @Deprecated\n                void pos3NoModifier() {\n                }\n            }\n        ", (String[])removeAnnotation3, "\n            import org.b.ThirdAnnotation;\n            \n            public class RemoveAnnotation {\n            \n                private Integer intValue;\n                private Double doubleValue;\n                private Long longValue;\n                \n                // Pos 1 with modifier.\n                @SuppressWarnings(\"\")\n                @ThirdAnnotation\n                public RemoveAnnotation(Integer intValue) {\n                    this.intValue = intValue;\n                }\n                \n                // Pos 2 with modifier.\n                @SuppressWarnings(\"\")\n                @ThirdAnnotation\n                public RemoveAnnotation(Double doubleValue) {\n                    this.doubleValue = doubleValue;\n                }\n                \n                // Pos 3 with modifier.\n                @SuppressWarnings(\"\")\n                @ThirdAnnotation\n                public RemoveAnnotation(Long longValue) {\n                    this.longValue = longValue;\n                }\n                \n                // Pos 1 no modifier.\n                @SuppressWarnings(\"\")\n                @ThirdAnnotation\n                RemoveAnnotation(Integer intValue, Double doubleValue) {\n                    this.intValue = intValue;\n                    this.doubleValue = doubleValue;\n                }\n                \n                // Pos 2 no modifier.\n                @SuppressWarnings(\"\")\n                @ThirdAnnotation\n                RemoveAnnotation(Double doubleValue, Long longValue) {\n                    this.doubleValue = doubleValue;\n                    this.longValue = longValue;\n                }\n                \n                // Pos 3 no modifier.\n                @SuppressWarnings(\"\")\n                @ThirdAnnotation\n                RemoveAnnotation(Integer intValue, Double doubleValue, Long longValue) {\n                    this.intValue = intValue;\n                    this.doubleValue = doubleValue;\n                    this.longValue = longValue;\n                }\n                \n                @SuppressWarnings(\"\")\n                @ThirdAnnotation\n                public void pos1WithModifier() {\n                }\n                \n                @SuppressWarnings(\"\")\n                @ThirdAnnotation\n                public void pos2WithModifier() {\n                }\n                \n                @SuppressWarnings(\"\")\n                @ThirdAnnotation\n                public void pos3WithModifier() {\n                }\n                \n                @SuppressWarnings(\"\")\n                @ThirdAnnotation\n                void pos1NoModifier() {\n                }\n                \n                @SuppressWarnings(\"\")\n                @ThirdAnnotation\n                void pos2NoModifier() {\n                }\n                \n                @SuppressWarnings(\"\")\n                @ThirdAnnotation\n                void pos3NoModifier() {\n                }\n            }\n        ", 0, 0, null, null, 965, null);
        }

        @Test
        public static void multipleAnnotationsOnVariable(@NotNull RemoveAnnotationTest this_) {
            RemoveAnnotation removeAnnotation2 = new RemoveAnnotation[]{"\n            package org.b;\n            \n            import java.lang.annotation.Target;\n            import static java.lang.annotation.ElementType.*;\n            \n            @Target({TYPE, FIELD, METHOD, PARAMETER, CONSTRUCTOR, LOCAL_VARIABLE})\n            public @interface ThirdAnnotation {\n            }\n        "};
            RemoveAnnotation removeAnnotation3 = removeAnnotation2;
            removeAnnotation2 = new RemoveAnnotation("@java.lang.Deprecated");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, (Recipe)removeAnnotation2, null, "\n            import org.b.ThirdAnnotation;\n            \n            public class RemoveAnnotation {\n            \n                @Deprecated\n                @SuppressWarnings(\"\")\n                @ThirdAnnotation\n                public final Integer pos1WithModifiers;\n                \n                @SuppressWarnings(\"\")\n                @Deprecated\n                @ThirdAnnotation\n                public final Integer pos2WithModifiers;\n                \n                @SuppressWarnings(\"\")\n                @ThirdAnnotation\n                @Deprecated\n                public final Integer pos3WithModifiers;\n                \n                @Deprecated\n                @SuppressWarnings(\"\")\n                @ThirdAnnotation\n                Integer pos1NoModifiers;\n                \n                @SuppressWarnings(\"\")\n                @Deprecated\n                @ThirdAnnotation\n                Integer pos2NoModifiers;\n                \n                @SuppressWarnings(\"\")\n                @ThirdAnnotation\n                @Deprecated\n                Integer pos3NoModifiers;\n            }\n        ", (String[])removeAnnotation3, "\n            import org.b.ThirdAnnotation;\n            \n            public class RemoveAnnotation {\n            \n                @SuppressWarnings(\"\")\n                @ThirdAnnotation\n                public final Integer pos1WithModifiers;\n                \n                @SuppressWarnings(\"\")\n                @ThirdAnnotation\n                public final Integer pos2WithModifiers;\n                \n                @SuppressWarnings(\"\")\n                @ThirdAnnotation\n                public final Integer pos3WithModifiers;\n                \n                @SuppressWarnings(\"\")\n                @ThirdAnnotation\n                Integer pos1NoModifiers;\n                \n                @SuppressWarnings(\"\")\n                @ThirdAnnotation\n                Integer pos2NoModifiers;\n                \n                @SuppressWarnings(\"\")\n                @ThirdAnnotation\n                Integer pos3NoModifiers;\n            }\n        ", 0, 0, null, null, 965, null);
        }

        @NotNull
        public static JavaParser getParser(@NotNull RemoveAnnotationTest this_) {
            return JavaRecipeTest.DefaultImpls.getParser(this_);
        }

        @NotNull
        public static ExecutionContext getExecutionContext(@NotNull RemoveAnnotationTest this_) {
            return JavaRecipeTest.DefaultImpls.getExecutionContext(this_);
        }

        @BeforeEach
        public static void beforeRecipe(@NotNull RemoveAnnotationTest this_) {
            JavaRecipeTest.DefaultImpls.beforeRecipe(this_);
        }

        @AfterEach
        public static void afterRecipe(@NotNull RemoveAnnotationTest this_) {
            JavaRecipeTest.DefaultImpls.afterRecipe(this_);
        }

        public static void assertChanged(@NotNull RemoveAnnotationTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super TypeValidator.ValidationOptions.Companion.Builder, Unit> typeValidation, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(typeValidation, (String)"typeValidation");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged(this_, parser, recipe2, executionContext, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, typeValidation, afterConditions);
        }

        public static void assertChanged(@NotNull RemoveAnnotationTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull File before, @Nullable Path relativeTo, @Language(value="java") @NotNull File[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super TypeValidator.ValidationOptions.Companion.Builder, Unit> typeValidation, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(typeValidation, (String)"typeValidation");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged(this_, parser, recipe2, executionContext, before, relativeTo, dependsOn, after, cycles, expectedCyclesThatMakeChanges, typeValidation, afterConditions);
        }

        public static void assertUnchanged(@NotNull RemoveAnnotationTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, parser, recipe2, executionContext, before, dependsOn);
        }

        public static void assertUnchanged(@NotNull RemoveAnnotationTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull File before, @Nullable Path relativeTo, @Language(value="java") @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, parser, recipe2, executionContext, before, relativeTo, dependsOn);
        }

        @Nullable
        public static Recipe getRecipe(@NotNull RemoveAnnotationTest this_) {
            return JavaRecipeTest.DefaultImpls.getRecipe(this_);
        }

        public static void assertChangedBase(@NotNull RemoveAnnotationTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull File before, @Nullable Path relativeTo, @NotNull File[] dependsOn, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase(this_, parser, recipe2, executionContext, before, relativeTo, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertChangedBase(@NotNull RemoveAnnotationTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull String before, @NotNull String[] dependsOn, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase(this_, parser, recipe2, executionContext, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertUnchangedBase(@NotNull RemoveAnnotationTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull File before, @Nullable Path relativeTo, @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchangedBase(this_, parser, recipe2, executionContext, before, relativeTo, dependsOn);
        }

        public static void assertUnchangedBase(@NotNull RemoveAnnotationTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull String before, @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchangedBase(this_, parser, recipe2, executionContext, before, dependsOn);
        }

        @NotNull
        public static Recipe fromRuntimeClasspath(@NotNull RemoveAnnotationTest this_, @NotNull String recipe2) {
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            return JavaRecipeTest.DefaultImpls.fromRuntimeClasspath(this_, recipe2);
        }

        @NotNull
        public static Recipe toRecipe(@NotNull RemoveAnnotationTest this_, @NotNull Function0<? extends TreeVisitor<?, ExecutionContext>> supplier) {
            Intrinsics.checkNotNullParameter(supplier, (String)"supplier");
            return JavaRecipeTest.DefaultImpls.toRecipe(this_, supplier);
        }
    }
}

