/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaRecipeTest;
import org.openrewrite.java.OrderImports;
import org.openrewrite.java.TypeValidator;
import org.openrewrite.java.style.ImportLayoutStyle;
import org.openrewrite.java.tree.J;
import org.openrewrite.style.NamedStyles;
import org.openrewrite.style.Style;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001c\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0006\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\tH\u0017J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000bH\u0017J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000bH\u0017J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000bH\u0017J\u0018\u0010\u000e\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\tH\u0017J\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000bH\u0017J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000bH\u0017J\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000bH\u0017J\u0010\u0010\u0012\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000bH\u0017J\b\u0010\u0013\u001a\u00020\u0007H\u0017J\u0010\u0010\u0014\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000bH\u0017J\u0010\u0010\u0015\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000bH\u0017J\u0010\u0010\u0016\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000bH\u0017J\u0010\u0010\u0017\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000bH\u0017J\u0010\u0010\u0018\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000bH\u0017J\u0010\u0010\u0019\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000bH\u0017J\u0010\u0010\u001a\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000bH\u0017J\u0010\u0010\u001b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000bH\u0017J\u0010\u0010\u001c\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000bH\u0017J\u0010\u0010\u001d\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000bH\u0017J\u0010\u0010\u001e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000bH\u0017J\u0010\u0010\u001f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000bH\u0017J\u0010\u0010 \u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000bH\u0017J\u0010\u0010!\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000bH\u0017J\b\u0010\"\u001a\u00020\u0007H\u0017J\u0010\u0010#\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000bH\u0017J\u0010\u0010$\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000bH\u0017J\u0010\u0010%\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000bH\u0017J\u0010\u0010&\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000bH\u0017R\u0014\u0010\u0002\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006'"}, d2={"Lorg/openrewrite/java/OrderImportsTest;", "Lorg/openrewrite/java/JavaRecipeTest;", "recipe", "Lorg/openrewrite/java/OrderImports;", "getRecipe", "()Lorg/openrewrite/java/OrderImports;", "blankLinesBetweenImports", "", "jp", "Lorg/openrewrite/java/JavaParser$Builder;", "blankLinesNotFollowedByBlockArentAdded", "Lorg/openrewrite/java/JavaParser;", "collapsesDifferentStaticImportsFromSamePackage", "detectBlockPattern", "doNotFoldImports", "doNotFoldPackageWithJavaLangClassNames", "foldGroupOfStaticImportsThatAppearLast", "foldIntoExistingStar", "foldIntoStar", "foldPackageWithExistingImports", "groupImportsIsAwareOfNestedClasses", "idempotence", "importSorting", "multipleClassesWithTheSameNameButDifferentPackages", "orderAndDoNotFoldImports", "orderAndDoNotFoldStaticClasses", "packagePatternEscapesDots", "preservesDifferentStaticImportsFromSamePackage", "preservesStaticInheritanceImport", "preservesStaticMethodArguments", "preservesStaticStarImportWhenRemovingUnused", "removeUnused", "removesRedundantImports", "sortInnerAndOuterClassesInTheSamePackage", "springCloudFormat", "twoImportsFollowedByStar", "unfoldStar", "unfoldStarMultiple", "unfoldStaticStar", "rewrite-java-tck"})
public interface OrderImportsTest
extends JavaRecipeTest {
    @NotNull
    public OrderImports getRecipe();

    @Test
    public void sortInnerAndOuterClassesInTheSamePackage(@NotNull JavaParser var1);

    @Test
    public void multipleClassesWithTheSameNameButDifferentPackages(@NotNull JavaParser var1);

    @Test
    public void foldIntoStar(@NotNull JavaParser var1);

    @Test
    public void blankLinesNotFollowedByBlockArentAdded(@NotNull JavaParser var1);

    @Test
    public void foldIntoExistingStar(@NotNull JavaParser var1);

    @Test
    public void idempotence(@NotNull JavaParser var1);

    @Test
    public void unfoldStar(@NotNull JavaParser var1);

    @Test
    public void unfoldStarMultiple(@NotNull JavaParser var1);

    @Test
    public void removeUnused(@NotNull JavaParser var1);

    @Test
    public void unfoldStaticStar(@NotNull JavaParser var1);

    @Test
    public void packagePatternEscapesDots(@NotNull JavaParser var1);

    @Test
    public void twoImportsFollowedByStar(@NotNull JavaParser var1);

    @Test
    public void springCloudFormat();

    @Test
    public void importSorting(@NotNull JavaParser var1);

    @Test
    public void foldGroupOfStaticImportsThatAppearLast(@NotNull JavaParser var1);

    @Test
    public void preservesStaticStarImportWhenRemovingUnused(@NotNull JavaParser var1);

    @Test
    public void preservesStaticInheritanceImport(@NotNull JavaParser var1);

    @Test
    public void preservesStaticMethodArguments(@NotNull JavaParser var1);

    @Test
    public void preservesDifferentStaticImportsFromSamePackage(@NotNull JavaParser var1);

    @Test
    public void collapsesDifferentStaticImportsFromSamePackage(@NotNull JavaParser var1);

    @Test
    public void removesRedundantImports(@NotNull JavaParser var1);

    @Test
    public void blankLinesBetweenImports(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    public void groupImportsIsAwareOfNestedClasses(@NotNull JavaParser var1);

    @Test
    public void detectBlockPattern(@NotNull JavaParser var1);

    @Test
    public void doNotFoldImports(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    public void orderAndDoNotFoldStaticClasses(@NotNull JavaParser var1);

    @Test
    public void orderAndDoNotFoldImports(@NotNull JavaParser var1);

    @Test
    public void doNotFoldPackageWithJavaLangClassNames(@NotNull JavaParser var1);

    @Test
    public void foldPackageWithExistingImports();

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @NotNull
        public static OrderImports getRecipe(@NotNull OrderImportsTest this_) {
            return new OrderImports(Boolean.valueOf(false));
        }

        @Test
        public static void sortInnerAndOuterClassesInTheSamePackage(@NotNull OrderImportsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, jp, null, null, "class Test {}", null, 22, null);
        }

        @Test
        public static void multipleClassesWithTheSameNameButDifferentPackages(@NotNull OrderImportsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, jp, null, null, "\n            import java.awt.List;\n            import java.util.List;\n            \n            class Test {}\n        ", null, 22, null);
        }

        @Test
        public static void foldIntoStar(@NotNull OrderImportsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, null, null, "\n            import java.util.List;\n            import java.util.ArrayList;\n            import java.util.regex.Pattern;\n            import java.util.Objects;\n            import java.util.Set;\n            import java.util.Map;\n        ", null, "\n            import java.util.*;\n            import java.util.regex.Pattern;\n        ", 0, 0, null, null, 982, null);
        }

        @Test
        public static void blankLinesNotFollowedByBlockArentAdded(@NotNull OrderImportsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, jp, null, null, "\n            import java.util.List;\n            \n            import static java.util.Collections.*;\n            \n            class A {}\n        ", null, 22, null);
        }

        @Test
        public static void foldIntoExistingStar(@NotNull OrderImportsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, null, null, "\n            import java.util.*;\n            import java.util.ArrayList;\n            import java.util.regex.Pattern;\n            import java.util.Objects;\n        ", null, "\n            import java.util.*;\n            import java.util.regex.Pattern;\n        ", 0, 0, null, null, 982, null);
        }

        @Test
        public static void idempotence(@NotNull OrderImportsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, jp, null, null, "\n            import java.util.*;\n            import java.util.regex.Pattern;\n        ", null, 22, null);
        }

        @Test
        public static void unfoldStar(@NotNull OrderImportsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, (Recipe)new OrderImports(Boolean.valueOf(true)), null, "\n            import java.util.*;\n            \n            class A {\n                List<Integer> list;\n                List<Integer> list2;\n            }\n        ", null, "\n            import java.util.List;\n            \n            class A {\n                List<Integer> list;\n                List<Integer> list2;\n            }\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void unfoldStarMultiple(@NotNull OrderImportsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, (Recipe)new OrderImports(Boolean.valueOf(true)), null, "\n            import java.util.*;\n            \n            class A {\n                List<Integer> list;\n                List<Integer> list2;\n                Map<Integer, Integer> map;\n            }\n        ", null, "\n            import java.util.List;\n            import java.util.Map;\n            \n            class A {\n                List<Integer> list;\n                List<Integer> list2;\n                Map<Integer, Integer> map;\n            }\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void removeUnused(@NotNull OrderImportsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, (Recipe)new OrderImports(Boolean.valueOf(true)), null, "\n            import java.util.*;\n        ", null, "", 0, 0, null, null, 980, null);
        }

        @Test
        public static void unfoldStaticStar(@NotNull OrderImportsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, (Recipe)new OrderImports(Boolean.valueOf(true)), null, "\n            import java.util.List;\n            \n            import static java.util.Collections.*;\n            \n            class A {\n                List<Integer> list = emptyList();\n            }\n        ", null, "\n            import java.util.List;\n            \n            import static java.util.Collections.emptyList;\n            \n            class A {\n                List<Integer> list = emptyList();\n            }\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void packagePatternEscapesDots(@NotNull OrderImportsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, jp, null, null, "\n            import javax.annotation.Nonnull;\n        ", null, 22, null);
        }

        @Test
        public static void twoImportsFollowedByStar(@NotNull OrderImportsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, jp, null, null, "\n            import java.io.IOException;\n            import java.io.UncheckedIOException;\n            import java.nio.files.*;\n        ", null, 22, null);
        }

        @Test
        public static void springCloudFormat(@NotNull OrderImportsTest this_) {
            JavaRecipeTest javaRecipeTest = this_;
            JavaParser javaParser = JavaParser.fromJavaVersion().styles((Iterable)CollectionsKt.listOf((Object)new NamedStyles(Tree.randomId(), "spring", "spring", "spring", SetsKt.emptySet(), (Collection)CollectionsKt.listOf((Object)ImportLayoutStyle.builder().classCountToUseStarImport(999).nameCountToUseStarImport(999).importPackage("java.*").blankLine().importPackage("javax.*").blankLine().importAllOthers().blankLine().importPackage("org.springframework.*").blankLine().importStaticAllOthers().build())))).build();
            Intrinsics.checkNotNullExpressionValue((Object)javaParser, (String)"fromJavaVersion().styles\u2026      )\n        ).build()");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(javaRecipeTest, javaParser, null, null, "\n            import java.io.ByteArrayOutputStream;\n            import java.nio.charset.StandardCharsets;\n            import java.util.Collections;\n            import java.util.zip.GZIPOutputStream;\n            \n            import javax.servlet.ReadListener;\n            import javax.servlet.ServletInputStream;\n            import javax.servlet.ServletOutputStream;\n            \n            import com.fasterxml.jackson.databind.ObjectMapper;\n            import org.apache.commons.logging.Log;\n            import reactor.core.publisher.Mono;\n            \n            import org.springframework.core.io.buffer.DataBuffer;\n            import org.springframework.core.io.buffer.DataBufferFactory;\n            import org.springframework.http.HttpHeaders;\n            import org.springframework.util.MultiValueMap;\n            import org.springframework.web.bind.annotation.PathVariable;\n            import org.springframework.web.server.ServerWebExchange;\n            \n            import static java.util.Arrays.stream;\n            import static org.springframework.cloud.gateway.support.ServerWebExchangeUtils.toAsyncPredicate;\n            \n            class A {}\n        ", null, 22, null);
        }

        @Test
        public static void importSorting(@NotNull OrderImportsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, null, null, "\n            import r.core.Flux;\n            import s.core.Flux;\n            import com.fasterxml.jackson.databind.ObjectMapper;\n            import org.apache.commons.logging.Log;\n            import reactor.core.publisher.Mono;\n        ", null, "\n            import com.fasterxml.jackson.databind.ObjectMapper;\n            import org.apache.commons.logging.Log;\n            import r.core.Flux;\n            import reactor.core.publisher.Mono;\n            import s.core.Flux;\n        ", 0, 0, null, null, 982, null);
        }

        @Test
        public static void foldGroupOfStaticImportsThatAppearLast(@NotNull OrderImportsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, null, null, "\n            import static java.util.stream.Collectors.toList;\n            import static java.util.stream.Collectors.toMap;\n            import static java.util.stream.Collectors.toSet;\n        ", null, "\n            import static java.util.stream.Collectors.*;\n        ", 0, 0, null, null, 982, null);
        }

        @Test
        public static void preservesStaticStarImportWhenRemovingUnused(@NotNull OrderImportsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, jp, (Recipe)new OrderImports(Boolean.valueOf(true)), null, "\n            import static java.util.Collections.*;\n            \n            class Test {\n                Object[] o = new Object[] { emptyList(), emptyMap(), emptySet() };\n            }\n        ", null, 20, null);
        }

        @Test
        public static void preservesStaticInheritanceImport(@NotNull OrderImportsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            OrderImports orderImports = new OrderImports(Boolean.valueOf(true));
            String[] stringArray = new String[]{"package my; public class MyCollections extends java.util.Collections {}"};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, jp, (Recipe)orderImports, null, "\n            import static my.MyCollections.*;\n            \n            class Test {\n                Object[] o = new Object[] { emptyList(), emptyMap(), emptySet() };\n            }\n        ", stringArray2, 4, null);
        }

        @Test
        public static void preservesStaticMethodArguments(@NotNull OrderImportsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, jp, (Recipe)new OrderImports(Boolean.valueOf(true)), null, "\n            import static java.util.Collections.*;\n            \n            class Test {\n                Object[] o = new Object[] { emptyList(), emptyMap(), emptySet() };\n            }\n        ", null, 20, null);
        }

        @Test
        public static void preservesDifferentStaticImportsFromSamePackage(@NotNull OrderImportsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, jp, null, null, "\n            import static java.util.Collections.emptyList;\n            import static java.util.Collections.emptyMap;\n            import static java.util.GregorianCalendar.getAvailableCalendarTypes;\n            import static java.util.GregorianCalendar.getAvailableLocales;\n        ", null, 22, null);
        }

        @Test
        public static void collapsesDifferentStaticImportsFromSamePackage(@NotNull OrderImportsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, null, null, "\n            import static java.util.Collections.emptyList;\n            import static java.util.Collections.emptyMap;\n            import static java.util.Collections.emptySet;\n            import static java.util.GregorianCalendar.getAvailableCalendarTypes;\n            import static java.util.GregorianCalendar.getAvailableLocales;\n            import static java.util.GregorianCalendar.getInstance;\n        ", null, "\n            import static java.util.Collections.*;\n            import static java.util.GregorianCalendar.*;\n        ", 0, 0, null, null, 982, null);
        }

        @Test
        public static void removesRedundantImports(@NotNull OrderImportsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, null, null, "\n            import java.util.List;\n            import java.util.List;\n        ", null, "\n            import java.util.List;\n        ", 0, 0, null, null, 982, null);
        }

        @Test
        public static void blankLinesBetweenImports(@NotNull OrderImportsTest this_, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            JavaRecipeTest javaRecipeTest = this_;
            ImportLayoutStyle importLayoutStyle = ImportLayoutStyle.builder().classCountToUseStarImport(9999).nameCountToUseStarImport(9999).importStaticAllOthers().blankLine().importAllOthers().blankLine().build();
            if (importLayoutStyle == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.style.Style");
            }
            JavaParser javaParser = jp.styles((Iterable)CollectionsKt.listOf((Object)new NamedStyles(Tree.randomId(), "custom", "custom style", null, SetsKt.emptySet(), (Collection)CollectionsKt.listOf((Object)((Style)importLayoutStyle))))).build();
            Intrinsics.checkNotNullExpressionValue((Object)javaParser, (String)"jp.styles(\n            l\u2026      )\n        ).build()");
            JavaRecipeTest.DefaultImpls.assertChanged$default(javaRecipeTest, javaParser, null, null, "\n            import java.util.List;\n            import static java.util.Collections.singletonList;\n            class Test {\n            }\n        ", null, "\n            import static java.util.Collections.singletonList;\n            \n            import java.util.List;\n            \n            class Test {\n            }\n        ", 0, 0, null, null, 982, null);
        }

        @Test
        public static void groupImportsIsAwareOfNestedClasses(@NotNull OrderImportsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, null, null, "\n            import org.openrewrite.java.J.CompilationUnit;\n            import org.openrewrite.java.J;\n            import org.openrewrite.java.JavaVisitor;\n            import org.openrewrite.java.JavaPrinter;\n            import org.openrewrite.java.ChangeMethodName;\n            import org.openrewrite.java.ChangeType;\n        ", null, "\n            import org.openrewrite.java.*;\n            import org.openrewrite.java.J.CompilationUnit;\n        ", 0, 0, null, null, 982, null);
        }

        @Test
        public static void detectBlockPattern(@NotNull OrderImportsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, jp, null, null, "\n            // org.slf4j should be detected as a block pattern, and not be moved to all other imports.\n            import org.slf4j.Logger;\n            import org.slf4j.LoggerFactory;\n            \n            import java.util.Arrays;\n            import java.util.List;\n            \n            public class C {\n            }\n        ", null, 22, null);
        }

        @Test
        public static void doNotFoldImports(@NotNull OrderImportsTest this_, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            JavaRecipeTest javaRecipeTest = this_;
            ImportLayoutStyle importLayoutStyle = ImportLayoutStyle.builder().classCountToUseStarImport(Integer.MAX_VALUE).nameCountToUseStarImport(Integer.MAX_VALUE).importPackage("java.*").blankLine().importPackage("javax.*").blankLine().importAllOthers().blankLine().importStaticAllOthers().build();
            if (importLayoutStyle == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.style.Style");
            }
            JavaParser javaParser = jp.styles((Iterable)CollectionsKt.listOf((Object)new NamedStyles(Tree.randomId(), "custom", "custom style", null, SetsKt.emptySet(), (Collection)CollectionsKt.listOf((Object)((Style)importLayoutStyle))))).build();
            Intrinsics.checkNotNullExpressionValue((Object)javaParser, (String)"jp.styles(\n            l\u2026      )\n        ).build()");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(javaRecipeTest, javaParser, null, null, "\n            import java.util.ArrayList;\n            import java.util.Collections;\n            import java.util.HashSet;\n            import java.util.List;\n            import java.util.Set;\n            \n            import javax.persistence.Entity;\n            import javax.persistence.FetchType;\n            import javax.persistence.JoinColumn;\n            import javax.persistence.JoinTable;\n            import javax.persistence.ManyToMany;\n            import javax.persistence.Table;\n            \n            public class C {\n            }\n        ", null, 22, null);
        }

        @Test
        public static void orderAndDoNotFoldStaticClasses(@NotNull OrderImportsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, (Recipe)new OrderImports(Boolean.valueOf(false)), null, "\n            import static org.openrewrite.java.J.CompilationUnit.*;\n            import static org.openrewrite.java.J.ClassDeclaration.*;\n            import static org.openrewrite.java.J.MethodInvocation.*;\n            import static org.openrewrite.java.J.MethodDeclaration.*;\n            import static org.openrewrite.java.J.If.*;\n        ", null, "\n            import static org.openrewrite.java.J.ClassDeclaration.*;\n            import static org.openrewrite.java.J.CompilationUnit.*;\n            import static org.openrewrite.java.J.If.*;\n            import static org.openrewrite.java.J.MethodDeclaration.*;\n            import static org.openrewrite.java.J.MethodInvocation.*;\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void orderAndDoNotFoldImports(@NotNull OrderImportsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, null, null, "\n            import java.aws.List;\n            import java.awt.Panel;\n            import java.util.Collection;\n            import java.util.List;\n            import java.awt.Point;\n            import java.awt.Robot;\n            import java.util.TreeMap;\n            import java.util.Map;\n            import java.util.Set;\n            import java.awt.Polygon;\n        ", null, "\n            import java.aws.List;\n            import java.awt.Panel;\n            import java.awt.Point;\n            import java.awt.Polygon;\n            import java.awt.Robot;\n            import java.util.Collection;\n            import java.util.List;\n            import java.util.Map;\n            import java.util.Set;\n            import java.util.TreeMap;\n        ", 0, 0, null, null, 982, null);
        }

        /*
         * WARNING - void declaration
         */
        @Test
        public static void doNotFoldPackageWithJavaLangClassNames(@NotNull OrderImportsTest this_, @NotNull JavaParser jp) {
            void $this$doNotFoldPackageWithJavaLangClassNames_u24lambda_u2d0;
            ExecutionContext executionContext;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            ExecutionContext executionContext2 = executionContext = this_.getExecutionContext();
            Recipe recipe2 = (Recipe)new OrderImports(Boolean.valueOf(false));
            JavaParser javaParser = jp;
            JavaRecipeTest javaRecipeTest = this_;
            boolean bl = false;
            $this$doNotFoldPackageWithJavaLangClassNames_u24lambda_u2d0.putMessage("org.openrewrite.java.skipSourceSetTypeGeneration", (Object)false);
            Unit unit = Unit.INSTANCE;
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(javaRecipeTest, javaParser, recipe2, executionContext, "\n            import kotlin.DeepRecursiveFunction;\n            import kotlin.Function;\n            import kotlin.Lazy;\n            import kotlin.Pair;\n            import kotlin.String;\n        ", null, 16, null);
        }

        @Test
        public static void foldPackageWithExistingImports(@NotNull OrderImportsTest this_) {
            JavaRecipeTest javaRecipeTest = this_;
            JavaParser javaParser = JavaParser.fromJavaVersion().styles((Iterable)CollectionsKt.listOf((Object)new NamedStyles(Tree.randomId(), "test", "test", "test", SetsKt.emptySet(), (Collection)CollectionsKt.listOf((Object)ImportLayoutStyle.builder().packageToFold("java.util.*", Boolean.valueOf(false)).importAllOthers().importStaticAllOthers().build())))).build();
            Intrinsics.checkNotNullExpressionValue((Object)javaParser, (String)"fromJavaVersion().styles\u2026      )\n        ).build()");
            JavaRecipeTest.DefaultImpls.assertChanged$default(javaRecipeTest, javaParser, (Recipe)new OrderImports(Boolean.valueOf(false)), null, "\n            import java.util.List;\n        ", null, "\n            import java.util.*;\n        ", 0, 0, null, null, 980, null);
        }

        @NotNull
        public static JavaParser getParser(@NotNull OrderImportsTest this_) {
            return JavaRecipeTest.DefaultImpls.getParser(this_);
        }

        @NotNull
        public static ExecutionContext getExecutionContext(@NotNull OrderImportsTest this_) {
            return JavaRecipeTest.DefaultImpls.getExecutionContext(this_);
        }

        @BeforeEach
        public static void beforeRecipe(@NotNull OrderImportsTest this_) {
            JavaRecipeTest.DefaultImpls.beforeRecipe(this_);
        }

        @AfterEach
        public static void afterRecipe(@NotNull OrderImportsTest this_) {
            JavaRecipeTest.DefaultImpls.afterRecipe(this_);
        }

        public static void assertChanged(@NotNull OrderImportsTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super TypeValidator.ValidationOptions.Companion.Builder, Unit> typeValidation, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(typeValidation, (String)"typeValidation");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged(this_, parser, recipe2, executionContext, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, typeValidation, afterConditions);
        }

        public static void assertChanged(@NotNull OrderImportsTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull File before, @Nullable Path relativeTo, @Language(value="java") @NotNull File[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super TypeValidator.ValidationOptions.Companion.Builder, Unit> typeValidation, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(typeValidation, (String)"typeValidation");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged(this_, parser, recipe2, executionContext, before, relativeTo, dependsOn, after, cycles, expectedCyclesThatMakeChanges, typeValidation, afterConditions);
        }

        public static void assertUnchanged(@NotNull OrderImportsTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, parser, recipe2, executionContext, before, dependsOn);
        }

        public static void assertUnchanged(@NotNull OrderImportsTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull File before, @Nullable Path relativeTo, @Language(value="java") @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, parser, recipe2, executionContext, before, relativeTo, dependsOn);
        }

        public static void assertChangedBase(@NotNull OrderImportsTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull File before, @Nullable Path relativeTo, @NotNull File[] dependsOn, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase(this_, parser, recipe2, executionContext, before, relativeTo, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertChangedBase(@NotNull OrderImportsTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull String before, @NotNull String[] dependsOn, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase(this_, parser, recipe2, executionContext, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertUnchangedBase(@NotNull OrderImportsTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull File before, @Nullable Path relativeTo, @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchangedBase(this_, parser, recipe2, executionContext, before, relativeTo, dependsOn);
        }

        public static void assertUnchangedBase(@NotNull OrderImportsTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull String before, @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchangedBase(this_, parser, recipe2, executionContext, before, dependsOn);
        }

        @NotNull
        public static Recipe fromRuntimeClasspath(@NotNull OrderImportsTest this_, @NotNull String recipe2) {
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            return JavaRecipeTest.DefaultImpls.fromRuntimeClasspath(this_, recipe2);
        }

        @NotNull
        public static Recipe toRecipe(@NotNull OrderImportsTest this_, @NotNull Function0<? extends TreeVisitor<?, ExecutionContext>> supplier) {
            Intrinsics.checkNotNullParameter(supplier, (String)"supplier");
            return JavaRecipeTest.DefaultImpls.toRecipe(this_, supplier);
        }
    }
}

