/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.List;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b(\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0012\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0013\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0014\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0015\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0016\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0017\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0018\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0019\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u001a\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u001b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u001c\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u001d\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u001e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u001f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010 \u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010!\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\"\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010#\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010$\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010%\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010&\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010'\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010(\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010)\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010*\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010+\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010,\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010-\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010.\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010/\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u00100\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0014\u00101\u001a\u000202*\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u00063"}, d2={"Lorg/openrewrite/java/MethodMatcherTest;", "", "argRegex", "Lkotlin/text/Regex;", "signature", "", "arrayExample", "", "jp", "Lorg/openrewrite/java/JavaParser;", "dotDotMatchesArrayArgs", "matchUnknownTypesExplicitPackageWildcardReceiverType", "matchUnknownTypesFullWildcardReceiverType", "matchUnknownTypesNoSelect", "matchUnknownTypesPackageQualifiedStaticMethod", "matchUnknownTypesQualifiedStaticMethod", "matchUnknownTypesRejectsMismatchedMethodName", "matchUnknownTypesRejectsMismatchingKnownArgument", "matchUnknownTypesRejectsStaticSelectMismatch", "matchUnknownTypesRejectsTooFewArguments", "matchUnknownTypesRejectsTooManyArguments", "matchUnknownTypesSingleWildcardArgument", "matchUnknownTypesWildcardArguments", "matchUnknownTypesWildcardReceiverType", "matcherForUnknownType", "matchesArguments", "matchesArgumentsWithDotDot", "matchesArgumentsWithWildcards", "matchesArrayArguments", "matchesConstructorAsExpressionUsage", "matchesConstructorUsage", "matchesMethod", "matchesMethodName", "matchesMethodNameWithDotSeparator", "matchesMethodNameWithPoundSeparator", "matchesMethodSymbolsWithVarargs", "matchesMethodTargetType", "matchesMethodWithWildcardForClassInPackage", "matchesMethodWithWildcardForClassNotInPackage", "matchesPrimitiveArgument", "matchesSuperclassTypeOfClasses", "matchesSuperclassTypeOfInterfaces", "matchesUnqualifiedJavaLangArguments", "matchesWildcardedMethodNameStartingWithJavaKeyword", "nameRegex", "siteExample", "strictMatchMethodOverride", "typeRegex", "wildcardType", "asMethodInvocation", "Lorg/openrewrite/java/tree/J$MethodInvocation;", "rewrite-java-tck"})
public interface MethodMatcherTest {
    @NotNull
    public Regex typeRegex(@NotNull String var1);

    @NotNull
    public Regex nameRegex(@NotNull String var1);

    @NotNull
    public Regex argRegex(@NotNull String var1);

    @Test
    public void matchesSuperclassTypeOfInterfaces(@NotNull JavaParser var1);

    @Test
    public void matchesSuperclassTypeOfClasses(@NotNull JavaParser var1);

    @Test
    public void matchesMethodTargetType(@NotNull JavaParser var1);

    @Test
    public void matchesMethodNameWithDotSeparator(@NotNull JavaParser var1);

    @Test
    public void matchesMethodNameWithPoundSeparator(@NotNull JavaParser var1);

    @Test
    public void matchesMethodName(@NotNull JavaParser var1);

    @Test
    public void matchesArguments(@NotNull JavaParser var1);

    @Test
    public void matchesUnqualifiedJavaLangArguments(@NotNull JavaParser var1);

    @Test
    public void matchesArgumentsWithWildcards(@NotNull JavaParser var1);

    @Test
    public void matchesArgumentsWithDotDot(@NotNull JavaParser var1);

    @Test
    public void matchesMethodSymbolsWithVarargs(@NotNull JavaParser var1);

    @Test
    public void dotDotMatchesArrayArgs(@NotNull JavaParser var1);

    @Test
    public void matchesArrayArguments(@NotNull JavaParser var1);

    @Test
    public void matchesPrimitiveArgument(@NotNull JavaParser var1);

    @Test
    public void matchesConstructorUsage(@NotNull JavaParser var1);

    @Test
    public void matchesConstructorAsExpressionUsage(@NotNull JavaParser var1);

    @Test
    public void matchesMethod(@NotNull JavaParser var1);

    @Test
    public void strictMatchMethodOverride(@NotNull JavaParser var1);

    @Test
    public void matchesMethodWithWildcardForClassInPackage(@NotNull JavaParser var1);

    @Test
    public void matchesMethodWithWildcardForClassNotInPackage(@NotNull JavaParser var1);

    @Test
    public void matchesWildcardedMethodNameStartingWithJavaKeyword(@NotNull JavaParser var1);

    @Test
    public void wildcardType(@NotNull JavaParser var1);

    @Test
    public void siteExample(@NotNull JavaParser var1);

    @Test
    public void matchUnknownTypesNoSelect(@NotNull JavaParser var1);

    @Test
    public void matchUnknownTypesQualifiedStaticMethod(@NotNull JavaParser var1);

    @Test
    public void matchUnknownTypesPackageQualifiedStaticMethod(@NotNull JavaParser var1);

    @Test
    public void matchUnknownTypesWildcardReceiverType(@NotNull JavaParser var1);

    @Test
    public void matchUnknownTypesFullWildcardReceiverType(@NotNull JavaParser var1);

    @Test
    public void matchUnknownTypesExplicitPackageWildcardReceiverType(@NotNull JavaParser var1);

    @Test
    public void matchUnknownTypesRejectsMismatchedMethodName(@NotNull JavaParser var1);

    @Test
    public void matchUnknownTypesRejectsStaticSelectMismatch(@NotNull JavaParser var1);

    @Test
    public void matchUnknownTypesRejectsTooManyArguments(@NotNull JavaParser var1);

    @Test
    public void matchUnknownTypesRejectsTooFewArguments(@NotNull JavaParser var1);

    @Test
    public void matchUnknownTypesRejectsMismatchingKnownArgument(@NotNull JavaParser var1);

    @Test
    public void matchUnknownTypesWildcardArguments(@NotNull JavaParser var1);

    @Test
    public void matchUnknownTypesSingleWildcardArgument(@NotNull JavaParser var1);

    @NotNull
    public J.MethodInvocation asMethodInvocation(@NotNull String var1, @NotNull JavaParser var2);

    @Test
    public void arrayExample(@NotNull JavaParser var1);

    @Test
    public void matcherForUnknownType(@NotNull JavaParser var1);

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @NotNull
        public static Regex typeRegex(@NotNull MethodMatcherTest this_, @NotNull String signature) {
            Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
            Pattern pattern = new MethodMatcher(signature).getTargetTypePattern();
            Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"MethodMatcher(signature).targetTypePattern");
            Pattern pattern2 = pattern;
            return new Regex(pattern2);
        }

        @NotNull
        public static Regex nameRegex(@NotNull MethodMatcherTest this_, @NotNull String signature) {
            Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
            Pattern pattern = new MethodMatcher(signature).getMethodNamePattern();
            Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"MethodMatcher(signature).methodNamePattern");
            Pattern pattern2 = pattern;
            return new Regex(pattern2);
        }

        @NotNull
        public static Regex argRegex(@NotNull MethodMatcherTest this_, @NotNull String signature) {
            Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
            Pattern pattern = new MethodMatcher(signature).getArgumentPattern();
            Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"MethodMatcher(signature).argumentPattern");
            Pattern pattern2 = pattern;
            return new Regex(pattern2);
        }

        @Test
        public static void matchesSuperclassTypeOfInterfaces(@NotNull MethodMatcherTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"class Test { java.util.List l; }"};
            Object e = ((J.ClassDeclaration)((J.CompilationUnit)jp.parse(stringArray).get(0)).getClasses().get(0)).getBody().getStatements().get(0);
            if (e == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDeclarations");
            }
            JavaType.FullyQualified listType = ((J.VariableDeclarations)e).getTypeAsFullyQualified();
            Assertions.assertTrue((boolean)new MethodMatcher("java.util.Collection size()", true).matchesTargetType(listType));
            Assertions.assertFalse((boolean)new MethodMatcher("java.util.Collection size()").matchesTargetType(listType));
            Assertions.assertFalse((boolean)new MethodMatcher("java.util.List size()", true).matchesTargetType((JavaType.FullyQualified)JavaType.ShallowClass.build((String)"java.util.Collection")));
            Assertions.assertFalse((boolean)new MethodMatcher("java.util.List size()").matchesTargetType((JavaType.FullyQualified)JavaType.ShallowClass.build((String)"java.util.Collection")));
        }

        @Test
        public static void matchesSuperclassTypeOfClasses(@NotNull MethodMatcherTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Assertions.assertTrue((boolean)new MethodMatcher("Object equals(Object)", true).matchesTargetType((JavaType.FullyQualified)JavaType.ShallowClass.build((String)"java.lang.String")));
            Assertions.assertFalse((boolean)new MethodMatcher("Object equals(Object)").matchesTargetType((JavaType.FullyQualified)JavaType.ShallowClass.build((String)"java.lang.String")));
            Assertions.assertFalse((boolean)new MethodMatcher("String equals(String)", true).matchesTargetType((JavaType.FullyQualified)JavaType.ShallowClass.build((String)"java.lang.Object")));
            Assertions.assertFalse((boolean)new MethodMatcher("String equals(String)").matchesTargetType((JavaType.FullyQualified)JavaType.ShallowClass.build((String)"java.lang.Object")));
        }

        @Test
        public static void matchesMethodTargetType(@NotNull MethodMatcherTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Assertions.assertTrue((boolean)this_.typeRegex("*..MyClass foo()").matches((CharSequence)"com.bar.MyClass"));
            Assertions.assertTrue((boolean)this_.typeRegex("MyClass foo()").matches((CharSequence)"MyClass"));
            Assertions.assertTrue((boolean)this_.typeRegex("com.bar.MyClass foo()").matches((CharSequence)"com.bar.MyClass"));
            Assertions.assertTrue((boolean)this_.typeRegex("com.*.MyClass foo()").matches((CharSequence)"com.bar.MyClass"));
        }

        @Test
        public static void matchesMethodNameWithDotSeparator(@NotNull MethodMatcherTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Assertions.assertTrue((boolean)this_.nameRegex("A.foo()").matches((CharSequence)"foo"));
            Assertions.assertTrue((boolean)this_.nameRegex("A.*()").matches((CharSequence)"foo"));
            Assertions.assertTrue((boolean)this_.nameRegex("A.fo*()").matches((CharSequence)"foo"));
        }

        @Test
        public static void matchesMethodNameWithPoundSeparator(@NotNull MethodMatcherTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Assertions.assertTrue((boolean)this_.nameRegex("A#foo()").matches((CharSequence)"foo"));
            Assertions.assertTrue((boolean)this_.nameRegex("A#*()").matches((CharSequence)"foo"));
            Assertions.assertTrue((boolean)this_.nameRegex("A#fo*()").matches((CharSequence)"foo"));
            Assertions.assertTrue((boolean)this_.nameRegex("A#*oo()").matches((CharSequence)"foo"));
        }

        @Test
        public static void matchesMethodName(@NotNull MethodMatcherTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Assertions.assertTrue((boolean)this_.nameRegex("A foo()").matches((CharSequence)"foo"));
            Assertions.assertTrue((boolean)this_.nameRegex("A *()").matches((CharSequence)"foo"));
            Assertions.assertTrue((boolean)this_.nameRegex("A fo*()").matches((CharSequence)"foo"));
            Assertions.assertTrue((boolean)this_.nameRegex("A *oo()").matches((CharSequence)"foo"));
        }

        @Test
        public static void matchesArguments(@NotNull MethodMatcherTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Assertions.assertTrue((boolean)this_.argRegex("A foo()").matches((CharSequence)""));
            Assertions.assertTrue((boolean)this_.argRegex("A foo(int)").matches((CharSequence)"int"));
            Assertions.assertTrue((boolean)this_.argRegex("A foo(java.util.Map)").matches((CharSequence)"java.util.Map"));
        }

        @Test
        public static void matchesUnqualifiedJavaLangArguments(@NotNull MethodMatcherTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Assertions.assertTrue((boolean)this_.argRegex("A foo(String)").matches((CharSequence)"java.lang.String"));
        }

        @Test
        public static void matchesArgumentsWithWildcards(@NotNull MethodMatcherTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Assertions.assertTrue((boolean)this_.argRegex("A foo(java.util.*)").matches((CharSequence)"java.util.Map"));
            Assertions.assertTrue((boolean)this_.argRegex("A foo(java..*)").matches((CharSequence)"java.util.Map"));
        }

        @Test
        public static void matchesArgumentsWithDotDot(@NotNull MethodMatcherTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Assertions.assertTrue((boolean)this_.argRegex("A foo(.., int)").matches((CharSequence)"int"));
            Assertions.assertTrue((boolean)this_.argRegex("A foo(.., int)").matches((CharSequence)"int,int"));
            Assertions.assertTrue((boolean)this_.argRegex("A foo(int, ..)").matches((CharSequence)"int"));
            Assertions.assertTrue((boolean)this_.argRegex("A foo(int, ..)").matches((CharSequence)"int,int"));
            Assertions.assertTrue((boolean)this_.argRegex("A foo(..)").matches((CharSequence)""));
            Assertions.assertTrue((boolean)this_.argRegex("A foo(..)").matches((CharSequence)"int"));
            Assertions.assertTrue((boolean)this_.argRegex("A foo(..)").matches((CharSequence)"int,int"));
        }

        @Test
        public static void matchesMethodSymbolsWithVarargs(@NotNull MethodMatcherTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            this_.argRegex("A foo(String, Object...)").matches((CharSequence)"String,Object[]");
        }

        @Test
        public static void dotDotMatchesArrayArgs(@NotNull MethodMatcherTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            this_.argRegex("A foo(..)").matches((CharSequence)"String,Object[]");
        }

        @Test
        public static void matchesArrayArguments(@NotNull MethodMatcherTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Assertions.assertTrue((boolean)this_.argRegex("A foo(String[])").matches((CharSequence)"java.lang.String[]"));
        }

        @Test
        public static void matchesPrimitiveArgument(@NotNull MethodMatcherTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Assertions.assertTrue((boolean)this_.argRegex("A foo(int)").matches((CharSequence)"int"));
            Assertions.assertTrue((boolean)this_.argRegex("A foo(int[])").matches((CharSequence)"int[]"));
            Assertions.assertFalse((boolean)this_.argRegex("A foo(int[])").matches((CharSequence)"int"));
        }

        @Test
        public static void matchesConstructorUsage(@NotNull MethodMatcherTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"package a;\nclass A {\n    A a = new A();\n}"};
            J.CompilationUnit cu = (J.CompilationUnit)jp.parse(stringArray).get(0);
            MethodMatcher methodMatcher = new MethodMatcher("a.A <constructor>()");
            List list = cu.getClasses();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"cu.classes");
            List list2 = ((J.ClassDeclaration)CollectionsKt.first((List)list)).getBody().getStatements();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"cu.classes.first().body.statements");
            Object object = CollectionsKt.first((List)list2);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDeclarations");
            }
            List list3 = ((J.VariableDeclarations)object).getVariables();
            Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"cu.classes.first().body.\u2026               .variables");
            Expression expression = ((J.VariableDeclarations.NamedVariable)CollectionsKt.first((List)list3)).getInitializer();
            if (expression == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.NewClass");
            }
            Assertions.assertTrue((boolean)methodMatcher.matches((J.NewClass)expression));
        }

        @Test
        public static void matchesConstructorAsExpressionUsage(@NotNull MethodMatcherTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Object object = new String[]{"package a;\nclass A {\n    A a = new A();\n}"};
            J.CompilationUnit cu = (J.CompilationUnit)jp.parse(object).get(0);
            MethodMatcher methodMatcher = new MethodMatcher("a.A <constructor>()");
            List list = cu.getClasses();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"cu.classes");
            List list2 = ((J.ClassDeclaration)CollectionsKt.first((List)list)).getBody().getStatements();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"cu.classes.first().body.statements");
            Object object2 = CollectionsKt.first((List)list2);
            if (object2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDeclarations");
            }
            object = ((J.VariableDeclarations)object2).getVariables();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"cu.classes.first().body.\u2026               .variables");
            Expression expression = ((J.VariableDeclarations.NamedVariable)CollectionsKt.first((List)object)).getInitializer();
            Intrinsics.checkNotNull((Object)expression);
            Assertions.assertTrue((boolean)methodMatcher.matches(expression));
            MethodMatcher methodMatcher2 = new MethodMatcher("a.A *()");
            List list3 = cu.getClasses();
            Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"cu.classes");
            List list4 = ((J.ClassDeclaration)CollectionsKt.first((List)list3)).getBody().getStatements();
            Intrinsics.checkNotNullExpressionValue((Object)list4, (String)"cu.classes.first().body.statements");
            Object object3 = CollectionsKt.first((List)list4);
            if (object3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDeclarations");
            }
            object = ((J.VariableDeclarations)object3).getVariables();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"cu.classes.first().body.\u2026               .variables");
            Expression expression2 = ((J.VariableDeclarations.NamedVariable)CollectionsKt.first((List)object)).getInitializer();
            Intrinsics.checkNotNull((Object)expression2);
            Assertions.assertTrue((boolean)methodMatcher2.matches(expression2));
        }

        @Test
        public static void matchesMethod(@NotNull MethodMatcherTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"package a;\n\nclass A {\n    void setInt(int value) {}\n    int getInt() {}\n    void setInteger(Integer value) {}\n    Integer getInteger(){}\n}"};
            List list = jp.parse(stringArray);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"jp.parse(\n            \"\"\u2026\"\".trimIndent()\n        )");
            J.CompilationUnit cu = (J.CompilationUnit)CollectionsKt.first((List)list);
            List list2 = cu.getClasses();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"cu.classes");
            J.ClassDeclaration classDecl2 = (J.ClassDeclaration)CollectionsKt.first((List)list2);
            Object e = classDecl2.getBody().getStatements().get(0);
            if (e == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.MethodDeclaration setIntMethod = (J.MethodDeclaration)e;
            Object e2 = classDecl2.getBody().getStatements().get(1);
            if (e2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.MethodDeclaration getIntMethod = (J.MethodDeclaration)e2;
            Object e3 = classDecl2.getBody().getStatements().get(2);
            if (e3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.MethodDeclaration setIntegerMethod = (J.MethodDeclaration)e3;
            Object e4 = classDecl2.getBody().getStatements().get(3);
            if (e4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.MethodDeclaration getIntegerMethod = (J.MethodDeclaration)e4;
            Assertions.assertTrue((boolean)new MethodMatcher("a.A setInt(int)").matches(setIntMethod, classDecl2));
            Assertions.assertTrue((boolean)new MethodMatcher("a.A getInt()").matches(getIntMethod, classDecl2));
            Assertions.assertTrue((boolean)new MethodMatcher("a.A setInteger(Integer)").matches(setIntegerMethod, classDecl2));
            Assertions.assertTrue((boolean)new MethodMatcher("a.A getInteger()").matches(getIntegerMethod, classDecl2));
        }

        @Test
        public static void strictMatchMethodOverride(@NotNull MethodMatcherTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"\n                package com.abc;\n\n                class Parent {\n                    public void method(String s) {\n                    }\n\n                    @Override\n                    public String toString() {\n                        return \"empty\";\n                    }\n                }\n\n                class Test extends Parent {\n                    @Override\n                    public void method(String s) {\n                    }\n                }\n        "};
            List list = jp.parse(stringArray);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"jp.parse(\n            \"\"\u2026  }\n        \"\"\"\n        )");
            J.CompilationUnit cu = (J.CompilationUnit)CollectionsKt.first((List)list);
            Object e = ((J.ClassDeclaration)cu.getClasses().get(0)).getBody().getStatements().get(0);
            if (e == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            JavaType.Method parentMethodDefinition = ((J.MethodDeclaration)e).getMethodType();
            Object e2 = ((J.ClassDeclaration)cu.getClasses().get(1)).getBody().getStatements().get(0);
            if (e2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            JavaType.Method childMethodOverride = ((J.MethodDeclaration)e2).getMethodType();
            Assertions.assertFalse((boolean)new MethodMatcher("com.abc.Parent method(String)", false).matches(childMethodOverride));
            Assertions.assertTrue((boolean)new MethodMatcher("com.abc.Parent method(String)", true).matches(parentMethodDefinition));
            Assertions.assertTrue((boolean)new MethodMatcher("com.abc.Parent method(String)", true).matches(childMethodOverride));
            Assertions.assertTrue((boolean)new MethodMatcher("com.abc.Parent method(String)", false).matches(parentMethodDefinition));
            Assertions.assertFalse((boolean)new MethodMatcher("com.abc.Test method(String)", true).matches(parentMethodDefinition));
            Object e3 = ((J.ClassDeclaration)cu.getClasses().get(0)).getBody().getStatements().get(1);
            if (e3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            JavaType.Method parentToStringDefinition = ((J.MethodDeclaration)e3).getMethodType();
            Assertions.assertTrue((boolean)new MethodMatcher("com.abc.Parent toString()", true).matches(parentToStringDefinition));
            Assertions.assertTrue((boolean)new MethodMatcher("java.lang.Object toString()", true).matches(parentToStringDefinition));
            Assertions.assertFalse((boolean)new MethodMatcher("java.lang.Object toString()", false).matches(parentToStringDefinition));
        }

        @Test
        public static void matchesMethodWithWildcardForClassInPackage(@NotNull MethodMatcherTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"\n            package a;\n\n            class A {\n                void foo() {}\n            }\n        "};
            List list = jp.parse(stringArray);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"jp.parse(\n            \"\"\u2026  }\n        \"\"\"\n        )");
            J.CompilationUnit cu = (J.CompilationUnit)CollectionsKt.first((List)list);
            List list2 = cu.getClasses();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"cu.classes");
            J.ClassDeclaration classDecl2 = (J.ClassDeclaration)CollectionsKt.first((List)list2);
            Object e = classDecl2.getBody().getStatements().get(0);
            if (e == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.MethodDeclaration fooMethod = (J.MethodDeclaration)e;
            Assertions.assertTrue((boolean)new MethodMatcher("* foo(..)").matches(fooMethod, classDecl2));
        }

        @Test
        public static void matchesMethodWithWildcardForClassNotInPackage(@NotNull MethodMatcherTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"\n            class A {\n                void foo() {}\n            }\n        "};
            List list = jp.parse(stringArray);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"jp.parse(\n            \"\"\u2026  }\n        \"\"\"\n        )");
            J.CompilationUnit cu = (J.CompilationUnit)CollectionsKt.first((List)list);
            List list2 = cu.getClasses();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"cu.classes");
            J.ClassDeclaration classDecl2 = (J.ClassDeclaration)CollectionsKt.first((List)list2);
            Object e = classDecl2.getBody().getStatements().get(0);
            if (e == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.MethodDeclaration fooMethod = (J.MethodDeclaration)e;
            Assertions.assertTrue((boolean)new MethodMatcher("* foo(..)").matches(fooMethod, classDecl2));
        }

        @Test
        public static void matchesWildcardedMethodNameStartingWithJavaKeyword(@NotNull MethodMatcherTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Assertions.assertTrue((boolean)this_.nameRegex("A assert*()").matches((CharSequence)"assertThat"));
        }

        @Test
        public static void wildcardType(@NotNull MethodMatcherTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Assertions.assertTrue((boolean)new MethodMatcher("*..* build()").matchesTargetType((JavaType.FullyQualified)JavaType.ShallowClass.build((String)"javax.ws.rs.core.Response")));
            Assertions.assertTrue((boolean)new MethodMatcher("javax..* build()").matchesTargetType((JavaType.FullyQualified)JavaType.ShallowClass.build((String)"javax.ws.rs.core.Response")));
        }

        @Test
        public static void siteExample(@NotNull MethodMatcherTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"\n            package com.yourorg;\n\n            class Foo {\n                void bar(int i, String s) {}\n                void other() {\n                    bar(0, \"\");\n                }\n            }\n        "};
            List list = jp.parse(stringArray);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"jp.parse(\n            \"\"\u2026  }\n        \"\"\"\n        )");
            J.CompilationUnit cu = (J.CompilationUnit)CollectionsKt.first((List)list);
            List list2 = cu.getClasses();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"cu.classes");
            J.ClassDeclaration classDecl2 = (J.ClassDeclaration)CollectionsKt.first((List)list2);
            Object e = classDecl2.getBody().getStatements().get(1);
            if (e == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.MethodDeclaration methodDecl = (J.MethodDeclaration)e;
            J.Block block2 = methodDecl.getBody();
            Intrinsics.checkNotNull((Object)block2);
            Object e2 = block2.getStatements().get(0);
            if (e2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodInvocation");
            }
            J.MethodInvocation fooMethod = (J.MethodInvocation)e2;
            Assertions.assertTrue((boolean)new MethodMatcher("com.yourorg.Foo bar(int, String)").matches(fooMethod));
        }

        @Test
        public static void matchUnknownTypesNoSelect(@NotNull MethodMatcherTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            J.MethodInvocation mi = this_.asMethodInvocation("assertTrue(Foo.bar());", jp);
            Assertions.assertTrue((boolean)new MethodMatcher("org.junit.Assert assertTrue(boolean)").matches(mi, true));
        }

        @Test
        public static void matchUnknownTypesQualifiedStaticMethod(@NotNull MethodMatcherTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            J.MethodInvocation mi = this_.asMethodInvocation("Assert.assertTrue(Foo.bar());", jp);
            Assertions.assertTrue((boolean)new MethodMatcher("org.junit.Assert assertTrue(boolean)").matches(mi, true));
        }

        @Test
        public static void matchUnknownTypesPackageQualifiedStaticMethod(@NotNull MethodMatcherTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            J.MethodInvocation mi = this_.asMethodInvocation("org.junit.Assert.assertTrue(Foo.bar());", jp);
            Assertions.assertTrue((boolean)new MethodMatcher("org.junit.Assert assertTrue(boolean)").matches(mi, true));
        }

        @Test
        public static void matchUnknownTypesWildcardReceiverType(@NotNull MethodMatcherTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            J.MethodInvocation mi = this_.asMethodInvocation("Assert.assertTrue(Foo.bar());", jp);
            Assertions.assertTrue((boolean)new MethodMatcher("*..* assertTrue(boolean)").matches(mi, true));
        }

        @Test
        public static void matchUnknownTypesFullWildcardReceiverType(@NotNull MethodMatcherTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            J.MethodInvocation mi = this_.asMethodInvocation("Assert.assertTrue(Foo.bar());", jp);
            Assertions.assertTrue((boolean)new MethodMatcher("* assertTrue(boolean)").matches(mi, true));
        }

        @Test
        public static void matchUnknownTypesExplicitPackageWildcardReceiverType(@NotNull MethodMatcherTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            J.MethodInvocation mi = this_.asMethodInvocation("Assert.assertTrue(Foo.bar());", jp);
            Assertions.assertTrue((boolean)new MethodMatcher("org.junit.* assertTrue(boolean)").matches(mi, true));
        }

        @Test
        public static void matchUnknownTypesRejectsMismatchedMethodName(@NotNull MethodMatcherTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            J.MethodInvocation mi = this_.asMethodInvocation("Assert.assertTrue(Foo.bar());", jp);
            Assertions.assertFalse((boolean)new MethodMatcher("org.junit.Assert assertFalse(boolean)").matches(mi, true));
        }

        @Test
        public static void matchUnknownTypesRejectsStaticSelectMismatch(@NotNull MethodMatcherTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            J.MethodInvocation mi = this_.asMethodInvocation("Assert.assertTrue(Foo.bar());", jp);
            Assertions.assertFalse((boolean)new MethodMatcher("org.junit.FooAssert assertTrue(boolean)").matches(mi, true));
        }

        @Test
        public static void matchUnknownTypesRejectsTooManyArguments(@NotNull MethodMatcherTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            J.MethodInvocation mi = this_.asMethodInvocation("Assert.assertTrue(Foo.bar(), \"message\");", jp);
            Assertions.assertFalse((boolean)new MethodMatcher("org.junit.Assert assertTrue(boolean)").matches(mi, true));
        }

        @Test
        public static void matchUnknownTypesRejectsTooFewArguments(@NotNull MethodMatcherTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            J.MethodInvocation mi = this_.asMethodInvocation("Assert.assertTrue(Foo.bar());", jp);
            Assertions.assertFalse((boolean)new MethodMatcher("org.junit.Assert assertTrue(boolean, String)").matches(mi, true));
        }

        @Test
        public static void matchUnknownTypesRejectsMismatchingKnownArgument(@NotNull MethodMatcherTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            J.MethodInvocation mi = this_.asMethodInvocation("Assert.assertTrue(Foo.bar(), \"message\");", jp);
            Assertions.assertFalse((boolean)new MethodMatcher("org.junit.Assert assertTrue(boolean, int)").matches(mi, true));
        }

        @Test
        public static void matchUnknownTypesWildcardArguments(@NotNull MethodMatcherTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            J.MethodInvocation mi = this_.asMethodInvocation("Assert.assertTrue(Foo.bar(), \"message\");", jp);
            Assertions.assertTrue((boolean)new MethodMatcher("org.junit.Assert assertTrue(..)").matches(mi, true));
        }

        @Test
        public static void matchUnknownTypesSingleWildcardArgument(@NotNull MethodMatcherTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            J.MethodInvocation mi = this_.asMethodInvocation("Assert.assertTrue(Foo.bar(), \"message\");", jp);
            Assertions.assertTrue((boolean)new MethodMatcher("org.junit.Assert assertTrue(*, String)").matches(mi, true));
        }

        @NotNull
        public static J.MethodInvocation asMethodInvocation(@NotNull MethodMatcherTest this_, @NotNull String receiver, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)receiver, (String)"receiver");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"\n                class MyTest {\n                    void test() {\n                        " + receiver + "\n                    }\n                }\n            "};
            List list = jp.parse(stringArray);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"jp.parse(\n            \"\"\u2026           \"\"\",\n        )");
            J.CompilationUnit cu = (J.CompilationUnit)CollectionsKt.first((List)list);
            List list2 = cu.getClasses();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"cu.classes");
            J.ClassDeclaration classDecl2 = (J.ClassDeclaration)CollectionsKt.first((List)list2);
            Object e = classDecl2.getBody().getStatements().get(0);
            if (e == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.MethodDeclaration testMethod = (J.MethodDeclaration)e;
            J.Block block2 = testMethod.getBody();
            Intrinsics.checkNotNull((Object)block2);
            Object e2 = block2.getStatements().get(0);
            if (e2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodInvocation");
            }
            return (J.MethodInvocation)e2;
        }

        @Test
        public static void arrayExample(@NotNull MethodMatcherTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"\n            package com.yourorg;\n\n            class Foo {\n                void bar(String[] s) {}\n            }\n        "};
            List list = jp.parse(stringArray);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"jp.parse(\n            \"\"\u2026  }\n        \"\"\"\n        )");
            J.CompilationUnit cu = (J.CompilationUnit)CollectionsKt.first((List)list);
            List list2 = cu.getClasses();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"cu.classes");
            J.ClassDeclaration classDecl2 = (J.ClassDeclaration)CollectionsKt.first((List)list2);
            Object e = classDecl2.getBody().getStatements().get(0);
            if (e == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.MethodDeclaration methodDecl = (J.MethodDeclaration)e;
            Assertions.assertEquals((Object)"MethodDeclaration{com.yourorg.Foo{name=bar,return=void,parameters=[java.lang.String[]]}}", (Object)methodDecl.toString());
            Assertions.assertTrue((boolean)new MethodMatcher("com.yourorg.Foo bar(String[])").matches(methodDecl, classDecl2));
        }

        @Test
        public static void matcherForUnknownType(@NotNull MethodMatcherTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"\n            class Test {\n                void foo(Unknown u) {}\n            }\n        "};
            List list = jp.parse(stringArray);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"jp.parse(\"\"\"\n           \u2026           }\n        \"\"\")");
            J.CompilationUnit cu = (J.CompilationUnit)CollectionsKt.first((List)list);
            Object e = ((J.ClassDeclaration)cu.getClasses().get(0)).getBody().getStatements().get(0);
            if (e == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.MethodDeclaration methodDecl = (J.MethodDeclaration)e;
            MethodMatcher matcher = new MethodMatcher(MethodMatcher.methodPattern((J.MethodDeclaration)methodDecl));
            Assertions.assertTrue((boolean)matcher.matches(methodDecl.getMethodType()));
        }
    }
}

