/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.io.File;
import java.nio.file.Path;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaRecipeTest;
import org.openrewrite.java.TypeValidator;
import org.openrewrite.java.cleanup.UseCollectionInterfaces;
import org.openrewrite.java.marker.JavaVersion;
import org.openrewrite.java.tree.J;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b#\bf\u0018\u00002\u00020\u0001J\b\u0010\u0006\u001a\u00020\u0007H\u0017J\b\u0010\b\u001a\u00020\u0007H\u0017J\b\u0010\t\u001a\u00020\u0007H\u0017J\b\u0010\n\u001a\u00020\u0007H\u0017J\b\u0010\u000b\u001a\u00020\u0007H\u0017J\b\u0010\f\u001a\u00020\u0007H\u0017J\b\u0010\r\u001a\u00020\u0007H\u0017J\b\u0010\u000e\u001a\u00020\u0007H\u0017J\b\u0010\u000f\u001a\u00020\u0007H\u0017J\b\u0010\u0010\u001a\u00020\u0007H\u0017J\b\u0010\u0011\u001a\u00020\u0007H\u0017J\b\u0010\u0012\u001a\u00020\u0007H\u0017J\b\u0010\u0013\u001a\u00020\u0007H\u0017J\b\u0010\u0014\u001a\u00020\u0007H\u0017J\b\u0010\u0015\u001a\u00020\u0007H\u0017J\b\u0010\u0016\u001a\u00020\u0007H\u0017J\b\u0010\u0017\u001a\u00020\u0007H\u0017J\b\u0010\u0018\u001a\u00020\u0007H\u0017J\b\u0010\u0019\u001a\u00020\u0007H\u0017J\b\u0010\u001a\u001a\u00020\u0007H\u0017J\b\u0010\u001b\u001a\u00020\u0007H\u0017J\b\u0010\u001c\u001a\u00020\u0007H\u0017J\b\u0010\u001d\u001a\u00020\u0007H\u0017J\b\u0010\u001e\u001a\u00020\u0007H\u0017J\b\u0010\u001f\u001a\u00020\u0007H\u0017J\b\u0010 \u001a\u00020\u0007H\u0017J\b\u0010!\u001a\u00020\u0007H\u0017J\b\u0010\"\u001a\u00020\u0007H\u0017J\b\u0010#\u001a\u00020\u0007H\u0017J\b\u0010$\u001a\u00020\u0007H\u0017J\b\u0010%\u001a\u00020\u0007H\u0017J\b\u0010&\u001a\u00020\u0007H\u0017J\b\u0010'\u001a\u00020\u0007H\u0017J\b\u0010(\u001a\u00020\u0007H\u0017J\b\u0010)\u001a\u00020\u0007H\u0017R\u0014\u0010\u0002\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006*"}, d2={"Lorg/openrewrite/java/cleanup/UseCollectionInterfacesTest;", "Lorg/openrewrite/java/JavaRecipeTest;", "recipe", "Lorg/openrewrite/Recipe;", "getRecipe", "()Lorg/openrewrite/Recipe;", "abstractList", "", "abstractMap", "abstractQueue", "abstractSequentialList", "abstractSet", "arrayDeque", "arrayList", "concurrentHashMap", "concurrentLinkedDeque", "concurrentLinkedQueue", "concurrentSkipListMap", "copyOnWriteArrayList", "copyOnWriteArraySet", "enumMap", "enumSet", "fieldIsAlreadyInterface", "hashMap", "hashSet", "hashtable", "identityHashMap", "linkedHashMap", "linkedHashSet", "noModifierOnMethod", "noModifierOnVariable", "noTargetInUse", "parameterizedFieldType", "parameterizedReturnType", "preserveParameters", "privateMethod", "privateVariable", "rawFieldType", "rawReturnType", "returnIsAlreadyInterface", "variableWithVar", "weakHashMap", "rewrite-java-tck"})
public interface UseCollectionInterfacesTest
extends JavaRecipeTest {
    @NotNull
    public Recipe getRecipe();

    @Test
    public void noTargetInUse();

    @Test
    public void returnIsAlreadyInterface();

    @Test
    public void rawReturnType();

    @Test
    public void parameterizedReturnType();

    @Test
    public void preserveParameters();

    @Test
    public void fieldIsAlreadyInterface();

    @Test
    public void rawFieldType();

    @Test
    public void parameterizedFieldType();

    @Test
    public void arrayDeque();

    @Test
    public void concurrentLinkedDeque();

    @Test
    public void abstractList();

    @Test
    public void abstractSequentialList();

    @Test
    public void arrayList();

    @Test
    public void copyOnWriteArrayList();

    @Test
    public void abstractMap();

    @Test
    public void enumMap();

    @Test
    public void hashMap();

    @Test
    public void hashtable();

    @Test
    public void identityHashMap();

    @Test
    public void linkedHashMap();

    @Test
    public void weakHashMap();

    @Test
    public void concurrentHashMap();

    @Test
    public void concurrentSkipListMap();

    @Test
    public void abstractQueue();

    @Test
    public void concurrentLinkedQueue();

    @Test
    public void abstractSet();

    @Test
    public void enumSet();

    @Test
    public void hashSet();

    @Test
    public void linkedHashSet();

    @Test
    public void copyOnWriteArraySet();

    @Test
    public void privateVariable();

    @Test
    public void noModifierOnVariable();

    @Test
    public void privateMethod();

    @Test
    public void noModifierOnMethod();

    @Test
    public void variableWithVar();

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @NotNull
        public static Recipe getRecipe(@NotNull UseCollectionInterfacesTest this_) {
            return (Recipe)new UseCollectionInterfaces();
        }

        @Test
        public static void noTargetInUse(@NotNull UseCollectionInterfacesTest this_) {
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, null, null, null, "\n            import java.util.Collections;\n            import java.util.Set;\n            \n            class Test {\n                Set<Integer> method() {\n                    return Collections.emptySet();\n                }\n            }\n        ", null, 23, null);
        }

        @Test
        public static void returnIsAlreadyInterface(@NotNull UseCollectionInterfacesTest this_) {
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, null, null, null, "\n            import java.util.HashSet;\n            import java.util.Set;\n            \n            class Test {\n                public Set<Integer> method() {\n                    return new HashSet<>();\n                }\n            }\n        ", null, 23, null);
        }

        @Test
        public static void rawReturnType(@NotNull UseCollectionInterfacesTest this_) {
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, null, "\n            import java.util.HashSet;\n            \n            class Test {\n                public HashSet method() {\n                    return new HashSet<>();\n                }\n            }\n        ", null, "\n            import java.util.HashSet;\n            import java.util.Set;\n            \n            class Test {\n                public Set method() {\n                    return new HashSet<>();\n                }\n            }\n        ", 0, 0, null, null, 983, null);
        }

        @Test
        public static void parameterizedReturnType(@NotNull UseCollectionInterfacesTest this_) {
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, null, "\n            import java.util.HashSet;\n            \n            class Test {\n                public HashSet<Integer> method() {\n                    return new HashSet<>();\n                }\n            }\n        ", null, "\n            import java.util.HashSet;\n            import java.util.Set;\n            \n            class Test {\n                public Set<Integer> method() {\n                    return new HashSet<>();\n                }\n            }\n        ", 0, 0, null, null, 983, null);
        }

        @Test
        public static void preserveParameters(@NotNull UseCollectionInterfacesTest this_) {
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, null, "\n            import java.util.HashSet;\n            \n            class Test {\n                public HashSet<Integer> method(int primitive, Integer integer) {\n                    return new HashSet<>();\n                }\n            }\n        ", null, "\n            import java.util.HashSet;\n            import java.util.Set;\n            \n            class Test {\n                public Set<Integer> method(int primitive, Integer integer) {\n                    return new HashSet<>();\n                }\n            }\n        ", 0, 0, null, null, 983, null);
        }

        @Test
        public static void fieldIsAlreadyInterface(@NotNull UseCollectionInterfacesTest this_) {
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, null, null, null, "\n            import java.util.HashSet;\n            import java.util.Set;\n            \n            class Test {\n                public Set<Integer> values = new HashSet<>();\n            }\n        ", null, 23, null);
        }

        @Test
        public static void rawFieldType(@NotNull UseCollectionInterfacesTest this_) {
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, null, "\n            import java.util.HashSet;\n            \n            class Test {\n                public HashSet values = new HashSet();\n            }\n        ", null, "\n            import java.util.HashSet;\n            import java.util.Set;\n            \n            class Test {\n                public Set values = new HashSet();\n            }\n        ", 0, 0, null, null, 983, null);
        }

        @Test
        public static void parameterizedFieldType(@NotNull UseCollectionInterfacesTest this_) {
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, null, "\n            import java.util.HashSet;\n            \n            class Test {\n                public HashSet<Integer> values = new HashSet<>();\n            }\n        ", null, "\n            import java.util.HashSet;\n            import java.util.Set;\n            \n            class Test {\n                public Set<Integer> values = new HashSet<>();\n            }\n        ", 0, 0, null, null, 983, null);
        }

        @Test
        public static void arrayDeque(@NotNull UseCollectionInterfacesTest this_) {
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, null, "\n            import java.util.ArrayDeque;\n            \n            class Test {\n                public ArrayDeque values = new ArrayDeque();\n            }\n        ", null, "\n            import java.util.ArrayDeque;\n            import java.util.Deque;\n            \n            class Test {\n                public Deque values = new ArrayDeque();\n            }\n        ", 0, 0, null, null, 983, null);
        }

        @Test
        public static void concurrentLinkedDeque(@NotNull UseCollectionInterfacesTest this_) {
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, null, "\n            import java.util.concurrent.ConcurrentLinkedDeque;\n            \n            class Test {\n                public ConcurrentLinkedDeque values = new ConcurrentLinkedDeque();\n            }\n        ", null, "\n            import java.util.Deque;\n            import java.util.concurrent.ConcurrentLinkedDeque;\n            \n            class Test {\n                public Deque values = new ConcurrentLinkedDeque();\n            }\n        ", 0, 0, null, null, 983, null);
        }

        @Test
        public static void abstractList(@NotNull UseCollectionInterfacesTest this_) {
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, null, "\n            import java.util.ArrayList;\n            import java.util.AbstractList;\n            \n            class Test {\n                public AbstractList values = new ArrayList();\n            }\n        ", null, "\n            import java.util.ArrayList;\n            import java.util.List;\n            \n            class Test {\n                public List values = new ArrayList();\n            }\n        ", 0, 0, null, null, 983, null);
        }

        @Test
        public static void abstractSequentialList(@NotNull UseCollectionInterfacesTest this_) {
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, null, "\n            import java.util.AbstractSequentialList;\n            import java.util.LinkedList;\n            \n            class Test {\n                public AbstractSequentialList values = new LinkedList();\n            }\n        ", null, "\n            import java.util.LinkedList;\n            import java.util.List;\n            \n            class Test {\n                public List values = new LinkedList();\n            }\n        ", 0, 0, null, null, 983, null);
        }

        @Test
        public static void arrayList(@NotNull UseCollectionInterfacesTest this_) {
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, null, "\n            import java.util.ArrayList;\n            \n            class Test {\n                public ArrayList values = new ArrayList();\n            }\n        ", null, "\n            import java.util.ArrayList;\n            import java.util.List;\n            \n            class Test {\n                public List values = new ArrayList();\n            }\n        ", 0, 0, null, null, 983, null);
        }

        @Test
        public static void copyOnWriteArrayList(@NotNull UseCollectionInterfacesTest this_) {
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, null, "\n            import java.util.concurrent.CopyOnWriteArrayList;\n            \n            class Test {\n                public CopyOnWriteArrayList values = new CopyOnWriteArrayList();\n            }\n        ", null, "\n            import java.util.List;\n            import java.util.concurrent.CopyOnWriteArrayList;\n            \n            class Test {\n                public List values = new CopyOnWriteArrayList();\n            }\n        ", 0, 0, null, null, 983, null);
        }

        @Test
        public static void abstractMap(@NotNull UseCollectionInterfacesTest this_) {
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, null, "\n            import java.util.AbstractMap;\n            import java.util.HashMap;\n            \n            class Test {\n                public AbstractMap values = new HashMap();\n            }\n        ", null, "\n            import java.util.HashMap;\n            import java.util.Map;\n            \n            class Test {\n                public Map values = new HashMap();\n            }\n        ", 0, 0, null, null, 983, null);
        }

        @Test
        public static void enumMap(@NotNull UseCollectionInterfacesTest this_) {
            String[] stringArray = new String[]{"\n            public enum A {}\n        "};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, null, "\n            import java.util.EnumMap;\n            \n            class Test {\n                @SuppressWarnings(\"unchecked\")\n                public EnumMap values = new EnumMap(A.class);\n            }\n        ", stringArray2, "\n            import java.util.EnumMap;\n            import java.util.Map;\n            \n            class Test {\n                @SuppressWarnings(\"unchecked\")\n                public Map values = new EnumMap(A.class);\n            }\n        ", 0, 0, null, null, 967, null);
        }

        @Test
        public static void hashMap(@NotNull UseCollectionInterfacesTest this_) {
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, null, "\n            import java.util.HashMap;\n            \n            class Test {\n                public HashMap values = new HashMap();\n            }\n        ", null, "\n            import java.util.HashMap;\n            import java.util.Map;\n            \n            class Test {\n                public Map values = new HashMap();\n            }\n        ", 0, 0, null, null, 983, null);
        }

        @Test
        public static void hashtable(@NotNull UseCollectionInterfacesTest this_) {
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, null, "\n            import java.util.Hashtable;\n            \n            class Test {\n                public Hashtable values = new Hashtable();\n            }\n        ", null, "\n            import java.util.Hashtable;\n            import java.util.Map;\n            \n            class Test {\n                public Map values = new Hashtable();\n            }\n        ", 0, 0, null, null, 983, null);
        }

        @Test
        public static void identityHashMap(@NotNull UseCollectionInterfacesTest this_) {
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, null, "\n            import java.util.IdentityHashMap;\n            \n            class Test {\n                public IdentityHashMap values = new IdentityHashMap();\n            }\n        ", null, "\n            import java.util.IdentityHashMap;\n            import java.util.Map;\n            \n            class Test {\n                public Map values = new IdentityHashMap();\n            }\n        ", 0, 0, null, null, 983, null);
        }

        @Test
        public static void linkedHashMap(@NotNull UseCollectionInterfacesTest this_) {
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, null, "\n            import java.util.LinkedHashMap;\n            \n            class Test {\n                public LinkedHashMap values = new LinkedHashMap();\n            }\n        ", null, "\n            import java.util.LinkedHashMap;\n            import java.util.Map;\n            \n            class Test {\n                public Map values = new LinkedHashMap();\n            }\n        ", 0, 0, null, null, 983, null);
        }

        @Test
        public static void weakHashMap(@NotNull UseCollectionInterfacesTest this_) {
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, null, "\n            import java.util.WeakHashMap;\n            \n            class Test {\n                public WeakHashMap values = new WeakHashMap();\n            }\n        ", null, "\n            import java.util.Map;\n            import java.util.WeakHashMap;\n            \n            class Test {\n                public Map values = new WeakHashMap();\n            }\n        ", 0, 0, null, null, 983, null);
        }

        @Test
        public static void concurrentHashMap(@NotNull UseCollectionInterfacesTest this_) {
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, null, "\n            import java.util.concurrent.ConcurrentHashMap;\n            \n            class Test {\n                public ConcurrentHashMap values = new ConcurrentHashMap();\n            }\n        ", null, "\n            import java.util.concurrent.ConcurrentHashMap;\n            import java.util.concurrent.ConcurrentMap;\n            \n            class Test {\n                public ConcurrentMap values = new ConcurrentHashMap();\n            }\n        ", 0, 0, null, null, 983, null);
        }

        @Test
        public static void concurrentSkipListMap(@NotNull UseCollectionInterfacesTest this_) {
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, null, "\n            import java.util.concurrent.ConcurrentSkipListMap;\n            \n            class Test {\n                public ConcurrentSkipListMap values = new ConcurrentSkipListMap();\n            }\n        ", null, "\n            import java.util.concurrent.ConcurrentMap;\n            import java.util.concurrent.ConcurrentSkipListMap;\n            \n            class Test {\n                public ConcurrentMap values = new ConcurrentSkipListMap();\n            }\n        ", 0, 0, null, null, 983, null);
        }

        @Test
        public static void abstractQueue(@NotNull UseCollectionInterfacesTest this_) {
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, null, "\n            import java.util.AbstractQueue;\n            import java.util.PriorityQueue;\n            \n            class Test {\n                public AbstractQueue values = new PriorityQueue();\n            }\n        ", null, "\n            import java.util.PriorityQueue;\n            import java.util.Queue;\n            \n            class Test {\n                public Queue values = new PriorityQueue();\n            }\n        ", 0, 0, null, null, 983, null);
        }

        @Test
        public static void concurrentLinkedQueue(@NotNull UseCollectionInterfacesTest this_) {
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, null, "\n            import java.util.concurrent.ConcurrentLinkedQueue;\n            \n            class Test {\n                public ConcurrentLinkedQueue values = new ConcurrentLinkedQueue();\n            }\n        ", null, "\n            import java.util.Queue;\n            import java.util.concurrent.ConcurrentLinkedQueue;\n            \n            class Test {\n                public Queue values = new ConcurrentLinkedQueue();\n            }\n        ", 0, 0, null, null, 983, null);
        }

        @Test
        public static void abstractSet(@NotNull UseCollectionInterfacesTest this_) {
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, null, "\n            import java.util.AbstractSet;\n            import java.util.HashSet;\n            \n            class Test {\n                public AbstractSet values = new HashSet();\n            }\n        ", null, "\n            import java.util.HashSet;\n            import java.util.Set;\n            \n            class Test {\n                public Set values = new HashSet();\n            }\n        ", 0, 0, null, null, 983, null);
        }

        @Test
        public static void enumSet(@NotNull UseCollectionInterfacesTest this_) {
            String[] stringArray = new String[]{"\n            public enum A {}\n        "};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, null, "\n            import java.util.EnumSet;\n            \n            class Test {\n                public EnumSet values = EnumSet.allOf(A.class);\n            }\n        ", stringArray2, "\n            import java.util.EnumSet;\n            import java.util.Set;\n            \n            class Test {\n                public Set values = EnumSet.allOf(A.class);\n            }\n        ", 0, 0, null, null, 967, null);
        }

        @Test
        public static void hashSet(@NotNull UseCollectionInterfacesTest this_) {
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, null, "\n            import java.util.HashSet;\n            \n            class Test {\n                public HashSet values = new HashSet();\n            }\n        ", null, "\n            import java.util.HashSet;\n            import java.util.Set;\n            \n            class Test {\n                public Set values = new HashSet();\n            }\n        ", 0, 0, null, null, 983, null);
        }

        @Test
        public static void linkedHashSet(@NotNull UseCollectionInterfacesTest this_) {
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, null, "\n            import java.util.LinkedHashSet;\n            \n            class Test {\n                public LinkedHashSet values = new LinkedHashSet();\n            }\n        ", null, "\n            import java.util.LinkedHashSet;\n            import java.util.Set;\n            \n            class Test {\n                public Set values = new LinkedHashSet();\n            }\n        ", 0, 0, null, null, 983, null);
        }

        @Test
        public static void copyOnWriteArraySet(@NotNull UseCollectionInterfacesTest this_) {
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, null, "\n            import java.util.concurrent.CopyOnWriteArraySet;\n            \n            class Test {\n                public CopyOnWriteArraySet values = new CopyOnWriteArraySet();\n            }\n        ", null, "\n            import java.util.Set;\n            import java.util.concurrent.CopyOnWriteArraySet;\n            \n            class Test {\n                public Set values = new CopyOnWriteArraySet();\n            }\n        ", 0, 0, null, null, 983, null);
        }

        @Test
        public static void privateVariable(@NotNull UseCollectionInterfacesTest this_) {
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, null, "\n            import java.util.ArrayList;\n            \n            class Test {\n                private ArrayList<Integer> values = new ArrayList<>();\n            }\n        ", null, "\n            import java.util.ArrayList;\n            import java.util.List;\n            \n            class Test {\n                private List<Integer> values = new ArrayList<>();\n            }\n        ", 0, 0, null, null, 983, null);
        }

        @Test
        public static void noModifierOnVariable(@NotNull UseCollectionInterfacesTest this_) {
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, null, "\n            import java.util.ArrayList;\n            \n            class Test {\n                ArrayList<Integer> values = new ArrayList<>();\n            }\n        ", null, "\n            import java.util.ArrayList;\n            import java.util.List;\n            \n            class Test {\n                List<Integer> values = new ArrayList<>();\n            }\n        ", 0, 0, null, null, 983, null);
        }

        @Test
        public static void privateMethod(@NotNull UseCollectionInterfacesTest this_) {
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, null, "\n            import java.util.HashSet;\n            \n            class Test {\n                private HashSet<Integer> method() {\n                    return new HashSet<>();\n                }\n            }\n        ", null, "\n            import java.util.HashSet;\n            import java.util.Set;\n            \n            class Test {\n                private Set<Integer> method() {\n                    return new HashSet<>();\n                }\n            }\n        ", 0, 0, null, null, 983, null);
        }

        @Test
        public static void noModifierOnMethod(@NotNull UseCollectionInterfacesTest this_) {
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, null, "\n            import java.util.HashSet;\n            \n            class Test {\n                HashSet<Integer> method() {\n                    return new HashSet<>();\n                }\n            }\n        ", null, "\n            import java.util.HashSet;\n            import java.util.Set;\n            \n            class Test {\n                Set<Integer> method() {\n                    return new HashSet<>();\n                }\n            }\n        ", 0, 0, null, null, 983, null);
        }

        @Test
        public static void variableWithVar(@NotNull UseCollectionInterfacesTest this_) {
            String javaRuntimeVersion = System.getProperty("java.runtime.version");
            String javaVendor = System.getProperty("java.vm.vendor");
            if (new JavaVersion(UUID.randomUUID(), javaRuntimeVersion, javaVendor, javaRuntimeVersion, javaRuntimeVersion).getMajorVersion() >= 10) {
                JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, this_.getParser(), this_.getRecipe(), this_.getExecutionContext(), "import java.util.ArrayList;\n\nclass Test {\n    public void method() {\n        var list = new ArrayList<>();\n    }\n}", null, 16, null);
            }
        }

        @NotNull
        public static JavaParser getParser(@NotNull UseCollectionInterfacesTest this_) {
            return JavaRecipeTest.DefaultImpls.getParser(this_);
        }

        @NotNull
        public static ExecutionContext getExecutionContext(@NotNull UseCollectionInterfacesTest this_) {
            return JavaRecipeTest.DefaultImpls.getExecutionContext(this_);
        }

        @BeforeEach
        public static void beforeRecipe(@NotNull UseCollectionInterfacesTest this_) {
            JavaRecipeTest.DefaultImpls.beforeRecipe(this_);
        }

        @AfterEach
        public static void afterRecipe(@NotNull UseCollectionInterfacesTest this_) {
            JavaRecipeTest.DefaultImpls.afterRecipe(this_);
        }

        public static void assertChanged(@NotNull UseCollectionInterfacesTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super TypeValidator.ValidationOptions.Companion.Builder, Unit> typeValidation, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(typeValidation, (String)"typeValidation");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged(this_, parser, recipe2, executionContext, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, typeValidation, afterConditions);
        }

        public static void assertChanged(@NotNull UseCollectionInterfacesTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull File before, @Nullable Path relativeTo, @Language(value="java") @NotNull File[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super TypeValidator.ValidationOptions.Companion.Builder, Unit> typeValidation, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(typeValidation, (String)"typeValidation");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged(this_, parser, recipe2, executionContext, before, relativeTo, dependsOn, after, cycles, expectedCyclesThatMakeChanges, typeValidation, afterConditions);
        }

        public static void assertUnchanged(@NotNull UseCollectionInterfacesTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, parser, recipe2, executionContext, before, dependsOn);
        }

        public static void assertUnchanged(@NotNull UseCollectionInterfacesTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull File before, @Nullable Path relativeTo, @Language(value="java") @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, parser, recipe2, executionContext, before, relativeTo, dependsOn);
        }

        public static void assertChangedBase(@NotNull UseCollectionInterfacesTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull File before, @Nullable Path relativeTo, @NotNull File[] dependsOn, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase(this_, parser, recipe2, executionContext, before, relativeTo, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertChangedBase(@NotNull UseCollectionInterfacesTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull String before, @NotNull String[] dependsOn, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase(this_, parser, recipe2, executionContext, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertUnchangedBase(@NotNull UseCollectionInterfacesTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull File before, @Nullable Path relativeTo, @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchangedBase(this_, parser, recipe2, executionContext, before, relativeTo, dependsOn);
        }

        public static void assertUnchangedBase(@NotNull UseCollectionInterfacesTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull String before, @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchangedBase(this_, parser, recipe2, executionContext, before, dependsOn);
        }

        @NotNull
        public static Recipe fromRuntimeClasspath(@NotNull UseCollectionInterfacesTest this_, @NotNull String recipe2) {
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            return JavaRecipeTest.DefaultImpls.fromRuntimeClasspath(this_, recipe2);
        }

        @NotNull
        public static Recipe toRecipe(@NotNull UseCollectionInterfacesTest this_, @NotNull Function0<? extends TreeVisitor<?, ExecutionContext>> supplier) {
            Intrinsics.checkNotNullParameter(supplier, (String)"supplier");
            return JavaRecipeTest.DefaultImpls.toRecipe(this_, supplier);
        }
    }
}

