/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.io.File;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaRecipeTest;
import org.openrewrite.java.TypeValidator;
import org.openrewrite.java.cleanup.RenamePrivateFieldsToCamelCase;
import org.openrewrite.java.tree.J;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0012\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0013\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0014\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0015\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017R\u0016\u0010\u0002\u001a\u0004\u0018\u00010\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0016"}, d2={"Lorg/openrewrite/java/cleanup/RenamePrivateFieldsToCamelCaseTest;", "Lorg/openrewrite/java/JavaRecipeTest;", "recipe", "Lorg/openrewrite/Recipe;", "getRecipe", "()Lorg/openrewrite/Recipe;", "doNotChangeExistsInOnlyOneMethod", "", "jp", "Lorg/openrewrite/java/JavaParser;", "doNotChangeIfToNameExists", "doNotChangeInheritedFields", "doNotChangeStaticImports", "doNotChangeWhenSameMethodParam", "doNotRenameAnonymousInnerClasses", "doNotRenameInnerClassesMembers", "handleStaticMethods", "renameFinalMembers", "renamePrivateMembers", "renameUsageInInnerClasses", "renameWhenSameMethodExists", "renameWithFieldAccess", "rewrite-java-tck"})
public interface RenamePrivateFieldsToCamelCaseTest
extends JavaRecipeTest {
    @Nullable
    public Recipe getRecipe();

    @Test
    public void doNotChangeStaticImports(@NotNull JavaParser var1);

    @Test
    public void doNotChangeInheritedFields(@NotNull JavaParser var1);

    @Test
    public void doNotChangeIfToNameExists(@NotNull JavaParser var1);

    @Test
    public void doNotChangeExistsInOnlyOneMethod(@NotNull JavaParser var1);

    @Test
    public void renamePrivateMembers(@NotNull JavaParser var1);

    @Test
    public void renameWithFieldAccess(@NotNull JavaParser var1);

    @Test
    public void doNotRenameInnerClassesMembers(@NotNull JavaParser var1);

    @Test
    public void renameUsageInInnerClasses(@NotNull JavaParser var1);

    @Test
    public void doNotRenameAnonymousInnerClasses(@NotNull JavaParser var1);

    @Test
    public void handleStaticMethods(@NotNull JavaParser var1);

    @Test
    public void renameFinalMembers(@NotNull JavaParser var1);

    @Test
    public void doNotChangeWhenSameMethodParam(@NotNull JavaParser var1);

    @Test
    public void renameWhenSameMethodExists(@NotNull JavaParser var1);

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @Nullable
        public static Recipe getRecipe(@NotNull RenamePrivateFieldsToCamelCaseTest this_) {
            return (Recipe)new RenamePrivateFieldsToCamelCase();
        }

        @Test
        public static void doNotChangeStaticImports(@NotNull RenamePrivateFieldsToCamelCaseTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"\n            class B {\n                public static int _staticImport_ = 0;\n            }\n        "};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, jp, null, null, "\n            import static B._staticImport_;\n\n            class Test {\n                private int member = _staticImport_;\n            }\n        ", stringArray2, 6, null);
        }

        @Test
        public static void doNotChangeInheritedFields(@NotNull RenamePrivateFieldsToCamelCaseTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"\n            class A {\n                public int _inheritedField_ = 0;\n            }\n        "};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, null, null, "\n            class Test extends A {\n                private int _inheritedField_ = super._inheritedField_;\n            }\n        ", stringArray2, "\n            class Test extends A {\n                private int inheritedField = super._inheritedField_;\n            }\n        ", 0, 0, null, null, 966, null);
        }

        @Test
        public static void doNotChangeIfToNameExists(@NotNull RenamePrivateFieldsToCamelCaseTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, jp, null, null, "\n            class Test {\n                int test_value;\n\n                public int addTen(int testValue) {\n                    return test_value + testValue;\n                }\n            }\n        ", null, 22, null);
        }

        @Test
        public static void doNotChangeExistsInOnlyOneMethod(@NotNull RenamePrivateFieldsToCamelCaseTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, jp, null, null, "\n            class Test {\n                private int DoNoTChange;\n                \n                public int addTwenty(String doNoTChange) {\n                    return DoNoTChange + 20;\n                }\n                public int addTen(String value) {\n                    return DoNoTChange + 10;\n                }\n            }\n        ", null, 22, null);
        }

        @Test
        public static void renamePrivateMembers(@NotNull RenamePrivateFieldsToCamelCaseTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, null, null, "\n            class Test {\n                private int DoChange = 10;\n                public int DoNotChangePublicMember;\n                int DoNotChangeDefaultMember;\n\n                public int getTen() {\n                    return DoChange;\n                }\n\n                public int getTwenty() {\n                    return this.DoChange * 2;\n                }\n\n                public int getThirty() {\n                    return DoChange * 3;\n                }\n            }\n        ", null, "\n            class Test {\n                private int doChange = 10;\n                public int DoNotChangePublicMember;\n                int DoNotChangeDefaultMember;\n\n                public int getTen() {\n                    return doChange;\n                }\n\n                public int getTwenty() {\n                    return this.doChange * 2;\n                }\n\n                public int getThirty() {\n                    return doChange * 3;\n                }\n            }\n        ", 0, 0, null, null, 982, null);
        }

        @Test
        public static void renameWithFieldAccess(@NotNull RenamePrivateFieldsToCamelCaseTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"\n            class ClassWithPublicField {\n                public int publicField = 10;\n            }\n        "};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, null, null, "\n            class Test {\n                private ClassWithPublicField DoChange = new ClassWithPublicField();\n\n                public int getTen() {\n                    return DoChange.publicField;\n                }\n            }\n        ", stringArray2, "\n            class Test {\n                private ClassWithPublicField doChange = new ClassWithPublicField();\n\n                public int getTen() {\n                    return doChange.publicField;\n                }\n            }\n        ", 0, 0, null, null, 966, null);
        }

        @Test
        public static void doNotRenameInnerClassesMembers(@NotNull RenamePrivateFieldsToCamelCaseTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, jp, null, null, "\n            class Test {\n                private int test = new InnerClass().DoNotChange + new InnerClass().DoNotChange2;\n                \n                private class InnerClass{\n                    public int DoNotChange = 10;\n                    private int DoNotChange2 = 10;\n                }\n            }\n        ", null, 22, null);
        }

        @Test
        public static void renameUsageInInnerClasses(@NotNull RenamePrivateFieldsToCamelCaseTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, null, null, "\n            class Test {\n                private int DoChange = 10;\n                \n                private class InnerClass{\n                    private int test = DoChange + 1;\n                }\n            }\n        ", null, "\n            class Test {\n                private int doChange = 10;\n                \n                private class InnerClass{\n                    private int test = doChange + 1;\n                }\n            }\n        ", 0, 0, null, null, 982, null);
        }

        @Test
        public static void doNotRenameAnonymousInnerClasses(@NotNull RenamePrivateFieldsToCamelCaseTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"\n                interface Book{}\n            "};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, jp, null, null, "\n                class B (){\n                    B(){\n                        new Book() {\n                          private String DoChange;\n\n                          @Override\n                          public String toString() {\n                            return DoChange;\n                          }\n                        };\n                    }\n                }\n        ", stringArray2, 6, null);
        }

        @Test
        public static void handleStaticMethods(@NotNull RenamePrivateFieldsToCamelCaseTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, null, null, "\n                class A (){\n                    private int _variable;\n                    public static A getInstance(){\n                        A a = new A();\n                        a._variable = 12;\n                        return a;\n                    }\n                }\n        ", null, "\n                class A (){\n                    private int variable;\n                    public static A getInstance(){\n                        A a = new A();\n                        a.variable = 12;\n                        return a;\n                    }\n                }\n        ", 0, 0, null, null, 982, null);
        }

        @Test
        public static void renameFinalMembers(@NotNull RenamePrivateFieldsToCamelCaseTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, null, null, "\n                class A (){\n                    private final int _final_variable;\n                    private static int _static_variable;\n                    private static final int DO_NOT_CHANGE;\n                }\n        ", null, "\n                class A (){\n                    private final int finalVariable;\n                    private static int staticVariable;\n                    private static final int DO_NOT_CHANGE;\n                }\n        ", 0, 0, null, null, 982, null);
        }

        @Test
        public static void doNotChangeWhenSameMethodParam(@NotNull RenamePrivateFieldsToCamelCaseTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, jp, null, null, "\n                class A (){\n                    private int _variable;\n                    public void getInstance(int _variable){\n                        this._variable = _variable;\n                    }\n                }\n        ", null, 22, null);
        }

        @Test
        public static void renameWhenSameMethodExists(@NotNull RenamePrivateFieldsToCamelCaseTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, null, null, "\n                class A (){\n                    private boolean _hasMethod;\n                    public boolean hasMethod(){\n                        return _hasMethod;\n                    }\n                }\n        ", null, "\n                class A (){\n                    private boolean hasMethod;\n                    public boolean hasMethod(){\n                        return hasMethod;\n                    }\n                }\n        ", 0, 0, null, null, 982, null);
        }

        @NotNull
        public static JavaParser getParser(@NotNull RenamePrivateFieldsToCamelCaseTest this_) {
            return JavaRecipeTest.DefaultImpls.getParser(this_);
        }

        @NotNull
        public static ExecutionContext getExecutionContext(@NotNull RenamePrivateFieldsToCamelCaseTest this_) {
            return JavaRecipeTest.DefaultImpls.getExecutionContext(this_);
        }

        @BeforeEach
        public static void beforeRecipe(@NotNull RenamePrivateFieldsToCamelCaseTest this_) {
            JavaRecipeTest.DefaultImpls.beforeRecipe(this_);
        }

        @AfterEach
        public static void afterRecipe(@NotNull RenamePrivateFieldsToCamelCaseTest this_) {
            JavaRecipeTest.DefaultImpls.afterRecipe(this_);
        }

        public static void assertChanged(@NotNull RenamePrivateFieldsToCamelCaseTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super TypeValidator.ValidationOptions.Companion.Builder, Unit> typeValidation, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(typeValidation, (String)"typeValidation");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged(this_, parser, recipe2, executionContext, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, typeValidation, afterConditions);
        }

        public static void assertChanged(@NotNull RenamePrivateFieldsToCamelCaseTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull File before, @Nullable Path relativeTo, @Language(value="java") @NotNull File[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super TypeValidator.ValidationOptions.Companion.Builder, Unit> typeValidation, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(typeValidation, (String)"typeValidation");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged(this_, parser, recipe2, executionContext, before, relativeTo, dependsOn, after, cycles, expectedCyclesThatMakeChanges, typeValidation, afterConditions);
        }

        public static void assertUnchanged(@NotNull RenamePrivateFieldsToCamelCaseTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, parser, recipe2, executionContext, before, dependsOn);
        }

        public static void assertUnchanged(@NotNull RenamePrivateFieldsToCamelCaseTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull File before, @Nullable Path relativeTo, @Language(value="java") @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, parser, recipe2, executionContext, before, relativeTo, dependsOn);
        }

        public static void assertChangedBase(@NotNull RenamePrivateFieldsToCamelCaseTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull File before, @Nullable Path relativeTo, @NotNull File[] dependsOn, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase(this_, parser, recipe2, executionContext, before, relativeTo, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertChangedBase(@NotNull RenamePrivateFieldsToCamelCaseTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull String before, @NotNull String[] dependsOn, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase(this_, parser, recipe2, executionContext, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertUnchangedBase(@NotNull RenamePrivateFieldsToCamelCaseTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull File before, @Nullable Path relativeTo, @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchangedBase(this_, parser, recipe2, executionContext, before, relativeTo, dependsOn);
        }

        public static void assertUnchangedBase(@NotNull RenamePrivateFieldsToCamelCaseTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull String before, @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchangedBase(this_, parser, recipe2, executionContext, before, dependsOn);
        }

        @NotNull
        public static Recipe fromRuntimeClasspath(@NotNull RenamePrivateFieldsToCamelCaseTest this_, @NotNull String recipe2) {
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            return JavaRecipeTest.DefaultImpls.fromRuntimeClasspath(this_, recipe2);
        }

        @NotNull
        public static Recipe toRecipe(@NotNull RenamePrivateFieldsToCamelCaseTest this_, @NotNull Function0<? extends TreeVisitor<?, ExecutionContext>> supplier) {
            Intrinsics.checkNotNullParameter(supplier, (String)"supplier");
            return JavaRecipeTest.DefaultImpls.toRecipe(this_, supplier);
        }
    }
}

