/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.io.File;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.Assertions;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaRecipeTest;
import org.openrewrite.java.TypeValidator;
import org.openrewrite.java.cleanup.RemoveUnusedLocalVariables;
import org.openrewrite.java.tree.J;
import org.openrewrite.test.RecipeSpec;
import org.openrewrite.test.RewriteTest;
import org.openrewrite.test.SourceSpecs;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b$\bf\u0018\u00002\u00020\u00012\u00020\u0002J\b\u0010\u0007\u001a\u00020\bH\u0017J\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\bH\u0017J\b\u0010\r\u001a\u00020\bH\u0017J\b\u0010\u000e\u001a\u00020\bH\u0017J\b\u0010\u000f\u001a\u00020\bH\u0017J\b\u0010\u0010\u001a\u00020\bH\u0017J\b\u0010\u0011\u001a\u00020\bH\u0017J\b\u0010\u0012\u001a\u00020\bH\u0017J\b\u0010\u0013\u001a\u00020\bH\u0017J\b\u0010\u0014\u001a\u00020\bH\u0017J\b\u0010\u0015\u001a\u00020\bH\u0017J\b\u0010\u0016\u001a\u00020\bH\u0017J\b\u0010\u0017\u001a\u00020\bH\u0017J\b\u0010\u0018\u001a\u00020\bH\u0017J\b\u0010\u0019\u001a\u00020\bH\u0017J\b\u0010\u001a\u001a\u00020\bH\u0017J\b\u0010\u001b\u001a\u00020\bH\u0017J\b\u0010\u001c\u001a\u00020\bH\u0017J\b\u0010\u001d\u001a\u00020\bH\u0017J\b\u0010\u001e\u001a\u00020\bH\u0017J\b\u0010\u001f\u001a\u00020\bH\u0017J\b\u0010 \u001a\u00020\bH\u0017J\b\u0010!\u001a\u00020\bH\u0017J\b\u0010\"\u001a\u00020\bH\u0017J\b\u0010#\u001a\u00020\bH\u0017J\b\u0010$\u001a\u00020\bH\u0017J\b\u0010%\u001a\u00020\bH\u0017J\b\u0010&\u001a\u00020\bH\u0017J\b\u0010'\u001a\u00020\bH\u0017J\b\u0010(\u001a\u00020\bH\u0017J\b\u0010)\u001a\u00020\bH\u0017J\b\u0010*\u001a\u00020\bH\u0017J\b\u0010+\u001a\u00020\bH\u0017J\b\u0010,\u001a\u00020\bH\u0017J\b\u0010-\u001a\u00020\bH\u0017J\b\u0010.\u001a\u00020\bH\u0017R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006/"}, d2={"Lorg/openrewrite/java/cleanup/RemoveUnusedLocalVariablesTest;", "Lorg/openrewrite/test/RewriteTest;", "Lorg/openrewrite/java/JavaRecipeTest;", "recipe", "Lorg/openrewrite/Recipe;", "getRecipe", "()Lorg/openrewrite/Recipe;", "assignmentWithinExpression", "", "defaults", "spec", "Lorg/openrewrite/test/RecipeSpec;", "forLoopIncrementVariableReadInEvaluationCondition", "forLoopWithExternalIncrementLogic", "handleInstanceOf", "handleLocalVariablesShadowingClassFields", "handleVariablesReadWithinTry", "ignoreAnonymousClassVariables", "ignoreClassFields", "ignoreClassVariables", "ignoreEnhancedForLoops", "ignoreForLoopIncrementVariableNeverRead", "ignoreSuppressWarnings", "ignoreTryWithResourceUnusedVariables", "ignoreUnusedLambdaExpressionParameters", "ignoreUnusedLambdaExpressionParametersForEach", "ignoreUnusedTryCatchExceptionVariableDeclaration", "ignoreVariablesNamed", "keepLocalVariableAssignmentOperation", "keepLocalVariableBitwiseAssignmentOperationWithinExpression", "keepLocalVariablesAssignmentOperationToOtherVariables", "keepLocalVariablesWhenMethodInvocationsCalledOnThem", "keepLocalVariablesWhenUsedAsMethodInvocationArgument", "keepRightHandSideStatement", "keepStatementWhenSideEffectInAccess", "keepStatementWhenSideEffectInInitialization", "localVariableUnusedIncrementOperation", "preserveComment", "recognizeUsedVariableWithinWhileLoop", "remove file getter methods as they do not side effect", "remove file getter methods when chained as they do not side effect", "removeUnusedLocalVariableBitwiseAssignmentOperation", "removeUnusedLocalVariables", "removeUnusedLocalVariablesFromMultiVariablesDeclaration", "removeUnusedLocalVariablesInClassInitializer", "removeUnusedLocalVariablesReassignedButNeverUsed", "removeUnusedLocalVariablesWithinTryCatch", "rewrite-java-tck"})
public interface RemoveUnusedLocalVariablesTest
extends RewriteTest,
JavaRecipeTest {
    @NotNull
    public Recipe getRecipe();

    public void defaults(@NotNull RecipeSpec var1);

    @Test
    public void ignoreSuppressWarnings();

    @Test
    public void ignoreVariablesNamed();

    @Test
    public void keepRightHandSideStatement();

    @Test
    public void keepStatementWhenSideEffectInInitialization();

    @Test
    public void keepStatementWhenSideEffectInAccess();

    @Test
    public void removeUnusedLocalVariables();

    @Test
    public void preserveComment();

    @Test
    public void removeUnusedLocalVariablesReassignedButNeverUsed();

    @Test
    public void ignoreClassFields();

    @Test
    public void removeUnusedLocalVariablesInClassInitializer();

    @Test
    public void handleLocalVariablesShadowingClassFields();

    @Test
    public void localVariableUnusedIncrementOperation();

    @Test
    public void keepLocalVariablesAssignmentOperationToOtherVariables();

    @Test
    public void keepLocalVariableAssignmentOperation();

    @Test
    public void removeUnusedLocalVariableBitwiseAssignmentOperation();

    @Test
    public void keepLocalVariableBitwiseAssignmentOperationWithinExpression();

    @Test
    public void handleInstanceOf();

    @Test
    public void removeUnusedLocalVariablesFromMultiVariablesDeclaration();

    @Test
    public void keepLocalVariablesWhenUsedAsMethodInvocationArgument();

    @Test
    public void keepLocalVariablesWhenMethodInvocationsCalledOnThem();

    @Test
    public void ignoreClassVariables();

    @Test
    public void ignoreAnonymousClassVariables();

    @Test
    public void forLoopWithExternalIncrementLogic();

    @Test
    public void forLoopIncrementVariableReadInEvaluationCondition();

    @Test
    public void removeUnusedLocalVariablesWithinTryCatch();

    @Test
    public void ignoreTryWithResourceUnusedVariables();

    @Test
    public void handleVariablesReadWithinTry();

    @Test
    public void ignoreUnusedTryCatchExceptionVariableDeclaration();

    @Test
    public void ignoreUnusedLambdaExpressionParameters();

    @Test
    public void ignoreUnusedLambdaExpressionParametersForEach();

    @Test
    public void recognizeUsedVariableWithinWhileLoop();

    @Test
    public void ignoreForLoopIncrementVariableNeverRead();

    @Test
    public void ignoreEnhancedForLoops();

    @Test
    public void remove file getter methods as they do not side effect();

    @Test
    public void remove file getter methods when chained as they do not side effect();

    @Test
    public void assignmentWithinExpression();

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @NotNull
        public static Recipe getRecipe(@NotNull RemoveUnusedLocalVariablesTest this_) {
            return (Recipe)new RemoveUnusedLocalVariables(new String[0]);
        }

        public static void defaults(@NotNull RemoveUnusedLocalVariablesTest this_, @NotNull RecipeSpec spec) {
            Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
            spec.recipe((Recipe)new RemoveUnusedLocalVariables(new String[0]));
        }

        @Test
        public static void ignoreSuppressWarnings(@NotNull RemoveUnusedLocalVariablesTest this_) {
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, null, null, null, "\n            class Test {\n                static int method(int x) {\n                    int a = 0;\n                    @SuppressWarnings(\"unused\") int b = 0;\n                    return a + 1;\n                }\n            }\n        ", null, 23, null);
        }

        @Test
        public static void ignoreVariablesNamed(@NotNull RemoveUnusedLocalVariablesTest this_) {
            String[] stringArray = new String[]{"unused", "ignoreMe"};
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, null, (Recipe)new RemoveUnusedLocalVariables(stringArray), null, "\n            class Test {\n                void method(Object someData) {\n                    int unused = writeDataToTheDB(someData);\n                    int ignoreMe = writeDataToTheDB(someData);\n                }\n\n                int writeDataToTheDB(Object save) {\n                    return 1;\n                }\n            }\n        ", null, 21, null);
        }

        @Test
        public static void keepRightHandSideStatement(@NotNull RemoveUnusedLocalVariablesTest this_) {
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, null, null, null, "\n            class Test {\n                void method(Object someData) {\n                    int doNotRemoveMe = writeDataToTheDB(someData);\n                    int doNotRemoveMeEither = 1 + writeDataToTheDB(someData);\n                }\n\n                int writeDataToTheDB(Object save) {\n                    return 1;\n                }\n            }\n        ", null, 23, null);
        }

        @Test
        public static void keepStatementWhenSideEffectInInitialization(@NotNull RemoveUnusedLocalVariablesTest this_) {
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, null, null, null, "\n            class Test {\n                void method(Object someData) {\n                    // Don't write code like this.... Please\n                    int a = null == (someData = null) ? 0 : 9;\n                }\n            }\n        ", null, 23, null);
        }

        @Test
        public static void keepStatementWhenSideEffectInAccess(@NotNull RemoveUnusedLocalVariablesTest this_) {
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, null, null, null, "\n            class Test {\n                void method(Object someData) {\n                    String a = \"\";\n                    while((a = reader.nexLine()) != null) {\n                        System.out.println(a);\n                    }\n                }\n            }\n        ", null, 23, null);
        }

        @Test
        public static void removeUnusedLocalVariables(@NotNull RemoveUnusedLocalVariablesTest this_) {
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, null, "\n            class Test {\n                static int method(int x) {\n                    int a = 0;\n                    int b = 0;\n                    return a;\n                }\n            }\n        ", null, "\n            class Test {\n                static int method(int x) {\n                    int a = 0;\n                    return a;\n                }\n            }\n        ", 0, 0, null, null, 983, null);
        }

        @Test
        public static void preserveComment(@NotNull RemoveUnusedLocalVariablesTest this_) {
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, null, "\n            class Test {\n                Long method() {\n                    // Keep comment\n                    String foo;\n                    return Long.parseLong(\"123\");\n                }\n            }\n        ", null, "\n            class Test {\n                Long method() {\n                    // Keep comment\n                    return Long.parseLong(\"123\");\n                }\n            }\n        ", 0, 0, null, null, 983, null);
        }

        @Test
        public static void removeUnusedLocalVariablesReassignedButNeverUsed(@NotNull RemoveUnusedLocalVariablesTest this_) {
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, null, "\n            class Test {\n                static int method() {\n                    int isRead = -1;\n                    int notRead = 0;\n                    notRead = 1;\n                    notRead += 1;\n                    notRead = isRead + 1;\n                    return isRead + 1;\n                }\n            }\n        ", null, "\n            class Test {\n                static int method() {\n                    int isRead = -1;\n                    return isRead + 1;\n                }\n            }\n        ", 0, 0, null, null, 983, null);
        }

        @Test
        public static void ignoreClassFields(@NotNull RemoveUnusedLocalVariablesTest this_) {
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, null, null, null, "\n            class Test {\n                int a = 0;\n                int b = 1;\n\n                int method(int x) {\n                    b = 2;\n                    return x + 1;\n                }\n            }\n        ", null, 23, null);
        }

        @Test
        public static void removeUnusedLocalVariablesInClassInitializer(@NotNull RemoveUnusedLocalVariablesTest this_) {
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, null, "\n            class Test {\n                static {\n                    int unused = 0;\n                    int used = 1;\n                    System.out.println(used);\n                }\n\n                {\n                    int unused = 0;\n                    int used = 1;\n                    System.out.println(used);\n                }\n            }\n        ", null, "\n            class Test {\n                static {\n                    int used = 1;\n                    System.out.println(used);\n                }\n\n                {\n                    int used = 1;\n                    System.out.println(used);\n                }\n            }\n        ", 0, 0, null, null, 983, null);
        }

        @Test
        public static void handleLocalVariablesShadowingClassFields(@NotNull RemoveUnusedLocalVariablesTest this_) {
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, null, "\n            class Test {\n                int a = 0;\n                int unused = 1;\n\n                static int method(int x) {\n                    int unused = 2;\n                    return x + 1;\n                }\n            }\n        ", null, "\n            class Test {\n                int a = 0;\n                int unused = 1;\n\n                static int method(int x) {\n                    return x + 1;\n                }\n            }\n        ", 0, 0, null, null, 983, null);
        }

        @Test
        public static void localVariableUnusedIncrementOperation(@NotNull RemoveUnusedLocalVariablesTest this_) {
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, null, "\n            class Test {\n                static boolean isTrue() {\n                    return false;\n                }\n\n                static int method(int x) {\n                    int a = 0;\n                    int b = 99;\n                    a++;\n                    for (int i = 0; isTrue(); i++) {\n                        a++;\n                    }\n                    return b++;\n                }\n            }\n        ", null, "\n            class Test {\n                static boolean isTrue() {\n                    return false;\n                }\n\n                static int method(int x) {\n                    int b = 99;\n                    for (int i = 0; isTrue(); i++) {\n                    }\n                    return b++;\n                }\n            }\n        ", 0, 0, null, null, 983, null);
        }

        @Test
        public static void keepLocalVariablesAssignmentOperationToOtherVariables(@NotNull RemoveUnusedLocalVariablesTest this_) {
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, null, null, null, "\n            class Test {\n                static int method() {\n                    int dataSize = 0;\n                    int size = 0;\n                    for (int j = 0; j < 10; j++) {\n                        dataSize += 1;\n                    }\n                    size += dataSize;\n                    return size;\n                }\n            }\n        ", null, 23, null);
        }

        @Test
        public static void keepLocalVariableAssignmentOperation(@NotNull RemoveUnusedLocalVariablesTest this_) {
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, null, null, null, "\n            class Test {\n                static boolean method() {\n                    boolean a = false;\n                    return a |= false;\n                }\n            }\n        ", null, 23, null);
        }

        @Test
        public static void removeUnusedLocalVariableBitwiseAssignmentOperation(@NotNull RemoveUnusedLocalVariablesTest this_) {
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, null, "\n            class Test {\n                static boolean method() {\n                    boolean a = false;\n                    boolean b = false;\n                    b &= true;\n                    return a |= false;\n                }\n            }\n        ", null, "\n            class Test {\n                static boolean method() {\n                    boolean a = false;\n                    return a |= false;\n                }\n            }\n        ", 0, 0, null, null, 983, null);
        }

        @Test
        public static void keepLocalVariableBitwiseAssignmentOperationWithinExpression(@NotNull RemoveUnusedLocalVariablesTest this_) {
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, null, null, null, "\n            class Test {\n                static boolean method(String string) {\n                    boolean a = false;\n                    for (char c : string.toCharArray()) {\n                        if (false || (a |= !Character.isWhitespace(c))) {\n                            break;\n                        }\n                    }\n                    return a;\n                }\n            }\n        ", null, 23, null);
        }

        @Test
        public static void handleInstanceOf(@NotNull RemoveUnusedLocalVariablesTest this_) {
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, null, null, null, "\n            import java.util.Stack;\n\n            class Test {\n                static boolean method(Stack<Object> typeStack) {\n                    for (Object e = typeStack.pop(); ; e = typeStack.pop()) {\n                        if (e instanceof String) {\n                            break;\n                        }\n                    }\n                    return true;\n                }\n            }\n        ", null, 23, null);
        }

        @Test
        public static void removeUnusedLocalVariablesFromMultiVariablesDeclaration(@NotNull RemoveUnusedLocalVariablesTest this_) {
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, null, "\n            class Test {\n                static int method(int x) {\n                    int a = 0, b = 0, c = 0, d = 0;\n                    return b + c;\n                }\n            }\n        ", null, "\n            class Test {\n                static int method(int x) {\n                    int b = 0, c = 0;\n                    return b + c;\n                }\n            }\n        ", 0, 0, null, null, 983, null);
        }

        @Test
        public static void keepLocalVariablesWhenUsedAsMethodInvocationArgument(@NotNull RemoveUnusedLocalVariablesTest this_) {
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, null, null, null, "\n            class Test {\n                static void method() {\n                    int a = 0;\n                    System.out.println(a);\n                }\n            }\n        ", null, 23, null);
        }

        @Test
        public static void keepLocalVariablesWhenMethodInvocationsCalledOnThem(@NotNull RemoveUnusedLocalVariablesTest this_) {
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, null, null, null, "\n            class Test {\n                void method() {\n                    Worker worker = new Worker();\n                    worker.doWork();\n                }\n\n                class Worker {\n                    void doWork() {\n                        //\n                    }\n                }\n            }\n        ", null, 23, null);
        }

        @Test
        public static void ignoreClassVariables(@NotNull RemoveUnusedLocalVariablesTest this_) {
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, null, null, null, "\n            class Test {\n                static int someClassVariable = 0;\n                int someInstanceVariable = 0;\n\n                static void method() {\n                    // do nothing\n                }\n            }\n        ", null, 23, null);
        }

        @Test
        public static void ignoreAnonymousClassVariables(@NotNull RemoveUnusedLocalVariablesTest this_) {
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, null, null, null, "\n            import java.io.File;\n\n            class Test {\n                static File method(File dir) {\n                    final File src = new File(dir, \"child\") {\n                        private static final long serialVersionUID = 1L;\n                    };\n                    return src;\n                }\n            }\n        ", null, 23, null);
        }

        @Test
        public static void forLoopWithExternalIncrementLogic(@NotNull RemoveUnusedLocalVariablesTest this_) {
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, null, null, null, "\n            class Test {\n                static void method() {\n                    for (int i; ; ) {\n                        i = 41;\n                        if (i == 42) {\n                            break;\n                        }\n                    }\n                }\n            }\n        ", null, 23, null);
        }

        @Test
        public static void forLoopIncrementVariableReadInEvaluationCondition(@NotNull RemoveUnusedLocalVariablesTest this_) {
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, null, null, null, "\n            class Test {\n                static void method() {\n                    for (int j = 0; j < 10; j++) {\n                    }\n                }\n            }\n        ", null, 23, null);
        }

        @Test
        public static void removeUnusedLocalVariablesWithinTryCatch(@NotNull RemoveUnusedLocalVariablesTest this_) {
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, null, "\n            class Test {\n                static void method() {\n                    try {\n                        int a = 0;\n                        int b = 1;\n                        System.out.println(b);\n                    } catch (Exception e) {\n                        int a = 3;\n                        int b = 4;\n                        System.out.println(a);\n                    } finally {\n                        int a = 5;\n                        int b = 6;\n                    }\n                }\n            }\n        ", null, "\n            class Test {\n                static void method() {\n                    try {\n                        int b = 1;\n                        System.out.println(b);\n                    } catch (Exception e) {\n                        int a = 3;\n                        System.out.println(a);\n                    } finally {\n                    }\n                }\n            }\n        ", 0, 0, null, null, 983, null);
        }

        @Test
        public static void ignoreTryWithResourceUnusedVariables(@NotNull RemoveUnusedLocalVariablesTest this_) {
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, null, null, null, "\n            import java.util.stream.Stream;\n\n            class Test {\n                static void method() {\n                    try (Stream<Object> unused = Stream.of()) {\n                        // do nothing\n                    } catch (Exception e) {\n                        // do nothing\n                    }\n                }\n            }\n        ", null, 23, null);
        }

        @Test
        public static void handleVariablesReadWithinTry(@NotNull RemoveUnusedLocalVariablesTest this_) {
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, null, "\n            class Test {\n                static void assertEquals(Object expected, Object actual) {\n                    // do nothing\n                }\n\n                static void method() {\n                    Object used, unused;\n                    try {\n                        used = new Object();\n                        assertEquals(used, null);\n                        unused = new Object();\n                    } catch (Exception e) {\n                        // do nothing\n                    }\n                }\n            }\n        ", null, "\n            class Test {\n                static void assertEquals(Object expected, Object actual) {\n                    // do nothing\n                }\n\n                static void method() {\n                    Object used;\n                    try {\n                        used = new Object();\n                        assertEquals(used, null);\n                    } catch (Exception e) {\n                        // do nothing\n                    }\n                }\n            }\n        ", 0, 0, null, null, 983, null);
        }

        @Test
        public static void ignoreUnusedTryCatchExceptionVariableDeclaration(@NotNull RemoveUnusedLocalVariablesTest this_) {
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, null, null, null, "\n            class Test {\n                static void method() {\n                    try {\n                        // do nothing\n                    } catch (Exception e) {\n                        // do nothing\n                    }\n                }\n            }\n        ", null, 23, null);
        }

        @Test
        public static void ignoreUnusedLambdaExpressionParameters(@NotNull RemoveUnusedLocalVariablesTest this_) {
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, null, null, null, "\n            import java.util.function.BinaryOperator;\n            import java.util.function.UnaryOperator;\n\n            class Test {\n                static BinaryOperator<UnaryOperator<Object>> method() {\n                    return (a, b) -> input -> {\n                        Object o = a.apply(input);\n                        o.toString();\n                        return o;\n                    };\n                }\n            }\n        ", null, 23, null);
        }

        @Test
        public static void ignoreUnusedLambdaExpressionParametersForEach(@NotNull RemoveUnusedLocalVariablesTest this_) {
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, null, null, null, "\n            import java.util.List;\n\n            class Test {\n                static void method(List<Object> list) {\n                    list.forEach(item -> {\n                        // do nothing with \"item\"\n                    });\n                }\n            }\n        ", null, 23, null);
        }

        @Test
        public static void recognizeUsedVariableWithinWhileLoop(@NotNull RemoveUnusedLocalVariablesTest this_) {
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, null, "\n            class Test {\n                TestToken testToken;\n\n                static void method(Test tp) {\n                    int isUsed = 0;\n                    TestToken token = tp.nextToken();\n                    while ((token = tp.nextToken()) != TestToken.END_TOKEN) {\n                        // do anything except read the value of \"token\"\n                        tp.nextToken();\n                        int unused = 11;\n                        unused = isUsed;\n                        System.out.println(isUsed);\n                    }\n                }\n\n                TestToken nextToken() {\n                    return this.testToken;\n                }\n\n                enum TestToken {\n                    START_TOKEN,\n                    END_TOKEN\n                }\n            }\n        ", null, "\n            class Test {\n                TestToken testToken;\n\n                static void method(Test tp) {\n                    int isUsed = 0;\n                    TestToken token = tp.nextToken();\n                    while ((token = tp.nextToken()) != TestToken.END_TOKEN) {\n                        // do anything except read the value of \"token\"\n                        tp.nextToken();\n                        System.out.println(isUsed);\n                    }\n                }\n\n                TestToken nextToken() {\n                    return this.testToken;\n                }\n\n                enum TestToken {\n                    START_TOKEN,\n                    END_TOKEN\n                }\n            }\n        ", 0, 0, null, null, 983, null);
        }

        @Test
        public static void ignoreForLoopIncrementVariableNeverRead(@NotNull RemoveUnusedLocalVariablesTest this_) {
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, null, null, null, "\n            class Test {\n                static boolean isTrue() {\n                    return true;\n                }\n\n                static void method() {\n                    for (int j = 0; isTrue(); j++) {\n                    }\n                }\n            }\n        ", null, 23, null);
        }

        @Test
        public static void ignoreEnhancedForLoops(@NotNull RemoveUnusedLocalVariablesTest this_) {
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, null, null, null, "\n            import java.util.List;\n\n            class Test {\n                static void method(List<String> list) {\n                    for (String s : list) {\n                        // do nothing\n                    }\n                }\n            }\n        ", null, 23, null);
        }

        @Test
        public static void remove file getter methods as they do not side effect(@NotNull RemoveUnusedLocalVariablesTest this_) {
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, null, "\n            import java.io.File;\n\n            class Test {\n                static void method(File file) {\n                    String canonicalPath = file.getCanonicalPath();\n                }\n            }\n        ", null, "\n            import java.io.File;\n\n            class Test {\n                static void method(File file) {\n                }\n            }\n        ", 0, 0, null, null, 983, null);
        }

        @Test
        public static void remove file getter methods when chained as they do not side effect(@NotNull RemoveUnusedLocalVariablesTest this_) {
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, null, "\n            import java.io.File;\n\n            class Test {\n                static void method(File file) {\n                    String canonicalPath = file.getParentFile().getCanonicalPath();\n                }\n            }\n        ", null, "\n            import java.io.File;\n\n            class Test {\n                static void method(File file) {\n                }\n            }\n        ", 0, 0, null, null, 983, null);
        }

        @Test
        public static void assignmentWithinExpression(@NotNull RemoveUnusedLocalVariablesTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class A {\n                void foo() {\n                    String foo;\n                    Long.parseLong(foo = \"123\");\n                }\n            }\n        ", (String)"\n            class A {\n                void foo() {\n                    Long.parseLong(\"123\");\n                }\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @NotNull
        public static JavaParser getParser(@NotNull RemoveUnusedLocalVariablesTest this_) {
            return JavaRecipeTest.DefaultImpls.getParser(this_);
        }

        @NotNull
        public static ExecutionContext getExecutionContext(@NotNull RemoveUnusedLocalVariablesTest this_) {
            return JavaRecipeTest.DefaultImpls.getExecutionContext(this_);
        }

        @BeforeEach
        public static void beforeRecipe(@NotNull RemoveUnusedLocalVariablesTest this_) {
            JavaRecipeTest.DefaultImpls.beforeRecipe(this_);
        }

        @AfterEach
        public static void afterRecipe(@NotNull RemoveUnusedLocalVariablesTest this_) {
            JavaRecipeTest.DefaultImpls.afterRecipe(this_);
        }

        public static void assertChanged(@NotNull RemoveUnusedLocalVariablesTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super TypeValidator.ValidationOptions.Companion.Builder, Unit> typeValidation, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(typeValidation, (String)"typeValidation");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged(this_, parser, recipe2, executionContext, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, typeValidation, afterConditions);
        }

        public static void assertChanged(@NotNull RemoveUnusedLocalVariablesTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull File before, @Nullable Path relativeTo, @Language(value="java") @NotNull File[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super TypeValidator.ValidationOptions.Companion.Builder, Unit> typeValidation, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(typeValidation, (String)"typeValidation");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged(this_, parser, recipe2, executionContext, before, relativeTo, dependsOn, after, cycles, expectedCyclesThatMakeChanges, typeValidation, afterConditions);
        }

        public static void assertUnchanged(@NotNull RemoveUnusedLocalVariablesTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, parser, recipe2, executionContext, before, dependsOn);
        }

        public static void assertUnchanged(@NotNull RemoveUnusedLocalVariablesTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull File before, @Nullable Path relativeTo, @Language(value="java") @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, parser, recipe2, executionContext, before, relativeTo, dependsOn);
        }

        public static void assertChangedBase(@NotNull RemoveUnusedLocalVariablesTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull File before, @Nullable Path relativeTo, @NotNull File[] dependsOn, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase(this_, parser, recipe2, executionContext, before, relativeTo, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertChangedBase(@NotNull RemoveUnusedLocalVariablesTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull String before, @NotNull String[] dependsOn, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase(this_, parser, recipe2, executionContext, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertUnchangedBase(@NotNull RemoveUnusedLocalVariablesTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull File before, @Nullable Path relativeTo, @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchangedBase(this_, parser, recipe2, executionContext, before, relativeTo, dependsOn);
        }

        public static void assertUnchangedBase(@NotNull RemoveUnusedLocalVariablesTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull String before, @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchangedBase(this_, parser, recipe2, executionContext, before, dependsOn);
        }

        @NotNull
        public static Recipe fromRuntimeClasspath(@NotNull RemoveUnusedLocalVariablesTest this_, @NotNull String recipe2) {
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            return JavaRecipeTest.DefaultImpls.fromRuntimeClasspath(this_, recipe2);
        }

        @NotNull
        public static Recipe toRecipe(@NotNull RemoveUnusedLocalVariablesTest this_, @NotNull Function0<? extends TreeVisitor<?, ExecutionContext>> supplier) {
            Intrinsics.checkNotNullParameter(supplier, (String)"supplier");
            return JavaRecipeTest.DefaultImpls.toRecipe(this_, supplier);
        }
    }
}

