/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.io.File;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaRecipeTest;
import org.openrewrite.java.TypeValidator;
import org.openrewrite.java.cleanup.ControlFlowIndentation;
import org.openrewrite.java.tree.J;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017R\u0014\u0010\u0002\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u000f"}, d2={"Lorg/openrewrite/java/cleanup/ControlFlowIndentationTest;", "Lorg/openrewrite/java/JavaRecipeTest;", "recipe", "Lorg/openrewrite/Recipe;", "getRecipe", "()Lorg/openrewrite/Recipe;", "addsIndentationToStatementInIf", "", "jp", "Lorg/openrewrite/java/JavaParser;", "elseIf", "leavesIndentationAloneWhenBlocksAreExplicit", "removesIndentationFromStatementAfterIf", "removesIndentationFromStatementAfterIfElse", "removesIndentationFromStatementAfterLoop", "rewrite-java-tck"})
public interface ControlFlowIndentationTest
extends JavaRecipeTest {
    @NotNull
    public Recipe getRecipe();

    @Test
    public void removesIndentationFromStatementAfterIf(@NotNull JavaParser var1);

    @Test
    public void addsIndentationToStatementInIf(@NotNull JavaParser var1);

    @Test
    public void leavesIndentationAloneWhenBlocksAreExplicit(@NotNull JavaParser var1);

    @Test
    public void removesIndentationFromStatementAfterIfElse(@NotNull JavaParser var1);

    @Test
    public void elseIf(@NotNull JavaParser var1);

    @Test
    public void removesIndentationFromStatementAfterLoop(@NotNull JavaParser var1);

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @NotNull
        public static Recipe getRecipe(@NotNull ControlFlowIndentationTest this_) {
            return (Recipe)new ControlFlowIndentation();
        }

        @Test
        public static void removesIndentationFromStatementAfterIf(@NotNull ControlFlowIndentationTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, null, "\n            class A {\n                {\n                    if(true)\n                        foo();\n                        foo();\n                }\n                \n                static void foo() { \n                // There's no control flow in this method body, so its indentation should remain untouched\n                            int a = 0;\n                        }\n            }\n        ", null, "\n            class A {\n                {\n                    if(true)\n                        foo();\n                    foo();\n                }\n                \n                static void foo() { \n                // There's no control flow in this method body, so its indentation should remain untouched\n                            int a = 0;\n                        }\n            }\n        ", 0, 0, null, null, 983, null);
        }

        @Test
        public static void addsIndentationToStatementInIf(@NotNull ControlFlowIndentationTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, null, "\n            class A {\n                {\n                    if(true)\n                    foo();\n                    foo();\n                }\n                \n                static void foo(){}\n            }\n        ", null, "\n            class A {\n                {\n                    if(true)\n                        foo();\n                    foo();\n                }\n                \n                static void foo(){}\n            }\n        ", 0, 0, null, null, 983, null);
        }

        @Test
        public static void leavesIndentationAloneWhenBlocksAreExplicit(@NotNull ControlFlowIndentationTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, null, null, null, "\n            class A {\n                {\n                    if(true) {\n                        foo();\n                    } else if(true) {\n                        foo();\n                    } else {\n                        foo();\n                    }\n                        foo();\n                }\n                \n                static void foo(){}\n            }\n        ", null, 23, null);
        }

        @Test
        public static void removesIndentationFromStatementAfterIfElse(@NotNull ControlFlowIndentationTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, null, "\n            class A {\n                {\n                    if(true) {\n                        foo();\n                    } else\n                        foo();\n                        foo();\n                }\n                \n                static void foo(){}\n            }\n        ", null, "\n            class A {\n                {\n                    if(true) {\n                        foo();\n                    } else\n                        foo();\n                    foo();\n                }\n                \n                static void foo(){}\n            }\n        ", 0, 0, null, null, 983, null);
        }

        @Test
        public static void elseIf(@NotNull ControlFlowIndentationTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, null, "\n            class A {\n                {\n                    if(true){\n                        foo();\n                    } else if(false)\n                    foo();\n                    else {\n                        foo();\n                    }\n                }\n                static void foo(){}\n            }\n        ", null, "\n            class A {\n                {\n                    if(true){\n                        foo();\n                    } else if(false)\n                        foo();\n                    else {\n                        foo();\n                    }\n                }\n                static void foo(){}\n            }\n        ", 0, 0, null, null, 983, null);
        }

        @Test
        public static void removesIndentationFromStatementAfterLoop(@NotNull ControlFlowIndentationTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, null, "\n            class A {\n                {\n                    while(false)\n                        foo();\n                        foo();\n                }\n                \n                static void foo(){}\n            }\n        ", null, "\n            class A {\n                {\n                    while(false)\n                        foo();\n                    foo();\n                }\n                \n                static void foo(){}\n            }\n        ", 0, 0, null, null, 983, null);
        }

        @NotNull
        public static JavaParser getParser(@NotNull ControlFlowIndentationTest this_) {
            return JavaRecipeTest.DefaultImpls.getParser(this_);
        }

        @NotNull
        public static ExecutionContext getExecutionContext(@NotNull ControlFlowIndentationTest this_) {
            return JavaRecipeTest.DefaultImpls.getExecutionContext(this_);
        }

        @BeforeEach
        public static void beforeRecipe(@NotNull ControlFlowIndentationTest this_) {
            JavaRecipeTest.DefaultImpls.beforeRecipe(this_);
        }

        @AfterEach
        public static void afterRecipe(@NotNull ControlFlowIndentationTest this_) {
            JavaRecipeTest.DefaultImpls.afterRecipe(this_);
        }

        public static void assertChanged(@NotNull ControlFlowIndentationTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super TypeValidator.ValidationOptions.Companion.Builder, Unit> typeValidation, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(typeValidation, (String)"typeValidation");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged(this_, parser, recipe2, executionContext, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, typeValidation, afterConditions);
        }

        public static void assertChanged(@NotNull ControlFlowIndentationTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull File before, @Nullable Path relativeTo, @Language(value="java") @NotNull File[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super TypeValidator.ValidationOptions.Companion.Builder, Unit> typeValidation, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(typeValidation, (String)"typeValidation");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged(this_, parser, recipe2, executionContext, before, relativeTo, dependsOn, after, cycles, expectedCyclesThatMakeChanges, typeValidation, afterConditions);
        }

        public static void assertUnchanged(@NotNull ControlFlowIndentationTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, parser, recipe2, executionContext, before, dependsOn);
        }

        public static void assertUnchanged(@NotNull ControlFlowIndentationTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull File before, @Nullable Path relativeTo, @Language(value="java") @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, parser, recipe2, executionContext, before, relativeTo, dependsOn);
        }

        public static void assertChangedBase(@NotNull ControlFlowIndentationTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull File before, @Nullable Path relativeTo, @NotNull File[] dependsOn, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase(this_, parser, recipe2, executionContext, before, relativeTo, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertChangedBase(@NotNull ControlFlowIndentationTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull String before, @NotNull String[] dependsOn, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase(this_, parser, recipe2, executionContext, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertUnchangedBase(@NotNull ControlFlowIndentationTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull File before, @Nullable Path relativeTo, @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchangedBase(this_, parser, recipe2, executionContext, before, relativeTo, dependsOn);
        }

        public static void assertUnchangedBase(@NotNull ControlFlowIndentationTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull String before, @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchangedBase(this_, parser, recipe2, executionContext, before, dependsOn);
        }

        @NotNull
        public static Recipe fromRuntimeClasspath(@NotNull ControlFlowIndentationTest this_, @NotNull String recipe2) {
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            return JavaRecipeTest.DefaultImpls.fromRuntimeClasspath(this_, recipe2);
        }

        @NotNull
        public static Recipe toRecipe(@NotNull ControlFlowIndentationTest this_, @NotNull Function0<? extends TreeVisitor<?, ExecutionContext>> supplier) {
            Intrinsics.checkNotNullParameter(supplier, (String)"supplier");
            return JavaRecipeTest.DefaultImpls.toRecipe(this_, supplier);
        }
    }
}

