/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Check;
import com.sun.tools.javac.comp.Enter;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.comp.Todo;
import com.sun.tools.javac.file.JavacFileManager;
import com.sun.tools.javac.main.JavaCompiler;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Options;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Timer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardLocation;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.MetricsHelper;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.Java8ParserInputFileObject;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaParsingException;
import org.openrewrite.java.ReloadableJava8ParserVisitor;
import org.openrewrite.java.internal.JavaTypeCache;
import org.openrewrite.java.marker.JavaSourceSet;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.marker.Marker;
import org.openrewrite.style.NamedStyles;
import org.openrewrite.tree.ParsingEventListener;
import org.openrewrite.tree.ParsingExecutionContextView;
import org.slf4j.LoggerFactory;

class ReloadableJava8Parser
implements JavaParser {
    private String sourceSet = "main";
    private final JavaTypeCache typeCache;
    @Nullable
    private transient JavaSourceSet sourceSetProvenance;
    @Nullable
    private Collection<Path> classpath;
    @Nullable
    private final Collection<Parser.Input> dependsOn;
    private final JavacFileManager pfm;
    private final Context context;
    private final JavaCompiler compiler;
    private final ResettableLog compilerLog;
    private final Collection<NamedStyles> styles;

    ReloadableJava8Parser(@Nullable Collection<Path> classpath, Collection<byte[]> classBytesClasspath, @Nullable Collection<Parser.Input> dependsOn, Charset charset, final boolean logCompilationWarningsAndErrors, Collection<NamedStyles> styles, JavaTypeCache typeCache) {
        this.classpath = classpath;
        this.dependsOn = dependsOn;
        this.styles = styles;
        this.typeCache = typeCache;
        this.context = new Context();
        this.compilerLog = new ResettableLog(this.context);
        this.pfm = new ByteArrayCapableJavacFileManager(this.context, true, charset, classBytesClasspath);
        this.context.put(JavaFileManager.class, this.pfm);
        Options.instance(this.context).put("allowStringFolding", "false");
        Options.instance(this.context).put("compilePolicy", "attr");
        Options.instance(this.context).put("-implicit", "none");
        Options.instance(this.context).put("-g", "-g");
        Options.instance(this.context).put("-proc", "none");
        this.compiler = new JavaCompiler(this.context);
        this.compiler.genEndPos = true;
        this.compiler.keepComments = true;
        this.compiler.lineDebugInfo = false;
        this.compilerLog.setWriters(new PrintWriter(new Writer(){

            @Override
            public void write(char[] cbuf, int off, int len) {
                String log;
                if (logCompilationWarningsAndErrors && !StringUtils.isBlank((String)(log = new String(Arrays.copyOfRange(cbuf, off, len)))) && !log.contains("warning: a package-info.java file has already")) {
                    LoggerFactory.getLogger(ReloadableJava8Parser.class).warn(log);
                }
            }

            @Override
            public void flush() {
            }

            @Override
            public void close() {
            }
        }));
        this.compileDependencies();
    }

    public java.util.List<J.CompilationUnit> parseInputs(Iterable<Parser.Input> sourceFiles, @Nullable Path relativeTo, ExecutionContext ctx) {
        ParsingEventListener parsingListener = ParsingExecutionContextView.view((ExecutionContext)ctx).getParsingListener();
        if (this.classpath != null) {
            if (this.context.get(JavaFileManager.class) != this.pfm) {
                throw new IllegalStateException("JavaFileManager has been forked unexpectedly");
            }
            try {
                this.pfm.setLocation(StandardLocation.CLASS_PATH, this.classpath.stream().map(Path::toFile).collect(Collectors.toList()));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        LinkedHashMap cus = this.acceptedInputs(sourceFiles).stream().collect(Collectors.toMap(Function.identity(), input -> (JCTree.JCCompilationUnit)MetricsHelper.successTags((Timer.Builder)Timer.builder((String)"rewrite.parse").description("The time spent by the JDK in parsing and tokenizing the source file").tag("file.type", "Java").tag("step", "(1) JDK parsing")).register((MeterRegistry)Metrics.globalRegistry).record(() -> {
            try {
                return this.compiler.parse(new Java8ParserInputFileObject((Parser.Input)input));
            }
            catch (IllegalStateException e) {
                if ("endPosTable already set".equals(e.getMessage())) {
                    throw new IllegalStateException("Call reset() on JavaParser before parsing anotherset of source files that have some of the same fully qualified names", e);
                }
                throw e;
            }
        }), (e2, e1) -> e1, LinkedHashMap::new));
        try {
            this.enterAll(cus.values());
            this.compiler.attribute(new TimedTodo(this.compiler.todo));
        }
        catch (Throwable t) {
            ctx.getOnError().accept(new JavaParsingException("Failed symbol entering or attribution", t));
        }
        java.util.List mappedCus = cus.entrySet().stream().map(cuByPath -> {
            Timer.Sample sample = Timer.start();
            Parser.Input input = (Parser.Input)cuByPath.getKey();
            try {
                ReloadableJava8ParserVisitor parser = new ReloadableJava8ParserVisitor(input.getRelativePath(relativeTo), input.getSource(), this.styles, this.typeCache, ctx, this.context);
                J.CompilationUnit cu = (J.CompilationUnit)parser.scan((com.sun.source.tree.Tree)cuByPath.getValue(), Space.EMPTY);
                sample.stop(MetricsHelper.successTags((Timer.Builder)Timer.builder((String)"rewrite.parse").description("The time spent mapping the OpenJDK AST to Rewrite's AST").tag("file.type", "Java").tag("step", "(3) Map to Rewrite AST")).register((MeterRegistry)Metrics.globalRegistry));
                parsingListener.parsed(input, (SourceFile)cu);
                return cu;
            }
            catch (Throwable t) {
                sample.stop(MetricsHelper.errorTags((Timer.Builder)Timer.builder((String)"rewrite.parse").description("The time spent mapping the OpenJDK AST to Rewrite's AST").tag("file.type", "Java").tag("step", "(3) Map to Rewrite AST"), (Throwable)t).register((MeterRegistry)Metrics.globalRegistry));
                ctx.getOnError().accept(t);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
        JavaSourceSet sourceSet = this.getSourceSet(ctx);
        if (!((Boolean)ctx.getMessage("org.openrewrite.java.skipSourceSetTypeGeneration", (Object)false)).booleanValue()) {
            java.util.List classpath = sourceSet.getClasspath();
            for (J.CompilationUnit cu2 : mappedCus) {
                for (JavaType type : cu2.getTypesInUse().getTypesInUse()) {
                    if (!(type instanceof JavaType.FullyQualified)) continue;
                    classpath.add((JavaType.FullyQualified)type);
                }
            }
            this.sourceSetProvenance = sourceSet.withClasspath(classpath);
        }
        assert (this.sourceSetProvenance != null);
        return ListUtils.map(mappedCus, cu -> cu.withMarkers(cu.getMarkers().add((Marker)this.sourceSetProvenance)));
    }

    public ReloadableJava8Parser reset() {
        this.typeCache.clear();
        this.compilerLog.reset();
        this.pfm.flush();
        this.compileDependencies();
        return this;
    }

    public void setClasspath(Collection<Path> classpath) {
        this.classpath = classpath;
    }

    public void setSourceSet(String sourceSet) {
        this.sourceSetProvenance = null;
        this.sourceSet = sourceSet;
    }

    public JavaSourceSet getSourceSet(ExecutionContext ctx) {
        if (this.sourceSetProvenance == null) {
            this.sourceSetProvenance = (Boolean)ctx.getMessage("org.openrewrite.java.skipSourceSetTypeGeneration", (Object)false) != false ? new JavaSourceSet(Tree.randomId(), this.sourceSet, Collections.emptyList()) : JavaSourceSet.build((String)this.sourceSet, this.classpath == null ? Collections.emptyList() : this.classpath, (JavaTypeCache)this.typeCache, (boolean)false);
        }
        return this.sourceSetProvenance;
    }

    private void compileDependencies() {
        if (this.dependsOn != null) {
            InMemoryExecutionContext ctx = new InMemoryExecutionContext();
            ctx.putMessage("org.openrewrite.java.skipSourceSetMarker", (Object)true);
            this.parseInputs(this.dependsOn, null, (ExecutionContext)ctx);
        }
        Check.instance((Context)this.context).compiled.clear();
    }

    private void enterAll(Collection<JCTree.JCCompilationUnit> cus) {
        Enter enter = Enter.instance(this.context);
        List<JCTree.JCCompilationUnit> compilationUnits = List.from(cus.toArray(new JCTree.JCCompilationUnit[0]));
        enter.main(compilationUnits);
    }

    private static class PackageAwareJavaFileObject
    extends SimpleJavaFileObject {
        private final String pkg;
        private final String className;
        private final byte[] classBytes;

        private PackageAwareJavaFileObject(byte[] classBytes) {
            super(URI.create("file:///.byteArray"), JavaFileObject.Kind.CLASS);
            final AtomicReference pkgRef = new AtomicReference();
            final AtomicReference nameRef = new AtomicReference();
            ClassReader classReader = new ClassReader(classBytes);
            classReader.accept(new ClassVisitor(589824){

                public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                    if (name.contains("/")) {
                        pkgRef.set(name.substring(0, name.lastIndexOf(47)).replace('/', '.'));
                        nameRef.set(name.substring(name.lastIndexOf(47) + 1));
                    } else {
                        pkgRef.set(name);
                        nameRef.set(name);
                    }
                }
            }, 7);
            this.pkg = (String)pkgRef.get();
            this.className = (String)nameRef.get();
            this.classBytes = classBytes;
        }

        public String getPackage() {
            return this.pkg;
        }

        public String getClassName() {
            return this.className;
        }

        @Override
        public InputStream openInputStream() {
            return new ByteArrayInputStream(this.classBytes);
        }
    }

    private static class ByteArrayCapableJavacFileManager
    extends JavacFileManager {
        private final java.util.List<PackageAwareJavaFileObject> classByteClasspath;

        public ByteArrayCapableJavacFileManager(Context context, boolean register, Charset charset, Collection<byte[]> classByteClasspath) {
            super(context, register, charset);
            this.classByteClasspath = classByteClasspath.stream().map(x$0 -> new PackageAwareJavaFileObject((byte[])x$0)).collect(Collectors.toList());
        }

        @Override
        public boolean isSameFile(FileObject fileObject, FileObject fileObject1) {
            return fileObject.equals(fileObject1);
        }

        @Override
        public String inferBinaryName(JavaFileManager.Location location, JavaFileObject file) {
            if (file instanceof PackageAwareJavaFileObject) {
                return ((PackageAwareJavaFileObject)file).getClassName();
            }
            return super.inferBinaryName(location, file);
        }

        @Override
        public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
            if (StandardLocation.CLASS_PATH.equals(location)) {
                Iterable<JavaFileObject> listed = super.list(location, packageName, kinds, recurse);
                return Stream.concat(this.classByteClasspath.stream().filter(jfo -> jfo.getPackage().equals(packageName)), StreamSupport.stream(listed.spliterator(), false)).collect(Collectors.toList());
            }
            return super.list(location, packageName, kinds, recurse);
        }
    }

    private static class TimedTodo
    extends Todo {
        private final Todo todo;
        @Nullable
        private Timer.Sample sample;

        private TimedTodo(Todo todo) {
            super(new Context());
            this.todo = todo;
        }

        @Override
        public boolean isEmpty() {
            if (this.sample != null) {
                this.sample.stop(MetricsHelper.successTags((Timer.Builder)Timer.builder((String)"rewrite.parse").description("The time spent by the JDK in type attributing the source file").tag("file.type", "Java").tag("step", "(2) Type attribution")).register((MeterRegistry)Metrics.globalRegistry));
            }
            return this.todo.isEmpty();
        }

        @Override
        public Env<AttrContext> remove() {
            this.sample = Timer.start();
            return (Env)this.todo.remove();
        }
    }

    private static class ResettableLog
    extends Log {
        protected ResettableLog(Context context) {
            super(context);
        }

        public void reset() {
            this.sourceMap.clear();
        }
    }
}

