/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.isolated;

import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.BoundKind;
import com.sun.tools.javac.code.Kinds;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.stream.Collectors;
import javax.lang.model.type.NullType;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaTypeMapping;
import org.openrewrite.java.internal.JavaTypeCache;
import org.openrewrite.java.isolated.ReloadableJava21TypeSignatureBuilder;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

class ReloadableJava21TypeMapping
implements JavaTypeMapping<Tree> {
    private final ReloadableJava21TypeSignatureBuilder signatureBuilder = new ReloadableJava21TypeSignatureBuilder();
    private final JavaTypeCache typeCache;

    public JavaType type(@Nullable Type type) {
        if (type == null || type instanceof Type.ErrorType || type instanceof Type.PackageType || type instanceof Type.UnknownType || type instanceof NullType) {
            return JavaType.Unknown.getInstance();
        }
        String signature = this.signatureBuilder.signature((Object)type);
        JavaType existing = (JavaType)this.typeCache.get(signature);
        if (existing != null) {
            return existing;
        }
        if (type instanceof Type.ClassType) {
            return this.classType((Type.ClassType)type, signature);
        }
        if (type instanceof Type.TypeVar) {
            return this.generic((Type.TypeVar)type, signature);
        }
        if (type instanceof Type.JCPrimitiveType) {
            return this.primitive(type.getTag());
        }
        if (type instanceof Type.JCVoidType) {
            return JavaType.Primitive.Void;
        }
        if (type instanceof Type.ArrayType) {
            return this.array(type, signature);
        }
        if (type instanceof Type.WildcardType) {
            return this.generic((Type.WildcardType)type, signature);
        }
        if (type instanceof Type.JCNoType) {
            return JavaType.Unknown.getInstance();
        }
        throw new UnsupportedOperationException("Unknown type " + type.getClass().getName());
    }

    private JavaType array(Type type, String signature) {
        JavaType.Array arr = new JavaType.Array(null, null);
        this.typeCache.put(signature, (Object)arr);
        arr.unsafeSet(this.type(((Type.ArrayType)type).elemtype));
        return arr;
    }

    private JavaType.GenericTypeVariable generic(Type.WildcardType wildcard, String signature) {
        JavaType.GenericTypeVariable.Variance variance;
        JavaType.GenericTypeVariable gtv = new JavaType.GenericTypeVariable(null, "?", JavaType.GenericTypeVariable.Variance.INVARIANT, null);
        this.typeCache.put(signature, (Object)gtv);
        java.util.List<JavaType> bounds = switch (wildcard.kind) {
            case BoundKind.SUPER -> {
                variance = JavaType.GenericTypeVariable.Variance.CONTRAVARIANT;
                yield Collections.singletonList(this.type(wildcard.getSuperBound()));
            }
            case BoundKind.EXTENDS -> {
                variance = JavaType.GenericTypeVariable.Variance.COVARIANT;
                yield Collections.singletonList(this.type(wildcard.getExtendsBound()));
            }
            default -> {
                variance = JavaType.GenericTypeVariable.Variance.INVARIANT;
                yield null;
            }
        };
        if (bounds != null && bounds.get(0) instanceof JavaType.FullyQualified && "java.lang.Object".equals(((JavaType.FullyQualified)bounds.get(0)).getFullyQualifiedName())) {
            bounds = null;
        }
        gtv.unsafeSet(gtv.getName(), variance, bounds);
        return gtv;
    }

    private JavaType generic(Type.TypeVar type, String signature) {
        JavaType mappedBound;
        String name = type.tsym.name.toString();
        JavaType.GenericTypeVariable gtv = new JavaType.GenericTypeVariable(null, name, JavaType.GenericTypeVariable.Variance.INVARIANT, null);
        this.typeCache.put(signature, (Object)gtv);
        java.util.List<JavaType> bounds = null;
        if (type.getUpperBound() instanceof Type.IntersectionClassType) {
            Type.IntersectionClassType intersectionBound = (Type.IntersectionClassType)type.getUpperBound();
            boolean isIntersectionSuperType = !intersectionBound.supertype_field.tsym.getQualifiedName().toString().equals("java.lang.Object");
            bounds = new ArrayList<JavaType>((isIntersectionSuperType ? 1 : 0) + intersectionBound.interfaces_field.length());
            if (isIntersectionSuperType) {
                bounds.add(this.type(intersectionBound.supertype_field));
            }
            for (Type bound : intersectionBound.interfaces_field) {
                bounds.add(this.type(bound));
            }
        } else if (!(type.getUpperBound() == null || (mappedBound = this.type(type.getUpperBound())) instanceof JavaType.FullyQualified && "java.lang.Object".equals(((JavaType.FullyQualified)mappedBound).getFullyQualifiedName()))) {
            bounds = Collections.singletonList(mappedBound);
        }
        gtv.unsafeSet(gtv.getName(), bounds == null ? JavaType.GenericTypeVariable.Variance.INVARIANT : JavaType.GenericTypeVariable.Variance.COVARIANT, bounds);
        return gtv;
    }

    private JavaType.FullyQualified classType(Type.ClassType classType, String signature) {
        Symbol.ClassSymbol sym = (Symbol.ClassSymbol)classType.tsym;
        Type.ClassType symType = (Type.ClassType)sym.type;
        String fqn = sym.flatName().toString();
        JavaType.FullyQualified fq = (JavaType.FullyQualified)this.typeCache.get(fqn);
        JavaType.Class clazz = (JavaType.Class)(fq instanceof JavaType.Parameterized ? ((JavaType.Parameterized)fq).getType() : fq);
        if (clazz == null) {
            if (!sym.completer.isTerminal()) {
                this.completeClassSymbol(sym);
            }
            clazz = new JavaType.Class(null, sym.flags_field, fqn, this.getKind(sym), null, null, null, null, null, null, null);
            this.typeCache.put(fqn, (Object)clazz);
            JavaType.FullyQualified supertype = TypeUtils.asFullyQualified((JavaType)this.type(symType.supertype_field));
            JavaType.FullyQualified owner = null;
            if (sym.owner instanceof Symbol.ClassSymbol) {
                owner = TypeUtils.asFullyQualified((JavaType)this.type(sym.owner.type));
            }
            ArrayList<JavaType.FullyQualified> interfaces = null;
            if (symType.interfaces_field != null) {
                interfaces = new ArrayList<JavaType.FullyQualified>(symType.interfaces_field.length());
                for (Type iParam : symType.interfaces_field) {
                    JavaType.FullyQualified javaType = TypeUtils.asFullyQualified((JavaType)this.type(iParam));
                    if (javaType == null) continue;
                    interfaces.add(javaType);
                }
            }
            ArrayList<JavaType.Variable> fields = null;
            ArrayList<JavaType.Method> methods = null;
            if (sym.members_field != null) {
                for (Symbol elem : sym.members_field.getSymbols()) {
                    Symbol.MethodSymbol methodSymbol;
                    if (elem instanceof Symbol.VarSymbol && (elem.flags_field & 0x30A0001000L) == 0L) {
                        if (fqn.equals("java.lang.String") && elem.name.toString().equals("serialPersistentFields")) continue;
                        if (fields == null) {
                            fields = new ArrayList<JavaType.Variable>();
                        }
                        fields.add(this.variableType(elem, (JavaType.FullyQualified)clazz));
                        continue;
                    }
                    if (!(elem instanceof Symbol.MethodSymbol) || (elem.flags_field & 0x20A0001000L) != 0L) continue;
                    if (methods == null) {
                        methods = new ArrayList<JavaType.Method>();
                    }
                    if ((methodSymbol = (Symbol.MethodSymbol)elem).isStaticOrInstanceInit()) continue;
                    methods.add(this.methodDeclarationType(methodSymbol, (JavaType.FullyQualified)clazz));
                }
            }
            ArrayList<JavaType> typeParameters = null;
            if (symType.typarams_field != null && symType.typarams_field.length() > 0) {
                typeParameters = new ArrayList<JavaType>(symType.typarams_field.length());
                for (Type tParam : symType.typarams_field) {
                    typeParameters.add(this.type(tParam));
                }
            }
            clazz.unsafeSet(typeParameters, supertype, owner, this.listAnnotations(sym), interfaces, fields, methods);
        }
        if (classType.typarams_field != null && classType.typarams_field.length() > 0) {
            JavaType.Parameterized pt = (JavaType.Parameterized)this.typeCache.get(signature);
            if (pt == null) {
                pt = new JavaType.Parameterized(null, null, null);
                this.typeCache.put(signature, (Object)pt);
                ArrayList<JavaType> typeParameters = new ArrayList<JavaType>(classType.typarams_field.length());
                for (Type tParam : classType.typarams_field) {
                    typeParameters.add(this.type(tParam));
                }
                pt.unsafeSet((JavaType.FullyQualified)clazz, typeParameters);
            }
            return pt;
        }
        return clazz;
    }

    private JavaType.FullyQualified.Kind getKind(Symbol.ClassSymbol sym) {
        switch (sym.getKind()) {
            case ENUM: {
                return JavaType.FullyQualified.Kind.Enum;
            }
            case ANNOTATION_TYPE: {
                return JavaType.FullyQualified.Kind.Annotation;
            }
            case INTERFACE: {
                return JavaType.FullyQualified.Kind.Interface;
            }
            case RECORD: {
                return JavaType.FullyQualified.Kind.Record;
            }
        }
        return JavaType.FullyQualified.Kind.Class;
    }

    public JavaType type(@Nullable Tree tree) {
        if (tree == null) {
            return null;
        }
        Symbol symbol = null;
        if (tree instanceof JCTree.JCIdent) {
            symbol = ((JCTree.JCIdent)tree).sym;
        } else if (tree instanceof JCTree.JCMethodDecl) {
            symbol = ((JCTree.JCMethodDecl)tree).sym;
        } else if (tree instanceof JCTree.JCVariableDecl) {
            return this.variableType(((JCTree.JCVariableDecl)tree).sym);
        }
        return this.type(((JCTree)tree).type, symbol);
    }

    @Nullable
    private JavaType type(Type type, Symbol symbol) {
        if (type instanceof Type.MethodType) {
            return this.methodInvocationType(type, symbol);
        }
        return this.type(type);
    }

    public JavaType.Primitive primitive(TypeTag tag) {
        switch (tag) {
            case BOOLEAN: {
                return JavaType.Primitive.Boolean;
            }
            case BYTE: {
                return JavaType.Primitive.Byte;
            }
            case CHAR: {
                return JavaType.Primitive.Char;
            }
            case DOUBLE: {
                return JavaType.Primitive.Double;
            }
            case FLOAT: {
                return JavaType.Primitive.Float;
            }
            case INT: {
                return JavaType.Primitive.Int;
            }
            case LONG: {
                return JavaType.Primitive.Long;
            }
            case SHORT: {
                return JavaType.Primitive.Short;
            }
            case VOID: {
                return JavaType.Primitive.Void;
            }
            case NONE: {
                return JavaType.Primitive.None;
            }
            case CLASS: {
                return JavaType.Primitive.String;
            }
            case BOT: {
                return JavaType.Primitive.Null;
            }
        }
        throw new IllegalArgumentException("Unknown type tag " + String.valueOf((Object)tag));
    }

    @Nullable
    public JavaType.Variable variableType(@Nullable Symbol symbol) {
        return this.variableType(symbol, null);
    }

    @Nullable
    private JavaType.Variable variableType(@Nullable Symbol symbol, @Nullable JavaType.FullyQualified owner) {
        if (!(symbol instanceof Symbol.VarSymbol)) {
            return null;
        }
        String signature = this.signatureBuilder.variableSignature(symbol);
        JavaType.Variable existing = (JavaType.Variable)this.typeCache.get(signature);
        if (existing != null) {
            return existing;
        }
        JavaType.Variable variable = new JavaType.Variable(null, symbol.flags_field, symbol.name.toString(), null, null, null);
        this.typeCache.put(signature, (Object)variable);
        JavaType.FullyQualified resolvedOwner = owner;
        if (owner == null) {
            Type type = symbol.owner.type;
            Symbol sym = symbol.owner;
            if (sym.type instanceof Type.ForAll) {
                type = ((Type.ForAll)type).qtype;
            }
            Object object = resolvedOwner = type instanceof Type.MethodType ? this.methodInvocationType(type, sym) : this.type(type);
            assert (resolvedOwner != null);
        }
        variable.unsafeSet((JavaType)resolvedOwner, this.type(symbol.type), this.listAnnotations(symbol));
        return variable;
    }

    @Nullable
    public JavaType.Method methodInvocationType(@Nullable Type selectType, @Nullable Symbol symbol) {
        JavaType.FullyQualified resolvedDeclaringType;
        if (selectType == null || selectType instanceof Type.ErrorType || symbol == null || symbol.kind == Kinds.Kind.ERR || symbol.type instanceof Type.UnknownType) {
            return null;
        }
        Symbol.MethodSymbol methodSymbol = (Symbol.MethodSymbol)symbol;
        if (selectType instanceof Type.ForAll) {
            Type.ForAll fa = (Type.ForAll)selectType;
            return this.methodInvocationType(fa.qtype, methodSymbol);
        }
        String signature = this.signatureBuilder.methodSignature(selectType, methodSymbol);
        JavaType.Method existing = (JavaType.Method)this.typeCache.get(signature);
        if (existing != null) {
            return existing;
        }
        String[] paramNames = null;
        if (!methodSymbol.params().isEmpty()) {
            paramNames = new String[methodSymbol.params().size()];
            List<Symbol.VarSymbol> params = methodSymbol.params();
            for (int i = 0; i < params.size(); ++i) {
                String s;
                Symbol.VarSymbol p = params.get(i);
                paramNames[i] = s = p.name.toString();
            }
        }
        JavaType.Method method = new JavaType.Method(null, methodSymbol.flags_field, null, methodSymbol.isConstructor() ? "<constructor>" : ((Name)methodSymbol.getSimpleName()).toString(), null, paramNames, null, null, null, null);
        this.typeCache.put(signature, (Object)method);
        JavaType.Unknown returnType = null;
        ArrayList<JavaType> parameterTypes = null;
        ArrayList<JavaType> exceptionTypes = null;
        if (selectType instanceof Type.MethodType) {
            JavaType javaType;
            Type.MethodType methodType = (Type.MethodType)selectType;
            if (!methodType.argtypes.isEmpty()) {
                parameterTypes = new ArrayList<JavaType>(methodType.argtypes.size());
                for (Type argtype : methodType.argtypes) {
                    if (argtype == null) continue;
                    javaType = this.type(argtype);
                    parameterTypes.add(javaType);
                }
            }
            returnType = this.type(methodType.restype);
            if (!methodType.thrown.isEmpty()) {
                exceptionTypes = new ArrayList<JavaType>(methodType.thrown.size());
                for (Type exceptionType : methodType.thrown) {
                    javaType = TypeUtils.asFullyQualified((JavaType)this.type(exceptionType));
                    if (javaType == null && exceptionType instanceof Type.ClassType) {
                        Symbol.ClassSymbol sym = (Symbol.ClassSymbol)exceptionType.tsym;
                        javaType = new JavaType.Class(null, Flag.Public.getBitMask(), sym.flatName().toString(), JavaType.FullyQualified.Kind.Class, null, null, null, null, null, null, null);
                    }
                    if (javaType == null) continue;
                    exceptionTypes.add(javaType);
                }
            }
        } else if (selectType instanceof Type.UnknownType) {
            returnType = JavaType.Unknown.getInstance();
        }
        if ((resolvedDeclaringType = TypeUtils.asFullyQualified((JavaType)this.type(methodSymbol.owner.type))) == null) {
            return null;
        }
        assert (returnType != null);
        method.unsafeSet(resolvedDeclaringType, (JavaType)(methodSymbol.isConstructor() ? resolvedDeclaringType : returnType), parameterTypes, exceptionTypes, this.listAnnotations(methodSymbol));
        return method;
    }

    @Nullable
    public JavaType.Method methodDeclarationType(@Nullable Symbol symbol, @Nullable JavaType.FullyQualified declaringType) {
        Symbol.MethodSymbol methodSymbol;
        Symbol.MethodSymbol methodSymbol2 = methodSymbol = symbol instanceof Symbol.MethodSymbol ? (Symbol.MethodSymbol)symbol : null;
        if (methodSymbol != null) {
            Type.MethodType mt;
            String signature = this.signatureBuilder.methodSignature(methodSymbol);
            JavaType.Method existing = (JavaType.Method)this.typeCache.get(signature);
            if (existing != null) {
                return existing;
            }
            String[] paramNames = null;
            if (!methodSymbol.params().isEmpty()) {
                paramNames = new String[methodSymbol.params().size()];
                List<Symbol.VarSymbol> params = methodSymbol.params();
                for (int i = 0; i < params.size(); ++i) {
                    String s;
                    Symbol.VarSymbol p = params.get(i);
                    paramNames[i] = s = p.name.toString();
                }
            }
            java.util.List<String> defaultValues = null;
            if (methodSymbol.getDefaultValue() != null) {
                defaultValues = methodSymbol.getDefaultValue() instanceof Attribute.Array ? ((Attribute.Array)methodSymbol.getDefaultValue()).getValue().stream().map(attr -> attr.getValue().toString()).collect(Collectors.toList()) : Collections.singletonList(methodSymbol.getDefaultValue().getValue().toString());
            }
            JavaType.Method method = new JavaType.Method(null, methodSymbol.flags_field, null, methodSymbol.isConstructor() ? "<constructor>" : ((Name)methodSymbol.getSimpleName()).toString(), null, paramNames, null, null, null, defaultValues);
            this.typeCache.put(signature, (Object)method);
            Type signatureType = methodSymbol.type instanceof Type.ForAll ? ((Type.ForAll)methodSymbol.type).qtype : methodSymbol.type;
            ArrayList<JavaType.FullyQualified> exceptionTypes = null;
            Type selectType = methodSymbol.type;
            if (selectType instanceof Type.ForAll) {
                selectType = ((Type.ForAll)selectType).qtype;
            }
            if (selectType instanceof Type.MethodType) {
                Type.MethodType methodType = (Type.MethodType)selectType;
                if (!methodType.thrown.isEmpty()) {
                    exceptionTypes = new ArrayList<JavaType.FullyQualified>(methodType.thrown.size());
                    for (Type exceptionType : methodType.thrown) {
                        JavaType.FullyQualified javaType = TypeUtils.asFullyQualified((JavaType)this.type(exceptionType));
                        if (javaType == null && exceptionType instanceof Type.ClassType) {
                            Symbol.ClassSymbol sym = (Symbol.ClassSymbol)exceptionType.tsym;
                            javaType = new JavaType.Class(null, Flag.Public.getBitMask(), sym.flatName().toString(), JavaType.FullyQualified.Kind.Class, null, null, null, null, null, null, null);
                        }
                        if (javaType == null) continue;
                        exceptionTypes.add(javaType);
                    }
                }
            }
            JavaType.FullyQualified resolvedDeclaringType = declaringType;
            if (declaringType == null && (methodSymbol.owner instanceof Symbol.ClassSymbol || methodSymbol.owner instanceof Symbol.TypeVariableSymbol)) {
                resolvedDeclaringType = TypeUtils.asFullyQualified((JavaType)this.type(methodSymbol.owner.type));
            }
            if (resolvedDeclaringType == null) {
                return null;
            }
            ArrayList<JavaType> parameterTypes = null;
            if (signatureType instanceof Type.ForAll) {
                signatureType = ((Type.ForAll)signatureType).qtype;
            }
            if (signatureType instanceof Type.MethodType) {
                mt = (Type.MethodType)signatureType;
                if (!mt.argtypes.isEmpty()) {
                    parameterTypes = new ArrayList<JavaType>(mt.argtypes.size());
                    for (Type argtype : mt.argtypes) {
                        if (argtype == null) continue;
                        JavaType javaType = this.type(argtype);
                        parameterTypes.add(javaType);
                    }
                }
            } else {
                throw new UnsupportedOperationException("Unexpected method signature type" + signatureType.getClass().getName());
            }
            JavaType returnType = this.type(mt.restype);
            method.unsafeSet(resolvedDeclaringType, (JavaType)(methodSymbol.isConstructor() ? resolvedDeclaringType : returnType), parameterTypes, exceptionTypes, this.listAnnotations(methodSymbol));
            return method;
        }
        return null;
    }

    private void completeClassSymbol(Symbol.ClassSymbol classSymbol) {
        try {
            classSymbol.complete();
        }
        catch (Symbol.CompletionFailure completionFailure) {
            // empty catch block
        }
    }

    @Nullable
    private java.util.List<JavaType.FullyQualified> listAnnotations(Symbol symb) {
        ArrayList<JavaType.FullyQualified> annotations = null;
        if (!symb.getDeclarationAttributes().isEmpty()) {
            annotations = new ArrayList<JavaType.FullyQualified>(symb.getDeclarationAttributes().size());
            for (Attribute.Compound a : symb.getDeclarationAttributes()) {
                Retention retention;
                JavaType.FullyQualified annotType = TypeUtils.asFullyQualified((JavaType)this.type(a.type));
                if (annotType == null || (retention = a.getAnnotationType().asElement().getAnnotation(Retention.class)) != null && retention.value() == RetentionPolicy.SOURCE) continue;
                annotations.add(annotType);
            }
        }
        return annotations;
    }

    public ReloadableJava21TypeMapping(JavaTypeCache typeCache) {
        this.typeCache = typeCache;
    }
}

