/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import com.sun.source.tree.Tree;
import com.sun.tools.javac.comp.Annotate;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Check;
import com.sun.tools.javac.comp.Enter;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.comp.Modules;
import com.sun.tools.javac.comp.Todo;
import com.sun.tools.javac.file.JavacFileManager;
import com.sun.tools.javac.main.JavaCompiler;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Options;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Timer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardLocation;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.internal.MetricsHelper;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNullApi;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.Java11ParserInputFileObject;
import org.openrewrite.java.Java11ParserVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaParsingException;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Space;
import org.openrewrite.style.NamedStyles;
import org.slf4j.LoggerFactory;

@NonNullApi
public class Java11Parser
implements JavaParser {
    @Nullable
    private Collection<Path> classpath;
    @Nullable
    private final Collection<Parser.Input> dependsOn;
    private final boolean relaxedClassTypeMatching;
    private final JavacFileManager pfm;
    private final Context context;
    private final JavaCompiler compiler;
    private final ResettableLog compilerLog;
    private final Collection<NamedStyles> styles;

    private Java11Parser(@Nullable Collection<Path> classpath, Collection<byte[]> classBytesClasspath, @Nullable Collection<Parser.Input> dependsOn, Charset charset, boolean relaxedClassTypeMatching, final boolean logCompilationWarningsAndErrors, Collection<NamedStyles> styles) {
        this.classpath = classpath;
        this.dependsOn = dependsOn;
        this.relaxedClassTypeMatching = relaxedClassTypeMatching;
        this.styles = styles;
        this.context = new Context();
        this.compilerLog = new ResettableLog(this.context);
        this.pfm = new ByteArrayCapableJavacFileManager(this.context, true, charset, classBytesClasspath);
        Options.instance(this.context).put("allowStringFolding", "false");
        Options.instance(this.context).put("compilePolicy", "attr");
        Options.instance(this.context).put("-implicit", "none");
        Options.instance(this.context).put("-g", "-g");
        Options.instance(this.context).put("-proc", "none");
        new TimedTodo(this.context);
        this.compiler = new JavaCompiler(this.context);
        this.compiler.genEndPos = true;
        this.compiler.keepComments = false;
        this.compiler.lineDebugInfo = false;
        this.compilerLog.setWriters(new PrintWriter(new Writer(){

            @Override
            public void write(char[] cbuf, int off, int len) {
                String log;
                if (logCompilationWarningsAndErrors && !(log = new String(Arrays.copyOfRange(cbuf, off, len))).isBlank()) {
                    LoggerFactory.getLogger(Java11Parser.class).warn(log);
                }
            }

            @Override
            public void flush() {
            }

            @Override
            public void close() {
            }
        }));
        this.compileDependencies();
    }

    public static Builder builder() {
        return new Builder();
    }

    public java.util.List<J.CompilationUnit> parseInputs(Iterable<Parser.Input> sourceFiles, @Nullable Path relativeTo, ExecutionContext ctx) {
        if (this.classpath != null) {
            if (this.context.get(JavaFileManager.class) != this.pfm) {
                throw new IllegalStateException("JavaFileManager has been forked unexpectedly");
            }
            try {
                this.pfm.setLocationFromPaths(StandardLocation.CLASS_PATH, new ArrayList<Path>(this.classpath));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        LinkedHashMap<Parser.Input, JCTree.JCCompilationUnit> cus = new LinkedHashMap<Parser.Input, JCTree.JCCompilationUnit>();
        for (Parser.Input input1 : this.acceptedInputs(sourceFiles)) {
            cus.put(input1, (JCTree.JCCompilationUnit)MetricsHelper.successTags((Timer.Builder)Timer.builder((String)"rewrite.parse").description("The time spent by the JDK in parsing and tokenizing the source file").tag("file.type", "Java").tag("step", "(1) JDK parsing")).register((MeterRegistry)Metrics.globalRegistry).record(() -> {
                try {
                    return this.compiler.parse(new Java11ParserInputFileObject(input1));
                }
                catch (IllegalStateException e) {
                    if (e.getMessage().equals("endPosTable already set")) {
                        throw new IllegalStateException("Call reset() on JavaParser before parsing anotherset of source files that have some of the same fully qualified names", e);
                    }
                    throw e;
                }
            }));
        }
        try {
            this.initModules(cus.values());
            this.enterAll(cus.values());
            Annotate annotate = Annotate.instance(this.context);
            while (annotate.annotationsBlocked()) {
                annotate.unblockAnnotations();
            }
            this.compiler.attribute(this.compiler.todo);
        }
        catch (Throwable t) {
            ctx.getOnError().accept(new JavaParsingException("Failed symbol entering or attribution", t));
        }
        HashMap sharedClassTypes = new HashMap();
        return cus.entrySet().stream().map(cuByPath -> {
            Timer.Sample sample = Timer.start();
            Parser.Input input = (Parser.Input)cuByPath.getKey();
            try {
                Java11ParserVisitor parser = new Java11ParserVisitor(input.getRelativePath(relativeTo), StringUtils.readFully((InputStream)input.getSource()), this.relaxedClassTypeMatching, this.styles, sharedClassTypes, ctx);
                J.CompilationUnit cu = (J.CompilationUnit)parser.scan((Tree)cuByPath.getValue(), Space.EMPTY);
                sample.stop(MetricsHelper.successTags((Timer.Builder)Timer.builder((String)"rewrite.parse").description("The time spent mapping the OpenJDK AST to Rewrite's AST").tag("file.type", "Java").tag("step", "(3) Map to Rewrite AST")).register((MeterRegistry)Metrics.globalRegistry));
                return cu;
            }
            catch (Throwable t) {
                sample.stop(MetricsHelper.errorTags((Timer.Builder)Timer.builder((String)"rewrite.parse").description("The time spent mapping the OpenJDK AST to Rewrite's AST").tag("file.type", "Java").tag("step", "(3) Map to Rewrite AST"), (Throwable)t).register((MeterRegistry)Metrics.globalRegistry));
                ctx.getOnError().accept(t);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public Java11Parser reset() {
        this.compilerLog.reset();
        this.pfm.flush();
        Check.instance(this.context).newRound();
        Annotate.instance(this.context).newRound();
        Enter.instance(this.context).newRound();
        Modules.instance(this.context).newRound();
        this.compileDependencies();
        return this;
    }

    public void setClasspath(Collection<Path> classpath) {
        this.classpath = classpath;
    }

    private void compileDependencies() {
        if (this.dependsOn != null) {
            this.parseInputs(this.dependsOn, null, (ExecutionContext)new InMemoryExecutionContext());
        }
        Modules.instance(this.context).newRound();
    }

    private void initModules(Collection<JCTree.JCCompilationUnit> cus) {
        Modules modules = Modules.instance(this.context);
        modules.newRound();
        modules.initModules(List.from(cus));
    }

    private void enterAll(Collection<JCTree.JCCompilationUnit> cus) {
        Enter enter = Enter.instance(this.context);
        List<JCTree.JCCompilationUnit> compilationUnits = List.from((JCTree.JCCompilationUnit[])cus.toArray(JCTree.JCCompilationUnit[]::new));
        enter.main(compilationUnits);
    }

    private static class PackageAwareJavaFileObject
    extends SimpleJavaFileObject {
        private final String pkg;
        private final String className;
        private final byte[] classBytes;

        private PackageAwareJavaFileObject(byte[] classBytes) {
            super(URI.create("dontCare"), JavaFileObject.Kind.CLASS);
            final AtomicReference pkgRef = new AtomicReference();
            final AtomicReference nameRef = new AtomicReference();
            ClassReader classReader = new ClassReader(classBytes);
            classReader.accept(new ClassVisitor(589824){

                public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                    if (name.contains("/")) {
                        pkgRef.set(name.substring(0, name.lastIndexOf(47)).replace('/', '.'));
                        nameRef.set(name.substring(name.lastIndexOf(47) + 1));
                    } else {
                        pkgRef.set(name);
                        nameRef.set(name);
                    }
                }
            }, 7);
            this.pkg = (String)pkgRef.get();
            this.className = (String)nameRef.get();
            this.classBytes = classBytes;
        }

        public String getPackage() {
            return this.pkg;
        }

        public String getClassName() {
            return this.className;
        }

        @Override
        public InputStream openInputStream() {
            return new ByteArrayInputStream(this.classBytes);
        }
    }

    private static class ByteArrayCapableJavacFileManager
    extends JavacFileManager {
        private final java.util.List<PackageAwareJavaFileObject> classByteClasspath;

        public ByteArrayCapableJavacFileManager(Context context, boolean register, Charset charset, Collection<byte[]> classByteClasspath) {
            super(context, register, charset);
            this.classByteClasspath = classByteClasspath.stream().map(x$0 -> new PackageAwareJavaFileObject((byte[])x$0)).collect(Collectors.toList());
        }

        @Override
        public String inferBinaryName(JavaFileManager.Location location, JavaFileObject file) {
            if (file instanceof PackageAwareJavaFileObject) {
                return ((PackageAwareJavaFileObject)file).getClassName();
            }
            return super.inferBinaryName(location, file);
        }

        @Override
        public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
            if (StandardLocation.CLASS_PATH.equals(location)) {
                Iterable<JavaFileObject> listed = super.list(location, packageName, kinds, recurse);
                return Stream.concat(this.classByteClasspath.stream().filter(jfo -> jfo.getPackage().equals(packageName)), StreamSupport.stream(listed.spliterator(), false)).collect(Collectors.toList());
            }
            return super.list(location, packageName, kinds, recurse);
        }
    }

    public static class Builder
    extends JavaParser.Builder<Java11Parser, Builder> {
        public Java11Parser build() {
            return new Java11Parser(this.classpath, this.classBytesClasspath, this.dependsOn, this.charset, this.relaxedClassTypeMatching, this.logCompilationWarningsAndErrors, this.styles);
        }
    }

    private static class TimedTodo
    extends Todo {
        @Nullable
        private Timer.Sample sample;

        private TimedTodo(Context context) {
            super(context);
        }

        @Override
        public boolean isEmpty() {
            if (this.sample != null) {
                this.sample.stop(MetricsHelper.successTags((Timer.Builder)Timer.builder((String)"rewrite.parse").description("The time spent by the JDK in type attributing the source file").tag("file.type", "Java").tag("step", "(2) Type attribution")).register((MeterRegistry)Metrics.globalRegistry));
            }
            return super.isEmpty();
        }

        @Override
        public Env<AttrContext> remove() {
            this.sample = Timer.start();
            return (Env)super.remove();
        }
    }

    private static class ResettableLog
    extends Log {
        protected ResettableLog(Context context) {
            super(context);
        }

        public void reset() {
            this.sourceMap.clear();
        }
    }
}

