/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import com.sun.source.tree.AnnotatedTypeTree;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.ArrayTypeTree;
import com.sun.source.tree.AssertTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.BreakTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.ContinueTree;
import com.sun.source.tree.DoWhileLoopTree;
import com.sun.source.tree.EmptyStatementTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.LabeledStatementTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.PrimitiveTypeTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.SwitchTree;
import com.sun.source.tree.SynchronizedTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.UnionTypeTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.tree.WhileLoopTree;
import com.sun.source.tree.WildcardTree;
import com.sun.source.util.TreePathScanner;
import com.sun.tools.javac.code.Flags;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.tree.EndPosTable;
import com.sun.tools.javac.tree.JCTree;
import java.lang.reflect.Field;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import org.openrewrite.Formatting;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaStyle;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.NameTree;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TreeBuilder;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Java11ParserVisitor
extends TreePathScanner<J, Formatting> {
    private static final Logger logger = LoggerFactory.getLogger(Java11ParserVisitor.class);
    private final URI uri;
    private final String source;
    private final boolean relaxedClassTypeMatching;
    private final Collection<JavaStyle> styles;
    private final Map<String, JavaType.Class> sharedClassTypes;
    private EndPosTable endPosTable;
    private int cursor = 0;
    private final Function<com.sun.source.tree.Tree, String> statementDelim = t -> {
        if (t instanceof JCTree.JCThrow || t instanceof JCTree.JCBreak || t instanceof JCTree.JCAssert || t instanceof JCTree.JCContinue || t instanceof JCTree.JCExpressionStatement || t instanceof JCTree.JCReturn || t instanceof JCTree.JCVariableDecl || t instanceof JCTree.JCDoWhileLoop || t instanceof JCTree.JCSkip) {
            return this.sourceBefore(";");
        }
        if (t instanceof JCTree.JCCase) {
            return this.sourceBefore(":");
        }
        if (t instanceof JCTree.JCMethodDecl) {
            return this.sourceBefore(((JCTree.JCMethodDecl)t).body == null ? ";" : "");
        }
        return this.sourceBefore("");
    };
    private final Map<Long, Flag> flagMasks = Map.of(1L, Flag.Public, 2L, Flag.Private, 4L, Flag.Protected, 8L, Flag.Static, 16L, Flag.Final, 32L, Flag.Synchronized, 64L, Flag.Volatile, 128L, Flag.Transient, 1024L, Flag.Abstract);
    private final Function<com.sun.source.tree.Tree, String> semiDelim = ignored -> this.sourceBefore(";");
    private final Function<com.sun.source.tree.Tree, String> commaDelim = ignored -> this.sourceBefore(",");
    private final Function<com.sun.source.tree.Tree, String> noDelim = ignored -> "";

    public Java11ParserVisitor(URI uri, String source, boolean relaxedClassTypeMatching, Collection<JavaStyle> styles, Map<String, JavaType.Class> sharedClassTypes) {
        this.uri = uri;
        this.source = source;
        this.relaxedClassTypeMatching = relaxedClassTypeMatching;
        this.styles = styles;
        this.sharedClassTypes = sharedClassTypes;
    }

    @Override
    public J visitAnnotation(AnnotationTree node, Formatting fmt) {
        this.skip("@");
        NameTree name = (NameTree)this.convert(node.getAnnotationType());
        J.Annotation.Arguments args = null;
        if (node.getArguments().size() > 0) {
            ExpressionTree arg;
            String argsPrefix = this.sourceBefore("(");
            List<Object> expressions = node.getArguments().size() == 1 ? ((arg = node.getArguments().get(0)) instanceof JCTree.JCAssign ? (this.endPos(arg) < 0 ? Collections.singletonList((Expression)this.convert(((JCTree.JCAssign)arg).rhs, t -> this.sourceBefore(")"))) : Collections.singletonList((Expression)this.convert(arg, t -> this.sourceBefore(")")))) : Collections.singletonList((Expression)this.convert(arg, t -> this.sourceBefore(")")))) : this.convertAll(node.getArguments(), this.commaDelim, t -> this.sourceBefore(")"));
            args = new J.Annotation.Arguments(Tree.randomId(), expressions, Formatting.format((String)argsPrefix));
        } else {
            String remaining = this.source.substring(this.cursor, this.endPos(node));
            if (remaining.contains("(") && remaining.contains(")")) {
                String parenPrefix = this.sourceBefore("(");
                args = new J.Annotation.Arguments(Tree.randomId(), Collections.singletonList(new J.Empty(Tree.randomId(), Formatting.format((String)this.sourceBefore(")")))), Formatting.format((String)parenPrefix));
            }
        }
        return new J.Annotation(Tree.randomId(), name, args, fmt);
    }

    @Override
    public J visitArrayAccess(ArrayAccessTree node, Formatting fmt) {
        Expression indexed = (Expression)this.convert(node.getExpression());
        String dimensionPrefix = this.sourceBefore("[");
        J.ArrayAccess.Dimension dimension = new J.ArrayAccess.Dimension(Tree.randomId(), (Expression)this.convert(node.getIndex(), t -> this.sourceBefore("]")), Formatting.format((String)dimensionPrefix));
        return new J.ArrayAccess(Tree.randomId(), indexed, dimension, this.type(node), fmt);
    }

    @Override
    public J visitArrayType(ArrayTypeTree node, Formatting fmt) {
        com.sun.source.tree.Tree typeIdent = node.getType();
        int dimCount = 1;
        while (typeIdent instanceof ArrayTypeTree) {
            ++dimCount;
            typeIdent = ((ArrayTypeTree)typeIdent).getType();
        }
        TypeTree elemType = (TypeTree)this.convert(typeIdent);
        List dimensions = IntStream.range(0, dimCount).mapToObj(n -> {
            String dimPrefix = this.sourceBefore("[");
            return new J.ArrayType.Dimension(Tree.randomId(), new J.Empty(Tree.randomId(), Formatting.format((String)this.sourceBefore("]"))), Formatting.format((String)dimPrefix));
        }).collect(Collectors.toList());
        return new J.ArrayType(Tree.randomId(), elemType, dimensions, fmt);
    }

    @Override
    public J visitAssert(AssertTree node, Formatting fmt) {
        this.skip("assert");
        return new J.Assert(Tree.randomId(), (Expression)this.convert(((JCTree.JCAssert)node).cond), fmt);
    }

    @Override
    public J visitAssignment(AssignmentTree node, Formatting fmt) {
        Expression variable = (Expression)this.convert(node.getVariable(), t -> this.sourceBefore("="));
        return new J.Assign(Tree.randomId(), variable, (Expression)this.convert(node.getExpression()), this.type(node), fmt);
    }

    @Override
    public J visitBinary(BinaryTree node, Formatting fmt) {
        J.Binary.Operator.Addition op;
        Expression left = (Expression)this.convert(node.getLeftOperand());
        Formatting opPrefix = Formatting.format((String)this.whitespace());
        switch (((JCTree.JCBinary)node).getTag()) {
            case PLUS: {
                this.skip("+");
                op = new J.Binary.Operator.Addition(Tree.randomId(), opPrefix);
                break;
            }
            case MINUS: {
                this.skip("-");
                op = new J.Binary.Operator.Subtraction(Tree.randomId(), opPrefix);
                break;
            }
            case DIV: {
                this.skip("/");
                op = new J.Binary.Operator.Division(Tree.randomId(), opPrefix);
                break;
            }
            case MUL: {
                this.skip("*");
                op = new J.Binary.Operator.Multiplication(Tree.randomId(), opPrefix);
                break;
            }
            case MOD: {
                this.skip("%");
                op = new J.Binary.Operator.Modulo(Tree.randomId(), opPrefix);
                break;
            }
            case AND: {
                this.skip("&&");
                op = new J.Binary.Operator.And(Tree.randomId(), opPrefix);
                break;
            }
            case OR: {
                this.skip("||");
                op = new J.Binary.Operator.Or(Tree.randomId(), opPrefix);
                break;
            }
            case BITAND: {
                this.skip("&");
                op = new J.Binary.Operator.BitAnd(Tree.randomId(), opPrefix);
                break;
            }
            case BITOR: {
                this.skip("|");
                op = new J.Binary.Operator.BitOr(Tree.randomId(), opPrefix);
                break;
            }
            case BITXOR: {
                this.skip("^");
                op = new J.Binary.Operator.BitXor(Tree.randomId(), opPrefix);
                break;
            }
            case SL: {
                this.skip("<<");
                op = new J.Binary.Operator.LeftShift(Tree.randomId(), opPrefix);
                break;
            }
            case SR: {
                this.skip(">>");
                op = new J.Binary.Operator.RightShift(Tree.randomId(), opPrefix);
                break;
            }
            case USR: {
                this.skip(">>>");
                op = new J.Binary.Operator.UnsignedRightShift(Tree.randomId(), opPrefix);
                break;
            }
            case LT: {
                this.skip("<");
                op = new J.Binary.Operator.LessThan(Tree.randomId(), opPrefix);
                break;
            }
            case GT: {
                this.skip(">");
                op = new J.Binary.Operator.GreaterThan(Tree.randomId(), opPrefix);
                break;
            }
            case LE: {
                this.skip("<=");
                op = new J.Binary.Operator.LessThanOrEqual(Tree.randomId(), opPrefix);
                break;
            }
            case GE: {
                this.skip(">=");
                op = new J.Binary.Operator.GreaterThanOrEqual(Tree.randomId(), opPrefix);
                break;
            }
            case EQ: {
                this.skip("==");
                op = new J.Binary.Operator.Equal(Tree.randomId(), opPrefix);
                break;
            }
            case NE: {
                this.skip("!=");
                op = new J.Binary.Operator.NotEqual(Tree.randomId(), opPrefix);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected binary tag " + ((JCTree.JCBinary)node).getTag());
            }
        }
        return new J.Binary(Tree.randomId(), left, (J.Binary.Operator)op, (Expression)this.convert(node.getRightOperand()), this.type(node), fmt);
    }

    @Override
    public J visitBlock(BlockTree node, Formatting fmt) {
        J.Empty stat = null;
        if ((((JCTree.JCBlock)node).flags & 8L) != 0L) {
            this.skip("static");
            stat = new J.Empty(Tree.randomId(), Formatting.format((String)"", (String)this.sourceBefore("{")));
        } else {
            this.skip("{");
        }
        ArrayList<StatementTree> statementTrees = new ArrayList<StatementTree>();
        for (StatementTree statementTree : node.getStatements()) {
            if (this.endPos(statementTree) <= 0) continue;
            statementTrees.add(statementTree);
        }
        List statements = this.convertPossibleMultiVariable(statementTrees);
        return new J.Block(Tree.randomId(), stat, statements, fmt, new J.Block.End(Tree.randomId(), Formatting.format((String)this.sourceBefore("}"))));
    }

    @Override
    public J visitBreak(BreakTree node, Formatting fmt) {
        this.skip("break");
        J.Ident label = null;
        Name labelName = node.getLabel();
        if (labelName != null) {
            label = J.Ident.build((UUID)Tree.randomId(), (String)labelName.toString(), null, (Formatting)Formatting.format((String)this.sourceBefore(labelName.toString())));
            this.skip(labelName.toString());
        }
        return new J.Break(Tree.randomId(), label, fmt);
    }

    @Override
    public J visitCase(CaseTree node, Formatting fmt) {
        Expression pattern = (Expression)this.convertOrNull(node.getExpression(), t -> this.sourceBefore(":"));
        if (pattern == null) {
            pattern = J.Ident.build((UUID)Tree.randomId(), (String)this.skip("default"), null, (Formatting)Formatting.format((String)this.sourceBefore(":")));
        }
        return new J.Case(Tree.randomId(), pattern, this.convertPossibleMultiVariable(node.getStatements()), fmt);
    }

    @Override
    public J visitCatch(CatchTree node, Formatting fmt) {
        this.skip("catch");
        String paramPrefix = this.sourceBefore("(");
        J.VariableDecls paramDecl = (J.VariableDecls)this.convert(node.getParameter(), t -> this.sourceBefore(")"));
        J.Parentheses param = new J.Parentheses(Tree.randomId(), (J)paramDecl, Formatting.format((String)paramPrefix));
        return new J.Try.Catch(Tree.randomId(), param, (J.Block)this.convert(node.getBlock()), fmt);
    }

    @Override
    public J visitClass(ClassTree node, Formatting fmt) {
        List annotations = this.convertAll(node.getModifiers().getAnnotations(), this.noDelim, this.noDelim);
        List<J.Modifier> modifiers = this.sortedFlags(node.getModifiers());
        Object kind = this.hasFlag(node.getModifiers(), 16384L) ? new J.ClassDecl.Kind.Enum(Tree.randomId(), Formatting.format((String)this.sourceBefore("enum"))) : (this.hasFlag(node.getModifiers(), 8192L) ? new J.ClassDecl.Kind.Annotation(Tree.randomId(), Formatting.format((String)this.sourceBefore("@interface"))) : (this.hasFlag(node.getModifiers(), 512L) ? new J.ClassDecl.Kind.Interface(Tree.randomId(), Formatting.format((String)this.sourceBefore("interface"))) : new J.ClassDecl.Kind.Class(Tree.randomId(), Formatting.format((String)this.sourceBefore("class")))));
        J.Ident name = J.Ident.build((UUID)Tree.randomId(), (String)((JCTree.JCClassDecl)node).getSimpleName().toString(), (JavaType)this.type(node), (Formatting)Formatting.format((String)this.sourceBefore(node.getSimpleName().toString())));
        J.TypeParameters typeParams = null;
        if (!node.getTypeParameters().isEmpty()) {
            String genericPrefix = this.sourceBefore("<");
            typeParams = new J.TypeParameters(Tree.randomId(), this.convertAll(node.getTypeParameters(), this.commaDelim, t -> this.sourceBefore(">")), Formatting.format((String)genericPrefix));
        }
        J.ClassDecl.Extends extendings = null;
        if (node.getExtendsClause() != null) {
            String extendsPrefix = this.sourceBefore("extends");
            extendings = new J.ClassDecl.Extends(Tree.randomId(), (TypeTree)this.convertOrNull(node.getExtendsClause()), Formatting.format((String)extendsPrefix));
        }
        J.ClassDecl.Implements implementings = null;
        if (node.getImplementsClause() != null && !node.getImplementsClause().isEmpty()) {
            String implementsPrefix = this.sourceBefore(kind instanceof J.ClassDecl.Kind.Interface ? "extends" : "implements");
            implementings = new J.ClassDecl.Implements(Tree.randomId(), this.convertAll(node.getImplementsClause(), this.commaDelim, this.noDelim), Formatting.format((String)implementsPrefix));
        }
        String bodyPrefix = this.sourceBefore("{");
        ArrayList<com.sun.source.tree.Tree> jcEnums = new ArrayList<com.sun.source.tree.Tree>();
        for (com.sun.source.tree.Tree tree : node.getMembers()) {
            if (!(tree instanceof JCTree.JCVariableDecl) || !this.hasFlag(((JCTree.JCVariableDecl)tree).getModifiers(), 16384L)) continue;
            jcEnums.add(tree);
        }
        J.EnumValueSet enumSet = null;
        if (!jcEnums.isEmpty()) {
            AtomicBoolean atomicBoolean = new AtomicBoolean(false);
            List enumValues = this.convertAll(jcEnums, this.commaDelim, t -> {
                semicolonPresent.set(this.positionOfNext(";", Character.valueOf('}')) > 0);
                return semicolonPresent.get() ? this.sourceBefore(";", Character.valueOf('}')) : "";
            });
            enumSet = new J.EnumValueSet(Tree.randomId(), enumValues, atomicBoolean.get(), Formatting.EMPTY);
        }
        ArrayList<com.sun.source.tree.Tree> arrayList = new ArrayList<com.sun.source.tree.Tree>();
        for (com.sun.source.tree.Tree tree : node.getMembers()) {
            if (tree instanceof JCTree.JCMethodDecl && this.hasFlag(((JCTree.JCMethodDecl)tree).getModifiers(), 0x1000000000L) || tree instanceof JCTree.JCVariableDecl && this.hasFlag(((JCTree.JCVariableDecl)tree).getModifiers(), 16384L)) continue;
            arrayList.add(tree);
        }
        ArrayList<Object> members = new ArrayList<Object>();
        if (enumSet != null) {
            members.add(enumSet);
        }
        members.addAll(this.convertPossibleMultiVariable(arrayList));
        J.Block block = new J.Block(Tree.randomId(), null, members, Formatting.format((String)bodyPrefix), new J.Block.End(Tree.randomId(), Formatting.format((String)this.sourceBefore("}"))));
        return new J.ClassDecl(Tree.randomId(), annotations, modifiers, (J.ClassDecl.Kind)kind, name, typeParams, extendings, implementings, block, (JavaType.Class)this.type(node), fmt);
    }

    @Override
    public J visitCompilationUnit(CompilationUnitTree node, Formatting fmt) {
        logger.debug("Building AST for: " + this.uri);
        JCTree.JCCompilationUnit cu = (JCTree.JCCompilationUnit)node;
        String prefix = this.source.substring(0, cu.getStartPosition());
        this.cursor(cu.getStartPosition());
        this.endPosTable = cu.endPositions;
        J.Package packageDecl = null;
        if (cu.getPackageName() != null) {
            String packagePrefix = this.sourceBefore("package");
            packageDecl = new J.Package(Tree.randomId(), (Expression)this.convert(cu.getPackageName()), Formatting.format((String)packagePrefix, (String)this.sourceBefore(";")));
        }
        return new J.CompilationUnit(Tree.randomId(), this.uri.toString(), Collections.emptyList(), packageDecl, this.convertAll(node.getImports(), this.semiDelim, this.semiDelim), this.convertAll(node.getTypeDecls().stream().filter(JCTree.JCClassDecl.class::isInstance).collect(Collectors.toList()), this::whitespace, this.noDelim), Formatting.format((String)prefix, (String)this.source.substring(this.cursor)), this.styles);
    }

    @Override
    public J visitCompoundAssignment(CompoundAssignmentTree node, Formatting fmt) {
        J.AssignOp.Operator.Addition op;
        Expression left = (Expression)this.convert(((JCTree.JCAssignOp)node).lhs);
        Formatting opPrefix = Formatting.format((String)this.whitespace());
        switch (((JCTree.JCAssignOp)node).getTag()) {
            case PLUS_ASG: {
                this.skip("+=");
                op = new J.AssignOp.Operator.Addition(Tree.randomId(), opPrefix);
                break;
            }
            case MINUS_ASG: {
                this.skip("-=");
                op = new J.AssignOp.Operator.Subtraction(Tree.randomId(), opPrefix);
                break;
            }
            case DIV_ASG: {
                this.skip("/=");
                op = new J.AssignOp.Operator.Division(Tree.randomId(), opPrefix);
                break;
            }
            case MUL_ASG: {
                this.skip("*=");
                op = new J.AssignOp.Operator.Multiplication(Tree.randomId(), opPrefix);
                break;
            }
            case MOD_ASG: {
                this.skip("%=");
                op = new J.AssignOp.Operator.Modulo(Tree.randomId(), opPrefix);
                break;
            }
            case BITAND_ASG: {
                this.skip("&=");
                op = new J.AssignOp.Operator.BitAnd(Tree.randomId(), opPrefix);
                break;
            }
            case BITOR_ASG: {
                this.skip("|=");
                op = new J.AssignOp.Operator.BitOr(Tree.randomId(), opPrefix);
                break;
            }
            case BITXOR_ASG: {
                this.skip("^=");
                op = new J.AssignOp.Operator.BitXor(Tree.randomId(), opPrefix);
                break;
            }
            case SL_ASG: {
                this.skip("<<=");
                op = new J.AssignOp.Operator.LeftShift(Tree.randomId(), opPrefix);
                break;
            }
            case SR_ASG: {
                this.skip(">>=");
                op = new J.AssignOp.Operator.RightShift(Tree.randomId(), opPrefix);
                break;
            }
            case USR_ASG: {
                this.skip(">>>=");
                op = new J.AssignOp.Operator.UnsignedRightShift(Tree.randomId(), opPrefix);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected compound assignment tag " + ((JCTree.JCAssignOp)node).getTag());
            }
        }
        return new J.AssignOp(Tree.randomId(), left, (J.AssignOp.Operator)op, (Expression)this.convert(((JCTree.JCAssignOp)node).rhs), this.type(node), fmt);
    }

    @Override
    public J visitConditionalExpression(ConditionalExpressionTree node, Formatting fmt) {
        return new J.Ternary(Tree.randomId(), (Expression)this.convert(node.getCondition(), t -> this.sourceBefore("?")), (Expression)this.convert(node.getTrueExpression(), t -> this.sourceBefore(":")), (Expression)this.convert(node.getFalseExpression()), this.type(node), fmt);
    }

    @Override
    public J visitContinue(ContinueTree node, Formatting fmt) {
        this.skip("continue");
        Name label = node.getLabel();
        return new J.Continue(Tree.randomId(), label == null ? null : J.Ident.build((UUID)Tree.randomId(), (String)label.toString(), null, (Formatting)Formatting.format((String)this.sourceBefore(label.toString()))), fmt);
    }

    @Override
    public J visitDoWhileLoop(DoWhileLoopTree node, Formatting fmt) {
        this.skip("do");
        Statement stat = (Statement)this.convert(node.getStatement());
        String whilePrefix = this.sourceBefore("while");
        return new J.DoWhileLoop(Tree.randomId(), stat, new J.DoWhileLoop.While(Tree.randomId(), (J.Parentheses)this.convert(node.getCondition()), Formatting.format((String)whilePrefix)), fmt);
    }

    @Override
    public J visitEmptyStatement(EmptyStatementTree node, Formatting fmt) {
        return new J.Empty(Tree.randomId(), fmt);
    }

    @Override
    public J visitEnhancedForLoop(EnhancedForLoopTree node, Formatting fmt) {
        this.skip("for");
        String ctrlPrefix = this.sourceBefore("(");
        J.VariableDecls variable = (J.VariableDecls)this.convert(node.getVariable(), t -> this.sourceBefore(":"));
        Expression expression = (Expression)this.convert(node.getExpression(), t -> this.sourceBefore(")"));
        return new J.ForEachLoop(Tree.randomId(), new J.ForEachLoop.Control(Tree.randomId(), variable, expression, Formatting.format((String)ctrlPrefix)), (Statement)this.convert(node.getStatement(), this.statementDelim), fmt);
    }

    private J visitEnumVariable(VariableTree node, Formatting fmt) {
        this.skip(node.getName().toString());
        J.Ident name = J.Ident.build((UUID)Tree.randomId(), (String)node.getName().toString(), (JavaType)this.type(node), (Formatting)Formatting.EMPTY);
        J.NewClass initializer = null;
        if (this.source.charAt(this.endPos(node) - 1) == ')' || this.source.charAt(this.endPos(node) - 1) == '}') {
            initializer = (J.NewClass)this.convert(node.getInitializer());
        }
        return new J.EnumValue(Tree.randomId(), name, initializer, fmt);
    }

    @Override
    public J visitForLoop(ForLoopTree node, Formatting fmt) {
        List<Object> update;
        this.skip("for");
        String ctrlPrefix = this.sourceBefore("(");
        Statement init = this.convertPossibleMultiVariable(node.getInitializer()).stream().filter(Statement.class::isInstance).map(Statement.class::cast).findAny().orElseGet(() -> new J.Empty(Tree.randomId(), Formatting.format((String)"", (String)this.sourceBefore(";"))));
        Expression condition = (Expression)this.convertOrNull(node.getCondition(), this.semiDelim);
        if (condition == null) {
            condition = new J.Empty(Tree.randomId(), Formatting.format((String)"", (String)this.sourceBefore(";")));
        }
        if (node.getUpdate().isEmpty()) {
            update = Collections.singletonList(new J.Empty(Tree.randomId(), Formatting.format((String)"", (String)this.sourceBefore(")"))));
        } else {
            update = new ArrayList();
            List<? extends ExpressionStatementTree> nodeUpdate = node.getUpdate();
            for (int i = 0; i < nodeUpdate.size(); ++i) {
                ExpressionStatementTree tree = nodeUpdate.get(i);
                update.add((Statement)this.convert(tree, i == nodeUpdate.size() - 1 ? t -> this.sourceBefore(")") : this.commaDelim));
            }
        }
        return new J.ForLoop(Tree.randomId(), new J.ForLoop.Control(Tree.randomId(), init, condition, update, Formatting.format((String)ctrlPrefix)), (Statement)this.convert(node.getStatement(), this.statementDelim), fmt);
    }

    @Override
    public J visitIdentifier(IdentifierTree node, Formatting fmt) {
        this.cursor += node.getName().toString().length();
        return J.Ident.build((UUID)Tree.randomId(), (String)node.getName().toString(), (JavaType)this.type(node), (Formatting)fmt);
    }

    @Override
    public J visitIf(IfTree node, Formatting fmt) {
        this.skip("if");
        J.Parentheses ifPart = (J.Parentheses)this.convert(node.getCondition());
        Statement then = (Statement)this.convert(node.getThenStatement());
        J.If.Else elsePart = null;
        if (node.getElseStatement() instanceof JCTree.JCStatement) {
            String elsePrefix = this.sourceBefore("else");
            elsePart = new J.If.Else(Tree.randomId(), (Statement)this.convert(node.getElseStatement(), this.statementDelim), Formatting.format((String)elsePrefix));
        }
        return new J.If(Tree.randomId(), ifPart, then, elsePart, fmt);
    }

    @Override
    public J visitImport(ImportTree node, Formatting fmt) {
        this.skip("import");
        this.skipPattern("\\s+static");
        return new J.Import(Tree.randomId(), (J.FieldAccess)this.convert(node.getQualifiedIdentifier()), node.isStatic(), fmt);
    }

    @Override
    public J visitInstanceOf(InstanceOfTree node, Formatting fmt) {
        return new J.InstanceOf(Tree.randomId(), (Expression)this.convert(node.getExpression(), t -> this.sourceBefore("instanceof")), this.convert(node.getType()), this.type(node), fmt);
    }

    @Override
    public J visitLabeledStatement(LabeledStatementTree node, Formatting fmt) {
        this.skip(node.getLabel().toString());
        return new J.Label(Tree.randomId(), J.Ident.build((UUID)Tree.randomId(), (String)node.getLabel().toString(), null, (Formatting)Formatting.format((String)"", (String)this.sourceBefore(":"))), (Statement)this.convert(node.getStatement()), fmt);
    }

    @Override
    public J visitLambdaExpression(LambdaExpressionTree node, Formatting fmt) {
        Object body;
        boolean parenthesized = this.source.charAt(this.cursor) == '(';
        this.skip("(");
        List<Object> paramList = parenthesized && node.getParameters().isEmpty() ? Collections.singletonList(new J.Empty(Tree.randomId(), Formatting.format((String)this.sourceBefore(")")))) : this.convertAll(node.getParameters(), this.commaDelim, t -> parenthesized ? this.sourceBefore(")") : "");
        J.Lambda.Parameters params = new J.Lambda.Parameters(Tree.randomId(), parenthesized, paramList);
        J.Lambda.Arrow arrow = new J.Lambda.Arrow(Tree.randomId(), Formatting.format((String)this.sourceBefore("->")));
        if (node.getBody() instanceof JCTree.JCBlock) {
            String prefix = this.sourceBefore("{");
            --this.cursor;
            body = this.convert(node.getBody());
            body = (J)body.withPrefix(prefix);
        } else {
            body = this.convert(node.getBody());
        }
        return new J.Lambda(Tree.randomId(), params, arrow, body, this.type(node), fmt);
    }

    @Override
    public J visitLiteral(LiteralTree node, Formatting fmt) {
        this.cursor(this.endPos(node));
        Object value = node.getValue();
        JavaType.Primitive type = this.primitive(((JCTree.JCLiteral)node).typetag);
        return new J.Literal(Tree.randomId(), value, this.source.substring(((JCTree.JCLiteral)node).getStartPosition(), this.endPos(node)), type, fmt);
    }

    @Override
    public J visitMemberReference(MemberReferenceTree node, Formatting fmt) {
        String referenceName;
        JCTree.JCMemberReference ref = (JCTree.JCMemberReference)node;
        Expression expr = (Expression)this.convert(ref.expr, t -> this.sourceBefore("::"));
        switch (ref.getMode()) {
            case NEW: {
                referenceName = "new";
                break;
            }
            default: {
                referenceName = node.getName().toString();
            }
        }
        J.TypeParameters typeParams = this.convertTypeParameters(node.getTypeArguments());
        J.Ident reference = J.Ident.build((UUID)Tree.randomId(), (String)referenceName, null, (Formatting)Formatting.format((String)this.sourceBefore(referenceName)));
        return new J.MemberReference(Tree.randomId(), expr, typeParams, reference, this.type(node), fmt);
    }

    @Override
    public J visitMemberSelect(MemberSelectTree node, Formatting fmt) {
        JCTree.JCFieldAccess fieldAccess = (JCTree.JCFieldAccess)node;
        Expression target = (Expression)this.convert(fieldAccess.selected, t -> this.sourceBefore("."));
        J.Ident name = J.Ident.build((UUID)Tree.randomId(), (String)fieldAccess.name.toString(), null, (Formatting)Formatting.format((String)this.sourceBefore(fieldAccess.name.toString())));
        return new J.FieldAccess(Tree.randomId(), target, name, this.type(node), fmt);
    }

    @Override
    public J visitMethodInvocation(MethodInvocationTree node, Formatting fmt) {
        J.Ident name;
        JCTree.JCExpression jcSelect = ((JCTree.JCMethodInvocation)node).getMethodSelect();
        Expression select = null;
        if (jcSelect instanceof JCTree.JCFieldAccess) {
            select = (Expression)this.convert(((JCTree.JCFieldAccess)jcSelect).selected, t -> this.sourceBefore("."));
        } else if (!(jcSelect instanceof JCTree.JCIdent)) {
            throw new IllegalStateException("Unexpected method select type " + jcSelect.getClass().getSimpleName());
        }
        J.TypeParameters typeParams = null;
        if (!node.getTypeArguments().isEmpty()) {
            String genericPrefix = this.sourceBefore("<");
            List genericParams = this.convertAll(node.getTypeArguments(), this.commaDelim, t -> this.sourceBefore(">"));
            ArrayList<J.TypeParameter> mappedGenericParams = new ArrayList<J.TypeParameter>();
            for (Expression gp : genericParams) {
                J.TypeParameter typeParameter = new J.TypeParameter(Tree.randomId(), Collections.emptyList(), (Expression)gp.withFormatting(Formatting.EMPTY), null, gp.getFormatting());
                mappedGenericParams.add(typeParameter);
            }
            typeParams = new J.TypeParameters(Tree.randomId(), mappedGenericParams, Formatting.format((String)genericPrefix));
        }
        if (jcSelect instanceof JCTree.JCFieldAccess) {
            String selectName = ((JCTree.JCFieldAccess)jcSelect).name.toString();
            name = J.Ident.build((UUID)Tree.randomId(), (String)selectName, null, (Formatting)Formatting.format((String)this.sourceBefore(selectName)));
        } else {
            name = (J.Ident)this.convert(jcSelect);
        }
        String argsPrefix = this.sourceBefore("(");
        J.MethodInvocation.Arguments args = new J.MethodInvocation.Arguments(Tree.randomId(), node.getArguments().isEmpty() ? Collections.singletonList(new J.Empty(Tree.randomId(), Formatting.format((String)this.sourceBefore(")")))) : this.convertAll(node.getArguments(), this.commaDelim, t -> this.sourceBefore(")")), Formatting.format((String)argsPrefix));
        Symbol genericSymbolAny = jcSelect instanceof JCTree.JCFieldAccess ? ((JCTree.JCFieldAccess)jcSelect).sym : ((JCTree.JCIdent)jcSelect).sym;
        Symbol.MethodSymbol genericSymbol = genericSymbolAny instanceof Symbol.MethodSymbol ? (Symbol.MethodSymbol)genericSymbolAny : null;
        JavaType.Method type = null;
        if (genericSymbol != null && jcSelect.type != null) {
            Function<Type, JavaType.Method.Signature> signature = t -> {
                if (t instanceof Type.MethodType) {
                    Type.MethodType mt = (Type.MethodType)t;
                    ArrayList<JavaType> paramTypes = new ArrayList<JavaType>();
                    for (Type argtype : mt.argtypes) {
                        if (argtype == null) continue;
                        JavaType javaType = this.type(argtype);
                        paramTypes.add(javaType);
                    }
                    return new JavaType.Method.Signature(this.type(mt.restype), paramTypes);
                }
                return null;
            };
            JavaType.Method.Signature genericSignature = genericSymbol.type instanceof Type.ForAll ? signature.apply(((Type.ForAll)genericSymbol.type).qtype) : signature.apply(genericSymbol.type);
            ArrayList<String> paramNames = new ArrayList<String>();
            for (Symbol.VarSymbol p : genericSymbol.params()) {
                String s = p.name.toString();
                paramNames.add(s);
            }
            type = JavaType.Method.build((JavaType.FullyQualified)TypeUtils.asClass((JavaType)this.type(genericSymbol.owner)), (String)name.getSimpleName(), (JavaType.Method.Signature)genericSignature, (JavaType.Method.Signature)signature.apply(jcSelect.type), paramNames, this.filteredFlags(genericSymbol));
        }
        return new J.MethodInvocation(Tree.randomId(), select, typeParams, name, args, type, fmt);
    }

    @Override
    public J visitMethod(MethodTree node, Formatting fmt) {
        J.Ident name;
        logger.trace("Visiting method {}", (Object)node.getName());
        List annotations = this.convertAll(node.getModifiers().getAnnotations(), this.noDelim, this.noDelim);
        List<J.Modifier> modifiers = this.sortedFlags(node.getModifiers());
        J.TypeParameters typeParams = null;
        if (!node.getTypeParameters().isEmpty()) {
            String genericPrefix = this.sourceBefore("<");
            typeParams = new J.TypeParameters(Tree.randomId(), this.convertAll(node.getTypeParameters(), this.commaDelim, t -> this.sourceBefore(">")), Formatting.format((String)genericPrefix));
        }
        TypeTree returnType = (TypeTree)this.convertOrNull(node.getReturnType());
        if ("<init>".equals(node.getName().toString())) {
            Symbol.MethodSymbol nodeSym = ((JCTree.JCMethodDecl)node).sym;
            String owner = null;
            if (nodeSym == null) {
                for (com.sun.source.tree.Tree tree : this.getCurrentPath()) {
                    if (!(tree instanceof JCTree.JCClassDecl)) continue;
                    owner = ((JCTree.JCClassDecl)tree).getSimpleName().toString();
                    break;
                }
                if (owner == null) {
                    throw new IllegalStateException("Should have been able to locate an owner");
                }
            } else {
                owner = ((JCTree.JCMethodDecl)node).sym.owner.name.toString();
            }
            name = J.Ident.build((UUID)Tree.randomId(), (String)owner, null, (Formatting)Formatting.format((String)this.sourceBefore(owner)));
        } else {
            name = J.Ident.build((UUID)Tree.randomId(), (String)node.getName().toString(), null, (Formatting)Formatting.format((String)this.sourceBefore(node.getName().toString())));
        }
        Formatting paramFmt = Formatting.format((String)this.sourceBefore("("));
        J.MethodDecl.Parameters params = !node.getParameters().isEmpty() ? new J.MethodDecl.Parameters(Tree.randomId(), this.convertAll(node.getParameters(), this.commaDelim, t -> this.sourceBefore(")")), paramFmt) : new J.MethodDecl.Parameters(Tree.randomId(), Collections.singletonList(new J.Empty(Tree.randomId(), Formatting.format((String)this.sourceBefore(")")))), paramFmt);
        J.MethodDecl.Throws throwss = null;
        if (!node.getThrows().isEmpty()) {
            String throwsPrefix = this.sourceBefore("throws");
            throwss = new J.MethodDecl.Throws(Tree.randomId(), this.convertAll(node.getThrows(), this.commaDelim, this.noDelim), Formatting.format((String)throwsPrefix));
        }
        J.Block body = (J.Block)this.convertOrNull(node.getBody());
        J.MethodDecl.Default defaultValue = null;
        if (node.getDefaultValue() != null) {
            String defaultPrefix = this.sourceBefore("default");
            defaultValue = new J.MethodDecl.Default(Tree.randomId(), (Expression)this.convert(node.getDefaultValue()), Formatting.format((String)defaultPrefix));
        }
        return new J.MethodDecl(Tree.randomId(), annotations, modifiers, typeParams, returnType, name, params, throwss, body, defaultValue, fmt);
    }

    @Override
    public J visitNewArray(NewArrayTree node, Formatting fmt) {
        TypeTree typeExpr;
        this.skip("new");
        JCTree.JCExpression jcVarType = ((JCTree.JCNewArray)node).elemtype;
        if (jcVarType instanceof JCTree.JCArrayTypeTree) {
            JCTree.JCExpression elementType = ((JCTree.JCArrayTypeTree)jcVarType).elemtype;
            while (elementType instanceof JCTree.JCArrayTypeTree) {
                elementType = ((JCTree.JCArrayTypeTree)elementType).elemtype;
            }
            typeExpr = (TypeTree)this.convertOrNull(elementType);
        } else {
            typeExpr = (TypeTree)this.convertOrNull(jcVarType);
        }
        ArrayList<J.NewArray.Dimension> dimensions = new ArrayList<J.NewArray.Dimension>();
        List<? extends ExpressionTree> nodeDimensions = node.getDimensions();
        for (int i = 0; i < nodeDimensions.size(); ++i) {
            ExpressionTree dim = nodeDimensions.get(i);
            String dimensionPrefix = this.sourceBefore("[");
            dimensions.add(new J.NewArray.Dimension(Tree.randomId(), (Expression)this.convert(dim, t -> this.sourceBefore("]")), Formatting.format((String)dimensionPrefix, (String)(i == node.getDimensions().size() - 1 && node.getInitializers() != null ? this.sourceBefore("}") : ""))));
        }
        Matcher matcher = Pattern.compile("\\G(\\s*)\\[(\\s*)]").matcher(this.source);
        while (matcher.find(this.cursor)) {
            this.cursor(matcher.end());
            J.Empty ws = new J.Empty(Tree.randomId(), Formatting.format((String)matcher.group(2)));
            dimensions.add(new J.NewArray.Dimension(Tree.randomId(), (Expression)ws, Formatting.format((String)matcher.group(1))));
        }
        J.NewArray.Initializer initializer = null;
        if (node.getInitializers() != null) {
            String initPrefix = this.sourceBefore("{");
            List initializers = node.getInitializers().isEmpty() ? Collections.singletonList(new J.Empty(Tree.randomId(), Formatting.format((String)"", (String)this.sourceBefore("}")))) : this.convertAll(node.getInitializers(), this.commaDelim, t -> this.sourceBefore("}"));
            initializer = new J.NewArray.Initializer(Tree.randomId(), initializers, Formatting.format((String)initPrefix));
        }
        return new J.NewArray(Tree.randomId(), typeExpr, dimensions, initializer, this.type(node), fmt);
    }

    @Override
    public J visitNewClass(NewClassTree node, Formatting fmt) {
        Expression encl;
        Expression expression = encl = node.getEnclosingExpression() == null ? null : (Expression)this.convert(node.getEnclosingExpression());
        if (encl != null) {
            encl = (Expression)encl.withSuffix(this.sourceBefore("."));
        }
        String whitespaceBeforeNew = "";
        com.sun.source.tree.Tree parent = this.getCurrentPath().getParentPath().getLeaf();
        if (!(parent instanceof JCTree.JCVariableDecl) || (((JCTree.JCVariableDecl)parent).mods.flags & 0x4000L) == 0L) {
            whitespaceBeforeNew = this.sourceBefore("new");
            this.skip("new");
        }
        TypeTree clazz = this.endPos(node.getIdentifier()) >= 0 ? (TypeTree)this.convertOrNull(node.getIdentifier()) : null;
        J.NewClass.Arguments args = null;
        if (this.positionOfNext("(", Character.valueOf('{')) > -1) {
            String argPrefix = this.sourceBefore("(");
            args = new J.NewClass.Arguments(Tree.randomId(), node.getArguments().isEmpty() ? Collections.singletonList(new J.Empty(Tree.randomId(), Formatting.format((String)this.sourceBefore(")")))) : this.convertAll(node.getArguments(), this.commaDelim, t -> this.sourceBefore(")")), Formatting.format((String)argPrefix));
        }
        J.Block body = null;
        if (node.getClassBody() != null) {
            String bodyPrefix = this.sourceBefore("{");
            ArrayList<com.sun.source.tree.Tree> members = new ArrayList<com.sun.source.tree.Tree>();
            for (com.sun.source.tree.Tree tree : node.getClassBody().getMembers()) {
                if (tree instanceof JCTree.JCMethodDecl && (((JCTree.JCMethodDecl)tree).getModifiers().flags & 0x1000000000L) != 0L) continue;
                members.add(tree);
            }
            body = new J.Block(Tree.randomId(), null, this.convertAll(members, this.noDelim, this.noDelim), Formatting.format((String)bodyPrefix), new J.Block.End(Tree.randomId(), Formatting.format((String)this.sourceBefore("}"))));
        }
        return new J.NewClass(Tree.randomId(), encl, new J.NewClass.New(UUID.randomUUID(), Formatting.format((String)whitespaceBeforeNew)), clazz, args, body, this.type(((JCTree.JCNewClass)node).type), fmt);
    }

    @Override
    public J visitParameterizedType(ParameterizedTypeTree node, Formatting fmt) {
        return new J.ParameterizedType(Tree.randomId(), (NameTree)this.convert(node.getType()), this.convertTypeParameters(node.getTypeArguments()), fmt);
    }

    @Override
    public J visitParenthesized(ParenthesizedTree node, Formatting fmt) {
        this.skip("(");
        return new J.Parentheses(Tree.randomId(), (J)((Expression)this.convert(node.getExpression(), t -> this.sourceBefore(")"))), fmt);
    }

    @Override
    public J visitPrimitiveType(PrimitiveTypeTree node, Formatting fmt) {
        JavaType.Primitive primitiveType;
        this.cursor(this.endPos(node));
        switch (node.getPrimitiveTypeKind()) {
            case BOOLEAN: {
                primitiveType = JavaType.Primitive.Boolean;
                break;
            }
            case BYTE: {
                primitiveType = JavaType.Primitive.Byte;
                break;
            }
            case CHAR: {
                primitiveType = JavaType.Primitive.Char;
                break;
            }
            case DOUBLE: {
                primitiveType = JavaType.Primitive.Double;
                break;
            }
            case FLOAT: {
                primitiveType = JavaType.Primitive.Float;
                break;
            }
            case INT: {
                primitiveType = JavaType.Primitive.Int;
                break;
            }
            case LONG: {
                primitiveType = JavaType.Primitive.Long;
                break;
            }
            case SHORT: {
                primitiveType = JavaType.Primitive.Short;
                break;
            }
            case VOID: {
                primitiveType = JavaType.Primitive.Void;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown primitive type " + node.getPrimitiveTypeKind());
            }
        }
        return new J.Primitive(Tree.randomId(), primitiveType, fmt);
    }

    @Override
    public J visitReturn(ReturnTree node, Formatting fmt) {
        this.skip("return");
        return new J.Return(Tree.randomId(), (Expression)this.convertOrNull(node.getExpression()), fmt);
    }

    @Override
    public J visitSwitch(SwitchTree node, Formatting fmt) {
        this.skip("switch");
        J.Parentheses selector = (J.Parentheses)this.convert(node.getExpression());
        String casePrefix = this.sourceBefore("{");
        List cases = this.convertAll(node.getCases(), this.noDelim, this.noDelim);
        return new J.Switch(Tree.randomId(), selector, new J.Block(Tree.randomId(), null, cases, Formatting.format((String)casePrefix), new J.Block.End(Tree.randomId(), Formatting.format((String)this.sourceBefore("}")))), fmt);
    }

    @Override
    public J visitSynchronized(SynchronizedTree node, Formatting fmt) {
        this.skip("synchronized");
        return new J.Synchronized(Tree.randomId(), (J.Parentheses)this.convert(node.getExpression()), (J.Block)this.convert(node.getBlock()), fmt);
    }

    @Override
    public J visitThrow(ThrowTree node, Formatting fmt) {
        this.skip("throw");
        return new J.Throw(Tree.randomId(), (Expression)this.convert(node.getExpression()), fmt);
    }

    @Override
    public J visitTry(TryTree node, Formatting fmt) {
        this.skip("try");
        J.Try.Resources resources = null;
        if (!node.getResources().isEmpty()) {
            String resourcesPrefix = this.sourceBefore("(");
            List decls = this.convertAll(node.getResources(), this.semiDelim, t -> this.sourceBefore(")"));
            resources = new J.Try.Resources(Tree.randomId(), decls, Formatting.format((String)resourcesPrefix));
        }
        J.Block block = (J.Block)this.convert(node.getBlock());
        List catches = this.convertAll(node.getCatches(), this.noDelim, this.noDelim);
        J.Try.Finally finallyy = null;
        if (node.getFinallyBlock() != null) {
            String finallyPrefix = this.sourceBefore("finally");
            finallyy = new J.Try.Finally(Tree.randomId(), (J.Block)this.convert(node.getFinallyBlock()), Formatting.format((String)finallyPrefix));
        }
        return new J.Try(Tree.randomId(), resources, block, catches, finallyy, fmt);
    }

    @Override
    public J visitTypeCast(TypeCastTree node, Formatting fmt) {
        String clazzPrefix = this.sourceBefore("(");
        J.Parentheses clazz = new J.Parentheses(Tree.randomId(), (J)((TypeTree)this.convert(node.getType(), t -> this.sourceBefore(")"))), Formatting.format((String)clazzPrefix));
        return new J.TypeCast(Tree.randomId(), clazz, (Expression)this.convert(node.getExpression()), fmt);
    }

    @Override
    public J visitAnnotatedType(AnnotatedTypeTree node, Formatting formatting) {
        List annotations = this.convertAll(node.getAnnotations(), this.noDelim, this.noDelim);
        return new J.AnnotatedType(Tree.randomId(), annotations, (TypeTree)this.convert(node.getUnderlyingType()), formatting);
    }

    @Override
    public J visitTypeParameter(TypeParameterTree node, Formatting fmt) {
        List annotations = this.convertAll(node.getAnnotations(), this.noDelim, this.noDelim);
        TypeTree name = TreeBuilder.buildName((String)node.getName().toString(), (Formatting)Formatting.format((String)this.sourceBefore(node.getName().toString())));
        J.TypeParameter.Bounds bounds = null;
        if (!node.getBounds().isEmpty()) {
            String boundPrefix = !node.getBounds().isEmpty() ? this.sourceBefore("extends") : "";
            bounds = new J.TypeParameter.Bounds(Tree.randomId(), this.convertAll(node.getBounds(), t -> this.sourceBefore("&"), this.noDelim), Formatting.format((String)boundPrefix));
        }
        return new J.TypeParameter(Tree.randomId(), annotations, (Expression)name, bounds, fmt);
    }

    @Override
    public J visitUnionType(UnionTypeTree node, Formatting fmt) {
        return new J.MultiCatch(Tree.randomId(), this.convertAll(node.getTypeAlternatives(), t -> this.sourceBefore("|"), this.noDelim), fmt);
    }

    @Override
    public J visitUnary(UnaryTree node, Formatting fmt) {
        Expression expr;
        J.Unary.Operator.Positive op;
        JCTree.JCUnary unary = (JCTree.JCUnary)node;
        JCTree.Tag tag = unary.getTag();
        switch (tag) {
            case POS: {
                this.skip("+");
                op = new J.Unary.Operator.Positive(Tree.randomId());
                expr = (Expression)this.convert(unary.arg);
                break;
            }
            case NEG: {
                this.skip("-");
                op = new J.Unary.Operator.Negative(Tree.randomId());
                expr = (Expression)this.convert(unary.arg);
                break;
            }
            case PREDEC: {
                this.skip("--");
                op = new J.Unary.Operator.PreDecrement(Tree.randomId());
                expr = (Expression)this.convert(unary.arg);
                break;
            }
            case PREINC: {
                this.skip("++");
                op = new J.Unary.Operator.PreIncrement(Tree.randomId());
                expr = (Expression)this.convert(unary.arg);
                break;
            }
            case POSTDEC: {
                expr = (Expression)this.convert(unary.arg);
                op = new J.Unary.Operator.PostDecrement(Tree.randomId(), Formatting.format((String)this.sourceBefore("--")));
                break;
            }
            case POSTINC: {
                expr = (Expression)this.convert(unary.arg);
                op = new J.Unary.Operator.PostIncrement(Tree.randomId(), Formatting.format((String)this.sourceBefore("++")));
                break;
            }
            case COMPL: {
                this.skip("~");
                op = new J.Unary.Operator.Complement(Tree.randomId(), Formatting.EMPTY);
                expr = (Expression)this.convert(unary.arg);
                break;
            }
            case NOT: {
                this.skip("!");
                op = new J.Unary.Operator.Not(Tree.randomId(), Formatting.EMPTY);
                expr = (Expression)this.convert(unary.arg);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected unary tag " + tag);
            }
        }
        return new J.Unary(Tree.randomId(), (J.Unary.Operator)op, expr, this.type(node), fmt);
    }

    @Override
    public J visitVariable(VariableTree node, Formatting fmt) {
        return this.hasFlag(node.getModifiers(), 16384L) ? this.visitEnumVariable(node, fmt) : this.visitVariables(Collections.singletonList(node), fmt);
    }

    private J.VariableDecls visitVariables(List<VariableTree> nodes, Formatting fmt) {
        TypeTree typeExpr;
        JCTree.JCVariableDecl node = (JCTree.JCVariableDecl)nodes.get(0);
        List annotations = this.convertAll(node.getModifiers().annotations, this.noDelim, this.noDelim);
        JCTree.JCExpression vartype = node.vartype;
        List<Object> modifiers = node.getModifiers().pos >= 0 ? this.sortedFlags(node.getModifiers()) : Collections.emptyList();
        if (vartype == null || this.endPos(vartype) < 0 || vartype instanceof JCTree.JCErroneous) {
            typeExpr = null;
        } else if (vartype instanceof JCTree.JCArrayTypeTree) {
            JCTree.JCExpression elementType = ((JCTree.JCArrayTypeTree)vartype).elemtype;
            while (elementType instanceof JCTree.JCArrayTypeTree) {
                elementType = ((JCTree.JCArrayTypeTree)elementType).elemtype;
            }
            typeExpr = (TypeTree)this.convert(elementType);
        } else {
            typeExpr = (TypeTree)this.convert(vartype);
        }
        Supplier<List> dimensions = () -> {
            Matcher matcher = Pattern.compile("\\G(\\s*)\\[(\\s*)]").matcher(this.source);
            ArrayList<J.VariableDecls.Dimension> dims = new ArrayList<J.VariableDecls.Dimension>();
            while (matcher.find(this.cursor)) {
                this.cursor(matcher.end());
                J.Empty ws = new J.Empty(Tree.randomId(), Formatting.format((String)matcher.group(2)));
                dims.add(new J.VariableDecls.Dimension(Tree.randomId(), ws, Formatting.format((String)matcher.group(1))));
            }
            return dims;
        };
        List beforeDimensions = dimensions.get();
        String vartypeString = typeExpr == null ? "" : this.source.substring(vartype.getStartPosition(), this.endPos(vartype));
        Matcher varargMatcher = Pattern.compile("(\\s*)\\.{3}").matcher(vartypeString);
        J.VariableDecls.Varargs varargs = null;
        if (varargMatcher.find()) {
            this.skipPattern("(\\s*)\\.{3}");
            varargs = new J.VariableDecls.Varargs(Tree.randomId(), Formatting.format((String)varargMatcher.group(1)));
        }
        ArrayList<J.VariableDecls.NamedVar> vars = new ArrayList<J.VariableDecls.NamedVar>();
        for (int i = 0; i < nodes.size(); ++i) {
            VariableTree n = nodes.get(i);
            String namedVarPrefix = this.sourceBefore(n.getName().toString());
            JCTree.JCVariableDecl vd = (JCTree.JCVariableDecl)n;
            List dimensionsAfterName = dimensions.get();
            if (!dimensionsAfterName.isEmpty()) {
                dimensionsAfterName = Formatting.formatLastSuffix((List)dimensionsAfterName, (String)(vd.init != null ? this.sourceBefore("=") : ""));
            }
            J.Ident name = J.Ident.build((UUID)Tree.randomId(), (String)n.getName().toString(), (JavaType)this.type(node), (Formatting)Formatting.format((String)"", (String)(dimensionsAfterName.isEmpty() && vd.init != null ? this.sourceBefore("=") : "")));
            vars.add(new J.VariableDecls.NamedVar(Tree.randomId(), name, dimensionsAfterName, (Expression)this.convertOrNull(vd.init), this.type(n), i == nodes.size() - 1 ? Formatting.format((String)namedVarPrefix) : Formatting.format((String)namedVarPrefix, (String)this.sourceBefore(","))));
        }
        return new J.VariableDecls(Tree.randomId(), annotations, modifiers, typeExpr, varargs, beforeDimensions, vars, fmt);
    }

    @Override
    public J visitWhileLoop(WhileLoopTree node, Formatting fmt) {
        this.skip("while");
        return new J.WhileLoop(Tree.randomId(), (J.Parentheses)this.convert(node.getCondition()), (Statement)this.convert(node.getStatement(), this.statementDelim), fmt);
    }

    @Override
    public J visitWildcard(WildcardTree node, Formatting fmt) {
        J.Wildcard.Bound.Extends bound;
        this.skip("?");
        JCTree.JCWildcard wildcard = (JCTree.JCWildcard)node;
        switch (wildcard.kind.kind) {
            case EXTENDS: {
                bound = new J.Wildcard.Bound.Extends(Tree.randomId(), Formatting.format((String)this.sourceBefore("extends")));
                break;
            }
            case SUPER: {
                bound = new J.Wildcard.Bound.Super(Tree.randomId(), Formatting.format((String)this.sourceBefore("super")));
                break;
            }
            default: {
                bound = null;
            }
        }
        return new J.Wildcard(Tree.randomId(), (J.Wildcard.Bound)bound, (NameTree)this.convertOrNull(wildcard.inner), fmt);
    }

    private <T extends J> T convert(com.sun.source.tree.Tree t) {
        return this.convert(t, t2 -> "");
    }

    private <T extends J> T convert(com.sun.source.tree.Tree t2, Function<com.sun.source.tree.Tree, String> suffix) {
        try {
            String prefix = this.source.substring(this.cursor, Math.max(((JCTree)t2).getStartPosition(), this.cursor));
            this.cursor += prefix.length();
            J t = (J)this.scan(t2, Formatting.format((String)prefix));
            if (t != null) {
                t = (J)t.withSuffix(suffix.apply(t2));
            }
            this.cursor(Math.max(this.endPos(t2), this.cursor));
            return (T)t;
        }
        catch (Throwable ex) {
            logger.error("Failed to convert " + t2.getClass().getSimpleName() + " for the following cursor stack:");
            this.logCurrentPathAsError();
            throw ex;
        }
    }

    private void logCurrentPathAsError() {
        logger.error("--- BEGIN PATH ---");
        List paths = StreamSupport.stream(this.getCurrentPath().spliterator(), false).collect(Collectors.toList());
        int i = paths.size();
        while (i-- > 0) {
            JCTree tree = (JCTree)paths.get(i);
            if (tree instanceof JCTree.JCCompilationUnit) {
                logger.error("JCCompilationUnit(sourceFile = " + ((JCTree.JCCompilationUnit)tree).sourcefile.getName() + ")");
                continue;
            }
            if (tree instanceof JCTree.JCClassDecl) {
                logger.error("JCClassDecl(name = " + ((JCTree.JCClassDecl)tree).name + ", line = " + this.lineNumber(tree) + ")");
                continue;
            }
            if (tree instanceof JCTree.JCVariableDecl) {
                logger.error("JCVariableDecl(name = " + ((JCTree.JCVariableDecl)tree).name + ", line = " + this.lineNumber(tree) + ")");
                continue;
            }
            logger.error(tree.getClass().getSimpleName() + "(line = " + this.lineNumber(tree) + ")");
        }
        logger.error("--- END PATH ---");
    }

    private long lineNumber(com.sun.source.tree.Tree tree) {
        return this.source.substring(0, ((JCTree)tree).getStartPosition()).chars().filter(c -> c == 10).count() + 1L;
    }

    private <T extends J> T convertOrNull(@Nullable com.sun.source.tree.Tree t) {
        return this.convertOrNull(t, t2 -> "");
    }

    @Nullable
    private <T extends J> T convertOrNull(@Nullable com.sun.source.tree.Tree t, Function<com.sun.source.tree.Tree, String> suffix) {
        return t == null ? null : (T)this.convert(t, suffix);
    }

    private <T extends J> List<T> convertAll(List<? extends com.sun.source.tree.Tree> trees, Function<com.sun.source.tree.Tree, String> innerSuffix, Function<com.sun.source.tree.Tree, String> suffix) {
        ArrayList<T> converted = new ArrayList<T>(trees.size());
        for (int i = 0; i < trees.size(); ++i) {
            converted.add(this.convert(trees.get(i), i == trees.size() - 1 ? suffix : innerSuffix));
        }
        return converted;
    }

    private J.TypeParameters convertTypeParameters(List<? extends com.sun.source.tree.Tree> typeArguments) {
        if (typeArguments == null) {
            return null;
        }
        String typeArgPrefix = this.sourceBefore("<");
        List<Object> typeArgs = typeArguments.isEmpty() ? Collections.singletonList(new J.Empty(Tree.randomId(), Formatting.format((String)"", (String)this.sourceBefore(">")))) : this.convertAll(typeArguments, this.commaDelim, t -> this.sourceBefore(">"));
        ArrayList<J.TypeParameter> params = new ArrayList<J.TypeParameter>();
        for (Expression expression : typeArgs) {
            J.TypeParameter typeParameter = new J.TypeParameter(Tree.randomId(), Collections.emptyList(), (Expression)expression.withFormatting(Formatting.EMPTY), null, expression.getFormatting());
            params.add(typeParameter);
        }
        return new J.TypeParameters(Tree.randomId(), params, Formatting.format((String)typeArgPrefix));
    }

    private <T extends J> List<T> convertPossibleMultiVariable(@Nullable List<? extends com.sun.source.tree.Tree> trees) {
        if (trees == null) {
            return Collections.emptyList();
        }
        LinkedHashMap<Integer, List> treesGroupedByStartPosition = new LinkedHashMap<Integer, List>();
        for (com.sun.source.tree.Tree tree : trees) {
            treesGroupedByStartPosition.computeIfAbsent(((JCTree)tree).getStartPosition(), k -> new ArrayList()).add(tree);
        }
        ArrayList<Object> converted = new ArrayList<Object>();
        for (List treeGroup : treesGroupedByStartPosition.values()) {
            if (treeGroup.size() == 1) {
                converted.add(this.convert((com.sun.source.tree.Tree)treeGroup.get(0), this.statementDelim));
                continue;
            }
            String prefix = this.source.substring(this.cursor, Math.max(((JCTree)treeGroup.get(0)).getStartPosition(), this.cursor));
            this.cursor += prefix.length();
            com.sun.source.tree.Tree last = (com.sun.source.tree.Tree)treeGroup.get(treeGroup.size() - 1);
            J.VariableDecls vars = this.visitVariables(treeGroup, Formatting.format((String)prefix));
            vars = (J.VariableDecls)vars.withSuffix(this.semiDelim.apply(last));
            this.cursor(Math.max(this.endPos(last), this.cursor));
            converted.add(vars);
        }
        return converted;
    }

    private Set<Flag> filteredFlags(Symbol sym) {
        HashSet<Flag> set = new HashSet<Flag>();
        for (Map.Entry<Long, Flag> mask : this.flagMasks.entrySet()) {
            if ((sym.flags() & mask.getKey()) == 0L) continue;
            Flag value = mask.getValue();
            set.add(value);
        }
        return set;
    }

    @Nullable
    private JavaType type(@Nullable Symbol symbol) {
        if (symbol instanceof Symbol.ClassSymbol || symbol instanceof Symbol.TypeVariableSymbol) {
            return this.type(symbol.type);
        }
        if (symbol instanceof Symbol.VarSymbol) {
            return new JavaType.GenericTypeVariable(symbol.name.toString(), null);
        }
        return null;
    }

    @Nullable
    private JavaType type(@Nullable Type type) {
        return this.type(type, Collections.emptyList());
    }

    @Nullable
    private JavaType type(@Nullable Type type, List<Symbol> stack) {
        return this.type(type, stack, false);
    }

    @Nullable
    private JavaType type(@Nullable Type type, List<Symbol> stack, boolean shallow) {
        if (type instanceof Type.ClassType) {
            List interfaces;
            List typeParameters;
            List fields;
            if (type instanceof Type.ErrorType) {
                return null;
            }
            Symbol.ClassSymbol sym = (Symbol.ClassSymbol)type.tsym;
            if (stack.contains(sym)) {
                return new JavaType.Cyclic(sym.className());
            }
            if (shallow) {
                return new JavaType.ShallowClass(sym.className());
            }
            JavaType.Class flyweight = this.sharedClassTypes.get(sym.className());
            if (flyweight != null) {
                return flyweight;
            }
            ArrayList<Symbol> stackWithSym = new ArrayList<Symbol>(stack);
            stackWithSym.add(sym);
            if (sym.members_field == null) {
                fields = Collections.emptyList();
            } else {
                fields = new ArrayList();
                for (Symbol elem : sym.members_field.getSymbols()) {
                    if (!(elem instanceof Symbol.VarSymbol)) continue;
                    fields.add(new JavaType.Var(elem.name.toString(), this.type(elem.type, stackWithSym), this.filteredFlags(elem)));
                }
            }
            Type.ClassType classType = (Type.ClassType)type;
            Type.ClassType symType = (Type.ClassType)sym.type;
            if (classType.typarams_field == null) {
                typeParameters = Collections.emptyList();
            } else {
                typeParameters = new ArrayList();
                for (Type type2 : classType.typarams_field) {
                    JavaType javaType = this.type(type2, stackWithSym, true);
                    if (javaType == null) continue;
                    typeParameters.add(javaType);
                }
            }
            if (symType.interfaces_field == null) {
                interfaces = Collections.emptyList();
            } else {
                interfaces = new ArrayList();
                for (Type iParam : symType.interfaces_field) {
                    JavaType javaType = this.type(iParam, stackWithSym, false);
                    if (javaType == null) continue;
                    interfaces.add(javaType);
                }
            }
            JavaType.Class clazz = JavaType.Class.build((String)sym.className(), fields, typeParameters, interfaces, null, (JavaType.Class)TypeUtils.asClass((JavaType)this.type(classType.supertype_field, stackWithSym)), (boolean)this.relaxedClassTypeMatching);
            this.sharedClassTypes.put(sym.className(), clazz);
            return clazz;
        }
        if (type instanceof Type.TypeVar) {
            return new JavaType.GenericTypeVariable(type.tsym.name.toString(), TypeUtils.asClass((JavaType)this.type(type.getUpperBound(), stack)));
        }
        if (type instanceof Type.JCPrimitiveType) {
            return this.primitive(type.getTag());
        }
        if (type instanceof Type.ArrayType) {
            return new JavaType.Array(this.type(((Type.ArrayType)type).elemtype, stack));
        }
        if (Type.noType.equals(type)) {
            return null;
        }
        return null;
    }

    @Nullable
    private JavaType type(com.sun.source.tree.Tree t) {
        return this.type(((JCTree)t).type);
    }

    private JavaType.Primitive primitive(TypeTag tag) {
        switch (tag) {
            case BOOLEAN: {
                return JavaType.Primitive.Boolean;
            }
            case BYTE: {
                return JavaType.Primitive.Byte;
            }
            case CHAR: {
                return JavaType.Primitive.Char;
            }
            case DOUBLE: {
                return JavaType.Primitive.Double;
            }
            case FLOAT: {
                return JavaType.Primitive.Float;
            }
            case INT: {
                return JavaType.Primitive.Int;
            }
            case LONG: {
                return JavaType.Primitive.Long;
            }
            case SHORT: {
                return JavaType.Primitive.Short;
            }
            case VOID: {
                return JavaType.Primitive.Void;
            }
            case NONE: {
                return JavaType.Primitive.None;
            }
            case CLASS: {
                return JavaType.Primitive.String;
            }
            case BOT: {
                return JavaType.Primitive.Null;
            }
        }
        throw new IllegalArgumentException("Unknown type tag " + tag);
    }

    private int endPos(com.sun.source.tree.Tree t) {
        return ((JCTree)t).getEndPosition(this.endPosTable);
    }

    private String sourceBefore(String untilDelim) {
        return this.sourceBefore(untilDelim, null);
    }

    private String sourceBefore(String untilDelim, @Nullable Character stop) {
        int delimIndex = this.positionOfNext(untilDelim, stop);
        if (delimIndex < 0) {
            return "";
        }
        String prefix = this.source.substring(this.cursor, delimIndex);
        this.cursor += prefix.length() + untilDelim.length();
        return prefix;
    }

    private int positionOfNext(String untilDelim, @Nullable Character stop) {
        int delimIndex;
        boolean inMultiLineComment = false;
        boolean inSingleLineComment = false;
        for (delimIndex = this.cursor; delimIndex < this.source.length() - untilDelim.length() + 1; ++delimIndex) {
            if (inSingleLineComment && this.source.charAt(delimIndex) == '\n') {
                inSingleLineComment = false;
                continue;
            }
            if (this.source.length() - untilDelim.length() > delimIndex + 1) {
                switch (this.source.substring(delimIndex, delimIndex + 2)) {
                    case "//": {
                        inSingleLineComment = true;
                        ++delimIndex;
                        break;
                    }
                    case "/*": {
                        inMultiLineComment = true;
                        ++delimIndex;
                        break;
                    }
                    case "*/": {
                        inMultiLineComment = false;
                        ++delimIndex;
                    }
                }
            }
            if (inMultiLineComment || inSingleLineComment) continue;
            if (stop != null && this.source.charAt(delimIndex) == stop.charValue()) {
                return -1;
            }
            if (this.source.startsWith(untilDelim, delimIndex)) break;
        }
        return delimIndex > this.source.length() - untilDelim.length() ? -1 : delimIndex;
    }

    private String whitespace() {
        return this.whitespace(null);
    }

    /*
     * Unable to fully structure code
     */
    private String whitespace(@Nullable com.sun.source.tree.Tree t) {
        inMultiLineComment = false;
        inSingleLineComment = false;
        block10: for (delimIndex = this.cursor; delimIndex < this.source.length(); ++delimIndex) {
            if (inSingleLineComment && (this.source.charAt(delimIndex) == '\n' || this.source.charAt(delimIndex) == '\r')) {
                inSingleLineComment = false;
                continue;
            }
            if (this.source.length() <= delimIndex + 1) ** GOTO lbl-1000
            var5_5 = this.source.substring(delimIndex, delimIndex + 2);
            var6_6 = -1;
            switch (var5_5.hashCode()) {
                case 1504: {
                    if (!var5_5.equals("//")) break;
                    var6_6 = 0;
                    break;
                }
                case 1499: {
                    if (!var5_5.equals("/*")) break;
                    var6_6 = 1;
                    break;
                }
                case 1349: {
                    if (!var5_5.equals("*/")) break;
                    var6_6 = 2;
                }
            }
            switch (var6_6) {
                case 0: {
                    inSingleLineComment = true;
                    ++delimIndex;
                    continue block10;
                }
                case 1: {
                    inMultiLineComment = true;
                    ++delimIndex;
                    continue block10;
                }
                case 2: {
                    inMultiLineComment = false;
                    ++delimIndex;
                    continue block10;
                }
                default: lbl-1000:
                // 2 sources

                {
                    if (!inMultiLineComment && !inSingleLineComment && !Character.isWhitespace(this.source.substring(delimIndex, delimIndex + 1).charAt(0))) break block10;
                }
            }
        }
        prefix = this.source.substring(this.cursor, delimIndex);
        this.cursor += prefix.length();
        return prefix;
    }

    @Nullable
    private String skip(@Nullable String token) {
        if (token == null) {
            return null;
        }
        if (this.source.startsWith(token, this.cursor)) {
            this.cursor += token.length();
        }
        return token;
    }

    private void skipPattern(String pattern) {
        Matcher matcher = Pattern.compile("\\G" + pattern).matcher(this.source);
        if (matcher.find(this.cursor)) {
            this.cursor(matcher.end());
        }
    }

    private void cursor(int n) {
        this.cursor = n;
    }

    private boolean hasFlag(ModifiersTree modifiers, long flag) {
        return (((JCTree.JCModifiers)modifiers).flags & flag) != 0L;
    }

    private List<String> listFlags(long flags) {
        Map<String, Long> allFlags = Arrays.stream(Flags.class.getDeclaredFields()).filter(field -> {
            field.setAccessible(true);
            try {
                return field.get(null) instanceof Long && field.getName().matches("[A-Z_]+");
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toMap(Field::getName, field -> {
            try {
                return (Long)field.get(null);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }));
        ArrayList<String> all = new ArrayList<String>();
        for (Map.Entry<String, Long> flagNameAndCode : allFlags.entrySet()) {
            if ((flagNameAndCode.getValue() & flags) == 0L) continue;
            all.add(flagNameAndCode.getKey());
        }
        return all;
    }

    private List<J.Modifier> sortedFlags(ModifiersTree modifiers) {
        if (modifiers.getFlags().isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Modifier> sortedModifiers = new ArrayList<Modifier>();
        boolean inComment = false;
        boolean inMultilineComment = false;
        AtomicReference<String> word = new AtomicReference<String>("");
        for (int i = this.cursor; i < this.source.length(); ++i) {
            char c = this.source.charAt(i);
            if (c == '/' && this.source.length() > i + 1) {
                char next = this.source.charAt(i + 1);
                if (next == '*') {
                    inMultilineComment = true;
                } else if (next == '/') {
                    inComment = true;
                }
            }
            if (inMultilineComment && c == '/' && this.source.charAt(i - 1) == '*') {
                inMultilineComment = false;
                continue;
            }
            if (inComment && c == '\n' || c == '\r') {
                inComment = false;
                continue;
            }
            if (inMultilineComment || inComment) continue;
            if (Character.isWhitespace(c)) {
                if (word.get().isEmpty()) continue;
                Modifier matching = null;
                for (Modifier modifier : modifiers.getFlags()) {
                    if (!modifier.name().toLowerCase().equals(word.get())) continue;
                    matching = modifier;
                    break;
                }
                if (matching == null) break;
                sortedModifiers.add(matching);
                word.set("");
                continue;
            }
            word.getAndUpdate(w -> w + c);
        }
        ArrayList<J.Modifier> mappedModifiers = new ArrayList<J.Modifier>();
        block16: for (Modifier mod : sortedModifiers) {
            Formatting modFormat = Formatting.format((String)this.whitespace());
            this.cursor += mod.name().length();
            switch (mod) {
                case DEFAULT: {
                    mappedModifiers.add((J.Modifier)new J.Modifier.Default(Tree.randomId(), modFormat));
                    continue block16;
                }
                case PUBLIC: {
                    mappedModifiers.add((J.Modifier)new J.Modifier.Public(Tree.randomId(), modFormat));
                    continue block16;
                }
                case PROTECTED: {
                    mappedModifiers.add((J.Modifier)new J.Modifier.Protected(Tree.randomId(), modFormat));
                    continue block16;
                }
                case PRIVATE: {
                    mappedModifiers.add((J.Modifier)new J.Modifier.Private(Tree.randomId(), modFormat));
                    continue block16;
                }
                case ABSTRACT: {
                    mappedModifiers.add((J.Modifier)new J.Modifier.Abstract(Tree.randomId(), modFormat));
                    continue block16;
                }
                case STATIC: {
                    mappedModifiers.add((J.Modifier)new J.Modifier.Static(Tree.randomId(), modFormat));
                    continue block16;
                }
                case FINAL: {
                    mappedModifiers.add((J.Modifier)new J.Modifier.Final(Tree.randomId(), modFormat));
                    continue block16;
                }
                case NATIVE: {
                    mappedModifiers.add((J.Modifier)new J.Modifier.Native(Tree.randomId(), modFormat));
                    continue block16;
                }
                case STRICTFP: {
                    mappedModifiers.add((J.Modifier)new J.Modifier.Strictfp(Tree.randomId(), modFormat));
                    continue block16;
                }
                case SYNCHRONIZED: {
                    mappedModifiers.add((J.Modifier)new J.Modifier.Synchronized(Tree.randomId(), modFormat));
                    continue block16;
                }
                case TRANSIENT: {
                    mappedModifiers.add((J.Modifier)new J.Modifier.Transient(Tree.randomId(), modFormat));
                    continue block16;
                }
                case VOLATILE: {
                    mappedModifiers.add((J.Modifier)new J.Modifier.Volatile(Tree.randomId(), modFormat));
                    continue block16;
                }
            }
            throw new IllegalArgumentException("Unexpected modifier " + mod);
        }
        return mappedModifiers;
    }
}

