/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.hcl.format;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Tree;
import org.openrewrite.hcl.HclIsoVisitor;
import org.openrewrite.hcl.style.SpacesStyle;
import org.openrewrite.hcl.tree.BodyContent;
import org.openrewrite.hcl.tree.Expression;
import org.openrewrite.hcl.tree.Hcl;
import org.openrewrite.hcl.tree.HclLeftPadded;
import org.openrewrite.internal.StringUtils;

public class AttributeSpaceVisitor<P>
extends HclIsoVisitor<P> {
    private final @Nullable Tree stopAfter;
    private final SpacesStyle style;

    public AttributeSpaceVisitor(SpacesStyle style) {
        this(style, null);
    }

    public AttributeSpaceVisitor(SpacesStyle style, @Nullable Tree stopAfter) {
        this.style = style;
        this.stopAfter = stopAfter;
    }

    @Override
    public Hcl.Attribute visitAttribute(Hcl.Attribute attribute, P p) {
        Hcl a = super.visitAttribute(attribute, (Object)p);
        Hcl parent = (Hcl)this.getCursor().getParentTreeCursor().getValue();
        if (parent instanceof Hcl.Block || parent instanceof Hcl.ObjectValue) {
            List<Hcl.Attribute> siblingAttributes = this.getSiblingAttributes(parent);
            if (attribute.getType() == Hcl.Attribute.Type.Assignment) {
                HclLeftPadded<Hcl.Attribute.Type> type = ((Hcl.Attribute)a).getPadding().getType();
                if (Boolean.TRUE.equals(this.style.getBodyContent().getColumnarAlignment())) {
                    List<Hcl.Attribute> groupAttributes = this.attributesInGroup(siblingAttributes, attribute);
                    int rightMostColumnOfAttributeKey = 0;
                    for (Hcl.Attribute sibling : groupAttributes) {
                        rightMostColumnOfAttributeKey = Math.max(rightMostColumnOfAttributeKey, this.endColumn(sibling));
                    }
                    rightMostColumnOfAttributeKey = Math.max(rightMostColumnOfAttributeKey, this.endColumn((Hcl.Attribute)a));
                    int indent = rightMostColumnOfAttributeKey - this.endColumn((Hcl.Attribute)a) + 1;
                    a = ((Hcl.Attribute)a).getPadding().withType(type.withBefore(type.getBefore().withWhitespace(StringUtils.repeat((String)" ", (int)indent))));
                } else if (Boolean.FALSE.equals(this.style.getBodyContent().getColumnarAlignment())) {
                    a = ((Hcl.Attribute)a).getPadding().withType(type.withBefore(type.getBefore().withWhitespace(" ")));
                }
            }
        }
        return a;
    }

    private List<Hcl.Attribute> getSiblingAttributes(Hcl parent) {
        ArrayList<Hcl.Attribute> allAttributes = new ArrayList<Hcl.Attribute>();
        if (parent instanceof Hcl.Block) {
            for (BodyContent bc : ((Hcl.Block)parent).getBody()) {
                if (!(bc instanceof Hcl.Attribute)) continue;
                allAttributes.add((Hcl.Attribute)bc);
            }
        } else {
            for (Expression expr : ((Hcl.ObjectValue)parent).getAttributes()) {
                if (!(expr instanceof Hcl.Attribute)) continue;
                allAttributes.add((Hcl.Attribute)expr);
            }
        }
        return allAttributes;
    }

    private List<Hcl.Attribute> attributesInGroup(List<Hcl.Attribute> siblings, Hcl.Attribute attribute) {
        boolean isAttributeMultiline;
        boolean bl = isAttributeMultiline = attribute.getValue().print(this.getCursor()).split("\r\n|\r|\n").length > 2;
        if (isAttributeMultiline) {
            return Collections.singletonList(attribute);
        }
        ArrayList<Hcl.Attribute> groupAttributes = new ArrayList<Hcl.Attribute>();
        boolean groupFound = false;
        Hcl.Attribute perviousSibling = null;
        for (Hcl.Attribute sibling : siblings) {
            boolean newGroup;
            if (sibling.getType() != Hcl.Attribute.Type.Assignment) continue;
            boolean siblingPrefixHasNewLines = sibling.getPrefix().getWhitespace().split("\r\n|\r|\n").length > 2;
            boolean siblingIsMultiline = sibling.getValue().print(this.getCursor()).split("\r\n|\r|\n").length > 2;
            boolean previousSiblingIsMultiline = perviousSibling != null && perviousSibling.getValue().print(this.getCursor()).split("\r\n|\r|\n").length > 2;
            boolean bl2 = newGroup = siblingPrefixHasNewLines || previousSiblingIsMultiline || siblingIsMultiline;
            if (newGroup) {
                if (groupFound) break;
                groupAttributes.clear();
            }
            if (sibling.getId() == attribute.getId()) {
                groupFound = true;
            }
            groupAttributes.add(sibling);
            perviousSibling = sibling;
        }
        return groupAttributes;
    }

    private int endColumn(Hcl.Attribute attribute) {
        return (attribute.getPrefix().getIndent() + attribute.getName().print(this.getCursor())).length();
    }

    public @Nullable Hcl postVisit(Hcl tree, P p) {
        if (this.stopAfter != null && this.stopAfter.isScope((Tree)tree)) {
            this.getCursor().putMessageOnFirstEnclosing(Hcl.ConfigFile.class, "stop", (Object)true);
        }
        return (Hcl)super.postVisit((Tree)tree, p);
    }

    public @Nullable Hcl visit(@Nullable Tree tree, P p) {
        if (this.getCursor().getNearestMessage("stop") != null) {
            return (Hcl)tree;
        }
        return (Hcl)super.visit(tree, p);
    }
}

