/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.hcl.format;

import java.util.Optional;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.Tree;
import org.openrewrite.hcl.HclVisitor;
import org.openrewrite.hcl.format.BlankLinesStyle;
import org.openrewrite.hcl.format.BlankLinesVisitor;
import org.openrewrite.hcl.format.BracketsVisitor;
import org.openrewrite.hcl.format.NormalizeFormatVisitor;
import org.openrewrite.hcl.format.RemoveTrailingWhitespaceVisitor;
import org.openrewrite.hcl.format.SpacesVisitor;
import org.openrewrite.hcl.format.TabsAndIndentsVisitor;
import org.openrewrite.hcl.style.BracketsStyle;
import org.openrewrite.hcl.style.SpacesStyle;
import org.openrewrite.hcl.style.TabsAndIndentsStyle;
import org.openrewrite.hcl.tree.Hcl;

public class AutoFormatVisitor<P>
extends HclVisitor<P> {
    private final @Nullable Tree stopAfter;

    public AutoFormatVisitor() {
        this(null);
    }

    public AutoFormatVisitor(@Nullable Tree stopAfter) {
        this.stopAfter = stopAfter;
    }

    public @Nullable Hcl preVisit(Hcl tree, P p) {
        this.stopAfterPreVisit();
        Cursor cursor = this.getCursor().getParentOrThrow();
        Hcl.ConfigFile cf = (Hcl.ConfigFile)this.getCursor().firstEnclosingOrThrow(Hcl.ConfigFile.class);
        Hcl t = (Hcl)new NormalizeFormatVisitor().visit(tree, p, cursor.fork());
        t = (Hcl)new BracketsVisitor(Optional.ofNullable((BracketsStyle)cf.getStyle(BracketsStyle.class)).orElse(BracketsStyle.DEFAULT), this.stopAfter).visit(t, p, cursor.fork());
        t = new TabsAndIndentsVisitor(Optional.ofNullable((TabsAndIndentsStyle)cf.getStyle(TabsAndIndentsStyle.class)).orElse(TabsAndIndentsStyle.DEFAULT), this.stopAfter).visit((Tree)t, (Object)p, cursor.fork());
        t = (Hcl)new SpacesVisitor(Optional.ofNullable((SpacesStyle)cf.getStyle(SpacesStyle.class)).orElse(SpacesStyle.DEFAULT), this.stopAfter).visit(t, p, cursor.fork());
        t = (Hcl)new BlankLinesVisitor(Optional.ofNullable((BlankLinesStyle)cf.getStyle(BlankLinesStyle.class)).orElse(BlankLinesStyle.DEFAULT), this.stopAfter).visit(t, p, cursor.fork());
        if (t instanceof Hcl.ConfigFile) {
            t = this.visitConfigFile((Hcl.ConfigFile)t, p);
        }
        return t;
    }

    @Override
    public Hcl visitConfigFile(Hcl.ConfigFile cf, P p) {
        Hcl.ConfigFile t = (Hcl.ConfigFile)new RemoveTrailingWhitespaceVisitor().visit(cf, p);
        t = (Hcl.ConfigFile)new NormalizeFormatVisitor().visit(t, p);
        t = (Hcl.ConfigFile)new BracketsVisitor(Optional.ofNullable((BracketsStyle)cf.getStyle(BracketsStyle.class)).orElse(BracketsStyle.DEFAULT), this.stopAfter).visit((Tree)t, (Object)p);
        t = (Hcl.ConfigFile)new TabsAndIndentsVisitor(Optional.ofNullable((TabsAndIndentsStyle)cf.getStyle(TabsAndIndentsStyle.class)).orElse(TabsAndIndentsStyle.DEFAULT), this.stopAfter).visit((Tree)t, (Object)p);
        t = (Hcl.ConfigFile)new SpacesVisitor(Optional.ofNullable((SpacesStyle)cf.getStyle(SpacesStyle.class)).orElse(SpacesStyle.DEFAULT), this.stopAfter).visit((Tree)t, (Object)p);
        t = (Hcl.ConfigFile)new BlankLinesVisitor(Optional.ofNullable((BlankLinesStyle)cf.getStyle(BlankLinesStyle.class)).orElse(BlankLinesStyle.DEFAULT), this.stopAfter).visit((Tree)t, (Object)p);
        assert (t != null);
        return t;
    }
}

