/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.hcl;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.SourceFile;
import org.openrewrite.hcl.HclParsingException;
import org.openrewrite.hcl.internal.HclParserVisitor;
import org.openrewrite.hcl.internal.grammar.HCLLexer;
import org.openrewrite.hcl.internal.grammar.HCLParser;
import org.openrewrite.hcl.tree.Hcl;
import org.openrewrite.internal.EncodingDetectingInputStream;
import org.openrewrite.marker.Markers;
import org.openrewrite.style.NamedStyles;
import org.openrewrite.tree.ParseError;
import org.openrewrite.tree.ParsingEventListener;
import org.openrewrite.tree.ParsingExecutionContextView;

public class HclParser
implements Parser {
    private final List<NamedStyles> styles;

    private HclParser(List<NamedStyles> styles) {
        this.styles = styles;
    }

    public Stream<SourceFile> parseInputs(Iterable<Parser.Input> sourceFiles, @Nullable Path relativeTo, ExecutionContext ctx) {
        ParsingEventListener parsingListener = ParsingExecutionContextView.view((ExecutionContext)ctx).getParsingListener();
        return this.acceptedInputs(sourceFiles).map(input -> {
            try {
                parsingListener.startedParsing(input);
                EncodingDetectingInputStream is = input.getSource(ctx);
                String sourceStr = is.readFully();
                HCLLexer lexer = new HCLLexer((CharStream)CharStreams.fromString((String)sourceStr));
                lexer.removeErrorListeners();
                lexer.addErrorListener((ANTLRErrorListener)new ForwardingErrorListener(input.getPath(), ctx));
                HCLParser parser = new HCLParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
                parser.removeErrorListeners();
                parser.addErrorListener((ANTLRErrorListener)new ForwardingErrorListener(input.getPath(), ctx));
                Hcl.ConfigFile configFile = (Hcl.ConfigFile)new HclParserVisitor(input.getRelativePath(relativeTo), sourceStr, is.getCharset(), is.isCharsetBomMarked(), input.getFileAttributes()).visitConfigFile(parser.configFile());
                configFile = configFile.withMarkers(Markers.build(this.styles));
                parsingListener.parsed(input, (SourceFile)configFile);
                return this.requirePrintEqualsInput(configFile, (Parser.Input)input, relativeTo, ctx);
            }
            catch (Throwable t) {
                ctx.getOnError().accept(t);
                return ParseError.build((Parser)this, (Parser.Input)input, (Path)relativeTo, (ExecutionContext)ctx, (Throwable)t);
            }
        });
    }

    public boolean accept(Path path) {
        return path.toString().endsWith(".tf") || path.toString().endsWith(".tfvars");
    }

    public Path sourcePathFromSourceText(Path prefix, String sourceCode) {
        return prefix.resolve("file.tf");
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends Parser.Builder {
        protected final List<NamedStyles> styles = new ArrayList<NamedStyles>();

        public Builder() {
            super(Hcl.ConfigFile.class);
        }

        public Builder styles(Iterable<? extends NamedStyles> styles) {
            for (NamedStyles namedStyles : styles) {
                this.styles.add(namedStyles);
            }
            return this;
        }

        public HclParser build() {
            return new HclParser(this.styles);
        }

        public String getDslName() {
            return "hcl";
        }
    }

    private static class ForwardingErrorListener
    extends BaseErrorListener {
        private final Path sourcePath;
        private final ExecutionContext ctx;

        private ForwardingErrorListener(Path sourcePath, ExecutionContext ctx) {
            this.sourcePath = sourcePath;
            this.ctx = ctx;
        }

        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
            this.ctx.getOnError().accept(new HclParsingException(this.sourcePath, String.format("Syntax error in %s at line %d:%d %s.", this.sourcePath, line, charPositionInLine, msg), e));
        }
    }
}

