/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.hcl.format;

import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.TreeVisitor;
import org.openrewrite.hcl.HclIsoVisitor;
import org.openrewrite.hcl.format.BlankLinesStyle;
import org.openrewrite.hcl.format.BlankLinesVisitor;
import org.openrewrite.hcl.tree.Hcl;

public class BlankLines
extends Recipe {
    public String getDisplayName() {
        return "Blank lines";
    }

    public String getDescription() {
        return "Add and/or remove blank lines.";
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new BlankLinesFromCompilationUnitStyle();
    }

    public static <H extends Hcl> H formatBlankLines(Hcl j, Cursor cursor) {
        BlankLinesStyle style = (BlankLinesStyle)((SourceFile)cursor.firstEnclosingOrThrow(SourceFile.class)).getStyle(BlankLinesStyle.class);
        return (H)((Hcl)new BlankLinesVisitor(style == null ? BlankLinesStyle.DEFAULT : style).visitNonNull(j, 0, cursor));
    }

    private static class BlankLinesFromCompilationUnitStyle
    extends HclIsoVisitor<ExecutionContext> {
        private BlankLinesFromCompilationUnitStyle() {
        }

        @Override
        public Hcl.ConfigFile visitConfigFile(Hcl.ConfigFile configFile, ExecutionContext ctx) {
            BlankLinesStyle style = (BlankLinesStyle)configFile.getStyle(BlankLinesStyle.class);
            if (style == null) {
                style = BlankLinesStyle.DEFAULT;
            }
            this.doAfterVisit(new BlankLinesVisitor(style));
            return configFile;
        }
    }
}

