/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.hcl;

import java.util.List;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.hcl.format.AutoFormatVisitor;
import org.openrewrite.hcl.tree.BodyContent;
import org.openrewrite.hcl.tree.Expression;
import org.openrewrite.hcl.tree.Hcl;
import org.openrewrite.hcl.tree.HclContainer;
import org.openrewrite.hcl.tree.HclLeftPadded;
import org.openrewrite.hcl.tree.HclRightPadded;
import org.openrewrite.hcl.tree.Label;
import org.openrewrite.hcl.tree.Space;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.Nullable;

public class HclVisitor<P>
extends TreeVisitor<Hcl, P> {
    public <H extends Hcl> H autoFormat(H h, P p) {
        return this.autoFormat(h, p, this.getCursor());
    }

    public <H extends Hcl> H autoFormat(H h, P p, Cursor cursor) {
        return this.autoFormat(h, null, p, cursor);
    }

    public <H extends Hcl> H autoFormat(H h, @Nullable Hcl stopAfter, P p, Cursor cursor) {
        return (H)new AutoFormatVisitor(stopAfter).visit((Tree)h, (Object)p, cursor);
    }

    public boolean isAcceptable(SourceFile sourceFile, ExecutionContext ctx) {
        return sourceFile instanceof Hcl.ConfigFile;
    }

    public String getLanguage() {
        return "HCL";
    }

    public Hcl visitAttribute(Hcl.Attribute attribute, P p) {
        Hcl.Attribute a = attribute;
        a = a.withPrefix(this.visitSpace(a.getPrefix(), Space.Location.ATTRIBUTE, p));
        a = a.withMarkers(this.visitMarkers(a.getMarkers(), p));
        a = (Hcl.Attribute)this.visitBodyContent(a, p);
        a = a.withName((Hcl.Identifier)this.visit(a.getName(), p));
        this.visitSpace(a.getPadding().getType().getBefore(), Space.Location.ATTRIBUTE_ASSIGNMENT, p);
        a = a.withValue((Expression)this.visit(a.getValue(), p));
        return a;
    }

    public Hcl visitAttributeAccess(Hcl.AttributeAccess attributeAccess, P p) {
        Hcl.AttributeAccess a = attributeAccess;
        a = a.withPrefix(this.visitSpace(a.getPrefix(), Space.Location.ATTRIBUTE_ACCESS, p));
        Expression temp = (Expression)this.visitExpression(a = a.withMarkers(this.visitMarkers(a.getMarkers(), p)), p);
        if (!(temp instanceof Hcl.AttributeAccess)) {
            return temp;
        }
        a = (Hcl.AttributeAccess)temp;
        a = a.withAttribute((Expression)this.visit(a.getAttribute(), p));
        a = a.getPadding().withName(this.visitLeftPadded(a.getPadding().getName(), HclLeftPadded.Location.ATTRIBUTE_ACCESS_NAME, p));
        return a;
    }

    public Hcl visitBinary(Hcl.Binary binary, P p) {
        Hcl.Binary b = binary;
        b = b.withPrefix(this.visitSpace(b.getPrefix(), Space.Location.BINARY, p));
        Expression temp = (Expression)this.visitExpression(b = b.withMarkers(this.visitMarkers(b.getMarkers(), p)), p);
        if (!(temp instanceof Hcl.Binary)) {
            return temp;
        }
        b = (Hcl.Binary)temp;
        b = b.withLeft((Expression)this.visit(b.getLeft(), p));
        b = b.getPadding().withOperator(b.getPadding().getOperator().withBefore(this.visitSpace(b.getPrefix(), Space.Location.BINARY_OPERATOR, p)));
        b = b.withRight((Expression)this.visit(b.getRight(), p));
        return b;
    }

    public Hcl visitBlock(Hcl.Block block, P p) {
        Hcl.Block b = block;
        b = b.withPrefix(this.visitSpace(b.getPrefix(), Space.Location.BLOCK, p));
        Expression temp = (Expression)this.visitBodyContent(b = b.withMarkers(this.visitMarkers(b.getMarkers(), p)), p);
        if (!(temp instanceof Hcl.Block)) {
            return temp;
        }
        b = (Hcl.Block)temp;
        b = b.withType((Hcl.Identifier)this.visit(b.getType(), p));
        b = b.withLabels(ListUtils.map(b.getLabels(), l -> (Label)this.visit((Tree)l, p)));
        b = b.withOpen(this.visitSpace(b.getOpen(), Space.Location.BLOCK_OPEN, p));
        b = b.withBody(ListUtils.map(b.getBody(), bc -> (BodyContent)this.visit((Tree)bc, p)));
        b = b.withClose(this.visitSpace(b.getClose(), Space.Location.BLOCK_CLOSE, p));
        return b;
    }

    public Hcl visitBodyContent(BodyContent bodyContent, P p) {
        return bodyContent;
    }

    public Hcl visitConditional(Hcl.Conditional conditional, P p) {
        Hcl.Conditional c = conditional;
        c = c.withPrefix(this.visitSpace(c.getPrefix(), Space.Location.CONDITIONAL, p));
        Expression temp = (Expression)this.visitExpression(c = c.withMarkers(this.visitMarkers(c.getMarkers(), p)), p);
        if (!(temp instanceof Hcl.Conditional)) {
            return temp;
        }
        c = (Hcl.Conditional)temp;
        c = c.withCondition((Expression)this.visit(c.getCondition(), p));
        c = c.getPadding().withTruePart(this.visitLeftPadded(c.getPadding().getTruePart(), HclLeftPadded.Location.CONDITIONAL_TRUE, p));
        c = c.getPadding().withFalsePart(this.visitLeftPadded(c.getPadding().getFalsePart(), HclLeftPadded.Location.CONDITIONAL_FALSE, p));
        return c;
    }

    public Hcl visitConfigFile(Hcl.ConfigFile configFile, P p) {
        Hcl.ConfigFile c = configFile;
        c = c.withPrefix(this.visitSpace(c.getPrefix(), Space.Location.CONFIG_FILE, p));
        c = c.withMarkers(this.visitMarkers(c.getMarkers(), p));
        c = c.withBody(ListUtils.map(c.getBody(), bc -> (BodyContent)this.visit((Tree)bc, p)));
        return c;
    }

    public Hcl visitEmpty(Hcl.Empty empty, P p) {
        Hcl.Empty e = empty;
        e = e.withPrefix(this.visitSpace(e.getPrefix(), Space.Location.EMPTY, p));
        e = e.withMarkers(this.visitMarkers(e.getMarkers(), p));
        return e;
    }

    public Hcl visitForIntro(Hcl.ForIntro forIntro, P p) {
        Hcl.ForIntro f = forIntro;
        f = f.withPrefix(this.visitSpace(f.getPrefix(), Space.Location.FOR_INTRO, p));
        f = f.withMarkers(this.visitMarkers(f.getMarkers(), p));
        f = f.getPadding().withVariables(this.visitContainer(f.getPadding().getVariables(), HclContainer.Location.FOR_VARIABLES, p));
        f = f.withIn((Expression)this.visit(f.getIn(), p));
        return f;
    }

    public Hcl visitForObject(Hcl.ForObject forObject, P p) {
        Hcl.ForObject f = forObject;
        f = f.withPrefix(this.visitSpace(f.getPrefix(), Space.Location.OBJECT_VALUE, p));
        Expression temp = (Expression)this.visitExpression(f = f.withMarkers(this.visitMarkers(f.getMarkers(), p)), p);
        if (!(temp instanceof Hcl.ForObject)) {
            return temp;
        }
        f = (Hcl.ForObject)temp;
        f = f.withIntro((Hcl.ForIntro)this.visit(f.getIntro(), p));
        f = f.getPadding().withUpdateName(this.visitLeftPadded(f.getPadding().getUpdateName(), HclLeftPadded.Location.FOR_UPDATE, p));
        if ((f = f.getPadding().withUpdateValue(this.visitLeftPadded(f.getPadding().getUpdateValue(), HclLeftPadded.Location.FOR_UPDATE_VALUE, p))).getPadding().getCondition() != null) {
            f = f.getPadding().withCondition(this.visitLeftPadded(f.getPadding().getCondition(), HclLeftPadded.Location.FOR_CONDITION, p));
        }
        this.visitSpace(f.getEnd(), Space.Location.FOR_TUPLE_SUFFIX, p);
        return f;
    }

    public Hcl visitForTuple(Hcl.ForTuple forTuple, P p) {
        Hcl.ForTuple f = forTuple;
        f = f.withPrefix(this.visitSpace(f.getPrefix(), Space.Location.FOR_TUPLE, p));
        Expression temp = (Expression)this.visitExpression(f = f.withMarkers(this.visitMarkers(f.getMarkers(), p)), p);
        if (!(temp instanceof Hcl.ForTuple)) {
            return temp;
        }
        f = (Hcl.ForTuple)temp;
        f = f.withIntro((Hcl.ForIntro)this.visit(f.getIntro(), p));
        if ((f = f.getPadding().withUpdate(this.visitLeftPadded(f.getPadding().getUpdate(), HclLeftPadded.Location.FOR_UPDATE, p))).getPadding().getCondition() != null) {
            f = f.getPadding().withCondition(this.visitLeftPadded(f.getPadding().getCondition(), HclLeftPadded.Location.FOR_CONDITION, p));
        }
        this.visitSpace(f.getEnd(), Space.Location.FOR_TUPLE_SUFFIX, p);
        return f;
    }

    public Hcl visitFunctionCall(Hcl.FunctionCall functionCall, P p) {
        Hcl.FunctionCall f = functionCall;
        f = f.withPrefix(this.visitSpace(f.getPrefix(), Space.Location.FUNCTION_CALL, p));
        Expression temp = (Expression)this.visitExpression(f = f.withMarkers(this.visitMarkers(f.getMarkers(), p)), p);
        if (!(temp instanceof Hcl.FunctionCall)) {
            return temp;
        }
        f = (Hcl.FunctionCall)temp;
        f = f.withName((Hcl.Identifier)this.visit(f.getName(), p));
        f = f.getPadding().withArguments(this.visitContainer(f.getPadding().getArguments(), HclContainer.Location.FUNCTION_CALL_ARGUMENTS, p));
        return f;
    }

    public Hcl visitHeredocTemplate(Hcl.HeredocTemplate heredocTemplate, P p) {
        Hcl.HeredocTemplate h = heredocTemplate;
        h = h.withPrefix(this.visitSpace(h.getPrefix(), Space.Location.HEREDOC, p));
        Expression temp = (Expression)this.visitExpression(h = h.withMarkers(this.visitMarkers(h.getMarkers(), p)), p);
        if (!(temp instanceof Hcl.HeredocTemplate)) {
            return temp;
        }
        h = (Hcl.HeredocTemplate)temp;
        h = h.withDelimiter((Hcl.Identifier)this.visit(h.getDelimiter(), p));
        h = h.withExpressions(ListUtils.map(h.getExpressions(), e -> (Expression)this.visit((Tree)e, p)));
        h = h.withEnd(this.visitSpace(h.getEnd(), Space.Location.HEREDOC_END, p));
        return h;
    }

    public Hcl visitIdentifier(Hcl.Identifier identifier, P p) {
        Hcl.Identifier i = identifier;
        i = i.withPrefix(this.visitSpace(i.getPrefix(), Space.Location.IDENTIFIER, p));
        i = i.withMarkers(this.visitMarkers(i.getMarkers(), p));
        return i;
    }

    public Hcl visitIndex(Hcl.Index index, P p) {
        Hcl.Index i = index;
        i = i.withPrefix(this.visitSpace(i.getPrefix(), Space.Location.INDEX, p));
        i = i.withMarkers(this.visitMarkers(i.getMarkers(), p));
        i = i.withIndexed((Expression)this.visit(i.getIndexed(), p));
        i = i.withPosition((Hcl.Index.Position)this.visit(i.getPosition(), p));
        return i;
    }

    public Hcl visitIndexPosition(Hcl.Index.Position indexPosition, P p) {
        Hcl.Index.Position i = indexPosition;
        i = i.withPrefix(this.visitSpace(i.getPrefix(), Space.Location.INDEX_POSITION, p));
        i = i.withMarkers(this.visitMarkers(i.getMarkers(), p));
        i = i.getPadding().withPosition(this.visitRightPadded(i.getPadding().getPosition(), HclRightPadded.Location.INDEX_POSITION, p));
        return i;
    }

    public Hcl visitLiteral(Hcl.Literal literal, P p) {
        Hcl.Literal l = literal;
        l = l.withPrefix(this.visitSpace(l.getPrefix(), Space.Location.LITERAL, p));
        Expression temp = (Expression)this.visitExpression(l = l.withMarkers(this.visitMarkers(l.getMarkers(), p)), p);
        if (!(temp instanceof Hcl.Literal)) {
            return temp;
        }
        l = (Hcl.Literal)temp;
        return l;
    }

    public Hcl visitObjectValue(Hcl.ObjectValue objectValue, P p) {
        Hcl.ObjectValue o = objectValue;
        o = o.withPrefix(this.visitSpace(o.getPrefix(), Space.Location.OBJECT_VALUE, p));
        Expression temp = (Expression)this.visitExpression(o = o.withMarkers(this.visitMarkers(o.getMarkers(), p)), p);
        if (!(temp instanceof Hcl.ObjectValue)) {
            return temp;
        }
        o = (Hcl.ObjectValue)temp;
        o = o.getPadding().withAttributes(this.visitContainer(o.getPadding().getAttributes(), HclContainer.Location.OBJECT_VALUE_ATTRIBUTES, p));
        return o;
    }

    public Hcl visitParentheses(Hcl.Parentheses parentheses, P p) {
        Hcl.Parentheses pa = parentheses;
        pa = pa.withPrefix(this.visitSpace(pa.getPrefix(), Space.Location.ONE_LINE_BLOCK, p));
        Expression temp = (Expression)this.visitExpression(pa = pa.withMarkers(this.visitMarkers(pa.getMarkers(), p)), p);
        if (!(temp instanceof Hcl.Parentheses)) {
            return temp;
        }
        pa = (Hcl.Parentheses)temp;
        pa = pa.getPadding().withExpression(this.visitRightPadded(pa.getPadding().getExpression(), HclRightPadded.Location.PARENTHESES, p));
        return pa;
    }

    public Hcl visitQuotedTemplate(Hcl.QuotedTemplate template, P p) {
        Hcl.QuotedTemplate t = template;
        t = t.withPrefix(this.visitSpace(t.getPrefix(), Space.Location.QUOTED_TEMPLATE, p));
        Expression temp = (Expression)this.visitExpression(t = t.withMarkers(this.visitMarkers(t.getMarkers(), p)), p);
        if (!(temp instanceof Hcl.QuotedTemplate)) {
            return temp;
        }
        t = (Hcl.QuotedTemplate)temp;
        t = t.withExpressions(ListUtils.map(t.getExpressions(), e -> (Expression)this.visit((Tree)e, p)));
        return t;
    }

    public Hcl visitSplat(Hcl.Splat splat, P p) {
        Hcl.Splat s = splat;
        s = s.withPrefix(this.visitSpace(s.getPrefix(), Space.Location.SPLAT, p));
        Expression temp = (Expression)this.visitExpression(s = s.withMarkers(this.visitMarkers(s.getMarkers(), p)), p);
        if (!(temp instanceof Hcl.Splat)) {
            return temp;
        }
        s = (Hcl.Splat)temp;
        s = s.withSelect((Expression)this.visit(s.getSelect(), p));
        s = s.withOperator((Hcl.Splat.Operator)this.visit(s.getOperator(), p));
        return s;
    }

    public Hcl visitSplatOperator(Hcl.Splat.Operator splatOperator, P p) {
        Hcl.Splat.Operator s = splatOperator;
        s = s.withPrefix(this.visitSpace(s.getPrefix(), Space.Location.SPLAT, p));
        s = s.withMarkers(this.visitMarkers(s.getMarkers(), p));
        s = s.withSplat(this.visitRightPadded(s.getSplat(), HclRightPadded.Location.SPLAT_OPERATOR, p));
        return s;
    }

    public Hcl visitTemplateInterpolation(Hcl.TemplateInterpolation template, P p) {
        Hcl.TemplateInterpolation t = template;
        t = t.withPrefix(this.visitSpace(t.getPrefix(), Space.Location.TEMPLATE_INTERPOLATION, p));
        Expression temp = (Expression)this.visitExpression(t = t.withMarkers(this.visitMarkers(t.getMarkers(), p)), p);
        if (!(temp instanceof Hcl.TemplateInterpolation)) {
            return temp;
        }
        t = (Hcl.TemplateInterpolation)temp;
        t = t.withExpression((Expression)this.visit(t.getExpression(), p));
        return t;
    }

    public Hcl visitTuple(Hcl.Tuple tuple, P p) {
        Hcl.Tuple t = tuple;
        t = t.withPrefix(this.visitSpace(t.getPrefix(), Space.Location.TUPLE, p));
        Expression temp = (Expression)this.visitExpression(t = t.withMarkers(this.visitMarkers(t.getMarkers(), p)), p);
        if (!(temp instanceof Hcl.Tuple)) {
            return temp;
        }
        t = (Hcl.Tuple)temp;
        t = t.getPadding().withValues(this.visitContainer(t.getPadding().getValues(), HclContainer.Location.TUPLE_VALUES, p));
        return t;
    }

    public Hcl visitUnary(Hcl.Unary unary, P p) {
        Hcl.Unary u = unary;
        u = u.withPrefix(this.visitSpace(u.getPrefix(), Space.Location.UNARY, p));
        Expression temp = (Expression)this.visitExpression(u = u.withMarkers(this.visitMarkers(u.getMarkers(), p)), p);
        if (!(temp instanceof Hcl.Unary)) {
            return temp;
        }
        u = (Hcl.Unary)temp;
        u = u.withExpression((Expression)this.visit(u.getExpression(), p));
        return u;
    }

    public Hcl visitVariableExpression(Hcl.VariableExpression variableExpression, P p) {
        Hcl.VariableExpression v = variableExpression;
        v = v.withPrefix(this.visitSpace(v.getPrefix(), Space.Location.TEMPLATE_INTERPOLATION, p));
        Expression temp = (Expression)this.visitExpression(v = v.withMarkers(this.visitMarkers(v.getMarkers(), p)), p);
        if (!(temp instanceof Hcl.VariableExpression)) {
            return temp;
        }
        v = (Hcl.VariableExpression)temp;
        v = v.withName((Hcl.Identifier)this.visit(v.getName(), p));
        return v;
    }

    public Hcl visitExpression(Expression expression, P p) {
        return expression;
    }

    public <T> HclLeftPadded<T> visitLeftPadded(HclLeftPadded<T> left, HclLeftPadded.Location loc, P p) {
        this.setCursor(new Cursor(this.getCursor(), left));
        Space before = this.visitSpace(left.getBefore(), loc.getBeforeLocation(), p);
        Object t = left.getElement();
        if (t instanceof Hcl) {
            t = this.visitAndCast((Hcl)left.getElement(), p);
        }
        this.setCursor(this.getCursor().getParent());
        if (t == null) {
            return null;
        }
        return before == left.getBefore() && t == left.getElement() ? left : new HclLeftPadded<T>(before, t, left.getMarkers());
    }

    public <T> HclRightPadded<T> visitRightPadded(@Nullable HclRightPadded<T> right, HclRightPadded.Location loc, P p) {
        if (right == null) {
            return null;
        }
        this.setCursor(new Cursor(this.getCursor(), right));
        Object t = right.getElement();
        if (t instanceof Hcl) {
            t = this.visitAndCast((Hcl)right.getElement(), p);
        }
        this.setCursor(this.getCursor().getParent());
        if (t == null) {
            return null;
        }
        Space after = this.visitSpace(right.getAfter(), loc.getAfterLocation(), p);
        return after == right.getAfter() && t == right.getElement() ? right : new HclRightPadded<T>(t, after, right.getMarkers());
    }

    public <H extends Hcl> HclContainer<H> visitContainer(HclContainer<H> container, HclContainer.Location loc, P p) {
        this.setCursor(new Cursor(this.getCursor(), container));
        Space before = this.visitSpace(container.getBefore(), loc.getBeforeLocation(), p);
        List js = ListUtils.map(container.getPadding().getElements(), t -> this.visitRightPadded((HclRightPadded)t, loc.getElementLocation(), p));
        this.setCursor(this.getCursor().getParent());
        return js == container.getPadding().getElements() && before == container.getBefore() ? container : HclContainer.build(before, js, container.getMarkers());
    }

    public Space visitSpace(Space space, Space.Location loc, P p) {
        return space;
    }
}

