/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.hcl;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.openrewrite.Cursor;
import org.openrewrite.Tree;
import org.openrewrite.hcl.HclVisitor;
import org.openrewrite.hcl.format.AttributeSpaceVisitor;
import org.openrewrite.hcl.internal.template.HclTemplateParser;
import org.openrewrite.hcl.internal.template.Substitutions;
import org.openrewrite.hcl.style.SpacesStyle;
import org.openrewrite.hcl.tree.BodyContent;
import org.openrewrite.hcl.tree.Expression;
import org.openrewrite.hcl.tree.Hcl;
import org.openrewrite.hcl.tree.HclCoordinates;
import org.openrewrite.hcl.tree.Space;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.template.SourceTemplate;

public class HclTemplate
implements SourceTemplate<Hcl, HclCoordinates> {
    private final Supplier<Cursor> parentScopeGetter;
    private final String code;
    private final int parameterCount;
    private final Consumer<String> onAfterVariableSubstitution;
    private final HclTemplateParser templateParser;

    private HclTemplate(Supplier<Cursor> parentScopeGetter, String code, Consumer<String> onAfterVariableSubstitution, Consumer<String> onBeforeParseTemplate) {
        this.parentScopeGetter = parentScopeGetter;
        this.code = code;
        this.onAfterVariableSubstitution = onAfterVariableSubstitution;
        this.parameterCount = StringUtils.countOccurrences((String)code, (String)"#{");
        this.templateParser = new HclTemplateParser(onAfterVariableSubstitution, onBeforeParseTemplate);
    }

    public <H extends Hcl> H withTemplate(final Tree changing, HclCoordinates coordinates, Object[] parameters) {
        if (parameters.length != this.parameterCount) {
            throw new IllegalArgumentException("This template requires " + this.parameterCount + " parameters.");
        }
        final Substitutions substitutions = new Substitutions(this.code, parameters);
        final String substitutedTemplate = substitutions.substitute();
        this.onAfterVariableSubstitution.accept(substitutedTemplate);
        final Hcl insertionPoint = coordinates.getTree();
        final Space.Location loc = coordinates.getSpaceLocation();
        final AtomicReference parentCursorRef = new AtomicReference();
        new HclVisitor<Integer>(){

            @Nullable
            public Hcl visit(@Nullable Tree tree, Integer integer) {
                if (tree != null && tree.isScope(changing)) {
                    parentCursorRef.set(this.getCursor());
                    return (Hcl)tree;
                }
                return (Hcl)super.visit(tree, (Object)integer);
            }
        }.visit((Tree)this.parentScopeGetter.get().getValue(), 0, this.parentScopeGetter.get().getParentOrThrow());
        Cursor parentCursor = (Cursor)parentCursorRef.get();
        Hcl h = (Hcl)new HclVisitor<Integer>(){

            @Override
            public Hcl visitBlock(Hcl.Block block, Integer p) {
                Hcl.Block b = (Hcl.Block)super.visitBlock(block, p);
                if (loc.equals((Object)Space.Location.BLOCK_CLOSE)) {
                    if (b.isScope(insertionPoint)) {
                        List<BodyContent> gen = substitutions.unsubstitute(HclTemplate.this.templateParser.parseBodyContent(substitutedTemplate));
                        b = b.withBody(ListUtils.concatAll(block.getBody(), (List)ListUtils.map(gen, (i, s) -> this.autoFormat(i == 0 ? s.withPrefix(Space.format("\n")) : s, p, this.getCursor()))));
                        Hcl.ConfigFile cf = (Hcl.ConfigFile)this.getCursor().firstEnclosingOrThrow(Hcl.ConfigFile.class);
                        b = (Hcl.Block)new AttributeSpaceVisitor(Optional.ofNullable((SpacesStyle)cf.getStyle(SpacesStyle.class)).orElse(SpacesStyle.DEFAULT)).visit(b, p, this.getCursor().getParentOrThrow());
                        assert (b != null);
                    }
                } else if (loc.equals((Object)Space.Location.BLOCK) && b.isScope(insertionPoint)) {
                    b = (Hcl.Block)this.autoFormat(HclTemplate.this.templateParser.parseBodyContent(substitutedTemplate).get(0), p, this.getCursor().getParentOrThrow());
                }
                return b;
            }

            @Override
            public Hcl visitExpression(Expression expression, Integer p) {
                Hcl e = super.visitExpression(expression, p);
                if (loc.equals((Object)Space.Location.EXPRESSION_PREFIX) && e.isScope(insertionPoint)) {
                    e = HclTemplate.this.templateParser.parseExpression(substitutedTemplate).withPrefix(expression.getPrefix());
                }
                return e;
            }
        }.visit(changing, 0, parentCursor);
        assert (h != null);
        return (H)h;
    }

    public static Builder builder(Supplier<Cursor> parentScope, String code) {
        return new Builder(parentScope, code);
    }

    public static class Builder {
        private final Supplier<Cursor> parentScope;
        private final String code;
        private Consumer<String> onAfterVariableSubstitution = s -> {};
        private Consumer<String> onBeforeParseTemplate = s -> {};

        Builder(Supplier<Cursor> parentScope, String code) {
            this.parentScope = parentScope;
            this.code = code.trim();
        }

        public Builder doAfterVariableSubstitution(Consumer<String> afterVariableSubstitution) {
            this.onAfterVariableSubstitution = afterVariableSubstitution;
            return this;
        }

        public Builder doBeforeParseTemplate(Consumer<String> beforeParseTemplate) {
            this.onBeforeParseTemplate = beforeParseTemplate;
            return this;
        }

        public HclTemplate build() {
            return new HclTemplate(this.parentScope, this.code, this.onAfterVariableSubstitution, this.onBeforeParseTemplate);
        }
    }
}

