/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.hcl.tree;

import org.openrewrite.hcl.tree.Hcl;
import org.openrewrite.hcl.tree.HclCoordinates;
import org.openrewrite.hcl.tree.Space;

public abstract class CoordinateBuilder {
    Hcl tree;

    CoordinateBuilder(Hcl tree) {
        this.tree = tree;
    }

    HclCoordinates before(Space.Location location) {
        return new HclCoordinates(this.tree, location, HclCoordinates.Mode.BEFORE, null);
    }

    HclCoordinates after(Space.Location location) {
        return new HclCoordinates(this.tree, location, HclCoordinates.Mode.AFTER, null);
    }

    HclCoordinates replace(Space.Location location) {
        return new HclCoordinates(this.tree, location, HclCoordinates.Mode.REPLACEMENT, null);
    }

    public static class Block
    extends Expression {
        Block(Hcl.Block tree) {
            super(tree);
        }

        public HclCoordinates last() {
            return this.before(Space.Location.BLOCK_CLOSE);
        }

        @Override
        public HclCoordinates replace() {
            return this.replace(Space.Location.BLOCK);
        }
    }

    public static class Expression
    extends CoordinateBuilder {
        Expression(org.openrewrite.hcl.tree.Expression tree) {
            super(tree);
        }

        public HclCoordinates replace() {
            return this.replace(Space.Location.EXPRESSION_PREFIX);
        }
    }
}

