/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.hcl.internal;

import java.util.List;
import org.openrewrite.Cursor;
import org.openrewrite.Tree;
import org.openrewrite.TreePrinter;
import org.openrewrite.hcl.HclVisitor;
import org.openrewrite.hcl.tree.Comment;
import org.openrewrite.hcl.tree.Hcl;
import org.openrewrite.hcl.tree.HclContainer;
import org.openrewrite.hcl.tree.HclLeftPadded;
import org.openrewrite.hcl.tree.HclRightPadded;
import org.openrewrite.hcl.tree.Space;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Markers;

public class HclPrinter<P>
extends HclVisitor<P> {
    private static final String PRINTER_ACC_KEY = "printed";
    private final TreePrinter<P> treePrinter;

    public HclPrinter(TreePrinter<P> treePrinter) {
        this.treePrinter = treePrinter;
    }

    @NonNull
    protected StringBuilder getPrinter() {
        StringBuilder acc = (StringBuilder)this.getCursor().getRoot().getMessage(PRINTER_ACC_KEY);
        if (acc == null) {
            acc = new StringBuilder();
            this.getCursor().getRoot().putMessage(PRINTER_ACC_KEY, (Object)acc);
        }
        return acc;
    }

    @Override
    public Space visitSpace(Space space, Space.Location loc, P p) {
        StringBuilder acc = this.getPrinter();
        acc.append(space.getWhitespace());
        for (Comment comment : space.getComments()) {
            this.visitMarkers(comment.getMarkers(), p);
            switch (comment.getStyle()) {
                case LINE_SLASH: {
                    acc.append("//").append(comment.getText());
                    break;
                }
                case LINE_HASH: {
                    acc.append("#").append(comment.getText());
                    break;
                }
                case INLINE: {
                    acc.append("/*").append(comment.getText()).append("*/");
                }
            }
            acc.append(comment.getSuffix());
        }
        return space;
    }

    protected void visitLeftPadded(@Nullable String prefix, @Nullable HclLeftPadded<? extends Hcl> leftPadded, HclLeftPadded.Location location, P p) {
        if (leftPadded != null) {
            StringBuilder acc = this.getPrinter();
            this.visitSpace(leftPadded.getBefore(), location.getBeforeLocation(), p);
            if (prefix != null) {
                acc.append(prefix);
            }
            this.visit((Tree)leftPadded.getElement(), (Object)p);
        }
    }

    protected void visitRightPadded(List<? extends HclRightPadded<? extends Hcl>> nodes, HclRightPadded.Location location, String suffixBetween, P p) {
        StringBuilder acc = this.getPrinter();
        for (int i = 0; i < nodes.size(); ++i) {
            HclRightPadded<? extends Hcl> node = nodes.get(i);
            this.visit((Tree)node.getElement(), (Object)p);
            this.visitSpace(node.getAfter(), location.getAfterLocation(), p);
            if (i >= nodes.size() - 1) continue;
            acc.append(suffixBetween);
        }
    }

    protected void visitContainer(String before, @Nullable HclContainer<? extends Hcl> container, HclContainer.Location location, String suffixBetween, @Nullable String after, P p) {
        if (container == null) {
            return;
        }
        StringBuilder acc = this.getPrinter();
        this.visitSpace(container.getBefore(), location.getBeforeLocation(), p);
        acc.append(before);
        this.visitRightPadded(container.getPadding().getElements(), location.getElementLocation(), suffixBetween, p);
        acc.append(after == null ? "" : after);
    }

    public <M extends Marker> M visitMarker(Marker marker, P p) {
        StringBuilder acc = this.getPrinter();
        this.treePrinter.doBefore((Tree)marker, acc, p);
        acc.append(marker.print(this.treePrinter, p));
        this.treePrinter.doAfter((Tree)marker, acc, p);
        return (M)marker;
    }

    public Markers visitMarkers(Markers markers, P p) {
        StringBuilder acc = this.getPrinter();
        this.treePrinter.doBefore((Tree)markers, acc, p);
        Markers m = super.visitMarkers(markers, p);
        this.treePrinter.doAfter((Tree)markers, acc, p);
        return m;
    }

    public String print(Hcl hcl, P p) {
        this.setCursor(new Cursor(null, (Object)"EPSILON"));
        this.visit((Tree)hcl, (Object)p);
        return this.getPrinter().toString();
    }

    @Nullable
    public Hcl visit(@Nullable Tree tree, P p) {
        if (tree == null) {
            return (Hcl)this.defaultValue(null, p);
        }
        StringBuilder printerAcc = this.getPrinter();
        this.treePrinter.doBefore(tree, printerAcc, p);
        tree = super.visit(tree, p);
        if (tree != null) {
            this.treePrinter.doAfter(tree, printerAcc, p);
        }
        return (Hcl)tree;
    }

    public void visit(@Nullable List<? extends Hcl> nodes, P p) {
        if (nodes != null) {
            for (Hcl hcl : nodes) {
                this.visit((Tree)hcl, (Object)p);
            }
        }
    }

    @Override
    public Hcl visitAttribute(Hcl.Attribute attribute, P p) {
        this.visitSpace(attribute.getPrefix(), Space.Location.ATTRIBUTE, p);
        this.visitMarkers(attribute.getMarkers(), p);
        this.visit((Tree)attribute.getName(), (Object)p);
        StringBuilder acc = this.getPrinter();
        this.visitSpace(attribute.getPadding().getType().getBefore(), Space.Location.ATTRIBUTE_ASSIGNMENT, p);
        acc.append(attribute.getType().equals((Object)Hcl.Attribute.Type.Assignment) ? "=" : ":");
        this.visit((Tree)attribute.getValue(), (Object)p);
        return attribute;
    }

    @Override
    public Hcl visitAttributeAccess(Hcl.AttributeAccess attributeAccess, P p) {
        this.visitSpace(attributeAccess.getPrefix(), Space.Location.ATTRIBUTE_ACCESS, p);
        this.visitMarkers(attributeAccess.getMarkers(), p);
        this.visit((Tree)attributeAccess.getAttribute(), (Object)p);
        this.visitLeftPadded(".", attributeAccess.getPadding().getName(), HclLeftPadded.Location.ATTRIBUTE_ACCESS_NAME, p);
        return attributeAccess;
    }

    @Override
    public Hcl visitBinary(Hcl.Binary binary, P p) {
        this.visitSpace(binary.getPrefix(), Space.Location.BINARY, p);
        this.visitMarkers(binary.getMarkers(), p);
        this.visit((Tree)binary.getLeft(), (Object)p);
        StringBuilder acc = this.getPrinter();
        this.visitSpace(binary.getPadding().getOperator().getBefore(), Space.Location.BINARY_OPERATOR, p);
        switch (binary.getOperator()) {
            case Addition: {
                acc.append('+');
                break;
            }
            case Subtraction: {
                acc.append('-');
                break;
            }
            case Multiplication: {
                acc.append('*');
                break;
            }
            case Division: {
                acc.append('/');
                break;
            }
            case Modulo: {
                acc.append('%');
                break;
            }
            case LessThan: {
                acc.append('<');
                break;
            }
            case GreaterThan: {
                acc.append('>');
                break;
            }
            case LessThanOrEqual: {
                acc.append("<=");
                break;
            }
            case GreaterThanOrEqual: {
                acc.append(">=");
                break;
            }
            case Equal: {
                acc.append("==");
                break;
            }
            case NotEqual: {
                acc.append("!=");
                break;
            }
            case Or: {
                acc.append("||");
                break;
            }
            case And: {
                acc.append("&&");
            }
        }
        this.visit((Tree)binary.getRight(), (Object)p);
        return binary;
    }

    @Override
    public Hcl visitBlock(Hcl.Block block, P p) {
        this.visitSpace(block.getPrefix(), Space.Location.BLOCK, p);
        this.visitMarkers(block.getMarkers(), p);
        this.visit((Tree)block.getType(), (Object)p);
        this.visit(block.getLabels(), p);
        StringBuilder acc = this.getPrinter();
        this.visitSpace(block.getOpen(), Space.Location.BLOCK_OPEN, p);
        acc.append('{');
        this.visit(block.getBody(), p);
        this.visitSpace(block.getClose(), Space.Location.BLOCK_CLOSE, p);
        acc.append('}');
        return block;
    }

    @Override
    public Hcl visitConditional(Hcl.Conditional conditional, P p) {
        this.visitSpace(conditional.getPrefix(), Space.Location.CONDITIONAL, p);
        this.visitMarkers(conditional.getMarkers(), p);
        this.visit((Tree)conditional.getCondition(), (Object)p);
        this.visitLeftPadded("?", conditional.getPadding().getTruePart(), HclLeftPadded.Location.CONDITIONAL_TRUE, p);
        this.visitLeftPadded(":", conditional.getPadding().getFalsePart(), HclLeftPadded.Location.CONDITIONAL_FALSE, p);
        return conditional;
    }

    @Override
    public Hcl visitConfigFile(Hcl.ConfigFile configFile, P p) {
        this.visitSpace(configFile.getPrefix(), Space.Location.CONFIG_FILE, p);
        this.visitMarkers(configFile.getMarkers(), p);
        this.visit(configFile.getBody(), p);
        return configFile;
    }

    @Override
    public Hcl visitForIntro(Hcl.ForIntro forIntro, P p) {
        this.visitSpace(forIntro.getPrefix(), Space.Location.FOR_INTRO, p);
        this.visitMarkers(forIntro.getMarkers(), p);
        this.visitContainer("for", forIntro.getPadding().getVariables(), HclContainer.Location.FOR_VARIABLES, ",", "in", p);
        this.visit((Tree)forIntro.getIn(), (Object)p);
        return forIntro;
    }

    @Override
    public Hcl visitForObject(Hcl.ForObject forObject, P p) {
        this.visitSpace(forObject.getPrefix(), Space.Location.FOR_OBJECT, p);
        this.visitMarkers(forObject.getMarkers(), p);
        StringBuilder acc = this.getPrinter();
        acc.append("{");
        this.visit((Tree)forObject.getIntro(), (Object)p);
        this.visitLeftPadded(":", forObject.getPadding().getUpdateName(), HclLeftPadded.Location.FOR_UPDATE, p);
        this.visitLeftPadded("=>", forObject.getPadding().getUpdateValue(), HclLeftPadded.Location.FOR_UPDATE_VALUE, p);
        if (forObject.getEllipsis() != null) {
            this.visitSpace(forObject.getEllipsis().getPrefix(), Space.Location.FOR_UPDATE_VALUE_ELLIPSIS, p);
            acc.append("...");
        }
        if (forObject.getPadding().getCondition() != null) {
            this.visitLeftPadded("if", forObject.getPadding().getCondition(), HclLeftPadded.Location.FOR_CONDITION, p);
        }
        this.visitSpace(forObject.getEnd(), Space.Location.FOR_OBJECT_SUFFIX, p);
        acc.append("}");
        return forObject;
    }

    @Override
    public Hcl visitForTuple(Hcl.ForTuple forTuple, P p) {
        this.visitSpace(forTuple.getPrefix(), Space.Location.FOR_TUPLE, p);
        this.visitMarkers(forTuple.getMarkers(), p);
        StringBuilder acc = this.getPrinter();
        acc.append("[");
        this.visit((Tree)forTuple.getIntro(), (Object)p);
        this.visitLeftPadded(":", forTuple.getPadding().getUpdate(), HclLeftPadded.Location.FOR_UPDATE, p);
        if (forTuple.getPadding().getCondition() != null) {
            this.visitLeftPadded("if", forTuple.getPadding().getCondition(), HclLeftPadded.Location.FOR_CONDITION, p);
        }
        this.visitSpace(forTuple.getEnd(), Space.Location.FOR_TUPLE_SUFFIX, p);
        acc.append("]");
        return forTuple;
    }

    @Override
    public Hcl visitFunctionCall(Hcl.FunctionCall functionCall, P p) {
        this.visitSpace(functionCall.getPrefix(), Space.Location.FUNCTION_CALL, p);
        this.visitMarkers(functionCall.getMarkers(), p);
        this.visit((Tree)functionCall.getName(), (Object)p);
        this.visitContainer("(", functionCall.getPadding().getArguments(), HclContainer.Location.FUNCTION_CALL_ARGUMENTS, ",", ")", p);
        return functionCall;
    }

    @Override
    public Hcl visitHeredocTemplate(Hcl.HeredocTemplate heredocTemplate, P p) {
        this.visitSpace(heredocTemplate.getPrefix(), Space.Location.HEREDOC, p);
        this.visitMarkers(heredocTemplate.getMarkers(), p);
        StringBuilder acc = this.getPrinter();
        acc.append(heredocTemplate.getArrow());
        this.visit((Tree)heredocTemplate.getDelimiter(), (Object)p);
        this.visit(heredocTemplate.getExpressions(), p);
        this.visitSpace(heredocTemplate.getEnd(), Space.Location.HEREDOC_END, p);
        acc.append(heredocTemplate.getDelimiter().getName());
        return heredocTemplate;
    }

    @Override
    public Hcl visitIdentifier(Hcl.Identifier identifier, P p) {
        this.visitSpace(identifier.getPrefix(), Space.Location.IDENTIFIER, p);
        this.visitMarkers(identifier.getMarkers(), p);
        StringBuilder acc = this.getPrinter();
        acc.append(identifier.getName());
        return identifier;
    }

    @Override
    public Hcl visitIndex(Hcl.Index index, P p) {
        this.visitSpace(index.getPrefix(), Space.Location.INDEX, p);
        this.visitMarkers(index.getMarkers(), p);
        this.visit((Tree)index.getIndexed(), (Object)p);
        this.visit((Tree)index.getPosition(), (Object)p);
        return index;
    }

    @Override
    public Hcl visitIndexPosition(Hcl.Index.Position indexPosition, P p) {
        this.visitSpace(indexPosition.getPrefix(), Space.Location.INDEX_POSITION, p);
        this.visitMarkers(indexPosition.getMarkers(), p);
        StringBuilder acc = this.getPrinter();
        acc.append("[");
        this.visitMarkers(indexPosition.getMarkers(), p);
        this.visitRightPadded(indexPosition.getPadding().getPosition(), HclRightPadded.Location.INDEX_POSITION, p);
        acc.append("]");
        return indexPosition;
    }

    @Override
    public Hcl visitLiteral(Hcl.Literal literal, P p) {
        this.visitSpace(literal.getPrefix(), Space.Location.LITERAL, p);
        this.visitMarkers(literal.getMarkers(), p);
        StringBuilder acc = this.getPrinter();
        acc.append(literal.getValueSource());
        return literal;
    }

    @Override
    public Hcl visitObjectValue(Hcl.ObjectValue objectValue, P p) {
        this.visitSpace(objectValue.getPrefix(), Space.Location.OBJECT_VALUE, p);
        this.visitMarkers(objectValue.getMarkers(), p);
        this.visitContainer("{", objectValue.getPadding().getAttributes(), HclContainer.Location.OBJECT_VALUE_ATTRIBUTES, ",", "}", p);
        return objectValue;
    }

    @Override
    public Hcl visitParentheses(Hcl.Parentheses parentheses, P p) {
        this.visitSpace(parentheses.getPrefix(), Space.Location.PARENTHETICAL_EXPRESSION, p);
        this.visitMarkers(parentheses.getMarkers(), p);
        StringBuilder acc = this.getPrinter();
        acc.append('(');
        this.visitRightPadded(parentheses.getPadding().getExpression(), HclRightPadded.Location.PARENTHESES, p);
        acc.append(')');
        return parentheses;
    }

    @Override
    public Hcl visitQuotedTemplate(Hcl.QuotedTemplate template, P p) {
        this.visitSpace(template.getPrefix(), Space.Location.QUOTED_TEMPLATE, p);
        this.visitMarkers(template.getMarkers(), p);
        StringBuilder acc = this.getPrinter();
        acc.append('\"');
        this.visit(template.getExpressions(), p);
        acc.append('\"');
        return template;
    }

    @Override
    public Hcl visitTemplateInterpolation(Hcl.TemplateInterpolation template, P p) {
        this.visitSpace(template.getPrefix(), Space.Location.TEMPLATE_INTERPOLATION, p);
        this.visitMarkers(template.getMarkers(), p);
        StringBuilder acc = this.getPrinter();
        acc.append("${");
        this.visit((Tree)template.getExpression(), (Object)p);
        acc.append('}');
        return template;
    }

    @Override
    public Hcl visitSplat(Hcl.Splat splat, P p) {
        this.visitSpace(splat.getPrefix(), Space.Location.ATTRIBUTE_ACCESS, p);
        this.visitMarkers(splat.getMarkers(), p);
        this.visit((Tree)splat.getSelect(), (Object)p);
        this.visit((Tree)splat.getOperator(), (Object)p);
        return splat;
    }

    @Override
    public Hcl visitSplatOperator(Hcl.Splat.Operator splatOperator, P p) {
        this.visitSpace(splatOperator.getPrefix(), Space.Location.SPLAT_OPERATOR, p);
        this.visitMarkers(splatOperator.getMarkers(), p);
        StringBuilder acc = this.getPrinter();
        if (splatOperator.getType().equals((Object)Hcl.Splat.Operator.Type.Full)) {
            acc.append('[');
        } else {
            acc.append('.');
        }
        this.visitSpace(splatOperator.getSplat().getElement().getPrefix(), Space.Location.SPLAT_OPERATOR_PREFIX, p);
        acc.append('*');
        if (splatOperator.getType().equals((Object)Hcl.Splat.Operator.Type.Full)) {
            this.visitSpace(splatOperator.getSplat().getAfter(), Space.Location.SPLAT_OPERATOR_SUFFIX, p);
            acc.append(']');
        }
        return splatOperator;
    }

    @Override
    public Hcl visitTuple(Hcl.Tuple tuple, P p) {
        this.visitSpace(tuple.getPrefix(), Space.Location.FUNCTION_CALL, p);
        this.visitMarkers(tuple.getMarkers(), p);
        this.visitContainer("[", tuple.getPadding().getValues(), HclContainer.Location.TUPLE_VALUES, ",", "]", p);
        return tuple;
    }

    @Override
    public Hcl visitUnary(Hcl.Unary unary, P p) {
        this.visitSpace(unary.getPrefix(), Space.Location.UNARY, p);
        this.visitMarkers(unary.getMarkers(), p);
        StringBuilder acc = this.getPrinter();
        switch (unary.getOperator()) {
            case Negative: {
                acc.append('-');
                break;
            }
            case Not: {
                acc.append('!');
            }
        }
        this.visit((Tree)unary.getExpression(), (Object)p);
        return unary;
    }

    @Override
    public Hcl visitVariableExpression(Hcl.VariableExpression variableExpression, P p) {
        this.visitSpace(variableExpression.getPrefix(), Space.Location.VARIABLE_EXPRESSION, p);
        this.visitMarkers(variableExpression.getMarkers(), p);
        this.visit((Tree)variableExpression.getName(), (Object)p);
        return variableExpression;
    }
}

