/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.groovy.format;

import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.groovy.format.OmitParenthesesForLastArgumentLambda;
import org.openrewrite.groovy.style.OmitParenthesesStyle;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.style.Style;

public class OmitParenthesesFormat
extends Recipe {
    public String getDisplayName() {
        return "Stylize Groovy code to omit parentheses";
    }

    public String getDescription() {
        return "Omit parentheses for last argument lambdas in Groovy code.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new OmitParenthesesFromCompilationUnitStyle();
    }

    private static class OmitParenthesesFromCompilationUnitStyle
    extends JavaIsoVisitor<ExecutionContext> {
        private OmitParenthesesFromCompilationUnitStyle() {
        }

        public @Nullable J visit(@Nullable Tree tree, ExecutionContext ctx) {
            SourceFile cu;
            OmitParenthesesStyle style;
            if (tree instanceof JavaSourceFile && (style = (OmitParenthesesStyle)Style.from(OmitParenthesesStyle.class, (SourceFile)(cu = (SourceFile)Objects.requireNonNull(tree)), () -> OmitParenthesesStyle.DEFAULT)).getLastArgumentLambda().booleanValue()) {
                this.doAfterVisit(new OmitParenthesesForLastArgumentLambda().getVisitor());
            }
            return (J)super.visit(tree, (Object)ctx);
        }
    }
}

