/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.groovy;

import groovy.lang.GroovyClassLoader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.ErrorCollector;
import org.codehaus.groovy.control.Janitor;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.io.InputStreamReaderSource;
import org.codehaus.groovy.control.io.ReaderSource;
import org.codehaus.groovy.control.messages.ExceptionMessage;
import org.codehaus.groovy.control.messages.Message;
import org.codehaus.groovy.control.messages.SyntaxErrorMessage;
import org.codehaus.groovy.transform.stc.StaticTypeCheckingVisitor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.SourceFile;
import org.openrewrite.groovy.CompiledGroovySource;
import org.openrewrite.groovy.GroovyParserVisitor;
import org.openrewrite.groovy.tree.G;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.internal.JavaTypeCache;
import org.openrewrite.style.NamedStyles;
import org.openrewrite.tree.ParsingEventListener;
import org.openrewrite.tree.ParsingExecutionContextView;
import org.slf4j.LoggerFactory;

public class GroovyParser
implements Parser<G.CompilationUnit> {
    @Nullable
    private final Collection<Path> classpath;
    private final List<NamedStyles> styles;
    private final boolean logCompilationWarningsAndErrors;
    private final JavaTypeCache typeCache;
    private final List<Consumer<CompilerConfiguration>> compilerCustomizers;

    public List<G.CompilationUnit> parse(String ... sources) {
        Pattern packagePattern = Pattern.compile("^package\\s+([^;]+);");
        Pattern classPattern = Pattern.compile("(class|interface|enum)\\s*(<[^>]*>)?\\s+(\\w+)");
        Function<String, String> simpleName = sourceStr -> {
            Matcher classMatcher = classPattern.matcher((CharSequence)sourceStr);
            return classMatcher.find() ? classMatcher.group(3) : null;
        };
        return this.parseInputs(Arrays.stream(sources).map(sourceFile -> {
            Matcher packageMatcher = packagePattern.matcher((CharSequence)sourceFile);
            String pkg = packageMatcher.find() ? packageMatcher.group(1).replace('.', '/') + "/" : "";
            String className = Optional.ofNullable((String)simpleName.apply((String)sourceFile)).orElse(Long.toString(System.nanoTime())) + ".java";
            Path path = Paths.get(pkg + className, new String[0]);
            return new Parser.Input(path, null, () -> new ByteArrayInputStream(sourceFile.getBytes(StandardCharsets.UTF_8)), true);
        }).collect(Collectors.toList()), null, (ExecutionContext)new InMemoryExecutionContext());
    }

    public List<G.CompilationUnit> parseInputs(Iterable<Parser.Input> sources, @Nullable Path relativeTo, ExecutionContext ctx) {
        ParsingExecutionContextView pctx = ParsingExecutionContextView.view((ExecutionContext)ctx);
        ParsingEventListener parsingListener = pctx.getParsingListener();
        List<CompiledGroovySource> compilerCus = this.parseInputsToCompilerAst(sources, relativeTo, pctx);
        ArrayList<G.CompilationUnit> cus = new ArrayList<G.CompilationUnit>(compilerCus.size());
        for (CompiledGroovySource compiled : compilerCus) {
            try {
                GroovyParserVisitor mappingVisitor = new GroovyParserVisitor(compiled.getInput().getRelativePath(relativeTo), compiled.getInput().getFileAttributes(), compiled.getInput().getSource(ctx), this.typeCache, ctx);
                G.CompilationUnit gcu = mappingVisitor.visit(compiled.getSourceUnit(), compiled.getModule());
                cus.add(gcu);
                parsingListener.parsed(compiled.getInput(), (SourceFile)gcu);
            }
            catch (Throwable t) {
                pctx.parseFailure(compiled.getInput(), relativeTo, (Parser)this, t);
                ctx.getOnError().accept(t);
            }
        }
        return cus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<CompiledGroovySource> parseInputsToCompilerAst(Iterable<Parser.Input> sources, final @Nullable Path relativeTo, final ParsingExecutionContextView ctx) {
        ArrayList<CompiledGroovySource> cus = new ArrayList<CompiledGroovySource>();
        for (final Parser.Input input : sources) {
            CompilerConfiguration configuration = new CompilerConfiguration();
            configuration.setTolerance(Integer.MAX_VALUE);
            configuration.setWarningLevel(0);
            configuration.setClasspathList(this.classpath == null ? Collections.emptyList() : this.classpath.stream().flatMap(cp -> {
                try {
                    return Stream.of(cp.toFile().toString());
                }
                catch (UnsupportedOperationException e) {
                    return Stream.empty();
                }
            }).collect(Collectors.toList()));
            for (Consumer<CompilerConfiguration> compilerCustomizer : this.compilerCustomizers) {
                compilerCustomizer.accept(configuration);
            }
            ErrorCollector errorCollector = new ErrorCollector(configuration){

                public void addErrorAndContinue(Message message) throws CompilationFailedException {
                    super.addErrorAndContinue(message);
                    if (message instanceof SyntaxErrorMessage) {
                        ctx.parseFailure(input, relativeTo, (Parser)GroovyParser.this, (Throwable)((SyntaxErrorMessage)message).getCause());
                    } else if (message instanceof ExceptionMessage) {
                        ctx.parseFailure(input, relativeTo, (Parser)GroovyParser.this, (Throwable)((ExceptionMessage)message).getCause());
                    }
                }

                protected void failIfErrors() throws CompilationFailedException {
                }
            };
            GroovyClassLoader classLoader = new GroovyClassLoader(this.getClass().getClassLoader(), configuration, true);
            SourceUnit unit = new SourceUnit("doesntmatter", (ReaderSource)new InputStreamReaderSource((InputStream)input.getSource((ExecutionContext)ctx), configuration), configuration, classLoader, errorCollector);
            CompilationUnit compUnit = new CompilationUnit(configuration, null, classLoader, classLoader);
            compUnit.addSource(unit);
            try {
                compUnit.compile(5);
                ModuleNode ast = unit.getAST();
                for (ClassNode aClass : ast.getClasses()) {
                    try {
                        StaticTypeCheckingVisitor staticTypeCheckingVisitor = new StaticTypeCheckingVisitor(unit, aClass);
                        staticTypeCheckingVisitor.setCompilationUnit(compUnit);
                        staticTypeCheckingVisitor.visitClass(aClass);
                    }
                    catch (NoClassDefFoundError noClassDefFoundError) {}
                }
                cus.add(new CompiledGroovySource(input, unit, ast));
            }
            catch (Throwable t) {
                ctx.parseFailure(input, relativeTo, (Parser)this, t);
                ctx.getOnError().accept(t);
            }
            finally {
                if (!this.logCompilationWarningsAndErrors || !errorCollector.hasErrors() && !errorCollector.hasWarnings()) continue;
                try (StringWriter sw = new StringWriter();
                     PrintWriter pw = new PrintWriter(sw);){
                    errorCollector.write(pw, new Janitor());
                    LoggerFactory.getLogger(GroovyParser.class).warn(sw.toString());
                }
                catch (IOException sw2) {}
            }
        }
        return cus;
    }

    public boolean accept(Path path) {
        return path.toString().endsWith(".groovy");
    }

    public GroovyParser reset() {
        this.typeCache.clear();
        return this;
    }

    public Path sourcePathFromSourceText(Path prefix, String sourceCode) {
        return prefix.resolve("file.groovy");
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Builder base) {
        return new Builder(base);
    }

    private GroovyParser(@Nullable Collection<Path> classpath, List<NamedStyles> styles, boolean logCompilationWarningsAndErrors, JavaTypeCache typeCache, List<Consumer<CompilerConfiguration>> compilerCustomizers) {
        this.classpath = classpath;
        this.styles = styles;
        this.logCompilationWarningsAndErrors = logCompilationWarningsAndErrors;
        this.typeCache = typeCache;
        this.compilerCustomizers = compilerCustomizers;
    }

    public static class Builder
    extends Parser.Builder {
        @Nullable
        private Collection<Path> classpath = JavaParser.runtimeClasspath();
        private JavaTypeCache typeCache = new JavaTypeCache();
        private boolean logCompilationWarningsAndErrors = false;
        private final List<NamedStyles> styles = new ArrayList<NamedStyles>();
        private final List<Consumer<CompilerConfiguration>> compilerCustomizers = new ArrayList<Consumer<CompilerConfiguration>>();

        public Builder() {
            super(G.CompilationUnit.class);
        }

        public Builder(Builder base) {
            super(G.CompilationUnit.class);
            this.classpath = base.classpath;
            this.typeCache = base.typeCache;
            this.logCompilationWarningsAndErrors = base.logCompilationWarningsAndErrors;
            this.styles.addAll(base.styles);
            this.compilerCustomizers.addAll(base.compilerCustomizers);
        }

        public Builder logCompilationWarningsAndErrors(boolean logCompilationWarningsAndErrors) {
            this.logCompilationWarningsAndErrors = logCompilationWarningsAndErrors;
            return this;
        }

        public Builder classpath(Collection<Path> classpath) {
            this.classpath = classpath;
            return this;
        }

        public Builder classpath(String ... classpath) {
            this.classpath = JavaParser.dependenciesFromClasspath((String[])classpath);
            return this;
        }

        public Builder typeCache(JavaTypeCache typeCache) {
            this.typeCache = typeCache;
            return this;
        }

        public Builder styles(Iterable<? extends NamedStyles> styles) {
            for (NamedStyles namedStyles : styles) {
                this.styles.add(namedStyles);
            }
            return this;
        }

        public Builder compilerCustomizers(Consumer<CompilerConfiguration> ... compilerCustomizers) {
            return this.compilerCustomizers(Arrays.asList(compilerCustomizers));
        }

        public Builder compilerCustomizers(Iterable<Consumer<CompilerConfiguration>> compilerCustomizers) {
            for (Consumer<CompilerConfiguration> compilerCustomizer : compilerCustomizers) {
                this.compilerCustomizers.add(compilerCustomizer);
            }
            return this;
        }

        public GroovyParser build() {
            return new GroovyParser(this.classpath, this.styles, this.logCompilationWarningsAndErrors, this.typeCache, this.compilerCustomizers);
        }

        public String getDslName() {
            return "groovy";
        }
    }
}

