/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.gradle.marker.GradleDependencyConfiguration;
import org.openrewrite.gradle.marker.GradleProject;
import org.openrewrite.gradle.trait.GradleDependency;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.marker.JavaProject;
import org.openrewrite.java.marker.JavaSourceSet;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.maven.graph.DependencyGraph;
import org.openrewrite.maven.table.DependenciesInUse;
import org.openrewrite.maven.tree.Dependency;
import org.openrewrite.maven.tree.GroupArtifactVersion;
import org.openrewrite.maven.tree.ResolvedDependency;
import org.openrewrite.maven.tree.ResolvedGroupArtifactVersion;
import org.openrewrite.semver.Semver;
import org.openrewrite.semver.VersionComparator;

public final class DependencyInsight
extends Recipe {
    private final transient DependenciesInUse dependenciesInUse = new DependenciesInUse((Recipe)this);
    private static final MethodMatcher DEPENDENCY_CONFIGURATION_MATCHER = new MethodMatcher("DependencyHandlerSpec *(..)");
    private static final MethodMatcher DEPENDENCY_CLOSURE_MATCHER = new MethodMatcher("RewriteGradleProject dependencies(..)");
    private static final Function<Object, Set<GroupArtifactVersion>> EMPTY = gav -> new HashSet();
    @Option(displayName="Group pattern", description="Group glob pattern used to match dependencies.", example="com.fasterxml.jackson.module")
    private final String groupIdPattern;
    @Option(displayName="Artifact pattern", description="Artifact glob pattern used to match dependencies.", example="jackson-module-*")
    private final String artifactIdPattern;
    @Option(displayName="Version", description="Match only dependencies with the specified resolved version. Node-style [version selectors](https://docs.openrewrite.org/reference/dependency-version-selectors) may be used.All versions are searched by default.", example="1.x", required=false)
    private final @Nullable String version;
    @Option(displayName="Scope", description="Match dependencies with the specified scope. If not specified, all configurations will be searched.", example="compileClasspath", required=false)
    private final @Nullable String configuration;

    public String getDisplayName() {
        return "Gradle dependency insight";
    }

    public String getDescription() {
        return "Find direct and transitive dependencies matching a group, artifact, resolved version, and optionally a configuration name. Results include dependencies that either directly match or transitively include a matching dependency.";
    }

    public Validated<Object> validate() {
        Validated v = super.validate();
        if (this.version != null) {
            v = v.and(Semver.validate((String)this.version, null));
        }
        return v;
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new TreeVisitor<Tree, ExecutionContext>(){

            public boolean isAcceptable(SourceFile sourceFile, ExecutionContext ctx) {
                return sourceFile.getMarkers().findFirst(GradleProject.class).isPresent();
            }

            public Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                SourceFile sourceFile = (SourceFile)Objects.requireNonNull(tree);
                Optional maybeGradleProject = sourceFile.getMarkers().findFirst(GradleProject.class);
                if (!maybeGradleProject.isPresent()) {
                    return sourceFile;
                }
                GradleProject gp = (GradleProject)maybeGradleProject.get();
                String projectName = sourceFile.getMarkers().findFirst(JavaProject.class).map(JavaProject::getProjectName).orElse("");
                String sourceSetName = sourceFile.getMarkers().findFirst(JavaSourceSet.class).map(JavaSourceSet::getName).orElse("main");
                DependencyGraph dependencyGraph = new DependencyGraph();
                Map<ResolvedGroupArtifactVersion, List<DependencyGraph.DependencyPath>> dependencyPaths = this.collectDependencyPaths(gp, dependencyGraph);
                HashMap<String, Set<GroupArtifactVersion>> configurationToDirectDependency = new HashMap<String, Set<GroupArtifactVersion>>();
                HashMap<GroupArtifactVersion, Set<GroupArtifactVersion>> directDependencyToTargetDependency = new HashMap<GroupArtifactVersion, Set<GroupArtifactVersion>>();
                Map<String, List<DependencyInfo>> matchingDependencies = this.collectMatchingDependencies(gp, sourceFile);
                this.processMatchingDependencies(matchingDependencies, dependencyPaths, dependencyGraph, DependencyInsight.this.dependenciesInUse, configurationToDirectDependency, directDependencyToTargetDependency, projectName, sourceSetName, ctx);
                if (matchingDependencies.isEmpty()) {
                    return sourceFile;
                }
                if (directDependencyToTargetDependency.isEmpty()) {
                    return sourceFile;
                }
                for (GradleDependencyConfiguration c : gp.getConfigurations()) {
                    if (configurationToDirectDependency.containsKey(c.getName())) continue;
                    for (Dependency dependency : c.getRequested()) {
                        GroupArtifactVersion gav = dependency.getGav();
                        Optional<GroupArtifactVersion> matchingGroupArtifact = directDependencyToTargetDependency.keySet().stream().filter(key -> key.equals((Object)gav)).findFirst();
                        if (!matchingGroupArtifact.isPresent()) {
                            matchingGroupArtifact = directDependencyToTargetDependency.keySet().stream().filter(key -> key.asGroupArtifact().equals((Object)gav.asGroupArtifact())).findFirst();
                        }
                        matchingGroupArtifact.ifPresent(version -> ((Set)configurationToDirectDependency.computeIfAbsent(c.getName(), EMPTY)).add(version));
                    }
                }
                return new MarkIndividualDependency(configurationToDirectDependency, directDependencyToTargetDependency).attachMarkers((Tree)sourceFile, ctx);
            }

            private boolean matchesConfiguration(GradleDependencyConfiguration c) {
                return DependencyInsight.this.configuration == null || DependencyInsight.this.configuration.isEmpty() || c.getName().equals(DependencyInsight.this.configuration);
            }

            private void processDependency(ResolvedDependency directDep, ResolvedDependency dep, String configName, DependencyGraph dependencyGraph, Map<ResolvedGroupArtifactVersion, List<DependencyGraph.DependencyPath>> dependencyPaths, DependenciesInUse dependenciesInUse, Map<String, Set<GroupArtifactVersion>> configurationToDirectDependency, Map<GroupArtifactVersion, Set<GroupArtifactVersion>> directDependencyToTargetDependency, String projectName, String sourceSetName, ExecutionContext ctx) {
                GroupArtifactVersion requestedGav = new GroupArtifactVersion(directDep.getGroupId(), directDep.getArtifactId(), directDep.getVersion());
                GroupArtifactVersion targetGav = new GroupArtifactVersion(dep.getGroupId(), dep.getArtifactId(), dep.getVersion());
                configurationToDirectDependency.computeIfAbsent(configName, EMPTY).add(requestedGav);
                directDependencyToTargetDependency.computeIfAbsent(requestedGav, EMPTY).add(targetGav);
                String depGraph = this.buildDependencyGraph(dependencyGraph, dep, dependencyPaths, configName);
                dependenciesInUse.insertRow(ctx, (Object)new DependenciesInUse.Row(projectName, sourceSetName, dep.getGroupId(), dep.getArtifactId(), dep.getVersion(), dep.getDatedSnapshotVersion(), dep.getRequested().getScope(), Integer.valueOf(dep.getDepth()), depGraph));
            }

            private void processMultiplePaths(ResolvedGroupArtifactVersion gav, Map<ResolvedGroupArtifactVersion, List<DependencyGraph.DependencyPath>> dependencyPaths, DependencyGraph dependencyGraph, DependenciesInUse dependenciesInUse, Map<String, Set<GroupArtifactVersion>> configurationToDirectDependency, Map<GroupArtifactVersion, Set<GroupArtifactVersion>> directDependencyToTargetDependency, String projectName, String sourceSetName, ExecutionContext ctx) {
                List<DependencyGraph.DependencyPath> paths = dependencyPaths.get(gav);
                if (paths == null || paths.isEmpty()) {
                    return;
                }
                Map<String, DependencyGraph.DependencyPath> pathsByParent = this.groupPathsByParent(paths);
                ArrayList<DependencyGraph.DependencyPath> uniquePaths = new ArrayList<DependencyGraph.DependencyPath>(pathsByParent.values());
                uniquePaths.sort((p1, p2) -> Integer.compare(p2.getPath().size(), p1.getPath().size()));
                for (DependencyGraph.DependencyPath path : uniquePaths) {
                    this.createDataTableRow(gav, path, dependencyGraph, dependenciesInUse, configurationToDirectDependency, directDependencyToTargetDependency, projectName, sourceSetName, ctx);
                }
            }

            private Map<String, DependencyGraph.DependencyPath> groupPathsByParent(List<DependencyGraph.DependencyPath> paths) {
                HashMap<String, DependencyGraph.DependencyPath> pathsByParent = new HashMap<String, DependencyGraph.DependencyPath>();
                for (DependencyGraph.DependencyPath path : paths) {
                    String parentKey;
                    DependencyGraph.DependencyPath existing;
                    List nodes = path.getPath();
                    if (nodes.isEmpty() || (existing = (DependencyGraph.DependencyPath)pathsByParent.get(parentKey = this.determineParentKey(nodes, path.getScope()))) != null && path.getPath().size() <= existing.getPath().size()) continue;
                    pathsByParent.put(parentKey, path);
                }
                return pathsByParent;
            }

            private String determineParentKey(List<DependencyGraph.DependencyNode> nodes, String configName) {
                if (nodes.size() == 1) {
                    return "direct:" + configName;
                }
                DependencyGraph.DependencyNode parentNode = nodes.get(1);
                return parentNode.getGroupId() + ":" + parentNode.getArtifactId() + ":" + parentNode.getVersion() + ":" + configName;
            }

            private void createDataTableRow(ResolvedGroupArtifactVersion gav, DependencyGraph.DependencyPath path, DependencyGraph dependencyGraph, DependenciesInUse dependenciesInUse, Map<String, Set<GroupArtifactVersion>> configurationToDirectDependency, Map<GroupArtifactVersion, Set<GroupArtifactVersion>> directDependencyToTargetDependency, String projectName, String sourceSetName, ExecutionContext ctx) {
                DependencyGraph.DependencyNode directDepNode;
                List nodes = path.getPath();
                String configName = path.getScope();
                int depth = nodes.size() - 1;
                DependencyGraph.DependencyNode dependencyNode = directDepNode = nodes.isEmpty() ? null : (DependencyGraph.DependencyNode)nodes.get(nodes.size() - 1);
                if (directDepNode != null) {
                    this.updateDependencyMappings(gav, directDepNode, configName, configurationToDirectDependency, directDependencyToTargetDependency);
                }
                String depGraph = this.buildIsolatedPathGraph(gav, path, depth, configName, dependencyGraph);
                dependenciesInUse.insertRow(ctx, (Object)new DependenciesInUse.Row(projectName, sourceSetName, gav.getGroupId(), gav.getArtifactId(), gav.getVersion(), gav.getDatedSnapshotVersion(), configName, Integer.valueOf(depth), depGraph));
            }

            private void updateDependencyMappings(ResolvedGroupArtifactVersion gav, DependencyGraph.DependencyNode directDepNode, String configName, Map<String, Set<GroupArtifactVersion>> configurationToDirectDependency, Map<GroupArtifactVersion, Set<GroupArtifactVersion>> directDependencyToTargetDependency) {
                GroupArtifactVersion requestedGav = new GroupArtifactVersion(directDepNode.getGroupId(), directDepNode.getArtifactId(), directDepNode.getVersion());
                GroupArtifactVersion targetGav = new GroupArtifactVersion(gav.getGroupId(), gav.getArtifactId(), gav.getVersion());
                configurationToDirectDependency.computeIfAbsent(configName, EMPTY).add(requestedGav);
                directDependencyToTargetDependency.computeIfAbsent(requestedGav, EMPTY).add(targetGav);
            }

            private String buildIsolatedPathGraph(ResolvedGroupArtifactVersion gav, DependencyGraph.DependencyPath path, int depth, String configName, DependencyGraph dependencyGraph) {
                HashMap<ResolvedGroupArtifactVersion, List<DependencyGraph.DependencyPath>> singlePathMap = new HashMap<ResolvedGroupArtifactVersion, List<DependencyGraph.DependencyPath>>();
                singlePathMap.put(gav, Collections.singletonList(path));
                return dependencyGraph.buildDependencyGraph(gav, singlePathMap, depth, configName);
            }

            private Map<ResolvedGroupArtifactVersion, List<DependencyGraph.DependencyPath>> collectDependencyPaths(GradleProject gp, DependencyGraph dependencyGraph) {
                HashMap<ResolvedGroupArtifactVersion, List<DependencyGraph.DependencyPath>> dependencyPaths = new HashMap<ResolvedGroupArtifactVersion, List<DependencyGraph.DependencyPath>>();
                gp.getConfigurations().stream().filter(this::matchesConfiguration).forEach(c -> dependencyGraph.collectGradleDependencyPaths(c.getDirectResolved(), dependencyPaths, c.getName()));
                return dependencyPaths;
            }

            private Map<String, List<DependencyInfo>> collectMatchingDependencies(GradleProject gp, SourceFile sourceFile) {
                HashMap<String, List<DependencyInfo>> matchingDependencies = new HashMap<String, List<DependencyInfo>>();
                VersionComparator versionComparator = DependencyInsight.this.version != null ? (VersionComparator)Semver.validate((String)DependencyInsight.this.version, null).getValue() : null;
                for (GradleDependencyConfiguration c : gp.getConfigurations()) {
                    if (!this.matchesConfiguration(c)) continue;
                    for (ResolvedDependency resolvedDependency : c.getDirectResolved()) {
                        if (!resolvedDependency.isDirect()) continue;
                        List nestedMatchingDependencies = resolvedDependency.findDependencies(DependencyInsight.this.groupIdPattern, DependencyInsight.this.artifactIdPattern);
                        for (ResolvedDependency dep : nestedMatchingDependencies) {
                            if (versionComparator != null && !versionComparator.isValid(null, dep.getVersion())) continue;
                            String gavKey = dep.getGroupId() + ":" + dep.getArtifactId() + ":" + dep.getVersion();
                            matchingDependencies.computeIfAbsent(gavKey, k -> new ArrayList()).add(new DependencyInfo(resolvedDependency, dep, c.getName()));
                        }
                    }
                }
                return matchingDependencies;
            }

            private void processMatchingDependencies(Map<String, List<DependencyInfo>> matchingDependencies, Map<ResolvedGroupArtifactVersion, List<DependencyGraph.DependencyPath>> dependencyPaths, DependencyGraph dependencyGraph, DependenciesInUse dependenciesInUse, Map<String, Set<GroupArtifactVersion>> configurationToDirectDependency, Map<GroupArtifactVersion, Set<GroupArtifactVersion>> directDependencyToTargetDependency, String projectName, String sourceSetName, ExecutionContext ctx) {
                for (Map.Entry<String, List<DependencyInfo>> entry : matchingDependencies.entrySet()) {
                    List<DependencyInfo> depInfos = entry.getValue();
                    if (depInfos.isEmpty()) continue;
                    DependencyInfo firstInfo = depInfos.get(0);
                    ResolvedGroupArtifactVersion gav = firstInfo.getDep().getGav();
                    this.processMultiplePaths(gav, dependencyPaths, dependencyGraph, dependenciesInUse, configurationToDirectDependency, directDependencyToTargetDependency, projectName, sourceSetName, ctx);
                }
            }

            private String buildDependencyGraph(DependencyGraph dependencyGraph, ResolvedDependency dep, Map<ResolvedGroupArtifactVersion, List<DependencyGraph.DependencyPath>> dependencyPaths, String configurationName) {
                return dependencyGraph.buildDependencyGraph(dep.getGav(), dependencyPaths, dep.getDepth(), configurationName);
            }
        };
    }

    @Generated
    public DependencyInsight(String groupIdPattern, String artifactIdPattern, @Nullable String version, @Nullable String configuration) {
        this.groupIdPattern = groupIdPattern;
        this.artifactIdPattern = artifactIdPattern;
        this.version = version;
        this.configuration = configuration;
    }

    @Generated
    public DependenciesInUse getDependenciesInUse() {
        return this.dependenciesInUse;
    }

    @Generated
    public String getGroupIdPattern() {
        return this.groupIdPattern;
    }

    @Generated
    public String getArtifactIdPattern() {
        return this.artifactIdPattern;
    }

    @Generated
    public @Nullable String getVersion() {
        return this.version;
    }

    @Generated
    public @Nullable String getConfiguration() {
        return this.configuration;
    }

    @NonNull
    @Generated
    public String toString() {
        return "DependencyInsight(dependenciesInUse=" + this.getDependenciesInUse() + ", groupIdPattern=" + this.getGroupIdPattern() + ", artifactIdPattern=" + this.getArtifactIdPattern() + ", version=" + this.getVersion() + ", configuration=" + this.getConfiguration() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DependencyInsight)) {
            return false;
        }
        DependencyInsight other = (DependencyInsight)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$groupIdPattern = this.getGroupIdPattern();
        String other$groupIdPattern = other.getGroupIdPattern();
        if (this$groupIdPattern == null ? other$groupIdPattern != null : !this$groupIdPattern.equals(other$groupIdPattern)) {
            return false;
        }
        String this$artifactIdPattern = this.getArtifactIdPattern();
        String other$artifactIdPattern = other.getArtifactIdPattern();
        if (this$artifactIdPattern == null ? other$artifactIdPattern != null : !this$artifactIdPattern.equals(other$artifactIdPattern)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$configuration = this.getConfiguration();
        String other$configuration = other.getConfiguration();
        return !(this$configuration == null ? other$configuration != null : !this$configuration.equals(other$configuration));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof DependencyInsight;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $groupIdPattern = this.getGroupIdPattern();
        result = result * 59 + ($groupIdPattern == null ? 43 : $groupIdPattern.hashCode());
        String $artifactIdPattern = this.getArtifactIdPattern();
        result = result * 59 + ($artifactIdPattern == null ? 43 : $artifactIdPattern.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : $configuration.hashCode());
        return result;
    }

    private static class MarkIndividualDependency
    extends JavaIsoVisitor<ExecutionContext> {
        private final Map<String, Set<GroupArtifactVersion>> configurationToDirectDependency;
        private final Map<GroupArtifactVersion, Set<GroupArtifactVersion>> directDependencyToTargetDependency;
        private final Set<GroupArtifactVersion> individuallyMarkedDependencies = new HashSet<GroupArtifactVersion>();

        public Tree attachMarkers(Tree before, ExecutionContext ctx) {
            String resultText;
            Tree after = super.visitNonNull(before, (Object)ctx);
            if (after == before && !(resultText = this.directDependencyToTargetDependency.entrySet().stream().filter(target -> !this.individuallyMarkedDependencies.contains(target.getKey())).map(Map.Entry::getValue).flatMap(Collection::stream).distinct().map(target -> target.getGroupId() + ":" + target.getArtifactId() + ":" + target.getVersion()).collect(Collectors.joining(","))).isEmpty()) {
                return SearchResult.found((Tree)after, (String)resultText);
            }
            return after;
        }

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            String resultText;
            J.MethodInvocation m = super.visitMethodInvocation(method, (Object)ctx);
            if (DEPENDENCY_CLOSURE_MATCHER.matches((MethodCall)m) && !(resultText = this.directDependencyToTargetDependency.entrySet().stream().filter(target -> !this.individuallyMarkedDependencies.contains(target.getKey())).map(Map.Entry::getValue).flatMap(Collection::stream).distinct().map(target -> target.getGroupId() + ":" + target.getArtifactId() + ":" + target.getVersion()).collect(Collectors.joining(","))).isEmpty()) {
                this.directDependencyToTargetDependency.clear();
                return (J.MethodInvocation)SearchResult.found((Tree)m, (String)resultText);
            }
            if (this.configurationToDirectDependency.containsKey(m.getSimpleName())) {
                return new GradleDependency.Matcher().get(this.getCursor()).map(dependency -> {
                    ResolvedGroupArtifactVersion gav = dependency.getResolvedDependency().getGav();
                    Optional<GroupArtifactVersion> configurationGav = this.configurationToDirectDependency.get(m.getSimpleName()).stream().filter(dep -> dep.asGroupArtifact().equals((Object)gav.asGroupArtifact())).findAny();
                    if (configurationGav.isPresent()) {
                        this.configurationToDirectDependency.get(m.getSimpleName());
                        Set<GroupArtifactVersion> mark = this.directDependencyToTargetDependency.get(configurationGav.get());
                        if (mark == null) {
                            return null;
                        }
                        this.individuallyMarkedDependencies.add(configurationGav.get());
                        String resultText = mark.stream().map(target -> target.getGroupId() + ":" + target.getArtifactId() + ":" + target.getVersion()).collect(Collectors.joining(","));
                        if (!resultText.isEmpty()) {
                            return (J.MethodInvocation)SearchResult.found((Tree)m, (String)resultText);
                        }
                    }
                    return null;
                }).orElse(m);
            }
            return m;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MarkIndividualDependency)) {
                return false;
            }
            MarkIndividualDependency other = (MarkIndividualDependency)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            Map<String, Set<GroupArtifactVersion>> this$configurationToDirectDependency = this.getConfigurationToDirectDependency();
            Map<String, Set<GroupArtifactVersion>> other$configurationToDirectDependency = other.getConfigurationToDirectDependency();
            if (this$configurationToDirectDependency == null ? other$configurationToDirectDependency != null : !((Object)this$configurationToDirectDependency).equals(other$configurationToDirectDependency)) {
                return false;
            }
            Map<GroupArtifactVersion, Set<GroupArtifactVersion>> this$directDependencyToTargetDependency = this.getDirectDependencyToTargetDependency();
            Map<GroupArtifactVersion, Set<GroupArtifactVersion>> other$directDependencyToTargetDependency = other.getDirectDependencyToTargetDependency();
            if (this$directDependencyToTargetDependency == null ? other$directDependencyToTargetDependency != null : !((Object)this$directDependencyToTargetDependency).equals(other$directDependencyToTargetDependency)) {
                return false;
            }
            Set<GroupArtifactVersion> this$individuallyMarkedDependencies = this.getIndividuallyMarkedDependencies();
            Set<GroupArtifactVersion> other$individuallyMarkedDependencies = other.getIndividuallyMarkedDependencies();
            return !(this$individuallyMarkedDependencies == null ? other$individuallyMarkedDependencies != null : !((Object)this$individuallyMarkedDependencies).equals(other$individuallyMarkedDependencies));
        }

        @Generated
        protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
            return other instanceof MarkIndividualDependency;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<String, Set<GroupArtifactVersion>> $configurationToDirectDependency = this.getConfigurationToDirectDependency();
            result = result * 59 + ($configurationToDirectDependency == null ? 43 : ((Object)$configurationToDirectDependency).hashCode());
            Map<GroupArtifactVersion, Set<GroupArtifactVersion>> $directDependencyToTargetDependency = this.getDirectDependencyToTargetDependency();
            result = result * 59 + ($directDependencyToTargetDependency == null ? 43 : ((Object)$directDependencyToTargetDependency).hashCode());
            Set<GroupArtifactVersion> $individuallyMarkedDependencies = this.getIndividuallyMarkedDependencies();
            result = result * 59 + ($individuallyMarkedDependencies == null ? 43 : ((Object)$individuallyMarkedDependencies).hashCode());
            return result;
        }

        @Generated
        public MarkIndividualDependency(Map<String, Set<GroupArtifactVersion>> configurationToDirectDependency, Map<GroupArtifactVersion, Set<GroupArtifactVersion>> directDependencyToTargetDependency) {
            this.configurationToDirectDependency = configurationToDirectDependency;
            this.directDependencyToTargetDependency = directDependencyToTargetDependency;
        }

        @Generated
        public Map<String, Set<GroupArtifactVersion>> getConfigurationToDirectDependency() {
            return this.configurationToDirectDependency;
        }

        @Generated
        public Map<GroupArtifactVersion, Set<GroupArtifactVersion>> getDirectDependencyToTargetDependency() {
            return this.directDependencyToTargetDependency;
        }

        @Generated
        public Set<GroupArtifactVersion> getIndividuallyMarkedDependencies() {
            return this.individuallyMarkedDependencies;
        }

        @NonNull
        @Generated
        public String toString() {
            return "DependencyInsight.MarkIndividualDependency(configurationToDirectDependency=" + this.getConfigurationToDirectDependency() + ", directDependencyToTargetDependency=" + this.getDirectDependencyToTargetDependency() + ", individuallyMarkedDependencies=" + this.getIndividuallyMarkedDependencies() + ")";
        }
    }

    private static final class DependencyInfo {
        private final ResolvedDependency directDep;
        private final ResolvedDependency dep;
        private final String configName;

        @Generated
        public DependencyInfo(ResolvedDependency directDep, ResolvedDependency dep, String configName) {
            this.directDep = directDep;
            this.dep = dep;
            this.configName = configName;
        }

        @Generated
        public ResolvedDependency getDirectDep() {
            return this.directDep;
        }

        @Generated
        public ResolvedDependency getDep() {
            return this.dep;
        }

        @Generated
        public String getConfigName() {
            return this.configName;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DependencyInfo)) {
                return false;
            }
            DependencyInfo other = (DependencyInfo)o;
            ResolvedDependency this$directDep = this.getDirectDep();
            ResolvedDependency other$directDep = other.getDirectDep();
            if (this$directDep == null ? other$directDep != null : !this$directDep.equals(other$directDep)) {
                return false;
            }
            ResolvedDependency this$dep = this.getDep();
            ResolvedDependency other$dep = other.getDep();
            if (this$dep == null ? other$dep != null : !this$dep.equals(other$dep)) {
                return false;
            }
            String this$configName = this.getConfigName();
            String other$configName = other.getConfigName();
            return !(this$configName == null ? other$configName != null : !this$configName.equals(other$configName));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ResolvedDependency $directDep = this.getDirectDep();
            result = result * 59 + ($directDep == null ? 43 : $directDep.hashCode());
            ResolvedDependency $dep = this.getDep();
            result = result * 59 + ($dep == null ? 43 : $dep.hashCode());
            String $configName = this.getConfigName();
            result = result * 59 + ($configName == null ? 43 : $configName.hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "DependencyInsight.DependencyInfo(directDep=" + this.getDirectDep() + ", dep=" + this.getDep() + ", configName=" + this.getConfigName() + ")";
        }
    }
}

