/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle.marker;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.io.Serializable;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.gradle.attributes.Category;
import org.openrewrite.gradle.attributes.ProjectAttribute;
import org.openrewrite.gradle.marker.GradleDependencyConstraint;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.maven.MavenDownloadingException;
import org.openrewrite.maven.MavenDownloadingExceptions;
import org.openrewrite.maven.attributes.Attributed;
import org.openrewrite.maven.internal.MavenPomDownloader;
import org.openrewrite.maven.tree.Dependency;
import org.openrewrite.maven.tree.GroupArtifact;
import org.openrewrite.maven.tree.GroupArtifactVersion;
import org.openrewrite.maven.tree.ManagedDependency;
import org.openrewrite.maven.tree.MavenRepository;
import org.openrewrite.maven.tree.Pom;
import org.openrewrite.maven.tree.ResolvedDependency;
import org.openrewrite.maven.tree.ResolvedPom;
import org.openrewrite.maven.tree.Scope;
import org.openrewrite.maven.tree.Version;
import org.openrewrite.semver.Semver;

public final class GradleDependencyConfiguration
implements Serializable,
Attributed {
    private final String name;
    private final @Nullable String description;
    private final boolean isTransitive;
    private final boolean isCanBeResolved;
    private final boolean isCanBeConsumed;
    private final boolean isCanBeDeclared;
    private List<GradleDependencyConfiguration> extendsFrom;
    private final List<Dependency> requested;
    private List<ResolvedDependency> directResolved;
    private @Nullable String exceptionType;
    private @Nullable String message;
    private List<GradleDependencyConstraint> constraints;
    private final Map<String, String> attributes;
    private final transient LazyResolutionContext resolutionContext = new LazyResolutionContext();

    public List<ResolvedDependency> getDirectResolved() {
        if (this.resolutionContext.isResolveRequired()) {
            this.resolutionContext.resolve();
        }
        return this.directResolved == null ? Collections.emptyList() : this.directResolved;
    }

    public List<ResolvedDependency> getResolved() {
        ArrayList<ResolvedDependency> resolved = new ArrayList<ResolvedDependency>(this.getDirectResolved());
        HashMap<GroupArtifact, ResolvedDependency> alreadyResolved = new HashMap<GroupArtifact, ResolvedDependency>();
        GradleDependencyConfiguration.resolveTransitiveDependencies(resolved, alreadyResolved);
        return new ArrayList<ResolvedDependency>(alreadyResolved.values());
    }

    public GradleDependencyConfiguration markForReResolution(List<MavenRepository> repositories, ExecutionContext ctx) {
        this.resolutionContext.markForReResolution(repositories, ctx);
        return this;
    }

    List<GradleDependencyConstraint> getAllConstraints() {
        LinkedHashSet<GradleDependencyConstraint> constraintSet = new LinkedHashSet<GradleDependencyConstraint>(this.constraints);
        for (GradleDependencyConfiguration parentConfiguration : this.allExtendsFrom()) {
            constraintSet.addAll(parentConfiguration.getConstraints());
        }
        return new ArrayList<GradleDependencyConstraint>(constraintSet);
    }

    @Deprecated
    public GradleDependencyConfiguration(String name, @Nullable String description, boolean isTransitive, boolean isCanBeResolved, boolean isCanBeConsumed, List<GradleDependencyConfiguration> extendsFrom, List<Dependency> requested, List<ResolvedDependency> directResolved, @Nullable String exceptionType, @Nullable String message) {
        this(name, description, isTransitive, isCanBeResolved, isCanBeConsumed, !name.endsWith("Classpath"), extendsFrom, requested, directResolved, exceptionType, message);
    }

    @Deprecated
    public GradleDependencyConfiguration(String name, @Nullable String description, boolean isTransitive, boolean isCanBeResolved, boolean isCanBeConsumed, boolean isCanBeDeclared, List<GradleDependencyConfiguration> extendsFrom, List<Dependency> requested, List<ResolvedDependency> directResolved, @Nullable String exceptionType, @Nullable String message) {
        this.name = name;
        this.description = description;
        this.isTransitive = isTransitive;
        this.isCanBeResolved = isCanBeResolved;
        this.isCanBeConsumed = isCanBeConsumed;
        this.isCanBeDeclared = isCanBeDeclared;
        this.extendsFrom = extendsFrom;
        this.requested = requested;
        this.directResolved = directResolved;
        this.exceptionType = exceptionType;
        this.message = message;
        this.constraints = Collections.emptyList();
        this.attributes = Collections.emptyMap();
    }

    public List<GradleDependencyConfiguration> allExtendsFrom() {
        LinkedHashSet<GradleDependencyConfiguration> result = new LinkedHashSet<GradleDependencyConfiguration>();
        for (GradleDependencyConfiguration parentConfiguration : this.getExtendsFrom()) {
            result.add(parentConfiguration);
            result.addAll(parentConfiguration.allExtendsFrom());
        }
        return new ArrayList<GradleDependencyConfiguration>(result);
    }

    public @Nullable Dependency findRequestedDependency(@Nullable String groupId, String artifactId) {
        for (Dependency d : this.requested) {
            if (!StringUtils.matchesGlob((String)d.getGav().getGroupId(), (String)groupId) || !StringUtils.matchesGlob((String)d.getGav().getArtifactId(), (String)artifactId)) continue;
            return d;
        }
        return null;
    }

    public @Nullable ResolvedDependency findResolvedDependency(@Nullable String groupId, String artifactId) {
        for (ResolvedDependency d : this.getDirectResolved()) {
            ResolvedDependency dependency = d.findDependency(groupId == null ? "" : groupId, artifactId);
            if (dependency == null) continue;
            return dependency;
        }
        return null;
    }

    public void unsafeSetExtendsFrom(List<GradleDependencyConfiguration> extendsFrom) {
        this.extendsFrom = extendsFrom;
    }

    public void unsafeSetConstraints(List<GradleDependencyConstraint> constraints) {
        this.constraints = constraints;
    }

    void unsafeSetDirectResolved(List<ResolvedDependency> directResolved) {
        this.directResolved = directResolved;
    }

    private static void resolveTransitiveDependencies(List<ResolvedDependency> resolved, Map<GroupArtifact, ResolvedDependency> alreadyResolved) {
        for (ResolvedDependency dependency : resolved) {
            GroupArtifact ga = dependency.getGav().asGroupArtifact();
            if (alreadyResolved.containsKey(ga)) {
                ResolvedDependency alreadyPresent = alreadyResolved.get(ga);
                Version newVersion = new Version(dependency.getVersion());
                Version presentVersion = new Version(alreadyPresent.getVersion());
                int compared = presentVersion.compareTo(newVersion);
                if (compared > 0 || compared == 0 && alreadyPresent.getDependencies().size() == dependency.getDependencies().size()) continue;
            }
            alreadyResolved.put(ga, dependency);
            GradleDependencyConfiguration.resolveTransitiveDependencies(dependency.getDependencies(), alreadyResolved);
        }
    }

    public static List<GradleDependencyConstraint> merge(@Nullable Collection<GradleDependencyConstraint> preferred, @Nullable Collection<GradleDependencyConstraint> others) {
        if ((preferred == null || preferred.isEmpty()) && (others == null || others.isEmpty())) {
            return Collections.emptyList();
        }
        if (preferred == null || preferred.isEmpty()) {
            return new ArrayList<GradleDependencyConstraint>(others);
        }
        if (others == null || others.isEmpty()) {
            return new ArrayList<GradleDependencyConstraint>(preferred);
        }
        Map<GroupArtifact, GradleDependencyConstraint> results = preferred.stream().collect(Collectors.toMap(it -> new GroupArtifact(it.getGroupId(), it.getArtifactId()), it -> it));
        for (GradleDependencyConstraint lowerPrecedenceConstraint : others) {
            results.putIfAbsent(new GroupArtifact(lowerPrecedenceConstraint.getGroupId(), lowerPrecedenceConstraint.getArtifactId()), lowerPrecedenceConstraint);
        }
        return new ArrayList<GradleDependencyConstraint>(results.values());
    }

    public GradleDependencyConfiguration removeDirectDependencies(Collection<GroupArtifact> gas, List<MavenRepository> repositories, ExecutionContext ctx) {
        return this.mapDependencies(d -> {
            for (GroupArtifact gav : gas) {
                if (!Objects.equals(d.getGroupId(), gav.getGroupId()) || !Objects.equals(d.getArtifactId(), gav.getArtifactId())) continue;
                return null;
            }
            return d;
        }, repositories, ctx);
    }

    public GradleDependencyConfiguration upgradeDirectDependencies(Collection<GroupArtifactVersion> gavs, List<MavenRepository> repositories, ExecutionContext ctx) {
        return this.mapDependencies(d -> {
            for (GroupArtifactVersion gav : gavs) {
                if (!Objects.equals(d.getGroupId(), gav.getGroupId()) || !Objects.equals(d.getArtifactId(), gav.getArtifactId()) || Objects.equals(d.getVersion(), Semver.max((String)d.getVersion(), (String)gav.getVersion()))) continue;
                return d.withGav(new GroupArtifactVersion(gav.getGroupId(), gav.getArtifactId(), gav.getVersion()));
            }
            return d;
        }, repositories, ctx);
    }

    public GradleDependencyConfiguration upgradeDirectDependency(GroupArtifactVersion gav, List<MavenRepository> repositories, ExecutionContext ctx) {
        return this.mapDependencies(d -> {
            if (Objects.equals(d.getGroupId(), gav.getGroupId()) && Objects.equals(d.getArtifactId(), gav.getArtifactId()) && !Objects.equals(d.getVersion(), Semver.max((String)d.getVersion(), (String)gav.getVersion()))) {
                return d.withGav(gav);
            }
            return d;
        }, repositories, ctx);
    }

    public GradleDependencyConfiguration changeDependencyConstraints(Collection<GroupArtifactVersion> gavs, List<MavenRepository> repositories, ExecutionContext ctx) {
        return this.mapConstraints(c -> {
            for (GroupArtifactVersion gav : gavs) {
                if (!Objects.equals(c.getGroupId(), gav.getGroupId()) || !Objects.equals(c.getArtifactId(), gav.getArtifactId()) || Objects.equals(c.approximateEffectiveVersion(), gav.getVersion())) continue;
                return c.withPreferredVersion(null).withStrictVersion(null).withRequiredVersion(gav.getVersion());
            }
            return c;
        }, repositories, ctx);
    }

    public GradleDependencyConfiguration mapConstraints(Function<GradleDependencyConstraint, @Nullable GradleDependencyConstraint> mapping, List<MavenRepository> repositories, ExecutionContext ctx) {
        List newConstraints = ListUtils.map(this.constraints, mapping::apply);
        if (this.constraints == newConstraints) {
            return this;
        }
        return this.withConstraints(newConstraints).markForReResolution(repositories, ctx);
    }

    public GradleDependencyConfiguration addConstraint(GradleDependencyConstraint constraint, List<MavenRepository> repositories, ExecutionContext ctx) {
        List newConstraints = ListUtils.concat(this.constraints, (Object)constraint);
        if (this.constraints == newConstraints) {
            return this;
        }
        return this.withConstraints(newConstraints).markForReResolution(repositories, ctx);
    }

    public GradleDependencyConfiguration addOrUpdateConstraint(GroupArtifactVersion gav, List<MavenRepository> repositories, ExecutionContext ctx) {
        return this.addOrUpdateConstraint(GradleDependencyConstraint.builder().groupId(gav.getGroupId() == null ? "" : gav.getGroupId()).artifactId(gav.getArtifactId()).requiredVersion(gav.getVersion()).build(), repositories, ctx);
    }

    public GradleDependencyConfiguration addOrUpdateConstraint(GradleDependencyConstraint constraint, List<MavenRepository> repositories, ExecutionContext ctx) {
        GradleDependencyConfiguration maybeUpdated = this.mapConstraints(it -> {
            if (Objects.equals(it.getArtifactId(), constraint.getArtifactId()) && Objects.equals(it.getGroupId(), constraint.getGroupId()) && !Objects.equals(it.approximateEffectiveVersion(), constraint.approximateEffectiveVersion())) {
                return constraint;
            }
            return it;
        }, repositories, ctx);
        if (maybeUpdated == this) {
            maybeUpdated = this.addConstraint(constraint, repositories, ctx);
        }
        return maybeUpdated;
    }

    public GradleDependencyConfiguration mapDependencies(Function<Dependency, @Nullable Dependency> mapping, List<MavenRepository> repositories, ExecutionContext ctx) {
        List newRequested = ListUtils.map(this.requested, mapping::apply);
        if (this.requested == newRequested) {
            return this;
        }
        return this.withRequested(newRequested).markForReResolution(repositories, ctx);
    }

    private List<ManagedDependency> managedFrom(List<Dependency> maybeContainsBoms) {
        List<GradleDependencyConstraint> allConstraints = this.getAllConstraints();
        ArrayList<ManagedDependency> managed = new ArrayList<ManagedDependency>(allConstraints.size() + maybeContainsBoms.size());
        for (Dependency maybeBom : maybeContainsBoms) {
            maybeBom.findAttribute(Category.class).ifPresent(category -> {
                if (category.isBom()) {
                    managed.add((ManagedDependency)new ManagedDependency.Imported(maybeBom.getGav()));
                }
            });
        }
        for (GradleDependencyConstraint constraint : allConstraints) {
            String version = null;
            if (StringUtils.isNotEmpty((String)constraint.getStrictVersion())) {
                version = constraint.getStrictVersion();
            } else if (StringUtils.isNotEmpty((String)constraint.getRequiredVersion())) {
                version = constraint.getRequiredVersion();
            } else if (StringUtils.isNotEmpty((String)constraint.getPreferredVersion())) {
                version = constraint.getPreferredVersion();
            }
            if (version == null) continue;
            managed.add((ManagedDependency)new ManagedDependency.Defined(new GroupArtifactVersion(constraint.getGroupId(), constraint.getArtifactId(), version), null, null, null, null));
        }
        return managed;
    }

    private Pom singleDependencyPom(Dependency requested, List<Dependency> maybeContainsBoms, List<MavenRepository> repositories, ExecutionContext ctx) {
        Dependency mavenCompatibleRequested = requested.withScope("compile");
        if (requested.findAttribute(Category.class).isPresent()) {
            mavenCompatibleRequested = mavenCompatibleRequested.withType("pom");
        }
        GroupArtifactVersion requestedGav = requested.getGav();
        List bomsOnly = ListUtils.filter(maybeContainsBoms, it -> it.findAttribute(Category.class).isPresent());
        return Pom.builder().gav(requestedGav.asResolved().withGroupId("sdp-" + requestedGav.getGroupId()).withArtifactId("sdp-" + requestedGav.getArtifactId()).withVersion(String.valueOf(Objects.hash(requested, this.getAllConstraints(), bomsOnly, repositories)))).repositories(repositories).dependencyManagement(this.managedFrom(bomsOnly)).dependencies(Collections.singletonList(mavenCompatibleRequested)).sourcePath(Paths.get("pom.xml", new String[0])).build();
    }

    public static Map<String, GradleDependencyConfiguration> updateExtendsFrom(Map<String, GradleDependencyConfiguration> updatedConfigurations, Map<String, GradleDependencyConfiguration> untouchedConfigurations) {
        HashMap<String, GradleDependencyConfiguration> result = new HashMap<String, GradleDependencyConfiguration>();
        for (GradleDependencyConfiguration conf : updatedConfigurations.values()) {
            conf.unsafeSetExtendsFrom(ListUtils.map(conf.getExtendsFrom(), extending -> updatedConfigurations.getOrDefault(extending.getName(), (GradleDependencyConfiguration)untouchedConfigurations.get(extending.getName()))));
            result.put(conf.getName(), conf);
        }
        for (GradleDependencyConfiguration conf : untouchedConfigurations.values()) {
            conf.unsafeSetExtendsFrom(ListUtils.map(conf.getExtendsFrom(), extending -> updatedConfigurations.getOrDefault(extending.getName(), (GradleDependencyConfiguration)untouchedConfigurations.get(extending.getName()))));
            result.put(conf.getName(), conf);
        }
        return result;
    }

    protected GradleDependencyConfiguration clone() {
        return new GradleDependencyConfiguration(this.name, this.description, this.isTransitive, this.isCanBeResolved, this.isCanBeConsumed, this.isCanBeDeclared, this.extendsFrom.stream().map(GradleDependencyConfiguration::clone).collect(Collectors.toList()), this.requested, this.getDirectResolved(), this.exceptionType, this.message, this.constraints, this.attributes);
    }

    @NonNull
    @Generated
    public static GradleDependencyConfigurationBuilder builder() {
        return new GradleDependencyConfigurationBuilder();
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public @Nullable String getDescription() {
        return this.description;
    }

    @Generated
    public boolean isTransitive() {
        return this.isTransitive;
    }

    @Generated
    public boolean isCanBeResolved() {
        return this.isCanBeResolved;
    }

    @Generated
    public boolean isCanBeConsumed() {
        return this.isCanBeConsumed;
    }

    @Generated
    public boolean isCanBeDeclared() {
        return this.isCanBeDeclared;
    }

    @Generated
    public List<GradleDependencyConfiguration> getExtendsFrom() {
        return this.extendsFrom;
    }

    @Generated
    public List<Dependency> getRequested() {
        return this.requested;
    }

    @Generated
    public @Nullable String getExceptionType() {
        return this.exceptionType;
    }

    @Generated
    public @Nullable String getMessage() {
        return this.message;
    }

    @Generated
    public List<GradleDependencyConstraint> getConstraints() {
        return this.constraints;
    }

    @Generated
    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    @Generated
    public LazyResolutionContext getResolutionContext() {
        return this.resolutionContext;
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GradleDependencyConfiguration)) {
            return false;
        }
        GradleDependencyConfiguration other = (GradleDependencyConfiguration)o;
        if (this.isTransitive() != other.isTransitive()) {
            return false;
        }
        if (this.isCanBeResolved() != other.isCanBeResolved()) {
            return false;
        }
        if (this.isCanBeConsumed() != other.isCanBeConsumed()) {
            return false;
        }
        if (this.isCanBeDeclared() != other.isCanBeDeclared()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        List<GradleDependencyConfiguration> this$extendsFrom = this.getExtendsFrom();
        List<GradleDependencyConfiguration> other$extendsFrom = other.getExtendsFrom();
        if (this$extendsFrom == null ? other$extendsFrom != null : !((Object)this$extendsFrom).equals(other$extendsFrom)) {
            return false;
        }
        List<Dependency> this$requested = this.getRequested();
        List<Dependency> other$requested = other.getRequested();
        if (this$requested == null ? other$requested != null : !((Object)this$requested).equals(other$requested)) {
            return false;
        }
        List<ResolvedDependency> this$directResolved = this.getDirectResolved();
        List<ResolvedDependency> other$directResolved = other.getDirectResolved();
        if (this$directResolved == null ? other$directResolved != null : !((Object)this$directResolved).equals(other$directResolved)) {
            return false;
        }
        String this$exceptionType = this.getExceptionType();
        String other$exceptionType = other.getExceptionType();
        if (this$exceptionType == null ? other$exceptionType != null : !this$exceptionType.equals(other$exceptionType)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        List<GradleDependencyConstraint> this$constraints = this.getConstraints();
        List<GradleDependencyConstraint> other$constraints = other.getConstraints();
        if (this$constraints == null ? other$constraints != null : !((Object)this$constraints).equals(other$constraints)) {
            return false;
        }
        Map<String, String> this$attributes = this.getAttributes();
        Map<String, String> other$attributes = other.getAttributes();
        return !(this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isTransitive() ? 79 : 97);
        result = result * 59 + (this.isCanBeResolved() ? 79 : 97);
        result = result * 59 + (this.isCanBeConsumed() ? 79 : 97);
        result = result * 59 + (this.isCanBeDeclared() ? 79 : 97);
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        List<GradleDependencyConfiguration> $extendsFrom = this.getExtendsFrom();
        result = result * 59 + ($extendsFrom == null ? 43 : ((Object)$extendsFrom).hashCode());
        List<Dependency> $requested = this.getRequested();
        result = result * 59 + ($requested == null ? 43 : ((Object)$requested).hashCode());
        List<ResolvedDependency> $directResolved = this.getDirectResolved();
        result = result * 59 + ($directResolved == null ? 43 : ((Object)$directResolved).hashCode());
        String $exceptionType = this.getExceptionType();
        result = result * 59 + ($exceptionType == null ? 43 : $exceptionType.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        List<GradleDependencyConstraint> $constraints = this.getConstraints();
        result = result * 59 + ($constraints == null ? 43 : ((Object)$constraints).hashCode());
        Map<String, String> $attributes = this.getAttributes();
        result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
        return result;
    }

    @NonNull
    @Generated
    public String toString() {
        return "GradleDependencyConfiguration(name=" + this.getName() + ", description=" + this.getDescription() + ", isTransitive=" + this.isTransitive() + ", isCanBeResolved=" + this.isCanBeResolved() + ", isCanBeConsumed=" + this.isCanBeConsumed() + ", isCanBeDeclared=" + this.isCanBeDeclared() + ", extendsFrom=" + this.getExtendsFrom() + ", requested=" + this.getRequested() + ", directResolved=" + this.getDirectResolved() + ", exceptionType=" + this.getExceptionType() + ", message=" + this.getMessage() + ", constraints=" + this.getConstraints() + ", attributes=" + this.getAttributes() + ", resolutionContext=" + this.getResolutionContext() + ")";
    }

    @NonNull
    @Generated
    public GradleDependencyConfiguration withName(String name) {
        return this.name == name ? this : new GradleDependencyConfiguration(name, this.description, this.isTransitive, this.isCanBeResolved, this.isCanBeConsumed, this.isCanBeDeclared, this.extendsFrom, this.requested, this.directResolved, this.exceptionType, this.message, this.constraints, this.attributes);
    }

    @NonNull
    @Generated
    public GradleDependencyConfiguration withDescription(@Nullable String description) {
        return this.description == description ? this : new GradleDependencyConfiguration(this.name, description, this.isTransitive, this.isCanBeResolved, this.isCanBeConsumed, this.isCanBeDeclared, this.extendsFrom, this.requested, this.directResolved, this.exceptionType, this.message, this.constraints, this.attributes);
    }

    @NonNull
    @Generated
    public GradleDependencyConfiguration withTransitive(boolean isTransitive) {
        return this.isTransitive == isTransitive ? this : new GradleDependencyConfiguration(this.name, this.description, isTransitive, this.isCanBeResolved, this.isCanBeConsumed, this.isCanBeDeclared, this.extendsFrom, this.requested, this.directResolved, this.exceptionType, this.message, this.constraints, this.attributes);
    }

    @NonNull
    @Generated
    public GradleDependencyConfiguration withCanBeResolved(boolean isCanBeResolved) {
        return this.isCanBeResolved == isCanBeResolved ? this : new GradleDependencyConfiguration(this.name, this.description, this.isTransitive, isCanBeResolved, this.isCanBeConsumed, this.isCanBeDeclared, this.extendsFrom, this.requested, this.directResolved, this.exceptionType, this.message, this.constraints, this.attributes);
    }

    @NonNull
    @Generated
    public GradleDependencyConfiguration withCanBeConsumed(boolean isCanBeConsumed) {
        return this.isCanBeConsumed == isCanBeConsumed ? this : new GradleDependencyConfiguration(this.name, this.description, this.isTransitive, this.isCanBeResolved, isCanBeConsumed, this.isCanBeDeclared, this.extendsFrom, this.requested, this.directResolved, this.exceptionType, this.message, this.constraints, this.attributes);
    }

    @NonNull
    @Generated
    public GradleDependencyConfiguration withCanBeDeclared(boolean isCanBeDeclared) {
        return this.isCanBeDeclared == isCanBeDeclared ? this : new GradleDependencyConfiguration(this.name, this.description, this.isTransitive, this.isCanBeResolved, this.isCanBeConsumed, isCanBeDeclared, this.extendsFrom, this.requested, this.directResolved, this.exceptionType, this.message, this.constraints, this.attributes);
    }

    @NonNull
    @Generated
    public GradleDependencyConfiguration withExtendsFrom(List<GradleDependencyConfiguration> extendsFrom) {
        return this.extendsFrom == extendsFrom ? this : new GradleDependencyConfiguration(this.name, this.description, this.isTransitive, this.isCanBeResolved, this.isCanBeConsumed, this.isCanBeDeclared, extendsFrom, this.requested, this.directResolved, this.exceptionType, this.message, this.constraints, this.attributes);
    }

    @NonNull
    @Generated
    public GradleDependencyConfiguration withRequested(List<Dependency> requested) {
        return this.requested == requested ? this : new GradleDependencyConfiguration(this.name, this.description, this.isTransitive, this.isCanBeResolved, this.isCanBeConsumed, this.isCanBeDeclared, this.extendsFrom, requested, this.directResolved, this.exceptionType, this.message, this.constraints, this.attributes);
    }

    @NonNull
    @Generated
    public GradleDependencyConfiguration withDirectResolved(List<ResolvedDependency> directResolved) {
        return this.directResolved == directResolved ? this : new GradleDependencyConfiguration(this.name, this.description, this.isTransitive, this.isCanBeResolved, this.isCanBeConsumed, this.isCanBeDeclared, this.extendsFrom, this.requested, directResolved, this.exceptionType, this.message, this.constraints, this.attributes);
    }

    @NonNull
    @Generated
    public GradleDependencyConfiguration withExceptionType(@Nullable String exceptionType) {
        return this.exceptionType == exceptionType ? this : new GradleDependencyConfiguration(this.name, this.description, this.isTransitive, this.isCanBeResolved, this.isCanBeConsumed, this.isCanBeDeclared, this.extendsFrom, this.requested, this.directResolved, exceptionType, this.message, this.constraints, this.attributes);
    }

    @NonNull
    @Generated
    public GradleDependencyConfiguration withMessage(@Nullable String message) {
        return this.message == message ? this : new GradleDependencyConfiguration(this.name, this.description, this.isTransitive, this.isCanBeResolved, this.isCanBeConsumed, this.isCanBeDeclared, this.extendsFrom, this.requested, this.directResolved, this.exceptionType, message, this.constraints, this.attributes);
    }

    @NonNull
    @Generated
    public GradleDependencyConfiguration withConstraints(List<GradleDependencyConstraint> constraints) {
        return this.constraints == constraints ? this : new GradleDependencyConfiguration(this.name, this.description, this.isTransitive, this.isCanBeResolved, this.isCanBeConsumed, this.isCanBeDeclared, this.extendsFrom, this.requested, this.directResolved, this.exceptionType, this.message, constraints, this.attributes);
    }

    @NonNull
    @Generated
    public GradleDependencyConfiguration withAttributes(Map<String, String> attributes) {
        return this.attributes == attributes ? this : new GradleDependencyConfiguration(this.name, this.description, this.isTransitive, this.isCanBeResolved, this.isCanBeConsumed, this.isCanBeDeclared, this.extendsFrom, this.requested, this.directResolved, this.exceptionType, this.message, this.constraints, attributes);
    }

    @JsonCreator
    @Generated
    public GradleDependencyConfiguration(String name, @Nullable String description, boolean isTransitive, boolean isCanBeResolved, boolean isCanBeConsumed, boolean isCanBeDeclared, List<GradleDependencyConfiguration> extendsFrom, List<Dependency> requested, List<ResolvedDependency> directResolved, @Nullable String exceptionType, @Nullable String message, List<GradleDependencyConstraint> constraints, Map<String, String> attributes) {
        this.name = name;
        this.description = description;
        this.isTransitive = isTransitive;
        this.isCanBeResolved = isCanBeResolved;
        this.isCanBeConsumed = isCanBeConsumed;
        this.isCanBeDeclared = isCanBeDeclared;
        this.extendsFrom = extendsFrom;
        this.requested = requested;
        this.directResolved = directResolved;
        this.exceptionType = exceptionType;
        this.message = message;
        this.constraints = constraints;
        this.attributes = attributes;
    }

    private class LazyResolutionContext {
        private boolean resolveRequired;
        private @Nullable List<MavenRepository> repositories;
        private @Nullable ExecutionContext ctx;

        private LazyResolutionContext() {
        }

        public void markForReResolution(List<MavenRepository> repositories, ExecutionContext ctx) {
            this.repositories = repositories;
            this.resolveRequired = true;
            this.ctx = ctx;
        }

        public void resolve() {
            if (!this.resolveRequired || this.repositories == null || this.ctx == null) {
                return;
            }
            if (GradleDependencyConfiguration.this.isCanBeResolved) {
                MavenPomDownloader mpd = new MavenPomDownloader(this.ctx);
                ArrayList<ResolvedDependency> newResolved = new ArrayList<ResolvedDependency>(GradleDependencyConfiguration.this.requested.size());
                Map<GroupArtifact, ResolvedDependency> gaToOriginalDirectResolved = null;
                for (Dependency dep : GradleDependencyConfiguration.this.requested) {
                    try {
                        if (dep.findAttribute(ProjectAttribute.class).isPresent()) {
                            ResolvedDependency resolved = ResolvedDependency.builder().gav(dep.getGav().asResolved()).requested(dep).classifier(dep.getClassifier()).build();
                            newResolved.add(resolved);
                            continue;
                        }
                        Pom singlePom = GradleDependencyConfiguration.this.singleDependencyPom(dep, GradleDependencyConfiguration.this.requested, this.repositories, this.ctx);
                        ResolvedPom singleDependencyResolved = singlePom.resolve(Collections.emptyList(), mpd, this.ctx);
                        ResolvedDependency resolved = (ResolvedDependency)singleDependencyResolved.resolveDependencies(Scope.Compile, mpd, this.ctx).get(0);
                        newResolved.add(resolved);
                    }
                    catch (MavenDownloadingException | MavenDownloadingExceptions e) {
                        ResolvedDependency maybeOriginal;
                        MavenDownloadingException m = e instanceof MavenDownloadingException ? (MavenDownloadingException)e : (MavenDownloadingException)((Object)((MavenDownloadingExceptions)e).getExceptions().get(0));
                        GradleDependencyConfiguration.this.exceptionType = ((Object)((Object)m)).getClass().getName();
                        GradleDependencyConfiguration.this.message = e.getMessage();
                        if (gaToOriginalDirectResolved == null) {
                            gaToOriginalDirectResolved = GradleDependencyConfiguration.this.directResolved.stream().collect(Collectors.toMap(it -> it.getGav().asGroupArtifact(), it -> it));
                        }
                        if ((maybeOriginal = (ResolvedDependency)gaToOriginalDirectResolved.get(dep.getGav().asGroupArtifact())) == null) continue;
                        newResolved.add(maybeOriginal);
                    }
                }
                GradleDependencyConfiguration.this.unsafeSetDirectResolved(newResolved);
            }
            this.resolveRequired = false;
            this.repositories = null;
            this.ctx = null;
        }

        @Generated
        public boolean isResolveRequired() {
            return this.resolveRequired;
        }
    }

    @Generated
    public static class GradleDependencyConfigurationBuilder {
        @Generated
        private String name;
        @Generated
        private String description;
        @Generated
        private boolean isTransitive;
        @Generated
        private boolean isCanBeResolved;
        @Generated
        private boolean isCanBeConsumed;
        @Generated
        private boolean isCanBeDeclared;
        @Generated
        private List<GradleDependencyConfiguration> extendsFrom;
        @Generated
        private List<Dependency> requested;
        @Generated
        private List<ResolvedDependency> directResolved;
        @Generated
        private String exceptionType;
        @Generated
        private String message;
        @Generated
        private List<GradleDependencyConstraint> constraints;
        @Generated
        private Map<String, String> attributes;

        @Generated
        GradleDependencyConfigurationBuilder() {
        }

        @NonNull
        @Generated
        public GradleDependencyConfigurationBuilder name(String name) {
            this.name = name;
            return this;
        }

        @NonNull
        @Generated
        public GradleDependencyConfigurationBuilder description(@Nullable String description) {
            this.description = description;
            return this;
        }

        @NonNull
        @Generated
        public GradleDependencyConfigurationBuilder isTransitive(boolean isTransitive) {
            this.isTransitive = isTransitive;
            return this;
        }

        @NonNull
        @Generated
        public GradleDependencyConfigurationBuilder isCanBeResolved(boolean isCanBeResolved) {
            this.isCanBeResolved = isCanBeResolved;
            return this;
        }

        @NonNull
        @Generated
        public GradleDependencyConfigurationBuilder isCanBeConsumed(boolean isCanBeConsumed) {
            this.isCanBeConsumed = isCanBeConsumed;
            return this;
        }

        @NonNull
        @Generated
        public GradleDependencyConfigurationBuilder isCanBeDeclared(boolean isCanBeDeclared) {
            this.isCanBeDeclared = isCanBeDeclared;
            return this;
        }

        @NonNull
        @Generated
        public GradleDependencyConfigurationBuilder extendsFrom(List<GradleDependencyConfiguration> extendsFrom) {
            this.extendsFrom = extendsFrom;
            return this;
        }

        @NonNull
        @Generated
        public GradleDependencyConfigurationBuilder requested(List<Dependency> requested) {
            this.requested = requested;
            return this;
        }

        @NonNull
        @Generated
        public GradleDependencyConfigurationBuilder directResolved(List<ResolvedDependency> directResolved) {
            this.directResolved = directResolved;
            return this;
        }

        @NonNull
        @Generated
        public GradleDependencyConfigurationBuilder exceptionType(@Nullable String exceptionType) {
            this.exceptionType = exceptionType;
            return this;
        }

        @NonNull
        @Generated
        public GradleDependencyConfigurationBuilder message(@Nullable String message) {
            this.message = message;
            return this;
        }

        @NonNull
        @Generated
        public GradleDependencyConfigurationBuilder constraints(List<GradleDependencyConstraint> constraints) {
            this.constraints = constraints;
            return this;
        }

        @NonNull
        @Generated
        public GradleDependencyConfigurationBuilder attributes(Map<String, String> attributes) {
            this.attributes = attributes;
            return this;
        }

        @NonNull
        @Generated
        public GradleDependencyConfiguration build() {
            return new GradleDependencyConfiguration(this.name, this.description, this.isTransitive, this.isCanBeResolved, this.isCanBeConsumed, this.isCanBeDeclared, this.extendsFrom, this.requested, this.directResolved, this.exceptionType, this.message, this.constraints, this.attributes);
        }

        @NonNull
        @Generated
        public String toString() {
            return "GradleDependencyConfiguration.GradleDependencyConfigurationBuilder(name=" + this.name + ", description=" + this.description + ", isTransitive=" + this.isTransitive + ", isCanBeResolved=" + this.isCanBeResolved + ", isCanBeConsumed=" + this.isCanBeConsumed + ", isCanBeDeclared=" + this.isCanBeDeclared + ", extendsFrom=" + this.extendsFrom + ", requested=" + this.requested + ", directResolved=" + this.directResolved + ", exceptionType=" + this.exceptionType + ", message=" + this.message + ", constraints=" + this.constraints + ", attributes=" + this.attributes + ")";
        }
    }
}

