/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle.trait;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.gradle.internal.Dependency;
import org.openrewrite.gradle.internal.DependencyStringNotationConverter;
import org.openrewrite.gradle.marker.GradleDependencyConfiguration;
import org.openrewrite.gradle.marker.GradleProject;
import org.openrewrite.gradle.trait.GradleTraitMatcher;
import org.openrewrite.groovy.tree.G;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.kotlin.tree.K;
import org.openrewrite.maven.tree.GroupArtifactVersion;
import org.openrewrite.maven.tree.ResolvedDependency;
import org.openrewrite.maven.tree.ResolvedGroupArtifactVersion;
import org.openrewrite.trait.Trait;
import org.openrewrite.trait.VisitFunction2;

public final class GradleDependency
implements Trait<J.MethodInvocation> {
    private final Cursor cursor;
    private final ResolvedDependency resolvedDependency;

    @Generated
    public GradleDependency(Cursor cursor, ResolvedDependency resolvedDependency) {
        this.cursor = cursor;
        this.resolvedDependency = resolvedDependency;
    }

    @Generated
    public Cursor getCursor() {
        return this.cursor;
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GradleDependency)) {
            return false;
        }
        GradleDependency other = (GradleDependency)o;
        Cursor this$cursor = this.getCursor();
        Cursor other$cursor = other.getCursor();
        if (this$cursor == null ? other$cursor != null : !this$cursor.equals(other$cursor)) {
            return false;
        }
        ResolvedDependency this$resolvedDependency = this.getResolvedDependency();
        ResolvedDependency other$resolvedDependency = other.getResolvedDependency();
        return !(this$resolvedDependency == null ? other$resolvedDependency != null : !this$resolvedDependency.equals(other$resolvedDependency));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Cursor $cursor = this.getCursor();
        result = result * 59 + ($cursor == null ? 43 : $cursor.hashCode());
        ResolvedDependency $resolvedDependency = this.getResolvedDependency();
        result = result * 59 + ($resolvedDependency == null ? 43 : $resolvedDependency.hashCode());
        return result;
    }

    @NonNull
    @Generated
    public String toString() {
        return "GradleDependency(cursor=" + this.getCursor() + ", resolvedDependency=" + this.getResolvedDependency() + ")";
    }

    @Generated
    public ResolvedDependency getResolvedDependency() {
        return this.resolvedDependency;
    }

    public static class Matcher
    extends GradleTraitMatcher<GradleDependency> {
        private static final MethodMatcher DEPENDENCY_DSL_MATCHER = new MethodMatcher("DependencyHandlerSpec *(..)");
        protected @Nullable String configuration;
        protected @Nullable String groupId;
        protected @Nullable String artifactId;

        public Matcher configuration(@Nullable String configuration) {
            this.configuration = configuration;
            return this;
        }

        public Matcher groupId(@Nullable String groupId) {
            this.groupId = groupId;
            return this;
        }

        public Matcher artifactId(@Nullable String artifactId) {
            this.artifactId = artifactId;
            return this;
        }

        public <P> TreeVisitor<? extends Tree, P> asVisitor(final VisitFunction2<GradleDependency, P> visitor) {
            return new JavaVisitor<P>(){

                public J visitMethodInvocation(J.MethodInvocation method, P p) {
                    GradleDependency dependency = this.test(this.getCursor());
                    return dependency != null ? (J)visitor.visit((Trait)dependency, p) : super.visitMethodInvocation(method, p);
                }
            };
        }

        protected @Nullable GradleDependency test(Cursor cursor) {
            Object object = cursor.getValue();
            if (object instanceof J.MethodInvocation) {
                J.MethodInvocation methodInvocation = (J.MethodInvocation)object;
                if (!this.withinDependenciesBlock(cursor)) {
                    return null;
                }
                if (this.withinDependencyConstraintsBlock(cursor)) {
                    return null;
                }
                GradleProject gradleProject = this.getGradleProject(cursor);
                GradleDependencyConfiguration gdc = Matcher.getConfiguration(gradleProject, methodInvocation);
                if (gdc == null && (!DEPENDENCY_DSL_MATCHER.matches((MethodCall)methodInvocation) || "project".equals(methodInvocation.getSimpleName()))) {
                    return null;
                }
                if (!StringUtils.isBlank((String)this.configuration) && !methodInvocation.getSimpleName().equals(this.configuration)) {
                    return null;
                }
                Dependency dependency = null;
                Expression argument = (Expression)methodInvocation.getArguments().get(0);
                if (argument instanceof J.Literal || argument instanceof G.GString || argument instanceof G.MapEntry || argument instanceof G.MapLiteral || argument instanceof J.Assignment || argument instanceof K.StringTemplate) {
                    dependency = this.parseDependency(methodInvocation.getArguments());
                } else if (argument instanceof J.Binary && ((J.Binary)argument).getLeft() instanceof J.Literal) {
                    dependency = this.parseDependency(Arrays.asList(((J.Binary)argument).getLeft()));
                } else if (argument instanceof J.MethodInvocation) {
                    if (((J.MethodInvocation)argument).getSimpleName().equals("platform") || ((J.MethodInvocation)argument).getSimpleName().equals("enforcedPlatform")) {
                        dependency = this.parseDependency(((J.MethodInvocation)argument).getArguments());
                    } else if (((J.MethodInvocation)argument).getSimpleName().equals("project")) {
                        return null;
                    }
                }
                if (dependency == null) {
                    return null;
                }
                if (gdc != null) {
                    if (gdc.isCanBeResolved()) {
                        for (ResolvedDependency resolvedDependency : gdc.getResolved()) {
                            org.openrewrite.maven.tree.Dependency req;
                            if (this.groupId != null && !StringUtils.matchesGlob((String)resolvedDependency.getGroupId(), (String)this.groupId) || this.artifactId != null && !StringUtils.matchesGlob((String)resolvedDependency.getArtifactId(), (String)this.artifactId) || (req = resolvedDependency.getRequested()).getGroupId() != null && !req.getGroupId().equals(dependency.getGroupId()) || !req.getArtifactId().equals(dependency.getArtifactId())) continue;
                            return new GradleDependency(cursor, Matcher.withRequested(resolvedDependency, dependency));
                        }
                    } else {
                        for (GradleDependencyConfiguration transitiveConfiguration : gradleProject.configurationsExtendingFrom(gdc, true)) {
                            if (!transitiveConfiguration.isCanBeResolved()) continue;
                            for (ResolvedDependency resolvedDependency : transitiveConfiguration.getResolved()) {
                                org.openrewrite.maven.tree.Dependency req;
                                if (this.groupId != null && !StringUtils.matchesGlob((String)resolvedDependency.getGroupId(), (String)this.groupId) || this.artifactId != null && !StringUtils.matchesGlob((String)resolvedDependency.getArtifactId(), (String)this.artifactId) || (req = resolvedDependency.getRequested()).getGroupId() != null && !req.getGroupId().equals(dependency.getGroupId()) || !req.getArtifactId().equals(dependency.getArtifactId())) continue;
                                return new GradleDependency(cursor, Matcher.withRequested(resolvedDependency, dependency));
                            }
                        }
                    }
                }
                if ((this.groupId == null || StringUtils.matchesGlob((String)dependency.getGroupId(), (String)this.groupId)) && (this.artifactId == null || StringUtils.matchesGlob((String)dependency.getArtifactId(), (String)this.artifactId))) {
                    ResolvedDependency resolvedDependency = ResolvedDependency.builder().depth(-1).gav(new ResolvedGroupArtifactVersion(null, dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion() != null ? dependency.getVersion() : "", null)).classifier(dependency.getClassifier()).type(dependency.getExt()).requested(org.openrewrite.maven.tree.Dependency.builder().scope(methodInvocation.getSimpleName()).type(dependency.getExt()).gav(new GroupArtifactVersion(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion())).classifier(dependency.getClassifier()).build()).build();
                    return new GradleDependency(cursor, Matcher.withRequested(resolvedDependency, dependency));
                }
            }
            return null;
        }

        private static ResolvedDependency withRequested(ResolvedDependency resolved, Dependency requested) {
            return resolved.withRequested(resolved.getRequested().withGav(requested.getGav()));
        }

        private static @Nullable GradleDependencyConfiguration getConfiguration(@Nullable GradleProject gradleProject, J.MethodInvocation methodInvocation) {
            if (gradleProject == null) {
                return null;
            }
            String methodName = methodInvocation.getSimpleName();
            if (methodName.equals("classpath")) {
                return gradleProject.getBuildscript().getConfiguration(methodName);
            }
            return gradleProject.getConfiguration(methodName);
        }

        private boolean withinBlock(Cursor cursor, String name) {
            for (Cursor parentCursor = cursor.getParent(); parentCursor != null; parentCursor = parentCursor.getParent()) {
                J.MethodInvocation m;
                if (!(parentCursor.getValue() instanceof J.MethodInvocation) || !(m = (J.MethodInvocation)parentCursor.getValue()).getSimpleName().equals(name)) continue;
                return true;
            }
            return false;
        }

        private boolean withinDependenciesBlock(Cursor cursor) {
            return this.withinBlock(cursor, "dependencies");
        }

        private boolean withinDependencyConstraintsBlock(Cursor cursor) {
            return this.withinBlock(cursor, "constraints") && this.withinDependenciesBlock(cursor);
        }

        private @Nullable Dependency parseDependency(List<Expression> arguments) {
            Expression argument = arguments.get(0);
            if (argument instanceof J.Literal) {
                return DependencyStringNotationConverter.parse((String)((J.Literal)argument).getValue());
            }
            if (argument instanceof G.GString) {
                G.GString gstring = (G.GString)argument;
                List strings = gstring.getStrings();
                if (strings.size() >= 2 && strings.get(0) instanceof J.Literal && ((J.Literal)strings.get(0)).getValue() != null) {
                    return DependencyStringNotationConverter.parse((String)((J.Literal)strings.get(0)).getValue());
                }
            } else {
                K.StringTemplate template;
                List strings;
                if (argument instanceof G.MapLiteral) {
                    List<Expression> mapEntryExpressions = ((G.MapLiteral)argument).getElements().stream().map(e -> e).collect(Collectors.toList());
                    return Matcher.getMapEntriesDependency(mapEntryExpressions);
                }
                if (argument instanceof G.MapEntry) {
                    return Matcher.getMapEntriesDependency(arguments);
                }
                if (argument instanceof J.Assignment) {
                    String group = null;
                    String artifact = null;
                    for (Expression e2 : arguments) {
                        J.Assignment arg;
                        if (!(e2 instanceof J.Assignment) || !((arg = (J.Assignment)e2).getVariable() instanceof J.Identifier) || !(arg.getAssignment() instanceof J.Literal)) continue;
                        J.Identifier identifier = (J.Identifier)arg.getVariable();
                        J.Literal value = (J.Literal)arg.getAssignment();
                        if (!(value.getValue() instanceof String)) continue;
                        String name = identifier.getSimpleName();
                        if ("group".equals(name)) {
                            group = (String)value.getValue();
                            continue;
                        }
                        if (!"name".equals(name)) continue;
                        artifact = (String)value.getValue();
                    }
                    if (group == null || artifact == null) {
                        return null;
                    }
                    return new Dependency(group, artifact, null, null, null);
                }
                if (argument instanceof K.StringTemplate && (strings = (template = (K.StringTemplate)argument).getStrings()).size() >= 2 && strings.get(0) instanceof J.Literal && ((J.Literal)strings.get(0)).getValue() != null) {
                    return DependencyStringNotationConverter.parse((String)((J.Literal)strings.get(0)).getValue());
                }
            }
            return null;
        }

        private static @Nullable Dependency getMapEntriesDependency(List<Expression> arguments) {
            String group = null;
            String artifact = null;
            for (Expression e : arguments) {
                G.MapEntry arg;
                if (!(e instanceof G.MapEntry) || !((arg = (G.MapEntry)e).getKey() instanceof J.Literal) || !(arg.getValue() instanceof J.Literal)) continue;
                J.Literal key = (J.Literal)arg.getKey();
                J.Literal value = (J.Literal)arg.getValue();
                if (!(key.getValue() instanceof String) || !(value.getValue() instanceof String)) continue;
                String keyValue = (String)key.getValue();
                if ("group".equals(keyValue)) {
                    group = (String)value.getValue();
                    continue;
                }
                if (!"name".equals(keyValue)) continue;
                artifact = (String)value.getValue();
            }
            if (group == null || artifact == null) {
                return null;
            }
            return new Dependency(group, artifact, null, null, null);
        }
    }
}

