/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.gradle.DependencyVersionSelector;
import org.openrewrite.gradle.internal.ChangeStringLiteral;
import org.openrewrite.gradle.internal.Dependency;
import org.openrewrite.gradle.internal.DependencyStringNotationConverter;
import org.openrewrite.gradle.marker.GradleDependencyConfiguration;
import org.openrewrite.gradle.marker.GradleProject;
import org.openrewrite.gradle.search.FindGradleProject;
import org.openrewrite.gradle.trait.GradleDependency;
import org.openrewrite.groovy.tree.G;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.kotlin.tree.K;
import org.openrewrite.marker.Marker;
import org.openrewrite.maven.MavenDownloadingException;
import org.openrewrite.maven.table.MavenMetadataFailures;
import org.openrewrite.maven.tree.GroupArtifact;
import org.openrewrite.maven.tree.GroupArtifactVersion;
import org.openrewrite.maven.tree.ResolvedDependency;
import org.openrewrite.maven.tree.ResolvedGroupArtifactVersion;
import org.openrewrite.semver.DependencyMatcher;
import org.openrewrite.semver.Semver;

public final class ChangeDependency
extends Recipe {
    private final transient Map<org.openrewrite.maven.tree.Dependency, org.openrewrite.maven.tree.Dependency> updatedRequested = new HashMap<org.openrewrite.maven.tree.Dependency, org.openrewrite.maven.tree.Dependency>();
    private final transient Map<ResolvedDependency, ResolvedDependency> updatedResolved = new HashMap<ResolvedDependency, ResolvedDependency>();
    private final transient MavenMetadataFailures metadataFailures = new MavenMetadataFailures((Recipe)this);
    @Option(displayName="Old groupId", description="The old groupId to replace. The groupId is the first part of a dependency coordinate 'com.google.guava:guava:VERSION'. Supports glob expressions.", example="org.openrewrite.recipe")
    private final String oldGroupId;
    @Option(displayName="Old artifactId", description="The old artifactId to replace. The artifactId is the second part of a dependency coordinate 'com.google.guava:guava:VERSION'. Supports glob expressions.", example="rewrite-testing-frameworks")
    private final String oldArtifactId;
    @Option(displayName="New groupId", description="The new groupId to use. Defaults to the existing group id.", example="corp.internal.openrewrite.recipe", required=false)
    private final @Nullable String newGroupId;
    @Option(displayName="New artifactId", description="The new artifactId to use. Defaults to the existing artifact id.", example="rewrite-testing-frameworks", required=false)
    private final @Nullable String newArtifactId;
    @Option(displayName="New version", description="An exact version number or node-style semver selector used to select the version number. You can also use `latest.release` for the latest available version and `latest.patch` if the current version is a valid semantic version. For more details, you can look at the documentation page of [version selectors](https://docs.openrewrite.org/reference/dependency-version-selectors).", example="29.X", required=false)
    private final @Nullable String newVersion;
    @Option(displayName="Version pattern", description="Allows version selection to be extended beyond the original Node Semver semantics. So for example,Setting 'version' to \"25-29\" can be paired with a metadata pattern of \"-jre\" to select Guava 29.0-jre", example="-jre", required=false)
    private final @Nullable String versionPattern;
    @Option(displayName="Override managed version", description="If the old dependency has a managed version, this flag can be used to explicitly set the version on the new dependency. WARNING: No check is done on the NEW dependency to verify if it is managed, it relies on whether the OLD dependency had a managed version. The default for this flag is `false`.", required=false)
    private final @Nullable Boolean overrideManagedVersion;

    public String getDisplayName() {
        return "Change Gradle dependency";
    }

    public String getInstanceNameSuffix() {
        return String.format("`%s:%s`", this.oldGroupId, this.oldArtifactId);
    }

    public String getDescription() {
        return "Change a Gradle dependency coordinates. The `newGroupId` or `newArtifactId` **MUST** be different from before.";
    }

    public Validated<Object> validate() {
        Validated validated = super.validate();
        if (this.newVersion != null) {
            validated = validated.and(Semver.validate((String)this.newVersion, (String)this.versionPattern));
        }
        validated = validated.and(Validated.required((String)"newGroupId", (Object)this.newGroupId).or(Validated.required((String)"newArtifactId", (Object)this.newArtifactId)));
        validated = validated.and(Validated.test((String)"coordinates", (String)"newGroupId OR newArtifactId must be different from before", (Object)((Object)this), r -> {
            boolean sameGroupId = StringUtils.isBlank((String)r.newGroupId) || Objects.equals(r.oldGroupId, r.newGroupId);
            boolean sameArtifactId = StringUtils.isBlank((String)r.newArtifactId) || Objects.equals(r.oldArtifactId, r.newArtifactId);
            return !sameGroupId || !sameArtifactId;
        }));
        return validated;
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check(new FindGradleProject(FindGradleProject.SearchCriteria.Marker).getVisitor(), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){
            final DependencyMatcher depMatcher;
            GradleProject gradleProject;
            {
                this.depMatcher = Objects.requireNonNull((DependencyMatcher)DependencyMatcher.build((String)(ChangeDependency.this.oldGroupId + ":" + ChangeDependency.this.oldArtifactId)).getValue());
            }

            public boolean isAcceptable(SourceFile sourceFile, ExecutionContext ctx) {
                return sourceFile instanceof G.CompilationUnit || sourceFile instanceof K.CompilationUnit;
            }

            public @Nullable J visit(@Nullable Tree tree, ExecutionContext ctx) {
                if (tree instanceof JavaSourceFile) {
                    JavaSourceFile sourceFile = (JavaSourceFile)tree;
                    Optional maybeGp = sourceFile.getMarkers().findFirst(GradleProject.class);
                    if (!maybeGp.isPresent()) {
                        return sourceFile;
                    }
                    this.gradleProject = (GradleProject)maybeGp.get();
                    if ((sourceFile = (JavaSourceFile)super.visit((Tree)sourceFile, (Object)ctx)) != tree) {
                        sourceFile = (JavaSourceFile)sourceFile.withMarkers(sourceFile.getMarkers().setByType((Marker)this.updateGradleModel(this.gradleProject)));
                    }
                    return sourceFile;
                }
                return (J)super.visit(tree, (Object)ctx);
            }

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation m = super.visitMethodInvocation(method, (Object)ctx);
                GradleDependency.Matcher gradleDependencyMatcher = new GradleDependency.Matcher().groupId(ChangeDependency.this.oldGroupId).artifactId(ChangeDependency.this.oldArtifactId);
                if (!gradleDependencyMatcher.get(this.getCursor()).isPresent()) {
                    return m;
                }
                List depArgs = m.getArguments();
                if (depArgs.get(0) instanceof J.Literal || depArgs.get(0) instanceof G.GString || depArgs.get(0) instanceof G.MapEntry || depArgs.get(0) instanceof G.MapLiteral || depArgs.get(0) instanceof J.Assignment || depArgs.get(0) instanceof K.StringTemplate) {
                    m = this.updateDependency(m, ctx);
                } else if (depArgs.get(0) instanceof J.MethodInvocation && (((J.MethodInvocation)depArgs.get(0)).getSimpleName().equals("platform") || ((J.MethodInvocation)depArgs.get(0)).getSimpleName().equals("enforcedPlatform"))) {
                    m = m.withArguments(ListUtils.mapFirst((List)depArgs, platform -> this.updateDependency((J.MethodInvocation)platform, ctx)));
                }
                return m;
            }

            private J.MethodInvocation updateDependency(J.MethodInvocation m, ExecutionContext ctx) {
                J.Literal literal;
                Dependency original;
                K.StringTemplate template;
                List strings;
                List depArgs = m.getArguments();
                if (depArgs.get(0) instanceof J.Literal) {
                    Dependency original2;
                    String gav = (String)((J.Literal)depArgs.get(0)).getValue();
                    if (gav != null && (original2 = DependencyStringNotationConverter.parse(gav)) != null) {
                        Dependency updated = original2;
                        if (!StringUtils.isBlank((String)ChangeDependency.this.newGroupId) && !updated.getGroupId().equals(ChangeDependency.this.newGroupId)) {
                            updated = updated.withGroupId(ChangeDependency.this.newGroupId);
                        }
                        if (!StringUtils.isBlank((String)ChangeDependency.this.newArtifactId) && !updated.getArtifactId().equals(ChangeDependency.this.newArtifactId)) {
                            updated = updated.withArtifactId(ChangeDependency.this.newArtifactId);
                        }
                        if (!(StringUtils.isBlank((String)ChangeDependency.this.newVersion) || StringUtils.isBlank((String)original2.getVersion()) && !Boolean.TRUE.equals(ChangeDependency.this.overrideManagedVersion))) {
                            String resolvedVersion;
                            try {
                                resolvedVersion = new DependencyVersionSelector(ChangeDependency.this.metadataFailures, this.gradleProject, null).select(new GroupArtifact(updated.getGroupId(), updated.getArtifactId()), m.getSimpleName(), ChangeDependency.this.newVersion, ChangeDependency.this.versionPattern, ctx);
                            }
                            catch (MavenDownloadingException e) {
                                return (J.MethodInvocation)e.warn((Tree)m);
                            }
                            if (resolvedVersion != null && !resolvedVersion.equals(updated.getVersion())) {
                                updated = updated.withVersion(resolvedVersion);
                            }
                        }
                        if (original2 != updated) {
                            String replacement = updated.toStringNotation();
                            m = m.withArguments(ListUtils.mapFirst((List)m.getArguments(), arg -> ChangeStringLiteral.withStringValue((J.Literal)arg, replacement)));
                        }
                    }
                } else if (m.getArguments().get(0) instanceof G.GString) {
                    J.Literal literal2;
                    Dependency original3;
                    G.GString gstring = (G.GString)depArgs.get(0);
                    List strings2 = gstring.getStrings();
                    if (strings2.size() >= 2 && strings2.get(0) instanceof J.Literal && ((J.Literal)strings2.get(0)).getValue() != null && (original3 = DependencyStringNotationConverter.parse((String)Objects.requireNonNull((literal2 = (J.Literal)strings2.get(0)).getValue()))) != null) {
                        Dependency updated = original3;
                        if (!StringUtils.isBlank((String)ChangeDependency.this.newGroupId) && !updated.getGroupId().equals(ChangeDependency.this.newGroupId)) {
                            updated = updated.withGroupId(ChangeDependency.this.newGroupId);
                        }
                        if (!StringUtils.isBlank((String)ChangeDependency.this.newArtifactId) && !updated.getArtifactId().equals(ChangeDependency.this.newArtifactId)) {
                            updated = updated.withArtifactId(ChangeDependency.this.newArtifactId);
                        }
                        if (!StringUtils.isBlank((String)ChangeDependency.this.newVersion)) {
                            String resolvedVersion;
                            try {
                                resolvedVersion = new DependencyVersionSelector(ChangeDependency.this.metadataFailures, this.gradleProject, null).select(new GroupArtifact(updated.getGroupId(), updated.getArtifactId()), m.getSimpleName(), ChangeDependency.this.newVersion, ChangeDependency.this.versionPattern, ctx);
                            }
                            catch (MavenDownloadingException e) {
                                return (J.MethodInvocation)e.warn((Tree)m);
                            }
                            if (resolvedVersion != null && !resolvedVersion.equals(updated.getVersion())) {
                                updated = updated.withVersion(resolvedVersion);
                            }
                        }
                        if (original3 != updated) {
                            String replacement = updated.toStringNotation();
                            J.Literal newLiteral = literal2.withValue((Object)replacement).withValueSource(gstring.getDelimiter() + replacement + gstring.getDelimiter());
                            m = m.withArguments(Collections.singletonList(newLiteral));
                        }
                    }
                } else if (m.getArguments().get(0) instanceof G.MapEntry) {
                    G.MapEntry groupEntry = null;
                    G.MapEntry artifactEntry = null;
                    G.MapEntry versionEntry = null;
                    String groupId = null;
                    String artifactId = null;
                    String version = null;
                    for (Expression e : depArgs) {
                        G.MapEntry arg2;
                        if (!(e instanceof G.MapEntry) || !((arg2 = (G.MapEntry)e).getKey() instanceof J.Literal) || !(arg2.getValue() instanceof J.Literal)) continue;
                        J.Literal key = (J.Literal)arg2.getKey();
                        J.Literal value = (J.Literal)arg2.getValue();
                        if (!(key.getValue() instanceof String) || !(value.getValue() instanceof String)) continue;
                        String keyValue = (String)key.getValue();
                        String valueValue = (String)value.getValue();
                        switch (keyValue) {
                            case "group": {
                                groupEntry = arg2;
                                groupId = valueValue;
                                break;
                            }
                            case "name": {
                                artifactEntry = arg2;
                                artifactId = valueValue;
                                break;
                            }
                            case "version": {
                                versionEntry = arg2;
                                version = valueValue;
                            }
                        }
                    }
                    if (groupId == null || artifactId == null) {
                        return m;
                    }
                    if (!this.depMatcher.matches(groupId, artifactId)) {
                        return m;
                    }
                    String updatedGroupId = groupId;
                    if (!StringUtils.isBlank((String)ChangeDependency.this.newGroupId) && !updatedGroupId.equals(ChangeDependency.this.newGroupId)) {
                        updatedGroupId = ChangeDependency.this.newGroupId;
                    }
                    String updatedArtifactId = artifactId;
                    if (!StringUtils.isBlank((String)ChangeDependency.this.newArtifactId) && !updatedArtifactId.equals(ChangeDependency.this.newArtifactId)) {
                        updatedArtifactId = ChangeDependency.this.newArtifactId;
                    }
                    String updatedVersion = version;
                    if (!(StringUtils.isBlank((String)ChangeDependency.this.newVersion) || StringUtils.isBlank(version) && !Boolean.TRUE.equals(ChangeDependency.this.overrideManagedVersion))) {
                        String resolvedVersion;
                        try {
                            resolvedVersion = new DependencyVersionSelector(ChangeDependency.this.metadataFailures, this.gradleProject, null).select(new GroupArtifact(updatedGroupId, updatedArtifactId), m.getSimpleName(), ChangeDependency.this.newVersion, ChangeDependency.this.versionPattern, ctx);
                        }
                        catch (MavenDownloadingException e) {
                            return (J.MethodInvocation)e.warn((Tree)m);
                        }
                        if (resolvedVersion != null && !resolvedVersion.equals(updatedVersion)) {
                            updatedVersion = resolvedVersion;
                        }
                    }
                    if (!updatedGroupId.equals(groupId) || !updatedArtifactId.equals(artifactId) || updatedVersion != null && !updatedVersion.equals(version)) {
                        G.MapEntry finalGroup = groupEntry;
                        String finalGroupIdValue = updatedGroupId;
                        G.MapEntry finalArtifact = artifactEntry;
                        String finalArtifactIdValue = updatedArtifactId;
                        G.MapEntry finalVersion = versionEntry;
                        String finalVersionValue = updatedVersion;
                        m = m.withArguments(ListUtils.map((List)m.getArguments(), arg -> {
                            if (arg == finalGroup) {
                                return finalGroup.withValue((Expression)ChangeStringLiteral.withStringValue((J.Literal)finalGroup.getValue(), finalGroupIdValue));
                            }
                            if (arg == finalArtifact) {
                                return finalArtifact.withValue((Expression)ChangeStringLiteral.withStringValue((J.Literal)finalArtifact.getValue(), finalArtifactIdValue));
                            }
                            if (arg == finalVersion) {
                                return finalVersion.withValue((Expression)ChangeStringLiteral.withStringValue((J.Literal)finalVersion.getValue(), finalVersionValue));
                            }
                            return arg;
                        }));
                    }
                } else if (m.getArguments().get(0) instanceof G.MapLiteral) {
                    G.MapLiteral map = (G.MapLiteral)depArgs.get(0);
                    G.MapEntry groupEntry = null;
                    G.MapEntry artifactEntry = null;
                    G.MapEntry versionEntry = null;
                    String groupId = null;
                    String artifactId = null;
                    String version = null;
                    for (G.MapEntry arg3 : map.getElements()) {
                        if (!(arg3.getKey() instanceof J.Literal) || !(arg3.getValue() instanceof J.Literal)) continue;
                        J.Literal key = (J.Literal)arg3.getKey();
                        J.Literal value = (J.Literal)arg3.getValue();
                        if (!(key.getValue() instanceof String) || !(value.getValue() instanceof String)) continue;
                        String keyValue = (String)key.getValue();
                        String valueValue = (String)value.getValue();
                        switch (keyValue) {
                            case "group": {
                                groupEntry = arg3;
                                groupId = valueValue;
                                break;
                            }
                            case "name": {
                                artifactEntry = arg3;
                                artifactId = valueValue;
                                break;
                            }
                            case "version": {
                                versionEntry = arg3;
                                version = valueValue;
                            }
                        }
                    }
                    if (groupId == null || artifactId == null) {
                        return m;
                    }
                    if (!this.depMatcher.matches(groupId, artifactId)) {
                        return m;
                    }
                    String updatedGroupId = groupId;
                    if (!StringUtils.isBlank((String)ChangeDependency.this.newGroupId) && !updatedGroupId.equals(ChangeDependency.this.newGroupId)) {
                        updatedGroupId = ChangeDependency.this.newGroupId;
                    }
                    String updatedArtifactId = artifactId;
                    if (!StringUtils.isBlank((String)ChangeDependency.this.newArtifactId) && !updatedArtifactId.equals(ChangeDependency.this.newArtifactId)) {
                        updatedArtifactId = ChangeDependency.this.newArtifactId;
                    }
                    String updatedVersion = version;
                    if (!(StringUtils.isBlank((String)ChangeDependency.this.newVersion) || StringUtils.isBlank(version) && !Boolean.TRUE.equals(ChangeDependency.this.overrideManagedVersion))) {
                        String resolvedVersion;
                        try {
                            resolvedVersion = new DependencyVersionSelector(ChangeDependency.this.metadataFailures, this.gradleProject, null).select(new GroupArtifact(updatedGroupId, updatedArtifactId), m.getSimpleName(), ChangeDependency.this.newVersion, ChangeDependency.this.versionPattern, ctx);
                        }
                        catch (MavenDownloadingException e) {
                            return (J.MethodInvocation)e.warn((Tree)m);
                        }
                        if (resolvedVersion != null && !resolvedVersion.equals(updatedVersion)) {
                            updatedVersion = resolvedVersion;
                        }
                    }
                    if (!updatedGroupId.equals(groupId) || !updatedArtifactId.equals(artifactId) || updatedVersion != null && !updatedVersion.equals(version)) {
                        G.MapEntry finalGroup = groupEntry;
                        String finalGroupIdValue = updatedGroupId;
                        G.MapEntry finalArtifact = artifactEntry;
                        String finalArtifactIdValue = updatedArtifactId;
                        G.MapEntry finalVersion = versionEntry;
                        String finalVersionValue = updatedVersion;
                        m = m.withArguments(ListUtils.mapFirst((List)m.getArguments(), arg -> {
                            G.MapLiteral mapLiteral = (G.MapLiteral)arg;
                            return mapLiteral.withElements(ListUtils.map((List)mapLiteral.getElements(), e -> {
                                if (e == finalGroup) {
                                    return finalGroup.withValue((Expression)ChangeStringLiteral.withStringValue((J.Literal)finalGroup.getValue(), finalGroupIdValue));
                                }
                                if (e == finalArtifact) {
                                    return finalArtifact.withValue((Expression)ChangeStringLiteral.withStringValue((J.Literal)finalArtifact.getValue(), finalArtifactIdValue));
                                }
                                if (e == finalVersion) {
                                    return finalVersion.withValue((Expression)ChangeStringLiteral.withStringValue((J.Literal)finalVersion.getValue(), finalVersionValue));
                                }
                                return e;
                            }));
                        }));
                    }
                } else if (m.getArguments().get(0) instanceof J.Assignment) {
                    J.Assignment groupAssignment = null;
                    J.Assignment artifactAssignment = null;
                    J.Assignment versionAssignment = null;
                    String groupId = null;
                    String artifactId = null;
                    String version = null;
                    for (Expression e : depArgs) {
                        J.Assignment arg4;
                        if (!(e instanceof J.Assignment) || !((arg4 = (J.Assignment)e).getVariable() instanceof J.Identifier) || !(arg4.getAssignment() instanceof J.Literal)) continue;
                        J.Identifier identifier = (J.Identifier)arg4.getVariable();
                        J.Literal assignment = (J.Literal)arg4.getAssignment();
                        if (!(assignment.getValue() instanceof String)) continue;
                        String valueValue = (String)assignment.getValue();
                        switch (identifier.getSimpleName()) {
                            case "group": {
                                groupAssignment = arg4;
                                groupId = valueValue;
                                break;
                            }
                            case "name": {
                                artifactAssignment = arg4;
                                artifactId = valueValue;
                                break;
                            }
                            case "version": {
                                versionAssignment = arg4;
                                version = valueValue;
                            }
                        }
                    }
                    if (groupId == null || artifactId == null) {
                        return m;
                    }
                    if (!this.depMatcher.matches(groupId, artifactId)) {
                        return m;
                    }
                    String updatedGroupId = groupId;
                    if (!StringUtils.isBlank((String)ChangeDependency.this.newGroupId) && !updatedGroupId.equals(ChangeDependency.this.newGroupId)) {
                        updatedGroupId = ChangeDependency.this.newGroupId;
                    }
                    String updatedArtifactId = artifactId;
                    if (!StringUtils.isBlank((String)ChangeDependency.this.newArtifactId) && !updatedArtifactId.equals(ChangeDependency.this.newArtifactId)) {
                        updatedArtifactId = ChangeDependency.this.newArtifactId;
                    }
                    String updatedVersion = version;
                    if (!(StringUtils.isBlank((String)ChangeDependency.this.newVersion) || StringUtils.isBlank(version) && !Boolean.TRUE.equals(ChangeDependency.this.overrideManagedVersion))) {
                        String resolvedVersion;
                        try {
                            resolvedVersion = new DependencyVersionSelector(ChangeDependency.this.metadataFailures, this.gradleProject, null).select(new GroupArtifact(updatedGroupId, updatedArtifactId), m.getSimpleName(), ChangeDependency.this.newVersion, ChangeDependency.this.versionPattern, ctx);
                        }
                        catch (MavenDownloadingException e) {
                            return (J.MethodInvocation)e.warn((Tree)m);
                        }
                        if (resolvedVersion != null && !resolvedVersion.equals(updatedVersion)) {
                            updatedVersion = resolvedVersion;
                        }
                    }
                    if (!updatedGroupId.equals(groupId) || !updatedArtifactId.equals(artifactId) || updatedVersion != null && !updatedVersion.equals(version)) {
                        J.Assignment finalGroup = groupAssignment;
                        String finalGroupIdValue = updatedGroupId;
                        J.Assignment finalArtifact = artifactAssignment;
                        String finalArtifactIdValue = updatedArtifactId;
                        J.Assignment finalVersion = versionAssignment;
                        String finalVersionValue = updatedVersion;
                        m = m.withArguments(ListUtils.map((List)m.getArguments(), arg -> {
                            if (arg == finalGroup) {
                                return finalGroup.withAssignment((Expression)ChangeStringLiteral.withStringValue((J.Literal)finalGroup.getAssignment(), finalGroupIdValue));
                            }
                            if (arg == finalArtifact) {
                                return finalArtifact.withAssignment((Expression)ChangeStringLiteral.withStringValue((J.Literal)finalArtifact.getAssignment(), finalArtifactIdValue));
                            }
                            if (arg == finalVersion) {
                                return finalVersion.withAssignment((Expression)ChangeStringLiteral.withStringValue((J.Literal)finalVersion.getAssignment(), finalVersionValue));
                            }
                            return arg;
                        }));
                    }
                } else if (depArgs.get(0) instanceof K.StringTemplate && (strings = (template = (K.StringTemplate)depArgs.get(0)).getStrings()).size() >= 2 && strings.get(0) instanceof J.Literal && ((J.Literal)strings.get(0)).getValue() != null && (original = DependencyStringNotationConverter.parse((String)Objects.requireNonNull((literal = (J.Literal)strings.get(0)).getValue()))) != null) {
                    Dependency updated = original;
                    if (!StringUtils.isBlank((String)ChangeDependency.this.newGroupId) && !updated.getGroupId().equals(ChangeDependency.this.newGroupId)) {
                        updated = updated.withGroupId(ChangeDependency.this.newGroupId);
                    }
                    if (!StringUtils.isBlank((String)ChangeDependency.this.newArtifactId) && !updated.getArtifactId().equals(ChangeDependency.this.newArtifactId)) {
                        updated = updated.withArtifactId(ChangeDependency.this.newArtifactId);
                    }
                    if (!StringUtils.isBlank((String)ChangeDependency.this.newVersion)) {
                        String resolvedVersion;
                        try {
                            resolvedVersion = new DependencyVersionSelector(ChangeDependency.this.metadataFailures, this.gradleProject, null).select(new GroupArtifact(updated.getGroupId(), updated.getArtifactId()), m.getSimpleName(), ChangeDependency.this.newVersion, ChangeDependency.this.versionPattern, ctx);
                        }
                        catch (MavenDownloadingException e) {
                            return (J.MethodInvocation)e.warn((Tree)m);
                        }
                        if (resolvedVersion != null && !resolvedVersion.equals(updated.getVersion())) {
                            updated = updated.withVersion(resolvedVersion);
                        }
                    }
                    if (original != updated) {
                        String replacement = updated.toStringNotation();
                        J.Literal newLiteral = literal.withValue((Object)replacement).withValueSource(template.getDelimiter() + replacement + template.getDelimiter());
                        m = m.withArguments(Collections.singletonList(newLiteral));
                    }
                }
                return m;
            }

            private GradleProject updateGradleModel(GradleProject gp) {
                Map<String, GradleDependencyConfiguration> nameToConfiguration = gp.getNameToConfiguration();
                HashMap<String, GradleDependencyConfiguration> newNameToConfiguration = new HashMap<String, GradleDependencyConfiguration>(nameToConfiguration.size());
                boolean anyChanged = false;
                Iterator<GradleDependencyConfiguration> iterator = nameToConfiguration.values().iterator();
                while (iterator.hasNext()) {
                    GradleDependencyConfiguration gdc;
                    GradleDependencyConfiguration newGdc = gdc = iterator.next();
                    newGdc = newGdc.withRequested(ListUtils.map(gdc.getRequested(), requested -> {
                        assert (requested != null);
                        if (this.depMatcher.matches(requested.getGroupId(), requested.getArtifactId())) {
                            requested = ChangeDependency.this.updatedRequested.computeIfAbsent(requested, r -> {
                                GroupArtifactVersion gav = r.getGav();
                                if (ChangeDependency.this.newGroupId != null) {
                                    gav = gav.withGroupId(ChangeDependency.this.newGroupId);
                                }
                                if (ChangeDependency.this.newArtifactId != null) {
                                    gav = gav.withArtifactId(ChangeDependency.this.newArtifactId);
                                }
                                if (gav != r.getGav()) {
                                    r = r.withGav(gav);
                                }
                                return r;
                            });
                        }
                        return requested;
                    }));
                    anyChanged |= (newGdc = newGdc.withDirectResolved(ListUtils.map(gdc.getDirectResolved(), resolved -> {
                        assert (resolved != null);
                        if (this.depMatcher.matches(resolved.getGroupId(), resolved.getArtifactId())) {
                            resolved = ChangeDependency.this.updatedResolved.computeIfAbsent(resolved, r -> {
                                ResolvedGroupArtifactVersion gav = r.getGav();
                                if (ChangeDependency.this.newGroupId != null) {
                                    gav = gav.withGroupId(ChangeDependency.this.newGroupId);
                                }
                                if (ChangeDependency.this.newArtifactId != null) {
                                    gav = gav.withArtifactId(ChangeDependency.this.newArtifactId);
                                }
                                if (gav != r.getGav()) {
                                    r = r.withGav(gav);
                                }
                                return r;
                            });
                        }
                        return resolved;
                    }))) != gdc;
                    newNameToConfiguration.put(newGdc.getName(), newGdc);
                }
                if (anyChanged) {
                    gp = gp.withNameToConfiguration(newNameToConfiguration);
                }
                return gp;
            }
        });
    }

    @Generated
    public Map<org.openrewrite.maven.tree.Dependency, org.openrewrite.maven.tree.Dependency> getUpdatedRequested() {
        return this.updatedRequested;
    }

    @Generated
    public Map<ResolvedDependency, ResolvedDependency> getUpdatedResolved() {
        return this.updatedResolved;
    }

    @Generated
    public MavenMetadataFailures getMetadataFailures() {
        return this.metadataFailures;
    }

    @Generated
    public String getOldGroupId() {
        return this.oldGroupId;
    }

    @Generated
    public String getOldArtifactId() {
        return this.oldArtifactId;
    }

    @Generated
    public @Nullable String getNewGroupId() {
        return this.newGroupId;
    }

    @Generated
    public @Nullable String getNewArtifactId() {
        return this.newArtifactId;
    }

    @Generated
    public @Nullable String getNewVersion() {
        return this.newVersion;
    }

    @Generated
    public @Nullable String getVersionPattern() {
        return this.versionPattern;
    }

    @Generated
    public @Nullable Boolean getOverrideManagedVersion() {
        return this.overrideManagedVersion;
    }

    @NonNull
    @Generated
    public String toString() {
        return "ChangeDependency(updatedRequested=" + this.getUpdatedRequested() + ", updatedResolved=" + this.getUpdatedResolved() + ", metadataFailures=" + this.getMetadataFailures() + ", oldGroupId=" + this.getOldGroupId() + ", oldArtifactId=" + this.getOldArtifactId() + ", newGroupId=" + this.getNewGroupId() + ", newArtifactId=" + this.getNewArtifactId() + ", newVersion=" + this.getNewVersion() + ", versionPattern=" + this.getVersionPattern() + ", overrideManagedVersion=" + this.getOverrideManagedVersion() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangeDependency)) {
            return false;
        }
        ChangeDependency other = (ChangeDependency)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$overrideManagedVersion = this.getOverrideManagedVersion();
        Boolean other$overrideManagedVersion = other.getOverrideManagedVersion();
        if (this$overrideManagedVersion == null ? other$overrideManagedVersion != null : !((Object)this$overrideManagedVersion).equals(other$overrideManagedVersion)) {
            return false;
        }
        String this$oldGroupId = this.getOldGroupId();
        String other$oldGroupId = other.getOldGroupId();
        if (this$oldGroupId == null ? other$oldGroupId != null : !this$oldGroupId.equals(other$oldGroupId)) {
            return false;
        }
        String this$oldArtifactId = this.getOldArtifactId();
        String other$oldArtifactId = other.getOldArtifactId();
        if (this$oldArtifactId == null ? other$oldArtifactId != null : !this$oldArtifactId.equals(other$oldArtifactId)) {
            return false;
        }
        String this$newGroupId = this.getNewGroupId();
        String other$newGroupId = other.getNewGroupId();
        if (this$newGroupId == null ? other$newGroupId != null : !this$newGroupId.equals(other$newGroupId)) {
            return false;
        }
        String this$newArtifactId = this.getNewArtifactId();
        String other$newArtifactId = other.getNewArtifactId();
        if (this$newArtifactId == null ? other$newArtifactId != null : !this$newArtifactId.equals(other$newArtifactId)) {
            return false;
        }
        String this$newVersion = this.getNewVersion();
        String other$newVersion = other.getNewVersion();
        if (this$newVersion == null ? other$newVersion != null : !this$newVersion.equals(other$newVersion)) {
            return false;
        }
        String this$versionPattern = this.getVersionPattern();
        String other$versionPattern = other.getVersionPattern();
        return !(this$versionPattern == null ? other$versionPattern != null : !this$versionPattern.equals(other$versionPattern));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof ChangeDependency;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $overrideManagedVersion = this.getOverrideManagedVersion();
        result = result * 59 + ($overrideManagedVersion == null ? 43 : ((Object)$overrideManagedVersion).hashCode());
        String $oldGroupId = this.getOldGroupId();
        result = result * 59 + ($oldGroupId == null ? 43 : $oldGroupId.hashCode());
        String $oldArtifactId = this.getOldArtifactId();
        result = result * 59 + ($oldArtifactId == null ? 43 : $oldArtifactId.hashCode());
        String $newGroupId = this.getNewGroupId();
        result = result * 59 + ($newGroupId == null ? 43 : $newGroupId.hashCode());
        String $newArtifactId = this.getNewArtifactId();
        result = result * 59 + ($newArtifactId == null ? 43 : $newArtifactId.hashCode());
        String $newVersion = this.getNewVersion();
        result = result * 59 + ($newVersion == null ? 43 : $newVersion.hashCode());
        String $versionPattern = this.getVersionPattern();
        result = result * 59 + ($versionPattern == null ? 43 : $versionPattern.hashCode());
        return result;
    }

    @Generated
    public ChangeDependency(String oldGroupId, String oldArtifactId, @Nullable String newGroupId, @Nullable String newArtifactId, @Nullable String newVersion, @Nullable String versionPattern, @Nullable Boolean overrideManagedVersion) {
        this.oldGroupId = oldGroupId;
        this.oldArtifactId = oldArtifactId;
        this.newGroupId = newGroupId;
        this.newArtifactId = newArtifactId;
        this.newVersion = newVersion;
        this.versionPattern = versionPattern;
        this.overrideManagedVersion = overrideManagedVersion;
    }
}

