/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.gradle.marker.GradleDependencyConfiguration;
import org.openrewrite.gradle.marker.GradleProject;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.marker.Marker;
import org.openrewrite.maven.tree.GroupArtifactVersion;
import org.openrewrite.maven.tree.ResolvedDependency;
import org.openrewrite.text.PlainText;
import org.openrewrite.text.PlainTextVisitor;

public final class UpdateDependencyLock
extends PlainTextVisitor<ExecutionContext> {
    private final Set<GradleProject> modules;

    public boolean isAcceptable(SourceFile sourceFile, ExecutionContext executionContext) {
        return sourceFile instanceof PlainText && sourceFile.getSourcePath().endsWith("gradle.lockfile");
    }

    public @Nullable Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
        if (tree == null) {
            return null;
        }
        Optional gradleProject = tree.getMarkers().findFirst(GradleProject.class);
        if (!gradleProject.isPresent()) {
            return tree;
        }
        HashSet lockedConfigurations = new HashSet();
        HashMap<GroupArtifactVersion, SortedSet> lockedVersions = new HashMap<GroupArtifactVersion, SortedSet>();
        TreeSet<String> empty = new TreeSet<String>();
        ArrayList comments = new ArrayList();
        PlainText plainText = (PlainText)tree;
        String text = plainText.getText();
        if (StringUtils.isBlank((String)text)) {
            return plainText;
        }
        GradleProject project = (GradleProject)gradleProject.get();
        Arrays.stream(text.split("\n")).forEach(lock -> {
            if (UpdateDependencyLock.isComment(lock)) {
                comments.add(lock);
            } else {
                lockedConfigurations.addAll(this.parseLockedConfigurations((String)lock));
                this.parseLockedConfigurations((String)lock).forEach(lockedConf -> {
                    GroupArtifactVersion gav;
                    GradleDependencyConfiguration conf = project.getNameToConfiguration().get(lockedConf);
                    if (!(conf != null && conf.isCanBeResolved() || (gav = this.parseLockedArtifact((String)lock)) == null)) {
                        lockedVersions.computeIfAbsent(gav, k -> new TreeSet()).add(lockedConf);
                    }
                });
            }
        });
        project.getConfigurations().stream().filter(GradleDependencyConfiguration::isCanBeResolved).filter(configuration -> lockedConfigurations.contains(configuration.getName())).forEach(conf -> {
            List<ResolvedDependency> transitivelyResolvedDependencies = conf.getResolved();
            String configuration = conf.getName();
            if (transitivelyResolvedDependencies.isEmpty()) {
                empty.add(configuration);
            } else {
                boolean anyChanged = false;
                for (ResolvedDependency resolved : transitivelyResolvedDependencies) {
                    if (this.isDependencyOnAnotherModule(resolved, project)) continue;
                    lockedVersions.computeIfAbsent(resolved.getGav().asGroupArtifactVersion(), k -> new TreeSet()).add(configuration);
                    anyChanged = true;
                }
                if (!anyChanged) {
                    empty.add(configuration);
                }
            }
        });
        TreeSet locks = new TreeSet();
        lockedVersions.forEach((gav, confs) -> {
            String lock = this.asLock((GroupArtifactVersion)gav, (Set<String>)confs);
            if (lock != null) {
                locks.add(lock);
            }
        });
        StringBuilder sb = new StringBuilder();
        if (!comments.isEmpty()) {
            sb.append(String.join((CharSequence)"\n", comments));
        }
        if (!comments.isEmpty() && !locks.isEmpty()) {
            sb.append("\n");
        }
        if (!locks.isEmpty()) {
            sb.append(String.join((CharSequence)"\n", locks));
        }
        sb.append("\n").append(this.asLock(null, empty));
        if (text.endsWith("\n")) {
            sb.append("\n");
        }
        if (plainText.getText().contentEquals(sb)) {
            return tree;
        }
        return plainText.withText(sb.toString()).withMarkers(tree.getMarkers().setByType((Marker)project));
    }

    private @Nullable String asLock(@Nullable GroupArtifactVersion gav, @Nullable Set<String> configurations) {
        TreeSet sortedConfigurations = new TreeSet(configurations == null ? Collections.emptyList() : configurations);
        if (gav == null) {
            return "empty=" + String.join((CharSequence)",", sortedConfigurations);
        }
        if (sortedConfigurations.isEmpty()) {
            return null;
        }
        return String.format("%s=%s", gav, String.join((CharSequence)",", sortedConfigurations));
    }

    private static boolean isComment(String entry) {
        return entry.startsWith("# ");
    }

    private boolean isDependencyOnAnotherModule(ResolvedDependency resolved, GradleProject project) {
        if (Objects.equals(project.getGroup(), resolved.getGroupId())) {
            return this.modules.stream().anyMatch(module -> resolved.getArtifactId().equals(module.getName()));
        }
        return false;
    }

    private @Nullable GroupArtifactVersion parseLockedArtifact(String lock) {
        String[] parts = lock.split("=");
        if (parts.length != 2) {
            return null;
        }
        String[] gavParts = parts[0].split(":");
        if (gavParts.length != 3) {
            return null;
        }
        return new GroupArtifactVersion(gavParts[0], gavParts[1], gavParts[2]);
    }

    private Set<String> parseLockedConfigurations(String lock) {
        String[] parts = lock.split("=");
        if (parts.length != 2) {
            return Collections.emptySet();
        }
        return Arrays.stream(parts[1].split(",")).map(String::trim).filter(conf -> !conf.isEmpty()).collect(Collectors.toSet());
    }

    @Generated
    public UpdateDependencyLock(Set<GradleProject> modules) {
        this.modules = modules;
    }

    @Generated
    public Set<GradleProject> getModules() {
        return this.modules;
    }

    @NonNull
    @Generated
    public String toString() {
        return "UpdateDependencyLock(modules=" + this.getModules() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpdateDependencyLock)) {
            return false;
        }
        UpdateDependencyLock other = (UpdateDependencyLock)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Set<GradleProject> this$modules = this.getModules();
        Set<GradleProject> other$modules = other.getModules();
        return !(this$modules == null ? other$modules != null : !((Object)this$modules).equals(other$modules));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof UpdateDependencyLock;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Set<GradleProject> $modules = this.getModules();
        result = result * 59 + ($modules == null ? 43 : ((Object)$modules).hashCode());
        return result;
    }
}

