/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle.plugins;

import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.gradle.IsSettingsGradle;
import org.openrewrite.gradle.plugins.AddPluginVisitor;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.semver.Semver;

public final class AddSettingsPlugin
extends Recipe {
    @Option(displayName="Plugin id", description="The plugin id to apply.", example="com.jfrog.bintray")
    private final String pluginId;
    @Option(displayName="Plugin version", description="An exact version number or node-style semver selector used to select the version number. You can also use `latest.release` for the latest available version and `latest.patch` if the current version is a valid semantic version. For more details, you can look at the documentation page of [version selectors](https://docs.openrewrite.org/reference/dependency-version-selectors). Defaults to `latest.release`.", example="3.x", required=false)
    private final @Nullable String version;
    @Option(displayName="Version pattern", description="Allows version selection to be extended beyond the original Node Semver semantics. So for example,Setting 'version' to \"25-29\" can be paired with a metadata pattern of \"-jre\" to select Guava 29.0-jre", example="-jre", required=false)
    private final @Nullable String versionPattern;
    @Option(displayName="Apply plugin", description="Immediate apply the plugin. Defaults to `true`.", valid={"true", "false"}, required=false)
    private final @Nullable Boolean apply;
    @Option(displayName="Accept transitive", description="Some plugins apply other plugins. When this is set to true no plugin declaration will be added if the plugin is already applied transitively. When this is set to false the plugin will be added explicitly even if it is already applied transitively. Defaults to `true`.", valid={"true", "false"}, required=false)
    private final @Nullable Boolean acceptTransitive;

    public String getDisplayName() {
        return "Add Gradle settings plugin";
    }

    public String getDescription() {
        return "Add plugin to Gradle settings file `plugins` block by id.";
    }

    public Validated<Object> validate() {
        Validated validated = super.validate();
        if (this.version != null) {
            validated = validated.and(Semver.validate((String)this.version, (String)this.versionPattern));
        }
        return validated;
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check(new IsSettingsGradle(), (TreeVisitor)new AddPluginVisitor(this.pluginId, StringUtils.isBlank((String)this.version) ? "latest.release" : this.version, this.versionPattern, this.apply, this.acceptTransitive));
    }

    @Generated
    public AddSettingsPlugin(String pluginId, @Nullable String version, @Nullable String versionPattern, @Nullable Boolean apply, @Nullable Boolean acceptTransitive) {
        this.pluginId = pluginId;
        this.version = version;
        this.versionPattern = versionPattern;
        this.apply = apply;
        this.acceptTransitive = acceptTransitive;
    }

    @Generated
    public String getPluginId() {
        return this.pluginId;
    }

    @Generated
    public @Nullable String getVersion() {
        return this.version;
    }

    @Generated
    public @Nullable String getVersionPattern() {
        return this.versionPattern;
    }

    @Generated
    public @Nullable Boolean getApply() {
        return this.apply;
    }

    @Generated
    public @Nullable Boolean getAcceptTransitive() {
        return this.acceptTransitive;
    }

    @NonNull
    @Generated
    public String toString() {
        return "AddSettingsPlugin(pluginId=" + this.getPluginId() + ", version=" + this.getVersion() + ", versionPattern=" + this.getVersionPattern() + ", apply=" + this.getApply() + ", acceptTransitive=" + this.getAcceptTransitive() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddSettingsPlugin)) {
            return false;
        }
        AddSettingsPlugin other = (AddSettingsPlugin)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$apply = this.getApply();
        Boolean other$apply = other.getApply();
        if (this$apply == null ? other$apply != null : !((Object)this$apply).equals(other$apply)) {
            return false;
        }
        Boolean this$acceptTransitive = this.getAcceptTransitive();
        Boolean other$acceptTransitive = other.getAcceptTransitive();
        if (this$acceptTransitive == null ? other$acceptTransitive != null : !((Object)this$acceptTransitive).equals(other$acceptTransitive)) {
            return false;
        }
        String this$pluginId = this.getPluginId();
        String other$pluginId = other.getPluginId();
        if (this$pluginId == null ? other$pluginId != null : !this$pluginId.equals(other$pluginId)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$versionPattern = this.getVersionPattern();
        String other$versionPattern = other.getVersionPattern();
        return !(this$versionPattern == null ? other$versionPattern != null : !this$versionPattern.equals(other$versionPattern));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof AddSettingsPlugin;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $apply = this.getApply();
        result = result * 59 + ($apply == null ? 43 : ((Object)$apply).hashCode());
        Boolean $acceptTransitive = this.getAcceptTransitive();
        result = result * 59 + ($acceptTransitive == null ? 43 : ((Object)$acceptTransitive).hashCode());
        String $pluginId = this.getPluginId();
        result = result * 59 + ($pluginId == null ? 43 : $pluginId.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $versionPattern = this.getVersionPattern();
        result = result * 59 + ($versionPattern == null ? 43 : $versionPattern.hashCode());
        return result;
    }
}

