/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle.marker;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Tree;
import org.openrewrite.gradle.marker.GradleBuildscript;
import org.openrewrite.gradle.marker.GradleDependencyConfiguration;
import org.openrewrite.gradle.marker.GradlePluginDescriptor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.marker.Marker;
import org.openrewrite.maven.tree.MavenRepository;

public final class GradleProject
implements Marker,
Serializable {
    private final UUID id;
    private final @Nullable String group;
    private final String name;
    private final @Nullable String version;
    private final String path;
    private final List<GradlePluginDescriptor> plugins;
    private final List<MavenRepository> mavenRepositories;
    @Deprecated
    private final @Nullable List<MavenRepository> mavenPluginRepositories;
    private final Map<String, GradleDependencyConfiguration> nameToConfiguration;
    private final GradleBuildscript buildscript;

    public GradleBuildscript getBuildscript() {
        if (this.buildscript == null) {
            return new GradleBuildscript(Tree.randomId(), Collections.emptyList(), Collections.emptyMap());
        }
        return this.buildscript;
    }

    @Deprecated
    public List<MavenRepository> getMavenPluginRepositories() {
        if (this.buildscript != null) {
            return this.buildscript.getMavenRepositories();
        }
        return this.mavenPluginRepositories == null ? Collections.emptyList() : this.mavenPluginRepositories;
    }

    public @Nullable GradleDependencyConfiguration getConfiguration(String name) {
        return this.nameToConfiguration.get(name);
    }

    public List<GradleDependencyConfiguration> getConfigurations() {
        return new ArrayList<GradleDependencyConfiguration>(this.nameToConfiguration.values());
    }

    public List<GradleDependencyConfiguration> configurationsExtendingFrom(GradleDependencyConfiguration parentConfiguration, boolean transitive) {
        ArrayList<GradleDependencyConfiguration> result = new ArrayList<GradleDependencyConfiguration>();
        for (GradleDependencyConfiguration configuration : this.nameToConfiguration.values()) {
            if (configuration == parentConfiguration) continue;
            for (GradleDependencyConfiguration extendsFrom : configuration.getExtendsFrom()) {
                if (extendsFrom != parentConfiguration) continue;
                result.add(configuration);
                if (!transitive) continue;
                result.addAll(this.configurationsExtendingFrom(configuration, true));
            }
        }
        return result;
    }

    public GradleProject withNameToConfiguration(Map<String, GradleDependencyConfiguration> nameToConfiguration) {
        HashMap<String, GradleDependencyConfiguration> configurations = new HashMap<String, GradleDependencyConfiguration>(nameToConfiguration);
        for (GradleDependencyConfiguration gdc : configurations.values()) {
            ArrayList<GradleDependencyConfiguration> extendsFromList = new ArrayList<GradleDependencyConfiguration>(gdc.getExtendsFrom());
            boolean changed = false;
            for (int i = 0; i < extendsFromList.size(); ++i) {
                GradleDependencyConfiguration extendsFrom = (GradleDependencyConfiguration)extendsFromList.get(i);
                if (configurations.get(extendsFrom.getName()) == extendsFrom) continue;
                extendsFromList.set(i, (GradleDependencyConfiguration)configurations.get(extendsFrom.getName()));
                changed = true;
            }
            if (!changed) continue;
            configurations.put(gdc.getName(), gdc.withExtendsFrom(extendsFromList));
        }
        return new GradleProject(this.id, this.group, this.name, this.version, this.path, this.plugins, this.mavenRepositories, this.mavenPluginRepositories, configurations, this.buildscript);
    }

    @Generated
    private static UUID $default$id() {
        return Tree.randomId();
    }

    @Generated
    private static String $default$name() {
        return "";
    }

    @Generated
    private static String $default$path() {
        return "";
    }

    @Generated
    private static List<GradlePluginDescriptor> $default$plugins() {
        return Collections.emptyList();
    }

    @Generated
    private static List<MavenRepository> $default$mavenRepositories() {
        return Collections.emptyList();
    }

    @Generated
    private static Map<String, GradleDependencyConfiguration> $default$nameToConfiguration() {
        return Collections.emptyMap();
    }

    @Generated
    private static GradleBuildscript $default$buildscript() {
        return new GradleBuildscript(Tree.randomId(), Collections.emptyList(), Collections.emptyMap());
    }

    @NonNull
    @Generated
    public static GradleProjectBuilder builder() {
        return new GradleProjectBuilder();
    }

    @Generated
    public UUID getId() {
        return this.id;
    }

    @Generated
    public @Nullable String getGroup() {
        return this.group;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public @Nullable String getVersion() {
        return this.version;
    }

    @Generated
    public String getPath() {
        return this.path;
    }

    @Generated
    public List<GradlePluginDescriptor> getPlugins() {
        return this.plugins;
    }

    @Generated
    public List<MavenRepository> getMavenRepositories() {
        return this.mavenRepositories;
    }

    @Generated
    public Map<String, GradleDependencyConfiguration> getNameToConfiguration() {
        return this.nameToConfiguration;
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GradleProject)) {
            return false;
        }
        GradleProject other = (GradleProject)o;
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$group = this.getGroup();
        String other$group = other.getGroup();
        if (this$group == null ? other$group != null : !this$group.equals(other$group)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        List<GradlePluginDescriptor> this$plugins = this.getPlugins();
        List<GradlePluginDescriptor> other$plugins = other.getPlugins();
        if (this$plugins == null ? other$plugins != null : !((Object)this$plugins).equals(other$plugins)) {
            return false;
        }
        List<MavenRepository> this$mavenRepositories = this.getMavenRepositories();
        List<MavenRepository> other$mavenRepositories = other.getMavenRepositories();
        if (this$mavenRepositories == null ? other$mavenRepositories != null : !((Object)this$mavenRepositories).equals(other$mavenRepositories)) {
            return false;
        }
        List<MavenRepository> this$mavenPluginRepositories = this.getMavenPluginRepositories();
        List<MavenRepository> other$mavenPluginRepositories = other.getMavenPluginRepositories();
        if (this$mavenPluginRepositories == null ? other$mavenPluginRepositories != null : !((Object)this$mavenPluginRepositories).equals(other$mavenPluginRepositories)) {
            return false;
        }
        Map<String, GradleDependencyConfiguration> this$nameToConfiguration = this.getNameToConfiguration();
        Map<String, GradleDependencyConfiguration> other$nameToConfiguration = other.getNameToConfiguration();
        if (this$nameToConfiguration == null ? other$nameToConfiguration != null : !((Object)this$nameToConfiguration).equals(other$nameToConfiguration)) {
            return false;
        }
        GradleBuildscript this$buildscript = this.getBuildscript();
        GradleBuildscript other$buildscript = other.getBuildscript();
        return !(this$buildscript == null ? other$buildscript != null : !((Object)this$buildscript).equals(other$buildscript));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $group = this.getGroup();
        result = result * 59 + ($group == null ? 43 : $group.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        List<GradlePluginDescriptor> $plugins = this.getPlugins();
        result = result * 59 + ($plugins == null ? 43 : ((Object)$plugins).hashCode());
        List<MavenRepository> $mavenRepositories = this.getMavenRepositories();
        result = result * 59 + ($mavenRepositories == null ? 43 : ((Object)$mavenRepositories).hashCode());
        List<MavenRepository> $mavenPluginRepositories = this.getMavenPluginRepositories();
        result = result * 59 + ($mavenPluginRepositories == null ? 43 : ((Object)$mavenPluginRepositories).hashCode());
        Map<String, GradleDependencyConfiguration> $nameToConfiguration = this.getNameToConfiguration();
        result = result * 59 + ($nameToConfiguration == null ? 43 : ((Object)$nameToConfiguration).hashCode());
        GradleBuildscript $buildscript = this.getBuildscript();
        result = result * 59 + ($buildscript == null ? 43 : ((Object)$buildscript).hashCode());
        return result;
    }

    @NonNull
    @Generated
    public String toString() {
        return "GradleProject(id=" + this.getId() + ", group=" + this.getGroup() + ", name=" + this.getName() + ", version=" + this.getVersion() + ", path=" + this.getPath() + ", plugins=" + this.getPlugins() + ", mavenRepositories=" + this.getMavenRepositories() + ", mavenPluginRepositories=" + this.getMavenPluginRepositories() + ", nameToConfiguration=" + this.getNameToConfiguration() + ", buildscript=" + this.getBuildscript() + ")";
    }

    @JsonCreator
    @Generated
    public GradleProject(UUID id, @Nullable String group, String name, @Nullable String version, String path, List<GradlePluginDescriptor> plugins, List<MavenRepository> mavenRepositories, @Nullable List<MavenRepository> mavenPluginRepositories, Map<String, GradleDependencyConfiguration> nameToConfiguration, GradleBuildscript buildscript) {
        this.id = id;
        this.group = group;
        this.name = name;
        this.version = version;
        this.path = path;
        this.plugins = plugins;
        this.mavenRepositories = mavenRepositories;
        this.mavenPluginRepositories = mavenPluginRepositories;
        this.nameToConfiguration = nameToConfiguration;
        this.buildscript = buildscript;
    }

    @NonNull
    @Generated
    public GradleProject withId(UUID id) {
        return this.id == id ? this : new GradleProject(id, this.group, this.name, this.version, this.path, this.plugins, this.mavenRepositories, this.mavenPluginRepositories, this.nameToConfiguration, this.buildscript);
    }

    @NonNull
    @Generated
    public GradleProject withGroup(@Nullable String group) {
        return this.group == group ? this : new GradleProject(this.id, group, this.name, this.version, this.path, this.plugins, this.mavenRepositories, this.mavenPluginRepositories, this.nameToConfiguration, this.buildscript);
    }

    @NonNull
    @Generated
    public GradleProject withName(String name) {
        return this.name == name ? this : new GradleProject(this.id, this.group, name, this.version, this.path, this.plugins, this.mavenRepositories, this.mavenPluginRepositories, this.nameToConfiguration, this.buildscript);
    }

    @NonNull
    @Generated
    public GradleProject withVersion(@Nullable String version) {
        return this.version == version ? this : new GradleProject(this.id, this.group, this.name, version, this.path, this.plugins, this.mavenRepositories, this.mavenPluginRepositories, this.nameToConfiguration, this.buildscript);
    }

    @NonNull
    @Generated
    public GradleProject withPath(String path) {
        return this.path == path ? this : new GradleProject(this.id, this.group, this.name, this.version, path, this.plugins, this.mavenRepositories, this.mavenPluginRepositories, this.nameToConfiguration, this.buildscript);
    }

    @NonNull
    @Generated
    public GradleProject withPlugins(List<GradlePluginDescriptor> plugins) {
        return this.plugins == plugins ? this : new GradleProject(this.id, this.group, this.name, this.version, this.path, plugins, this.mavenRepositories, this.mavenPluginRepositories, this.nameToConfiguration, this.buildscript);
    }

    @NonNull
    @Generated
    public GradleProject withMavenRepositories(List<MavenRepository> mavenRepositories) {
        return this.mavenRepositories == mavenRepositories ? this : new GradleProject(this.id, this.group, this.name, this.version, this.path, this.plugins, mavenRepositories, this.mavenPluginRepositories, this.nameToConfiguration, this.buildscript);
    }

    @NonNull
    @Deprecated
    @Generated
    public GradleProject withMavenPluginRepositories(@Nullable List<MavenRepository> mavenPluginRepositories) {
        return this.mavenPluginRepositories == mavenPluginRepositories ? this : new GradleProject(this.id, this.group, this.name, this.version, this.path, this.plugins, this.mavenRepositories, mavenPluginRepositories, this.nameToConfiguration, this.buildscript);
    }

    @Generated
    public static class GradleProjectBuilder {
        @Generated
        private boolean id$set;
        @Generated
        private UUID id$value;
        @Generated
        private String group;
        @Generated
        private boolean name$set;
        @Generated
        private String name$value;
        @Generated
        private String version;
        @Generated
        private boolean path$set;
        @Generated
        private String path$value;
        @Generated
        private boolean plugins$set;
        @Generated
        private List<GradlePluginDescriptor> plugins$value;
        @Generated
        private boolean mavenRepositories$set;
        @Generated
        private List<MavenRepository> mavenRepositories$value;
        @Generated
        private List<MavenRepository> mavenPluginRepositories;
        @Generated
        private boolean nameToConfiguration$set;
        @Generated
        private Map<String, GradleDependencyConfiguration> nameToConfiguration$value;
        @Generated
        private boolean buildscript$set;
        @Generated
        private GradleBuildscript buildscript$value;

        @Generated
        GradleProjectBuilder() {
        }

        @NonNull
        @Generated
        public GradleProjectBuilder id(UUID id) {
            this.id$value = id;
            this.id$set = true;
            return this;
        }

        @NonNull
        @Generated
        public GradleProjectBuilder group(@Nullable String group) {
            this.group = group;
            return this;
        }

        @NonNull
        @Generated
        public GradleProjectBuilder name(String name) {
            this.name$value = name;
            this.name$set = true;
            return this;
        }

        @NonNull
        @Generated
        public GradleProjectBuilder version(@Nullable String version) {
            this.version = version;
            return this;
        }

        @NonNull
        @Generated
        public GradleProjectBuilder path(String path) {
            this.path$value = path;
            this.path$set = true;
            return this;
        }

        @NonNull
        @Generated
        public GradleProjectBuilder plugins(List<GradlePluginDescriptor> plugins) {
            this.plugins$value = plugins;
            this.plugins$set = true;
            return this;
        }

        @NonNull
        @Generated
        public GradleProjectBuilder mavenRepositories(List<MavenRepository> mavenRepositories) {
            this.mavenRepositories$value = mavenRepositories;
            this.mavenRepositories$set = true;
            return this;
        }

        @NonNull
        @Deprecated
        @Generated
        public GradleProjectBuilder mavenPluginRepositories(@Nullable List<MavenRepository> mavenPluginRepositories) {
            this.mavenPluginRepositories = mavenPluginRepositories;
            return this;
        }

        @NonNull
        @Generated
        public GradleProjectBuilder nameToConfiguration(Map<String, GradleDependencyConfiguration> nameToConfiguration) {
            this.nameToConfiguration$value = nameToConfiguration;
            this.nameToConfiguration$set = true;
            return this;
        }

        @NonNull
        @Generated
        public GradleProjectBuilder buildscript(GradleBuildscript buildscript) {
            this.buildscript$value = buildscript;
            this.buildscript$set = true;
            return this;
        }

        @NonNull
        @Generated
        public GradleProject build() {
            UUID id$value = this.id$value;
            if (!this.id$set) {
                id$value = GradleProject.$default$id();
            }
            String name$value = this.name$value;
            if (!this.name$set) {
                name$value = GradleProject.$default$name();
            }
            String path$value = this.path$value;
            if (!this.path$set) {
                path$value = GradleProject.$default$path();
            }
            List plugins$value = this.plugins$value;
            if (!this.plugins$set) {
                plugins$value = GradleProject.$default$plugins();
            }
            List mavenRepositories$value = this.mavenRepositories$value;
            if (!this.mavenRepositories$set) {
                mavenRepositories$value = GradleProject.$default$mavenRepositories();
            }
            Map nameToConfiguration$value = this.nameToConfiguration$value;
            if (!this.nameToConfiguration$set) {
                nameToConfiguration$value = GradleProject.$default$nameToConfiguration();
            }
            GradleBuildscript buildscript$value = this.buildscript$value;
            if (!this.buildscript$set) {
                buildscript$value = GradleProject.$default$buildscript();
            }
            return new GradleProject(id$value, this.group, name$value, this.version, path$value, plugins$value, mavenRepositories$value, this.mavenPluginRepositories, nameToConfiguration$value, buildscript$value);
        }

        @NonNull
        @Generated
        public String toString() {
            return "GradleProject.GradleProjectBuilder(id$value=" + this.id$value + ", group=" + this.group + ", name$value=" + this.name$value + ", version=" + this.version + ", path$value=" + this.path$value + ", plugins$value=" + this.plugins$value + ", mavenRepositories$value=" + this.mavenRepositories$value + ", mavenPluginRepositories=" + this.mavenPluginRepositories + ", nameToConfiguration$value=" + this.nameToConfiguration$value + ", buildscript$value=" + this.buildscript$value + ")";
        }
    }
}

