/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.gradle.DependencyVersionSelector;
import org.openrewrite.gradle.marker.GradleDependencyConfiguration;
import org.openrewrite.gradle.marker.GradleProject;
import org.openrewrite.gradle.search.FindGradleProject;
import org.openrewrite.gradle.util.ChangeStringLiteral;
import org.openrewrite.gradle.util.Dependency;
import org.openrewrite.gradle.util.DependencyStringNotationConverter;
import org.openrewrite.groovy.GroovyIsoVisitor;
import org.openrewrite.groovy.GroovyVisitor;
import org.openrewrite.groovy.tree.G;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Markup;
import org.openrewrite.maven.MavenDownloadingException;
import org.openrewrite.maven.MavenDownloadingExceptions;
import org.openrewrite.maven.internal.MavenPomDownloader;
import org.openrewrite.maven.table.MavenMetadataFailures;
import org.openrewrite.maven.tree.GroupArtifact;
import org.openrewrite.maven.tree.GroupArtifactVersion;
import org.openrewrite.maven.tree.Pom;
import org.openrewrite.maven.tree.ResolvedGroupArtifactVersion;
import org.openrewrite.maven.tree.ResolvedPom;
import org.openrewrite.maven.tree.Scope;
import org.openrewrite.properties.PropertiesVisitor;
import org.openrewrite.properties.tree.Properties;
import org.openrewrite.semver.DependencyMatcher;
import org.openrewrite.semver.Semver;
import org.openrewrite.semver.VersionComparator;

public final class UpgradeDependencyVersion
extends ScanningRecipe<DependencyVersionState> {
    private static final String VERSION_VARIABLE_KEY = "VERSION_VARIABLE";
    private static final String NEW_VERSION_KEY = "NEW_VERSION";
    private static final String GRADLE_PROPERTIES_FILE_NAME = "gradle.properties";
    private final transient MavenMetadataFailures metadataFailures = new MavenMetadataFailures((Recipe)this);
    @Option(displayName="Group", description="The first part of a dependency coordinate `com.google.guava:guava:VERSION`. This can be a glob expression.", example="com.fasterxml.jackson*")
    private final String groupId;
    @Option(displayName="Artifact", description="The second part of a dependency coordinate `com.google.guava:guava:VERSION`. This can be a glob expression.", example="jackson-module*")
    private final String artifactId;
    @Option(displayName="New version", description="An exact version number or node-style semver selector used to select the version number. You can also use `latest.release` for the latest available version and `latest.patch` if the current version is a valid semantic version. For more details, you can look at the documentation page of [version selectors](https://docs.openrewrite.org/reference/dependency-version-selectors). Defaults to `latest.release`.", example="29.X", required=false)
    @Nullable
    private final String newVersion;
    @Option(displayName="Version pattern", description="Allows version selection to be extended beyond the original Node Semver semantics. So for example,Setting 'newVersion' to \"25-29\" can be paired with a metadata pattern of \"-jre\" to select Guava 29.0-jre", example="-jre", required=false)
    @Nullable
    private final String versionPattern;
    private static final String UPDATE_VERSION_ERROR_KEY = "UPDATE_VERSION_ERROR_KEY";

    public String getDisplayName() {
        return "Upgrade Gradle dependency versions";
    }

    public String getInstanceNameSuffix() {
        return String.format("`%s:%s`", this.groupId, this.artifactId);
    }

    public String getDescription() {
        return "Upgrade the version of a dependency in a build.gradle file. Supports updating dependency declarations of various forms:\n* `String` notation: `\"group:artifact:version\"` \n* `Map` notation: `group: 'group', name: 'artifact', version: 'version'`\nCan update version numbers which are defined earlier in the same file in variable declarations.";
    }

    public Validated<Object> validate() {
        Validated validated = super.validate();
        if (this.newVersion != null) {
            validated = validated.and(Semver.validate((String)this.newVersion, (String)this.versionPattern));
        }
        return validated;
    }

    public DependencyVersionState getInitialValue(ExecutionContext ctx) {
        return new DependencyVersionState();
    }

    public TreeVisitor<?, ExecutionContext> getScanner(final DependencyVersionState acc) {
        final MethodMatcher dependencyDsl = new MethodMatcher("DependencyHandlerSpec *(..)");
        return new GroovyVisitor<ExecutionContext>(){
            GradleProject gradleProject;
            final DependencyMatcher dependencyMatcher;
            {
                this.dependencyMatcher = new DependencyMatcher(UpgradeDependencyVersion.this.groupId, UpgradeDependencyVersion.this.artifactId, null);
            }

            public J visitCompilationUnit(G.CompilationUnit cu, ExecutionContext executionContext) {
                this.gradleProject = cu.getMarkers().findFirst(GradleProject.class).orElse(null);
                if (this.gradleProject == null) {
                    return cu;
                }
                return super.visitCompilationUnit(cu, (Object)executionContext);
            }

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation m = (J.MethodInvocation)super.visitMethodInvocation(method, (Object)ctx);
                if (dependencyDsl.matches((MethodCall)m)) {
                    if (m.getArguments().get(0) instanceof G.MapEntry) {
                        String groupId = null;
                        String artifactId = null;
                        String version = null;
                        for (Expression e : m.getArguments()) {
                            G.GString.Value versionGStringValue;
                            Object strings;
                            J.Literal value;
                            G.MapEntry arg;
                            if (!(e instanceof G.MapEntry) || !((arg = (G.MapEntry)e).getKey() instanceof J.Literal)) continue;
                            J.Literal key = (J.Literal)arg.getKey();
                            String valueValue = null;
                            if (arg.getValue() instanceof J.Literal) {
                                value = (J.Literal)arg.getValue();
                                if (value.getValue() instanceof String) {
                                    valueValue = (String)value.getValue();
                                }
                            } else if (arg.getValue() instanceof J.Identifier) {
                                value = (J.Identifier)arg.getValue();
                                valueValue = value.getSimpleName();
                            } else if (arg.getValue() instanceof G.GString && !(strings = (value = (G.GString)arg.getValue()).getStrings()).isEmpty() && strings.get(0) instanceof G.GString.Value && (versionGStringValue = (G.GString.Value)strings.get(0)).getTree() instanceof J.Identifier) {
                                valueValue = ((J.Identifier)versionGStringValue.getTree()).getSimpleName();
                            }
                            if (!(key.getValue() instanceof String)) continue;
                            String keyValue = (String)key.getValue();
                            switch (keyValue) {
                                case "group": {
                                    groupId = valueValue;
                                    break;
                                }
                                case "name": {
                                    artifactId = valueValue;
                                    break;
                                }
                                case "version": {
                                    version = valueValue;
                                }
                            }
                        }
                        if (groupId == null || artifactId == null) {
                            return m;
                        }
                        if (!this.dependencyMatcher.matches(groupId, artifactId)) {
                            return m;
                        }
                        String versionVariableName = version;
                        GroupArtifact ga = new GroupArtifact(groupId, artifactId);
                        if (acc.gaToNewVersion.containsKey(ga)) {
                            return m;
                        }
                        try {
                            String resolvedVersion = new DependencyVersionSelector(UpgradeDependencyVersion.this.metadataFailures, this.gradleProject).select(new GroupArtifact(groupId, artifactId), m.getSimpleName(), UpgradeDependencyVersion.this.newVersion, UpgradeDependencyVersion.this.versionPattern, ctx);
                            acc.versionPropNameToGA.put(versionVariableName, ga);
                            acc.gaToNewVersion.put(ga, resolvedVersion);
                        }
                        catch (MavenDownloadingException e) {
                            acc.gaToNewVersion.put(ga, e);
                            return m;
                        }
                    } else {
                        for (Expression depArg : m.getArguments()) {
                            Dependency dep;
                            G.GString gString;
                            List strings;
                            if (!(depArg instanceof G.GString) || (strings = (gString = (G.GString)depArg).getStrings()).size() != 2 || !(strings.get(0) instanceof J.Literal) || !(strings.get(1) instanceof G.GString.Value)) continue;
                            J.Literal groupArtifact = (J.Literal)strings.get(0);
                            G.GString.Value versionValue = (G.GString.Value)strings.get(1);
                            if (!(versionValue.getTree() instanceof J.Identifier) || !(groupArtifact.getValue() instanceof String) || !this.dependencyMatcher.matches((dep = DependencyStringNotationConverter.parse((String)groupArtifact.getValue())).getGroupId(), dep.getArtifactId())) continue;
                            String versionVariableName = ((J.Identifier)versionValue.getTree()).getSimpleName();
                            GroupArtifact ga = new GroupArtifact(dep.getGroupId(), dep.getArtifactId());
                            if (acc.gaToNewVersion.containsKey(ga)) continue;
                            try {
                                String resolvedVersion = new DependencyVersionSelector(UpgradeDependencyVersion.this.metadataFailures, this.gradleProject).select(new GroupArtifact(dep.getGroupId(), dep.getArtifactId()), m.getSimpleName(), UpgradeDependencyVersion.this.newVersion, UpgradeDependencyVersion.this.versionPattern, ctx);
                                acc.versionPropNameToGA.put(versionVariableName, ga);
                                acc.gaToNewVersion.put(ga, resolvedVersion);
                            }
                            catch (MavenDownloadingException e) {
                                acc.gaToNewVersion.put(ga, e);
                            }
                        }
                    }
                }
                return m;
            }
        };
    }

    public TreeVisitor<?, ExecutionContext> getVisitor(final DependencyVersionState acc) {
        final MethodMatcher dependencyDsl = new MethodMatcher("DependencyHandlerSpec *(..)");
        final DependencyMatcher dependencyMatcher = new DependencyMatcher(this.groupId, this.artifactId, null);
        return Preconditions.or((TreeVisitor[])new TreeVisitor[]{new PropertiesVisitor<ExecutionContext>(){

            public boolean isAcceptable(SourceFile sourceFile, ExecutionContext ctx) {
                return super.isAcceptable(sourceFile, (Object)ctx) && sourceFile.getSourcePath().endsWith(UpgradeDependencyVersion.GRADLE_PROPERTIES_FILE_NAME);
            }

            public Properties visitEntry(Properties.Entry entry, ExecutionContext ctx) {
                if (acc.versionPropNameToGA.containsKey(entry.getKey())) {
                    GroupArtifact ga = (GroupArtifact)acc.versionPropNameToGA.get(entry.getKey());
                    if (ga == null || !dependencyMatcher.matches(ga.getGroupId(), ga.getArtifactId())) {
                        return entry;
                    }
                    Object result = acc.gaToNewVersion.get(ga);
                    if (result == null || result instanceof Exception) {
                        return entry;
                    }
                    VersionComparator versionComparator = (VersionComparator)Semver.validate((String)(StringUtils.isBlank((String)UpgradeDependencyVersion.this.newVersion) ? "latest.release" : UpgradeDependencyVersion.this.newVersion), (String)UpgradeDependencyVersion.this.versionPattern).getValue();
                    if (versionComparator == null) {
                        return entry;
                    }
                    Optional finalVersion = versionComparator.upgrade(entry.getValue().getText(), Collections.singletonList((String)result));
                    return (Properties)finalVersion.map(v -> entry.withValue(entry.getValue().withText(v))).orElse(entry);
                }
                return entry;
            }
        }, Preconditions.check((Recipe)new FindGradleProject(FindGradleProject.SearchCriteria.Marker), (TreeVisitor)new GroovyVisitor<ExecutionContext>(){
            GradleProject gradleProject;

            public J visitCompilationUnit(G.CompilationUnit cu, ExecutionContext ctx) {
                this.gradleProject = (GradleProject)cu.getMarkers().findFirst(GradleProject.class).orElseThrow(() -> new IllegalStateException("Unable to find GradleProject marker."));
                return super.visitCompilationUnit(cu, (Object)ctx);
            }

            public J postVisit(J tree, ExecutionContext ctx) {
                if (tree instanceof JavaSourceFile) {
                    Map versionUpdates;
                    JavaSourceFile cu = (JavaSourceFile)tree;
                    Map variableNames = (Map)this.getCursor().getMessage(UpgradeDependencyVersion.VERSION_VARIABLE_KEY);
                    if (variableNames != null && this.gradleProject != null) {
                        cu = (JavaSourceFile)new UpdateVariable(variableNames, this.gradleProject).visitNonNull((Tree)cu, ctx);
                    }
                    if ((versionUpdates = (Map)this.getCursor().getMessage(UpgradeDependencyVersion.NEW_VERSION_KEY)) != null && this.gradleProject != null) {
                        GradleProject newGp = this.gradleProject;
                        for (Map.Entry gavToConfigurations : versionUpdates.entrySet()) {
                            newGp = UpgradeDependencyVersion.replaceVersion(newGp, ctx, (GroupArtifactVersion)gavToConfigurations.getKey(), (Set)gavToConfigurations.getValue());
                        }
                        cu = (JavaSourceFile)cu.withMarkers(cu.getMarkers().removeByType(GradleProject.class).add((Marker)newGp));
                    }
                    return cu;
                }
                return tree;
            }

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation m = (J.MethodInvocation)super.visitMethodInvocation(method, (Object)ctx);
                if (dependencyDsl.matches((MethodCall)m)) {
                    List depArgs = m.getArguments();
                    if (depArgs.get(0) instanceof J.Literal || depArgs.get(0) instanceof G.GString || depArgs.get(0) instanceof G.MapEntry) {
                        m = this.updateDependency(m, ctx);
                    } else if (depArgs.get(0) instanceof J.MethodInvocation && (((J.MethodInvocation)depArgs.get(0)).getSimpleName().equals("platform") || ((J.MethodInvocation)depArgs.get(0)).getSimpleName().equals("enforcedPlatform"))) {
                        m = m.withArguments(ListUtils.mapFirst((List)depArgs, platform -> this.updateDependency((J.MethodInvocation)platform, ctx)));
                    }
                }
                return m;
            }

            private J.MethodInvocation updateDependency(J.MethodInvocation method, ExecutionContext ctx) {
                List depArgs;
                J.MethodInvocation m = method;
                m = m.withArguments(ListUtils.map((List)m.getArguments(), arg -> {
                    if (arg instanceof G.GString) {
                        G.GString gString = (G.GString)arg;
                        List strings = gString.getStrings();
                        if (strings.size() != 2 || !(strings.get(0) instanceof J.Literal) || !(strings.get(1) instanceof G.GString.Value)) {
                            return arg;
                        }
                        J.Literal groupArtifact = (J.Literal)strings.get(0);
                        G.GString.Value versionValue = (G.GString.Value)strings.get(1);
                        if (!(versionValue.getTree() instanceof J.Identifier) || !(groupArtifact.getValue() instanceof String)) {
                            return arg;
                        }
                        Dependency dep = DependencyStringNotationConverter.parse((String)groupArtifact.getValue());
                        if (dependencyMatcher.matches(dep.getGroupId(), dep.getArtifactId())) {
                            Object scanResult = acc.gaToNewVersion.get(new GroupArtifact(dep.getGroupId(), dep.getArtifactId()));
                            if (scanResult instanceof Exception) {
                                this.getCursor().putMessage(UpgradeDependencyVersion.UPDATE_VERSION_ERROR_KEY, scanResult);
                                return arg;
                            }
                            String versionVariableName = ((J.Identifier)versionValue.getTree()).getSimpleName();
                            ((HashMap)this.getCursor().dropParentUntil(p -> p instanceof SourceFile).computeMessageIfAbsent(UpgradeDependencyVersion.VERSION_VARIABLE_KEY, v -> new HashMap())).computeIfAbsent(versionVariableName, it -> new HashMap()).computeIfAbsent(new GroupArtifact(dep.getGroupId(), dep.getArtifactId()), it -> new HashSet()).add(method.getSimpleName());
                        }
                    } else if (arg instanceof J.Literal) {
                        J.Literal literal = (J.Literal)arg;
                        String gav = (String)literal.getValue();
                        if (gav == null) {
                            this.getCursor().putMessage(UpgradeDependencyVersion.UPDATE_VERSION_ERROR_KEY, (Object)new IllegalStateException("Unable to update version"));
                            return arg;
                        }
                        Dependency dep = DependencyStringNotationConverter.parse(gav);
                        if (dependencyMatcher.matches(dep.getGroupId(), dep.getArtifactId()) && dep.getVersion() != null && !dep.getVersion().startsWith("$")) {
                            Object scanResult = acc.gaToNewVersion.get(new GroupArtifact(dep.getGroupId(), dep.getArtifactId()));
                            if (scanResult instanceof Exception) {
                                this.getCursor().putMessage(UpgradeDependencyVersion.UPDATE_VERSION_ERROR_KEY, scanResult);
                                return arg;
                            }
                            try {
                                String selectedVersion = new DependencyVersionSelector(UpgradeDependencyVersion.this.metadataFailures, this.gradleProject).select(dep.getGav(), method.getSimpleName(), UpgradeDependencyVersion.this.newVersion, UpgradeDependencyVersion.this.versionPattern, ctx);
                                if (selectedVersion == null || dep.getVersion().equals(selectedVersion)) {
                                    return arg;
                                }
                                ((HashMap)this.getCursor().dropParentUntil(p -> p instanceof SourceFile).computeMessageIfAbsent(UpgradeDependencyVersion.NEW_VERSION_KEY, it -> new HashMap())).computeIfAbsent(new GroupArtifactVersion(dep.getGroupId(), dep.getArtifactId(), selectedVersion), it -> new HashSet()).add(method.getSimpleName());
                                String newGav = dep.withVersion(selectedVersion).toStringNotation();
                                return literal.withValue((Object)newGav).withValueSource(Objects.requireNonNull(literal.getValueSource()).replace(gav, newGav));
                            }
                            catch (MavenDownloadingException e) {
                                this.getCursor().putMessage(UpgradeDependencyVersion.UPDATE_VERSION_ERROR_KEY, (Object)e);
                            }
                        }
                    }
                    return arg;
                }));
                Exception err = (Exception)this.getCursor().pollMessage(UpgradeDependencyVersion.UPDATE_VERSION_ERROR_KEY);
                if (err != null) {
                    m = (J.MethodInvocation)Markup.warn((Tree)m, (Throwable)err);
                }
                if ((depArgs = m.getArguments()).size() >= 3 && depArgs.get(0) instanceof G.MapEntry && depArgs.get(1) instanceof G.MapEntry && depArgs.get(2) instanceof G.MapEntry) {
                    Expression groupValue = ((G.MapEntry)depArgs.get(0)).getValue();
                    Expression artifactValue = ((G.MapEntry)depArgs.get(1)).getValue();
                    if (!(groupValue instanceof J.Literal) || !(artifactValue instanceof J.Literal)) {
                        return m;
                    }
                    J.Literal groupLiteral = (J.Literal)groupValue;
                    J.Literal artifactLiteral = (J.Literal)artifactValue;
                    if (!dependencyMatcher.matches((String)groupLiteral.getValue(), (String)artifactLiteral.getValue())) {
                        return m;
                    }
                    Object scanResult = acc.gaToNewVersion.get(new GroupArtifact((String)groupLiteral.getValue(), (String)artifactLiteral.getValue()));
                    if (scanResult instanceof Exception) {
                        return (J.MethodInvocation)Markup.warn((Tree)m, (Throwable)((Exception)scanResult));
                    }
                    G.MapEntry versionEntry = (G.MapEntry)depArgs.get(2);
                    Expression versionExp = versionEntry.getValue();
                    if (versionExp instanceof J.Literal && ((J.Literal)versionExp).getValue() instanceof String) {
                        String selectedVersion;
                        J.Literal versionLiteral = (J.Literal)versionExp;
                        String version = (String)versionLiteral.getValue();
                        if (version.startsWith("$")) {
                            return m;
                        }
                        try {
                            GroupArtifactVersion gav = new GroupArtifactVersion((String)groupLiteral.getValue(), (String)artifactLiteral.getValue(), version);
                            selectedVersion = new DependencyVersionSelector(UpgradeDependencyVersion.this.metadataFailures, this.gradleProject).select(gav, m.getSimpleName(), UpgradeDependencyVersion.this.newVersion, UpgradeDependencyVersion.this.versionPattern, ctx);
                        }
                        catch (MavenDownloadingException e) {
                            return (J.MethodInvocation)e.warn((Tree)m);
                        }
                        if (selectedVersion == null || version.equals(selectedVersion)) {
                            return m;
                        }
                        ArrayList<Object> newArgs = new ArrayList<Object>(3);
                        newArgs.add((Expression)depArgs.get(0));
                        newArgs.add((Expression)depArgs.get(1));
                        newArgs.add(versionEntry.withValue((Expression)versionLiteral.withValueSource(Objects.requireNonNull(versionLiteral.getValueSource()).replace(version, selectedVersion)).withValue((Object)selectedVersion)));
                        newArgs.addAll(depArgs.subList(3, depArgs.size()));
                        return m.withArguments(newArgs);
                    }
                    if (versionExp instanceof J.Identifier) {
                        String versionVariableName = ((J.Identifier)versionExp).getSimpleName();
                        ((HashMap)this.getCursor().dropParentUntil(p -> p instanceof SourceFile).computeMessageIfAbsent(UpgradeDependencyVersion.VERSION_VARIABLE_KEY, v -> new HashMap())).computeIfAbsent(versionVariableName, it -> new HashMap()).computeIfAbsent(new GroupArtifact((String)groupLiteral.getValue(), (String)artifactLiteral.getValue()), it -> new HashSet()).add(m.getSimpleName());
                    }
                }
                return m;
            }
        })});
    }

    static GradleProject replaceVersion(GradleProject gp, ExecutionContext ctx, GroupArtifactVersion gav, Set<String> configurations) {
        try {
            if (gav.getGroupId() == null || gav.getArtifactId() == null) {
                return gp;
            }
            HashSet<String> remainingConfigurations = new HashSet<String>(configurations);
            remainingConfigurations.remove("classpath");
            if (remainingConfigurations.isEmpty()) {
                return gp;
            }
            MavenPomDownloader mpd = new MavenPomDownloader(ctx);
            Pom pom = mpd.download(gav, null, null, gp.getMavenRepositories());
            ResolvedPom resolvedPom = pom.resolve(Collections.emptyList(), mpd, gp.getMavenRepositories(), ctx);
            ResolvedGroupArtifactVersion resolvedGav = resolvedPom.getGav();
            List transitiveDependencies = resolvedPom.resolveDependencies(Scope.Runtime, mpd, ctx);
            Map<String, GradleDependencyConfiguration> nameToConfiguration = gp.getNameToConfiguration();
            HashMap<String, GradleDependencyConfiguration> newNameToConfiguration = new HashMap<String, GradleDependencyConfiguration>(nameToConfiguration.size());
            boolean anyChanged = false;
            Iterator<GradleDependencyConfiguration> iterator = nameToConfiguration.values().iterator();
            while (iterator.hasNext()) {
                GradleDependencyConfiguration gdc;
                GradleDependencyConfiguration newGdc = gdc = iterator.next();
                newGdc = newGdc.withRequested(ListUtils.map(gdc.getRequested(), requested -> {
                    if (!Objects.equals(requested.getGroupId(), gav.getGroupId()) || !Objects.equals(requested.getArtifactId(), gav.getArtifactId())) {
                        return requested;
                    }
                    return requested.withGav(gav);
                }));
                anyChanged |= (newGdc = newGdc.withDirectResolved(ListUtils.map(gdc.getDirectResolved(), resolved -> {
                    if (!Objects.equals(resolved.getGroupId(), resolvedGav.getGroupId()) || !Objects.equals(resolved.getArtifactId(), resolvedGav.getArtifactId())) {
                        return resolved;
                    }
                    return resolved.withGav(resolvedGav).withDependencies(transitiveDependencies);
                }))) != gdc;
                newNameToConfiguration.put(newGdc.getName(), newGdc);
            }
            if (anyChanged) {
                gp = gp.withNameToConfiguration(newNameToConfiguration);
            }
        }
        catch (MavenDownloadingException | MavenDownloadingExceptions e) {
            return gp;
        }
        return gp;
    }

    public UpgradeDependencyVersion(String groupId, String artifactId, @Nullable String newVersion, @Nullable String versionPattern) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.newVersion = newVersion;
        this.versionPattern = versionPattern;
    }

    public MavenMetadataFailures getMetadataFailures() {
        return this.metadataFailures;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    @Nullable
    public String getNewVersion() {
        return this.newVersion;
    }

    @Nullable
    public String getVersionPattern() {
        return this.versionPattern;
    }

    @NonNull
    public String toString() {
        return "UpgradeDependencyVersion(metadataFailures=" + this.getMetadataFailures() + ", groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", newVersion=" + this.getNewVersion() + ", versionPattern=" + this.getVersionPattern() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpgradeDependencyVersion)) {
            return false;
        }
        UpgradeDependencyVersion other = (UpgradeDependencyVersion)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$artifactId = this.getArtifactId();
        String other$artifactId = other.getArtifactId();
        if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
            return false;
        }
        String this$newVersion = this.getNewVersion();
        String other$newVersion = other.getNewVersion();
        if (this$newVersion == null ? other$newVersion != null : !this$newVersion.equals(other$newVersion)) {
            return false;
        }
        String this$versionPattern = this.getVersionPattern();
        String other$versionPattern = other.getVersionPattern();
        return !(this$versionPattern == null ? other$versionPattern != null : !this$versionPattern.equals(other$versionPattern));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof UpgradeDependencyVersion;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $artifactId = this.getArtifactId();
        result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
        String $newVersion = this.getNewVersion();
        result = result * 59 + ($newVersion == null ? 43 : $newVersion.hashCode());
        String $versionPattern = this.getVersionPattern();
        result = result * 59 + ($versionPattern == null ? 43 : $versionPattern.hashCode());
        return result;
    }

    public static final class DependencyVersionState {
        private final Map<String, GroupArtifact> versionPropNameToGA = new HashMap<String, GroupArtifact>();
        private final Map<GroupArtifact, Object> gaToNewVersion = new HashMap<GroupArtifact, Object>();

        public Map<String, GroupArtifact> getVersionPropNameToGA() {
            return this.versionPropNameToGA;
        }

        public Map<GroupArtifact, Object> getGaToNewVersion() {
            return this.gaToNewVersion;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DependencyVersionState)) {
                return false;
            }
            DependencyVersionState other = (DependencyVersionState)o;
            Map<String, GroupArtifact> this$versionPropNameToGA = this.getVersionPropNameToGA();
            Map<String, GroupArtifact> other$versionPropNameToGA = other.getVersionPropNameToGA();
            if (this$versionPropNameToGA == null ? other$versionPropNameToGA != null : !((Object)this$versionPropNameToGA).equals(other$versionPropNameToGA)) {
                return false;
            }
            Map<GroupArtifact, Object> this$gaToNewVersion = this.getGaToNewVersion();
            Map<GroupArtifact, Object> other$gaToNewVersion = other.getGaToNewVersion();
            return !(this$gaToNewVersion == null ? other$gaToNewVersion != null : !((Object)this$gaToNewVersion).equals(other$gaToNewVersion));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<String, GroupArtifact> $versionPropNameToGA = this.getVersionPropNameToGA();
            result = result * 59 + ($versionPropNameToGA == null ? 43 : ((Object)$versionPropNameToGA).hashCode());
            Map<GroupArtifact, Object> $gaToNewVersion = this.getGaToNewVersion();
            result = result * 59 + ($gaToNewVersion == null ? 43 : ((Object)$gaToNewVersion).hashCode());
            return result;
        }

        @NonNull
        public String toString() {
            return "UpgradeDependencyVersion.DependencyVersionState(versionPropNameToGA=" + this.getVersionPropNameToGA() + ", gaToNewVersion=" + this.getGaToNewVersion() + ")";
        }
    }

    private class UpdateVariable
    extends GroovyIsoVisitor<ExecutionContext> {
        private final Map<String, Map<GroupArtifact, Set<String>>> versionVariableNames;
        private final GradleProject gradleProject;

        public J.VariableDeclarations.NamedVariable visitVariable(J.VariableDeclarations.NamedVariable variable, ExecutionContext ctx) {
            J.VariableDeclarations.NamedVariable v = super.visitVariable(variable, (Object)ctx);
            boolean noneMatch = true;
            Map<GroupArtifact, Set<String>> gaToConfigurations = null;
            for (Map.Entry<String, Map<GroupArtifact, Set<String>>> versionVariableNameEntry : this.versionVariableNames.entrySet()) {
                if (!versionVariableNameEntry.getKey().equals(v.getSimpleName())) continue;
                noneMatch = false;
                gaToConfigurations = versionVariableNameEntry.getValue();
                break;
            }
            if (noneMatch) {
                return v;
            }
            if (!(v.getInitializer() instanceof J.Literal)) {
                return v;
            }
            J.Literal initializer = (J.Literal)v.getInitializer();
            if (initializer.getType() != JavaType.Primitive.String) {
                return v;
            }
            String version = (String)initializer.getValue();
            if (version == null) {
                return v;
            }
            try {
                for (Map.Entry<GroupArtifact, Set<String>> gaEntry : gaToConfigurations.entrySet()) {
                    GroupArtifact ga = gaEntry.getKey();
                    GroupArtifactVersion gav = new GroupArtifactVersion(ga.getGroupId(), ga.getArtifactId(), version);
                    DependencyVersionSelector selector = new DependencyVersionSelector(UpgradeDependencyVersion.this.metadataFailures, this.gradleProject);
                    String selectedVersion = Optional.ofNullable(selector.select(gav, null, UpgradeDependencyVersion.this.newVersion, UpgradeDependencyVersion.this.versionPattern, ctx)).orElse(selector.select(gav, "classpath", UpgradeDependencyVersion.this.newVersion, UpgradeDependencyVersion.this.versionPattern, ctx));
                    if (selectedVersion == null) {
                        return v;
                    }
                    ((HashMap)this.getCursor().dropParentUntil(p -> p instanceof SourceFile).computeMessageIfAbsent(UpgradeDependencyVersion.NEW_VERSION_KEY, m -> new HashMap())).computeIfAbsent(new GroupArtifactVersion(ga.getGroupId(), ga.getArtifactId(), selectedVersion), it -> new HashSet()).addAll((Collection)gaEntry.getValue());
                    J.Literal newVersionLiteral = ChangeStringLiteral.withStringValue(initializer, selectedVersion);
                    v = v.withInitializer((Expression)newVersionLiteral);
                }
            }
            catch (MavenDownloadingException e) {
                return (J.VariableDeclarations.NamedVariable)e.warn((Tree)v);
            }
            return v;
        }

        public J.Assignment visitAssignment(J.Assignment assignment, ExecutionContext ctx) {
            J.Assignment a = super.visitAssignment(assignment, (Object)ctx);
            if (!(a.getVariable() instanceof J.Identifier)) {
                return a;
            }
            J.Identifier identifier = (J.Identifier)a.getVariable();
            Map<GroupArtifact, Set<String>> gaToConfigurations = null;
            boolean noneMatch = true;
            for (Map.Entry<String, Map<GroupArtifact, Set<String>>> versionVariableNameEntry : this.versionVariableNames.entrySet()) {
                if (!versionVariableNameEntry.getKey().equals(identifier.getSimpleName())) continue;
                noneMatch = false;
                gaToConfigurations = versionVariableNameEntry.getValue();
                break;
            }
            if (noneMatch) {
                return a;
            }
            if (!(a.getAssignment() instanceof J.Literal)) {
                return a;
            }
            J.Literal literal = (J.Literal)a.getAssignment();
            if (literal.getType() != JavaType.Primitive.String) {
                return a;
            }
            String version = (String)literal.getValue();
            if (version == null) {
                return a;
            }
            try {
                for (Map.Entry<GroupArtifact, Set<String>> gaEntry : gaToConfigurations.entrySet()) {
                    GroupArtifact ga = gaEntry.getKey();
                    GroupArtifactVersion gav = new GroupArtifactVersion(ga.getGroupId(), ga.getArtifactId(), version);
                    DependencyVersionSelector selector = new DependencyVersionSelector(UpgradeDependencyVersion.this.metadataFailures, this.gradleProject);
                    String selectedVersion = Optional.ofNullable(selector.select(gav, null, UpgradeDependencyVersion.this.newVersion, UpgradeDependencyVersion.this.versionPattern, ctx)).orElse(selector.select(gav, "classpath", UpgradeDependencyVersion.this.newVersion, UpgradeDependencyVersion.this.versionPattern, ctx));
                    if (selectedVersion == null) {
                        return a;
                    }
                    ((HashMap)this.getCursor().dropParentUntil(p -> p instanceof SourceFile).computeMessageIfAbsent(UpgradeDependencyVersion.NEW_VERSION_KEY, m -> new HashMap())).computeIfAbsent(new GroupArtifactVersion(ga.getGroupId(), ga.getArtifactId(), selectedVersion), it -> new HashSet()).addAll((Collection)gaEntry.getValue());
                    J.Literal newVersionLiteral = ChangeStringLiteral.withStringValue(literal, selectedVersion);
                    a = a.withAssignment((Expression)newVersionLiteral);
                }
            }
            catch (MavenDownloadingException e) {
                return (J.Assignment)e.warn((Tree)a);
            }
            return a;
        }

        public UpdateVariable(Map<String, Map<GroupArtifact, Set<String>>> versionVariableNames, GradleProject gradleProject) {
            this.versionVariableNames = versionVariableNames;
            this.gradleProject = gradleProject;
        }
    }
}

