/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle.plugins;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.SourceFile;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.gradle.IsBuildGradle;
import org.openrewrite.gradle.IsSettingsGradle;
import org.openrewrite.gradle.marker.GradleProject;
import org.openrewrite.gradle.marker.GradleSettings;
import org.openrewrite.gradle.plugins.AddPluginVisitor;
import org.openrewrite.gradle.util.ChangeStringLiteral;
import org.openrewrite.groovy.GroovyVisitor;
import org.openrewrite.groovy.tree.G;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.maven.MavenDownloadingException;
import org.openrewrite.maven.tree.MavenRepository;
import org.openrewrite.properties.PropertiesVisitor;
import org.openrewrite.properties.tree.Properties;
import org.openrewrite.semver.Semver;
import org.openrewrite.semver.VersionComparator;

public final class UpgradePluginVersion
extends ScanningRecipe<DependencyVersionState> {
    private static final String GRADLE_PROPERTIES_FILE_NAME = "gradle.properties";
    @Option(displayName="Plugin id", description="The `ID` part of `plugin { ID }`, as a glob expression.", example="com.jfrog.bintray")
    private final String pluginIdPattern;
    @Option(displayName="New version", description="An exact version number or node-style semver selector used to select the version number. You can also use `latest.release` for the latest available version and `latest.patch` if the current version is a valid semantic version. For more details, you can look at the documentation page of [version selectors](https://docs.openrewrite.org/reference/dependency-version-selectors). Defaults to `latest.release`.", example="29.X", required=false)
    @Nullable
    private final String newVersion;
    @Option(displayName="Version pattern", description="Allows version selection to be extended beyond the original Node Semver semantics. So for example,Setting 'version' to \"25-29\" can be paired with a metadata pattern of \"-jre\" to select Guava 29.0-jre", example="-jre", required=false)
    @Nullable
    private final String versionPattern;

    public String getDisplayName() {
        return "Update a Gradle plugin by id";
    }

    public String getDescription() {
        return "Update a Gradle plugin by id to a later version.";
    }

    public Validated<Object> validate() {
        Validated validated = super.validate();
        if (this.newVersion != null) {
            validated = validated.and(Semver.validate((String)this.newVersion, (String)this.versionPattern));
        }
        return validated;
    }

    public DependencyVersionState getInitialValue(ExecutionContext ctx) {
        return new DependencyVersionState();
    }

    public TreeVisitor<?, ExecutionContext> getScanner(final DependencyVersionState acc) {
        final MethodMatcher pluginMatcher = new MethodMatcher("PluginSpec id(..)", false);
        final MethodMatcher versionMatcher = new MethodMatcher("Plugin version(..)", false);
        GroovyVisitor<ExecutionContext> groovyVisitor = new GroovyVisitor<ExecutionContext>(){
            @Nullable
            private GradleProject gradleProject;
            @Nullable
            private GradleSettings gradleSettings;

            public J visitCompilationUnit(G.CompilationUnit cu, ExecutionContext ctx) {
                this.gradleProject = cu.getMarkers().findFirst(GradleProject.class).orElse(null);
                this.gradleSettings = cu.getMarkers().findFirst(GradleSettings.class).orElse(null);
                if (this.gradleProject == null && this.gradleSettings == null) {
                    return cu;
                }
                return super.visitCompilationUnit(cu, (Object)ctx);
            }

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation m = (J.MethodInvocation)super.visitMethodInvocation(method, (Object)ctx);
                if (!(versionMatcher.matches((MethodCall)m) && m.getSelect() instanceof J.MethodInvocation && pluginMatcher.matches(m.getSelect()))) {
                    return m;
                }
                List pluginArgs = ((J.MethodInvocation)m.getSelect()).getArguments();
                if (!(pluginArgs.get(0) instanceof J.Literal)) {
                    return m;
                }
                String pluginId = (String)((J.Literal)pluginArgs.get(0)).getValue();
                if (pluginId == null || !StringUtils.matchesGlob((String)pluginId, (String)UpgradePluginVersion.this.pluginIdPattern)) {
                    return m;
                }
                List versionArgs = m.getArguments();
                try {
                    if (versionArgs.get(0) instanceof J.Literal) {
                        String currentVersion = (String)((J.Literal)versionArgs.get(0)).getValue();
                        if (currentVersion == null) {
                            return m;
                        }
                        String resolvedVersion = AddPluginVisitor.resolvePluginVersion(pluginId, currentVersion, UpgradePluginVersion.this.newVersion, UpgradePluginVersion.this.versionPattern, this.getRepositories(), ctx).orElse(null);
                        acc.pluginIdToNewVersion.put(pluginId, resolvedVersion);
                    } else if (versionArgs.get(0) instanceof G.GString) {
                        G.GString gString = (G.GString)versionArgs.get(0);
                        if (gString == null || gString.getStrings().isEmpty() || !(gString.getStrings().get(0) instanceof G.GString.Value)) {
                            return m;
                        }
                        G.GString.Value gStringValue = (G.GString.Value)gString.getStrings().get(0);
                        String versionVariableName = gStringValue.getTree().toString();
                        String resolvedPluginVersion = AddPluginVisitor.resolvePluginVersion(pluginId, "0", UpgradePluginVersion.this.newVersion, UpgradePluginVersion.this.versionPattern, this.getRepositories(), ctx).orElse(null);
                        acc.versionPropNameToPluginId.put(versionVariableName, pluginId);
                        acc.pluginIdToNewVersion.put(pluginId, resolvedPluginVersion);
                    }
                }
                catch (MavenDownloadingException mavenDownloadingException) {
                    // empty catch block
                }
                return m;
            }

            private List<MavenRepository> getRepositories() {
                if (this.gradleSettings != null) {
                    return this.gradleSettings.getPluginRepositories();
                }
                assert (this.gradleProject != null);
                return this.gradleProject.getMavenPluginRepositories();
            }
        };
        return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{new IsBuildGradle(), new IsSettingsGradle()}), (TreeVisitor)groovyVisitor);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor(final DependencyVersionState acc) {
        final MethodMatcher pluginMatcher = new MethodMatcher("PluginSpec id(..)", false);
        final MethodMatcher versionMatcher = new MethodMatcher("Plugin version(..)", false);
        PropertiesVisitor<ExecutionContext> propertiesVisitor = new PropertiesVisitor<ExecutionContext>(){

            public boolean isAcceptable(SourceFile sourceFile, ExecutionContext ctx) {
                return super.isAcceptable(sourceFile, (Object)ctx) && sourceFile.getSourcePath().endsWith(UpgradePluginVersion.GRADLE_PROPERTIES_FILE_NAME);
            }

            public Properties visitEntry(Properties.Entry entry, ExecutionContext ctx) {
                if (acc.versionPropNameToPluginId.containsKey(entry.getKey())) {
                    String currentVersion = entry.getValue().getText();
                    String pluginId = acc.versionPropNameToPluginId.get(entry.getKey());
                    if (!StringUtils.isBlank((String)UpgradePluginVersion.this.newVersion)) {
                        String resolvedVersion = acc.pluginIdToNewVersion.get(pluginId);
                        VersionComparator versionComparator = (VersionComparator)Semver.validate((String)UpgradePluginVersion.this.newVersion, (String)UpgradePluginVersion.this.versionPattern).getValue();
                        if (versionComparator == null) {
                            return entry;
                        }
                        Optional finalVersion = versionComparator.upgrade(currentVersion, Collections.singletonList(resolvedVersion));
                        if (finalVersion.isPresent()) {
                            return entry.withValue(entry.getValue().withText(resolvedVersion));
                        }
                    }
                }
                return entry;
            }
        };
        GroovyVisitor<ExecutionContext> groovyVisitor = new GroovyVisitor<ExecutionContext>(){

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation m = (J.MethodInvocation)super.visitMethodInvocation(method, (Object)ctx);
                if (!(versionMatcher.matches((MethodCall)m) && m.getSelect() instanceof J.MethodInvocation && pluginMatcher.matches(m.getSelect()))) {
                    return m;
                }
                List pluginArgs = ((J.MethodInvocation)m.getSelect()).getArguments();
                if (!(pluginArgs.get(0) instanceof J.Literal)) {
                    return m;
                }
                String pluginId = (String)((J.Literal)pluginArgs.get(0)).getValue();
                if (pluginId == null || !StringUtils.matchesGlob((String)pluginId, (String)UpgradePluginVersion.this.pluginIdPattern)) {
                    return m;
                }
                List versionArgs = m.getArguments();
                if (!(versionArgs.get(0) instanceof J.Literal)) {
                    return m;
                }
                String currentVersion = (String)((J.Literal)versionArgs.get(0)).getValue();
                if (currentVersion == null) {
                    return m;
                }
                String resolvedVersion = acc.pluginIdToNewVersion.get(pluginId);
                if (resolvedVersion == null) {
                    return m;
                }
                return m.withArguments(ListUtils.map((List)versionArgs, v -> ChangeStringLiteral.withStringValue((J.Literal)v, resolvedVersion)));
            }
        };
        return Preconditions.or((TreeVisitor[])new TreeVisitor[]{propertiesVisitor, Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{new IsBuildGradle(), new IsSettingsGradle()}), (TreeVisitor)groovyVisitor)});
    }

    public UpgradePluginVersion(String pluginIdPattern, @Nullable String newVersion, @Nullable String versionPattern) {
        this.pluginIdPattern = pluginIdPattern;
        this.newVersion = newVersion;
        this.versionPattern = versionPattern;
    }

    public String getPluginIdPattern() {
        return this.pluginIdPattern;
    }

    @Nullable
    public String getNewVersion() {
        return this.newVersion;
    }

    @Nullable
    public String getVersionPattern() {
        return this.versionPattern;
    }

    @NonNull
    public String toString() {
        return "UpgradePluginVersion(pluginIdPattern=" + this.getPluginIdPattern() + ", newVersion=" + this.getNewVersion() + ", versionPattern=" + this.getVersionPattern() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpgradePluginVersion)) {
            return false;
        }
        UpgradePluginVersion other = (UpgradePluginVersion)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$pluginIdPattern = this.getPluginIdPattern();
        String other$pluginIdPattern = other.getPluginIdPattern();
        if (this$pluginIdPattern == null ? other$pluginIdPattern != null : !this$pluginIdPattern.equals(other$pluginIdPattern)) {
            return false;
        }
        String this$newVersion = this.getNewVersion();
        String other$newVersion = other.getNewVersion();
        if (this$newVersion == null ? other$newVersion != null : !this$newVersion.equals(other$newVersion)) {
            return false;
        }
        String this$versionPattern = this.getVersionPattern();
        String other$versionPattern = other.getVersionPattern();
        return !(this$versionPattern == null ? other$versionPattern != null : !this$versionPattern.equals(other$versionPattern));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof UpgradePluginVersion;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $pluginIdPattern = this.getPluginIdPattern();
        result = result * 59 + ($pluginIdPattern == null ? 43 : $pluginIdPattern.hashCode());
        String $newVersion = this.getNewVersion();
        result = result * 59 + ($newVersion == null ? 43 : $newVersion.hashCode());
        String $versionPattern = this.getVersionPattern();
        result = result * 59 + ($versionPattern == null ? 43 : $versionPattern.hashCode());
        return result;
    }

    public static class DependencyVersionState {
        Map<String, String> versionPropNameToPluginId = new HashMap<String, String>();
        Map<String, String> pluginIdToNewVersion = new HashMap<String, String>();
    }
}

