/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Incubating;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.gradle.DependencyVersionSelector;
import org.openrewrite.gradle.GradleParser;
import org.openrewrite.gradle.marker.GradleDependencyConfiguration;
import org.openrewrite.gradle.marker.GradleProject;
import org.openrewrite.gradle.search.FindGradleProject;
import org.openrewrite.groovy.GroovyIsoVisitor;
import org.openrewrite.groovy.GroovyVisitor;
import org.openrewrite.groovy.tree.G;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.format.BlankLinesVisitor;
import org.openrewrite.java.search.FindMethods;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.marker.Markers;
import org.openrewrite.marker.Markup;
import org.openrewrite.maven.MavenDownloadingException;
import org.openrewrite.maven.table.MavenMetadataFailures;
import org.openrewrite.maven.tree.GroupArtifact;
import org.openrewrite.maven.tree.GroupArtifactVersion;
import org.openrewrite.maven.tree.ResolvedDependency;
import org.openrewrite.semver.DependencyMatcher;
import org.openrewrite.semver.Semver;

@Incubating(since="8.18.0")
public final class UpgradeTransitiveDependencyVersion
extends Recipe {
    private static final MethodMatcher DEPENDENCIES_DSL_MATCHER = new MethodMatcher("RewriteGradleProject dependencies(..)");
    private static final MethodMatcher CONSTRAINTS_MATCHER = new MethodMatcher("org.gradle.api.artifacts.dsl.DependencyHandler constraints(..)", true);
    private static final String CONSTRAINT_MATCHER = "org.gradle.api.artifacts.dsl.DependencyHandler *(..)";
    private final transient MavenMetadataFailures metadataFailures = new MavenMetadataFailures((Recipe)this);
    @Option(displayName="Group", description="The first part of a dependency coordinate `com.google.guava:guava:VERSION`. This can be a glob expression.", example="com.fasterxml.jackson*")
    private final String groupId;
    @Option(displayName="Artifact", description="The second part of a dependency coordinate `com.google.guava:guava:VERSION`. This can be a glob expression.", example="jackson-module*")
    private final String artifactId;
    @Option(displayName="Version", description="An exact version number or node-style semver selector used to select the version number. You can also use `latest.release` for the latest available version and `latest.patch` if the current version is a valid semantic version. For more details, you can look at the documentation page of [version selectors](https://docs.openrewrite.org/reference/dependency-version-selectors). Defaults to `latest.release`.", example="29.X", required=false)
    @Nullable
    private final String version;
    @Option(displayName="Version pattern", description="Allows version selection to be extended beyond the original Node Semver semantics. So for example,Setting 'newVersion' to \"25-29\" can be paired with a metadata pattern of \"-jre\" to select Guava 29.0-jre", example="-jre", required=false)
    @Nullable
    private final String versionPattern;
    @Option(displayName="Because", description="The reason for upgrading the transitive dependency. For example, we could be responding to a vulnerability.", required=false, example="CVE-2021-1234")
    @Nullable
    private final String because;

    public String getDisplayName() {
        return "Upgrade transitive Gradle dependencies";
    }

    public String getDescription() {
        return "Upgrades the version of a transitive dependency in a Gradle build file. There are many ways to do this in Gradle, so the mechanism for upgrading a transitive dependency must be considered carefully depending on your style of dependency management.";
    }

    public Validated<Object> validate() {
        Validated validated = super.validate();
        if (this.version != null) {
            validated = validated.and(Semver.validate((String)this.version, (String)this.versionPattern));
        }
        return validated;
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final DependencyMatcher dependencyMatcher = new DependencyMatcher(this.groupId, this.artifactId, null);
        return Preconditions.check((Recipe)new FindGradleProject(FindGradleProject.SearchCriteria.Marker), (TreeVisitor)new GroovyVisitor<ExecutionContext>(){
            GradleProject gradleProject;

            public J visitCompilationUnit(G.CompilationUnit cu, ExecutionContext ctx) {
                this.gradleProject = (GradleProject)cu.getMarkers().findFirst(GradleProject.class).orElseThrow(() -> new IllegalStateException("Unable to find GradleProject marker."));
                HashMap<GroupArtifact, Map> toUpdate = new HashMap<GroupArtifact, Map>();
                DependencyVersionSelector versionSelector = new DependencyVersionSelector(UpgradeTransitiveDependencyVersion.this.metadataFailures, this.gradleProject);
                for (GradleDependencyConfiguration gradleDependencyConfiguration : this.gradleProject.getConfigurations()) {
                    for (ResolvedDependency resolved : gradleDependencyConfiguration.getResolved()) {
                        if (resolved.getDepth() <= 0 || !dependencyMatcher.matches(resolved.getGroupId(), resolved.getArtifactId(), resolved.getVersion())) continue;
                        try {
                            GradleDependencyConfiguration constraintConfig;
                            String selected = versionSelector.select(resolved.getGav(), gradleDependencyConfiguration.getName(), UpgradeTransitiveDependencyVersion.this.version, UpgradeTransitiveDependencyVersion.this.versionPattern, ctx);
                            if (selected == null || resolved.getVersion().equals(selected) || (constraintConfig = this.constraintConfiguration(gradleDependencyConfiguration)) == null) continue;
                            toUpdate.merge(new GroupArtifact(resolved.getGroupId(), resolved.getArtifactId()), Collections.singletonMap(constraintConfig, selected), (existing, update) -> {
                                HashMap all = new HashMap(existing);
                                all.putAll(update);
                                all.keySet().removeIf(c -> {
                                    if (c == null) {
                                        return true;
                                    }
                                    for (GradleDependencyConfiguration config : all.keySet()) {
                                        if (c.allExtendsFrom().contains(config)) {
                                            return true;
                                        }
                                        if (c.getName().equals("runtimeOnly") && config.getName().equals("implementation")) {
                                            return true;
                                        }
                                        if (!c.getName().equals("testRuntimeOnly") || !config.getName().equals("testImplementation") && !config.getName().equals("implementation")) continue;
                                        return true;
                                    }
                                    return false;
                                });
                                return all;
                            });
                        }
                        catch (MavenDownloadingException e) {
                            return (J)Markup.warn((Tree)cu, (Throwable)e);
                        }
                    }
                }
                if (!toUpdate.isEmpty()) {
                    cu = (G.CompilationUnit)Preconditions.check((TreeVisitor)Preconditions.not((TreeVisitor)new UsesMethod(CONSTRAINTS_MATCHER)), (TreeVisitor)new AddConstraintsBlock()).visitNonNull((Tree)cu, (Object)ctx);
                    for (Map.Entry entry : toUpdate.entrySet()) {
                        Map configs = (Map)entry.getValue();
                        for (Map.Entry config : configs.entrySet()) {
                            cu = (G.CompilationUnit)new AddConstraint(((GradleDependencyConfiguration)config.getKey()).getName(), new GroupArtifactVersion(((GroupArtifact)entry.getKey()).getGroupId(), ((GroupArtifact)entry.getKey()).getArtifactId(), (String)config.getValue()), UpgradeTransitiveDependencyVersion.this.because).visitNonNull((Tree)cu, ctx);
                        }
                    }
                }
                return cu;
            }

            @Nullable
            private GradleDependencyConfiguration constraintConfiguration(GradleDependencyConfiguration config) {
                String constraintConfigName = null;
                switch (config.getName()) {
                    case "compileClasspath": {
                        constraintConfigName = "implementation";
                        break;
                    }
                    case "runtimeClasspath": {
                        constraintConfigName = "runtimeOnly";
                        break;
                    }
                    case "testCompileClasspath": {
                        constraintConfigName = "testImplementation";
                        break;
                    }
                    case "testRuntimeClasspath": {
                        constraintConfigName = "testRuntimeOnly";
                    }
                }
                for (GradleDependencyConfiguration extended : config.getExtendsFrom()) {
                    if (!extended.getName().equals(constraintConfigName)) continue;
                    return extended;
                }
                return null;
            }
        });
    }

    public UpgradeTransitiveDependencyVersion(String groupId, String artifactId, @Nullable String version, @Nullable String versionPattern, @Nullable String because) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.versionPattern = versionPattern;
        this.because = because;
    }

    public MavenMetadataFailures getMetadataFailures() {
        return this.metadataFailures;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    @Nullable
    public String getVersion() {
        return this.version;
    }

    @Nullable
    public String getVersionPattern() {
        return this.versionPattern;
    }

    @Nullable
    public String getBecause() {
        return this.because;
    }

    @NonNull
    public String toString() {
        return "UpgradeTransitiveDependencyVersion(metadataFailures=" + this.getMetadataFailures() + ", groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", version=" + this.getVersion() + ", versionPattern=" + this.getVersionPattern() + ", because=" + this.getBecause() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpgradeTransitiveDependencyVersion)) {
            return false;
        }
        UpgradeTransitiveDependencyVersion other = (UpgradeTransitiveDependencyVersion)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$artifactId = this.getArtifactId();
        String other$artifactId = other.getArtifactId();
        if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$versionPattern = this.getVersionPattern();
        String other$versionPattern = other.getVersionPattern();
        if (this$versionPattern == null ? other$versionPattern != null : !this$versionPattern.equals(other$versionPattern)) {
            return false;
        }
        String this$because = this.getBecause();
        String other$because = other.getBecause();
        return !(this$because == null ? other$because != null : !this$because.equals(other$because));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof UpgradeTransitiveDependencyVersion;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $artifactId = this.getArtifactId();
        result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $versionPattern = this.getVersionPattern();
        result = result * 59 + ($versionPattern == null ? 43 : $versionPattern.hashCode());
        String $because = this.getBecause();
        result = result * 59 + ($because == null ? 43 : $because.hashCode());
        return result;
    }

    private static class AddConstraint
    extends GroovyIsoVisitor<ExecutionContext> {
        private final String config;
        private final GroupArtifactVersion gav;
        @Nullable
        private final String because;

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            if (CONSTRAINTS_MATCHER.matches((MethodCall)method)) {
                J.MethodInvocation m = super.visitMethodInvocation(method, (Object)ctx);
                boolean constraintExists = FindMethods.find((J)m, (String)UpgradeTransitiveDependencyVersion.CONSTRAINT_MATCHER, (boolean)true).stream().filter(J.MethodInvocation.class::isInstance).map(J.MethodInvocation.class::cast).anyMatch(c -> c.getSimpleName().equals(this.config) && c.getArguments().stream().anyMatch(arg -> arg instanceof J.Literal && this.gav.toString().equals(((J.Literal)arg).getValue())));
                if (constraintExists) {
                    return m;
                }
                J withConstraint = (J)GradleParser.builder().build().parse(new String[]{String.format("plugin { id 'java' }\ndependencies { constraints {\n    %s('%s')%s\n}}", this.config, this.gav, this.because == null ? "" : String.format(" {\n   because '%s'\n}", this.because))}).findFirst().orElseThrow(() -> new IllegalStateException("Unable to parse constraint"));
                J.MethodInvocation constraint = FindMethods.find((J)withConstraint, (String)UpgradeTransitiveDependencyVersion.CONSTRAINT_MATCHER, (boolean)true).stream().filter(J.MethodInvocation.class::isInstance).map(J.MethodInvocation.class::cast).filter(m2 -> m2.getSimpleName().equals(this.config)).findFirst().orElseThrow(() -> new IllegalStateException("Unable to find constraint")).withMarkers(Markers.EMPTY);
                return (J.MethodInvocation)this.autoFormat((J)m.withArguments(ListUtils.mapFirst((List)m.getArguments(), arg_0 -> AddConstraint.lambda$visitMethodInvocation$5(m, (Statement)constraint, arg_0))), (J)constraint, ctx, this.getCursor().getParentOrThrow());
            }
            return super.visitMethodInvocation(method, (Object)ctx);
        }

        public AddConstraint(String config, GroupArtifactVersion gav, @Nullable String because) {
            this.config = config;
            this.gav = gav;
            this.because = because;
        }

        private static /* synthetic */ Expression lambda$visitMethodInvocation$5(J.MethodInvocation m, Statement constraint, Expression arg) {
            J.Lambda dependencies = (J.Lambda)arg;
            if (!(dependencies.getBody() instanceof J.Block)) {
                return m;
            }
            J.Block body = (J.Block)dependencies.getBody();
            return dependencies.withBody((J)body.withStatements(ListUtils.concat((Object)constraint, (List)body.getStatements())));
        }
    }

    private static class AddConstraintsBlock
    extends GroovyIsoVisitor<ExecutionContext> {
        private AddConstraintsBlock() {
        }

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            J.MethodInvocation m = super.visitMethodInvocation(method, (Object)ctx);
            if (DEPENDENCIES_DSL_MATCHER.matches((MethodCall)method)) {
                J withConstraints = (J)GradleParser.builder().build().parse(new String[]{"plugins { id 'java' }\ndependencies {\n    constraints {\n    }\n}\n"}).findFirst().orElseThrow(() -> new IllegalStateException("Unable to parse constraints block"));
                J.MethodInvocation constraints = FindMethods.find((J)withConstraints, (String)"org.gradle.api.artifacts.dsl.DependencyHandler constraints(..)", (boolean)true).stream().filter(J.MethodInvocation.class::isInstance).map(J.MethodInvocation.class::cast).filter(m2 -> m2.getSimpleName().equals("constraints")).findFirst().orElseThrow(() -> new IllegalStateException("Unable to find constraints block")).withMarkers(Markers.EMPTY);
                return (J.MethodInvocation)this.autoFormat((J)m.withArguments(ListUtils.mapFirst((List)m.getArguments(), arg_0 -> AddConstraintsBlock.lambda$visitMethodInvocation$4(m, (Statement)constraints, arg_0))), (J)constraints, ctx, this.getCursor().getParentOrThrow());
            }
            return m;
        }

        private static /* synthetic */ Expression lambda$visitMethodInvocation$4(J.MethodInvocation m, Statement constraints, Expression arg) {
            J.Lambda dependencies = (J.Lambda)arg;
            if (!(dependencies.getBody() instanceof J.Block)) {
                return m;
            }
            J.Block body = (J.Block)dependencies.getBody();
            List statements = ListUtils.mapFirst((List)body.getStatements(), stat -> (Statement)stat.withPrefix(stat.getPrefix().withWhitespace(BlankLinesVisitor.minimumLines((String)stat.getPrefix().getWhitespace(), (int)1))));
            return dependencies.withBody((J)body.withStatements(ListUtils.concat((Object)constraints, (List)statements)));
        }
    }
}

