/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle.search;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.gradle.IsBuildGradle;
import org.openrewrite.gradle.IsSettingsGradle;
import org.openrewrite.gradle.tree.GradlePlugin;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.marker.SearchResult;

public final class FindPlugins
extends Recipe {
    @Option(displayName="Plugin id", description="The `ID` part of `plugin { ID }`.", example="`com.jfrog.bintray`")
    private final String pluginId;

    public String getDisplayName() {
        return "Find Gradle plugin";
    }

    public String getDescription() {
        return "Find a Gradle plugin by id.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final MethodMatcher pluginMatcher = new MethodMatcher("PluginSpec id(..)", false);
        return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{new IsBuildGradle(), new IsSettingsGradle()}), (TreeVisitor)new JavaVisitor<ExecutionContext>(){

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                if (pluginMatcher.matches((MethodCall)method) && method.getArguments().get(0) instanceof J.Literal && FindPlugins.this.pluginId.equals(((J.Literal)method.getArguments().get(0)).getValue())) {
                    return (J)SearchResult.found((Tree)method);
                }
                return super.visitMethodInvocation(method, (Object)ctx);
            }
        });
    }

    public static List<GradlePlugin> find(J j, String pluginIdPattern) {
        List plugins = (List)TreeVisitor.collect(new FindPlugins(pluginIdPattern).getVisitor(), (Tree)j, new ArrayList(), J.MethodInvocation.class, Function.identity());
        MethodMatcher idMatcher = new MethodMatcher("PluginSpec id(..)", false);
        MethodMatcher versionMatcher = new MethodMatcher("Plugin version(..)", false);
        List pluginsWithVersion = plugins.stream().flatMap(plugin -> {
            if (versionMatcher.matches((MethodCall)plugin) && idMatcher.matches(plugin.getSelect())) {
                return Stream.of(new GradlePlugin((J.MethodInvocation)plugin, Objects.requireNonNull(((J.Literal)Objects.requireNonNull((J.MethodInvocation)plugin.getSelect()).getArguments().get(0)).getValue()).toString(), Objects.requireNonNull(((J.Literal)plugin.getArguments().get(0)).getValue()).toString()));
            }
            return Stream.empty();
        }).collect(Collectors.toList());
        List pluginsWithoutVersion = plugins.stream().flatMap(plugin -> {
            if (idMatcher.matches((MethodCall)plugin) && pluginsWithVersion.stream().noneMatch(it -> it.getPluginId().equals(plugin.getSimpleName()))) {
                return Stream.of(new GradlePlugin((J.MethodInvocation)plugin, Objects.requireNonNull(((J.Literal)Objects.requireNonNull(plugin).getArguments().get(0)).getValue()).toString(), null));
            }
            return Stream.empty();
        }).collect(Collectors.toList());
        ArrayList<GradlePlugin> result = new ArrayList<GradlePlugin>(pluginsWithVersion.size() + pluginsWithoutVersion.size());
        result.addAll(pluginsWithVersion);
        result.addAll(pluginsWithoutVersion);
        return result;
    }

    public FindPlugins(String pluginId) {
        this.pluginId = pluginId;
    }

    public String getPluginId() {
        return this.pluginId;
    }

    @NonNull
    public String toString() {
        return "FindPlugins(pluginId=" + this.getPluginId() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindPlugins)) {
            return false;
        }
        FindPlugins other = (FindPlugins)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$pluginId = this.getPluginId();
        String other$pluginId = other.getPluginId();
        return !(this$pluginId == null ? other$pluginId != null : !this$pluginId.equals(other$pluginId));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof FindPlugins;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $pluginId = this.getPluginId();
        result = result * 59 + ($pluginId == null ? 43 : $pluginId.hashCode());
        return result;
    }
}

