/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle.plugins;

import java.util.List;
import java.util.Optional;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.gradle.IsBuildGradle;
import org.openrewrite.gradle.IsSettingsGradle;
import org.openrewrite.gradle.marker.GradleProject;
import org.openrewrite.gradle.marker.GradleSettings;
import org.openrewrite.gradle.plugins.AddPluginVisitor;
import org.openrewrite.groovy.GroovyVisitor;
import org.openrewrite.groovy.tree.G;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.maven.MavenDownloadingException;
import org.openrewrite.maven.table.MavenMetadataFailures;
import org.openrewrite.maven.tree.MavenRepository;
import org.openrewrite.semver.Semver;

public final class UpgradePluginVersion
extends Recipe {
    private final transient MavenMetadataFailures metadataFailures = new MavenMetadataFailures((Recipe)this);
    @Option(displayName="Plugin id", description="The `ID` part of `plugin { ID }`, as a glob expression.", example="com.jfrog.bintray")
    private final String pluginIdPattern;
    @Option(displayName="New version", description="An exact version number or node-style semver selector used to select the version number. You can also use `latest.release` for the latest available version and `latest.patch` if the current version is a valid semantic version. For more details, you can look at the documentation page of [version selectors](https://docs.openrewrite.org/reference/dependency-version-selectors). Defaults to `latest.release`.", example="29.X", required=false)
    @Nullable
    private final String newVersion;
    @Option(displayName="Version pattern", description="Allows version selection to be extended beyond the original Node Semver semantics. So for example,Setting 'version' to \"25-29\" can be paired with a metadata pattern of \"-jre\" to select Guava 29.0-jre", example="-jre", required=false)
    @Nullable
    private final String versionPattern;

    public String getDisplayName() {
        return "Update a Gradle plugin by id";
    }

    public String getDescription() {
        return "Update a Gradle plugin by id to a later version.";
    }

    public Validated<Object> validate() {
        Validated validated = super.validate();
        if (this.newVersion != null) {
            validated = validated.and(Semver.validate((String)this.newVersion, (String)this.versionPattern));
        }
        return validated;
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final MethodMatcher pluginMatcher = new MethodMatcher("PluginSpec id(..)", false);
        final MethodMatcher versionMatcher = new MethodMatcher("Plugin version(..)", false);
        return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{new IsBuildGradle(), new IsSettingsGradle()}), (TreeVisitor)new GroovyVisitor<ExecutionContext>(){
            private GradleProject gradleProject;
            private GradleSettings gradleSettings;

            public J visitCompilationUnit(G.CompilationUnit cu, ExecutionContext ctx) {
                Optional maybeGradleProject = cu.getMarkers().findFirst(GradleProject.class);
                Optional maybeGradleSettings = cu.getMarkers().findFirst(GradleSettings.class);
                if (!maybeGradleProject.isPresent() && !maybeGradleSettings.isPresent()) {
                    return cu;
                }
                this.gradleProject = maybeGradleProject.orElse(null);
                this.gradleSettings = maybeGradleSettings.orElse(null);
                return super.visitCompilationUnit(cu, (Object)ctx);
            }

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation m = (J.MethodInvocation)super.visitMethodInvocation(method, (Object)ctx);
                if (!(versionMatcher.matches((MethodCall)m) && m.getSelect() instanceof J.MethodInvocation && pluginMatcher.matches(m.getSelect()))) {
                    return m;
                }
                List pluginArgs = ((J.MethodInvocation)m.getSelect()).getArguments();
                if (!(pluginArgs.get(0) instanceof J.Literal)) {
                    return m;
                }
                String pluginId = (String)((J.Literal)pluginArgs.get(0)).getValue();
                if (pluginId == null || !StringUtils.matchesGlob((String)pluginId, (String)UpgradePluginVersion.this.pluginIdPattern)) {
                    return m;
                }
                List versionArgs = m.getArguments();
                if (!(versionArgs.get(0) instanceof J.Literal)) {
                    return m;
                }
                String currentVersion = (String)((J.Literal)versionArgs.get(0)).getValue();
                if (currentVersion == null) {
                    return m;
                }
                try {
                    Optional<String> version = AddPluginVisitor.resolvePluginVersion(pluginId, currentVersion, UpgradePluginVersion.this.newVersion, UpgradePluginVersion.this.versionPattern, this.getRepositories(), ctx);
                    J.MethodInvocation finalM = m;
                    m = version.map(upgradeVersion -> finalM.withArguments(ListUtils.map((List)versionArgs, v -> {
                        J.Literal versionLiteral = (J.Literal)v;
                        assert (versionLiteral.getValueSource() != null);
                        return versionLiteral.withValue(upgradeVersion).withValueSource(versionLiteral.getValueSource().replace(currentVersion, (CharSequence)upgradeVersion));
                    }))).orElse(m);
                    return m;
                }
                catch (MavenDownloadingException e) {
                    return (J)e.warn((Tree)m);
                }
            }

            private List<MavenRepository> getRepositories() {
                if (this.gradleSettings != null) {
                    return this.gradleSettings.getPluginRepositories();
                }
                return this.gradleProject.getMavenPluginRepositories();
            }
        });
    }

    public UpgradePluginVersion(String pluginIdPattern, @Nullable String newVersion, @Nullable String versionPattern) {
        this.pluginIdPattern = pluginIdPattern;
        this.newVersion = newVersion;
        this.versionPattern = versionPattern;
    }

    public MavenMetadataFailures getMetadataFailures() {
        return this.metadataFailures;
    }

    public String getPluginIdPattern() {
        return this.pluginIdPattern;
    }

    @Nullable
    public String getNewVersion() {
        return this.newVersion;
    }

    @Nullable
    public String getVersionPattern() {
        return this.versionPattern;
    }

    @NonNull
    public String toString() {
        return "UpgradePluginVersion(metadataFailures=" + this.getMetadataFailures() + ", pluginIdPattern=" + this.getPluginIdPattern() + ", newVersion=" + this.getNewVersion() + ", versionPattern=" + this.getVersionPattern() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpgradePluginVersion)) {
            return false;
        }
        UpgradePluginVersion other = (UpgradePluginVersion)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$pluginIdPattern = this.getPluginIdPattern();
        String other$pluginIdPattern = other.getPluginIdPattern();
        if (this$pluginIdPattern == null ? other$pluginIdPattern != null : !this$pluginIdPattern.equals(other$pluginIdPattern)) {
            return false;
        }
        String this$newVersion = this.getNewVersion();
        String other$newVersion = other.getNewVersion();
        if (this$newVersion == null ? other$newVersion != null : !this$newVersion.equals(other$newVersion)) {
            return false;
        }
        String this$versionPattern = this.getVersionPattern();
        String other$versionPattern = other.getVersionPattern();
        return !(this$versionPattern == null ? other$versionPattern != null : !this$versionPattern.equals(other$versionPattern));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof UpgradePluginVersion;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $pluginIdPattern = this.getPluginIdPattern();
        result = result * 59 + ($pluginIdPattern == null ? 43 : $pluginIdPattern.hashCode());
        String $newVersion = this.getNewVersion();
        result = result * 59 + ($newVersion == null ? 43 : $newVersion.hashCode());
        String $versionPattern = this.getVersionPattern();
        result = result * 59 + ($versionPattern == null ? 43 : $versionPattern.hashCode());
        return result;
    }
}

