/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.gradle.AddDependencyVisitor;
import org.openrewrite.gradle.marker.GradleDependencyConfiguration;
import org.openrewrite.gradle.marker.GradleProject;
import org.openrewrite.gradle.search.FindGradleProject;
import org.openrewrite.gradle.util.ChangeStringLiteral;
import org.openrewrite.gradle.util.Dependency;
import org.openrewrite.gradle.util.DependencyStringNotationConverter;
import org.openrewrite.groovy.GroovyIsoVisitor;
import org.openrewrite.groovy.GroovyVisitor;
import org.openrewrite.groovy.tree.G;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Markup;
import org.openrewrite.maven.MavenDownloadingException;
import org.openrewrite.maven.MavenDownloadingExceptions;
import org.openrewrite.maven.internal.MavenPomDownloader;
import org.openrewrite.maven.table.MavenMetadataFailures;
import org.openrewrite.maven.tree.GroupArtifact;
import org.openrewrite.maven.tree.GroupArtifactVersion;
import org.openrewrite.maven.tree.Pom;
import org.openrewrite.maven.tree.ResolvedGroupArtifactVersion;
import org.openrewrite.maven.tree.ResolvedPom;
import org.openrewrite.maven.tree.Scope;
import org.openrewrite.semver.DependencyMatcher;
import org.openrewrite.semver.Semver;

public final class UpgradeDependencyVersion
extends Recipe {
    private static final String VERSION_VARIABLE_KEY = "VERSION_VARIABLE";
    private static final String NEW_VERSION_KEY = "NEW_VERSION";
    private final MavenMetadataFailures metadataFailures = new MavenMetadataFailures((Recipe)this);
    @Option(displayName="Group", description="The first part of a dependency coordinate `com.google.guava:guava:VERSION`. This can be a glob expression.", example="com.fasterxml.jackson*")
    private final String groupId;
    @Option(displayName="Artifact", description="The second part of a dependency coordinate `com.google.guava:guava:VERSION`. This can be a glob expression.", example="jackson-module*")
    private final String artifactId;
    @Option(displayName="New version", description="An exact version number or node-style semver selector used to select the version number. You can also use `latest.release` for the latest available version and `latest.patch` if the current version is a valid semantic version. For more details, you can look at the documentation page of [version selectors](https://docs.openrewrite.org/reference/dependency-version-selectors). Defaults to `latest.release`.", example="29.X", required=false)
    @Nullable
    private final String newVersion;
    @Option(displayName="Version pattern", description="Allows version selection to be extended beyond the original Node Semver semantics. So for example,Setting 'newVersion' to \"25-29\" can be paired with a metadata pattern of \"-jre\" to select Guava 29.0-jre", example="-jre", required=false)
    @Nullable
    private final String versionPattern;
    private static final String UPDATE_VERSION_ERROR_KEY = "UPDATE_VERSION_ERROR_KEY";

    public String getDisplayName() {
        return "Upgrade Gradle dependency versions";
    }

    public String getInstanceNameSuffix() {
        return String.format("`%s:%s`", this.groupId, this.artifactId);
    }

    public String getDescription() {
        return "Upgrade the version of a dependency in a build.gradle file. Supports updating dependency declarations of various forms:\n* `String` notation: `\"group:artifact:version\"` \n* `Map` notation: `group: 'group', name: 'artifact', version: 'version'`\nCan update version numbers which are defined earlier in the same file in variable declarations.";
    }

    public Validated<Object> validate() {
        Validated validated = super.validate();
        if (this.newVersion != null) {
            validated = validated.and(Semver.validate((String)this.newVersion, (String)this.versionPattern));
        }
        return validated;
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final MethodMatcher dependencyDsl = new MethodMatcher("DependencyHandlerSpec *(..)");
        final DependencyMatcher dependencyMatcher = new DependencyMatcher(this.groupId, this.artifactId, null);
        return Preconditions.check((Recipe)new FindGradleProject(FindGradleProject.SearchCriteria.Marker), (TreeVisitor)new GroovyVisitor<ExecutionContext>(){

            public J postVisit(J tree, ExecutionContext ctx) {
                if (tree instanceof JavaSourceFile) {
                    Map versionUpdates;
                    JavaSourceFile cu = (JavaSourceFile)tree;
                    Map variableNames = (Map)this.getCursor().getMessage(UpgradeDependencyVersion.VERSION_VARIABLE_KEY);
                    if (variableNames != null) {
                        Optional maybeGp = cu.getMarkers().findFirst(GradleProject.class);
                        if (!maybeGp.isPresent()) {
                            return cu;
                        }
                        cu = (JavaSourceFile)new UpdateVariable(variableNames, (GradleProject)maybeGp.get()).visitNonNull((Tree)cu, ctx);
                    }
                    if ((versionUpdates = (Map)this.getCursor().getMessage(UpgradeDependencyVersion.NEW_VERSION_KEY)) != null) {
                        Optional maybeGp = cu.getMarkers().findFirst(GradleProject.class);
                        if (!maybeGp.isPresent()) {
                            return cu;
                        }
                        GradleProject newGp = (GradleProject)maybeGp.get();
                        for (Map.Entry gavToConfigurations : versionUpdates.entrySet()) {
                            newGp = UpgradeDependencyVersion.replaceVersion(newGp, ctx, (GroupArtifactVersion)gavToConfigurations.getKey(), (Set)gavToConfigurations.getValue());
                        }
                        cu = (JavaSourceFile)cu.withMarkers(cu.getMarkers().removeByType(GradleProject.class).add((Marker)newGp));
                    }
                    return cu;
                }
                return tree;
            }

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation m = (J.MethodInvocation)super.visitMethodInvocation(method, (Object)ctx);
                if (dependencyDsl.matches((MethodCall)m)) {
                    List depArgs = m.getArguments();
                    if (depArgs.get(0) instanceof J.Literal || depArgs.get(0) instanceof G.GString || depArgs.get(0) instanceof G.MapEntry) {
                        m = this.updateDependency(m, ctx);
                    } else if (depArgs.get(0) instanceof J.MethodInvocation && (((J.MethodInvocation)depArgs.get(0)).getSimpleName().equals("platform") || ((J.MethodInvocation)depArgs.get(0)).getSimpleName().equals("enforcedPlatform"))) {
                        m = m.withArguments(ListUtils.mapFirst((List)depArgs, platform -> this.updateDependency((J.MethodInvocation)platform, ctx)));
                    }
                }
                return m;
            }

            private J.MethodInvocation updateDependency(J.MethodInvocation method, ExecutionContext ctx) {
                List depArgs;
                J.MethodInvocation m = method;
                m = m.withArguments(ListUtils.map((List)m.getArguments(), arg -> {
                    if (arg instanceof G.GString) {
                        G.GString gString = (G.GString)arg;
                        List strings = gString.getStrings();
                        if (strings.size() != 2 || !(strings.get(0) instanceof J.Literal) || !(strings.get(1) instanceof G.GString.Value)) {
                            return arg;
                        }
                        J.Literal groupArtifact = (J.Literal)strings.get(0);
                        G.GString.Value versionValue = (G.GString.Value)strings.get(1);
                        if (!(versionValue.getTree() instanceof J.Identifier) || !(groupArtifact.getValue() instanceof String)) {
                            return arg;
                        }
                        Dependency dep = DependencyStringNotationConverter.parse((String)groupArtifact.getValue());
                        if (dependencyMatcher.matches(dep.getGroupId(), dep.getArtifactId())) {
                            String versionVariableName = ((J.Identifier)versionValue.getTree()).getSimpleName();
                            ((HashMap)this.getCursor().dropParentUntil(p -> p instanceof SourceFile).computeMessageIfAbsent(UpgradeDependencyVersion.VERSION_VARIABLE_KEY, v -> new HashMap())).computeIfAbsent(versionVariableName, it -> new HashMap()).computeIfAbsent(new GroupArtifact(dep.getGroupId(), dep.getArtifactId()), it -> new HashSet()).add(method.getSimpleName());
                        }
                    } else if (arg instanceof J.Literal) {
                        J.Literal literal = (J.Literal)arg;
                        String gav = (String)literal.getValue();
                        if (gav == null) {
                            this.getCursor().putMessage(UpgradeDependencyVersion.UPDATE_VERSION_ERROR_KEY, (Object)new IllegalStateException("Unable to update version"));
                            return arg;
                        }
                        Dependency dep = DependencyStringNotationConverter.parse(gav);
                        if (dependencyMatcher.matches(dep.getGroupId(), dep.getArtifactId()) && dep.getVersion() != null && !dep.getVersion().startsWith("$")) {
                            GradleProject gradleProject = (GradleProject)((JavaSourceFile)this.getCursor().firstEnclosingOrThrow(JavaSourceFile.class)).getMarkers().findFirst(GradleProject.class).orElseThrow(() -> new IllegalArgumentException("Gradle files are expected to have a GradleProject marker."));
                            String version = dep.getVersion();
                            try {
                                String newVersion;
                                String string = newVersion = "classpath".equals(method.getSimpleName()) ? UpgradeDependencyVersion.this.findNewerPluginVersion(dep.getGroupId(), dep.getArtifactId(), version, gradleProject, ctx) : UpgradeDependencyVersion.this.findNewerProjectDependencyVersion(dep.getGroupId(), dep.getArtifactId(), version, gradleProject, ctx);
                                if (newVersion == null || version.equals(newVersion)) {
                                    return arg;
                                }
                                ((HashMap)this.getCursor().dropParentUntil(p -> p instanceof SourceFile).computeMessageIfAbsent(UpgradeDependencyVersion.NEW_VERSION_KEY, it -> new HashMap())).computeIfAbsent(new GroupArtifactVersion(dep.getGroupId(), dep.getArtifactId(), newVersion), it -> new HashSet()).add(method.getSimpleName());
                                String newGav = dep.withVersion(newVersion).toStringNotation();
                                return literal.withValue((Object)newGav).withValueSource(Objects.requireNonNull(literal.getValueSource()).replace(gav, newGav));
                            }
                            catch (MavenDownloadingException e) {
                                this.getCursor().putMessage(UpgradeDependencyVersion.UPDATE_VERSION_ERROR_KEY, (Object)e);
                            }
                        }
                    }
                    return arg;
                }));
                Exception err = (Exception)this.getCursor().pollMessage(UpgradeDependencyVersion.UPDATE_VERSION_ERROR_KEY);
                if (err != null) {
                    m = (J.MethodInvocation)Markup.warn((Tree)m, (Throwable)err);
                }
                if ((depArgs = m.getArguments()).size() >= 3 && depArgs.get(0) instanceof G.MapEntry && depArgs.get(1) instanceof G.MapEntry && depArgs.get(2) instanceof G.MapEntry) {
                    Expression groupValue = ((G.MapEntry)depArgs.get(0)).getValue();
                    Expression artifactValue = ((G.MapEntry)depArgs.get(1)).getValue();
                    if (!(groupValue instanceof J.Literal) || !(artifactValue instanceof J.Literal)) {
                        return m;
                    }
                    J.Literal groupLiteral = (J.Literal)groupValue;
                    J.Literal artifactLiteral = (J.Literal)artifactValue;
                    if (!dependencyMatcher.matches((String)groupLiteral.getValue(), (String)artifactLiteral.getValue())) {
                        return m;
                    }
                    G.MapEntry versionEntry = (G.MapEntry)depArgs.get(2);
                    Expression versionExp = versionEntry.getValue();
                    if (versionExp instanceof J.Literal && ((J.Literal)versionExp).getValue() instanceof String) {
                        String newVersion;
                        GradleProject gradleProject = (GradleProject)((JavaSourceFile)this.getCursor().firstEnclosingOrThrow(JavaSourceFile.class)).getMarkers().findFirst(GradleProject.class).orElseThrow(() -> new IllegalArgumentException("Gradle files are expected to have a GradleProject marker."));
                        J.Literal versionLiteral = (J.Literal)versionExp;
                        String version = (String)versionLiteral.getValue();
                        if (version.startsWith("$")) {
                            return m;
                        }
                        try {
                            newVersion = "classpath".equals(m.getSimpleName()) ? UpgradeDependencyVersion.this.findNewerPluginVersion((String)groupLiteral.getValue(), (String)artifactLiteral.getValue(), version, gradleProject, ctx) : UpgradeDependencyVersion.this.findNewerProjectDependencyVersion((String)groupLiteral.getValue(), (String)artifactLiteral.getValue(), version, gradleProject, ctx);
                        }
                        catch (MavenDownloadingException e) {
                            return (J.MethodInvocation)e.warn((Tree)m);
                        }
                        if (newVersion == null || version.equals(newVersion)) {
                            return m;
                        }
                        ArrayList<Object> newArgs = new ArrayList<Object>(3);
                        newArgs.add((Expression)depArgs.get(0));
                        newArgs.add((Expression)depArgs.get(1));
                        newArgs.add(versionEntry.withValue((Expression)versionLiteral.withValueSource(Objects.requireNonNull(versionLiteral.getValueSource()).replace(version, newVersion)).withValue((Object)newVersion)));
                        newArgs.addAll(depArgs.subList(3, depArgs.size()));
                        return m.withArguments(newArgs);
                    }
                    if (versionExp instanceof J.Identifier) {
                        String versionVariableName = ((J.Identifier)versionExp).getSimpleName();
                        ((HashMap)this.getCursor().dropParentUntil(p -> p instanceof SourceFile).computeMessageIfAbsent(UpgradeDependencyVersion.VERSION_VARIABLE_KEY, v -> new HashMap())).computeIfAbsent(versionVariableName, it -> new HashMap()).computeIfAbsent(new GroupArtifact((String)groupLiteral.getValue(), (String)artifactLiteral.getValue()), it -> new HashSet()).add(m.getSimpleName());
                    }
                }
                return m;
            }
        });
    }

    @Nullable
    private String findNewerPluginVersion(String groupId, String artifactId, String version, GradleProject gradleProject, ExecutionContext ctx) throws MavenDownloadingException {
        return AddDependencyVisitor.resolveDependencyVersion(groupId, artifactId, version, this.newVersion, this.versionPattern, gradleProject.getMavenPluginRepositories(), this.metadataFailures, ctx).orElse(null);
    }

    @Nullable
    private String findNewerProjectDependencyVersion(String groupId, String artifactId, String version, GradleProject gradleProject, ExecutionContext ctx) throws MavenDownloadingException {
        return AddDependencyVisitor.resolveDependencyVersion(groupId, artifactId, version, this.newVersion, this.versionPattern, gradleProject.getMavenRepositories(), this.metadataFailures, ctx).orElse(null);
    }

    static GradleProject replaceVersion(GradleProject gp, ExecutionContext ctx, GroupArtifactVersion gav, Set<String> configurations) {
        try {
            if (gav.getGroupId() == null || gav.getArtifactId() == null) {
                return gp;
            }
            HashSet<String> remainingConfigurations = new HashSet<String>(configurations);
            remainingConfigurations.remove("classpath");
            if (remainingConfigurations.isEmpty()) {
                return gp;
            }
            MavenPomDownloader mpd = new MavenPomDownloader(ctx);
            Pom pom = mpd.download(gav, null, null, gp.getMavenRepositories());
            ResolvedPom resolvedPom = pom.resolve(Collections.emptyList(), mpd, gp.getMavenRepositories(), ctx);
            ResolvedGroupArtifactVersion resolvedGav = resolvedPom.getGav();
            List transitiveDependencies = resolvedPom.resolveDependencies(Scope.Runtime, mpd, ctx);
            Map nameToConfiguration = gp.getNameToConfiguration();
            HashMap<String, GradleDependencyConfiguration> newNameToConfiguration = new HashMap<String, GradleDependencyConfiguration>(nameToConfiguration.size());
            boolean anyChanged = false;
            Iterator iterator = nameToConfiguration.values().iterator();
            while (iterator.hasNext()) {
                GradleDependencyConfiguration gdc;
                GradleDependencyConfiguration newGdc = gdc = (GradleDependencyConfiguration)iterator.next();
                newGdc = newGdc.withRequested(ListUtils.map((List)gdc.getRequested(), requested -> {
                    if (!Objects.equals(requested.getGroupId(), gav.getGroupId()) || !Objects.equals(requested.getArtifactId(), gav.getArtifactId())) {
                        return requested;
                    }
                    return requested.withGav(gav);
                }));
                anyChanged |= (newGdc = newGdc.withResolved(ListUtils.map((List)gdc.getResolved(), resolved -> {
                    if (!Objects.equals(resolved.getGroupId(), resolvedGav.getGroupId()) || !Objects.equals(resolved.getArtifactId(), resolvedGav.getArtifactId())) {
                        return resolved;
                    }
                    return resolved.withGav(resolvedGav).withDependencies(transitiveDependencies);
                }))) != gdc;
                newNameToConfiguration.put(newGdc.getName(), newGdc);
            }
            if (anyChanged) {
                gp = gp.withNameToConfiguration(newNameToConfiguration);
            }
        }
        catch (MavenDownloadingException | MavenDownloadingExceptions e) {
            return gp;
        }
        return gp;
    }

    public UpgradeDependencyVersion(String groupId, String artifactId, @Nullable String newVersion, @Nullable String versionPattern) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.newVersion = newVersion;
        this.versionPattern = versionPattern;
    }

    public MavenMetadataFailures getMetadataFailures() {
        return this.metadataFailures;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    @Nullable
    public String getNewVersion() {
        return this.newVersion;
    }

    @Nullable
    public String getVersionPattern() {
        return this.versionPattern;
    }

    @NonNull
    public String toString() {
        return "UpgradeDependencyVersion(metadataFailures=" + this.getMetadataFailures() + ", groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", newVersion=" + this.getNewVersion() + ", versionPattern=" + this.getVersionPattern() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpgradeDependencyVersion)) {
            return false;
        }
        UpgradeDependencyVersion other = (UpgradeDependencyVersion)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$artifactId = this.getArtifactId();
        String other$artifactId = other.getArtifactId();
        if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
            return false;
        }
        String this$newVersion = this.getNewVersion();
        String other$newVersion = other.getNewVersion();
        if (this$newVersion == null ? other$newVersion != null : !this$newVersion.equals(other$newVersion)) {
            return false;
        }
        String this$versionPattern = this.getVersionPattern();
        String other$versionPattern = other.getVersionPattern();
        return !(this$versionPattern == null ? other$versionPattern != null : !this$versionPattern.equals(other$versionPattern));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof UpgradeDependencyVersion;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $artifactId = this.getArtifactId();
        result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
        String $newVersion = this.getNewVersion();
        result = result * 59 + ($newVersion == null ? 43 : $newVersion.hashCode());
        String $versionPattern = this.getVersionPattern();
        result = result * 59 + ($versionPattern == null ? 43 : $versionPattern.hashCode());
        return result;
    }

    private final class UpdateVariable
    extends GroovyIsoVisitor<ExecutionContext> {
        private final Map<String, Map<GroupArtifact, Set<String>>> versionVariableNames;
        private final GradleProject gradleProject;

        public J.VariableDeclarations.NamedVariable visitVariable(J.VariableDeclarations.NamedVariable variable, ExecutionContext ctx) {
            J.VariableDeclarations.NamedVariable v = super.visitVariable(variable, (Object)ctx);
            boolean noneMatch = true;
            Map<GroupArtifact, Set<String>> gaToConfigurations = null;
            for (Map.Entry<String, Map<GroupArtifact, Set<String>>> versionVariableNameEntry : this.versionVariableNames.entrySet()) {
                if (!versionVariableNameEntry.getKey().equals(v.getSimpleName())) continue;
                noneMatch = false;
                gaToConfigurations = versionVariableNameEntry.getValue();
                break;
            }
            if (noneMatch) {
                return v;
            }
            if (!(v.getInitializer() instanceof J.Literal)) {
                return v;
            }
            J.Literal initializer = (J.Literal)v.getInitializer();
            if (initializer.getType() != JavaType.Primitive.String) {
                return v;
            }
            String version = (String)initializer.getValue();
            if (version == null) {
                return v;
            }
            try {
                for (Map.Entry<GroupArtifact, Set<String>> gaEntry : gaToConfigurations.entrySet()) {
                    GroupArtifact ga = gaEntry.getKey();
                    String newVersion = UpgradeDependencyVersion.this.findNewerProjectDependencyVersion(ga.getGroupId(), ga.getArtifactId(), version, this.gradleProject, ctx);
                    if (newVersion == null) {
                        newVersion = UpgradeDependencyVersion.this.findNewerPluginVersion(ga.getGroupId(), ga.getArtifactId(), version, this.gradleProject, ctx);
                    }
                    if (newVersion == null) {
                        return v;
                    }
                    ((HashMap)this.getCursor().dropParentUntil(p -> p instanceof SourceFile).computeMessageIfAbsent(UpgradeDependencyVersion.NEW_VERSION_KEY, m -> new HashMap())).computeIfAbsent(new GroupArtifactVersion(ga.getGroupId(), ga.getArtifactId(), newVersion), it -> new HashSet()).addAll((Collection)gaEntry.getValue());
                    J.Literal newVersionLiteral = ChangeStringLiteral.withStringValue(initializer, newVersion);
                    v = v.withInitializer((Expression)newVersionLiteral);
                }
            }
            catch (MavenDownloadingException e) {
                return (J.VariableDeclarations.NamedVariable)e.warn((Tree)v);
            }
            return v;
        }

        public J.Assignment visitAssignment(J.Assignment assignment, ExecutionContext ctx) {
            J.Assignment a = super.visitAssignment(assignment, (Object)ctx);
            if (!(a.getVariable() instanceof J.Identifier)) {
                return a;
            }
            J.Identifier identifier = (J.Identifier)a.getVariable();
            Map<GroupArtifact, Set<String>> gaToConfigurations = null;
            boolean noneMatch = true;
            for (Map.Entry<String, Map<GroupArtifact, Set<String>>> versionVariableNameEntry : this.versionVariableNames.entrySet()) {
                if (!versionVariableNameEntry.getKey().equals(identifier.getSimpleName())) continue;
                noneMatch = false;
                gaToConfigurations = versionVariableNameEntry.getValue();
                break;
            }
            if (noneMatch) {
                return a;
            }
            if (!(a.getAssignment() instanceof J.Literal)) {
                return a;
            }
            J.Literal literal = (J.Literal)a.getAssignment();
            if (literal.getType() != JavaType.Primitive.String) {
                return a;
            }
            String version = (String)literal.getValue();
            if (version == null) {
                return a;
            }
            try {
                for (Map.Entry<GroupArtifact, Set<String>> gaEntry : gaToConfigurations.entrySet()) {
                    GroupArtifact ga = gaEntry.getKey();
                    String newVersion = UpgradeDependencyVersion.this.findNewerProjectDependencyVersion(ga.getGroupId(), ga.getArtifactId(), version, this.gradleProject, ctx);
                    if (newVersion == null) {
                        newVersion = UpgradeDependencyVersion.this.findNewerPluginVersion(ga.getGroupId(), ga.getArtifactId(), version, this.gradleProject, ctx);
                    }
                    if (newVersion == null) {
                        return a;
                    }
                    ((HashMap)this.getCursor().dropParentUntil(p -> p instanceof SourceFile).computeMessageIfAbsent(UpgradeDependencyVersion.NEW_VERSION_KEY, m -> new HashMap())).computeIfAbsent(new GroupArtifactVersion(ga.getGroupId(), ga.getArtifactId(), newVersion), it -> new HashSet()).addAll((Collection)gaEntry.getValue());
                    J.Literal newVersionLiteral = ChangeStringLiteral.withStringValue(literal, newVersion);
                    a = a.withAssignment((Expression)newVersionLiteral);
                }
            }
            catch (MavenDownloadingException e) {
                return (J.Assignment)e.warn((Tree)a);
            }
            return a;
        }

        public UpdateVariable(Map<String, Map<GroupArtifact, Set<String>>> versionVariableNames, GradleProject gradleProject) {
            this.versionVariableNames = versionVariableNames;
            this.gradleProject = gradleProject;
        }

        public Map<String, Map<GroupArtifact, Set<String>>> getVersionVariableNames() {
            return this.versionVariableNames;
        }

        public GradleProject getGradleProject() {
            return this.gradleProject;
        }

        @NonNull
        public String toString() {
            return "UpgradeDependencyVersion.UpdateVariable(versionVariableNames=" + this.getVersionVariableNames() + ", gradleProject=" + this.getGradleProject() + ")";
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UpdateVariable)) {
                return false;
            }
            UpdateVariable other = (UpdateVariable)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Map<String, Map<GroupArtifact, Set<String>>> this$versionVariableNames = this.getVersionVariableNames();
            Map<String, Map<GroupArtifact, Set<String>>> other$versionVariableNames = other.getVersionVariableNames();
            if (this$versionVariableNames == null ? other$versionVariableNames != null : !((Object)this$versionVariableNames).equals(other$versionVariableNames)) {
                return false;
            }
            GradleProject this$gradleProject = this.getGradleProject();
            GradleProject other$gradleProject = other.getGradleProject();
            return !(this$gradleProject == null ? other$gradleProject != null : !this$gradleProject.equals(other$gradleProject));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof UpdateVariable;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Map<String, Map<GroupArtifact, Set<String>>> $versionVariableNames = this.getVersionVariableNames();
            result = result * 59 + ($versionVariableNames == null ? 43 : ((Object)$versionVariableNames).hashCode());
            GradleProject $gradleProject = this.getGradleProject();
            result = result * 59 + ($gradleProject == null ? 43 : $gradleProject.hashCode());
            return result;
        }
    }
}

